﻿#ifndef	AJCPREPRO_H_
#define	AJCPREPRO_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	オプションフラグ																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCPPC_FLG_NONE			0x0000		//	オプション無し
#define	AJCPPC_FLG_AUTO_SEARCH	0x0001		//	インクルードファイル自動検索フラグ
#define	AJCPPC_FLG_ONCE			0x0002		//	同一インクルードファイルを１回だけ読み出すフラグ
#define	AJCPPC_FLG_GENALL		0x0004		//	非生成部分（条件コンパイル＝偽の部分）もファイル出力する

//--------------------------------------------------------------------------------------------------------------//
//	プリプロセス文識別																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCPPC_PPK_TOKEN	(0	   )			//	プリプロセス文以外（通常のトークン）
#define	AJCPPC_PPK_DEFINE	(0x0001)			//	#define（マクロ定義識別ノード）
#define	AJCPPC_PPK_DEFCONT	(0x0002)			//	#define（マクロ定義ノード）
#define	AJCPPC_PPK_UNDEF	(0x0004)			//	#undef
#define	AJCPPC_PPK_INCLUDE	(0x0008)			//	#include
#define	AJCPPC_PPK_IFDEF	(0x0010)			//	#ifdef
#define	AJCPPC_PPK_IFNDEF	(0x0020)			//	#ifdef
#define	AJCPPC_PPK_IF		(0x0040)			//	#if
#define	AJCPPC_PPK_ELIF		(0x0080)			//	#ifndef
#define	AJCPPC_PPK_ELSE		(0x0100)			//	#else
#define	AJCPPC_PPK_ENDIF	(0x0200)			//	#endif
#define	AJCPPC_PPK_OTHERS	(0x0400)			//	その他（#pragma等）

#define	AJCPPC_PPK_ALLIF	(AJCPPC_PPK_IFDEF | AJCPPC_PPK_IFNDEF | AJCPPC_PPK_IF | AJCPPC_PPK_ELIF)
#define	AJCPPC_PPK_COND		(AJCPPC_PPK_IFDEF | AJCPPC_PPK_IFNDEF | AJCPPC_PPK_IF | AJCPPC_PPK_ELIF | AJCPPC_PPK_ELSE | AJCPPC_PPK_ENDIF)
#define	AJCPPC_PPK_ALL		(AJCPPC_PPK_COND | AJCPPC_PPK_DEFINE | AJCPPC_PPK_UNDEF)

//--------------------------------------------------------------------------------------------------------------//
//	最優先 #include パス																						//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCPP_INC_TOPPRIORITY		0x1BC4F983

//--------------------------------------------------------------------------------------------------------------//
//	プリコンパイル結果コード（AjcPpcCompileの戻り値）															//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCPPCR_OK		= 0	,				//	ＯＫ
	AJCPPCR_NOFILE		,				//	ファイル無し
	AJCPPCR_MEMERR		,				//	メモリエラー
	AJCPPCR_STOP		,				//	中止
	AJCPPCR_NOTOKEN		,				//	トークン無し
	AJCPPCR_PARAM		,				//	パラメタエラー
} AJCPPCRESULT;

//--------------------------------------------------------------------------------------------------------------//
//	通知コード																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {							//													p1					p2					p3
	AJCPPC_NTC_ANYEVT		= 0	,		//	いずれかのイベント発生							イベント識別		－					－
	AJCPPC_NTC_FILE_LNO		= 1	,		//	ファイル名，行番号通知							"ファイル名"		行＃				ネスト値（０～）
	AJCPPC_NTC_SRH_START		,		//	インクルードファイル検索開始通知				"Incファイル名"		"検索フォルダ"		－
	AJCPPC_NTC_SRH_DIR			,		//	インクルードファイル検索中のフォルダ通知		"フォルダパス"		－					－
	AJCPPC_NTC_SRH_END			,		//	インクルードファイル検索終了通知				"Incファイル名"		検索結果			－
	AJCPPC_NTC_OPTSYM			,		//	プリプロセス用オプションシンボル通知			PCAJCPPCTKNNODE		－					－
	AJCPPC_NTC_MACDEF			,		//	マクロ定義通知									PCAJCPPCTKNNODE		PCAJCPPCMACINFO		－
	AJCPPC_NTC_MACREF			,		//	マクロ参照通知									PCAJCPPCTKNNODE		PCAJCPPCMACINFO		－
	AJCPPC_NTC_OUTLOOP			,		//	トークンストリームをファイルへ出力ループ中		－					－					－
	AJCPPC_NTC_SRCTEC			,		//	ソースファイルのエンコード通知					"ファイルパス"		エンコード			ＢＯＭ
	AJCPPC_NTC_TOKEN			,		//	ソースから読み出したトークン通知				トークンコード		"トークン文字列"	－
} AJCPPCNOTIFY;
//--------------------------------------------------------------------------------------------------------------//
//	エラーコード																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {							//													p1					p2					p3
	//--- 一般エラー -----------//
	AJCPPC_ERROR_OK			= 0		,	//	正常											－					－					－
	AJCPPC_ERROR_SRC_OPEN			,	//	ソースファイルをオープンできません				"ファイルパス"		－					－
	AJCPPC_ERROR_INC_OPEN			,	//	INCLUDEファイルをオープンできません				"ファイルパス"		行＃				"Includeパス"
	AJCPPC_ERROR_NO_SYMBOL			,	//	#ifdef/#ifndefでシンボル名が指定されていません	"ファイルパス"		行＃				－
	AJCPPC_ERROR_COND_NOTCLS		,	//	条件(#if～#endif)がクローズされていません		"ファイルパス"		行＃(=1固定)		－
	AJCPPC_ERROR_COND_DEEP			,	//	条件(#if～#endif)のネストが深すぎます			"ファイルパス"		行＃				－
	AJCPPC_ERROR_NOT_IN_IF			,	//	対応する「#if / #ifdef / #ifndef」がありません	"ファイルパス"		行＃				－
	AJCPPC_ERROR_ELIF_IN_ELSE		,	//	「#else」条件中に「#elif」は記述できません		"ファイルパス"		行＃				－
	AJCPPC_ERROR_ELSE_IN_ELSE		,	//	「#else」条件中に「#else」は記述できません		"ファイルパス"		行＃				－
	//--- defined --------------//
	AJCPPC_DEFERR_INVALID	= 1000	,	//	definedの構文誤り								"ファイルパス"		行＃				－
	AJCPPC_DEFERR_NEED_LP			,	//	defined'の後に左括弧 '(' が必要です				"ファイルパス"		行＃				－
	AJCPPC_DEFERR_NEED_SYMBOL		,	//	defined'でシンボルが指定されていません			"ファイルパス"		行＃				－
	AJCPPC_DEFERR_NEED_RP			,	//	シンボルの次に右括弧 ')' が必要です				"ファイルパス"		行＃				"シンボル"
	//--- MACRO ----------------//
	AJCPPC_MACERR_NEED_LP	= 2000	,	//	マクロ名の後に左括弧が必要です					"ファイルパス"		行＃				"マクロ名"
	AJCPPC_MACERR_NEED_RP			,	//	仮引数の後に右括弧が必要です					"ファイルパス"		行＃				"仮引数"
	AJCPPC_MACERR_NEED_RP_C			,	//	仮引数の後に右括弧かカンマが必要です			"ファイルパス"		行＃				"仮引数"
	AJCPPC_MACERR_MULTDEF			,	//	マクロ二重定義									"ファイルパス"		行＃				"マクロ名"
	AJCPPC_MACERR_INV_NAME			,	//	不正なマクロ名です								"ファイルパス"		行＃				－
	AJCPPC_MACERR_NO_NAME			,	//	マクロ名がありません							"ファイルパス"		行＃				－
	AJCPPC_MACERR_NEST_OVER			,	//	マクロ展開ネストオーバー						"ファイルパス"		行＃				"マクロ名"
	AJCPPC_MACERR_ARG_LACK			,	//	マクロの引数が少なすぎる						"ファイルパス"		行＃				"マクロ名"
	AJCPPC_MACERR_ARG_OVER			,	//	マクロの引数が多すぎる							"ファイルパス"		行＃				"マクロ名"
	//--- INCLUDE --------------//
	AJCPPC_INCERR_NO_FILE	= 3000	,	//	Include ファイル名が指定されていません			"ファイルパス"		行＃				－
	AJCPPC_INCERR_INV_FILE			,	//	Include ファイルの記述が不正です				"ファイルパス"		行＃				－
	AJCPPC_INCERR_NOTCLS			,	//	Include ファイル名の後に '>' がありません		"ファイルパス"		行＃				－
	AJCPPC_INCERR_NEST_OVER			,	//	Include ファイルのネストオーバー				"ファイルパス"		行＃				－
	AJCPPC_INCERR_NOT_FOUND			,	//	Include ファイルが見つかりません				"ファイルパス"		行＃				"Includeファイル"
	//--- 数式評価エラー -------//
	AJCPPC_SCLERR_INVSYL	= 5000	,	//	無効な語句										"ファイルパス"		行＃				"語句"
	AJCPPC_SCLERR_DIVZERO			,	//	ゼロ除算										"ファイルパス"		行＃				－
	AJCPPC_SCLERR_NOTCLS			,	//	括弧が閉じられていない							"ファイルパス"		行＃				－
	AJCPPC_SCLERR_EXPRESSION		,	//	不当な数式表現									"ファイルパス"		行＃				"不正な語句"
	AJCPPC_SCLERR_EOL				,	//	数式表現が途中で終了している					"ファイルパス"		行＃				－
	AJCPPC_SCLERR_OVERNEST			,	//	数式表現のネストオーバー						"ファイルパス"		行＃				－
	//--- メモリ割り当て失敗 ---//
	AJCPPC_ERROR_MEMALLOC	= 9999		//	メモリ割り当て失敗								－					－					－
} AJCPPCERROR;

//--------------------------------------------------------------------------------------------------------------//
//	#unclude種別																								//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCPPC_INCF_NO		0x00		//			#include外（トップのソース）
#define		AJCPPC_INCF_GBL		0x01		//	Bit0 -	#include <・・・>
#define		AJCPPC_INCF_LCL		0x02		//	Bit1 -	#include "・・・"

#define		AJCPPC_INCF_DUP		0x08		//	Bit7 -	重複インクルード

//--------------------------------------------------------------------------------------------------------------//
//	トークンノード																								//
//--------------------------------------------------------------------------------------------------------------//
//--- ppIf ---------------------------------------------------------------//
#define	AJCPPIF_UNCOND	0xFFFC		//	上位の条件コンパイルが「偽」条件中
#define	AJCPPIF_NO_GEN	0xFFFE		//	非生成部分のノード

typedef struct _AJCPPCTKNNODE {
	struct _AJCPPCTKNNODE *pNxt;			//	次ノードポインタ
	UI			seq;						//	ノード順序番号
	BCP			pFile;						//	ファイルパス名へのポインタ
	BCP			pSyl;						//	語句文字列ポインタ
	UW			tkn;						//	トークンコード
	UW			kndPP;						//	プリプロセス文識別(0:プリプロ以外，AJCPPC_PPK_XXXXX)
	UI			lno;						//	行番号
	UW			pos;						//	トークンの位置（タブステップ＝４）
	UW			ppIf;						//	条件コンパイル情報 - #if, #elif, #ifdef, #ifndef, #else時のみ設定
											//							0		 : FALSE（条件コンパイル結果が「偽」)
											//							1		 : TRUE （条件コンパイル結果が「真」)
											//							0xFFFC	 : 上位の「偽」条件中
											//					   - #endif時のみ設定
											//							1～65530 : #if/#ifdef/#ifndef までの行番号相対値
											//							0		 : #if/#ifdef/#ifndef ～ #endif が65530行を超える場合は0,
											//					   - 共通設定
											//							0xFFFE	 : 非生成部分
	UB			flg;						//	語句のフラグ情報(AJCTKF_XXXXX)
	UB			inst;						//	#includeのネストレベル
	UB			incf;						//	#includeフラグ（AJCPPC_INCF_XXXXX)
	UB			mexp;						//	マクロ展開ネストレベル（０：非マクロ展開コード，１～：マクロ展開コード）
} AJCPPCTKNNODE, *PAJCPPCTKNNODE;
typedef const AJCPPCTKNNODE *PCAJCPPCTKNNODE;

//--------------------------------------------------------------------------------------------------------------//
//	マクロ情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BOOL			fWithArg;				//	引数付マクロ・フラグ（＝TRUE）
	BCP				pMacName;				//	マクロ名のＡＶＬキー（マクロ名文字列へのポインタ）
	PAJCPPCTKNNODE	pTknName;				//	マクロ名・トークンノードへのポインタ
	PAJCPPCTKNNODE	pTknBody;				//	マクロボディ・トークンノードへのポインタ
	UI				pos;					//	先頭「#」の桁位置
	BOOL			fVaArgs;				//	可変個引数マクロフラグ
	UI				nTmpArg;				//	仮引数の個数
	HAJCVQUE		hVQueArg;				//	マクロ仮引数名リスト
} AJCPPCMACINFO, *PAJCPPCMACINFO;
typedef const AJCPPCMACINFO *PCAJCPPCMACINFO;

//--------------------------------------------------------------------------------------------------------------//
//	#if ～ ネスト制御テーブル																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCPPC_MAX_IF_NEST		32

//----- プリプロセス(#if～#endif)種別 --------------------------------------------------------------------------//
typedef enum {
	AJCPPC_IFK_NONE			,				//	オープンコード（#if ～ #endif 外）
	AJCPPC_IFK_IFDEF		,				//	#ifdef
	AJCPPC_IFK_IFNDEF		,				//	#ifndef
	AJCPPC_IFK_IF			,				//	#if
	AJCPPC_IFK_ELIF			,				//	#elif
	AJCPPC_IFK_ELSE							//	#else
} AJCPPCIFKIND;

//----- プリプロセス(#if～#endif)処理状態 ----------------------------------------------------------------------//
typedef enum {
	AJCPPC_IFA_GEN_NORMAL	= 0x01	,		//	通常の生成状態（#if ～ #endif 外）
	AJCPPC_IFA_GEN_IN_IF	= 0x02	,		//	ＩＦ（真条件）による生成状態
	AJCPPC_IFA_GEN_IN_ELSE	= 0x04	,		//	ＥＬＳＥ条件による生成状態
	AJCPPC_IFA_SKIP_BY_IF	= 0x08	,		//	ＩＦ（偽条件）によるスキップ状態
	AJCPPC_IFA_SKIP_ENDIF	= 0x10	,		//	ＥＮＤＩＦまでスキップ状態
	AJCPPC_IFA_SKIP_ALL		= 0x20			//	無条件スキップ状態（上位の条件が偽）
} AJCPPCIFACT;

#define	AJCPPC_IFA_GEN		(AJCPPC_IFA_GEN_NORMAL | AJCPPC_IFA_GEN_IN_IF  | AJCPPC_IFA_GEN_IN_ELSE)
#define	AJCPPC_IFA_SKIP		(AJCPPC_IFA_SKIP_BY_IF | AJCPPC_IFA_SKIP_ENDIF | AJCPPC_IFA_SKIP_ALL   )

//----- テーブルエントリ ---------------------------------------------------------------------------------------//
typedef struct {
	AJCPPCIFKIND	knd;				//	プリプロセス(#if～#endif)種別
	AJCPPCIFACT		act;				//	プリプロセス(#if～#endif)処理状態
	UI				lno;				//	対応する #if, #ifdef, #ifndef の行番号
} AJCPPCIFTBL, *PAJCPPCIFTBL;

//--------------------------------------------------------------------------------------------------------------//
//	#includeネスト制御テーブル																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCPPC_MAX_INC_NEST		32

typedef struct {
	HAJCTK		hCtk;								//	字句分解インスタンスハンドル
	HAJCFILE	fh;									//	インクルードファイル・ハンドル
	BCP			pPath;								//	インクルードファイル・パス名
	BC			file[_MAX_FNAME + _MAX_EXT + 1];	//	インクルードファイル名
	UI			lno;								//	行番号
	int			IxIF;								//	#if～#endif ネストインデクス
	AJCPPCIFTBL	TblIF[AJCPPC_MAX_IF_NEST];			//	#if～#endif ネストテーブル
} AJCPPCINCNEST, *PAJCPPCINCNEST;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct _AJCPPC {
	//----- インスタンスＩＤ -----------------------------------------------------------------------------------//
	UI					InstID;
	//----- コンパイルオブジェクト・プール ---------------------------------------------------------------------//
	HAJCAVL				hAvlObj;
	//----- 広域ワーク -----------------------------------------------------------------------------------------//
	UB					BasePath[MAX_PATH];				//	#include検索時のベースパス
	PAJCLBXITEMA		pIncArr;						//	#include検索パス配列のアドレス
	PAJCLBXITEMA		pOptArr;						//	オプションシンボル配列のアドレス
	//----- コールバック ---------------------------------------------------------------------------------------//
	UX					cbp;												//	コールバックパラメタ
	VO (CALLBACK *cbNtc)(AJCPPCNOTIFY ntc, UX p1, UX p2, UX p3, UX cbp);	//	イベント通知
	VO (CALLBACK *cbErr)(AJCPPCERROR  err, UX p1, UX p2, UX p3, UX cbp);	//	エラー通知
	//----- Work for AjcPpAvlNStr ------------------------------------------------------------------------------//
	HAJCAVL				hAvlNStr;						//	文字列プール（大小区別なし）
	//----- Work for AjcPpAvlIStr ------------------------------------------------------------------------------//
	HAJCAVL				hAvlIStr;						//	文字列プール（大小区別あり）
	//----- Work for AjcPpMacro --------------------------------------------------------------------------------//
	HAJCAVL				hAvlMac;						//	マクロ定義トークンストリーム・プール
	//----- Work for AjcPpAvlInc -------------------------------------------------------------------------------//
	HAJCAVL				hAvlInc;						//	多重インクルードチェック用ＡＶＬハンドル
	//----- Work for AjcPpFormula ------------------------------------------------------------------------------//
	PAJCPPCTKNNODE		pFmlCur;						//	現在の語句情報ポインタ
	UI					FmlOpCode;						//	語句種別
	UI					FmlNestCnt;						//	ネストカウンタ
	AJCPPCERROR			FmlSclErr;						//	エラーコード
	int					FmlValue;						//	数値
	AJCPPCTKNNODE		FmlEolNode;						//	ダミーの行末ノード
	BOOL				nstDmyRgtInLAndLOr;				//	「&&」or「||」の右側ダミー演算中を示すフラグ（0:ダミー演算以外，１～ダミー演算中）
	//----- Work for AjcPpMain ---------------------------------------------------------------------------------//
	UI					OptFlag;						//	オプションフラグ（AJCPPC_FLG_XXXXX）

	int					incf;							//	インクルードフラグ(AJCPPC_INCF_XXXXX)
	int					IxInc;
	AJCPPCINCNEST		TblInc[AJCPPC_MAX_INC_NEST];

	BCP					pOptSymText;					//	オプションシンボルへのポインタ
	PAJCPPCTKNNODE		pTknTop;						//	先頭トークンノードアドレス
	PAJCPPCTKNNODE		pTknLas;						//	最終トークンノードアドレス
	PAJCPPCTKNNODE		*ppMacBfr;						//	マクロ展開済トークンノードポインタのアドレス

	PAJCPPCTKNNODE		pNoGTop;						//	先頭トークンノードアドレス（非生成部分のトークン）
	PAJCPPCTKNNODE		pNoGLas;						//	最終トークンノードアドレス（非生成部分のトークン）

	BOOL				fMemErr;						//	メモリエラーフラグ
	BOOL				fStop;							//	コンパイル中止フラグ

	BCP					pSrhPath;						//	インクルードファイル検索パス
	BOOL				rcSrhInc;						//	インクルードファイル検索結果

	//	トークンストリームのファイル出力用ワーク
	HAJCFILE			fhTsoOut;						//	出力ファイルハンドル
	BOOL				fTsoTop;						//	行頭フラグ
	UI					TsoNst0Lno;						//	ネスト０の行番号（＝ソースファイルの行番号）
	UI					TsoMaxFName;					//	ファイル名の最大長


	EAJCTEC				InpTec;							//	ソースファイルのテキストエンコード
	EAJCTEC				OutTec;							//	出力ファイル  のテキストエンコード
	BOOL				fBOM;							//	出力ファイル  のＢＯＭ出力フラグ

	EAJCTEC				InpActTec;						//	ソースファイルの実際のエンコード
	BOOL				InpActBOM;						//	ソースファイルのＢＯＭ存在フラグ

	//	エラーメッセージテキスト
	BC					ErrMsgText[1024];

	//----- MSILサポート用 -------------------------------------------------------------------------------------//
	WC				ErrMsgTextW[1024];
	WC				SvIncName[MAX_PATH];
	HAJCSPL			hSplMSIL;													//	ワイド文字列用文字列プール

	VO (CALLBACK *cbNtcAnyEvt	)(AJCPPCNOTIFY ntc);							//	いずれかのイベント発生通知
	VO (CALLBACK *cbNtcFileLno	)(C_WCP pFileName, UI lno, UI nest);			//	ファイル名，行番号通知
	VO (CALLBACK *cbNtcSrhStart	)(C_WCP pIncName , C_WCP pSrhPath);				//	インクルードファイル検索開始通知
	VO (CALLBACK *cbNtcSrhDir	)(C_WCP pIncName , C_WCP pDirPath);				//	インクルードファイル検索中のフォルダ通知
	VO (CALLBACK *cbNtcSrhEnd	)(C_WCP pIncName , BOOL fFind);					//	インクルードファイル検索終了通知
	VO (CALLBACK *cbNtcOptSym	)(C_WCP pFilePath, UI lno, C_WCP pSyl);			//	プリプロセス用オプションシンボル通知
	VO (CALLBACK *cbNtcMacDef	)(C_WCP pFilePath, UI lno, C_WCP pMac);			//	マクロ定義通知
	VO (CALLBACK *cbNtcMacRef	)(C_WCP pFilePath, UI lno, C_WCP pMac);			//	マクロ参照通知
	VO (CALLBACK *cbNtcOutput	)(VO);											//	トークンストリームをファイルへ出力中通知
	VO (CALLBACK *cbNtcSrcTec	)(C_WCP pFilePath, EAJCTEC tec, BOOL bom);		//	ソースファイルのエンコード通知
	VO (CALLBACK *cbNtcError)(AJCPPCERROR err, C_WCP p1, UI p2, C_WCP p3);		//	エラー通知

} AJCPPC, *PAJCPPC, *HAJCPPC;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCPPC		WINAPI	AjcPpcCreate(	C_BCP 		 pBasePath,
												PAJCLBXITEMA pIncPath,
												PAJCLBXITEMA pOptSym,
												UX			 cbp,
												VO (CALLBACK *cbNtc)(AJCPPCNOTIFY ntc, UX p1, UX p2, UX p3, UX cbp),
												VO (CALLBACK *cbErr)(AJCPPCERROR  err, UX p1, UX p2, UX p3, UX cbp));

AJCEXPORT	BOOL			WINAPI	AjcPpcDelete			(HAJCPPC hPpc);
AJCEXPORT	BOOL			WINAPI	AjcPpcSetOption			(HAJCPPC hPpc, UI opt);
AJCEXPORT	UI				WINAPI	AjcPpcGetOption			(HAJCPPC hPpc);
AJCEXPORT	AJCPPCRESULT	WINAPI	AjcPpcCompile			(HAJCPPC hPpc, C_BCP pSrcPath);
AJCEXPORT	PAJCPPCTKNNODE	WINAPI	AjcPpcGetObject			(HAJCPPC hPpc, PAJCPPCTKNNODE *ppNoGen);
AJCEXPORT	BOOL			WINAPI	AjcPpcReleaseObject		(HAJCPPC hPpc);
AJCEXPORT	UI				WINAPI	AjcPpcEnumMacro			(HAJCPPC hPpc, UX cbp, BOOL (CALLBACK *cbNtcMacName)(PCAJCPPCMACINFO pMacInfo, UX cbp));
AJCEXPORT	BOOL			WINAPI	AjcPpcGetMacroInfo		(HAJCPPC hPpc, C_BCP pMacName, PAJCPPCMACINFO pMacInfo);
AJCEXPORT	BOOL			WINAPI	AjcPpcStop				(HAJCPPC hPpc);
AJCEXPORT	BOOL			WINAPI	AjcPpcTokenStreamToFile	(HAJCPPC hPpc, C_BCP pOut, BOOL fExpInc, UI CommOutOfkndPP);

AJCEXPORT	BOOL			WINAPI	AjcPpcSetTecAtTokenStreamToFile(HAJCPPC hPpc, EAJCTEC tec, BOOL fBOM);
AJCEXPORT	BOOL			WINAPI	AjcPpcSetTextEncode		(HAJCPPC hPpc, EAJCTEC	tec);
AJCEXPORT	BOOL			WINAPI	AjcPpcGetTextEncode		(HAJCPPC hPpc, PEAJCTEC pTec, BOOL *pfBOM);

AJCEXPORT	C_BCP			WINAPI	AjcPpcGetErrMsgText(AJCPPCERROR err, UX p1, UX p2, UX p3);


//----- MSILサポート用 -----------------------------------------------------------------------------------------//
AJCEXPORT	HAJCPPC			WINAPI	AjcPpcCreateForMSIL				(VO);
AJCEXPORT	BOOL			WINAPI	AjcPpcDeleteForMSIL				(HAJCPPC hPpc);
AJCEXPORT	AJCPPCRESULT	WINAPI	AjcPpcCompileForMSIL			(HAJCPPC hPpc, C_WCP pSrcPath);
AJCEXPORT	BOOL			WINAPI	AjcPpcTokenStreamToFileForMSIL	(HAJCPPC hPpc, C_WCP pOut, BOOL fExpInc, UI CommOutOfkndPP);
AJCEXPORT	BOOL			WINAPI	AjcPpcSetBasePath				(HAJCPPC hPpc, C_WCP pBasePath);

//	インクルードパス設定
AJCEXPORT	BOOL		WINAPI	AjcPpcIncPathReset		(HAJCPPC hPpc);
AJCEXPORT	BOOL		WINAPI	AjcPpcIncPathCreate		(HAJCPPC hPpc, UI n);
AJCEXPORT	BOOL		WINAPI	AjcPpcIncPathSet		(HAJCPPC hPpc, UI ix, C_WCP pIncPath);

//	オプションシンボル設定
AJCEXPORT	BOOL		WINAPI	AjcPpcOptSymReset		(HAJCPPC hPpc);
AJCEXPORT	BOOL		WINAPI	AjcPpcOptSymCreate		(HAJCPPC hPpc, UI n);
AJCEXPORT	BOOL		WINAPI	AjcPpcOptSymSet			(HAJCPPC hPpc, UI ix, C_WCP pOptSym);

//	コールバック設定
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcAnyEvt	(HAJCPPC hPpc, VO (CALLBACK *cbNtcAnyEvt  )(AJCPPCNOTIFY ntc						));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcFileLno	(HAJCPPC hPpc, VO (CALLBACK *cbNtcFileLno )(C_WCP pFileName, UI lno		 , UI nest	));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcSrhStart	(HAJCPPC hPpc, VO (CALLBACK *cbNtcSrhStart)(C_WCP pIncName , C_WCP pSrhPath		 	));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcSrhDir	(HAJCPPC hPpc, VO (CALLBACK *cbNtcSrhDir  )(C_WCP pIncName , C_WCP pSrhDir		 	));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcSrhEnd	(HAJCPPC hPpc, VO (CALLBACK *cbNtcSrhEnd  )(C_WCP pIncName , BOOL  fFind			));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcOptSym	(HAJCPPC hPpc, VO (CALLBACK *cbNtcOptSym  )(C_WCP pFilePath, UI lno		, C_WCP pSyl));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcMacDef	(HAJCPPC hPpc, VO (CALLBACK *cbNtcMacDef  )(C_WCP pFilePath, UI lno		, C_WCP pMac));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcMacRef	(HAJCPPC hPpc, VO (CALLBACK *cbNtcMacRef  )(C_WCP pFilePath, UI lno		, C_WCP pMac));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcOutput	(HAJCPPC hPpc, VO (CALLBACK *cbNtcOutPut  )(VO		 								));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcSrcTec	(HAJCPPC hPpc, VO (CALLBACK *cbNtcSrcTec  )(C_WCP pFilePath, EAJCTEC tec, BOOL fBOM ));
AJCEXPORT	VO			WINAPI	AjcPpcSetCbNtcError		(HAJCPPC hPpc, VO (CALLBACK *cbErrMSIL)(AJCPPCERROR err, C_WCP p1, UI p2, C_WCP p3	));

//	エラーメッセージテキスト取得
AJCEXPORT	VO	WINAPI	AjcPpcGetErrMsgTextForMSIL(WCP pBuf, UI lBuf);


/****************************************************************************************************************/
#endif
