﻿#ifndef	AJCCTRLPRINTER_H_
#define	AJCCTRLPRINTER_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcPrnCreate		AjcPrnCreateW
	#define		AjcPrnGetInfo		AjcPrnGetInfoW
#else
	#define		AjcPrnCreate		AjcPrnCreateA
	#define		AjcPrnGetInfo		AjcPrnGetInfoA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	用紙の向き																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCPRN_ORIENT_UNKOWN	= 0 					,	//	不定
	AJCPRN_ORIENT_PORTRAIT	= DMORIENT_PORTRAIT		,	//	縦
	AJCPRN_ORIENT_LANDSCAPE	= DMORIENT_LANDSCAPE	,	//	横
} AJCPRN_ORIENT;

//--------------------------------------------------------------------------------------------------------------//
//	余白サイズ																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int		l;		//	左端余白
	int		r;		//	右端余白
	int		u;		//	上端余白
	int		d;		//	下端余白
} AJCPRN_MARGIN, *PAJCPRN_MARGIN;
typedef const AJCPRN_MARGIN *PCAJCPRN_MARGIN;

//--------------------------------------------------------------------------------------------------------------//
//	余白情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	AJCPRN_MARGIN	mm, mmMin, mmMax;
	AJCPRN_MARGIN	px, pxMin, pxMax;
} AJCPRN_MRGINFO, *PAJCPRN_MRGINFO;
typedef const AJCPRN_MRGINFO *PCAJCPRN_MRGINFO;

//--------------------------------------------------------------------------------------------------------------//
//	プリンタ情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	//----- プリンタ情報 -----------//
	int					x , y;					//	余白を除いた描画左上位置
	int					cx, cy;					//	余白を除いた描画ピクセル数
	AJCPRN_MRGINFO		MrgIf;					//	余白情報
	//----- プリンタ諸元 -----------//
	int					cxFull, cyFull;			//	用紙サイズのピクセル数
	int					cxPage, cyPage;			//	印字可能領域のピクセル数
	int					OffsetX;				//	左右印刷不能域のピクセル数
	int					OffsetY;				//	上下印刷不能域のピクセル数
	int					FactorX;				//	プリンタの水平軸の倍率
	int					FactorY;				//	プリンタの垂直軸の倍率
	int					LogPixelsX;				//	１インチ当たりの横ピクセル数
	int					LogPixelsY;				//	１インチ当たりの縦ピクセル数
	AJCPRN_ORIENT		Orientation;			//	AJCPRN_ORIENT_PORTRAIT(縦) / AJCPRN_ORIENT_LANDSCAPE(横)
} AJCPRN_INFO, *PAJCPRN_INFO;
typedef const AJCPRN_INFO *PCAJCPRN_INFO;

//--------------------------------------------------------------------------------------------------------------//
//	ページ情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	AJCPRN_MARGIN	mmMrg;
	AJCPRN_ORIENT	orientation;
}  AJCPRN_PGINFO, *PAJCPRN_PGINFO;
typedef const AJCPRN_PGINFO *PCAJCPRN_PGINFO;

//--------------------------------------------------------------------------------------------------------------//
//	印刷オプション																								//
//--------------------------------------------------------------------------------------------------------------//
//	オプションフラグ
#define	AJCPRNF_OUTPUTTOFILE				0x0100000000ULL				  // ファイルへ出力がチェックされた
#define	AJCPRNF_DISABLECOPIES				0x0200000000ULL				  // 「部数」「部単位で印刷」を無効化する
#define	AJCPRNF_DISABLEPAGEINFO				0x0400000000ULL				  // 「ページ範囲」を無効にする

#define	AJCPRNF_ALLPAGES					PD_ALLPAGES 				  // [すべて]ラジオ ボタンが最初に選択されていることを示す既定のフラグ
#define	AJCPRNF_SELECTION					PD_SELECTION				  // このフラグを設定すると、「選択」ラジオボタンが選択されます。
#define	AJCPRNF_PAGENUMS					PD_PAGENUMS 				  // このフラグを設定すると、[ページ指定]ラジオ ボタンが選択されます。
#define	AJCPRNF_NOSELECTION 				PD_NOSELECTION				  // [選択した部分] ラジオ ボタンを無効にします。
#define	AJCPRNF_NOPAGENUMS					PD_NOPAGENUMS				  // [ページ指定]ラジオ ボタンと関連付けられているエディット コントロールを無効にします。
#define	AJCPRNF_COLLATE 					PD_COLLATE					  // このフラグを設定すると、[照合] チェック ボックスがオンになります。
#define	AJCPRNF_PRINTTOFILE 				PD_PRINTTOFILE				  // このフラグを設定すると、[ファイルへ出力] チェック ボックスがオンになります。
#define	AJCPRNF_NOWARNING					PD_NOWARNING				  // 既定のプリンタがない場合に警告メッセージが表示されないようにします。
#define	AJCPRNF_USEDEVMODECOPIES			PD_USEDEVMODECOPIES 		  // このフラグは、アプリケーションが複数のコピーと照合順序をサポートするかどうかを示します。-
#define	AJCPRNF_USEDEVMODECOPIESANDCOLLATE	PD_USEDEVMODECOPIESANDCOLLATE // アプリケーションが複数のコピーと照合順序をサポートしていないことを示すには、入力にこのフラグを設定します。
#define	AJCPRNF_DISABLEPRINTTOFILE			PD_DISABLEPRINTTOFILE		  // [ファイルへ出力] チェック ボックスを無効にします。
#define	AJCPRNF_HIDEPRINTTOFILE 			PD_HIDEPRINTTOFILE			  // [ファイルへ出力] チェック ボックスを非表示にします。
#define	AJCPRNF_NONETWORKBUTTON 			PD_NONETWORKBUTTON			  // [ネットワーク] ボタンを非表示または無効にします。

#define	AJCPRNF_CURRENTPAGE 				PD_CURRENTPAGE				  // [現在のページ]を選択状態にします
#define	AJCPRNF_NOCURRENTPAGE				PD_NOCURRENTPAGE			  // [現在のページ]を無効状態にします

//	戻り値
//#define	AJCPRNRC_CANCEL 	PD_RESULT_CANCEL		//	0:キャンセルボタン押下
//#define	AJCPRNRC_PRINT		PD_RESULT_PRINT			//	1:印刷ボタン押下
//#define	AJCPRNRC_APPLY		PD_RESULT_APPLY			//	2:適用ボタン押下

#define	AJCPRNMAX_PGRANGES	2				//	最大ページレンジ数

typedef struct {
	ULL		Flags;							//	オプションフラグ
	UI		nCopies;						//	コピー部数
	UI		nFromPage;						//	開始ページ
	UI		nToPage;						//	終了ページ
	UI		nMinPage;						//	ページ範囲の最小値
	UI		nMaxPage;						//	ページ範囲の最大値
} AJCPRN_OPT, *PAJCPRN_OPT;
typedef const AJCPRN_OPT *PCAJCPRN_OPT;


//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCPRN_MAX_PRNNAME	1024

typedef struct {
	BOOL			fUnicode;							//	ワイド文字フラグ
	BOOL			fPrintBusy;							//	印刷中フラグ
	BOOL			fpi;								//	プリンタ情報設定済みフラグ
	AJCPRN_INFO		pi;									//	プリンタ情報
	PRINTDLG		pdg;								//	印刷ダイアログ構造体
	AJCDIBINFO		dib;								//	ＤＩＢセクション情報
	BC				NameA[AJCPRN_MAX_PRNNAME];			//	プリンタ名（バイト文字）
	WC				NameW[AJCPRN_MAX_PRNNAME];			//	プリンタ名（ワイド文字）
	UX				cbp;								//	コールバックパラメタ
	BOOL (CALLBACK *cbQueryPage)(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo, UX cbp);			//	ページ印刷開始通知
	BOOL (CALLBACK *cbDrawPrn  )(HDC hdc, PCAJCPRN_INFO pPrnInfo, UX cbp);							//	プリンタＤＣによる描画
	BOOL (CALLBACK *cbDrawDib  )(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp);	//	ＤＩＢセクションによる描画
} AJCPRN, *HAJCPRN;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCPRN			WINAPI	AjcPrnCreateA	(VO);
AJCEXPORT	HAJCPRN			WINAPI	AjcPrnCreateW	(VO);

AJCEXPORT	BOOL			WINAPI	AjcPrnSetMargin	(HAJCPRN hPrn, PAJCPRN_MARGIN pmmMargin);

AJCEXPORT	BOOL			WINAPI	AjcPrnSetCallbackParam(HAJCPRN hPrn, UX cbp);
AJCEXPORT	BOOL			WINAPI	AjcPrnSetCallbackQueryPage(HAJCPRN hPrn, BOOL (CALLBACK *cbQueryPage	  )(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPgInfo, UX cbp));
AJCEXPORT	BOOL			WINAPI	AjcPrnSetCallbackByDibSect(HAJCPRN hPrn, BOOL (CALLBACK *cbDrawByDibSectDC)(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp));
AJCEXPORT	BOOL			WINAPI	AjcPrnSetCallbackByPrinter(HAJCPRN hPrn, BOOL (CALLBACK *cbDrawByPrinterDC)(HDC hdc, PCAJCPRN_INFO pPrnInfo, UX cbp));

AJCEXPORT	VO				WINAPI	AjcPrnDelete	(HAJCPRN hPrn);
AJCEXPORT	BOOL			WINAPI	AjcPrnSelectDlg	(HAJCPRN hPrn, PAJCPRN_INFO pInfo, UI		   Flag, HWND hWndOwner);
AJCEXPORT	BOOL			WINAPI	AjcPrnPrintDlg	(HAJCPRN hPrn, PAJCPRN_INFO pInfo, PAJCPRN_OPT pOpt, HWND hWndOwner);
AJCEXPORT	int				WINAPI	AjcPrnStart		(HAJCPRN hPrn, BOOL fOutputToFile);

AJCEXPORT	C_BCP			WINAPI	AjcPrnGetInfoA	(HAJCPRN hPrn, PAJCPRN_INFO pBuf);
AJCEXPORT	C_WCP			WINAPI	AjcPrnGetInfoW	(HAJCPRN hPrn, PAJCPRN_INFO pBuf);


/****************************************************************************************************************/
#endif
