﻿#ifndef	AJCPROCESSMEM_H_
#define	AJCPROCESSMEM_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcPmSendMessage	AjcPmSendMessageW
	#define	AjcPmPostMessage	AjcPmPostMessageW
#else
	#define	AjcPmSendMessage	AjcPmSendMessageA
	#define	AjcPmPostMessage	AjcPmPostMessageA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	マクロ																										//
//--------------------------------------------------------------------------------------------------------------//
//	他プロセスへメッセージ送信時のデータ書き込み指定（wParam）
#define		AJCPM_WPARAM_W(HPM, PTR, LEN)	AjcPmSetWpForWrite(HPM, LEN, (VOP)PTR)

//	他プロセスへメッセージ送信時のデータ書き込み指定（lParam）
#define		AJCPM_LPARAM_W(HPM, PTR, LEN)	AjcPmSetLpForWrite(HPM, LEN, (VOP)PTR)

//	他プロセスへメッセージ送信時のデータ読み出し指定(wParam)
#define		AJCPM_WPARAM_R(HPM, PTR, LEN)	AjcPmSetWpForRead(HPM, LEN, (VOP)PTR)

//	他プロセスへメッセージ送信時のデータ読み出し指定(lParam)
#define		AJCPM_LPARAM_R(HPM, PTR, LEN)	AjcPmSetLpForRead(HPM, LEN, (VOP)PTR)

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCPMRW_NONE	= 0,
	AJCPMRW_W		= 1,
	AJCPMRW_R		= 2,
} AJCPMRWFLG;

//	メッセージ送信後の読み書き情報
typedef	struct {
	AJCPMRWFLG	flg;		//	AJCPMRW_W：書き込み，AJCPMRW_R:読み出し，AJCPMRW_NONE:読み書き無し
	UX			loc;		//	プロセス内メモリ位置
	UX			len;		//	読み出すバイト数
	VOP			pMem;		//	書き込みデータアドレス／読み出したデータを格納するバッファアドレス
} AJCPMRW;

//	インスタンスワーク
typedef struct {
	UI		InstID;			//	インスタンスＩＤ
	UL		ProcessID;		//	プロセスＩＤ
	UL		ThreadID;		//	スレッドＩＤ
	HANDLE	hProcess;		//	プロセスハンドル
	union {					//	他プロセス内メモリ位置
		VOP		pVoid;
		UBP		pByte;
		LPARAM	lParam;
	} u;
	AJCPMRW		wp;			//	他プロセスへメッセージ送信時のメモリＲ／Ｗ情報(wParam)
	AJCPMRW		lp;			//	他プロセスへメッセージ送信時のメモリＲ／Ｗ情報(lParam)
} AJCPM, *HAJCPM;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCPM	WINAPI	AjcPmCreateByWnd(HWND hwnd, UX size);
AJCEXPORT	HAJCPM	WINAPI	AjcPmCreateByPid(UL pid, UX size);
AJCEXPORT	BOOL	WINAPI	AjcPmDelete (HAJCPM pW);
AJCEXPORT	BOOL	WINAPI	AjcPmWrite	(HAJCPM pW, UX loc, C_VOP pSrc, UX len);
AJCEXPORT	BOOL	WINAPI	AjcPmRead	(HAJCPM pW, UX loc, VOP	pBuf, UX len);
AJCEXPORT	UX		WINAPI	AjcPmGetAddr(HAJCPM pW, UX loc);

AJCEXPORT	LRESULT	WINAPI	AjcPmSendMessageA(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);
AJCEXPORT	LRESULT	WINAPI	AjcPmSendMessageW(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);

AJCEXPORT	LRESULT	WINAPI	AjcPmPostMessageA(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);
AJCEXPORT	LRESULT	WINAPI	AjcPmPostMessageW(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);

AJCEXPORT	WPARAM	WINAPI	AjcPmSetWpForWrite(HAJCPM pW, UX len, VOP pMem);
AJCEXPORT	LPARAM	WINAPI	AjcPmSetLpForWrite(HAJCPM pW, UX len, VOP pMem);
AJCEXPORT	WPARAM	WINAPI	AjcPmSetWpForRead (HAJCPM pW, UX len, VOP pMem);
AJCEXPORT	LPARAM	WINAPI	AjcPmSetLpForRead (HAJCPM pW, UX len, VOP pMem);

/****************************************************************************************************************/
#endif
