﻿#ifndef	AJCPROFILE_H_
#define	AJCPROFILE_H_
/****************************************************************************************************************/
//
//	プロファイルアクセス（スタティック）
//
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcSetIniFilePath			AjcSetIniFilePathW
	#define		AjcGetIniFilePath			AjcGetIniFilePathW
	#define		AjcSetRegRootPath			AjcSetRegRootPathW
	#define		AjcGetRegRootPath			AjcGetRegRootPathW
	#define		AjcSetRegMidPath			AjcSetRegMidPathW
	#define		AjcGetRegMidPath			AjcGetRegMidPathW
	#define		AjcSetProfilePath			AjcSetProfilePathW
	#define		AjcGetProfilePath			AjcGetProfilePathW
	#define		AjcSetProfilePath			AjcSetProfilePathW
	#define		AjcGetProfilePath			AjcGetProfilePathW
	#define		AjcSetBinDataDir			AjcSetBinDataDirW
	#define		AjcGetBinDataDir			AjcGetBinDataDirW

	#define		AjcGetProfileUInt			AjcGetProfileUIntW
	#define		AjcGetProfileSInt			AjcGetProfileSIntW
	#define		AjcGetProfileHex			AjcGetProfileHexW
	#define		AjcGetProfileReal			AjcGetProfileRealW
	#define		AjcGetProfileUI64			AjcGetProfileUI64W
	#define		AjcGetProfileSI64			AjcGetProfileSI64W
	#define		AjcGetProfileH64			AjcGetProfileH64W
	#define		AjcGetProfileArr			AjcGetProfileArrW
	#define		AjcGetProfileStr			AjcGetProfileStrW
	#define		AjcGetProfileBin			AjcGetProfileBinW
	#define		AjcGetProfileLogFont		AjcGetProfileLogFontW
	#define		AjcGetProfileFontObj		AjcGetProfileFontObjW

	#define		AjcPutProfileUInt			AjcPutProfileUIntW
	#define		AjcPutProfileSInt			AjcPutProfileSIntW
	#define		AjcPutProfileHex			AjcPutProfileHexW
	#define		AjcPutProfileReal			AjcPutProfileRealW
	#define		AjcPutProfileUI64			AjcPutProfileUI64W
	#define		AjcPutProfileSI64			AjcPutProfileSI64W
	#define		AjcPutProfileH64			AjcPutProfileH64W
	#define		AjcPutProfileArr			AjcPutProfileArrW
	#define		AjcPutProfileStr			AjcPutProfileStrW
	#define		AjcPutProfileBin			AjcPutProfileBinW
	#define		AjcPutProfileLogFont		AjcPutProfileLogFontW
	#define		AjcPutProfileFontObj		AjcPutProfileFontObjW

	#define		AjcDelProfileSect			AjcDelProfileSectW
	#define		AjcDelProfileKey			AjcDelProfileKeyW
	#define		AjcRemoveProfileSect		AjcRemoveProfileSectW
	#define		AjcCleanupProfileSect		AjcCleanupProfileSectW
	#define		AjcEnumProfileSect			AjcEnumProfileSectW
	#define		AjcEnumProfileRegSect		AjcEnumProfileRegSectW
	#define		AjcEnumProfileKey			AjcEnumProfileKeyW

	//----- プロファイルから変数値読み出し -------------------------------------------------------------------------//
	#define	AJCGETPF_UINT(S, V, D)	V = AjcGetProfileUIntW(S, L#V, D)
	#define	AJCGETPF_SINT(S, V, D)	V = AjcGetProfileSIntW(S, L#V, D)
	#define	AJCGETPF_HEX( S, V, D)	V = AjcGetProfileHexW (S, L#V, D)
	#define	AJCGETPF_REAL(S, V, D)	V = AjcGetProfileRealW(S, L#V, D)
	#define	AJCGETPF_STR( S, V, D)	AjcGetProfileStrW (S, L#V, D, V, AJCTSIZE(V))
	#define	AJCGETPF_ARR( S, V	 )	AjcGetProfileArrW (S, L#V, (VOP)&V, sizeof V[0], (sizeof V / sizeof V[0]))
	#define	AJCGETPF_BIN( S, V	 )	AjcGetProfileBinW (S, L#V, (VOP)&V, sizeof V)

	//----- プロファイルへ変数値書き込み ---------------------------------------------------------------------------//
	#define	AJCPUTPF_UINT(S, V)		AjcPutProfileUIntW(S, L#V, V)
	#define	AJCPUTPF_SINT(S, V)		AjcPutProfileSIntW(S, L#V, V)
	#define	AJCPUTPF_HEX( S, V)		AjcPutProfileHexW (S, L#V, V)
	#define	AJCPUTPF_REAL(S, V)		AjcPutProfileRealW(S, L#V, V)
	#define	AJCPUTPF_STR( S, V)		AjcPutProfileStrW (S, L#V, V)
	#define	AJCPUTPF_ARR( S, V)		AjcPutProfileArrW (S, L#V, (VOP)&V, sizeof V[0], (sizeof V / sizeof V[0]))
	#define	AJCPUTPF_BIN( S, V)		AjcPutProfileBinW (S, L#V, (VOP)&V, sizeof V)

#else

	#define		AjcSetIniFilePath			AjcSetIniFilePathA
	#define		AjcGetIniFilePath			AjcGetIniFilePathA
	#define		AjcSetRegRootPath			AjcSetRegRootPathA
	#define		AjcGetRegRootPath			AjcGetRegRootPathA
	#define		AjcSetRegMidPath			AjcSetRegMidPathA
	#define		AjcGetRegMidPath			AjcGetRegMidPathA
	#define		AjcSetProfilePath			AjcSetProfilePathA
	#define		AjcGetProfilePath			AjcGetProfilePathA
	#define		AjcSetProfilePath			AjcSetProfilePathA
	#define		AjcGetProfilePath			AjcGetProfilePathA
	#define		AjcSetBinDataDir			AjcSetBinDataDirA
	#define		AjcGetBinDataDir			AjcGetBinDataDirA

	#define		AjcGetProfileUInt			AjcGetProfileUIntA
	#define		AjcGetProfileSInt			AjcGetProfileSIntA
	#define		AjcGetProfileHex			AjcGetProfileHexA
	#define		AjcGetProfileReal			AjcGetProfileRealA
	#define		AjcGetProfileUI64			AjcGetProfileUI64A
	#define		AjcGetProfileSI64			AjcGetProfileSI64A
	#define		AjcGetProfileH64			AjcGetProfileH64A
	#define		AjcGetProfileArr			AjcGetProfileArrA
	#define		AjcGetProfileStr			AjcGetProfileStrA
	#define		AjcGetProfileBin			AjcGetProfileBinA
	#define		AjcGetProfileLogFont		AjcGetProfileLogFontA
	#define		AjcGetProfileFontObj		AjcGetProfileFontObjA

	#define		AjcPutProfileUInt			AjcPutProfileUIntA
	#define		AjcPutProfileSInt			AjcPutProfileSIntA
	#define		AjcPutProfileHex			AjcPutProfileHexA
	#define		AjcPutProfileReal			AjcPutProfileRealA
	#define		AjcPutProfileUI64			AjcPutProfileUI64A
	#define		AjcPutProfileSI64			AjcPutProfileSI64A
	#define		AjcPutProfileH64			AjcPutProfileH64A
	#define		AjcPutProfileArr			AjcPutProfileArrA
	#define		AjcPutProfileStr			AjcPutProfileStrA
	#define		AjcPutProfileBin			AjcPutProfileBinA
	#define		AjcPutProfileLogFont		AjcPutProfileLogFontA
	#define		AjcPutProfileFontObj		AjcPutProfileFontObjA

	#define		AjcDelProfileSect			AjcDelProfileSectA
	#define		AjcDelProfileKey			AjcDelProfileKeyA
	#define		AjcRemoveProfileSect		AjcRemoveProfileSectA
	#define		AjcCleanupProfileSect		AjcCleanupProfileSectA
	#define		AjcEnumProfileSect			AjcEnumProfileSectA
	#define		AjcEnumProfileRegSect		AjcEnumProfileRegSectA
	#define		AjcEnumProfileKey			AjcEnumProfileKeyA

	//----- プロファイルから変数値読み出し -------------------------------------------------------------------------//
	#define	AJCGETPF_UINT(S, V, D)	V = AjcGetProfileUIntA(S, #V, D)
	#define	AJCGETPF_SINT(S, V, D)	V = AjcGetProfileSIntA(S, #V, D)
	#define	AJCGETPF_HEX( S, V, D)	V = AjcGetProfileHexA (S, #V, D)
	#define	AJCGETPF_REAL(S, V, D)	V = AjcGetProfileRealA(S, #V, D)
	#define	AJCGETPF_STR( S, V, D)	AjcGetProfileStrA (S, #V, D, V, AJCTSIZE(V))
	#define	AJCGETPF_ARR( S, V	 )	AjcGetProfileArrA (S, #V, (VOP)&V, sizeof V[0], (sizeof V / sizeof V[0]))
	#define	AJCGETPF_BIN( S, V	 )	AjcGetProfileBinA (S, #V, (VOP)&V, sizeof V)

	//----- プロファイルへ変数値書き込み ---------------------------------------------------------------------------//
	#define	AJCPUTPF_UINT(S, V)		AjcPutProfileUIntA(S, #V, V)
	#define	AJCPUTPF_SINT(S, V)		AjcPutProfileSIntA(S, #V, V)
	#define	AJCPUTPF_HEX( S, V)		AjcPutProfileHexA (S, #V, V)
	#define	AJCPUTPF_REAL(S, V)		AjcPutProfileRealA(S, #V, V)
	#define	AJCPUTPF_STR( S, V)		AjcPutProfileStrA (S, #V, V)
	#define	AJCPUTPF_ARR( S, V)		AjcPutProfileArrA (S, #V, (VOP)&V, sizeof V[0], (sizeof V / sizeof V[0]))
	#define	AJCPUTPF_BIN( S, V)		AjcPutProfileBinA (S, #V, (VOP)&V, sizeof V)
#endif

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSetProfileIsRegistory(BOOL fRegistory);
AJCEXPORT	BOOL		WINAPI	AjcGetProfileIsRegistory(VO);

AJCEXPORT	BOOL		WINAPI	AjcSetRegOptionVolatile(BOOL fVolatile);
AJCEXPORT	BOOL		WINAPI	AjcGetRegOptionVolatile(VO);

AJCEXPORT	int			WINAPI	AjcSetIniFilePathA(C_BCP pPath);
AJCEXPORT	int			WINAPI	AjcSetIniFilePathW(C_WCP pPath);

AJCEXPORT	int			WINAPI	AjcGetIniFilePathA(BCP pBuf, int lBuf);
AJCEXPORT	int			WINAPI	AjcGetIniFilePathW(WCP pBuf, int lBuf);

AJCEXPORT	int			WINAPI	AjcSetRegRootPathA(C_BCP pRootPath);
AJCEXPORT	int			WINAPI	AjcSetRegRootPathW(C_WCP pRootPath);

AJCEXPORT	int			WINAPI	AjcGetRegRootPathA(BCP pBuf, UI lBuf);
AJCEXPORT	int			WINAPI	AjcGetRegRootPathW(WCP pBuf, UI lBuf);

AJCEXPORT	int			WINAPI	AjcSetRegMidPathA(C_BCP pPath);
AJCEXPORT	int			WINAPI	AjcSetRegMidPathW(C_WCP pPath);

AJCEXPORT	int			WINAPI	AjcGetRegMidPathA(BCP pBuf, int lBuf);
AJCEXPORT	int			WINAPI	AjcGetRegMidPathW(WCP pBuf, int lBuf);

AJCEXPORT	int			WINAPI	AjcSetProfilePathA(C_BCP pPath);
AJCEXPORT	int			WINAPI	AjcSetProfilePathW(C_WCP pPath);

AJCEXPORT	BOOL		WINAPI	AjcGetProfilePathA(BCP	 pBuf , int lBuf);
AJCEXPORT	BOOL		WINAPI	AjcGetProfilePathW(WCP	 pBuf , int lBuf);

AJCEXPORT	VO			WINAPI	AjcSetBinDataDirA(C_BCP pBinDir);
AJCEXPORT	VO			WINAPI	AjcSetBinDataDirW(C_WCP pBinDir);

AJCEXPORT	VO			WINAPI	AjcGetBinDataDirA(BCP pBuf, UI lBuf);
AJCEXPORT	VO			WINAPI	AjcGetBinDataDirW(WCP pBuf, UI lBuf);

//----- プロファイル記録先の退避 -------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcPushProfileStack (VO);
AJCEXPORT	UI		WINAPI	AjcPopProfileStack	(VO);
AJCEXPORT	UI		WINAPI	AjcResetProfileStack(VO);

//----- プロファイル読み出し -----------------------------------------------------------------------------------//
//extern int	AjcGetProfile();
//extern int	AjcGetProfileBool();

AJCEXPORT	UI			WINAPI	AjcGetProfileUIntA(C_BCP pSecName, C_BCP pKeyName, UI defValue);
AJCEXPORT	UI			WINAPI	AjcGetProfileUIntW(C_WCP pSecName, C_WCP pKeyName, UI defValue);

AJCEXPORT	SI			WINAPI	AjcGetProfileSIntA(C_BCP pSecName, C_BCP pKeyName, SI defValue);
AJCEXPORT	SI			WINAPI	AjcGetProfileSIntW(C_WCP pSecName, C_WCP pKeyName, SI defValue);

AJCEXPORT	UI			WINAPI	AjcGetProfileHexA(C_BCP pSecName, C_BCP pKeyName, UI defValue);
AJCEXPORT	UI			WINAPI	AjcGetProfileHexW(C_WCP pSecName, C_WCP pKeyName, UI defValue);

AJCEXPORT	double		WINAPI	AjcGetProfileRealA(C_BCP pSecName, C_BCP pKeyName, double defValue);
AJCEXPORT	double		WINAPI	AjcGetProfileRealW(C_WCP pSecName, C_WCP pKeyName, double defValue);

AJCEXPORT	ULL			WINAPI	AjcGetProfileUI64A(C_BCP pSecName, C_BCP pKeyName, ULL defValue);
AJCEXPORT	ULL			WINAPI	AjcGetProfileUI64W(C_WCP pSecName, C_WCP pKeyName, ULL defValue);

AJCEXPORT	SLL			WINAPI	AjcGetProfileSI64A(C_BCP pSecName, C_BCP pKeyName, SLL defValue);
AJCEXPORT	SLL			WINAPI	AjcGetProfileSI64W(C_WCP pSecName, C_WCP pKeyName, SLL defValue);

AJCEXPORT	ULL			WINAPI	AjcGetProfileH64A(C_BCP pSecName, C_BCP pKeyName, ULL defValue);
AJCEXPORT	ULL			WINAPI	AjcGetProfileH64W(C_WCP pSecName, C_WCP pKeyName, ULL defValue);

AJCEXPORT	UI			WINAPI	AjcGetProfileArrA(C_BCP pSecName, C_BCP pKeyName, VOP pArray, UI lArray, UI nArray);
AJCEXPORT	UI			WINAPI	AjcGetProfileArrW(C_WCP pSecName, C_WCP pKeyName, VOP pArray, UI lArray, UI nArray);

AJCEXPORT	UI			WINAPI	AjcGetProfileStrA(C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcGetProfileStrW(C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf);

AJCEXPORT	UI			WINAPI	AjcGetProfileBinA(C_BCP pSecName, C_BCP pKeyName, VOP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcGetProfileBinW(C_WCP pSecName, C_WCP pKeyName, VOP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcGetProfileLogFontA(C_BCP pSecName, C_BCP pKeyPrefix, LPLOGFONTA pLogFont);
AJCEXPORT	BOOL		WINAPI	AjcGetProfileLogFontW(C_WCP pSecName, C_WCP pKeyPrefix, LPLOGFONTW pLogFont);

AJCEXPORT	HFONT		WINAPI	AjcGetProfileFontObjA(C_BCP pSecName, C_BCP pKeyPrefix);
AJCEXPORT	HFONT		WINAPI	AjcGetProfileFontObjW(C_WCP pSecName, C_WCP pKeyPrefix);

//----- プロファイル書き込み -----------------------------------------------------------------------------------//
//extern	int AjcPutProfile();
//extern	int AjcPutProfileBool();

AJCEXPORT	BOOL		WINAPI	AjcPutProfileUIntA(C_BCP pSecName, C_BCP pKeyName, UI Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileUIntW(C_WCP pSecName, C_WCP pKeyName, UI Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileSIntA(C_BCP pSecName, C_BCP pKeyName, SI Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileSIntW(C_WCP pSecName, C_WCP pKeyName, SI Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileHexA(C_BCP pSecName, C_BCP pKeyName, UI Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileHexW(C_WCP pSecName, C_WCP pKeyName, UI Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileRealA(C_BCP pSecName, C_BCP pKeyName, double Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileRealW(C_WCP pSecName, C_WCP pKeyName, double Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileUI64A(C_BCP pSecName, C_BCP pKeyName, ULL Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileUI64W(C_WCP pSecName, C_WCP pKeyName, ULL Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileSI64A(C_BCP pSecName, C_BCP pKeyName, SLL Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileSI64W(C_WCP pSecName, C_WCP pKeyName, SLL Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileH64A(C_BCP pSecName, C_BCP pKeyName, ULL Value);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileH64W(C_WCP pSecName, C_WCP pKeyName, ULL Value);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileArrA(C_BCP pSecName, C_BCP pKeyName, VOP pArray, UI lArray, UI nArray);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileArrW(C_WCP pSecName, C_WCP pKeyName, VOP pArray, UI lArray, UI nArray);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileStrA(C_BCP pSecName, C_BCP pKeyName, C_BCP pStr);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileStrW(C_WCP pSecName, C_WCP pKeyName, C_WCP pStr);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileBinA(C_BCP pSecName, C_BCP pKeyName, C_VOP pDat, UI lDat);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileBinW(C_WCP pSecName, C_WCP pKeyName, C_VOP pDat, UI lDat);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileLogFontA(C_BCP pSecName, C_BCP pKeyPrefix, const LOGFONTA *pLogFont);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileLogFontW(C_WCP pSecName, C_WCP pKeyPrefix, const LOGFONTW *pLogFont);

AJCEXPORT	BOOL		WINAPI	AjcPutProfileFontObjA(C_BCP pSecName, C_BCP pKeyPrefix, HFONT hFont);
AJCEXPORT	BOOL		WINAPI	AjcPutProfileFontObjW(C_WCP pSecName, C_WCP pKeyPrefix, HFONT hFont);

//----- プロファイル削除 ---------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcDelProfileSectA(C_BCP pSecName);
AJCEXPORT	BOOL		WINAPI	AjcDelProfileSectW(C_WCP pSecName);

AJCEXPORT	BOOL		WINAPI	AjcDelProfileKeyA (C_BCP pSecName, C_BCP pKeyName);
AJCEXPORT	BOOL		WINAPI	AjcDelProfileKeyW (C_WCP pSecName, C_WCP pKeyName);

AJCEXPORT	BOOL	 	WINAPI AjcRemoveProfileSectA(C_BCP pSecName);
AJCEXPORT	BOOL	 	WINAPI AjcRemoveProfileSectW(C_WCP pSecName);

AJCEXPORT	BOOL	 	WINAPI AjcCleanupProfileSectA(C_BCP pSecName);
AJCEXPORT	BOOL	 	WINAPI AjcCleanupProfileSectW(C_WCP pSecName);


//----- プロファイルクローズ -----------------------------------------------------------------------------------//
AJCEXPORT	VO			WINAPI	AjcCloseProfile (VO);

//----- プロファイル・セクション名収集 -------------------------------------------------------------------------//
AJCEXPORT	int			WINAPI	AjcEnumProfileSectA (UX cbp, BOOL (CALLBACK *cbEnumSect)(C_BCP pSect, UX cbp));
AJCEXPORT	int			WINAPI	AjcEnumProfileSectW (UX cbp, BOOL (CALLBACK *cbEnumSect)(C_WCP pSect, UX cbp));

AJCEXPORT	int			WINAPI	AjcEnumProfileRegSectA (C_BCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumSect)(C_BCP pSect, UX cbp));
AJCEXPORT	int			WINAPI	AjcEnumProfileRegSectW (C_WCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumSect)(C_WCP pSect, UX cbp));

//----- プロファイル・キー名収集 -------------------------------------------------------------------------------//
AJCEXPORT	int			WINAPI	AjcEnumProfileKeyA (C_BCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumKey)(C_BCP pKey, UX cbp));
AJCEXPORT	int			WINAPI	AjcEnumProfileKeyW (C_WCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumKey)(C_WCP pKey, UX cbp));

/****************************************************************************************************************/
#endif
