﻿#ifndef	AJCQUEF_H_
#define	AJCQUEF_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	キューヘッダ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct _AJCFQNODE {
	struct	_AJCFQNODE	*pNxt;					//	次のブロックへのポインタ
} AJCFQNODE, *PAJCFQNODE;

//--------------------------------------------------------------------------------------------------------------//
//	ポインタ配列エントリの構造体定義マクロ																		//
//--------------------------------------------------------------------------------------------------------------//
#define		MAJCFQUEPTR(ST, PT)										\
typedef struct {													\
	PT		pNode;					/*	ノードへのポインタ	*/		\
} ST, *P##ST;														\
typedef const ST *PC##ST;

MAJCFQUEPTR(AJCFQUEPTR, VOP)

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct {
	UI			InstID;							//	インスタンス識別ＩＤ
	PAJCFQNODE	pTop;							//	先頭ノードへのポインタ
	PAJCFQNODE	pLas;							//	最終ノードへのポインタ
	UI			num;							//	ノード数
	UI			len;							//	ノードデータバイト数

	BOOL				fMultiThread;			//	排他制御フラグ
	CRITICAL_SECTION	cs;						//	クリティカルセクション・オブジェクト

	UX			cbp;							//	コールバックパラメタ
	VO (CALLBACK *cbRemove)(VOP pDat, UX cbp);	//	ノード消去通知用コールバック

} AJCFQUE, *LPAJCFQUE, *HAJCFQUE;
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCFQUE	WINAPI	AjcFQueCreate(UI DatSize, UX cbp, VO (CALLBACK *cbRemove)(VOP pDat, UX cbp));
AJCEXPORT	BOOL		WINAPI	AjcFQueDelete(HAJCFQUE hFQue);
AJCEXPORT	BOOL		WINAPI	AjcFQueEnableMultiThread(HAJCFQUE hFQue, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI	AjcFQueEnque	(HAJCFQUE hFQue, C_VOP pDat);
AJCEXPORT	VOP			WINAPI	AjcFQueEnqueEx	(HAJCFQUE hFQue, C_VOP pDat);
AJCEXPORT	BOOL		WINAPI	AjcFQueEnqTop	(HAJCFQUE hFQue, C_VOP pDat);
AJCEXPORT	VOP 		WINAPI	AjcFQueEnqTopEx	(HAJCFQUE hFQue, C_VOP pDat);
AJCEXPORT	UI			WINAPI	AjcFQueDeque	(HAJCFQUE hFQue, VOP pBuf);
AJCEXPORT	BOOL		WINAPI	AjcFQuePurge	(HAJCFQUE hFQue);

AJCEXPORT	UI			WINAPI	AjcFQueGetCount	(HAJCFQUE hFQue);
AJCEXPORT	UI			WINAPI	AjcFQueNumber	(HAJCFQUE hFQue);	//	旧互換

AJCEXPORT	BOOL		WINAPI	AjcFQueMerge	(HAJCFQUE hFQue, HAJCFQUE pSrc);

AJCEXPORT	VOP			WINAPI	AjcFQueTopNode	(HAJCFQUE hFQue);
AJCEXPORT	VOP			WINAPI	AjcFQueNextNode	(HAJCFQUE hFQue, C_VOP pCurrentNode);

AJCEXPORT	PCAJCFQUEPTR WINAPI AjcFQueCreatePtrArr (HAJCFQUE hFQue, UIP pNum);
AJCEXPORT	VO	 		 WINAPI AjcFQueReleasePtrArr(HAJCFQUE hFQue, PCAJCFQUEPTR pArr);

/****************************************************************************************************************/
#endif
