﻿#ifndef	AJCQUEV_H_
#define	AJCQUEV_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	キューヘッダ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct _AJCVQNODE {
	struct	_AJCVQNODE	*pNxt;		//	次のブロックへのポインタ
	UI		len;					//	データバイト数
} AJCVQNODE, *PAJCVQNODE;

//--------------------------------------------------------------------------------------------------------------//
//	ポインタ配列エントリの構造体定義マクロ																		//
//--------------------------------------------------------------------------------------------------------------//
#define		MAJCVQUEPTR(ST, PT)											\
typedef struct {														\
	PT		pNode;					/*	ノードへのポインタ	*/			\
	UI		len;					/*	ノードのバイト数	*/			\
} ST, *P##ST;															\
typedef const ST *PC##ST;

MAJCVQUEPTR(AJCVQUEPTR, VOP)

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct _AJCVQUE {
	UI			InstID;					//	インスタンス識別ＩＤ
	PAJCVQNODE	pTop;					//	先頭エレメントへのポインタ
	PAJCVQNODE	pLas;					//	最終エレメントへのポインタ
	UI			num;					//	エレメント数

	BOOL				fMultiThread;	//	排他制御フラグ
	CRITICAL_SECTION	cs;				//	クリティカルセクション・オブジェクト

	UX			cbp;									//	コールバックパラメタ
	VO (CALLBACK *cbRemove)(VOP pDat, UI len, UX cbp);	//	ノード消去通知用コールバック

} AJCVQUE, *LPAJCVQUE, *HAJCVQUE;
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCVQUE	WINAPI	AjcVQueCreate(UX cbp, VO (CALLBACK *cbRemove)(VOP pDat, UI len, UX cbp));
AJCEXPORT	BOOL		WINAPI	AjcVQueDelete	(HAJCVQUE hVQue);
AJCEXPORT	BOOL		WINAPI	AjcVQueEnableMultiThread(HAJCVQUE hFQue, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI	AjcVQueEnque	(HAJCVQUE hVQue, C_VOP pDat, UI lDat);
AJCEXPORT	VOP			WINAPI	AjcVQueEnqueEx	(HAJCVQUE hVQue, C_VOP pDat, UI lDat);
AJCEXPORT	BOOL		WINAPI	AjcVQueEnqTop	(HAJCVQUE hVQue, C_VOP pDat, UI lDat);
AJCEXPORT	VOP			WINAPI	AjcVQueEnqTopEx	(HAJCVQUE hVQue, C_VOP pDat, UI lDat);
AJCEXPORT	UI			WINAPI	AjcVQueDeque	(HAJCVQUE hVQue, VOP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcVQueDequeEx	(HAJCVQUE hVQue, VOP pBuf, UI lBuf);
AJCEXPORT	BOOL		WINAPI	AjcVQuePurge	(HAJCVQUE hVQue);

AJCEXPORT	UI			WINAPI	AjcVQueGetCount	(HAJCVQUE hVQue);
AJCEXPORT	UI			WINAPI	AjcVQueNumber	(HAJCVQUE hVQue);	//	旧互換

AJCEXPORT	BOOL		WINAPI	AjcVQueMerge	(HAJCVQUE hVQue, HAJCVQUE pSrc);


AJCEXPORT	VOP			WINAPI	AjcVQueTopNode	(HAJCVQUE hVQue, UIP pBytes);
AJCEXPORT	VOP			WINAPI	AjcVQueNextNode	(HAJCVQUE hVQue, C_VOP pCurrentNode, UIP pBytes);

AJCEXPORT	PCAJCVQUEPTR WINAPI AjcVQueCreatePtrArr (HAJCVQUE hVQue, UIP pNum);
AJCEXPORT	VO	 		 WINAPI AjcVQueReleasePtrArr(HAJCVQUE hVQue, PCAJCVQUEPTR pArr);

/****************************************************************************************************************/
#endif
