﻿#ifndef	AJCQUEX_H_
#define	AJCQUEX_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	キューヘッダ																								//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCXQUEID		0x1289FB3A
typedef  struct _AJCXQNODE {
	UI		id;						//	=AJCXQUEID
	struct	_AJCXQNODE	*pBfr;		//	前のブロックへのポインタ
	struct	_AJCXQNODE	*pNxt;		//	次のブロックへのポインタ
	UI		len;					//	データバイト数
} AJCXQNODE, *PAJCXQNODE;

//--------------------------------------------------------------------------------------------------------------//
//	ポインタ配列エントリの構造体定義マクロ																		//
//--------------------------------------------------------------------------------------------------------------//
#define		MAJCXQUEPTR(ST, PT)											\
typedef struct {														\
	PT		pNode;					/*	ノードへのポインタ	*/			\
	UI		len;					/*	ノードのバイト数	*/			\
} ST, *P##ST;															\
typedef const ST *PC##ST;

MAJCXQUEPTR(AJCXQUEPTR, VOP)

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct _AJCXQUE {
	UI			InstID;					//	インスタンス識別ＩＤ
	PAJCXQNODE	pTop;					//	先頭ノードへのポインタ
	PAJCXQNODE	pLas;					//	最終ノードへのポインタ
	UI			num;					//	ノード数

	BOOL				fMultiThread;	//	排他制御フラグ
	CRITICAL_SECTION	cs;				//	クリティカルセクション・オブジェクト

	UX			cbp;									//	コールバックパラメタ
	VO (CALLBACK *cbRemove)(VOP pDat, UI len, UX cbp);	//	ノード消去通知用コールバック

} AJCXQUE, *LPAJCXQUE, *HAJCXQUE;
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCXQUE	WINAPI	AjcXQueCreate(UX cbp, VO (CALLBACK *cbRemove)(VOP pDat, UI len, UX cbp));
AJCEXPORT	BOOL		WINAPI	AjcXQueDelete	(HAJCXQUE hXQue);

AJCEXPORT	VOP			WINAPI	AjcXQueEnque	(HAJCXQUE hXQue, C_VOP pDat, UI lDat);
AJCEXPORT	VOP			WINAPI	AjcXQueEnqTop	(HAJCXQUE hXQue, C_VOP pDat, UI lDat);
AJCEXPORT	VOP			WINAPI	AjcXQueInsert	(HAJCXQUE hXQue, C_VOP pDat, UI lDat, C_VOP pIns);
AJCEXPORT	UI			WINAPI	AjcXQueRemove	(HAJCXQUE hXQue, C_VOP pDat);
AJCEXPORT	BOOL		WINAPI	AjcXQuePurge	(HAJCXQUE hXQue);
AJCEXPORT	UI			WINAPI	AjcXQueDeque	(HAJCXQUE hXQue, VOP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI	AjcXQueGetCount	(HAJCXQUE hXQue);
AJCEXPORT	BOOL		WINAPI	AjcXQueMerge	(HAJCXQUE hXQue, HAJCXQUE pSrc);

AJCEXPORT	VOP			WINAPI	AjcXQueTopNode	(HAJCXQUE hXQue, UIP pBytes);
AJCEXPORT	VOP			WINAPI	AjcXQueLastNode	(HAJCXQUE hXQue, UIP pBytes);
AJCEXPORT	VOP			WINAPI	AjcXQueNextNode	(HAJCXQUE hXQue, C_VOP pCurrentNode, UIP pBytes);
AJCEXPORT	VOP			WINAPI	AjcXQuePrevNode	(HAJCXQUE hXQue, C_VOP pCurrentNode, UIP pBytes);

AJCEXPORT	PCAJCXQUEPTR WINAPI AjcXQueCreatePtrArr (HAJCXQUE hXQue, UIP pNum);
AJCEXPORT	VO	 		 WINAPI AjcXQueReleasePtrArr(HAJCXQUE hXQue, PCAJCXQUEPTR pArr);

AJCEXPORT	BOOL		WINAPI	AjcXQueEnableMultiThread(HAJCXQUE hFQue, BOOL fEnable);

/****************************************************************************************************************/
#endif
