﻿#ifndef	AJCREGFILE_H_
#define	AJCREGFILE_H_
/****************************************************************************************************************/

#define	AJCMAX_REGPATH		2048

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcSetRegBinDir				AjcSetRegBinDirW
	#define		AjcGetRegBinDir				AjcGetRegBinDirW
	#define		AjcGetRegFileUInt			AjcGetRegFileUIntW
	#define		AjcGetRegFileSInt			AjcGetRegFileSIntW
	#define		AjcGetRegFileHex 			AjcGetRegFileHexW
	#define		AjcGetRegFileReal			AjcGetRegFileRealW
	#define		AjcGetRegFileUI64			AjcGetRegFileUI64W
	#define		AjcGetRegFileSI64			AjcGetRegFileSI64W
	#define		AjcGetRegFileH64 			AjcGetRegFileH64W
	#define		AjcGetRegFileArr 			AjcGetRegFileArrW
	#define		AjcGetRegFileStr 			AjcGetRegFileStrW
	#define		AjcGetRegFileExp			AjcGetRegFileExpW
	#define		AjcGetRegFileBin			AjcGetRegFileBinW
	#define		AjcPutRegFileUInt			AjcPutRegFileUIntW
	#define		AjcPutRegFileSInt			AjcPutRegFileSIntW
	#define		AjcPutRegFileHex 			AjcPutRegFileHexW
	#define		AjcPutRegFileReal			AjcPutRegFileRealW
	#define		AjcPutRegFileUI64			AjcPutRegFileUI64W
	#define		AjcPutRegFileSI64			AjcPutRegFileSI64W
	#define		AjcPutRegFileH64 			AjcPutRegFileH64W
	#define		AjcPutRegFileArr 			AjcPutRegFileArrW
	#define		AjcPutRegFileStr 			AjcPutRegFileStrW
	#define		AjcPutRegFileExp			AjcPutRegFileExpW
	#define		AjcPutRegFileBin			AjcPutRegFileBinW
	#define		AjcGetRegFileInfo			AjcGetRegFileInfoW
	#define		AjcDelRegSect				AjcDelRegSectW
	#define		AjcDelRegKey				AjcDelRegKeyW
	#define		AjcCleanupRegSect			AjcCleanupRegSectW
	#define		AjcRemoveRegSect			AjcRemoveRegSectW
	#define		AjcEnumRegSect				AjcEnumRegSectW
	#define		AjcEnumRegKey				AjcEnumRegKeyW

	#define		AjcRegGet					AjcRegGetW
	#define		AjcRegPut					AjcRegPutW
	#define		AjcRegDelSubKey				AjcRegDelSubKeyW
	#define		AjcRegDelValue				AjcRegDelValueW
	#define		AjcRegEnvGet				AjcRegEnvGetW
	#define		AjcRegHkCuEnvGet			AjcRegHkCuEnvGetW
	#define		AjcRegHkLmEnvGet			AjcRegHkLmEnvGetW
	#define		AjcRegEnvPut				AjcRegEnvPutW
	#define		AjcRegHkCuEnvPut			AjcRegHkCuEnvPutW
	#define		AjcRegHkLmEnvPut			AjcRegHkLmEnvPutW
	#define		AjcRegHkCuEnvDel			AjcRegHkCuEnvDelW
	#define		AjcRegHkLmEnvDel			AjcRegHkLmEnvDelW
	#define		AjcRegHkCuEnvSrhItem		AjcRegHkCuEnvSrhItemW
	#define		AjcRegHkLmEnvSrhItem		AjcRegHkLmEnvSrhItemW
	#define		AjcRegHkCuEnvAddItem		AjcRegHkCuEnvAddItemW
	#define		AjcRegHkLmEnvAddItem		AjcRegHkLmEnvAddItemW
	#define		AjcRegHkCuEnvSrhPathItem	AjcRegHkCuEnvSrhPathItemW
	#define		AjcRegHkLmEnvSrhPathItem	AjcRegHkLmEnvSrhPathItemW
	#define		AjcRegHkCuEnvAddPathItem	AjcRegHkCuEnvAddPathItemW
	#define		AjcRegHkLmEnvAddPathItem	AjcRegHkLmEnvAddPathItemW
	#define		AjcRegHkCuEnvDelItem		AjcRegHkCuEnvDelItemW
	#define		AjcRegHkLmEnvDelItem		AjcRegHkLmEnvDelItemW
	#define		AjcRegHkCuEnvDelPathItem	AjcRegHkCuEnvDelPathItemW
	#define		AjcRegHkLmEnvDelPathItem	AjcRegHkLmEnvDelPathItemW

	#define		AjcEnvAddPathItem			AjcEnvAddPathItemW
	#define		AjcEnvDelPathItem			AjcEnvDelPathItemW

	#define		AjcRegIsPathExist			AjcRegIsPathExistW
	#define		AjcRegIsKeyExist			AjcRegIsKeyExistW
#else
	#define		AjcSetRegBinDir				AjcSetRegBinDirA
	#define		AjcGetRegBinDir				AjcGetRegBinDirA
	#define		AjcGetRegFileUInt			AjcGetRegFileUIntA
	#define		AjcGetRegFileSInt			AjcGetRegFileSIntA
	#define		AjcGetRegFileHex 			AjcGetRegFileHexA
	#define		AjcGetRegFileReal			AjcGetRegFileRealA
	#define		AjcGetRegFileUI64			AjcGetRegFileUI64A
	#define		AjcGetRegFileSI64			AjcGetRegFileSI64A
	#define		AjcGetRegFileH64 			AjcGetRegFileH64A
	#define		AjcGetRegFileArr 			AjcGetRegFileArrA
	#define		AjcGetRegFileStr 			AjcGetRegFileStrA
	#define		AjcGetRegFileExp			AjcGetRegFileExpA
	#define		AjcGetRegFileBin			AjcGetRegFileBinA
	#define		AjcPutRegFileUInt			AjcPutRegFileUIntA
	#define		AjcPutRegFileSInt			AjcPutRegFileSIntA
	#define		AjcPutRegFileHex 			AjcPutRegFileHexA
	#define		AjcPutRegFileReal			AjcPutRegFileRealA
	#define		AjcPutRegFileUI64			AjcPutRegFileUI64A
	#define		AjcPutRegFileSI64			AjcPutRegFileSI64A
	#define		AjcPutRegFileH64 			AjcPutRegFileH64A
	#define		AjcPutRegFileArr 			AjcPutRegFileArrA
	#define		AjcPutRegFileStr 			AjcPutRegFileStrA
	#define		AjcPutRegFileExp			AjcPutRegFileExpA
	#define		AjcPutRegFileBin			AjcPutRegFileBinA
	#define		AjcGetRegFileInfo			AjcGetRegFileInfoA
	#define		AjcDelRegSect				AjcDelRegSectA
	#define		AjcDelRegKey				AjcDelRegKeyA
	#define		AjcCleanupRegSect			AjcCleanupRegSectA
	#define		AjcRemoveRegSect			AjcRemoveRegSectA
	#define		AjcEnumRegSect				AjcEnumRegSectA
	#define		AjcEnumRegKey				AjcEnumRegKeyA

	#define		AjcRegGet					AjcRegGetA
	#define		AjcRegPut					AjcRegPutA
	#define		AjcRegDelSubKey				AjcRegDelSubKeyA
	#define		AjcRegDelValue				AjcRegDelValueA
	#define		AjcRegEnvGet				AjcRegEnvGetA
	#define		AjcRegHkCuEnvGet			AjcRegHkCuEnvGetA
	#define		AjcRegHkLmEnvGet			AjcRegHkLmEnvGetA
	#define		AjcRegEnvPut				AjcRegEnvPutA
	#define		AjcRegHkCuEnvPut			AjcRegHkCuEnvPutA
	#define		AjcRegHkLmEnvPut			AjcRegHkLmEnvPutA
	#define		AjcRegHkCuEnvDel			AjcRegHkCuEnvDelA
	#define		AjcRegHkLmEnvDel			AjcRegHkLmEnvDelA
	#define		AjcRegHkCuEnvSrhItem		AjcRegHkCuEnvSrhItemA
	#define		AjcRegHkLmEnvSrhItem		AjcRegHkLmEnvSrhItemA
	#define		AjcRegHkCuEnvAddItem		AjcRegHkCuEnvAddItemA
	#define		AjcRegHkLmEnvAddItem		AjcRegHkLmEnvAddItemA
	#define		AjcRegHkCuEnvSrhPathItem	AjcRegHkCuEnvSrhPathItemA
	#define		AjcRegHkLmEnvSrhPathItem	AjcRegHkLmEnvSrhPathItemA
	#define		AjcRegHkCuEnvAddPathItem	AjcRegHkCuEnvAddPathItemA
	#define		AjcRegHkLmEnvAddPathItem	AjcRegHkLmEnvAddPathItemA
	#define		AjcRegHkCuEnvDelItem		AjcRegHkCuEnvDelItemA
	#define		AjcRegHkLmEnvDelItem		AjcRegHkLmEnvDelItemA
	#define		AjcRegHkCuEnvDelPathItem	AjcRegHkCuEnvDelPathItemA
	#define		AjcRegHkLmEnvDelPathItem	AjcRegHkLmEnvDelPathItemA

	#define		AjcEnvAddPathItem			AjcEnvAddPathItemA
	#define		AjcEnvDelPathItem			AjcEnvDelPathItemA

	#define		AjcRegIsPathExist			AjcRegIsPathExistA
	#define		AjcRegIsKeyExist			AjcRegIsKeyExistA
#endif
/*--------------------------------------------------------------------------------------------------------------*/
/*	レジストリタイプ																							*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef enum {																// 値	内容
	AJCREG_NONE							= REG_NONE						,	//	0 : 特定の型を持たない値
	AJCREG_SZ							= REG_SZ						,	//	1 : 文字列値
	AJCREG_EXPAND_SZ					= REG_EXPAND_SZ					,	//	2 : 展開可能な文字列値
	AJCREG_BINARY 						= REG_BINARY					,	//	3 : バイナリ値
	AJCREG_DWORD						= REG_DWORD						,	//	4 : ３２ビット値（リトルエンディアン）
	AJCREG_DWORD_BIG_ENDIAN				= REG_DWORD_BIG_ENDIAN			,	//	5 : ３２ビット値（ビッグエンディアン）
	AJCREG_LINK							= REG_LINK						,	//	6 : シンボリックリンク値
	AJCREG_MULTI_SZ						= REG_MULTI_SZ					,	//	7 : 複数の文字列値
	AJCREG_RESOURCE_LIST			 	= REG_RESOURCE_LIST				,	//	8 : リソースマップ値
	AJCREG_FULL_RESOURCE_DESCRIPTOR 	= REG_FULL_RESOURCE_DESCRIPTOR	,	//	9 : ハードウェアリソースリスト値
	AJCREG_RESOURCE_REQUIREMENTS_LIST	= REG_RESOURCE_REQUIREMENTS_LIST,	// 10 : ネストされた一連の配列値
	AJCREG_QWORD						= REG_QWORD							// 11 : ６４ビット値（リトルエンディアン）
} AJCREGTYPE, *PAJCREGTYPE;

#define		AJCREG_DWORD_LITTLE_ENDIAN	REG_DWORD_LITTLE_ENDIAN				//	4 : ３２ビット値(REG_DWORDと同じ)
#define		AJCREG_QWORD_LITTLE_ENDIAN	REG_QWORD_LITTLE_ENDIAN				// 11 : ６４ビット値(REG_QWORDと同じ)

/*--------------------------------------------------------------------------------------------------------------*/
/*	レジストリ書き込みオプション																				*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef enum {
	AJCREGOPT_ARG_NON_VOLATILE		= 0	,		//	引数の指定に従う（fVolatile引数のない場合は、永続記録）
	AJCREGOPT_ARG_VOLATILE				,		//	引数の指定に従う（fVolatile引数のない場合は、揮発性）
	AJCREGOUT_NON_VOLATILE				,		//	全て非揮発性
	AJCREGOPT_VOLATILE					,		//	全て揮発性とする
} AJCREGOPT, *PAJCREGOPT;

#define AJCREGOPT_DEFAULT	AJCREGOPT_ARG_NON_VOLATILE

/*--------------------------------------------------------------------------------------------------------------*/
/*	固定レジストリパス																							*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef UNICODE
	#define		AJC_REGPATH_USRENV		AJC_REGPATH_USRENVW
	#define		AJC_REGPATH_SYSENV		AJC_REGPATH_SYSENVW
	#define		AJCMSIL_REGPATH_KEY		AJCMSIL_REGPATH_KEYW
	#define		AJCMSIL_REGPATH_S32		AJCMSIL_REGPATH_S32W
	#define		AJCMSIL_REGPATH_L32		AJCMSIL_REGPATH_L32W
	#define		AJCMSIL_REGPATH_S64		AJCMSIL_REGPATH_S64W
	#define		AJCMSIL_REGPATH_L64		AJCMSIL_REGPATH_L64W
#else
	#define		AJC_REGPATH_USRENV		AJC_REGPATH_USRENVA
	#define		AJC_REGPATH_SYSENV		AJC_REGPATH_SYSENVA
	#define		AJCMSIL_REGPATH_KEY		AJCMSIL_REGPATH_KEYA
	#define		AJCMSIL_REGPATH_S32		AJCMSIL_REGPATH_S32A
	#define		AJCMSIL_REGPATH_L32		AJCMSIL_REGPATH_L32A
	#define		AJCMSIL_REGPATH_S64		AJCMSIL_REGPATH_S64A
	#define		AJCMSIL_REGPATH_L64		AJCMSIL_REGPATH_L64A
#endif

//----- UNICODE ------------------------------------------------------------------------------------------------//
//	カレントユーザ環境変数
#define		AJC_REGPATH_USRENVW			L"Environment"
//	ローカルマシン環境変数
#define		AJC_REGPATH_SYSENVW			L"SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment"
//	.NET Framework アセンブリ参照 レジストリパス
#define		AJCMSIL_REGPATH_KEYW		L"CAjrCustCtrl"
//	WIN32
#define		AJCMSIL_REGPATH_S32W		L"SOFTWARE\\Microsoft\\.NETFramework\\v4.0\\AssemblyFoldersEx"
#define		AJCMSIL_REGPATH_L32W		AJCMSIL_REGPATH_S32 "\\" AJCMSIL_REGPATH_KEY
//	WIN64
#define		AJCMSIL_REGPATH_S64W		L"SOFTWARE\\Wow6432Node\\Microsoft\\.NETFramework\\v4.0\\AssemblyFoldersEx"
#define		AJCMSIL_REGPATH_L64W		AJCMSIL_REGPATH_S64W L"\\" AJCMSIL_REGPATH_KEYW

//----- ANSI ---------------------------------------------------------------------------------------------------//
//	カレントユーザ環境変数
#define		AJC_REGPATH_USRENVA			 "Environment"
//	ローカルマシン環境変数
#define		AJC_REGPATH_SYSENVA			 "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment"
//	.NET Framework アセンブリ参照 レジストリパス
#define		AJCMSIL_REGPATH_KEYA		"CAjrCustCtrl"
//	WIN32
#define		AJCMSIL_REGPATH_S32A		"SOFTWARE\\Microsoft\\.NETFramework\\v4.0\\AssemblyFoldersEx"
#define		AJCMSIL_REGPATH_L32A		AJCMSIL_REGPATH_S32 "\\" AJCMSIL_REGPATH_KEY
//	WIN64
#define		AJCMSIL_REGPATH_S64A		"SOFTWARE\\Wow6432Node\\Microsoft\\.NETFramework\\v4.0\\AssemblyFoldersEx"
#define		AJCMSIL_REGPATH_L64A		AJCMSIL_REGPATH_S64A "\\" AJCMSIL_REGPATH_KEYA

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT VO	 WINAPI	AjcSetRegBinDirA   (C_BCP pBinDir);
AJCEXPORT VO	 WINAPI	AjcGetRegBinDirA   (BCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI AjcGetRegFileUIntA (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, UI	   defValue);
AJCEXPORT SI	 WINAPI AjcGetRegFileSIntA (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, SI	   defValue);
AJCEXPORT UI	 WINAPI AjcGetRegFileHexA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, UI	   defValue);
AJCEXPORT double WINAPI AjcGetRegFileRealA (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, double defValue);
AJCEXPORT ULL	 WINAPI AjcGetRegFileUI64A (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, ULL	defValue);
AJCEXPORT SLL	 WINAPI AjcGetRegFileSI64A (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, SLL	defValue);
AJCEXPORT ULL	 WINAPI AjcGetRegFileH64A  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, ULL	defValue);
AJCEXPORT UI	 WINAPI AjcGetRegFileArrA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, VOP pArray, UI lArray, UI nArray);
AJCEXPORT UI	 WINAPI AjcGetRegFileStrA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI	AjcGetRegFileExpA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI	AjcGetRegFileBinA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, VOP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI	AjcGetRegFileBinExA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, VOP pBuf, UI lBuf, C_BCP pBinDir);

AJCEXPORT BOOL	 WINAPI AjcPutRegFileUIntA (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, UI	   Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileSIntA (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, SI	   Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileHexA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, UI	   Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileRealA (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, double Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileUI64A (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, ULL	Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileSI64A (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, SLL	Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileH64A  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, ULL	Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileArrA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, VOP pArray, UI lArray, UI nArray);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileStrA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_BCP pStr);
AJCEXPORT BOOL	 WINAPI	AjcPutRegFileExpA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_BCP pStr);
AJCEXPORT BOOL	 WINAPI	AjcPutRegFileBinA  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat);
AJCEXPORT BOOL	 WINAPI	AjcPutRegFileBinExA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDatm, C_BCP pBinDir);

AJCEXPORT BOOL	 WINAPI AjcDelRegSectA	   (C_BCP pPath, C_BCP pSecName);
AJCEXPORT BOOL	 WINAPI AjcDelRegSectExA   (C_BCP pPath, C_BCP pSecName 			   , C_BCP pBinDir);
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyA	   (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName);
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyExA	   (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pBinDir);
AJCEXPORT BOOL	 WINAPI AjcCleanupRegSectA (C_BCP pPath, C_BCP pSecName);
AJCEXPORT BOOL	 WINAPI AjcRemoveRegSectA  (C_BCP pPath, C_BCP pSecName);

AJCEXPORT HKEY	 WINAPI AjcGetRegFileInfoA (BCP pBuf, int lBuf);

AJCEXPORT int	 WINAPI AjcEnumRegSectA    (C_BCP pPath				   , UX cbp, BOOL (CALLBACK *cbEnumSect)(C_BCP pSect 				, UX cbp));
AJCEXPORT int	 WINAPI AjcEnumRegKeyA	   (C_BCP pPath, C_BCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumSect)(C_BCP pKey, AJCREGTYPE type, UX cbp));


//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT VO	 WINAPI	AjcSetRegBinDirW   (C_WCP pBinDir);
AJCEXPORT VO	 WINAPI	AjcGetRegBinDirW   (WCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI AjcGetRegFileUIntW (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, UI	   defValue);
AJCEXPORT SI	 WINAPI AjcGetRegFileSIntW (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, SI	   defValue);
AJCEXPORT UI	 WINAPI AjcGetRegFileHexW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, UI	   defValue);
AJCEXPORT double WINAPI AjcGetRegFileRealW (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, double defValue);
AJCEXPORT ULL	 WINAPI AjcGetRegFileUI64W (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, ULL	defValue);
AJCEXPORT SLL	 WINAPI AjcGetRegFileSI64W (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, SLL	defValue);
AJCEXPORT ULL	 WINAPI AjcGetRegFileH64W  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, ULL	defValue);
AJCEXPORT UI	 WINAPI AjcGetRegFileArrW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, VOP pArray, UI lArray, UI nArray);
AJCEXPORT UI	 WINAPI AjcGetRegFileStrW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI	AjcGetRegFileExpW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI	AjcGetRegFileBinW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, VOP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI	AjcGetRegFileBinExW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, VOP pBuf, UI lBuf, C_WCP pBinDir);

AJCEXPORT BOOL	 WINAPI AjcPutRegFileUIntW (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, UI	   Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileSIntW (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, SI	   Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileHexW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, UI	   Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileRealW (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, double Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileUI64W (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, ULL	Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileSI64W (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, SLL	Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileH64W  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, ULL	Value);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileArrW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, VOP pArray, UI lArray, UI nArray);
AJCEXPORT BOOL	 WINAPI AjcPutRegFileStrW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_WCP pStr);
AJCEXPORT BOOL	 WINAPI	AjcPutRegFileExpW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_WCP pStr);
AJCEXPORT BOOL	 WINAPI	AjcPutRegFileBinW  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat);
AJCEXPORT BOOL	 WINAPI	AjcPutRegFileBinExW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat, C_WCP pBinDir);

AJCEXPORT BOOL	 WINAPI AjcDelRegSectW	   (C_WCP pPath, C_WCP pSecName);
AJCEXPORT BOOL	 WINAPI AjcDelRegSectExW   (C_WCP pPath, C_WCP pSecName 			   , C_WCP pBinDir);
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyW	   (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName);
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyExW	   (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pBinDir);
AJCEXPORT BOOL	 WINAPI AjcCleanupRegSectW (C_WCP pPath, C_WCP pSecName);
AJCEXPORT BOOL	 WINAPI AjcRemoveRegSectW  (C_WCP pPath, C_WCP pSecName);
AJCEXPORT HKEY	 WINAPI AjcGetRegFileInfoW (WCP pBuf, int lBuf);

AJCEXPORT int	 WINAPI AjcEnumRegSectW    (C_WCP pPath				   , UX cbp, BOOL (CALLBACK *cb)(C_WCP pSect 				, UX cbp));
AJCEXPORT int	 WINAPI AjcEnumRegKeyW	   (C_WCP pPath, C_WCP pSecName, UX cbp, BOOL (CALLBACK *cb)(C_WCP pKey, AJCREGTYPE type, UX cbp));


//----- 共通 ---------------------------------------------------------------------------------------------------//
AJCEXPORT HKEY	 WINAPI	AjcSetRegTopKey(HKEY hKey);
AJCEXPORT HKEY	 WINAPI	AjcGetRegTopKey(VO);
AJCEXPORT VO	 WINAPI AjcCloseRegFile(VO);

//----- レジストリ直接アクセス ---------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegGetA				(HKEY hTop, C_BCP pPath, C_BCP pKey, PAJCREGTYPE pType, VOP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcRegGetW				(HKEY hTop, C_WCP pPath, C_WCP pKey, PAJCREGTYPE pType, VOP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI	AjcRegPutA				(HKEY hTop, C_BCP pPath, C_BCP pKey, AJCREGTYPE type, C_VOP pDat, UI lDat);
AJCEXPORT	BOOL	WINAPI	AjcRegPutW				(HKEY hTop, C_WCP pPath, C_WCP pKey, AJCREGTYPE type, C_VOP pDat, UI lDat);

AJCEXPORT	BOOL	WINAPI	AjcRegDelSubKeyA		(HKEY hTop, C_BCP pPath, C_BCP pSubKey);
AJCEXPORT	BOOL	WINAPI	AjcRegDelSubKeyW		(HKEY hTop, C_WCP pPath, C_WCP pSubKey);

AJCEXPORT	BOOL	WINAPI	AjcRegDelValueA			(HKEY hTop, C_BCP pPath, C_BCP pKey);
AJCEXPORT	BOOL	WINAPI	AjcRegDelValueW			(HKEY hTop, C_WCP pPath, C_WCP pKey);

AJCEXPORT	UI		WINAPI	AjcRegEnvGetA			(C_BCP pName, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcRegEnvGetW			(C_WCP pName, WCP pBuf, UI lBuf);

AJCEXPORT	UI		WINAPI	AjcRegHkCuEnvGetA		(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcRegHkCuEnvGetW		(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf);

AJCEXPORT	UI		WINAPI	AjcRegHkLmEnvGetA		(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI	AjcRegHkLmEnvGetW		(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI	AjcRegEnvPutA			(C_BCP pName, C_BCP pTxt);
AJCEXPORT	BOOL	WINAPI	AjcRegEnvPutW			(C_WCP pName, C_WCP pTxt);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvPutA		(C_BCP pName, AJCREGTYPE type, C_BCP pTxt);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvPutW		(C_WCP pName, AJCREGTYPE type, C_WCP pTxt);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvPutA		(C_BCP pName, AJCREGTYPE type, C_BCP pTxt);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvPutW		(C_WCP pName, AJCREGTYPE type, C_WCP pTxt);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelA		(C_BCP pName);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelW		(C_WCP pName);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelA		(C_BCP pName);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelW		(C_WCP pName);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhItemA	(C_BCP pName, C_BCP pItem, BC Dlm);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhItemW	(C_WCP pName, C_WCP pItem, WC Dlm);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddItemA	(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fFront, AJCREGTYPE type);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddItemW	(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fFront, AJCREGTYPE type);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhItemA	(C_BCP pName, C_BCP pItem, BC Dlm);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhItemW	(C_WCP pName, C_WCP pItem, WC Dlm);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddItemA	(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fFront, AJCREGTYPE type);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddItemW	(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fFront, AJCREGTYPE type);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhPathItemA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhPathItemW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhPathItemA(C_BCP pPath);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhPathItemW(C_WCP pPath);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddPathItemA(C_BCP pPath, BOOL fFront, AJCREGTYPE type);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddPathItemW(C_WCP pPath, BOOL fFront, AJCREGTYPE type);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddPathItemA(C_BCP pPath, BOOL fFront, AJCREGTYPE type);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddPathItemW(C_WCP pPath, BOOL fFront, AJCREGTYPE type);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelItemA	(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fErase);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelItemW	(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fErase);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelItemA	(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fErase);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelItemW	(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fErase);

AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelPathItemA(C_BCP pPath, BOOL fErase);
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelPathItemW(C_WCP pPath, BOOL fErase);

AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelPathItemA(C_BCP pPath, BOOL fErase);
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelPathItemW(C_WCP pPath, BOOL fErase);

AJCEXPORT	VO		WINAPI	AjcRegEnableEnvironment(VO);

AJCEXPORT	BOOL	WINAPI	AjcRegIsPathExistA	  (HKEY hTop, C_BCP pPath, UIP pErr);
AJCEXPORT	BOOL	WINAPI	AjcRegIsPathExistW	  (HKEY hTop, C_WCP pPath, UIP pErr);

AJCEXPORT	BOOL	WINAPI	AjcRegIsKeyExistA	  (HKEY hTop, C_BCP pPath, C_BCP pKey, UIP pErr);
AJCEXPORT	BOOL	WINAPI	AjcRegIsKeyExistW	  (HKEY hTop, C_WCP pPath, C_WCP pKey, UIP pErr);

//----- ＭＳＩＬ用サポートコード -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcEnvAddPathItemW(C_WCP pPath, BOOL fFront);
AJCEXPORT	BOOL	WINAPI	AjcEnvDelPathItemW(C_WCP pPath);

/****************************************************************************************************************/
#endif
