﻿#ifndef	AJCSBCCOMBOBOX_H_
#define	AJCSBCCOMBOBOX_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	項目の最大文字列長（文字列終端を含む長さ）																	//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCSBC_MAXSTL		512

//--------------------------------------------------------------------------------------------------------------//
//	通知メッセージ																								//
//--------------------------------------------------------------------------------------------------------------//
//			HIWORD(wParam)									lParam
#define		AJCCBN_REMOVED		(WM_APP + 100)		//		削除した項目数
#define		AJCCBN_DROPPED		(WM_APP + 101)		//		ドロップした個数

//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcSbcComboBox			AjcSbcComboBoxW
	#define	AjcSbcComboBoxEx		AjcSbcComboBoxExW
	#define	AjcSbcLoadItems			AjcSbcLoadItemsW
	#define	AjcSbcSaveItems			AjcSbcSaveItemsW
	#define	AjcSbcShowFirstLine		AjcSbcShowFirstLineW
	#define	AjcSbcGetRemovedItem	AjcSbcGetRemovedItemW
#else
	#define	AjcSbcComboBox			AjcSbcComboBoxA
	#define	AjcSbcComboBoxEx		AjcSbcComboBoxExA
	#define	AjcSbcLoadItems			AjcSbcLoadItemsA
	#define	AjcSbcSaveItems			AjcSbcSaveItemsA
	#define	AjcSbcShowFirstLine		AjcSbcShowFirstLineA
	#define	AjcSbcGetRemovedItem	AjcSbcGetRemovedItemA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	フラグ																										//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCSBCF_IGNORWIDTH		0x0080									//	大文字小文字を区別しないで比較
#define		AJCSBCF_DROPFILE		0x0040									//	ファイルのドロップを許可
#define		AJCSBCF_DROPDIR			0x0020									//	フォルダのドロップを許可
#define		AJCSBCF_DROPBOTH		(AJCSBCF_DROPFILE | AJCSBCF_DROPDIR)	//	ファイルとフォルダのドロップを許可
#define		AJCSBCF_DIRTAIL			0x0010									//	ドロップしたフォルダの末尾に「\」を付加
#define		AJCSBCF_TIPINSEL		0x0008									//	リスト選択中のチップ制御
#define		AJCSBCF_LONGTIP			0x0004									//	長テキスト時のチップ表示

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxA	  (HWND hwnd, UI MaxItem, UI LimitText);
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxExA (HWND hwnd, UI MaxItem, UI LimitText, UI flag);

AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxW	  (HWND hwnd, UI MaxItem, UI LimitText);
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxExW (HWND hwnd, UI MaxItem, UI LimitText, UI flag);

AJCEXPORT BOOL	 WINAPI	AjcSbcSetCompExact(HWND hwnd, BOOL fExact);

AJCEXPORT BOOL	 WINAPI	AjcSbcLoadItemsA  (HWND hwnd, C_BCP pSect);
AJCEXPORT BOOL	 WINAPI	AjcSbcLoadItemsW  (HWND hwnd, C_WCP pSect);

AJCEXPORT BOOL	 WINAPI	AjcSbcSaveItemsA  (HWND hwnd, C_BCP pSect);
AJCEXPORT BOOL	 WINAPI	AjcSbcSaveItemsW  (HWND hwnd, C_WCP pSect);


AJCEXPORT HWND	 WINAPI	AjcSbcComboBoxCreateDlg		(HWND hwnd, UI id, UI style, BOOL fSort, UI MaxItem, UI LimitText);
AJCEXPORT HWND	 WINAPI	AjcSbcComboBoxGetCtrl		(HWND hDlg);
AJCEXPORT HWND	 WINAPI	AjcSbcGetEditCtrlInComboBox	(HWND hwnd);
AJCEXPORT BOOL	 WINAPI	AjcSbcSetMostNew			(HWND hwnd);

AJCEXPORT BOOL	 WINAPI	AjcSbcTipCtrl				(HWND hwnd, BOOL fTipCtrl);

AJCEXPORT BOOL	 WINAPI	AjcSbcEnableLongTip			(HWND hwnd, BOOL fEnable);

AJCEXPORT BOOL	 WINAPI	AjcSbcShowFirstLineA		(HWND hwnd, C_BCP pCharExclude);
AJCEXPORT BOOL	 WINAPI	AjcSbcShowFirstLineW		(HWND hwnd, C_WCP pCharExclude);

AJCEXPORT BOOL	 WINAPI AjcSbcGetRemovedItemA  (HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	 WINAPI AjcSbcGetRemovedItemW  (HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL	 WINAPI	AjcSbcSetTextEncode(HWND hwnd, EAJCTEC	 iTec, EAJCTEC	 oTec, BOOL   fBOM);
AJCEXPORT BOOL	 WINAPI	AjcSbcGetTextEncode(HWND hwnd, PEAJCTEC piTec, PEAJCTEC poTec, BOOL *pfBOM);

/****************************************************************************************************************/
#endif
