﻿#ifndef	AJCSEPSTREAM_H_
#define	AJCSEPSTREAM_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcSsepCreate	AjcSsepCreateW
	#define	AjcSsepPutText	AjcSsepPutTextW
#else
	#define	AjcSsepCreate	AjcSsepCreateA
	#define	AjcSsepPutText	AjcSsepPutTextA
#endif
//--------------------------------------------------------------------------------------------------------------//
//	イベントコード																								//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCSSEP_EV_TXT		0x01				//	テキストデータ通知
#define	AJCSSEP_EV_ESC		0x02				//	ＥＳＣコードデータ通知
#define	AJCSSEP_EV_PKT		0x04				//	パケットデータ通知
#define	AJCSSEP_EV_CTRL		0x08				//	制御コード通知
#define	AJCSSEP_EV_NOPKT	0x10				//	パケット外バイトデータ

#define	AJCSSEP_EV_ALL	(AJCSSEP_EV_TXT | AJCSSEP_EV_ESC | AJCSSEP_EV_PKT | AJCSSEP_EV_CTRL | AJCSSEP_EV_NOPKT)

//--------------------------------------------------------------------------------------------------------------//
//	処理モード																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCSSEP_MD_IDLE	= 0	,					//	アイドル状態
	AJCSSEP_MD_TXT		,					//	テキストデータ生成中
	AJCSSEP_MD_ESC		,					//	ＥＳＣコードデータ生成中
	AJCSSEP_MD_PKT							//	パケットデータ生成中
} AJCSSEP_MODE;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCSSEP_BUFSIZE	1024

typedef  struct {
	UI				InstID;						//	インスタンスＩＤ
	AJCSSEP_MODE	Mode;						//	処理モード

	UI				evt;						//	生成するイベント

	BOOL			fUnicode;					//	UNICODEフラグ
	BOOL			fDle;						//	ＤＬＥの直後を示すフラグ
	BC				TxtIncMap[256];				//	テキストに含める制御コードマップ
	BC				stx, etx, dle;				//	パケット分離用制御コード

	UI				PktTimSrt;					//	最後のパケットデータバイトを設定した時刻
	UI				PktTimOut;					//	パケットデータのタイムアウト値［ms］

	HAJCMBC			hMbc;						//	文字コード判定用ハンドル
	AJCMBCKIND		SvMbk;						//	文字コード種別の退避

	HAJCRNG			hRng;						//	データ・バッファ・ハンドル
	UB				RngBuf[AJCSSEP_BUFSIZE];	//	データ用 スタティックバッファ

	BOOL				fMultiThread;			//	排他制御フラグ
	CRITICAL_SECTION	cs;						//	クリティカルセクション・オブジェクト

	UX			cbp;							//	コールバックパラメタ
	BOOL (CALLBACK *cbEvent)(UI evt, VOP pDat, UI lDat, UX cbp);

} AJCSSEP, *HAJCSSEP;
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSSEP	WINAPI	AjcSsepCreateA(UI evt, UX cbp, BOOL (CALLBACK *cbEvent)(UI evt, VOP pDat, UI lDat, UX cbp));
AJCEXPORT	HAJCSSEP	WINAPI	AjcSsepCreateW(UI evt, UX cbp, BOOL (CALLBACK *cbEvent)(UI evt, VOP pDat, UI lDat, UX cbp));

AJCEXPORT	VO			WINAPI	AjcSsepDelete(HAJCSSEP hSsep);
AJCEXPORT	BOOL		WINAPI	AjcSsepEnableMultiThread(HAJCSSEP hSsep, BOOL fEnable);

AJCEXPORT	AJCSSEP_MODE WINAPI	AjcSsepPutData	(HAJCSSEP hSsep, C_UBP pDat, UI lDat);

AJCEXPORT	AJCSSEP_MODE WINAPI	AjcSsepPutTextA	(HAJCSSEP hSsep, C_BCP pTxt, UI lTxt);
AJCEXPORT	AJCSSEP_MODE WINAPI	AjcSsepPutTextW	(HAJCSSEP hSsep, C_WCP pTxt, UI lTxt);

AJCEXPORT	VO	 		WINAPI	AjcSsepReset	(HAJCSSEP hSsep);
AJCEXPORT	VO			WINAPI	AjcSsepSetEvent (HAJCSSEP hSsep, UI evt);
AJCEXPORT	UI			WINAPI	AjcSsepGetEvent (HAJCSSEP hSsep);

AJCEXPORT	VO			WINAPI	AjcSsepSetIncTxt(HAJCSSEP pW, UI num, ...);
AJCEXPORT	VO			WINAPI	AjcSsepSetStx	(HAJCSSEP hSsep, UI stx);
AJCEXPORT	VO			WINAPI	AjcSsepSetEtx	(HAJCSSEP hSsep, UI etx);
AJCEXPORT	VO			WINAPI	AjcSsepSetDle	(HAJCSSEP hSsep, UI dle);
AJCEXPORT	VO			WINAPI	AjcSsepSetPktTimeOut(HAJCSSEP hSsep, UI time);

AJCEXPORT	UI			WINAPI	AjcSsepGetStx	(HAJCSSEP hSsep);
AJCEXPORT	UI			WINAPI	AjcSsepGetEtx	(HAJCSSEP hSsep);
AJCEXPORT	UI			WINAPI	AjcSsepGetDle	(HAJCSSEP hSsep);
AJCEXPORT	UI			WINAPI	AjcSsepGetPktTimeOut(HAJCSSEP hSsep);

AJCEXPORT	VOP			WINAPI	AjcSsepMakePacket(HAJCSSEP hSsep, C_VOP pDat, UI lDat, UIP pBytes);
AJCEXPORT	VO			WINAPI	AjcSsepRelease	 (VOP pMemBlk);

//	文字コード判定機能
AJCEXPORT	VO			WINAPI	AjcSsepPutMbc		 (HAJCSSEP hSsep, C_BCP pTxt);
AJCEXPORT	AJCMBCKIND	WINAPI	AjcSsepGetMbcKind	 (HAJCSSEP hSsep);
AJCEXPORT	AJCMBCKIND	WINAPI	AjcSsepGetLastMbcKind(HAJCSSEP hSsep);
AJCEXPORT	VO	 		WINAPI	AjcSsepMbcReset		 (HAJCSSEP hSsep);

/****************************************************************************************************************/
#endif
