﻿#ifndef	AJCSPHEREDATA_H_
#define	AJCSPHEREDATA_H_
/****************************************************************************************************************/

//	球データ生成パラメタ
typedef struct {
	AJC3DVEC		vCent;				//	球中心
	double			radius;				//	球半径
	double			noise;				//	半径の誤差（±％）
	double			xrot;				//	回転軸のＸ軸回転角度・最大値（０～最大値［度］）
	double			yrot;				//	回転軸のＹ軸回転角度・最大値（０～最大値［度］）
	double			pitch;				//	プロット点の回転角度・最大値（０～最大値［度］）
} AJCSPD_PARAM, *PAJCSPD_PARAM;
typedef const AJCSPD_PARAM *PCAJCSPD_PARAM;


//	インスタンスワーク
typedef struct {
	AJCSPD_PARAM	param;				//	パラメタ
	AJC3DVEC		vAxis;				//	回転軸
	AJC3DVEC		vPt;				//	プロット点（中心を(0, 0, 0)としたプロット点）
	int				cnt;				//	演算回数カウンタ
} AJCSPD, *HAJCSPD;


//	プロトタイプ
AJCEXPORT	HAJCSPD	WINAPI	AjcSpdCreate(UI seed);
AJCEXPORT	BOOL	WINAPI	AjcSpdDelete(HAJCSPD hSpd);
AJCEXPORT	BOOL	WINAPI	AjcSpdSetParam(HAJCSPD hSpd, PCAJCSPD_PARAM pParam);
AJCEXPORT	BOOL	WINAPI	AjcSpdGetParam(HAJCSPD hSpd, PAJCSPD_PARAM	pBuf);
AJCEXPORT	BOOL	WINAPI	AjcSpdCalc (HAJCSPD hSpd, double *x, double *y, double *z);
AJCEXPORT	BOOL	WINAPI	AjcSpdCalcV(HAJCSPD hSpd, PAJC3DVEC pBuf);

/****************************************************************************************************************/
#endif
