﻿#ifndef		AJCSTATECTRL_H_
#define		AJCSTATECTRL_H_
//**************************************************************************************************************//
//==============================================================================================================//
//	状態遷移制御テーブル形式																					//
//==============================================================================================================//
//----- 一般定数 -----------------------------------------------------------------------------------------------//
#define		AJCSTC_MAX_PSF		6			//	最大プリセットファンクション数
#define		AJCSTC_MAX_STS		0xFFFE		//	最大状態番号

#define		AJCSTC_NOCHG		0xFFFF		//	状態遷移なし
#define		AJCSTC_NOPSF		0xFF		//	プリセットファンクションなし

#define		AJCSTC_TIM_CTL		0xC000		//	タイマコントロール情報
#define		AJCSTC_TIM_NOACT	0x0000		//		無制御
#define		AJCSTC_TIM_START	0x4000		//		タイマ起動
#define		AJCSTC_TIM_STOP		0x8000		//		タイマ停止
#define		AJCSTC_TIM_CYC		0xC000		//		サイクリックタイマ起動

//--------------------------------------------------------------------------------------------------------------//
//	状態遷移制御テーブル																						//
//--------------------------------------------------------------------------------------------------------------//
//----- 他の状態へ遷移する時／当該状態へ遷移する時のアクションテーブル形式 -------------------------------------//
typedef  struct  _AJCSTC_STSACT	{
	UW		tmc;							//	タイマ制御情報
	UB		pft[AJCSTC_MAX_PSF];			//	プリセットファンクション番号
} AJCSTC_STSACT, *PAJCSTC_STSACT;
typedef const AJCSTC_STSACT *PCAJCSTC_STSACT;

//----- イベントアクションテーブル形式 （フリーファンクションなし）---------------------------------------------//
typedef  struct  _AJCSTC_EVT_NF {
	UW		sts;					//	遷移先状態番号 (AJCSTC_NOCHG : 状態遷移しない)	
	UW		tmc;					//	タイマ制御情報
	UB		pft[AJCSTC_MAX_PSF];	//	プリセットファンクション番号
} AJCSTC_EVT_NF, *PAJCSTC_EVT_NF;
typedef const AJCSTC_EVT_NF *PCAJCSTC_EVT_NF;

//--------------------------------------------------------------------------------------------------------------//
//	タイマ情報																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCSTC_MAX_TMINFO	8
typedef struct {
	UI		msTime;					//	タイマ値[ms]
	int		EvtCode;				//	タイムアウト・イベントコード（-1:イベント無し）
} AJCSTC_TMINFO, *PAJCSTC_TMINFO;
typedef const AJCSTC_TMINFO *PCAJCSTC_TMINFO;

//--------------------------------------------------------------------------------------------------------------//
//	通知コード																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {						//	ntc					p1						p2
	AJCSTC_NTC_EVT	= 1	,			//	イベント実行		状態コード				イベントコード
	AJCSTC_NTC_STS		,			//	状態変化			状態コード
	AJCSTC_NTC_TIMSRT	,			//	タイマスタート		タイマＩＤ				タイマ値
	AJCSTC_NTC_TIMSTP	,			//	タイマストップ		タイマＩＤ				－
} AJCSTC_NTC;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCSTC_MAX_EVT	64
typedef struct {
	HWND			hwnd;											//	タイマ生成用ウインドハンドル
	BOOL			fBusy;											//	イベント処理中フラグ
	int				CurSts;											//	現在の状態
	int				nState;											//	状態の個数
	PCAJCSTC_STSACT	pCom;											//	他の状態から当該状態へ遷移時のアクションテーブル
	PCAJCSTC_STSACT	pRel;											//	当該状態から他の状態へ遷移時のアクションテーブル
	PCAJCSTC_EVT_NF pEvt;											//	イベントアクションテーブル
	AJCSTC_TMINFO	TmInfo [AJCSTC_MAX_TMINFO];						//	タイマ情報
	UB				fCyclic[AJCSTC_MAX_TMINFO];						//	サイクリックタイマ フラグ
	UI				six, eix;										//	イベントバッファ・インデクス
	int				EvtBuf[AJCSTC_MAX_EVT];							//	イベントバッファ
	UX				cbp;											//	コールバックパラメタ
	VO (CALLBACK *cbPsf)(UI pno, int sts, UX cbp);					//	プリセットファンクション通知用コールバック
	VO (CALLBACK *cbNtc)(AJCSTC_NTC ntc, UL p1, UL p2, UX cbp);		//	状態遷移制御通知用コールバック
} AJCSTC, *HAJCSTC;

//==============================================================================================================//
//	テーブル作成用シンボル																						//
//==============================================================================================================//
//----- 状態遷移 -----------------------------------------------------------------------------------------------//
#define		AJCSTC_STS___		AJCSTC_NOCHG		//	__ : 状態遷移なし

//----- タイマ制御 ---------------------------------------------------------------------------------------------//
#define		AJCSTC_TM__		AJCSTC_TIM_NOACT		//	_  : 無制御
#define		AJCSTC_TM_S		AJCSTC_TIM_START		//	S  : タイマ起動
#define		AJCSTC_TM_R		AJCSTC_TIM_STOP			//	R  : タイマ停止
#define		AJCSTC_TM_C		AJCSTC_TIM_CYC			//	C  : サイクリックタイマ起動

//----- プリセットファンクション -------------------------------------------------------------------------------//
#define		AJCSTC_PF___		AJCSTC_NOPSF		//	__       : プリセットファンクションなし

//----- 各アイテム定義用 ---------------------------------------------------------------------------------------//
#define		AJCSM(a)				AJCSTC_STS_##a

#define		AJCTM(a,b,c,d)			(AJCSTC_TM_##a >> 0) | (AJCSTC_TM_##b >>  2) | (AJCSTC_TM_##c >>  4) | (AJCSTC_TM_##d >>  6)

#define		AJCTM6(a,b,c,d,e,f)	 	(AJCSTC_TM_##a >> 0) | (AJCSTC_TM_##b >>  2) | (AJCSTC_TM_##c >>  4) | (AJCSTC_TM_##d >>  6) | \
									(AJCSTC_TM_##e >> 8) | (AJCSTC_TM_##f >> 10)

#define		AJCTM8(a,b,c,d,e,f,g,h)	(AJCSTC_TM_##a >> 0) | (AJCSTC_TM_##b >>  2) | (AJCSTC_TM_##c >>  4) | (AJCSTC_TM_##d >>  6) | \
									(AJCSTC_TM_##e >> 8) | (AJCSTC_TM_##f >> 10) | (AJCSTC_TM_##g >> 12) | (AJCSTC_TM_##h >> 14)

#define		AJCPF(a,b,c,d,e,f)		{AJCSTC_PF_##a, AJCSTC_PF_##b, AJCSTC_PF_##c, AJCSTC_PF_##d, AJCSTC_PF_##e, AJCSTC_PF_##f}

//==============================================================================================================//
//	プロトタイプ																								//
//==============================================================================================================//
AJCEXPORT HAJCSTC	WINAPI AjcStcCreate(PCAJCSTC_STSACT pCom,
										PCAJCSTC_STSACT pRel,
										PCAJCSTC_EVT_NF pEvt,
										int             nState,
										UX              cbp ,
										VO (CALLBACK *cbPsf)(UI pno, int sts, UX cbp),
										VO (CALLBACK *cbNtc)(AJCSTC_NTC ntc, UL p1, UL p2, UX cbp));

AJCEXPORT VO		WINAPI AjcStcDelete(HAJCSTC hSTc);

AJCEXPORT BOOL		WINAPI AjcStcSetTimerInfo   (HAJCSTC hSTc, UI tid, UI msTime, int EvtCode);
AJCEXPORT BOOL		WINAPI AjcStcTimerStart     (HAJCSTC pW, UI tid);
AJCEXPORT BOOL		WINAPI AjcStcTimerStop      (HAJCSTC pW, UI tid);
AJCEXPORT int		WINAPI AjcStcGetCurrentState(HAJCSTC hSTc);
AJCEXPORT BOOL		WINAPI AjcStcSetCurrentState(HAJCSTC hSTc, int sts);
AJCEXPORT int 		WINAPI AjcStcExecEvent      (HAJCSTC hSTc, int evt);
AJCEXPORT VO 		WINAPI AjcStcPurge          (HAJCSTC hSTc);


//**************************************************************************************************************//
#endif
