﻿#ifndef	AJCTEXTFILE_H_
#define	AJCTEXTFILE_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define		AjcFOpen			AjcFOpenW
	#define		AjcFOpenShare		AjcFOpenShareW
	#define		AjcFGetS			AjcFGetSW
	#define		AjcFGetSEx			AjcFGetSExW
	#define		AjcFGetC			AjcFGetCW
	#define		AjcFGetCode			AjcFGetCodeW
	#define		AjcFGetPoint		AjcFGetPointW
	#define		AjcFGetBytePoint	AjcFGetBytePointW
	#define		AjcFSavePoint		AjcFSavePointW
	#define		AjcFCreate			AjcFCreateW
	#define		AjcFCreateShare		AjcFCreateShareW
	#define		AjcFAppend			AjcFAppendW
	#define		AjcFAppendShare		AjcFAppendShareW
	#define		AjcFPutS			AjcFPutSW
	#define		AjcFPutC			AjcFPutCW
	#define		AjcFPutCode			AjcFPutCodeW
	#define		AjcFPrintF			AjcFPrintFW
	#define		AjcFVPrintF			AjcFVPrintFW
	#define		AjcFTecDialog		AjcFTecDialogW
#else
	#define		AjcFOpen			AjcFOpenA
	#define		AjcFOpenShare		AjcFOpenShareA
	#define		AjcFGetS			AjcFGetSA
	#define		AjcFGetSEx			AjcFGetSExA
	#define		AjcFGetC			AjcFGetCA
	#define		AjcFGetCode			AjcFGetCodeA
	#define		AjcFGetPoint		AjcFGetPointA
	#define		AjcFGetBytePoint	AjcFGetBytePointW
	#define		AjcFSavePoint		AjcFSavePointA
	#define		AjcFCreate			AjcFCreateA
	#define		AjcFCreateShare		AjcFCreateShareA
	#define		AjcFAppend			AjcFAppendA
	#define		AjcFAppendShare		AjcFAppendShareA
	#define		AjcFPutS			AjcFPutSA
	#define		AjcFPutC			AjcFPutCA
	#define		AjcFPutCode			AjcFPutCodeA
	#define		AjcFPrintF			AjcFPrintFA
	#define		AjcFVPrintF			AjcFVPrintFA
	#define		AjcFTecDialog		AjcFTecDialogA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	改行コード変換モード																						//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCFLF_NONE				= 0	,		//	変換無し

	AJCFLF_LF_TO_CRLF			,		//	ＬＦ → ＣＲ，ＬＦ（ファイル書き込み時のデフォルト）
	AJCFLF_LF_TO_CR				,		//	ＬＦ → ＣＲ

	AJCFLF_CR_TO_CRLF			,		//	ＣＲ → ＣＲ，ＬＦ
	AJCFLF_CR_TO_LF				,		//	ＣＲ → ＬＦ

	AJCFLF_CRLF_TO_LF			,		//	ＣＲ，ＬＦ → ＬＦ（ファイル読み出し時のデフォルト）
	AJCFLF_CRLF_TO_CR			,		//	ＣＲ，ＬＦ → ＣＲ

	AJCFLF_LF					,		//	ＬＦで改行，変換無し
	AJCFLF_CR					,		//	ＣＲで改行，変換無し
	AJCFLF_LF_CRSKIP			,		//	ＬＦで改行，ＣＲ除去
	AJCFLF_CR_LFSKIP			,		//	ＣＲで改行，ＬＦ除去

} AJCFLFCONV, *PAJCFLFCONV;

#define		AJCFLFCONV_MIN	AJCFLF_NONE
#define		AJCFLFCONV_MAX	AJCFLF_CR_LFSKIP


//----- 入力改行モード -----------------------------------------------------------------------------------------//
typedef enum {
	AJCFILF_LF			= 1	,	//	ＬＦで改行，ＣＲは読み飛ばす
	AJCFILF_LF_CROUT		,	//	ＬＦで改行，ＣＲはそのまま出力
	AJCFILF_CR				,	//	ＣＲで改行，ＬＦは読み飛ばす
	AJCFILF_CR_LFOUT		,	//	ＣＲで改行．ＬＦはそのまま出力
} AJCFINP_LFMODE, *PAJCFINP_LFMODE;

#define	AJCFILF_MIN		AJCFILF_LF
#define	AJCFILF_MAX		AJCFILF_CR_LFOUT

//----- 出力改行モード -----------------------------------------------------------------------------------------//
typedef enum {
	AJCFOLF_CRLF		= 1	,	//	改行コード＝ＣＲ，ＬＦを出力
	AJCFOLF_LF				,	//	改行コード＝ＬＦを出力
	AJCFOLF_CR				,	//	改行コード＝ＣＲを出力
} AJCFOUT_LFMODE, *PAJCFOUT_LFMODE;

#define	AJCFOLF_MIN		AJCFOLF_CRLF
#define	AJCFOLF_MAX		AJCFOLF_CR

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCTF_MAX_BUFW		1024
#define	AJCTF_MAX_BUFA		(AJCTF_MAX_BUFW * 2)

typedef union {
	BCP			bcp;
	WCP			wcp;
	VOP			vop;
} AJCFUPTR;

typedef struct {
	UI				iid;					//	インスタンスＩＤ
	AJCFLFCONV		LfCnv;					//	改行コード変換モード
	HANDLE			hFile;					//	ファイルハンドル
	EAJCTEC			tec;					//	テキストエンコード種別（UTF-16の場合は、AJCTEC_MBCを設定）
	BOOL			fInp;					//	入出力モード（FALSE:Output, TRUE:Input)

	//--- ファイル読み出し情報 ------------------------------------------------------//
	ULL				FSizeA;					//	ファイルサイズ（バイト数）
	ULL				FSizeW;					//	ファイルサイズ（文字数）
	ULL				FIx;					//	ファイルインデクス（読み出しバイト位置／文字位置）
	HANDLE			hMap;					//	ファイルマッピングハンドル

	AJCFUPTR		pInpTop;				//	ファイルマッピング先頭アドレス
	AJCFUPTR 		pInp;					//	ファイルマッピング読み出しポインタ

	BOOL			fExistBOM;				//	入力ファイルのＢＯＭ有無フラグ

	UI				lFmtBuf;				//	書式文字列用バッファ長（文字数）
	AJCFUPTR		pFmtBuf;				//	書式文字列用バッファポインタ

	BC				szLfA[3];				//	改行文字コード（バイト文字ファイル用）
	WC				szLfW[3];				//	改行文字コード（ワイド文字ファイル用）

	//--- ファイル書き込み情報 ------------------------------------------------------//
	BOOL			fBomOut;				//	ＢＯＭ出力フラグ（出力後クリアー）
	UI				SvOutC;					//	書き込みテキストのマルチバイト１バイト目／サロゲート１文字目退避（－１：退避なし）

	//--- ファイル書き込み／１文字入力用バッファ ------------------------------------//
	UI				BufBytes;				//	バッファに格納されているテキストのバイト数
	UI				BufChars;				//	バッファに格納されているテキストのバイト数／文字数
	UI				ixBuf;					//	バッファインデクス
	ULL				BufFIx;					//	バッファ先頭に対応するファイルインデクス（読み出しバイト位置／文字位置）
	union {									//	AjcFGetC()用読み出しバッファ
		BC			mbc[AJCTF_MAX_BUFA];	//	バッファ（バイト文字）
		WC			uni[AJCTF_MAX_BUFW];	//	バッファ（ワイド文字）
	} buf;

	//----- ファイル読み出しポインタ退避情報 ----------------------------------------//
	ULL				Sv_FIx;					//	ファイルインデクス退避
	AJCFUPTR		Sv_pInp;				//	ファイルマッピング読み出しポインタ

	//----- コールバック ------------------------------------------------------------//
	UX		cbp;									//	コールバックパラメタ
	BOOL	(CALLBACK *cbNtcRPos)(ULL pos, UX cbp);	//	読み出し済み文字数通知

} AJCFILE, *HAJCFILE;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
//	テキストファイル入力
AJCEXPORT	HAJCFILE	WINAPI	AjcFOpenA	(C_BCP pPath, EAJCTEC tec);
AJCEXPORT	HAJCFILE	WINAPI	AjcFOpenW	(C_WCP pPath, EAJCTEC tec);

AJCEXPORT	HAJCFILE	WINAPI	AjcFOpenShareA(C_BCP pPath, EAJCTEC tec, UI share);
AJCEXPORT	HAJCFILE	WINAPI	AjcFOpenShareW(C_WCP pPath, EAJCTEC tec, UI share);

AJCEXPORT	HAJCFILE	WINAPI	AjcFAttachOpened	(HANDLE hFile, EAJCTEC tec);

AJCEXPORT	BCP			WINAPI	AjcFGetSA	(HAJCFILE hFile, BCP pBuf, UI lBuf);
AJCEXPORT	WCP			WINAPI	AjcFGetSW	(HAJCFILE hFile, WCP pBuf, UI lBuf);

AJCEXPORT	BCP			WINAPI	AjcFGetSExA	(HAJCFILE hFile, BCP pBuf, UI lBuf, UX cbp, BOOL (CALLBACK *cbNtcRPos)(ULL pos, UX cbp));
AJCEXPORT	WCP			WINAPI	AjcFGetSExW	(HAJCFILE hFile, WCP pBuf, UI lBuf, UX cbp, BOOL (CALLBACK *cbNtcRPos)(ULL pos, UX cbp));

AJCEXPORT	BC			WINAPI	AjcFGetCA	(HAJCFILE hFile);
AJCEXPORT	WC			WINAPI	AjcFGetCW	(HAJCFILE hFile);

AJCEXPORT	UI			WINAPI	AjcFGetCodeA(HAJCFILE hFile);
AJCEXPORT	UI			WINAPI	AjcFGetCodeW(HAJCFILE hFile);

AJCEXPORT	ULL			WINAPI	AjcFGetPointA(HAJCFILE pW);
AJCEXPORT	ULL			WINAPI	AjcFGetPointW(HAJCFILE pW);

AJCEXPORT	ULL			WINAPI	AjcFGetBytePointA(HAJCFILE pW);
AJCEXPORT	ULL			WINAPI	AjcFGetBytePointW(HAJCFILE pW);

AJCEXPORT	BOOL		WINAPI	AjcFSetPoint(HAJCFILE pW, ULL point);

AJCEXPORT	ULL			WINAPI	AjcFSavePointA(HAJCFILE hFile);
AJCEXPORT	ULL			WINAPI	AjcFSavePointW(HAJCFILE hFile);

AJCEXPORT	BOOL		WINAPI	AjcFRecvPoint(HAJCFILE hFile);

AJCEXPORT	BOOL		WINAPI	AjcFEof		(HAJCFILE hFile);


//	テキストファイル出力
AJCEXPORT	HAJCFILE	WINAPI	AjcFCreateA	(C_BCP pPath, EAJCTEC tec, BOOL fBOM);
AJCEXPORT	HAJCFILE	WINAPI	AjcFCreateW	(C_WCP pPath, EAJCTEC tec, BOOL fBOM);

AJCEXPORT	HAJCFILE	WINAPI	AjcFCreateShareA(C_BCP pPath, EAJCTEC tec, BOOL fBOM, UI share);
AJCEXPORT	HAJCFILE	WINAPI	AjcFCreateShareW(C_WCP pPath, EAJCTEC tec, BOOL fBOM, UI share);

AJCEXPORT	HAJCFILE	WINAPI	AjcFAppendA	(C_BCP pPath, EAJCTEC tec, BOOL fBOM);
AJCEXPORT	HAJCFILE	WINAPI	AjcFAppendW	(C_WCP pPath, EAJCTEC tec, BOOL fBOM);

AJCEXPORT	HAJCFILE	WINAPI	AjcFAppendShareA(C_BCP pPath, EAJCTEC tec, BOOL fBOM, UI share);
AJCEXPORT	HAJCFILE	WINAPI	AjcFAppendShareW(C_WCP pPath, EAJCTEC tec, BOOL fBOM, UI share);

AJCEXPORT	HAJCFILE	WINAPI	AjcFAttachCreated(HANDLE hFile, EAJCTEC tec, BOOL fBOM);

AJCEXPORT	BOOL		WINAPI	AjcFPutSA	(HAJCFILE hFile, C_BCP pText, UI lText);
AJCEXPORT	BOOL		WINAPI	AjcFPutSW	(HAJCFILE hFile, C_WCP pText, UI lText);

AJCEXPORT	BOOL		WINAPI	AjcFPutCA	(HAJCFILE pW, BC c);
AJCEXPORT	BOOL		WINAPI	AjcFPutCW	(HAJCFILE pW, WC c);

AJCEXPORT	BOOL		WINAPI	AjcFPutCodeA(HAJCFILE hFile, UI c);
AJCEXPORT	BOOL		WINAPI	AjcFPutCodeW(HAJCFILE hFile, UI c);

AJCEXPORT	BOOL		WINAPI	AjcFPrintFA	(HAJCFILE hFile, C_BCP pFmt, ...);
AJCEXPORT	BOOL		WINAPI	AjcFPrintFW	(HAJCFILE hFile, C_WCP pFmt, ...);

AJCEXPORT	BOOL		WINAPI	AjcFVPrintFA	(HAJCFILE hFile, C_BCP pFmt, va_list vls);
AJCEXPORT	BOOL		WINAPI	AjcFVPrintFW	(HAJCFILE hFile, C_WCP pFmt, va_list vls);

//	テキストファイル 出力データフラッシュ
AJCEXPORT	BOOL		WINAPI	AjcFFlush	(HAJCFILE hFile);

//	テキストファイルクローズ
AJCEXPORT	BOOL		WINAPI	AjcFClose	(HAJCFILE hFile);

//	テキストファイルをクローズしないでインスタンス解放
AJCEXPORT	BOOL		WINAPI	AjcFDetach	(HAJCFILE hFile);

//	改行モード設定／取得
AJCEXPORT	BOOL		WINAPI	AjcFSetLfConv (HAJCFILE  hFile, AJCFLFCONV mode);
AJCEXPORT	AJCFLFCONV	WINAPI	AjcFGetLfConv (HAJCFILE  hFile);

//	テキストエンコード種別取得
AJCEXPORT	EAJCTEC		WINAPI	AjcFGetTec	(HAJCFILE hFile);

//	入力ファイルのＢＯＭ有無の取得
AJCEXPORT	BOOL		WINAPI	AjcFGetBOM(HAJCFILE hFile);

//	入出力モード取得
AJCEXPORT	BOOL		WINAPI	AjcFIsModeInput(HAJCFILE hFile);

//	書式文字列バッファ長設定
AJCEXPORT	BOOL		WINAPI	AjcFSetFmtLen	(HAJCFILE hFile, UI len);

//	ファイルハンドル取得
AJCEXPORT	HANDLE		WINAPI	AjcFGetFileHandle	(HAJCFILE hFile);

//	エンコード種別設定ダイアログ
AJCEXPORT	BOOL		WINAPI	AjcFTecDialogA(HWND hOwner, C_BCP pTitle, HICON hIcon, PEAJCTEC pInpTec, PEAJCTEC pOutTec, BOOL *pOutBom);
AJCEXPORT	BOOL		WINAPI	AjcFTecDialogW(HWND hOwner, C_WCP pTitle, HICON hIcon, PEAJCTEC pInpTec, PEAJCTEC pOutTec, BOOL *pOutBom);

/****************************************************************************************************************/
#endif
