﻿#ifndef	AJCTIMEMESVIEW_H_
#define	AJCTIMEMESVIEW_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	計測時間情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	ULL		Freq;				//	計測周波数[Hz]（us単位の計測ができない場合は０）
	ULL		Cnt;				//	描画回数カウンタ
	ULL		Sum;				//	描画時間 総和  [us]
	ULL		Ave;				//	描画時間 平均値[us]
	ULL		Max;				//	描画時間 最大値[us]
	ULL		Min;				//	描画時間 最小値[us]
} AJCMSTINFO, *PAJCMSTINFO;
typedef const AJCMSTINFO *PCAJCMSTINFO;

//--------------------------------------------------------------------------------------------------------------//
//	計測時間表示インスタンス																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;
	HWND		hParent;
	HWND		hMyDlg;
	HWND		hToolTip;
	UX			cbp;
	VO (CALLBACK *cbGetInfo  )(PAJCMSTINFO pBuf, UX cbp);
	VO (CALLBACK *cbNtcClosed)( 				 UX cbp);
} AJCMSTVIEW, *HAJCMSTVIEW;
typedef const AJCMSTVIEW *PCAJCMSTVIEW;
//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HWND	WINAPI	AjcViewMesTimeCreate (HWND hParent, UX cbp, VO (CALLBACK *cbGetInfo  )(PAJCMSTINFO pBuf, UX cbp),
																		VO (CALLBACK *cbNtcClosed)( 				 UX cbp));

AJCEXPORT	BOOL	WINAPI	AjcViewMesTimeDelete(HWND hDlg);

AJCEXPORT	BOOL	WINAPI	AjcViewMesTimeMove	(HWND hDlg);

/****************************************************************************************************************/
#endif
