﻿#ifndef	AJCTIPCTL_H_
#define	AJCTIPCTL_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					//
//--------------------------------------------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcTipTextAdd			AjcTipTextAddW
	#define	AjcTipTextAddEx			AjcTipTextAddExW
	#define	AjcTipTextAddF			AjcTipTextAddFW
	#define	AjcTipTextAddFEx		AjcTipTextAddFExW
	#define	AjcTipTextSetCallBack	AjcTipTextSetCallBackW
	#define	AjcTipTextGetInfo		AjcTipTextGetInfoW
	#define	AjcTipTextRegistPrefix	AjcTipTextRegistPrefixW

	#define	AJCTIPCTRL_SETHWND		AJCTIPCTRL_SETHWNDW
	#define	AJCTIPCTRL_PROPNAME		AJCTIPCTRL_PROPNAMEW
	#define	AJCTIPFRIEND_PROPNAME	AJCTIPFRIEND_PROPNAMEW
	#define	AJCTIP_SETFRIEND		AJCTIP_SETFRIENDW
#else
	#define	AjcTipTextAdd			AjcTipTextAddA
	#define	AjcTipTextAddEx			AjcTipTextAddExA
	#define	AjcTipTextAddF			AjcTipTextAddFA
	#define	AjcTipTextAddFEx		AjcTipTextAddFExA
	#define	AjcTipTextSetCallBack	AjcTipTextSetCallBackA
	#define	AjcTipTextGetInfo		AjcTipTextGetInfoA
	#define	AjcTipTextRegistPrefix	AjcTipTextRegistPrefixA

	#define	AJCTIPCTRL_SETHWND		AJCTIPCTRL_SETHWNDA
	#define	AJCTIPCTRL_PROPNAME		AJCTIPCTRL_PROPNAMEA
	#define	AJCTIPFRIEND_PROPNAME	AJCTIPFRIEND_PROPNAMEA
	#define	AJCTIP_SETFRIEND		AJCTIP_SETFRIENDA
#endif


//--------------------------------------------------------------------------------------------------------------//
//	チップテキストの表示位置モード																				//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCTIP_POS_UNDER_CONTROL	= 0	,	//	ツールチップを対象コントロールの下に表示
	AJCTIP_POS_UNDER_CURSOR		= 1	,	//	ツールチップをマウスカーソルの下に表示
} AJCTIP_POSMODE, *PAJCTIP_POSMODE;

//--------------------------------------------------------------------------------------------------------------//
//	チップテキスト設定情報																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HWND		hCtrl;					//	コントロールのウインドハンドル
	int			msDelay;				//	表示遅延時間[ms]
	int			msShow;					//	表示時間	[ms]
	HFONT		hFont;					//	フォントハンドル	(NULL : デフォルトフォント）
	COLORREF	TextColor;				//	テキスト描画色		(-1 : デフォルト色)
	COLORREF	BackGround;				//	背景色				(-1 : デフォルト色)
	COLORREF	BorderColor;			//	外枠描画色			(-1 : デフォルト色，-2 : 外枠非表示)
	UI			WindowTime;				//	コントロール間移動猶予時間[ms]
	HFONT		hDefFont;				//	デフォルトのフォントハンドル
	COLORREF	DefTextColor;			//		〃	  のテキスト描画色
	COLORREF	DefBackGround;			//		〃	  の背景色
	COLORREF	DefBorderColor;			//		〃	  の外枠描画色
	int			DefMsDelay;				//		〃	  の表示遅延時間
	int			DefMsShow;				//		〃	  の表示時間
} AJCTIPINFO, *PAJCTIPINFO;
typedef const AJCTIPINFO *PCAJCTIPINFO;

//--------------------------------------------------------------------------------------------------------------//
//	チップ制御の対象ウインド情報																				//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCTIPCTRL_PROPNAMEA		 "AJCTIPCTRLHWND"
#define		AJCTIPCTRL_PROPNAMEW		L"AJCTIPCTRLHWND"

#define		AJCTIPCTRL_SETHWNDA(HCTRL, TIPWND)		SetPropA(HCTRL, AJCTIPCTRL_PROPNAMEA, (HANDLE)TIPWND)
#define		AJCTIPCTRL_SETHWNDW(HCTRL, TIPWND)		SetPropW(HCTRL, AJCTIPCTRL_PROPNAMEW, (HANDLE)TIPWND)

//--------------------------------------------------------------------------------------------------------------//
//	チップ制御の友達ウインド情報（Ｚオーダー上位でも以下のプロパティが設定されている場合は同一ウインドとみなす）//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCTIPFRIEND_PROPNAMEA		 "AjcTipCtrlFriend"
#define		AJCTIPFRIEND_PROPNAMEW		L"AjcTipCtrlFriend"
#define		AJCTIPFRIEND_ID				(0x978145B3)

#define		AJCTIP_SETFRIENDA(HFRIEND)		SetPropA(HFRIEND, AJCTIPFRIEND_PROPNAMEA, (HANDLE)((UX)AJCTIPFRIEND_ID))
#define		AJCTIP_SETFRIENDW(HFRIEND)		SetPropW(HFRIEND, AJCTIPFRIEND_PROPNAMEW, (HANDLE)((UX)AJCTIPFRIEND_ID))

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcTipTextEnableMultiThread(BOOL fEnable);

AJCEXPORT AJCTIP_POSMODE WINAPI AjcTipTextSetTipPosMode (AJCTIP_POSMODE PosMode);

AJCEXPORT BOOL	 WINAPI AjcTipTextAddA(HWND hCtrl, C_BCP pTxt);
AJCEXPORT BOOL	 WINAPI AjcTipTextAddW(HWND hCtrl, C_WCP pTxt);

AJCEXPORT BOOL	 WINAPI AjcTipTextAddExA(HWND hCtrl, C_BCP pTxt, int msDelay, int msShow, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor);
AJCEXPORT BOOL	 WINAPI AjcTipTextAddExW(HWND hCtrl, C_WCP pTxt, int msDelay, int msShow, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor);

AJCEXPORT BOOL	 WINAPI AjcTipTextAddFA(HWND hCtrl, C_BCP pFmt, ...);
AJCEXPORT BOOL	 WINAPI AjcTipTextAddFW(HWND hCtrl, C_WCP pFmt, ...);

AJCEXPORT BOOL	 WINAPI AjcTipTextAddFExA(HWND hCtrl, int msDelay, int msShow, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor, C_BCP pFmt, ...);
AJCEXPORT BOOL	 WINAPI AjcTipTextAddFExW(HWND hCtrl, int msDelay, int msShow, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor, C_WCP pFmt, ...);

AJCEXPORT BOOL	 WINAPI AjcTipTextSetShowAlways(HWND hCtrl, BOOL fShowAlways);
AJCEXPORT BOOL	 WINAPI AjcTipTextGetShowAlways(HWND hCtrl);

AJCEXPORT VO	 WINAPI AjcTipTextSetShowForActive(BOOL fShowForActive);
AJCEXPORT BOOL	 WINAPI AjcTipTextGetShowForActive(VO);

AJCEXPORT BOOL	 WINAPI AjcTipTextSetCallBackA(HWND hCtrl, UX cbp, BOOL (CALLBACK *cbChkCursor)(HWND hCtrl, LPPOINT ptClient, UX cbp), C_BCP (CALLBACK *cbGetText)(HWND hCtrl, BCP pBuf, UI lBuf, UX cbp));
AJCEXPORT BOOL	 WINAPI AjcTipTextSetCallBackW(HWND hCtrl, UX cbp, BOOL (CALLBACK *cbChkCursor)(HWND hCtrl, LPPOINT ptClient, UX cbp), C_WCP (CALLBACK *cbGetText)(HWND hCtrl, WCP pBuf, UI lBuf, UX cbp));

AJCEXPORT BOOL	 WINAPI AjcTipTextSetCallBackNoBufA(HWND hCtrl, UX cbp, BOOL (CALLBACK *cbChkCursor)(HWND hCtrl, LPPOINT ptClient, UX cbp), C_BCP (CALLBACK *cbGetText)(HWND hCtrl, UX cbp));
AJCEXPORT BOOL	 WINAPI AjcTipTextSetCallBackNoBufW(HWND hCtrl, UX cbp, BOOL (CALLBACK *cbChkCursor)(HWND hCtrl, LPPOINT ptClient, UX cbp), C_WCP (CALLBACK *cbGetText)(HWND hCtrl, UX cbp));

AJCEXPORT BOOL	 WINAPI AjcTipTextEnable		(HWND hCtrl, BOOL fEnable);
AJCEXPORT BOOL	 WINAPI AjcTipTextGetEnableState(HWND hCtrl);

AJCEXPORT VO	 WINAPI AjcTipTextEnableAll 	   (BOOL fEnable);
AJCEXPORT BOOL	 WINAPI AjcTipTextGetEnableAllState(VO);

AJCEXPORT BOOL	 WINAPI AjcTipTextRemove(HWND hCtrl);
AJCEXPORT BOOL	 WINAPI AjcTipTextRemoveAll(VO);

AJCEXPORT UI	 WINAPI AjcTipTextGetInfoA(HWND hCtrl, PAJCTIPINFO pInfoBuf, BCP pTxtBuf, UI lTxtBuf);
AJCEXPORT UI	 WINAPI AjcTipTextGetInfoW(HWND hCtrl, PAJCTIPINFO pInfoBuf, WCP pTxtBuf, UI lTxtBuf);

AJCEXPORT BOOL	 WINAPI AjcTipTextSetNtcSubclass(HWND hCtrl, HWND hNtc, UI msg, UX lParam);
AJCEXPORT BOOL	 WINAPI AjcTipTextClrNtcSubclass(HWND hCtrl);

AJCEXPORT VO	 WINAPI AjcTipTextSetWindowTime(int msTime);
AJCEXPORT int	 WINAPI AjcTipTextGetWindowTime(VO);

AJCEXPORT VO	 WINAPI AjcTipTextSetDefMsDelay(int msDelay);
AJCEXPORT int	 WINAPI AjcTipTextGetDefMsDelay(VO);

/****************************************************************************************************************/
#endif
