﻿#ifndef	AJCWNDITEM_H_
#define	AJCWNDITEM_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	スペルミスの訂正																							*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		AjcLoadAllControlSetteings		AjcLoadAllControlSettings
#define		AjcLoadAllControlSetteingsW		AjcLoadAllControlSettingsW
#define		AjcLoadAllControlSetteingsA		AjcLoadAllControlSettingsA

#define		AjcSaveAllControlSetteings		AjcSaveAllControlSettings

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcGetCtrlStr 				AjcGetCtrlStrW
	#define		AjcGetCtrlStrLen			AjcGetCtrlStrLenW

	#define		AjcGetCtrlCboLen			AjcGetCtrlCboLenW
	#define		AjcGetCtrlCboItem			AjcGetCtrlCboItemW
	#define		AjcGetCtrlCboFind			AjcGetCtrlCboFindW
	#define		AjcGetCtrlCboMaxLen			AjcGetCtrlCboMaxLenW
	#define		AjcSetCtrlStr 				AjcSetCtrlStrW
	#define		AjcSetCtrlFStr 				AjcSetCtrlFStrW
	#define		AjcSetCtrlEdtLimit			AjcSetCtrlEdtLimitW
	#define		AjcSetCtrlCboAdd			AjcSetCtrlCboAddW
	#define		AjcSetCtrlCboIns			AjcSetCtrlCboInsW
	#define		AjcSetCtrlCboList			AjcSetCtrlCboListW

	#define		AjcSetCtrlCboLimit			AjcSetCtrlCboLimitW
	//----- プロファイル・エクスチェンジ ----------------------------//
	#define		AjcSetCtrlPropUInt			AjcSetCtrlPropUIntW
	#define		AjcSetCtrlPropSInt			AjcSetCtrlPropSIntW
	#define		AjcSetCtrlPropHex 			AjcSetCtrlPropHexW
	#define		AjcSetCtrlPropReal			AjcSetCtrlPropRealW
	#define		AjcSetCtrlPropUI8 			AjcSetCtrlPropUI8W
	#define		AjcSetCtrlPropSI8 			AjcSetCtrlPropSI8W
	#define		AjcSetCtrlPropH8  			AjcSetCtrlPropH8W
	#define		AjcSetCtrlPropUI16			AjcSetCtrlPropUI16W
	#define		AjcSetCtrlPropSI16			AjcSetCtrlPropSI16W
	#define		AjcSetCtrlPropH16 			AjcSetCtrlPropH16W
	#define		AjcSetCtrlPropUI64			AjcSetCtrlPropUI64W
	#define		AjcSetCtrlPropSI64			AjcSetCtrlPropSI64W
	#define		AjcSetCtrlPropH64 			AjcSetCtrlPropH64W
	#define		AjcSetCtrlPropChk 			AjcSetCtrlPropChkW
	#define		AjcSetCtrlPropStr			AjcSetCtrlPropStrW
	#define		AjcSetCtrlPropCbo			AjcSetCtrlPropCboW
	#define		AjcLoadCtrlProfiles 		AjcLoadCtrlProfilesW
	#define		AjcSaveCtrlProfiles 		AjcSaveCtrlProfilesW
	#define		AjcRefreshCtrlValues		AjcRefreshCtrlValuesW
	#define		AjcGetCtrlValues			AjcGetCtrlValuesW
	#define		AjcSetCtrlValues			AjcSetCtrlValuesW
	#define		AjcReleaseCtrlProps			AjcReleaseCtrlPropsW
	//----- コントロールの設定値セーブ／ロード -----------------------//
	#define		AjcLoadAllControlSettings		AjcLoadAllControlSettingsW
	#define		AjcSaveAllControlSettingsEx		AjcSaveAllControlSettingsExW
	#define		AjcLoadGrpControlSettings		AjcLoadGrpControlSettingsW
	#define		AjcSaveGrpControlSettingsEx		AjcSaveGrpControlSettingsExW

	#define		AjcCtrlLoadTextBox				AjcCtrlLoadTextBoxW
	#define		AjcCtrlLoadTextBoxEx			AjcCtrlLoadTextBoxExW
	#define		AjcCtrlSaveTextBox				AjcCtrlSaveTextBoxW
	#define		AjcCtrlSaveTextBoxEx			AjcCtrlSaveTextBoxExW
	#define		AjcCtrlLoadChkBox				AjcCtrlLoadChkBoxW
	#define		AjcCtrlSaveChkBox				AjcCtrlSaveChkBoxW
	#define		AjcCtrlLoadComboBox				AjcCtrlLoadComboBoxW
	#define		AjcCtrlSaveComboBox				AjcCtrlSaveComboBoxW
	#define		AjcCtrlIsComboBoxSaved			AjcCtrlIsComboBoxSavedW
	#define		AjcCtrlLoadListBox				AjcCtrlLoadListBoxW
	#define		AjcCtrlSaveListBox				AjcCtrlSaveListBoxW

#else
	#define		AjcGetCtrlStr 				AjcGetCtrlStrA
	#define		AjcGetCtrlStrLen			AjcGetCtrlStrLenA

	#define		AjcGetCtrlCboLen			AjcGetCtrlCboLenA
	#define		AjcGetCtrlCboItem			AjcGetCtrlCboItemA
	#define		AjcGetCtrlCboFind			AjcGetCtrlCboFindA
	#define		AjcGetCtrlCboMaxLen			AjcGetCtrlCboMaxLenA
	#define		AjcSetCtrlStr 				AjcSetCtrlStrA
	#define		AjcSetCtrlFStr 				AjcSetCtrlFStrA
	#define		AjcSetCtrlEdtLimit			AjcSetCtrlEdtLimitA
	#define		AjcSetCtrlCboAdd			AjcSetCtrlCboAddA
	#define		AjcSetCtrlCboIns			AjcSetCtrlCboInsW
	#define		AjcSetCtrlCboList			AjcSetCtrlCboListA

	#define		AjcSetCtrlCboLimit			AjcSetCtrlCboLimitA
	//----- プロファイル・エクスチェンジ ----------------------------//
	#define		AjcSetCtrlPropUInt			AjcSetCtrlPropUIntA
	#define		AjcSetCtrlPropSInt			AjcSetCtrlPropSIntA
	#define		AjcSetCtrlPropHex 			AjcSetCtrlPropHexA
	#define		AjcSetCtrlPropReal			AjcSetCtrlPropRealA
	#define		AjcSetCtrlPropUI8 			AjcSetCtrlPropUI8A
	#define		AjcSetCtrlPropSI8			AjcSetCtrlPropSI8A
	#define		AjcSetCtrlPropH8 			AjcSetCtrlPropH8A
	#define		AjcSetCtrlPropUI16			AjcSetCtrlPropUI16A
	#define		AjcSetCtrlPropSI16			AjcSetCtrlPropSI16A
	#define		AjcSetCtrlPropH16 			AjcSetCtrlPropH16A
	#define		AjcSetCtrlPropUI64			AjcSetCtrlPropUI64A
	#define		AjcSetCtrlPropSI64			AjcSetCtrlPropSI64A
	#define		AjcSetCtrlPropH64 			AjcSetCtrlPropH64A
	#define		AjcSetCtrlPropChk 			AjcSetCtrlPropChkA
	#define		AjcSetCtrlPropStr			AjcSetCtrlPropStrA
	#define		AjcSetCtrlPropCbo			AjcSetCtrlPropCboA
	#define		AjcLoadCtrlProfiles 		AjcLoadCtrlProfilesA
	#define		AjcSaveCtrlProfiles 		AjcSaveCtrlProfilesA
	#define		AjcRefreshCtrlValues		AjcRefreshCtrlValuesA
	#define		AjcGetCtrlValues			AjcGetCtrlValuesA
	#define		AjcSetCtrlValues			AjcSetCtrlValuesA
	#define		AjcReleaseCtrlProps			AjcReleaseCtrlPropsA
	//----- コントロールの設定値セーブ／ロード -----------------------//
	#define		AjcLoadAllControlSettings		AjcLoadAllControlSettingsA
	#define		AjcSaveAllControlSettingsEx		AjcSaveAllControlSettingsExA
	#define		AjcLoadGrpControlSettings		AjcLoadGrpControlSettingsA
	#define		AjcSaveGrpControlSettingsEx		AjcSaveGrpControlSettingsExA

	#define		AjcCtrlLoadTextBox				AjcCtrlLoadTextBoxA
	#define		AjcCtrlLoadTextBoxEx			AjcCtrlLoadTextBoxExA
	#define		AjcCtrlSaveTextBox				AjcCtrlSaveTextBoxA
	#define		AjcCtrlSaveTextBoxEx			AjcCtrlSaveTextBoxExA
	#define		AjcCtrlLoadChkBox				AjcCtrlLoadChkBoxA
	#define		AjcCtrlSaveChkBox				AjcCtrlSaveChkBoxA
	#define		AjcCtrlLoadComboBox				AjcCtrlLoadComboBoxA
	#define		AjcCtrlSaveComboBox				AjcCtrlSaveComboBoxA
	#define		AjcCtrlIsComboBoxSaved			AjcCtrlIsComboBoxSavedA
	#define		AjcCtrlLoadListBox				AjcCtrlLoadListBoxA
	#define		AjcCtrlSaveListBox				AjcCtrlSaveListBoxA
#endif

/*--------------------------------------------------------------------------------------------------------------*/
/*	AjcGetCtrlCboFind()／AjcSetCtrlCboAdd()／AjcSetCtrlCboInsの「flag」引数										*/
/*--------------------------------------------------------------------------------------------------------------*/
//																							摘用
#define		AJCCBF_SORT				0x0001		/*	昇順ソート									   Add			*/
#define		AJCCBF_EXACT_STR		0x0002		/*	文字列全体を比較						Find				*/
#define		AJCCBF_EXACT_WIDTH		0x0004		/*	英大小文字を区別						Find / Add / Ins	*/
#define		AJCCBF_EXCLUSION		0x0008		/*	同一項目存在時は追加／挿入しない			   Add / Ins	*/
#define		AJCCBF_SAME_ERR			0x0010		/*	同一項目存在時はエラーとする				   Add / Ins	*/
#define		AJCCBF_SELECT			0x0020		/*	追加／挿入or既存項目を選択状態にする	Find   Add / Ins	*/
#define		AJCCBF_ALL		(AJCCBF_EXACT | AJCCBF_SORT | AJCCBF_RECOGNIZE_WIDTH | AJCCBF_EXCLUSION | AJCCBF_SELECT)
#define		AJCCBF_ALL_NS	(AJCCBF_EXACT | 			  AJCCBF_RECOGNIZE_WIDTH | AJCCBF_EXCLUSION | AJCCBF_SELECT)

//	別名
#define		AJCCBF_EXACT			AJCCBF_EXACT_STR	/*	AJCCBF_EXACT_STR				Find				*/
#define		AJCCBF_RECOGNIZE_WIDTH	AJCCBF_EXACT_WIDTH	/*	AJCCBF_EXACT_WIDTH				Find / Add / Ins	*/
#define		AJCCBF_DISTINGUISH		AJCCBF_EXACT_WIDTH	/*	(同上)							Find / Add / Ins	*/


#define		MAJCBF2(A, B)			(AJCCBF_##A | AJCCBF_##B)
#define		MAJCBF3(A, B, C)		(AJCCBF_##A | AJCCBF_##B | AJCCBF_##C)

/*--------------------------------------------------------------------------------------------------------------*/
/*	AjcSetCtrlCboIns()の「ix」引数（挿入方法の指定）															*/
/*--------------------------------------------------------------------------------------------------------------*/
#define	AJCCBI_APPEND			 (-1)		/*	末尾に挿入														*/
#define	AJCCBI_ASCENDING		 (-2)		/*	昇順となる項目位置に挿入（英大小文字区別あり）					*/
#define	AJCCBI_DESCENDING		 (-3)		/*	降順となる項目位置に挿入（英大小文字区別あり）					*/

/*--------------------------------------------------------------------------------------------------------------*/
/*	コントロールの永続化に関する選択動作指定																	*/
/*--------------------------------------------------------------------------------------------------------------*/
#define	AJCCTL_SELACT_ALL			0			/*	全て永続化													*/
#define	AJCCTL_SELACT_CHKEXCLUDE	0x0001		/*	永続化項目から除外するコントロール以外を対象とする			*/
#define	AJCCTL_SELACT_CHKINCLUDE	0x0002		/*	永続化項目に含めるコントロールのみを対象とする				*/

#define	AJCCTL_SELACT_NTCCHK		0x0100		/*	チェックボックスで BN_CLICKED を通知						*/
#define	AJCCTL_SELACT_NTCRBT		0x0200		/*	チェックされているラジオボタンで BN_CLICKED を通知			*/
#define	AJCCTL_SELACT_NTCCBO		0x0400		/*	コンボボックスでCBN_SELENDOKを通知							*/
#define	AJCCTL_SELACT_NTCINP		0x0800		/*	数値入力で AJCIVN_INTVALUE / AJCIVN_REALVALUE を通知		*/
#define	AJCCTL_SELACT_NTCALL		(AJCCTL_SELACT_NTCCHK | AJCCTL_SELACT_NTCRBT | AJCCTL_SELACT_NTCCBO | AJCCTL_SELACT_NTCINP)

#define	AJCCTL_SELACT_BYLOAD		0x8000		/*	ロード時に指定された値を仮定（セーブ時のみ）				*/

/*--------------------------------------------------------------------------------------------------------------*/
/*	コントロールの永続化項目																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		AJCCTL_PSEL_DELETE		0			/*	属性解除													*/
#define		AJCCTL_PSEL_INCLUDE		0x00000001	/*	永続化項目に含める											*/
#define		AJCCTL_PSEL_EXCLUDE		0x00000002	/*	永続化項目から除外する										*/

#define		AJCCTL_PSEL_INCDATA		0x00000100	/*	データを含める			（コンボボックス，リストボックス）	*/
//#define	AJCCTL_PSEL_XXXXX		0x00000200	/*	-															*/
#define		AJCCTL_PSEL_INCLIST		0x00000400	/*	リストテキストを含める	（コンボボックス）					*/
#define		AJCCTL_PSEL_INCRDONLY	0x00000800	/*	読出専用テキストを含める（テキストボックス）				*/

//#define	AJCCTL_PSEL_EXCDATA		0x00001000	/*	データを除外			（コンボボックス，リストボックス）	*/
#define		AJCCTL_PSEL_EXCSEL		0x00002000	/*	選択情報を除外			（コンボボックス）					*/
#define		AJCCTL_PSEL_EXCLIST		0x00004000	/*	リストテキストを除外	（コンボボックス）					*/
#define		AJCCTL_PSEL_EXCEDIT		0x00008000	/*	テキストボックスを除外	（コンボボックス）					*/

#define		AJCCTL_PSEL_NTC			0x00010000	/*	チェックボックス／ラジオボタン読出し時 BN_CLICKED 通知		*/
#define		AJCCTL_PSEL_NONTC		0x00020000	/*	チェックボックス／ラジオボタン読出し時 BN_CLICKED 非通知	*/

#define		AJCCTL_PSEL_MASK	(~(AJCCTL_SELACT_CHKEXCLUDE | AJCCTL_PSEL_INCLUDE))

/*--------------------------------------------------------------------------------------------------------------*/
/*	ドロップオプション		AjcCtrlEnableToDrop()																*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		AJCDROP_DIR				0x0001							/*	ディレクトリ							*/
#define		AJCDROP_FILE			0x0002							/*	ファイル								*/
#define		AJCDROP_BOTH			(AJCDROP_DIR | AJCDROP_FILE)	/*	ディレクトリとファイル					*/
#define		AJCDROP_DIR_AND_FILE	(AJCDROP_DIR | AJCDROP_FILE)
#define		AJCDROP_CONNECT			0x0004							/*	全項目をセミコロン(;)で連結				*/
#define		AJCDROP_DIRTAIL			0x0008							/*	ディレクトリの末尾に "\" を付ける		*/

#define		AJCDROP_VOLEXP			0x0100		/*	元テキストの先頭が '<' の場合、ボリューム表現のパス名に変換	*/
#define		AJCDROP_RMVONLY			0x0200		/*	ボリューム表現のパス名に変換をリムーバブルディスクに限定	*/
#define		AJCDROP_VOLEXPRO		(AJCDROP_VOLEXP | AJCDROP_RMVONLY)

#define		AJCDROP_NOERRTIP		0x1000							/*	目的のオブジェクト(Dir/File)がドロップ	*/
																	/*	されない場合エラーチップを表示しない	*/

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
//----- ウインド項目アクセス -----------------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcGetCtrlUInt(HWND hwnd);
AJCEXPORT SI	 WINAPI AjcGetCtrlSInt(HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlHex (HWND hwnd);
AJCEXPORT double WINAPI AjcGetCtrlReal(HWND hwnd);
AJCEXPORT ULL	 WINAPI AjcGetCtrlUI64(HWND hwnd);
AJCEXPORT SLL	 WINAPI AjcGetCtrlSI64(HWND hwnd);
AJCEXPORT ULL	 WINAPI AjcGetCtrlH64 (HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlChk (HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlStrA(HWND hwnd, BCP	pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI AjcGetCtrlStrW(HWND hwnd, WCP	pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI AjcGetCtrlStrLenA(HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlStrLenW(HWND hwnd);

AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlUInt(HWND hwnd, UI 	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlSInt(HWND hwnd, SI 	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlHex (HWND hwnd, UI 	value, int digits	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlUI8 (HWND hwnd, UB 	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlSI8 (HWND hwnd, SB 	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlH8  (HWND hwnd, UB 	value, int digits	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlUI16(HWND hwnd, UW 	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlSI16(HWND hwnd, SW 	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlH16 (HWND hwnd, UW 	value, int digits	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlReal(HWND hwnd, double value, int precision);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlUI64(HWND hwnd, ULL	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlSI64(HWND hwnd, SLL	value, BOOL fComma	);
AJCEXPORT BOOL	 WINAPI AjcSetOptCtrlH64 (HWND hwnd, ULL	value, int digits	);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlUInt(HWND hwnd, UI	 value);
AJCEXPORT BOOL 	 WINAPI AjcSetCtrlSInt(HWND hwnd, SI	 value);
AJCEXPORT BOOL 	 WINAPI AjcSetCtrlHex (HWND hwnd, UI	 value);
AJCEXPORT BOOL 	 WINAPI AjcSetCtrlReal(HWND hwnd, double value, int prec);
AJCEXPORT BOOL 	 WINAPI AjcSetCtrlUI64(HWND hwnd, ULL	 value);
AJCEXPORT BOOL 	 WINAPI AjcSetCtrlSI64(HWND hwnd, SLL	 value);
AJCEXPORT BOOL 	 WINAPI AjcSetCtrlH64 (HWND hwnd, ULL	 value);

AJCEXPORT BOOL 	 WINAPI AjcSepCtrlUInt(HWND hwnd, UI	 value);
AJCEXPORT BOOL 	 WINAPI AjcSepCtrlSInt(HWND hwnd, SI	 value);
AJCEXPORT BOOL 	 WINAPI AjcSepCtrlHex (HWND hwnd, UI	 value, int col );
AJCEXPORT BOOL 	 WINAPI AjcSepCtrlReal(HWND hwnd, double value, int prec);
AJCEXPORT BOOL 	 WINAPI AjcSepCtrlUI64(HWND hwnd, ULL	 value);
AJCEXPORT BOOL 	 WINAPI AjcSepCtrlSI64(HWND hwnd, SLL	 value);
AJCEXPORT BOOL 	 WINAPI AjcSepCtrlH64 (HWND hwnd, ULL	 value, int col );

AJCEXPORT BOOL	 WINAPI AjcSetCtrlChk	 (HWND hwnd, UI state);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlStrA	 (HWND hwnd, C_BCP pStr);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlStrW	 (HWND hwnd, C_WCP pStr);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlFStrA  (HWND hwnd, C_BCP pFmt, ...);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlFStrW  (HWND hwnd, C_WCP pFmt, ...);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlEdtLimitA(HWND hwnd, UI limit);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlEdtLimitW(HWND hwnd, UI limit);

AJCEXPORT UI	 WINAPI AjcGetCtrlCboIx    (HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboCount (HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboLenA  (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboLenW  (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboItemA (HWND hwnd, UI ix, BCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboItemW (HWND hwnd, UI ix, WCP pBuf, UI lBuf);
AJCEXPORT SX	 WINAPI AjcGetCtrlCboData  (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboFindA (HWND hwnd, UI ix, C_BCP pStr, UI flag);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboFindW (HWND hwnd, UI ix, C_WCP pStr, UI flag);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboMaxLenA(HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboMaxLenW(HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlCboHeight (HWND hwnd, UI ix);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboIx    (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcSetCtrlCboAddA  (HWND hwnd, UI ix, C_BCP pItem, UI flag);
AJCEXPORT UI	 WINAPI AjcSetCtrlCboAddW  (HWND hwnd, UI ix, C_WCP pItem, UI flag);
AJCEXPORT UI	 WINAPI AjcSetCtrlCboInsA  (HWND hwnd, UI ix, C_BCP pItem, UI flag);
AJCEXPORT UI	 WINAPI AjcSetCtrlCboInsW  (HWND hwnd, UI ix, C_WCP pItem, UI flag);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboDel   (HWND hwnd, UI ix);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboData  (HWND hwnd, UI ix, SX data);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboListA (HWND hwnd, C_BCP pList);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboListW (HWND hwnd, C_WCP pList);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboReset (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboHeight(HWND hwnd, UI ix, UI height);
AJCEXPORT HWND	 WINAPI	AjcGetCtrlCboEditHandle(HWND hwnd);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboLimitA(HWND hwnd, UI limit);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlCboLimitW(HWND hwnd, UI limit);

AJCEXPORT UI	 WINAPI AjcGetCtrlLstIx    (HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstCount (HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstLenA  (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstLenW  (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstItemA (HWND hwnd, UI ix, BCP pBuf, UI lBuf);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstItemW (HWND hwnd, UI ix, WCP pBuf, UI lBuf);
AJCEXPORT SX	 WINAPI AjcGetCtrlLstData  (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstFindA (HWND hwnd, UI ix, C_BCP pStr, UI flag);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstFindW (HWND hwnd, UI ix, C_WCP pStr, UI flag);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstMaxLenA(HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstMaxLenW(HWND hwnd);
AJCEXPORT UI	 WINAPI AjcGetCtrlLstHeight (HWND hwnd, UI ix);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstIx    (HWND hwnd, UI ix);
AJCEXPORT UI	 WINAPI AjcSetCtrlLstAddA  (HWND hwnd, UI ix, C_BCP pItem, UI flag);
AJCEXPORT UI	 WINAPI AjcSetCtrlLstAddW  (HWND hwnd, UI ix, C_WCP pItem, UI flag);
AJCEXPORT UI	 WINAPI AjcSetCtrlLstInsA  (HWND hwnd, UI ix, C_BCP pItem, UI flag);
AJCEXPORT UI	 WINAPI AjcSetCtrlLstInsW  (HWND hwnd, UI ix, C_WCP pItem, UI flag);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstDel   (HWND hwnd, UI ix);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstData  (HWND hwnd, UI ix, SX data);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstListA (HWND hwnd, C_BCP pList);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstListW (HWND hwnd, C_WCP pList);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstReset (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlLstHeight(HWND hwnd, UI ix, UI height);


AJCEXPORT BOOL	 WINAPI AjcSetCtrlPgsRange(HWND hwnd, int low, int high);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPgsPos  (HWND hwnd, int pos);

AJCEXPORT int	 WINAPI AjcGetCtrlSldPos  (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSldRange(HWND hwnd, int low, int high, int page);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSldPos  (HWND hwnd, int pos);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlSpnInfo (HWND hwnd, int low, int high, HWND hwBuddy);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSpnRange(HWND hwnd, int low, int high);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlSpnBuddy(HWND hwnd, HWND hwBuddy);
AJCEXPORT HWND	 WINAPI AjcSetCtrlTopMostInSiblings (HWND hwnd);
AJCEXPORT HWND	 WINAPI AjcSetCtrlBackMostInSiblings(HWND hwnd);

//----- EDITコントロールのドロップ許可 -------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcEnableCtrlToDrop  (HWND hwnd,			UI optDrop);
AJCEXPORT BOOL	 WINAPI AjcEnableCtrlToDropEx(HWND hwnd, HWND hGrp, UI optDrop);

//----- コントロールの位置／矩形 設定／取得 --------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcGetCtrlPos	  (HWND hwnd, LPPOINT pPoint);
AJCEXPORT BOOL	WINAPI AjcGetCtrlSize	  (HWND hwnd, LPSIZE  pRect);
AJCEXPORT BOOL	WINAPI AjcGetCtrlRect	  (HWND hwnd, LPRECT  pRect);

AJCEXPORT BOOL	WINAPI AjcSetCtrlPos	  (HWND hwnd, int x, int y);
AJCEXPORT BOOL	WINAPI AjcSetCtrlPosV	  (HWND hwnd, const POINT *pPos);
AJCEXPORT BOOL	WINAPI AjcSetCtrlSize	  (HWND hwnd, int cx, int cy);
AJCEXPORT BOOL	WINAPI AjcSetCtrlSizeV	  (HWND hwnd, const SIZE *pSize);
AJCEXPORT BOOL	WINAPI AjcSetCtrlRect	  (HWND hwnd, int x, int y, int cx, int cy);
AJCEXPORT BOOL	WINAPI AjcSetCtrlRectV	  (HWND hwnd, const RECT *pRect);

//----- コントロールのグレィ設定／グループ操作 -----------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcEnableCtrl	   (HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL	WINAPI AjcShowCtrl		   (HWND hwnd, BOOL fShow);
AJCEXPORT BOOL	WINAPI AjcShowAndEnableCtrl(HWND hwnd, BOOL fShow, BOOL fEnable);

AJCEXPORT BOOL	WINAPI AjcEnableGroup	  (HWND hwnd, BOOL fEnaGrpBox, BOOL fEnaCtrls);
AJCEXPORT BOOL	WINAPI AjcEnableCtrlsInWnd(HWND hwnd, BOOL fEnaCtrls);
AJCEXPORT BOOL	WINAPI AjcShowGroup 	  (HWND hwnd, BOOL fShow);
AJCEXPORT BOOL	WINAPI AjcShowGroupEx	  (HWND hwnd, BOOL fShowGrpBox, BOOL fShowCtrls);
AJCEXPORT BOOL	WINAPI AjcMoveGroupToLoc  (HWND hwnd, int x, int y);
AJCEXPORT BOOL	WINAPI AjcMoveGroupToCtl  (HWND hwnd, HWND hctl);
AJCEXPORT BOOL	WINAPI AjcMoveGroupToOrg  (HWND hwnd);

//----- グループ内ウインド列挙 ---------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI AjcCtrlEnumInGroup (HWND hwnd, UX cbp, BOOL (CALLBACK *cbEnum)(HWND hCtrl, UX cbp));

//----- プロファイル エクスチェンジ ----------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUIntA  (HWND hCtrl, C_BCP pKey, UI	 defValue, BOOL fComma	, UI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSIntA  (HWND hCtrl, C_BCP pKey, SI	 defValue, BOOL fComma	, SI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropHexA	 (HWND hCtrl, C_BCP pKey, UI	 defValue, int digits	, UI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropRealA  (HWND hCtrl, C_BCP pKey, double defValue, BOOL fComma	, int prec, double *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUI8A	 (HWND hCtrl, C_BCP pKey, UB	 defValue, BOOL fComma	, UB	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSI8A	 (HWND hCtrl, C_BCP pKey, SB	 defValue, BOOL fComma	, SB	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropH8A	 (HWND hCtrl, C_BCP pKey, UB	 defValue, int digits	, UB	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUI16A  (HWND hCtrl, C_BCP pKey, UW	 defValue, BOOL fComma	, UW	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSI16A  (HWND hCtrl, C_BCP pKey, SW	 defValue, BOOL fComma	, SW	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropH16A	 (HWND hCtrl, C_BCP pKey, UW	 defValue, int digits	, UW	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUI64A  (HWND hCtrl, C_BCP pKey, ULL	 defValue, BOOL fComma	, ULL	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSI64A  (HWND hCtrl, C_BCP pKey, SLL	 defValue, BOOL fComma	, SLL	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropH64A	 (HWND hCtrl, C_BCP pKey, ULL	 defValue, int digits	, ULL	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropChkA	 (HWND hCtrl, C_BCP pKey, UI	 defState				, UI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropStrA	 (HWND hCtrl, C_BCP pKey, C_BCP pDefStr, BCP pVar, int lVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropCboA	 (HWND hCtrl, C_BCP pKey, C_BCP pDefLst, UI DefIx, UIP pVar);

AJCEXPORT BOOL	 WINAPI AjcLoadCtrlProfilesA (HWND hwnd, C_BCP pSec);
AJCEXPORT BOOL	 WINAPI AjcSaveCtrlProfilesA (HWND hwnd, C_BCP pSec);
AJCEXPORT BOOL	 WINAPI AjcRefreshCtrlValuesA(HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcGetCtrlValuesA	 (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlValuesA	 (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcReleaseCtrlPropsA (HWND hwnd);

AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUIntW  (HWND hCtrl, C_WCP pKey, UI	 defValue, BOOL fComma	, UI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSIntW  (HWND hCtrl, C_WCP pKey, SI	 defValue, BOOL fComma	, SI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropHexW	 (HWND hCtrl, C_WCP pKey, UI	 defValue, int digits	, UI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropRealW  (HWND hCtrl, C_WCP pKey, double defValue, BOOL fComma	, int prec, double *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUI8W	 (HWND hCtrl, C_WCP pKey, UB	 defValue, BOOL fComma	, UB	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSI8W	 (HWND hCtrl, C_WCP pKey, SB	 defValue, BOOL fComma	, SB	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropH8W	 (HWND hCtrl, C_WCP pKey, UB	 defValue, int digits	, UB	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUI16W  (HWND hCtrl, C_WCP pKey, UW	 defValue, BOOL fComma	, UW	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSI16W  (HWND hCtrl, C_WCP pKey, SW	 defValue, BOOL fComma	, SW	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropH16W	 (HWND hCtrl, C_WCP pKey, UW	 defValue, int digits	, UW	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropUI64W  (HWND hCtrl, C_WCP pKey, ULL	 defValue, BOOL fComma	, ULL	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropSI64W  (HWND hCtrl, C_WCP pKey, SLL	 defValue, BOOL fComma	, SLL	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropH64W	 (HWND hCtrl, C_WCP pKey, ULL	 defValue, int digits	, ULL	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropChkW	 (HWND hCtrl, C_WCP pKey, UI	 defState				, UI	 *pVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropStrW	 (HWND hCtrl, C_WCP pKey, C_WCP pDefStr, WCP pVar, int lVar);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlPropCboW	 (HWND hCtrl, C_WCP pKey, C_WCP pDefLst, UI DefIx, UIP pVar);

AJCEXPORT BOOL	 WINAPI AjcLoadCtrlProfilesW (HWND hwnd, C_WCP pSec);
AJCEXPORT BOOL	 WINAPI AjcSaveCtrlProfilesW (HWND hwnd, C_WCP pSec);
AJCEXPORT BOOL	 WINAPI AjcRefreshCtrlValuesW(HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcGetCtrlValuesW	 (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcSetCtrlValuesW	 (HWND hwnd);
AJCEXPORT BOOL	 WINAPI AjcReleaseCtrlPropsW (HWND hwnd);

//----- コントロールの永続化 -----------------------------------------------------------------------------------//
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSetPermAtt	(HWND hctrl,	   UI att);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSetPermAttGrp(HWND hctrl,	   UI att);
AJCEXPORT 	BOOL	WINAPI	AjcDelAllCtrlPermAtt(HWND hwnd);

AJCEXPORT 	BOOL	WINAPI	AjcLoadAllControlSettingsA(HWND hwnd, C_BCP pSect, UI act);
AJCEXPORT 	BOOL	WINAPI	AjcLoadAllControlSettingsW(HWND hwnd, C_WCP pSect, UI act);

AJCEXPORT 	BOOL	WINAPI	AjcSaveAllControlSettings(HWND hwnd);

AJCEXPORT 	BOOL	WINAPI	AjcSaveAllControlSettingsExA(HWND hwnd, C_BCP pSect, UI act);
AJCEXPORT 	BOOL	WINAPI	AjcSaveAllControlSettingsExW(HWND hwnd, C_WCP pSect, UI act);

AJCEXPORT 	BOOL	WINAPI	AjcLoadGrpControlSettingsA(HWND hwnd, HWND hGrp, C_BCP pSect, UI act);
AJCEXPORT 	BOOL	WINAPI	AjcLoadGrpControlSettingsW(HWND hwnd, HWND hGrp, C_WCP pSect, UI act);

AJCEXPORT 	BOOL	WINAPI	AjcSaveGrpControlSettings(HWND hwnd, HWND hGrp);

AJCEXPORT 	BOOL	WINAPI	AjcSaveGrpControlSettingsExA(HWND hwnd, HWND hGrp, C_BCP pSect, UI act);
AJCEXPORT 	BOOL	WINAPI	AjcSaveGrpControlSettingsExW(HWND hwnd, HWND hGrp, C_WCP pSect, UI act);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxA(HWND hwnd, C_BCP pSect);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxW(HWND hwnd, C_WCP pSect);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxExA(HWND hwnd, C_BCP pSect, BOOL fExcRdOnly);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadTextBoxExW(HWND hwnd, C_WCP pSect, BOOL fExcRdOnly);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxA(HWND hwnd, C_BCP pSect);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxW(HWND hwnd, C_WCP pSect);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxExA(HWND hwnd, C_BCP pSect, BOOL fExcRdOnly);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveTextBoxExW(HWND hwnd, C_WCP pSect, BOOL fExcRdOnly);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadChkBoxA(HWND hwnd, C_BCP pSect, BOOL fNtc);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadChkBoxW(HWND hwnd, C_WCP pSect, BOOL fNtc);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveChkBoxA(HWND hwnd, C_BCP pSect);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveChkBoxW(HWND hwnd, C_WCP pSect);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadComboBoxA(HWND hwnd, C_BCP pSect, UI sel, BOOL fNtc);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadComboBoxW(HWND hwnd, C_WCP pSect, UI sel, BOOL fNtc);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveComboBoxA(HWND hwnd, C_BCP pSect, UI sel);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveComboBoxW(HWND hwnd, C_WCP pSect, UI sel);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlIsComboBoxSavedA(HWND hwnd, C_BCP pSect);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlIsComboBoxSavedW(HWND hwnd, C_WCP pSect);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadListBoxA(HWND hwnd, C_BCP pSect, UI sel);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlLoadListBoxW(HWND hwnd, C_WCP pSect, UI sel);

AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveListBoxA(HWND hwnd, C_BCP pSect, UI sel);
AJCEXPORT 	BOOL	WINAPI	AjcCtrlSaveListBoxW(HWND hwnd, C_WCP pSect, UI sel);

//----- AjcSetOptCtrlXXXXの「opt」引数 -------------------------------------------------------------------------//
#define	AJCSEP	0x8000


/****************************************************************************************************************/
#endif
