﻿#ifndef	AJCWNDSUPPORT_H_
#define	AJCWNDSUPPORT_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define		AjcLoadWndPos			AjcLoadWndPosW
	#define		AjcSaveWndPos			AjcSaveWndPosW
	#define		AjcLoadWndRect			AjcLoadWndRectW
	#define		AjcSaveWndRect			AjcSaveWndRectW

	#define		AjcLoadWndPosEx			AjcLoadWndPosExW
	#define		AjcSaveWndPosEx			AjcSaveWndPosExW
	#define		AjcLoadWndRectEx		AjcLoadWndRectExW
	#define		AjcSaveWndRectEx		AjcSaveWndRectExW

	#define		AjcDoEvent				AjcDoEventW
	#define		AjcDoEventEx			AjcDoEventExW

  #if _MSC_VER >= 1400	// VisualStudio2005
	#define	AjcGetExePathName			AjcGetExePathNameW
  #endif

#else
	#define		AjcLoadWndPos			AjcLoadWndPosA
	#define		AjcSaveWndPos			AjcSaveWndPosA
	#define		AjcLoadWndRect			AjcLoadWndRectA
	#define		AjcSaveWndRect			AjcSaveWndRectA

	#define		AjcLoadWndPosEx			AjcLoadWndPosExA
	#define		AjcSaveWndPosEx			AjcSaveWndPosExA
	#define		AjcLoadWndRectEx		AjcLoadWndRectExA
	#define		AjcSaveWndRectEx		AjcSaveWndRectExA

	#define		AjcDoEvent				AjcDoEventA
	#define		AjcDoEventEx			AjcDoEventExA

  #if _MSC_VER >= 1400	// VisualStudio2005
	#define	AjcGetExePathName			AjcGetExePathNameA
  #endif

#endif

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT	BOOL	 WINAPI AjcLoadWndPosA		 (HWND hwnd, C_BCP pSec);
AJCEXPORT	BOOL	 WINAPI AjcLoadWndPosW		 (HWND hwnd, C_WCP pSec);

AJCEXPORT	BOOL	 WINAPI AjcLoadWndPosExA	 (HWND hwnd, C_BCP pSec, C_BCP pKeyPrefix);
AJCEXPORT	BOOL	 WINAPI AjcLoadWndPosExW	 (HWND hwnd, C_WCP pSec, C_WCP pKeyPrefix);

AJCEXPORT	BOOL	 WINAPI AjcLoadWndRectA 	 (HWND hwnd, C_BCP pSec);
AJCEXPORT	BOOL	 WINAPI AjcLoadWndRectW 	 (HWND hwnd, C_WCP pSec);

AJCEXPORT	BOOL	 WINAPI AjcLoadWndRectExA	 (HWND hwnd, C_BCP pSec, C_BCP pKeyPrefix);
AJCEXPORT	BOOL	 WINAPI AjcLoadWndRectExW	 (HWND hwnd, C_WCP pSec, C_WCP pKeyPrefix);

AJCEXPORT	BOOL	 WINAPI AjcSaveWndPosA		 (HWND hwnd, C_BCP pSec);
AJCEXPORT	BOOL	 WINAPI AjcSaveWndPosW		 (HWND hwnd, C_WCP pSec);

AJCEXPORT	BOOL	 WINAPI AjcSaveWndPosExA	 (HWND hwnd, C_BCP pSec, C_BCP pKeyPrefix);
AJCEXPORT	BOOL	 WINAPI AjcSaveWndPosExW	 (HWND hwnd, C_WCP pSec, C_WCP pKeyPrefix);

AJCEXPORT	BOOL	 WINAPI AjcSaveWndRectA 	 (HWND hwnd, C_BCP pSec);
AJCEXPORT	BOOL	 WINAPI AjcSaveWndRectW 	 (HWND hwnd, C_WCP pSec);

AJCEXPORT	BOOL	 WINAPI AjcSaveWndRectExA	 (HWND hwnd, C_BCP pSec, C_BCP pKeyPrefix);
AJCEXPORT	BOOL	 WINAPI AjcSaveWndRectExW	 (HWND hwnd, C_WCP pSec, C_WCP pKeyPrefix);

AJCEXPORT	BOOL	WINAPI	AjcMoveWndIntoMonitor	  (HWND hwnd);
AJCEXPORT	BOOL	WINAPI	AjcMoveWndRectIntoMonitor (HWND hwnd, LPRECT pRect);
AJCEXPORT	BOOL	WINAPI	AjcMoveOutWndToOrigin	  (HWND hwnd);
AJCEXPORT	BOOL	WINAPI	AjcIsSeeEntireInMonitors(LPRECT pRect, UIP pBounds, UIP pSqr);

AJCEXPORT	BOOL	WINAPI	AjcMoveWindowToGripped(HWND hwnd);
AJCEXPORT	BOOL	WINAPI	AjcMoveWindowToGrippedEx(HWND hwnd, UI ratio);

AJCEXPORT	BOOL	WINAPI	AjcMoveWindowToCenter(HWND hwnd);
AJCEXPORT	BOOL	WINAPI	AjcMoveWindowToCenterOfScreen(HWND hwnd);
AJCEXPORT	BOOL	WINAPI	AjcMoveWindowToCenterOfMonitor(HWND hwnd);
AJCEXPORT	BOOL	WINAPI	AjcMoveWindowToCenterOfWindow(HWND hwnd, HWND hWndScr);
AJCEXPORT	HWND	WINAPI	AjcGetFocusWindow(VO);
AJCEXPORT	BOOL	WINAPI	AjcSetFocusWindow(HWND hwnd);
AJCEXPORT	int		WINAPI	AjcGetWindowNormalRect(HWND hwnd, LPRECT pRect);
AJCEXPORT	VO		WINAPI	AjcSendMessageToThreadWindows(UI msg, WPARAM wParam, LPARAM lParam);
AJCEXPORT	VO		WINAPI	AjcSendMessageToThreadWindowsEx(UI msg, WPARAM wParam, LPARAM lParam, HWND hWndPre, HWND hWndPost);
AJCEXPORT	VO		WINAPI	AjcEnableThreadWindows(BOOL fEnable);

AJCEXPORT	UI		WINAPI	AjcDoEventA(VO);
AJCEXPORT	UI		WINAPI	AjcDoEventW(VO);

AJCEXPORT	UI		WINAPI	AjcDoEventExA(UI nDialog, ...);
AJCEXPORT	UI		WINAPI	AjcDoEventExW(UI nDialog, ...);


AJCEXPORT UX		WINAPI	AjcSetClassLongPtr(HWND hwnd, UI ix, UX data);
AJCEXPORT UX		WINAPI	AjcGetClassLongPtr(HWND hwnd, UI ix);

AJCEXPORT UX		WINAPI	AjcSetWindowLongPtr(HWND hwnd, UI ix, UX data);
AJCEXPORT UX		WINAPI	AjcGetWindowLongPtr(HWND hwnd, UI ix);

AJCEXPORT LRESULT	WINAPI	AjcDefWindowProc (				   HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);
AJCEXPORT LRESULT	WINAPI	AjcCallWindowProc(WNDPROC wndproc, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam);


#if _MSC_VER >= 1400	// VisualStudio2005
AJCEXPORT HINSTANCE	WINAPI	AjcGetExePathNameA(HWND hwnd, BCP pBuf, int lBuf);
AJCEXPORT HINSTANCE	WINAPI	AjcGetExePathNameW(HWND hwnd, WCP pBuf, int lBuf);
#endif

/****************************************************************************************************************/
#endif
