﻿#ifndef	AJXBMP_H_
#define	AJXBMP_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ビットマップ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT SAjxBmp {
	public:
		static	BOOL	ChangeBitmapColor		(HBITMAP hBmp, COLORREF before, COLORREF after);	//	ビットマップの色変更

		static	BOOL  	SetBitmapToClipboard	(HBITMAP hBitmap);									//	ビットマップデータをクリップボードへ格納する
		static	HBITMAP	GetBitmapFromClipboard	();													//	クリップボードからビットマップデータを取得する

		static	BOOL	WriteBitmapToFile		(HBITMAP hBitmap, C_BCP pFilePath);					//	ビットマップファイルを作成する(ASCII)
		static	BOOL	WriteBitmapToFile		(HBITMAP hBitmap, C_WCP pFilePath);					//	ビットマップファイルを作成する(UNICODE)

		//	ビットマップファイルを読み出してＤＩＢセクションを作成(ASCII)
		static	HBITMAP CreateDibFromFile		(C_BCP pFilePath, UIP pWidth = NULL, UIP pHeight = NULL, PAJCBITMAPINFO pBmpInfo = NULL, VOP *ppImage = NULL);
		//	ビットマップファイルを読み出してＤＩＢセクションを作成(UNICODE)
		static	HBITMAP CreateDibFromFile		(C_WCP pFilePath, UIP pWidth = NULL, UIP pHeight = NULL, PAJCBITMAPINFO pBmpInfo = NULL, VOP *ppImage = NULL);
	};
}
/****************************************************************************************************************/
#endif
