﻿#ifndef	AJXINP_H_
#define	AJXINP_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	数値入力コントロール																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxInp {
	public:
		HWND	m_hCtrl;				//	自コントロールのウインドハンドル

		CAjxInp();						//	コンストラクタ
		~CAjxInp();						//	デストラクタ

		BOOL		SetTextFormat	(int width, UI precision);						//	テキスト表示書式の設定
		BOOL		GetProp			(PAJCIVPROP	pBuf);								//	プロパティ取得
		BOOL		SetProp			(PCAJCIVPROP pProp);							//	プロパティ設定
		COLORREF	GetBorderColor	();												//	コントロール外枠の表示色取得
		BOOL		SetBorderColor	(COLORREF color);								//	コントロール外枠の表示色設定
		COLORREF	GetBlinkColor	();												//	ブリンク表示色取得
		BOOL		SetBlinkColor	(COLORREF color);								//	ブリンク表示色設定
		HWND		GetSilderHandle	();												//	スライダのウインドハンドル取得
		HWND		GetBtnHandle	();												//	ボタンのウインドハンドル取得
		HWND		GetTxtHandle	();												//	テキストボックスのウインドハンドル取得
		HWND		GetSpnHandle	();												//	スピンボタンのウインドハンドル取得
		UI			GetTxtLen		();												//	テキストボックスのサイズ（桁数）取得
		BOOL		SetTxtLen		(UI len);										//	テキストボックスのサイズ（桁数）設定
		BOOL		SetNtcRClk		(BOOL fNtcRClk, UI msgRBtnDown, UI msgRBtnUp);	//	右ボタン操作通知設定
		double		GetValue		();												//	値の取得（実数）
		int			GetValueInt		();												//	値の取得（整数）
		BOOL		SetValue		(double value, BOOL fNtc = FALSE);				//	値の設定
		BOOL		SetRange		(double minValue, double maxValue);				//	数値範囲の設定
		BOOL		SetSldUnit		(double unit);									//	数値の最小単位値の設定
		BOOL		SetSldPage		(double page);									//	スライダのページサイズ設定
		BOOL		SetSpnStep		(double step);									//	スピンボタンのステップサイズ設定
		BOOL		SetPrecision	(int prec);										//	数値の精度設定

		BOOL		SetTipText		(C_BCP pTipTxt);								//	ツールチップの設定（ASCII）
		BOOL		SetTipText		(C_WCP pTipTxt);								//	ツールチップの設定（UNICODE）

		UI			GetTipText		(BCP pBuf, UI lBuf);							//	ツールチップの取得（ASCII）
		UI			GetTipText		(WCP pBuf, UI lBuf);							//	ツールチップの取得（UNICODE）

		BOOL		SetTipShowAlways(BOOL fShowAlways);								//	ツールチップ表示条件の設定
		BOOL		GetTipShowAlways();												//	ツールチップ表示条件の取得


		BOOL		EnaDefTipText	(BOOL fEnable);									//	デフォルト ツールチップテキストの許可／禁止

		BOOL		GetEditState	();												//	数値編集状態の取得

		BOOL		LoadPermInfo	(C_BCP pProfileSect =  "InpPerm_*", C_BCP pKey =  "Inp", BOOL fNtc = FALSE);	//	永続化情報の読み出し(ASCII)
		BOOL		LoadPermInfo	(C_WCP pProfileSect = L"InpPerm_*", C_WCP pKey = L"Inp", BOOL fNtc = FALSE);	//	永続化情報の読み出し(UNICODE)

		BOOL		SavePermInfo	();												//	永続化情報の書き込み

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual VO Attach		 (HWND hWnd);										//	ハンドルを関連付け

		virtual VO OnNtcIntValue (int	 val);										//	整数モードでの数値変化通知
		virtual VO OnNtcRealValue(double val);										//	実数モードでの数値変化通知
		virtual VO OnNtcRClick	 (PCAJCIVRCLK pRClk);								//	右クリック通知
	};
}
/****************************************************************************************************************/
#endif
