﻿#ifndef	AJXPPC_H_
#define	AJXPPC_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	Ｃ言語 プリコンパイル																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxPpc {
		HAJCPPC	m_hPpc;					//	ＣＰＰインスタンスドハンドル

	public:
		CAjxPpc();						//	コンストラクタ
		~CAjxPpc();						//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		AJCPPCRESULT	PreCompile(	C_BCP pSrcPath,											//	プリコンパイル実行
									EAJCTEC			tecSrc 		= AJCTEC_AUTO,
									C_BCP			pBasePath 	= NULL,
									PAJCLBXITEMA	pIncPath	= NULL,
									PAJCLBXITEMA	pOptSym	 	= NULL,
									UI				opt		 	= AJCPPC_FLG_AUTO_SEARCH | AJCPPC_FLG_GENALL);

		PAJCPPCTKNNODE GetObject 	(PAJCPPCTKNNODE *ppNoGen);								//	プリコンパイル済オブジェクトの取得
		BOOL	Stop				();														//	プリコンパイル中止
		BOOL	GetMacroInfo		(C_BCP pMacName, PAJCPPCMACINFO pMacInfo);				//	マクロ情報取得
		UI		EnumMacro			();														//	マクロ列挙
		BOOL	TokenStreamToFile	(C_BCP pOutPath,										//	ファイル出力
									 EAJCTEC tecOut    = AJCTEC_AUTO,
									 BOOL	 bomOut    = FALSE,
									 BOOL	 fExpInc   = TRUE,
									 UI CommOutOfkndPP = AJCPPC_PPK_ALL);

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO		OnNtcAnyEvt		(AJCPPCNOTIFY evt);										//	いずれかのイベント発生
		virtual	VO		OnNtcFileLno	(C_BCP pFile, UI lno, UI nest);							//	ファイル名，行番号通知
		virtual	VO		OnNtcSrhStart	(C_BCP pIncFile, C_BCP pDirPath);						//	インクルードファイル検索開始通知
		virtual	VO		OnNtcSrhDir		(				 C_BCP pDirPath);						//	インクルードファイル検索中のフォルダ通知
		virtual	VO		OnNtcSrhEnd		(C_BCP pIncFile, BOOL fFind);							//	インクルードファイル検索終了通知
		virtual	VO		OnNtcOptSym		(PCAJCPPCTKNNODE pTkn);									//	プリプロセス用オプションシンボル通知
		virtual	VO		OnNtcMacDef		(PCAJCPPCTKNNODE pTkn, PCAJCPPCMACINFO pMac);			//	マクロ定義通知
		virtual	VO		OnNtcMacRef		(PCAJCPPCTKNNODE pTkn, PCAJCPPCMACINFO pMac);			//	マクロ参照通知
		virtual	VO		OnNtcOutLoop	(VO);													//	トークンストリームをファイルへ出力ループ中
		virtual	VO		OnNtcSrcTec		(C_BCP pFilePath, EAJCTEC tec, BOOL fBom);				//	ソースファイルのエンコード通知
		virtual	VO		OnNtcToken		(EAJCTKCODE tkn, C_BCP pTkn);							//	トークン通知
		virtual	VO		OnNtcError		(AJCPPCERROR err, C_BCP pFile, UI lno, C_BCP pErrTxt);	//	エラー通知
		virtual	BOOL	OnNtcMacInfo	(PCAJCPPCMACINFO pMacInfo);								//	マクロ列挙通知
	};
}
/****************************************************************************************************************/
#endif
