﻿#ifndef	AJXPRN_H_
#define	AJXPRN_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	印刷																										//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxPrn {
		BOOL	m_fUnicode;
		HWND	m_hWndOwner;
		union {
			BC		bc[AJCPRN_MAX_PRNNAME];
			WC		wc[AJCPRN_MAX_PRNNAME];
		} PrnName;
	public:
		HAJCPRN	m_hPrn;
		#ifdef UNICODE
			CAjxPrn(BOOL fUnicode = TRUE);		//	コンストラクタ(UNICODE)
		#else
			CAjxPrn(BOOL fUnicode = FALSE);		//	コンストラクタ(ASCII)
		#endif
		~CAjxPrn();								//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		BOOL		SetMargin	(PAJCPRN_MARGIN pmmMargin);									//	余白サイズ設定
		BOOL		SelectDialog(PAJCPRN_INFO pInfo, UI 		 Flag, HWND hWndOwner);		//	プリンタの選択ダイアログ表示
		BOOL		PrintDialog	(PAJCPRN_INFO pInfo, PAJCPRN_OPT pOpt, HWND hWndOwner);		//	印刷ダイアログ表示
		int			Start		(BOOL fUseDib = FALSE, BOOL fOutputToFile = FALSE);			//	印刷開始
		VO			GetInfo		(PAJCPRN_INFO pBuf, BCP pPrnName, UI lPrnName);				//	プリンタ設定情報取得(ASCII)
		VO			GetInfo		(PAJCPRN_INFO pBuf, WCP pPrnName, UI lPrnName);				//	プリンタ設定情報取得(UNICODE)

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	BOOL	OnQueryPage				(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo);			//	ページ印刷開始通知
		virtual	BOOL	OnDrawByDibSectDC		(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo);	//	ＤＩＢセクション・ビットマップによる描画
		virtual	BOOL	OnDrawByPrinterDC		(HDC hdc, PCAJCPRN_INFO pPrnInfo);							//	プリンタＤＣによる描画
	};
}
/****************************************************************************************************************/
#endif
