﻿#ifndef	AJXQUE_H_
#define	AJXQUE_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	線形リスト																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxQue {
		UI			m_DefSize;			//	デフォルトデータバイト数

	public:
		HAJCVQUE	m_hQue;				//	ＱＵＥインスタンスドハンドル
		BOOL	m_fDestruct;			//	デストラクト中を示すフラグ

		CAjxQue();						//	コンストラクタ
		~CAjxQue();						//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		VO			SetDefSize(UI DefSize);								//	ノードデータの規定バイト数設定
		UI			GetDefSize();										//	ノードデータの規定バイト数取得
		VOP			Enque	(C_VOP pDat, UI lDat = -1);					//	ノードを末尾へ追加
		VOP			EnqTop	(C_VOP pDat, UI lDat = -1);					//	ノードを先頭へ挿入
		UI			Deque	(VOP pBuf, UI lBuf = -1);					//	先頭ノード取り出し
		BOOL		Purge	();											//	全ノード消去
		UI			GetCount();											//	ノードの個数取得
		BOOL		Merge	(CAjxQue* pSrc);							//	２つのリストをマージ
		VOP			TopNode	(UIP pBytes);								//	先頭ノードアドレス取得
		VOP			NextNode(C_VOP pCurrentNode, UIP pBytes = NULL);	//	次のノードアドレス取得
		PCAJCVQUEPTR CreatePtrArr (UIP pNum = NULL);					//	全ノードへのポインタ配列生成
		VO	 		 ReleasePtrArr(PCAJCVQUEPTR pArr);					//	全ノードへのポインタ配列解放
		BOOL		EnableMultiThread	(BOOL fEnable);					//	マルチスレッドの許可／禁止

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO	OnNtcRemove(VOP pNodeDat, UI len);					//	ノード消去通知

	};
}
/****************************************************************************************************************/
#endif
