﻿#ifndef	AJXQUEX_H_
#define	AJXQUEX_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	双方向リスト																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	クラス定義																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxXQue {
		UI			m_DefSize;			//	デフォルトデータバイト数

	public:
		HAJCXQUE	m_hXQue;			//	ＱＵＥインスタンスドハンドル
		BOOL		m_fDestruct;		//	デストラクト中を示すフラグ

		CAjxXQue();						//	コンストラクタ
		~CAjxXQue();					//	デストラクタ

		//----- メンバ関数 -------------------------------------------------------------------------------------//
		VO			SetDefSize(UI DefSize);									//	ノードデータの規定バイト数設定
		UI			GetDefSize();											//	ノードデータの規定バイト数取得
		VOP			Enque	(C_VOP pDat, UI lDat = -1);						//	ノードを末尾へ追加
		VOP			EnqTop	(C_VOP pDat, UI lDat = -1);						//	ノードを先頭へ挿入
		VOP			Insert	(C_VOP pDat, UI lDat = -1, C_VOP pIns = NULL);	//	ノードを任意の位置に挿入
		UI			Remove	(C_VOP pDat);									//	ノード削除
		UI			Deque	(VOP pBuf, UI lBuf = -1);						//	先頭ノード取り出し
		BOOL		Purge	();												//	全ノード消去
		UI			GetCount();												//	ノードの個数取得
		BOOL		Merge	(CAjxXQue* pSrc);								//	２つのリストをマージ
		VOP			TopNode	(UIP pBytes);									//	先頭ノードアドレス取得
		VOP			LastNode(UIP pBytes);									//	末尾ノードアドレス取得
		VOP			NextNode(C_VOP pCurrentNode, UIP pBytes = NULL);		//	次のノードアドレス取得
		VOP			PrevNode(C_VOP pCurrentNode, UIP pBytes = NULL);		//	前のノードアドレス取得
		PCAJCXQUEPTR CreatePtrArr (UIP pNum = NULL);						//	全ノードへのポインタ配列生成
		VO	 		 ReleasePtrArr(PCAJCXQUEPTR pArr);						//	全ノードへのポインタ配列解放
		BOOL		EnableMultiThread	(BOOL fEnable);						//	マルチスレッドの許可／禁止

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO	OnNtcRemove(VOP pNodeDat, UI len);						//	ノード消去通知

	};
}
/****************************************************************************************************************/
#endif
