﻿#ifndef	AJXSSV_H_
#define	AJXSSV_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ソケット通信（サーバ側）個々のクライアント処理																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxSsvCli {
		HAJCSSVCLI m_hCli;
	public:
		CAjxSsvCli();								//	コンストラクタ
		~CAjxSsvCli();								//	デストラクタ

		//----- メンバ関数（クライアント処理）------------------------------------------------------------------//
		VO		SetCliHandle	(HAJCSSVCLI hCli);				//	クライアントハンドル設定

		C_BCP	GetIpAddrStr	(BCP pBuf, UI lBuf);			//	ＩＰアドレス文字列取得(ASCII)
		C_WCP	GetIpAddrStr	(WCP pBuf, UI lBuf);			//	ＩＰアドレス文字列取得(UNICODE)

		AJCSSV_TEXTCODE	GeActualtRxTextCode();					//	実際の受信テキストの文字コード取得
		AJCSSV_TEXTCODE	GetActualTxTextCode();					//	実際の送信テキストの文字コード取得

		BOOL	SendChar		(BC code);						//	クライアントへ１文字送信(ASCII)
		BOOL	SendChar		(WC code);						//	クライアントへ１文字送信(UNICODE)

		BOOL	SendText		(C_BCP pTxt, UI lTxt = -1);		//	クライアントへテキストデータ送信(ASCII)
		BOOL	SendText		(C_WCP pTxt, UI lTxt = -1);		//	クライアントへテキストデータ送信(UNICODE)

		BOOL	SendTextF		(C_BCP pFmt, ...);				//	クライアントへ書式テキスト送信(ASCII)
		BOOL	SendTextF		(C_WCP pFmt, ...);				//	クライアントへ書式テキスト送信(UNICODE)

		BOOL	SendBinData		(C_VOP pDat, UI lDat);			//	クライアントへバイナリデータ送信
		UI		SendPacket		(C_VOP pPkt, UI lPkt);			//	クライアントへパケットデータ送信

		BOOL	PurgeRecvData	();								//	全受信済データ破棄
		BOOL	PurgeSendData	();								//	全送信待ちデータ破棄
		BOOL	PurgeAllData	();								//	全受信済データと送信待ちデータ破棄

		BOOL	SetClientData	(UX data);						//	クライアントにデータを関連付ける
		UX		GetClientData	();								//	クライアントに関連付けたデータ取得

		UI		GetSeqNo		();								//	接続順序番号取得
		UI		GetIndex		();								//	クライアントのインデクス値取得

		BOOL	Disconnect		();								//	回線切断

		//----- 仮想関数 ---------------------------------------------------------------------------------------//
		virtual	VO	OnNtcConnect	();							//	クライアント接続通知
		virtual	VO	OnNtcDisconnect	();							//	クライアント切断通知

		virtual VO	OnNtcRxTextChunk(C_BCP pText);				//	テキストチャンク受信通知(ASCII)
		virtual VO	OnNtcRxTextChunk(C_WCP pText);				//	テキストチャンク受信通知(UNICODE)

		virtual VO	OnNtcRxBinChunk	(C_VOP pData, UI Bytes);	//	バイナリチャンク受信通知

		virtual VO	OnNtcRxText		(C_BCP pText);				//	テキスト受信通知(ASCII)
		virtual VO	OnNtcRxText		(C_WCP pText);				//	テキスト受信通知(UNICODE)

		virtual VO	OnNtcRxEsc		(C_BCP pText);				//	ＥＳＣシーケンス受信通知(ASCII)
		virtual VO	OnNtcRxEsc		(C_WCP pText);				//	ＥＳＣシーケンス受信通知(UNICODE)

		virtual VO	OnNtcRxCtrl		(UI Ctrl);					//	制御コード受信通知
		virtual VO	OnNtcRxPkt		(C_VOP pData, UI Bytes);	//	パケット受信通知
		virtual VO	OnNtcTxEmpty	();							//	送信完了通知

		virtual VO	OnNtcRxNoPkt	(C_BCP pText);				//	パケット外データ受信通知
		virtual VO	OnNtcRxNoPkt	(C_WCP pText);				//	パケット外データ受信通知

		virtual VO	OnNtcInvChunk	(C_VOP pData, UI lData);	//	不正テキストチャンク受信通知

		virtual VO	OnNtcRxError	(UI error);					//	受信エラー通知
		virtual VO	OnNtcTxError	(UI error);					//	送信エラー通知
	};
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ソケット通信（サーバ側）  サーバ処理																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
namespace  AjxControl {
	class  AJXEXPORT CAjxSsvSvr {
		ATOM	m_Atom;					//	イベント通知用クラスハンドル
		HWND	m_hWndEvt;				//	イベント通知用ウインド
		HAJCAVL	m_hAvl;					//	クライアントクラス格納用ＡＶＬ
		UIP		m_pMap;					//	インデクス決め用マップテーブル
		UI		m_MaxClients;			//	クライアント最大接続数

	public:
		HAJCSSV	m_hSsv;					//	ＳＳＶインスタンスドハンドル
		BOOL	m_fUnicode;				//	UNICODEフラグ

		CAjxSsvSvr();					//	コンストラクタ
		~CAjxSsvSvr();					//	デストラクタ

		//----- 内部サブ関数 -----------------------------------------------------------------------------------//
		HAJCAVL		GetAvl();			//	ＡＶＬハンドル取得

		//----- メンバ関数（サーバ処理）------------------------------------------------------------------------//
		//	サーバ開始
		#ifdef _CONSOLE
			BOOL			Start			(C_BCP pPort, UI MaxClients = 10, BOOL fUseWaitEvent = TRUE , int AddressFamily = AF_INET);	//	サーバ開始(ASCII)
			BOOL			Start			(C_WCP pPort, UI MaxClients = 10, BOOL fUseWaitEvent = TRUE , int AddressFamily = AF_INET);	//	サーバ開始(UNICODE)
		#else
			BOOL			Start			(C_BCP pPort, UI MaxClients = 10, BOOL fUseWaitEvent = FALSE, int AddressFamily = AF_INET);	//	サーバ開始(ASCII)
			BOOL			Start			(C_WCP pPort, UI MaxClients = 10, BOOL fUseWaitEvent = FALSE, int AddressFamily = AF_INET);	//	サーバ開始(UNICODE)
		#endif
		BOOL				Stop			();											//	サーバ停止

		BOOL				SetOpt			(AJCSSV_SERVOPT opt);						//	オプションの設定
		AJCSSV_SERVOPT		GetOpt			();											//	オプションの取得

		BOOL				SetChunkMode	(AJCSSV_CHUNKMODE ChunkMode);				//	チャンクデータの通知モード設定
		AJCSSV_CHUNKMODE	GetChunkMode	();											//	チャンクデータの通知モード取得

		BOOL				SetEvtMask		(UI EvtMsk);								//	イベントマスク設定
		UI		 			GetEvtMask		();											//	イベントマスク取得

		BOOL				SetRxTextCode	(AJCSSV_TEXTCODE code);						//	受信テキストの文字コード設定
		AJCSSV_TEXTCODE		GetRxTextCode	();											//	受信テキストの文字コード取得

		BOOL				SetTxTextCode	(AJCSSV_TEXTCODE code);						//	送信テキストの文字コード設定
		AJCSSV_TEXTCODE		GetTxTextCode	();											//	送信テキストの文字コード取得

		BOOL				WaitEvent		(UI msTime);								//	イベント発生待ち

		BOOL				SetPktCtrlCode	(UI stx, UI etx, UI dle);					//	パケットフレームを認識する為の制御コード設定
		BOOL				GetPktCtrlCode	(UIP pStx, UIP pEtx, UIP pDle);				//	パケットフレームを認識する為の制御コード取得

		BOOL				SetPktTimeout	(UI msTime);								//	パケットフレーム受信タイムアウト値設定
		BOOL				GetPktTimeout	(UIP pMsTime);								//	パケットフレーム受信タイムアウト値取得

		UI					GetClientCount	();											//	接続済のクライアント数取得
		UI					GetConnectCount	();											//	通算接続回数取得

		UI					EnumClients		();											//	接続済の全クライアント列挙

		BOOL				SetClientData	(HAJCSSVCLI hCli, UX data);					//	クライアントにデータを関連付ける
		UX					GetClientData	(HAJCSSVCLI hCli);							//	クライアントに関連付けたデータ取得

		//----- 仮想関数（サーバ処理） -------------------------------------------------------------------------//
		virtual	VO			OnNtcStart		();											//	サーバ開始通知
		virtual	VO			OnNtcStop		();											//	サーバ停止通知
		virtual	VO			OnNtcError		(UI err);									//	エラー通知
		virtual	BOOL		OnNtcClients	(HAJCSSVCLI hCli, CAjxSsvCli* pCli);		//	クライアント列挙


		//----- 仮想関数（クライアント処理） -------------------------------------------------------------------//
		virtual	CAjxSsvCli*	OnNtcConnect	(HAJCSSVCLI hCli);							//	クライアント接続通知
		virtual	VO			OnNtcDisconnect	(HAJCSSVCLI hCli, CAjxSsvCli* pCli);		//	クライアント切断通知

		virtual VO			OnNtcRxTextChunk(HAJCSSVCLI hCli, C_BCP pText);				//	テキストチャンク受信通知(ASCII)
		virtual VO			OnNtcRxTextChunk(HAJCSSVCLI hCli, C_WCP pText);				//	テキストチャンク受信通知(UNICODE)

		virtual VO			OnNtcRxBinChunk	(HAJCSSVCLI hCli, C_VOP pData, UI Bytes);	//	バイナリチャンク受信通知

		virtual VO			OnNtcRxText		(HAJCSSVCLI hCli, C_BCP pText);				//	テキスト受信通知(ASCII)
		virtual VO			OnNtcRxText		(HAJCSSVCLI hCli, C_WCP pText);				//	テキスト受信通知(UNICODE)

		virtual VO			OnNtcRxEsc		(HAJCSSVCLI hCli, C_BCP pData);				//	ＥＳＣシーケンス受信通知(ASCII)
		virtual VO			OnNtcRxEsc		(HAJCSSVCLI hCli, C_WCP pData);				//	ＥＳＣシーケンス受信通知(UNICODE)

		virtual VO			OnNtcRxCtrl		(HAJCSSVCLI hCli, UI Ctrl);					//	制御コード受信通知
		virtual VO			OnNtcRxPkt		(HAJCSSVCLI hCli, C_VOP pData, UI Bytes);	//	パケット受信通知
		virtual VO			OnNtcTxEmpty	(HAJCSSVCLI hCli);							//	送信完了通知

		virtual VO			OnNtcRxNoPkt	(HAJCSSVCLI hCli, C_BCP pText);				//	パケット外データ受信通知
		virtual VO			OnNtcRxNoPkt	(HAJCSSVCLI hCli, C_WCP pText);				//	パケット外データ受信通知

		virtual VO			OnNtcInvChunk	(HAJCSSVCLI hCli, C_VOP pData, UI lData);	//	不正テキストチャンク受信通知

		virtual VO			OnNtcRxError	(HAJCSSVCLI hCli, UI error);				//	受信エラー通知
		virtual VO			OnNtcTxError	(HAJCSSVCLI hCli, UI error);				//	送信エラー通知

	};
}
/****************************************************************************************************************/
#endif
