﻿#include	"AjcInternal.h"

#define	INST_ID			0x90BBA6B5
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//**************************************************************************************************************//
//																												//
//	平衡２分木（ＡＶＳ木，文字列キー）																			//
//																												//
//**************************************************************************************************************//

#define		AVS_ENTER	if (pW->fMultiThread) EnterCriticalSection(&pW->cs);
#define		AVS_LEAVE	if (pW->fMultiThread) LeaveCriticalSection(&pW->cs);

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	int		CALLBACK cbMyStrCmpA(UX key1, UX key2, UX cbp);
static	int		CALLBACK cbMyStrCmpW(UX key1, UX key2, UX cbp);

static	VO		CALLBACK cbMyNtcDel (UX key, VOP pNode, UI len, UI nest, UX cbp);

//==============================================================================================================//
//	ＡＶＳインスタンスの生成																					//
//																												//
//	引　数	：	CmpMode			 - 文字列比較モード（AJCCMP_{EXACT_WIDTH / IGNORE_WIDTH / MIX} ）				//
//				cbp 			 - コールバックパラメタ															//
//				cbNtcDelNodeData - 削除ノードデータ通知用コールバック（不要時は、ＮＵＬＬ）						//
//																												//
//	戻り値	：	≠NULL - ＯＫ（インスタンスハンドル）															//
//				＝NULL - エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCAVS	WINAPI	AjcAvsCreateA(EAJCCMPMODE CmpMode, UX cbp, VO (CALLBACK *cbNtcDelNodeData)(C_BCP pKey, VOP pNodeData, UI len, UI nest, UX cbp))
{
	HAJCAVS		pW = NULL;

	if ((pW = (HAJCAVS)AJCMEM(sizeof(AJCAVS))) != NULL) {
		//	インスタンスワーク初期化
		memset(pW, 0, sizeof *pW);
		pW->InstID	 = INST_ID;
		pW->fUnicode = FALSE;
		pW->CmpMode  = CmpMode;
		pW->cbp 	 = cbp;
		pW->hAvl	 = AjcAvlCreate ((UX)pW, cbMyStrCmpA, cbMyNtcDel);
		pW->hSpl	 = AjcSplCreateA(CmpMode);
		pW->u.cbNtcDelA = cbNtcDelNodeData;
		//	失敗ならば、リソース解放
		if (pW->hAvl == NULL || pW->hSpl == NULL) {
			if (pW->hAvl == NULL) AjcAvlDelete(pW->hAvl);
			if (pW->hSpl == NULL) AjcSplDelete(pW->hSpl);
			free(pW);
			pW = NULL;
		}
	}
	return pW;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCAVS	WINAPI	AjcAvsCreateW(EAJCCMPMODE CmpMode, UX cbp, VO (CALLBACK *cbNtcDelNodeData)(C_WCP pKey, VOP pNodeData, UI len, UI nest, UX cbp))
{
	HAJCAVS		pW = NULL;

	if ((pW = (HAJCAVS)AJCMEM(sizeof(AJCAVS))) != NULL) {
		//	インスタンスワーク初期化
		memset(pW, 0, sizeof *pW);
		pW->InstID	 = INST_ID;
		pW->fUnicode = TRUE;
		pW->CmpMode  = CmpMode;
		pW->cbp 	 = cbp;
		pW->hAvl	 = AjcAvlCreate ((UX)pW, cbMyStrCmpW, cbMyNtcDel);
		pW->hSpl	 = AjcSplCreateW(CmpMode);
		pW->u.cbNtcDelW = cbNtcDelNodeData;
		//	失敗ならば、リソース解放
		if (pW->hAvl == NULL || pW->hSpl == NULL) {
			if (pW->hAvl != NULL) AjcAvlDelete(pW->hAvl);
			if (pW->hSpl != NULL) AjcSplDelete(pW->hSpl);
			free(pW);
			pW = NULL;
		}
	}
	return pW;
}

//==============================================================================================================//
//	ＡＶＳインスタンスの削除																					//
//																												//
//	引　数	：	pW		- インスタンスワークのアドレス															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - パラメタエラー																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcAvsDelete			(HAJCAVS pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {

		AVS_ENTER
		if (pW->hAvl != NULL) AjcAvlDelete(pW->hAvl);
		if (pW->hSpl != NULL) AjcSplDelete(pW->hSpl);
		AVS_LEAVE

		if (pW->fMultiThread) {
			DeleteCriticalSection(&pW->cs);
		}
		free(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	マルチスレッドの許可／禁止																					//
//																												//
//	引　数	：	pW		- インスタンスワークのアドレス															//
//				fEnable - FALSE : マルチスレッド禁止															//
//						  TRUE	: マルチスレッド許可															//
//																												//
//	戻り値	：	前回の許可／禁止状態																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcAvsEnableMultiThread	(HAJCAVS pW, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		rc = pW->fMultiThread;
		if (fEnable) {
			if (!pW->fMultiThread) {
				InitializeCriticalSection(&pW->cs);
				pW->fMultiThread = TRUE;
			}
		}
		else {
			if (pW->fMultiThread) {
				pW->fMultiThread = FALSE;
				DeleteCriticalSection(&pW->cs);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	コールバックパラメタの設定																					//
//																												//
//	引　数	：	pW		- インスタンスワークのアドレス															//
//				cbp 	- コールバックパラメタ																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - パラメタエラー																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcAvsSetCbp			(HAJCAVS pW, UX cbp)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		pW->cbp = cbp;
		AVS_LEAVE
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	文字列比較モードの設定																						//
//																												//
//	引　数	：	pW		 - インスタンスワークのアドレス															//
//				CmpMode	 - 文字列比較モード（AJCCMP_{EXACT_WIDTH / IGNORE_WIDTH / MIX} ）						//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - パラメタエラー																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcAvsSetCompMode			(HAJCAVS pW, EAJCCMPMODE CmpMode)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		pW->CmpMode = CmpMode;
		AVS_LEAVE
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ノード挿入																									//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				pKey 	  - 文字列キーへのポインタ																//
//				pNodeData - 挿入するノードデータのアドレス														//
//				len 	  - 挿入するノードデータのバイト数（０～６５５３５）									//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - 同一キーのノードあり／ノードメモリ割り当て失敗／パラメタエラー							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsInsNodeA			(HAJCAVS pW, C_BCP pKey, C_VOP pNodeData, UI len)
{
	BOOL	rc = FALSE;
	C_BCP	pTmp;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		if (pTmp = AjcSplRegistA(pW->hSpl, pKey)) {
			if (!(rc = AjcAvlInsNode(pW->hAvl, (UX)pTmp, pNodeData, len))) {
			//	AjcSplRemoveA(pW->hSpl, pKey);	//	同一キー消失不具合修正
			}
		}
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsInsNodeW			(HAJCAVS pW, C_WCP pKey, C_VOP pNodeData, UI len)
{
	BOOL	rc = FALSE;
	C_WCP	pTmp;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		if (pTmp = AjcSplRegistW(pW->hSpl, pKey)) {
			if (!(rc = AjcAvlInsNode(pW->hAvl, (UX)pTmp, pNodeData, len))) {
			//	AjcSplRemoveW(pW->hSpl, pKey);	//	同一キー消失不具合修正
			}
		}
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	ノード取得（ノード検索）																					//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				pKey 	  - 文字列キーへのポインタ																//
//				pBuf	  - 見つかったノードデータを格納するバッファのアドレス（不要時はＮＵＬＬ）				//
//				lBuf	  - 見つかったノードデータを格納するバッファのバイト数									//
//																												//
//	戻り値	：	≠-1 - ＯＫ（当該ノード・データのバイト数）														//
//				＝-1 - 指定されたキーが見つからない																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcAvsGetNodeA			(HAJCAVS pW, C_BCP pKey, VOP	 pBuf,		UI lBuf)
{
	int		rc = -1;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		rc = AjcAvlGetNodeByKey(pW->hAvl, (UX)pKey, pBuf, lBuf);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcAvsGetNodeW			(HAJCAVS pW, C_WCP pKey, VOP	 pBuf,		UI lBuf)
{
	int		rc = -1;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		rc = AjcAvlGetNodeByKey(pW->hAvl, (UX)pKey, pBuf, lBuf);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	ノードポインタ取得（ノード検索）																			//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				pKey 	  - 文字列キーへのポインタ																//
//				pLen	  - 見つかったノードデータのバイト数を格納するバッファのアドレス（不要時はＮＵＬＬ）	//
//																												//
//	戻り値	：	≠NULL - ＯＫ（当該ノード・データへのポインタ）													//
//				＝NULL - 指定されたキーが見つからない／パラメタエラー											//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VOP		WINAPI	AjcAvsGetNodePtrA		(HAJCAVS pW, C_BCP pKey, UIP pLen)
{
	VOP		rc = NULL;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		rc = AjcAvlGetNodePtr(pW->hAvl, (UX)pKey, pLen);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VOP		WINAPI	AjcAvsGetNodePtrW		(HAJCAVS pW, C_WCP pKey, UIP pLen)
{
	VOP		rc = NULL;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		rc = AjcAvlGetNodePtr(pW->hAvl, (UX)pKey, pLen);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	ノードのキー文字列へのポインタ取得																			//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				pNode 	  - ノードへのポインタ																	//
//																												//
//	戻り値	：	≠NULL - ＯＫ（当該ノード・文字列キーへのポインタ）												//
//				＝NULL - 指定されたキーが見つからない／パラメタエラー											//
//==============================================================================================================//
AJCEXPORT	C_VOP		WINAPI	AjcAvsGetNodeKey		(HAJCAVS pW, VOP pNode)
{
	C_VOP	rc = NULL;
	UX		key;

	if (IS_MY_INST(pW) && pNode != NULL) {
		key = AjcAvlGetNodeKey(pW->hAvl, pNode);
		if (key != -1) rc = (C_VOP)key;
	}
	return rc;
}
//==============================================================================================================//
//	先頭ノード取得																								//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				ppKey	  - 先頭ノードのキー値(文字列へのポインタ)を格納するバッファのアドレス（不要時はNULL）	//
//				pBuf	  - 見つかったノードデータを格納するバッファのアドレス（不要時はＮＵＬＬ）				//
//				lBuf	  - 見つかったノードデータを格納するバッファのバイト数									//
//																												//
//	戻り値	：	≠-1 - ＯＫ（当該ノード・データのバイト数）														//
//				＝-1 - ノードなし																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcAvsGetTopNodeA		(HAJCAVS pW, C_BCP *ppKey, VOP pBuf, UI lBuf)
{
	int		rc = -1;

	if (IS_MY_INST(pW) && ppKey != NULL) {
		AVS_ENTER
		rc = AjcAvlGetTopNode(pW->hAvl, (UXP)ppKey, pBuf, lBuf);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcAvsGetTopNodeW		(HAJCAVS pW, C_WCP *ppKey, VOP pBuf, UI lBuf)
{
	int		rc = -1;

	if (IS_MY_INST(pW) && ppKey != NULL) {
		AVS_ENTER
		rc = AjcAvlGetTopNode(pW->hAvl, (UXP)ppKey, pBuf, lBuf);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	最終ノード取得																								//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				ppKey	  - 最終ノードのキー値(文字列へのポインタ)を格納するバッファのアドレス（不要時はNULL）	//
//				pBuf	  - 見つかったノードデータを格納するバッファのアドレス（不要時はＮＵＬＬ）				//
//				lBuf	  - 見つかったノードデータを格納するバッファのバイト数									//
//																												//
//	戻り値	：	≠-1 - ＯＫ（当該ノード・データのバイト数）														//
//				＝-1 - ノードなし																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcAvsGetLastNodeA		(HAJCAVS pW, C_BCP *ppKey, VOP pBuf, UI lBuf)
{
	int		rc = -1;

	if (IS_MY_INST(pW) && ppKey != NULL) {
		AVS_ENTER
		rc = AjcAvlGetLastNode(pW->hAvl, (UXP)ppKey, pBuf, lBuf);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcAvsGetLastNodeW		(HAJCAVS pW, C_WCP *ppKey, VOP pBuf, UI lBuf)
{
	int		rc = -1;

	if (IS_MY_INST(pW) && ppKey != NULL) {
		AVS_ENTER
		rc = AjcAvlGetLastNode(pW->hAvl, (UXP)ppKey, pBuf, lBuf);
		AVS_LEAVE
	}
	return rc;
}

//==============================================================================================================//
//	ノード置換																									//
//																												//
//	引　数	：	pW		  	- インスタンスハンドル																//
//				pKey 	  	- 文字列キーへのポインタ															//
//				pNodeData	- 置換する新ノードデータのアドレス													//
//				len 	 	- 置換する新ノードデータのバイト数（０～６５５３５）								//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - 指定されたキーが見つからない／ノードメモリ割り当て失敗／パラメタエラー					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsRepNodeA			(HAJCAVS pW, C_BCP pKey, C_VOP pNodeData, UI len)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		rc = AjcAvlRepNode(pW->hAvl, (UX)pKey, pNodeData, len);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsRepNodeW			(HAJCAVS pW, C_WCP pKey, C_VOP pNodeData, UI len)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		rc = AjcAvlRepNode(pW->hAvl, (UX)pKey, pNodeData, len);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	ノード挿入／置換																							//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				pKey 	  - 文字列キーへのポインタ																//
//				pNodeData - 置換するノードデータのアドレス														//
//				len		  - 置換するノードデータのバイト数														//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - ノードメモリ割り当て失敗／パラメタエラー												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsInsOrRepNodeA		(HAJCAVS pW, C_BCP pKey, C_VOP pNodeData, UI len)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		if (AjcAvlGetNodePtr(pW->hAvl, (UX)pKey, NULL) != NULL) {
			rc = AjcAvsRepNodeA(pW, pKey, pNodeData, len);
		}
		else {
			rc = AjcAvsInsNodeA(pW, pKey, pNodeData, len);
		}
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsInsOrRepNodeW		(HAJCAVS pW, C_WCP pKey, C_VOP pNodeData, UI len)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		if (AjcAvlGetNodePtr(pW->hAvl, (UX)pKey, NULL) != NULL) {
			rc = AjcAvsRepNodeW(pW, pKey, pNodeData, len);
		}
		else {
			rc = AjcAvsInsNodeW(pW, pKey, pNodeData, len);
		}
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	ノード削除																									//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				key 	  - 削除するノードのキー																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - 指定されたキーのノードが見つからない／パラメタエラー									//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsDelNodeA			(HAJCAVS pW, C_BCP pKey)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		if (rc = AjcAvlDelNode(pW->hAvl, (UX)pKey)) {
			AjcSplRemoveA(pW->hSpl, pKey);
		}
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsDelNodeW			(HAJCAVS pW, C_WCP pKey)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pKey != NULL && *pKey != 0) {
		AVS_ENTER
		if (rc = AjcAvlDelNode(pW->hAvl, (UX)pKey)) {
			AjcSplRemoveW(pW->hSpl, pKey);
		}
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノード削除																								//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - パラメタエラー																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcAvsDelAllNodes		(HAJCAVS pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlDelAllNodes(pW->hAvl);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	ノード数取得																								//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//																												//
//	戻り値	：	ノード数（パラメタエラー時は、０を返す）														//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcAvsGetCount	(HAJCAVS pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlGetCount(pW->hAvl);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノード取得																								//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				cbp			 - コールバックパラメタ																//
//				cbNtcNode	 - 取得したノードを通知するコールバック関数（不要時はＮＵＬＬ）						//
//				fDownSeq	 - FALSE:昇順，TRUE:降順															//
//																												//
//	戻り値	：	ノード数																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesA (HAJCAVS pW, AJCAVS_CBNTCA cbNtcNodeData, BOOL fDownSeq)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlEnumNodesEx(pW->hAvl, pW->cbp, (AJCAVL_CBNTC)cbNtcNodeData, fDownSeq);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesW (HAJCAVS pW, AJCAVS_CBNTCW cbNtcNodeData, BOOL fDownSeq)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlEnumNodesEx(pW->hAvl, pW->cbp, (AJCAVL_CBNTC)cbNtcNodeData, fDownSeq);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノード取得（コールバックパラメタ指定）																	//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				cbp			 - コールバックパラメタ																//
//				cbNtcNode	 - 取得したノードを通知するコールバック関数（不要時はＮＵＬＬ）						//
//				fDownSeq	 - FALSE:昇順，TRUE:降順															//
//																												//
//	戻り値	：	ノード数																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesExA (HAJCAVS pW, UX cbp, AJCAVS_CBNTCA cbNtcNodeData, BOOL fDownSeq)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlEnumNodesEx(pW->hAvl, cbp, (AJCAVL_CBNTC)cbNtcNodeData, fDownSeq);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcAvsEnumNodesExW (HAJCAVS pW, UX cbp, AJCAVS_CBNTCW cbNtcNodeData, BOOL fDownSeq)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlEnumNodesEx(pW->hAvl, cbp, (AJCAVL_CBNTC)cbNtcNodeData, fDownSeq);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノードへのポインタ配列生成																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pNum		- 配列要素数を格納するバッファのアドレス（不要時はNULL)								//
//				fDownSeq	- FALSE:昇順，TRUE:降順																//
//																												//
//	戻り値	：	≠NULL : 全ノードへのポインタ配列の先頭アドレス													//
//				＝NULL : エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	PCAJCAVSPTRA	WINAPI	AjcAvsCreatePtrArrA(HAJCAVS pW, UIP pNum, BOOL fDownSeq)
{
	PCAJCAVSPTRA	rc = NULL;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = (PCAJCAVSPTRA)AjcAvlCreatePtrArr(pW->hAvl, pNum, fDownSeq);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	PCAJCAVSPTRW	WINAPI	AjcAvsCreatePtrArrW(HAJCAVS pW, UIP pNum, BOOL fDownSeq)
{
	PCAJCAVSPTRW	rc = NULL;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = (PCAJCAVSPTRW)AjcAvlCreatePtrArr(pW->hAvl, pNum, fDownSeq);
		AVS_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノードへのポインタ配列解放																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				ppArr		- 全ノードへのポインタ配列の先頭アドレス											//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsReleasePtrArrA(HAJCAVS pW, PCAJCAVSPTRA pArr)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlReleasePtrArr(pW->hAvl, (PCAJCAVLPTR)pArr);
		AVS_LEAVE
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcAvsReleasePtrArrW(HAJCAVS pW, PCAJCAVSPTRW pArr)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AVS_ENTER
		rc = AjcAvlReleasePtrArr(pW->hAvl, (PCAJCAVLPTR)pArr);
		AVS_LEAVE
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	文字列比較																									//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	int		CALLBACK cbMyStrCmpA(UX key1, UX key2, UX cbp)
{
	int		rc;
	HAJCAVS	pW = (HAJCAVS)cbp;

	rc = AjcStrCmpExA((C_BCP)key1, (C_BCP)key2, pW->CmpMode);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	int		CALLBACK cbMyStrCmpW(UX key1, UX key2, UX cbp)
{
	int		rc;
	HAJCAVS	pW = (HAJCAVS)cbp;

	rc = AjcStrCmpExW((C_WCP)key1, (C_WCP)key2, pW->CmpMode);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ノード削除通知																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		CALLBACK cbMyNtcDel (UX key, VOP pNode, UI len, UI nest, UX cbp)
{
	HAJCAVS	pW = (HAJCAVS)cbp;

	if (pW->fUnicode) {
		if (pW->u.cbNtcDelA != NULL) {
			pW->u.cbNtcDelA((C_BCP)key, pNode, len, nest, pW->cbp);
		}
	}
	else {
		if (pW->u.cbNtcDelW != NULL) {
			pW->u.cbNtcDelW((C_WCP)key, pNode, len, nest, pW->cbp);
		}
	}
}
