﻿#include	"AjcInternal.h"

//==============================================================================================================//
//	ビットマップの色変更																						//
//																												//
//	引　数	：	hBmp	- 色を変更するビットマップのハンドル													//
//				before	- 変更前の色																			//
//				after	- 変更後の色																			//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcChangeBitmapColor(HBITMAP hBmp, COLORREF rgbBefore, COLORREF rgbAfter)
{
	BOOL		rc = FALSE;
	BITMAP		BmpInfo;
	HDC			hdc = NULL;
	HDC			hmd = NULL;
	int			x, y;
	COLORREF	rgb;

	do {
		if (hBmp                            == NULL) break;
		if ((hdc = GetDC(NULL)			  ) == NULL) break;
		if ((hmd = CreateCompatibleDC(hdc)) == NULL) break;
		SelectObject(hmd, hBmp);

		GetObject(hBmp, sizeof(BITMAP), &BmpInfo);
		for (y = 0; y < BmpInfo.bmHeight; y++) { for (x = 0; x < BmpInfo.bmWidth; x++) {
			rgb = GetPixel(hmd, x, y);
			if (rgb == rgbBefore) {
				SetPixel(hmd, x, y, rgbAfter);
			}
		}}
		rc = TRUE;
	} while(0);

	if (hmd != NULL) DeleteDC(hmd);
	if (hdc != NULL) DeleteDC(hdc);

	return rc;
}
//==============================================================================================================//
//	ビットマップデータをクリップボードへ格納する																//
//																												//
//	引　数：	hBitmap	- クリップボードへ格納するビットマップデータ											//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL  	WINAPI AjcSetBitmapToClipboard (HBITMAP hBitmap)
{
	BOOL	rc = FALSE;
	HBITMAP	hBmp;

	if (hBitmap != NULL) {
		BITMAP	bm;
		if (GetObject(hBitmap, sizeof(BITMAP), &bm) != 0) {
			hBmp = CopyImage(hBitmap, IMAGE_BITMAP, bm.bmWidth, bm.bmHeight, LR_COPYRETURNORG);
			if (hBmp != NULL) {
				if (OpenClipboard(NULL) != 0) {
					EmptyClipboard();
					SetClipboardData(CF_BITMAP, hBmp);
					CloseClipboard();
					rc = TRUE;
				}
				else {
					DeleteObject(hBmp);
				}
			 }
		}
	}
	return rc;
}
//==============================================================================================================//
//	クリップボードからビットマップデータを取得する																//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値	：	≠NULL - 成功（取得したビットマップデータのハンドル）											//
//				＝NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	HBITMAP	WINAPI AjcGetBitmapFromClipboard (VO)
{
	HBITMAP	rc	 = NULL;
	HBITMAP	hBmp = NULL;

	if (IsClipboardFormatAvailable(CF_BITMAP)) {
		if (OpenClipboard(NULL) != 0) {
			if (hBmp = (HBITMAP)GetClipboardData(CF_BITMAP)) {
				rc = CopyImage(hBmp, IMAGE_BITMAP, 0, 0, LR_COPYRETURNORG);
			}
			CloseClipboard();
		}
	}
	return rc;
}

//==============================================================================================================//
//	ビットマップマイルを作成する																				//
//																												//
//	引　数：	hBitmap   - ビットマップオブジェクトのハンドル													//
//				pFilePath - 出力するビットマップファイルのパス名												//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
static		BOOL		   SubAjcWriteBitmapToFile	(HBITMAP hBitmap, C_VOP pFilePath, BOOL fUnicode)
{
	BOOL				rc = FALSE;
	HANDLE				hFile 			= INVALID_HANDLE_VALUE;
	HDC					hDC				= NULL;
	DWORD				dw				= 0;
	DWORD				dwHeaderSize	= 0;
	DWORD				dwScanDataSize	= 0;
	BITMAPFILEHEADER	bmpFileHeader;
	BITMAPINFOHEADER	*pBmpInfoHdr	= NULL;
	UBP					pHeaderBuffer	= NULL;
	UBP					pScanDataBuffer	= NULL;
	BITMAP				bmp;

	do {
		if (hBitmap   == NULL) break;
		if (pFilePath == NULL) break;
		if (GetObject(hBitmap, sizeof(BITMAP), &bmp) == 0) break;

		if (bmp.bmBitsPixel < 24) dwHeaderSize = sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * (int)((UX)1 << bmp.bmBitsPixel);
		else					  dwHeaderSize = sizeof(BITMAPINFOHEADER);
		if ((pHeaderBuffer = (UBP)AJCMEM(dwHeaderSize)) == NULL) break;
		memset(pHeaderBuffer, 0, dwHeaderSize);

		pBmpInfoHdr 			= (BITMAPINFOHEADER*)pHeaderBuffer;
		pBmpInfoHdr->biBitCount = bmp.bmBitsPixel;

		pBmpInfoHdr->biSize 		 = sizeof(BITMAPINFOHEADER);
		pBmpInfoHdr->biWidth		 = bmp.bmWidth;
		pBmpInfoHdr->biHeight		 = bmp.bmHeight;
		pBmpInfoHdr->biPlanes		 = 1;
		pBmpInfoHdr->biCompression	 = BI_RGB;
		pBmpInfoHdr->biSizeImage	 = 0;
		pBmpInfoHdr->biXPelsPerMeter = 0;
		pBmpInfoHdr->biYPelsPerMeter = 0;
		pBmpInfoHdr->biClrUsed		 = 0;
		pBmpInfoHdr->biClrImportant  = 0;

		if ((hDC = GetDC(NULL)) == NULL) break;
		GetDIBits(hDC, hBitmap, 0, bmp.bmHeight, NULL, (LPBITMAPINFO)pBmpInfoHdr, DIB_RGB_COLORS);
		dwScanDataSize = pBmpInfoHdr->biSizeImage;
		if ((pScanDataBuffer = (UBP)AJCMEM(dwScanDataSize)) == NULL) break;;
		GetDIBits(hDC, hBitmap, 0, bmp.bmHeight, pScanDataBuffer, (LPBITMAPINFO)pBmpInfoHdr, DIB_RGB_COLORS);
		ReleaseDC(NULL, hDC);

		bmpFileHeader.bfType = 0x4D42;	/* "BM" */
		bmpFileHeader.bfReserved1 = 0;
		bmpFileHeader.bfReserved2 = 0;

		bmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + dwHeaderSize;
		bmpFileHeader.bfSize	= dwScanDataSize + bmpFileHeader.bfOffBits;

		if (fUnicode) {
			if ((hFile = CreateFileW((C_WCP)pFilePath, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) break;
		}
		else {
			if ((hFile = CreateFileA((C_BCP)pFilePath, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) break;
		}
		if (WriteFile(hFile, &bmpFileHeader, sizeof(BITMAPFILEHEADER), &dw, NULL) == 0) break;
		if (WriteFile(hFile, pHeaderBuffer, dwHeaderSize, &dw, NULL)			  == 0) break;
		if (WriteFile(hFile, pScanDataBuffer, dwScanDataSize, &dw, NULL)		  == 0) break;

		rc = TRUE;

	} while(0);

	if (hDC 			!= NULL) ReleaseDC(NULL, hDC);
	if (pHeaderBuffer	!= NULL) free(pHeaderBuffer  );
	if (pScanDataBuffer != NULL) free(pScanDataBuffer);
	if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFile);

	return rc;
}
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI AjcWriteBitmapToFileA	(HBITMAP hBitmap, C_BCP pFilePath)
{
	return SubAjcWriteBitmapToFile	(hBitmap, (C_VOP)pFilePath, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI AjcWriteBitmapToFileW	(HBITMAP hBitmap, C_WCP pFilePath)
{
	return SubAjcWriteBitmapToFile	(hBitmap, (C_VOP)pFilePath, TRUE);
}

//==============================================================================================================//
//	ビットマップファイルの読み出し（ＤＩＢセクション作成）														//
//																												//
//	引　数	：	pFilePath - ビットマップファイルのパス名														//
//				pWidth	  - ビットマップの横サイズを格納するバッファのアドレス		（不要時はNULL）			//
//				pHeight	  - ビットマップの縦サイズを格納するバッファのアドレス		（不要時はNULL）			//
//				pBmpInfo  - ビットマップ情報を格納するバッファのアドレス			（不要時はNULL）			//
//				ppImage	  - イメージデータへのポインタを格納するバッファのアドレス	（不要時はNULL）			//
//																												//
//	戻り値	：	≠NULL：ビットマップハンドル																	//
//				＝NULL：エラー																					//
//==============================================================================================================//
static	  HBITMAP 			SubCreateDibFromFile(C_VOP pFilePath, UIP pWidth, UIP pHeight, PAJCBITMAPINFO pBmpInfo, VOP *ppImage, BOOL fUnicode)
{
	HBITMAP				rc = NULL;
	UBP					pBits;
	DWORD				dwBytesRead;
	HANDLE				hFile = INVALID_HANDLE_VALUE;
	HBITMAP				hBitmap;
	BITMAPFILEHEADER	BmapFh;			//	ビットマップファイルヘッダ
	LPBITMAPINFO		pBmapIf = NULL;	//	ビットマップ情報
	UI					lBmapIf = 0;	//	ビットマップ情報のサイズ
	UI					lImage	= 0;	//	イメージデータバイト数

	do {
		if (pFilePath == NULL) break;
		//----- ビットマップファイル オープン ------------------------------------------------------------------//
		if (fUnicode) {
			if ((hFile = CreateFileW((C_WCP)pFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL)) == 
																									INVALID_HANDLE_VALUE) {
				break;
			}
		}
		else {
			if ((hFile = CreateFileA((C_BCP)pFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL)) == 
																									INVALID_HANDLE_VALUE) {
				break;
			}
		}
		//----- ビットマップファイルヘッダ読み出し -------------------------------------------------------------//
		if (!ReadFile (hFile, &BmapFh, sizeof(BITMAPFILEHEADER), &dwBytesRead, NULL)) {
			break;
		}
		//----- ビットマップファイルヘッダの内容チェック -------------------------------------------------------//
		if (dwBytesRead != sizeof(BITMAPFILEHEADER) || BmapFh.bfType != *(WORD *)"BM") {
			break;
		}
		//----- ビットマップ情報読み出し -----------------------------------------------------------------------//
		lBmapIf = BmapFh.bfOffBits - sizeof(BITMAPFILEHEADER) ;
		pBmapIf = (LPBITMAPINFO)AJCMEM(lBmapIf);
		if (pBmapIf == NULL) break;
		if (!ReadFile(hFile, pBmapIf, lBmapIf, &dwBytesRead, NULL)) {
			break;
		}
		//----- ビットマップ情報読み出しサイズチェック ---------------------------------------------------------//
		if (dwBytesRead != lBmapIf) {
			break;
		}
		//----- ＤＩＢＳＥＣＴＩＯＮ作成 -----------------------------------------------------------------------//
		if ((hBitmap = CreateDIBSection (NULL, pBmapIf, DIB_RGB_COLORS, (void **)&pBits, NULL, 0)) == NULL) {
			break;
		}
		//----- ビットマップイメージ読み出し -------------------------------------------------------------------//
		lImage = BmapFh.bfSize - BmapFh.bfOffBits;
		if (!ReadFile(hFile, pBits, lImage, &dwBytesRead, NULL)) {
			DeleteObject(hBitmap);
			break;
		}
		//---- イメージ読み出しサイズチェック ------------------------------------------------------------------//
		if (dwBytesRead != lImage) {
			DeleteObject(hBitmap);
			break;
		}
		//----- 戻り情報設定 -----------------------------------------------------------------------------------//
		//-- ビットマップサイズ情報 -------------//
		if (pBmapIf->bmiHeader.biSize == sizeof(BITMAPCOREHEADER)) {
			if (pWidth	!= NULL) *pWidth  = ((BITMAPCOREHEADER *) pBmapIf)->bcWidth;
			if (pHeight != NULL) *pHeight = ((BITMAPCOREHEADER *) pBmapIf)->bcHeight;
		}
		else {
			if (pWidth	!= NULL) *pWidth  = pBmapIf->bmiHeader.biWidth;
			if (pHeight != NULL) *pHeight = pBmapIf->bmiHeader.biHeight;
		}
		//-- ビットマップ情報 -------------------//
		if (pBmpInfo != NULL) {
			memset(pBmpInfo, 0, sizeof(AJCBITMAPINFO));
			if		(pBmapIf->bmiHeader.biSize == sizeof(BITMAPINFOHEADER)) memcpy(pBmpInfo, pBmapIf, sizeof(BITMAPINFOHEADER));
			else if (pBmapIf->bmiHeader.biSize == sizeof(BITMAPV4HEADER))	memcpy(pBmpInfo, pBmapIf, sizeof(BITMAPV4HEADER));
			else if (pBmapIf->bmiHeader.biSize == sizeof(BITMAPV5HEADER))	memcpy(pBmpInfo, pBmapIf, sizeof(BITMAPV5HEADER));
			else															memcpy(pBmpInfo, pBmapIf, sizeof(BITMAPCOREHEADER));
		}
		//-- ビットマップ・イメージアドレス -----//
		if (ppImage != NULL) {
			*ppImage = pBits;
		}
		//----- 戻り値（ビットマップハンドル）設定 -------------------------------------------------------------//
		rc = hBitmap;
	} while(0);

	//----- リソース開放 ---------------------------------------------------------------------------------------//
	if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFile);
	if (pBmapIf != NULL) free(pBmapIf); pBmapIf = NULL;

	return rc;
}
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HBITMAP WINAPI	AjcCreateDibFromFileA(C_BCP pFilePath, UIP pWidth, UIP pHeight, PAJCBITMAPINFO pBmpInfo, VOP *ppImage)
{
	return SubCreateDibFromFile((C_VOP)pFilePath, pWidth, pHeight, pBmpInfo, ppImage, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HBITMAP WINAPI	AjcCreateDibFromFileW(C_WCP pFilePath, UIP pWidth, UIP pHeight, PAJCBITMAPINFO pBmpInfo, VOP *ppImage)
{
	return SubCreateDibFromFile((C_VOP)pFilePath, pWidth, pHeight, pBmpInfo, ppImage, TRUE);
}
//==============================================================================================================//
//	ビットマップサイズの取得																					//
//																												//
//	引　数	：	hBitmap		- ビットマップハンドル																//
//				pSize		- ビットマップのサイズを格納するバッファのアドレス		（不要時はNULL）			//
//																												//
//	戻り値	：	≠0：ピクセルの色を示すために必要なビット数														//
//				＝0：エラー																						//
//==============================================================================================================//
AJCEXPORT UI WINAPI	AjcGetBitmapSize(HBITMAP hBitmap, LPSIZE pSize)
{
	UI		rc = 0;
	BITMAP	BmpInfo;

	if (GetObject(hBitmap, sizeof(BITMAP), &BmpInfo) == sizeof(BITMAP)) {
		if (pSize != NULL) {
			pSize->cx = BmpInfo.bmWidth;
			pSize->cy = BmpInfo.bmHeight;
		}
		rc = BmpInfo.bmBitsPixel;
	}
	return rc;
}
//==============================================================================================================//
//	アイコンサイズの取得																						//
//																												//
//	引　数	：	hIcon		- アイコンハンドル																	//
//				pSize		- アイコンのサイズを格納するバッファのアドレス		（不要時はNULL）				//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT BOOL WINAPI	AjcGetIconSize(HICON hIcon, LPSIZE pSize)
{
	BOOL		rc = FALSE;
	ICONINFO	ii = {0};

	if (GetIconInfo(hIcon, &ii)) {
		BITMAP bm;
		if (GetObject(ii.hbmMask, sizeof(bm), &bm) == sizeof(bm)) {
			pSize->cx = bm.bmWidth;
			pSize->cy = ii.hbmColor ? bm.bmHeight : bm.bmHeight / 2;
		}
		rc = TRUE;
	}
	if (ii.hbmMask ) DeleteObject(ii.hbmMask);
	if (ii.hbmColor) DeleteObject(ii.hbmColor);

	return rc;
}

