﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ																						//
//																												//
//**************************************************************************************************************//

#define	MYSECT	CIP_MAIN_SECT

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	内部サブ関数																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL		SubRegistVariable	(HAJCCIP pW);
static	BOOL		SubRegistNoInitVar	(HAJCCIP pW, PAJCCIPTKN pSymTkn, BOOL fNumeric);
static	BOOL		SubRegistInitedVar	(HAJCCIP pW, PAJCCIPTKN pSymTkn, BOOL fNumeric);
static	BOOL		SubRegistArray		(HAJCCIP pW, PAJCCIPTKN pSymTkn, BOOL fNumeric);
static	BOOL		SubRegistNoInitArr	(HAJCCIP pW, PAJCCIPTKN pSymTkn, UI nArr , BOOL fNumeric);
static	BOOL		SubRegistInitedArr	(HAJCCIP pW, PAJCCIPTKN pSymTkn, UI nArr , BOOL fNumeric);
static	BOOL		SubRegistValueCount	(HAJCCIP pW, PAJCCIPTKN pSymTkn, UIP pCnt, BOOL fNumeric);
static	BOOL		SubRegistSetVar		(HAJCCIP pW, PAJCCIPTKN pSymTkn, UI ix	 , BOOL fNumeric);
static	BOOL		SubRegistFunction	(HAJCCIP pW);

static	BOOL		CALLBACK cbNtcFuncs		(UX key, C_VOP pNodeData, UI len, UI nest, UX bcp);
static	BOOL		SubAnalSkipStmt			(HAJCCIP pW, PCAJCCIPFUNC pFunc);
static	BOOL		SubAnalIsValidAfterCtrl	(HAJCCIP pW, PAJCCIPTKN pTkn);
static	BOOL		SubAnalRegistLabelInfo	(HAJCCIP pW, PAJCCIPTKN pSymTkn);
static	BOOL		SubAnalRegistLoopInfo	(HAJCCIP pW, PAJCCIPTKN pTop, PAJCCIPTKN pExit);

static	BOOL		SubAnalSetGotoAndBreakJmpAddr(HAJCCIP pW, PCAJCCIPFUNC pFunc);
static	BOOL		SubAnalSetBreak			(HAJCCIP pW, PAJCCIPTKN pBreak);
static	BOOL		SubAnalSetGoto			(HAJCCIP pW, PAJCCIPTKN pGoto, BCP pLabelName);

static	BOOL		SubExeFuncCode			(HAJCCIP pW, UI ixSrt);

static	PAJCCIPTKN	SubSkipStmt(PAJCCIPTKN pStmt);

static BOOL	SubExeSkipLabel	(HAJCCIP pW);
static BOOL	SubExeCopyArray	(HAJCCIP pW);
static BOOL SubExeFormula	(HAJCCIP pW);

static BOOL SubExeStdEvt	(HAJCCIP pW);
static BOOL SubExeComEvt	(HAJCCIP pW);
static BOOL SubExeDefine	(HAJCCIP pW);
static BOOL SubExeIf		(HAJCCIP pW);
static BOOL SubExeElse		(HAJCCIP pW);
static BOOL SubExeDo		(HAJCCIP pW);
static BOOL SubExeWhile		(HAJCCIP pW);
static BOOL SubExeFor		(HAJCCIP pW);
static BOOL SubExeBreak		(HAJCCIP pW);
static BOOL SubExeReturn	(HAJCCIP pW);
static BOOL SubExeGoto		(HAJCCIP pW);
static BOOL SubExeLmPart	(HAJCCIP pW);
static BOOL SubExeRmPart	(HAJCCIP pW);
static BOOL SubExeSemiCol	(HAJCCIP pW);
static BOOL SubExeComma		(HAJCCIP pW);
static BOOL SubExeRsPart	(HAJCCIP pW);

static	HAJCVMGA	SubExeGetVarInst		(HAJCCIP pW, PAJCCIPTKN pSymTkn);
static	HAJCVMGA	SubExeGetVarInstAndIx	(HAJCCIP pW, ULLP pIx);

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	内臓 関数テーブル																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	C_BCP	pFuncName;
	BOOL	(*func)(HAJCCIP pW, PCAJCCIPCALL pCall);
} FUNCENTRY, *PFUNCENTRY;

static const FUNCENTRY FuncTbl[] = {
		//	オプション設定
		{"_EnableStdRClk"		,	CipFunEnableStdRClk		},
		{"_EnableAutoScroll"	,	CipFunEnableAutoScroll	},

		//	スクリーン情報
		{"_SetVramSize"			,	CipFunSetVramSize		},
		{"_SetBufLines"			,	CipFunSetBufLines		},
		{"_GetVRamWidth"		,	CipFunGetVramWidth		},
		{"_GetVRamHeight"		,	CipFunGetVramHeight		},
		{"_GetBufLines"			,	CipFunGetBufLines		},

		//	表示出力
		{"_PrintF"				,	CipFunPrintF			},
		{"_Print"				,	CipFunPrint				},
		{"_Pd"					,	CipFunPItem				},
		{"_Ph"					,	CipFunPHexa				},
		{"_Locate"				,	CipFunLocate			},
		{"_Cls"					,	CipFunCls				},
		{"_SetTextColor"		,	CipFunSetTextColor		},
		{"_SetBackColor"		,	CipFunSetBackColor		},
		{"_ResetColor"			,	CipFunResetColor		},

		//	配列操作
		{"_Elements"			,	CipFunElements			},
		{"_MakeArray"			,	CipFunMakeArray			},
		{"$_MakeArray"			,	CipFunMakeArray			},

		//	整数演算
		{"_CalcCrc"				,	CipFunCalcCrc			},
		{"_SRand"				,	CipFunSRand				},
		{"_Rand"				,	CipFunRand				},

		//	算術演算
		{"_Sqrt"				,	CipFunSqrt				},
		{"_Sin"					,	CipFunSin				},
		{"_Cos"					,	CipFunCos				},
		{"_Tan"					,	CipFunTan				},
		{"_ASin"				,	CipFunASin				},
		{"_ACos"				,	CipFunACos				},
		{"_ATan"				,	CipFunATan				},
		{"_ATan2"				,	CipFunATan2				},
		{"_Abs"					,	CipFunAbs				},
		{"_Min"					,	CipFunMin				},
		{"_Max"					,	CipFunMax				},

		//	時間／ウェイト
		{"_CurTime"				,	CipFunCurTime			},
		{"_GetTime"				,	CipFunGetTime			},
		{"_GetDateAndTime"		,	CipFunGetDateAndTime	},
		{"$_Date"				,	CipFunDate				},
		{"$_Time"				,	CipFunTime				},
		{"$_DateAndTime"		,	CipFunDateAndTime		},
		{"_msWait"				,	CipFunWaitMS			},
		{"_usWait"				,	CipFunWaitUS			},
		{"_Stop"				,	CipFunStop				},
		{"_Restart"				,	CipFunRestart			},

		//	タイマ起動／停止
		{"_TimerStart"			,	CipFunTimerStart		},
		{"_TimerStop"			,	CipFunTimerStop			},

		//	文字列
		{"_StrLen"				,	CipFunStrLen			},
		{"_StrICmp"				,	CipFunStrICmp			},
		{"_StrStr"				,	CipFunStrStr			},
		{"_StrIStr"				,	CipFunStrIStr			},
		{"_ToValue"				,	CipFunToValue			},
		{"$_SPrintF"			,	CipFunSPrintF			},
		{"$_StrCat"				,	CipFunStrCat			},
		{"$_PathCat"			,	CipFunPathCat			},
		{"$_StrLTrim"			,	CipFunStrLTrim			},
		{"$_StrRTrim"			,	CipFunStrRTrim			},
		{"$_StrTrim"			,	CipFunStrTrim			},
		{"$_StrPart"			,	CipFunStrPart			},
		{"$_StrRep"				,	CipFunStrRep			},
		{"$_StrSplit"			,	CipFunStrSplit			},
		{"$_StrJoin"			,	CipFunStrJoin			},
		{"$_ToDecStr"			,	CipFunToDecStr			},
		{"$_ToHexStr"			,	CipFunToHexStr			},
		{"$_Input"				,	CipFunInputStr			},
		{"_HexStrToBinary"		,	CipFunHexStrToBinary	},
		{"_GetValueByKey"		,	CipFunGetValueByKey		},
		{"_GetValues"			,	CipFunGetValues			},

		//	問い合わせ
		{"_MsgBox"				,	CipFunMsgBox			},
		{"_PopupMenu"			,	CipFunPopupMenu			},

		//	メモリブロック
		{"_MemAlloc"			,	CipFunMemAlloc			},
		{"_MemFree"				,	CipFunMemFree			},
		{"_GetMemBlk"			,	CipFunGetMemBlk			},
		{"_PutMemBlk"			,	CipFunPutMemBlk			},
		{"_ClrMemBlk"			,	CipFunClrMemBlk			},
		{"_DumpMemBlk"			,	CipFunDumpMemBlk		},

		//	ファイル／ディレクトリ
		{"_FOpen"				,	CipFunFOpen				},
		{"_FClose"				,	CipFunFClose			},
		{"_FPutS"				,	CipFunFPutStr			},
		{"_FRead"				,	CipFunFRead				},
		{"_FWrite"				,	CipFunFWrite			},
		{"_FGetSeek"			,	CipFunFGetSeek			},
		{"_FSetSeek"			,	CipFunFSetSeek			},
		{"_FSeek"				,	CipFunFSetSeek			},		//	FSeekは互換性の為
		{"$_FGetS"				,	CipFunFGetStr			},
		{"_FDelete"				,	CipFunFDelete			},
		{"_MakeFolder"			,	CipFunMakeFolder		},
		{"_PathExists"			,	CipFunPathExists		},
		{"_PathIsFolder"		,	CipFunPathIsFolder		},

		//	ファイル名／フォルダ名取得
		{"$_GetOpenFile"		,	CipFunGetOpenFile		},
		{"$_GetSaveFile"		,	CipFunGetSaveFile		},
		{"$_GetFolder"			,	CipFunGetFolder			},
		{"$_GetMacFilePath"		,	CipFunGetMacFilePath	},
		{"$_SearchFiles"		,	CipFunSearchFiles		},
		{"$_SplitPath"			,	CipFunSplitPath			},
		{"$_MakePath"			,	CipFunMakePath			},

		//	プロファイルアクセス
		{"_SetProfileSect"		,	CipFunSetProfileSect	},
		{"_SetProfileVal"		,	CipFunSetProfileVal		},
		{"_SetProfileStr"		,	CipFunSetProfileStr		},
		{"_GetProfileVal"		,	CipFunGetProfileVal		},
		{"$_GetProfileStr"		,	CipFunGetProfileStr		},

		//	ＣＯＭポートアクセス
		{"_ComCreate"			,	CipFunComCreate			},
		{"_ComCreateByDialog"	,	CipFunComCreateByDialog	},
		{"_ComDelete"			,	CipFunComDelete			},
		{"_ComOpen"				,	CipFunComOpen			},
		{"_ComIsOpenPossible"	,	CipFunComIsOpenPossible	},
		{"_ComIsOpened"			,	CipFunComIsOpened		},
		{"_ComClose"			,	CipFunComClose			},
		{"_ComSendText"			,	CipFunComSendText		},
		{"_ComSendBinary"		,	CipFunComSendBinary		},
		{"_ComSendBytes"		,	CipFunComSendBytes		},
		{"_ComSendPacket"		,	CipFunComSendPacket		},
		{"_ComGetRate"			,	CipFunComGetRate		},
		{"_ComGetDataBits"		,	CipFunComGetDataBits	},
		{"_ComGetParity"		,	CipFunComGetParity		},
		{"_ComGetStopBits"		,	CipFunComGetStopBits	},
		{"$_ComGetParam"		,	CipFunComGetParam		},
		{"_ComSetDTR"			,	CipFunComSetDTR			},
		{"_ComSetRTS"			,	CipFunComSetRTS			},
		{"_ComGetSignal"		,	CipFunComGetSignal		},

		//	ＣＯＭポートイベント登録
		{"_ComSetOnRxText"		,	CipFunComSetOnRxText	},
		{"_ComSetOnRxCtrl"		,	CipFunComSetOnRxCtrl	},
		{"_ComSetOnRxEsc"		,	CipFunComSetOnRxEsc		},
		{"_ComSetOnRxPacket"	,	CipFunComSetOnRxPacket	},

		//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭ
		{"_ComSendXModemSum"	,	CipFunComSendXModemSum	},
		{"_ComSendXModemCrc"	,	CipFunComSendXModemCrc	},
		{"_ComSendXModem1K"		,	CipFunComSendXModem1K	},
		{"_ComRecvXModemSum"	,	CipFunComRecvXModemSum	},
		{"_ComRecvXModemCrc"	,	CipFunComRecvXModemCrc	},
		{"_ComRecvXModem1K"		,	CipFunComRecvXModem1K	},
		{"_ComSendYModem"		,	CipFunComSendYModem		},
		{"_ComRecvYModem"		,	CipFunComRecvYModem		},

		//	イベント禁止／許可
		{"_DisStdEvt"			,	CipFunDisStdEvt			},
		{"_EnaStdEvt"			,	CipFunEnaStdEvt			},
		{"_GetDisStdEvt"		,	CipFunGetDisStdEvt		},
		{"_DisComEvt"			,	CipFunDisComEvt			},
		{"_EnaComEvt"			,	CipFunEnaComEvt			},
		{"_GetDisComEvt"		,	CipFunGetDisComEvt		},

		//	タイムチャートグラフ
		{"_TmcOpen"				,	CipFunTmcOpen			},
		{"_TmcSetItems"			,	CipFunTmcSetItems		},
		{"_TmcSetRange"			,	CipFunTmcSetRange		},
		{"_TmcPutData"			,	CipFunTmcPutData		},
		{"_TmcClear"			,	CipFunTmcClear			},
		{"_TmcWndMove"			,	CipFunTmcWndMove		},
		{"_TmcWndSize"			,	CipFunTmcWndSize		},
		{"_TmcClose"			,	CipFunTmcClose			},

		//	ボタン
		{"_BtnOpen"				,	CipFunBtnOpen			},
		{"_BtnClose"			,	CipFunBtnClose			},
		{"_BtnEnable"			,	CipFunBtnEnable			},

		//	チェックボックス
		{"_ChkBoxOpen"			,	CipFunChkBoxOpen		},
		{"_ChkBoxClose"			,	CipFunChkBoxClose		},
		{"_ChkBoxGetSts"		,	CipFunChkBoxGetSts		},
		{"_ChkBoxSetSts"		,	CipFunChkBoxSetSts		},
		{"_ChkBoxEnable"		,	CipFunChkBoxEnable		},

		//	その他
		{"_ShowText"			,	CipFunShowText			},
		{"_GetWndPosX"			,	CipFunGetWndPosX		},
		{"_GetWndPosY"			,	CipFunGetWndPosY		},
		{"_GetWndWidth"			,	CipFunGetWndWidth		},
		{"_GetWndHeight"		,	CipFunGetWndHeight		},
		{"_GetCharWidth"		,	CipFunGetCharWidth		},
		{"_GetCharHeight"		,	CipFunGetCharHeight		},
		{"_GetLineHeight"		,	CipFunGetLineHeight		},
		{"_Exit"				,	CipFunExit				},

		//	デバッグ機能
		{"_VarDump"				,	CipFunVarDump			},
		{"_Trace"				,	CipFunTrace				},
		{"_Pause"				,	CipFunPause				},
		{"_StepTrace"			,	CipFunStepTrace			},

};

#define	MAX_FUNCENTRY	((sizeof FuncTbl) / (sizeof FuncTbl[0]))

static	HAJCAVL		hAvlFuncs = NULL;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	数値定数テーブル																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	C_BCP		pVarName;				//	定数名
	SLL			val;					//	数値
} CONSTVAL, *PCONSTVAL;

static const CONSTVAL ConstVal[] = {
	{"_TRUE"			, TRUE				},
	{"_FALSE"			, FALSE				},

	{"_CR"				, 0x0D				},
	{"_LF"				, 0x0A				},

	{"_SLOT_PORT"		, SLOT_PORT			},

	{"_MB_OK"			, MB_OK				},
	{"_MB_OKCANCEL"		, MB_OKCANCEL		},
	{"_MB_RETRYCANCEL"	, MB_RETRYCANCEL	},
	{"_MB_YESNO"		, MB_YESNO			},
	{"_MB_YESNOCANCEL"	, MB_YESNOCANCEL	},
	{"_MB_ICONERROR"	, MB_ICONERROR		},

	{"_IDCANCEL"		, IDCANCEL			},
	{"_IDNO"			, IDNO				},
	{"_IDOK"			, IDOK				},
	{"_IDYES"			, IDYES				},

	{"_CRC_ITL"			, CRC_ITL			},
	{"_CRC_ITR"			, CRC_ITR			},
	{"_CRC_16L"			, CRC_16L			},
	{"_CRC_16R"			, CRC_16R			},
};

#define	MAX_CONSTVAL	((sizeof ConstVal) / (sizeof ConstVal[0]))


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	作業領域																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	ATOM	ClassCipBack	  = 0;		//	ＣＩＰコントロール バックウインドクラス
static	ATOM	ScpEvtWndClass	  = 0;		//	ＳＣＰ通知用  ウインドクラスハンドル
static	ATOM	TmcBakWndClass	  = 0;		//	ＴＭＣ用バックウインドクラスハンドル

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	内部サブ関数																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
AJC_WNDPROC_DEF(ScpEvt);
AJC_WNDPROC_DEF(TmcBak);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL	AjcCipInit(VO)
{
	BOOL		rc = TRUE;
	int			i;
	WNDCLASSA	wndclass;

	do {
		//	ＣＩＰコントロール・バックウインドクラス生成
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Back);
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(HAJCCIP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= hBruBtnFace;
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= "AjcCtrlCIP";
		ClassCipBack = RegisterClassA(&wndclass);
		if (ClassCipBack == 0) {
			rc = FALSE;
			break;
		}

		//	ＳＣＰ通知用ウインドクラス生成
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(ScpEvt);
		wndclass.cbClsExtra 	= 0;
		wndclass.cbWndExtra 	= (sizeof(UX) * 2);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= AJCCIP_SCPWNDCLASS;
		ScpEvtWndClass = RegisterClassA(&wndclass);
		if (ScpEvtWndClass == 0) {
			rc = FALSE;
			break;
		}

		//	ＴＭＣ用バックウインドクラス生成
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(TmcBak);
		wndclass.cbClsExtra 	= 0;
		wndclass.cbWndExtra 	= (sizeof(UX));
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= AJCCIP_TMCBAKCLASS;
		TmcBakWndClass = RegisterClassA(&wndclass);
		if (TmcBakWndClass == 0) {
			rc = FALSE;
			break;
		}

		//	関数名をＡＶＬに登録
		if (hAvlFuncs = AjcAvlCreate(0, cbAvlCompStr, NULL)) {
			for (i = 0; i < MAX_FUNCENTRY; i++) {
				if (!AjcAvlInsNode(hAvlFuncs, (UX)FuncTbl[i].pFuncName, &FuncTbl[i], sizeof FuncTbl[0])) {
					rc = FALSE;
					break;
				}
			}
		}
		else {
			rc = FALSE;
			break;
		}

		//	サブモジュール初期化
		if (!CipTrcInit	())	{rc = FALSE; break;}
		if (!CipStepInit())	{rc = FALSE; break;}

	} while(0);

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		AjcCipEnd(VO)
{
	if (ClassCipBack != 0) {
		UnregisterClassA((BCP)ClassCipBack, hDllInst);
		ClassCipBack = 0;
	}

	if (ScpEvtWndClass != 0) {
		UnregisterClassA((BCP)ScpEvtWndClass, hDllInst);
		ScpEvtWndClass = 0;
	}

	if (TmcBakWndClass != 0) {
		UnregisterClassA((BCP)TmcBakWndClass, hDllInst);
		TmcBakWndClass = 0;
	}

	if (hAvlFuncs != NULL) {
		AjcAvlDelete(hAvlFuncs);
		hAvlFuncs = NULL;
	}

	//	サブモジュール後処理
	CipTrcEnd	();
	CipStepEnd	();
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＣＩＰコントロール バックウインドプロシージャ																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define		IDC_VTH				5001				//	ＶＴＨコントロールＩＤ
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE		)
{
	HAJCCIP		pW = NULL;
	BOOL		rc = -1;
	UI			sty, exs;
	BC			txt[512];

	//----- インスタンス生成 -----------------------------------------//
	if (pW = CipGsrCreate()) {
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- 親ウインド，自ウインドハンドル設定 -------------------//
		pW->hParent  = GetParent(hwnd);
		pW->hWndBack = hwnd;
		//----- コントロールＩＤ設定 ---------------------------------//
		pW->CtrlId	= (int)MAjcGetWindowLong(hwnd, GWL_ID);
		//----- ボタンの情報設定 -------------------------------------//
		memset(pW->hButton, 0, sizeof pW->hButton);
		pW->mskBtnValid  = 0;
		pW->mskChkValid  = 0;
		pW->BtnChkHeight = 0;
		//----- VT-100エミュレーション・コントロール生成 -------------//
		sty = (UI) MAjcGetWindowLong(hwnd, GWL_STYLE);
		exs = (UI)(MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES);
		AjcGetCtrlStrA(hwnd, txt, sizeof txt);
		pW->hWndVth = CreateWindowExA(exs,											// extend style
									  "AjcCtrlVT100",								// window class name
									  txt,											// window caption
									  sty,											// style
									  0,											// initial x position
									  0,											// initial y position
									  0,											// initial x size
									  0,											// initial y size
									  hwnd,											// parent window handle
									  (HMENU)IDC_VTH,								// window menu handle
									  hDllInst,										// program instance handle
									  NULL);										// creation parameters
		if (pW->hWndVth != NULL) {
			ShowWindow(pW->hWndVth, SW_SHOW);
			rc = 0;
		}
		//----- メインＶＴＨウインド設定値ロード ---------------------//
		AjcVthLoadPropA(pW->hWndVth, MYSECT, NULL);

		//----- トレース表示ウインド オープン ------------------------//
		if (AjcGetProfileUIntA(CIP_TRC_SECT , "fTraceWindowOpened", FALSE)) {
			CipTrcCreateWindow(pW);
		}
		//----- ステップトレースウインド オープン --------------------//
		if (AjcGetProfileUIntA(CIP_STEP_SECT, "fStepWindowOpened", FALSE)) {
			CipStepCreateWindow(pW);
		}
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	if (pW != NULL) {
		//----- メインＶＴＨウインド設定値セーブ ----------------------//
		AjcVthSavePropA(pW->hWndVth, MYSECT);

		//----- ＶＴＨウインド破棄 ------------------------------------//
		if (pW->hWndBack != NULL) {
			DestroyWindow(pW->hWndVth);
			pW->hWndVth  = NULL;
			pW->hWndBack = NULL;
		}
		//----- トレースウインド破棄 ----------------------------------//
		AjcPutProfileUIntA(CIP_TRC_SECT , "fTraceWindowOpened", pW->hTrcBack != NULL);
		if (pW->hTrcBack != NULL) {
			DestroyWindow(pW->hTrcBack);
			pW->hTrcBack = NULL;
		}
		//----- ステップトレースウインド破棄 --------------------------//
		AjcPutProfileUIntA(CIP_STEP_SECT, "fStepWindowOpened", pW->hStepBack != NULL);
		if (pW->hStepBack != NULL) {
			DestroyWindow(pW->hStepBack);
			pW->hStepBack = NULL;
		}
		//----- リソース解放 ------------------------------------------//
		CipGsrDelete(pW);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	//----- ボタン，チェックボックス整列 ------------------------------//
	CipGsrBtnAndChkBoxAlignment(pW);
	//----- 再描画 ----------------------------------------------------//
	InvalidateRect(hwnd, NULL, FALSE);
	//----- Windows Event ---------------------------------------------//
	CipGsrDoEvent(pW);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_PAINT		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HPEN		hPen;
	RECT		r;

	hdc	  = BeginPaint(hwnd, &ps);
	hPen = (HPEN)SelectObject(hdc, GetStockObject(BLACK_PEN));
	GetClientRect(hwnd, &r);
	MoveToEx(hdc, 0 	 , 0, NULL);
	LineTo	(hdc, r.right, 0);
	SelectObject(hdc, hPen);
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ON_RCLICK	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	if (!pW->fExeRClick) {
		pW->ptExeRClick.x = (SW)LOWORD(lParam);
		pW->ptExeRClick.y = (SW)HIWORD(lParam);
		pW->fExeRClkShift = FALSE;
		pW->fExeRClkCtrl  = FALSE;
		pW->fExeRClick	  = TRUE;
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_POPUPMENU	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	PAJCCIPCALL		pCall;

	if (pCall = AjcCipCallInfoInit(pW->hWndBack, (C_BCP)lParam)) {		//	呼び出し情報生成
		pCall->pReturn = pW->pCur;										//		戻りアドレス
		AjcCipCallInfoInsInteger(pW->hWndBack, pCall, wParam);			//		第１引数（メニューＩＤ）
		AjcFQueEnque(pW->hFQueStdEvt, (VOP)&pCall);						//		イベント・エンキュー
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXTLENGTH)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_GETTEXTLENGTH, wParam, lParam);

	return SendMessage(pW->hWndVth, WM_GETTEXTLENGTH, wParam, lParam);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXT	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_GETTEXT, wParam, lParam);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETTEXT	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_SETTEXT, wParam, lParam);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_STYLECHANGED)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_STYLECHANGED, wParam, lParam);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ENABLE		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_ENABLE, wParam, lParam);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETFONT	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_SETFONT, wParam, lParam);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETFONT	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	rc = SendMessage(pW->hWndVth, WM_GETFONT, wParam, lParam);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_COMMAND	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	int			id	= LOWORD(wParam);
	int			cmd = HIWORD(wParam);
	PAJCCIPCALL	pCall;

	if (cmd == BN_CLICKED && (id >= IDC_BKBUTTON && id < IDC_BKBUTTON + MAX_BUTTON)) {
		id -= IDC_BKBUTTON;
		if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnButton")) {		//	呼び出し情報生成
			pCall->pReturn = pW->pCur;										//		戻りアドレス
			if (pW->NumType == AJCIPT_INTEGER) {							//		第１引数（ボタン番号）
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, id);
			}
			else {
				AjcCipCallInfoInsReal	(pW->hWndBack, pCall, (double)id);
			}
			AjcFQueEnque(pW->hFQueStdEvt, (VOP)&pCall);						//		イベントをエンキュー
		}
	}
	if (cmd == BN_CLICKED && (id >= IDC_BKCHKBOX && id < IDC_BKCHKBOX + MAX_CHKBOX)) {
		id -= IDC_BKCHKBOX;
		CipGsrCall_OnChkBox(pW, id);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_TIMER		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	//	TimerStart()による、タイマイベント発生フラグ設定
	if (!pW->fRunStop) {							//	マクロ実行中？
		if (wParam >= 1 && wParam <= 31) {			//		有効なタイマＩＤ？
			pW->fExeTimer[wParam] = TRUE;			//			イベント発生フラグ設定
		}
	}
	return 0;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, IDC_VTH		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	switch (HIWORD(wParam)) {
		//----- キー入力 -------------------------------------------------------//
		case AJCVTHN_KEYIN:
			if		(lParam == CC_CTRL_A && !pW->fExeEnaStdPopupMenu) {
				AjcVthSelectAll(pW->hWndVth);
			}
			else if (lParam == CC_CTRL_C && !pW->fExeEnaStdPopupMenu) {
				AjcVthCopyText(pW->hWndVth);
			}
			else {
				PAJCCIPCALL		pCall;
				if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnKeyIn")) {			//	呼び出し情報生成
					pCall->pReturn = pW->pCur;										//		戻りアドレス
					AjcCipCallInfoInsInteger(pW->hWndBack, pCall, lParam);			//		第１引数（キーコード）
					AjcFQueEnque(pW->hFQueStdEvt, (VOP)&pCall);						//		イベント・エンキュー
				}
				break;
			}
		//----- ダブルクリック -------------------------------------------------//
		case AJCVTHN_DBLCLK:
			if (pW->fNtcDblClk) {			//	親ウインドへ通知？
				AjcVthGetDblClickedLineA(pW->hWndVth, pW->NtcTxt, sizeof pW->NtcTxt);
				SendMessageA(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_DBLCLK),
													 fCmdWithHdl ? (LPARAM)pW->hWndBack : (LPARAM)pW->NtcTxt);
			}
			else {							//	_OnDblClk() 実行？
				UI				len;
				if (!pW->fExeDblClk) {														//	ダブルクリック未発生？
					len = AjcVthGetDblClickedLine(pW->hWndVth, NULL, 0);					//		ラインテキストバッファ確保
					if (pW->pExeDblClkLine = (BCP)AJCMEM(len + 1)) {						//		・
						AjcVthGetDblClickedLineA(pW->hWndVth, pW->pExeDblClkLine, len + 1);	//			ラインテキスト取得
						pW->fExeDblClk = TRUE;												//			ダブルクリック発生フラグ設定
					}
				}
			}
			break;
		//----- Shift/Ctrl + 右クリック ----------------------------------------//
		case AJCVTHN_RCLICK:
		{	PAJCVTHRCLK	pRClk = (PAJCVTHRCLK)lParam;
			if (!pW->fExeRClick) {
				pW->ptExeRClick.x = pRClk->x;
				pW->ptExeRClick.y = pRClk->y;
				pW->fExeRClkShift = pRClk->fShift;
				pW->fExeRClkCtrl  = pRClk->fCtrl;
				pW->fExeRClick	  = TRUE;
			}
			break;
		}
		//----- ファイルドロップ -----------------------------------------------//
		case AJCVTHN_DROPFILE:
			if (pW->hWndBack != NULL) {
				pW->NtcFiles = (UI)lParam;
				PostMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_DROPFILE),
													 fCmdWithHdl ? (LPARAM)pW->hWndBack : lParam);
			}
			break;
		//----- ディレクトリドロップ -------------------------------------------//
		case AJCVTHN_DROPDIR:
			if (pW->hWndBack != NULL) {
				pW->NtcDirs = (UI)lParam;
				PostMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_DROPDIR) ,
													 fCmdWithHdl ? (LPARAM)pW->hWndBack : lParam);
			}
			break;
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE			)
	AJC_WNDMAP_MSG(Back, WM_DESTROY			)
	AJC_WNDMAP_MSG(Back, WM_SIZE			)
	AJC_WNDMAP_MSG(Back, WM_PAINT			)
	AJC_WNDMAP_MSG(Back, WM_ON_RCLICK		)
	AJC_WNDMAP_MSG(Back, WM_POPUPMENU		)
	AJC_WNDMAP_MSG(Back, WM_GETTEXTLENGTH	)
	AJC_WNDMAP_MSG(Back, WM_GETTEXT			)
	AJC_WNDMAP_MSG(Back, WM_SETTEXT			)
	AJC_WNDMAP_MSG(Back, WM_STYLECHANGED	)
	AJC_WNDMAP_MSG(Back, WM_ENABLE			)
	AJC_WNDMAP_MSG(Back, WM_SETFONT			)
	AJC_WNDMAP_MSG(Back, WM_GETFONT			)
	AJC_WNDMAP_MSG(Back, WM_COMMAND			)
	AJC_WNDMAP_MSG(Back, WM_TIMER			)

	AJC_WNDMAP_CMD(Back, IDC_VTH			)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＳＣＰイベント通知ウインドプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(ScpEvt, WM_CREATE			)
{
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(ScpEvt, WM_DESTROY		)
{
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(ScpEvt, WM_CIP_SCPEVENT	)
{
	HAJCCIP 		pW	 = (HAJCCIP)MAjcGetWindowLong(hwnd, sizeof(UX) * 0);
	UI				port = (  UI   )MAjcGetWindowLong(hwnd, sizeof(UX) * 1);
	UI				len, param;
	VOP				vop;
	UBP				pTmp;
	AJCCIPSCPEVT	ScpEvtQue;

	if (pW->hFQueScpEvt != NULL) {
		if (port >= MIN_PORT && port <= MAX_PORT && pW->ExeScp[port].hScp != NULL) {
			AjcScpGetEventData(pW->ExeScp[port].hScp, lParam, &vop, &len, &param);		//	イベントデータ取得
			if (pW->ExeScp[port].hXyModem == NULL) {									//		通常モード？
				if (wParam & (AJCSCP_EV_RXTEXT | AJCSCP_EV_RXESC | AJCSCP_EV_RXCTRL | AJCSCP_EV_RXPKT)) {
					if (pTmp = (UBP)AJCMEM(len + 1)) {
						memcpy(pTmp, vop, len);
						pTmp[len] = 0;
						ScpEvtQue.evt  = (UI)wParam;
						ScpEvtQue.port = port;
						ScpEvtQue.len  = len;
						ScpEvtQue.pDat = pTmp;
						AjcFQueEnque(pW->hFQueScpEvt, &ScpEvtQue);
					}
				}
			}
			else {																		//		XMODEM/YMODEMモード？
				UBP		p = (UBP)vop;
				UI		i;
				if (wParam & AJCSCP_EV_RXCHUNK) {
					for (i = 0; i < len; i++) {
						AjcXymPutRxChar(pW->ExeScp[port].hXyModem, *p++);
					}
				}
			}
			AjcScpRelEventData(pW->ExeScp[port].hScp, lParam);							//	イベントデータ開放
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(ScpEvt)
	AJC_WNDMAP_MSG(ScpEvt, WM_CREATE		)
	AJC_WNDMAP_MSG(ScpEvt, WM_DESTROY 		)
	AJC_WNDMAP_MSG(ScpEvt, WM_CIP_SCPEVENT	)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＴＭＣバックウインドプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define		TMCSECT		"AjcCipTchSect"
#define		IDC_TMC		5010
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TmcBak, WM_CREATE		)
{
	HAJCCIP		pW = (HAJCCIP)(((LPCREATESTRUCT)lParam)->lpCreateParams);
	BOOL		rc = -1;

	//----- ウインド・エクストラ領域へワークポインタ設定 -------------//
	MAjcSetWindowLong(hwnd, 0, (UX)pW);

	//----- タイムチャート・コントロール生成 -------------------------//
	pW->hWndTmc = CreateWindowExA(0,											// extend style
								 "AjcCtrlTmChart",							// window class name
								 pW->ExeTmcTxt,								// window caption
								 WS_CHILD | WS_VISIBLE,						// style
								 0,											// initial x position
								 0,											// initial y position
								 0,											// initial x size
								 200,										// initial y size
								 hwnd,										// parent window handle
								 (HMENU)IDC_TMC,							// window menu handle
								 hDllInst,									// program instance handle
								 NULL);										// creation parameters

	if (pW->hWndTmc != NULL) {
		//	ウインド位置ロード
		AjcLoadWndRectA(hwnd, TMCSECT);
		//	ＴＭＣプロパティロード
		AjcTchLoadPropExA(pW->hWndTmc, TMCSECT, NULL);
		//	ウインド表示
		ShowWindow(pW->hWndTmc, SW_SHOW);
		rc = 0;
	}


	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TmcBak, WM_DESTROY		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	PAJCCIPCALL	pCall;

	if (pW->hWndTmc != NULL) {
		//	_OnTmcClose()実行
		if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnTmcClose")) {		//	呼び出し情報生成
			pCall->pReturn = pW->pCur;										//		戻りアドレス
			AjcFQueEnque(pW->hFQueStdEvt, (VOP)&pCall);						//		イベントをエンキュー
		}
		//	ウインド位置セーブ
		AjcSaveWndRectA(hwnd, TMCSECT);
		//	ＴＭＣプロパティセーブ
		AjcTchSavePropExA(pW->hWndTmc, TMCSECT);
		//	ウインドハンドル無効化
		pW->hWndTmc = NULL;
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TmcBak, WM_SIZE			)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	int			width, height;

	//----- ウインドサイズ設定 -----------------------------//
	width  = LOWORD(lParam);
	height = HIWORD(lParam);
	MoveWindow(pW->hWndTmc, 0, 0, width, height, TRUE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TmcBak, IDC_TMC			)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	switch (HIWORD(wParam)) {
		case AJCTCN_RANGE:					//	●グラフレンジ通知		－					PAJCTC_NTC_RANGE
			break;

		case AJCTCN_SCRPOS:					//	●スクロール位置通知		－				クスロール位置
			break;

		case AJCTCN_CLEAR:					//	●データクリアー通知		－				－
			break;

		case AJCTCN_DBLCLK:					//	●ダブルクリック通知		－				－
			break;

		case AJCTCN_DROPFILE:				//	●ファイルドロップ通知	－					ファイル数
			break;

		case AJCTCN_DROPDIR:				//	●フォルダドロップ通知	－					ディレクトリ数
			break;

	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(TmcBak)
	AJC_WNDMAP_MSG(TmcBak, WM_CREATE		)
	AJC_WNDMAP_MSG(TmcBak, WM_DESTROY 		)
	AJC_WNDMAP_MSG(TmcBak, WM_SIZE	 		)
	AJC_WNDMAP_CMD(TmcBak, IDC_TMC			)
AJC_WNDMAP_END


//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■																											■
//■	１．コードのローディング																				■
//■																											■
//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□
//□	１．１	コードファイル読み出し																			□
//□																											□
//□	引　数	：	pW			- インスタンスハンドル															□
//□				pFilePath	- コードファイルパス															□
//□																											□
//□	戻り値	：	TRUE  - 成功																				□
//□				FALSE - 失敗																				□
//□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□
//----- Ｃ言語字句分解コールバック（ソーステキスト読み出し）----------------------------------------------------//
static BOOL CALLBACK ACL_cbReadLine(BCP pBuf, UI lBuf, UX cbp)
{
	return (fgets(pBuf, lBuf, (FILE *)cbp) != NULL);
}
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipReadMacroText	(HAJCCIP pW)
{
	FILE		*hFile	 = NULL;
	HAJCTK		hCtk	 = NULL;
	PAJCCIPTKN	pTknNode = NULL;
	UI			TknFlag  = 0;
	UI			TknLNo	 = 0;
	UI			i;
	BC			txt[1024];

	//----- インスタンスリセット -------------------------------------------------------------------------------//
	//	エラーコードクリアー
	pW->ErrCod = AJCIP_ERR_OK;

	//	オプション情報リセット
	if (pW->fEnableOption) {
		pW->NumType = AJCIPT_INTEGER;
		pW->fSigned = TRUE;
	}
	//	フラグ情報リセット
	pW->fRunReady = FALSE;
	pW->fRunStop  = FALSE;

	//	字句群解放
	if (pW->pTknTop != NULL) {
		free(pW->pTknTop);
		pW->pTknTop = NULL;
		pW->nTkn	= 0;
	}
	//	２分木リセット
	if (pW->hAvlFun != NULL) AjcAvlDelAllNodes(pW->hAvlFun);	//	ファンクション
	if (pW->hAvlStr != NULL) AjcAvlDelAllNodes(pW->hAvlStr);	//	文字列
	//	変数管理情報リセット
	pW->ixFni = 0;
	AjcVmgPurgeA(pW->sFni[0].hVmg);
	for (i = 1; i < AJCCIPMAX_IXVMG; i++) {
		if (pW->sFni[i].hVmg != NULL) {
			AjcVmgDeleteA(pW->sFni[i].hVmg);
			pW->sFni[i].hVmg = NULL;
		}
	}
	//	完了フラグクリアー
	pW->fRunReady = FALSE;		//	トークン解析（プリコンパイル）完了フラグ
	pW->fRunStop  = FALSE;		//	実行中止フラグ

	do {
		if (hFile = fopen(pW->MacFile, "rt")) {
			//----- スクリプトファイルの読み出し ---------------------------------------------------------------//
			//	字句の個数カウント
			fseek(hFile, 0, SEEK_SET);
			//							↓'$' と全角文字を含める, アポストロフィ(')で囲まれた文字列はエスケース文字(\)を認識しない
			if (hCtk = AjcCtkCreateA(AJCTKFLG_INCSYM_DOLLAR | AJCTKFLG_INCSYM_MBSTR | AJCTKFLG_APOST_NOESC, ACL_cbReadLine, (UX)hFile)) {
				pW->nTkn = 0;
				while(AjcCtkGetTokenA(hCtk, txt, sizeof txt)) {
					pW->nTkn++;
				}
				pW->nTkn++;
				AjcCtkDelete(hCtk);
				hCtk = NULL;
			}
			else {				//	Ｃ言語字句分解インスタンス生成失敗
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, 0,
										  LNGSEL("Ｃ言語字句分解インスタンスの生成を失敗しました。",
												 "C-Lang parser instance creation failure."));
				break;
			}
			//	トークンノードスペース確保
			if (pW->pTknTop = (PAJCCIPTKN)AJCMEM(sizeof(AJCCIPTKN) * pW->nTkn)) {
				memset(pW->pTknTop, 0, sizeof(AJCCIPTKN) * pW->nTkn);
			}
			else {				//	トークンノードスペース確保失敗
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, 0,
										  LNGSEL("字句用メモリの確保を失敗しました。",
												 "Token space allocation failure."));
				break;
			}
			//	字句ノード作成
			fseek(hFile, 0, SEEK_SET);
			//							↓'$' と全角文字を含める, アポストロフィ(')で囲まれた文字列はエスケース文字(\)を認識しない
			if (hCtk = AjcCtkCreateA(AJCTKFLG_INCSYM_DOLLAR | AJCTKFLG_INCSYM_MBSTR | AJCTKFLG_APOST_NOESC, ACL_cbReadLine, (UX)hFile)) {
				pTknNode = pW->pTknTop;
				pW->nTkn = 0;
				while(AjcCtkGetTokenA(hCtk, txt, sizeof txt)) {
					UI CtkErr = AJCTK_ERROR(hCtk);
					if (CtkErr == AJCTKERR_OK) {
						pTknNode->tkn = AJCTK_TOKEN(hCtk);	//	トークンコード
						pTknNode->lno = AJCTK_LINE (hCtk);	//	トークン行番号
						TknLNo		  = pTknNode->lno;		//	・
						TknFlag 	  = AJCTK_FLAG (hCtk);	//	トークン属性フラグ（プリプロセス，ワイド文字）
						if ((TknFlag & AJCTKF_PPORWC) == 0) {
							switch (pTknNode->tkn) {
								case EAJCTK_RSV_DEFINE:		//	・define
								case EAJCTK_RSV_SIGNED:		//	・signed
								case EAJCTK_RSV_UNSIGNED:	//	・unsigned
								case EAJCTK_RSV_DOUBLE:		//	・double
								case EAJCTK_RSV_IF:			//	・if
								case EAJCTK_RSV_ELSE:		//	・else
								case EAJCTK_RSV_DO:			//	・do
								case EAJCTK_RSV_WHILE:		//	・while
								case EAJCTK_RSV_FOR:		//	・for
								case EAJCTK_RSV_BREAK:		//	・break
								case EAJCTK_RSV_RETURN:		//	・return
								case EAJCTK_RSV_GOTO:		//	・goto
									break;

								default:					//	・その他（の予約名）
									if (AJCTKIS_RSVSYM(pTknNode->tkn)) {
										BCP	pStr = (BCP)AjcAvlInsOrGetStrNodeA(pW->hAvlStr, txt);
										if (pStr != NULL) {
											//	ユーザ定義シンボルとして扱う
											pTknNode->tkn	 = EAJCTK_USR_NAME;
											pTknNode->u.pStr = pStr;
										}
										else {	//	ユーザ定義シンボル文字列登録失敗？
											pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, TknLNo,
																	  LNGSEL("シンボル <%s> の登録を失敗しました。",
																			 "Symbol <%s> registration failure."), txt);
										}
									}
									break;

								case EAJCTK_USR_NAME:		//	・ユーザ定義名
								{	BCP	pStr = (BCP)AjcAvlInsOrGetStrNodeA(pW->hAvlStr, txt);
									if (pStr != NULL) {
										if		(mbscmp(pStr, "function") == 0) {
											pTknNode->tkn = EAJCTK_CIP_FUNCTION;
										}
										pTknNode->u.pStr = pStr;
									}
									else {	//	ユーザ定義シンボル文字列登録失敗？
										pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, TknLNo,
																  LNGSEL("シンボル <%s> の登録を失敗しました。",
																		 "Symbol <%s> registration failure."), txt);
									}
									break;
								}

								case EAJCTK_STR_QUOTE:		//	"..."
								case EAJCTK_STR_APOST:		//	'...'
								{	HAJCRNG		hRng = NULL;
									UB			c;
									UI			ix, len;
									EAJCTKCODE	tkn = pTknNode->tkn;
									UI			flg;

									//	エスケープ文字のバイナリ化と連続する文字列の連結
									flg = ((tkn == EAJCTK_STR_QUOTE) ? AJCIP_VAL_QUOTE : AJCIP_VAL_APOST);
									if (hRng = AjcRngCreate(NULL, 0, 1024)) {
										for (;;) {
											ix = 0;
											//	先頭文字（ " or ' ）スキップ
											c = txt[ix++];
											//	文字列をリングバッファに格納
											while (txt[ix] != c && txt[ix] != 0) {
												if (tkn == EAJCTK_STR_QUOTE && txt[ix] == '\\') { // エスケープ文字「"\・・"」？
													if		(memcmp(&txt[ix], "\\a", 2) == 0) {AjcRngPutData(hRng, "\a", 1); ix += 2;}
													else if (memcmp(&txt[ix], "\\b", 2) == 0) {AjcRngPutData(hRng, "\b", 1); ix += 2;}
													else if (memcmp(&txt[ix], "\\f", 2) == 0) {AjcRngPutData(hRng, "\f", 1); ix += 2;}
													else if (memcmp(&txt[ix], "\\n", 2) == 0) {AjcRngPutData(hRng, "\n", 1); ix += 2;}
													else if (memcmp(&txt[ix], "\\r", 2) == 0) {AjcRngPutData(hRng, "\r", 1); ix += 2;}
													else if (memcmp(&txt[ix], "\\t", 2) == 0) {AjcRngPutData(hRng, "\t", 1); ix += 2;}
													else if (memcmp(&txt[ix], "\\v", 2) == 0) {AjcRngPutData(hRng, "\v", 1); ix += 2;}
													else {	//「"￥・・・"」
														ix++; //「\」スキップ
														if (txt[ix] >= '0' && txt[ix] <= '7') {			//	「\ooo」？
															UB	d = 0;
															while (txt[ix] >= '0' && txt[ix] <= '7') {
																d <<= 3;
																d |= (txt[ix] & 7);
																ix++;
															}
															AjcRngPutData(hRng, &d, 1);
														}
														else if (txt[ix] == 'x' || txt[ix] == 'X') {	//	「\xhh」？
															UB	d = 0;
															ix++;
															while (MAjcIsXDigitA(txt[ix])) {
																d <<= 4;
																d |= ((txt[ix] <= '9') ? (txt[ix] & 15) : ((txt[ix] & 15) + 9));
																ix++;
															}
															AjcRngPutData(hRng, &d, 1);
														}
														else if (txt[ix] != 0) {						//	「\c」？
															AjcRngPutData(hRng, &txt[ix], 1);
															ix++;
														}
													}
												}
												else {	//	エスケープ「"\・・"」以外 （ or シングルクォート文字列「'・・・'」）？
													if (_ismbblead(txt[ix]) && _ismbbtrail(txt[ix + 1])) {
														AjcRngPutData(hRng, &txt[ix], 1);
														ix++;
													}
													AjcRngPutData(hRng, &txt[ix], 1);
													ix++;
												}
											}
											//	次の字句が文字列ならば継続（文字列を連結）
											if (AjcCtkPeekTokenA(hCtk, NULL, 0)) {
												tkn = AJCTK_TOKEN(hCtk);
												if (tkn == EAJCTK_STR_QUOTE || tkn == EAJCTK_STR_APOST) {
													if (tkn == EAJCTK_STR_QUOTE) flg = AJCIP_VAL_QUOTE;
													AjcCtkGetTokenA(hCtk, txt, sizeof txt);
													TknFlag = AJCTK_FLAG (hCtk);	//	トークン属性フラグ（プリプロセス，ワイド文字）
													TknLNo	= AJCTK_LINE (hCtk);	//	トークン行番号
												}
												else break;		//	次は文字列でない（文字列連結終了）
											}
											else break;			//	ＥＯＦ
										}	//	End of 'for (;;)'

										//	トークンコード（文字列）設定（EAJCTK_STR_QUOTE or EAJCTK_STR_APOST --> EAJCTK_CIP_STRING）
										pTknNode->tkn = EAJCTK_CIP_STRING;
										//	結合した文字列を登録
										if (pW->ErrCod == AJCIP_ERR_OK) {
											BCP		pAllStr;
											len = AjcRngGetDataSize(hRng);
											if (pAllStr = (BCP)AJCMEM(len + 1)) {
												BCP		pRegStr;
												memset(pAllStr, 0, len + 1);
												AjcRngGetData(hRng, pAllStr, len);
												if (pRegStr = (BCP)AjcAvlInsOrGetStrNodeA(pW->hAvlStr, pAllStr)) {
													pTknNode->flgValue = flg;
													pTknNode->u.pStr  = pRegStr;
												}
												else {	//	文字列登録失敗？
													pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, TknLNo,
																			  LNGSEL("文字列 <%s> の登録を失敗しました。",
																					 "String <%s> registration failure."), txt);
												}
												free(pAllStr);
											}
											else {	//	文字列メモリ確保失敗
												pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, TknLNo,
																		  LNGSEL("文字列 <%s> のメモリ確保を失敗しました。",
																				 "String %s space allocation failure."), txt);
											}
										}
										//	リングバッファ・インスタンス消去
										AjcRngDelete(hRng);
									}
									else {		//	リングバッファ確保失敗
										pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, TknLNo,
																  LNGSEL("文字列作業バッファの確保を失敗しました。",
																		 "String work buffer Allocation failure."));
									}
									break;
								}

								case EAJCTK_VAL_DECIMAL:	//	nnn  （10進数）
									pTknNode->tkn	   = EAJCTK_CIP_INTEGER;
									pTknNode->flgValue = AJCIP_VAL_DEC;
									pTknNode->u.val    = AjcAscToLIntA(txt);
									break;

								case EAJCTK_VAL_HEXA:		//	0xhhh（16進数）
									pTknNode->tkn	   = EAJCTK_CIP_INTEGER;
									pTknNode->flgValue = AJCIP_VAL_HEX;
									pTknNode->u.val    = AjcAscToLIntA(txt);
									break;

								case EAJCTK_VAL_OCTAL:		//	0nnn （8進数）
									pTknNode->tkn	   = EAJCTK_CIP_INTEGER;
									pTknNode->flgValue = AJCIP_VAL_OCT;
									pTknNode->u.val    = (SLL)AjcOctToULLA(txt);
									break;

								case EAJCTK_VAL_REAL:		//	nn.mm / nnnE[+-]mm
									pTknNode->tkn	   = EAJCTK_CIP_REAL;
									pTknNode->flgValue = AJCIP_VAL_REAL;
									pTknNode->u.dbl    = AjcAscToRealA(txt);
									break;

							}	// End of 'switch (pTknNode->tkn)'

							//	エラーならば終了
							if (pW->ErrCod != AJCIP_ERR_OK) break;
							//	トークンノードカウンタ，アドレス更新
							pW->nTkn++;
							pTknNode++;
						}
						else {	//	プリプロセス文／ワイド文字列？
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, TknLNo,
													  LNGSEL("不正な字句です。<%s>",
															 "Invalid token (%s)."), txt);
							break;
						}
					}
					else {		//	CtkErr != AJCTKERR_OK
						if (CtkErr == AJCTKERR_MEMALLOC)
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM   , TknLNo,
													  LNGSEL("字句用メモリの確保を失敗しました。",
															 "Token space allocation failure."));
						else if (CtkErr == AJCTKERR_BUFOVER)
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, TknLNo,
													  LNGSEL("字句が長すぎます。",
															 "Token too long."));
						else
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, TknLNo,
													  LNGSEL("不正な字句です。<%s>",
															 "Invalid token <%s>."), txt);
						break;
					}
				}	// End of 'while(AjcCtkGetTokenA(hCtk, txt, sizeof txt))'

				//	終端（EAJCTK_EOF）設定
				pTknNode->tkn = EAJCTK_EOF;
				pTknNode->lno =TknLNo + 1;

				//	Ｃ言語字句分解インスタンス消去
				AjcCtkDelete(hCtk);
				hCtk = NULL;
				//	エラーならば終了
				if (pW->ErrCod != AJCIP_ERR_OK) break;
			}
			else {					//	Ｃ言語字句分解インスタンス生成失敗？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, 0,
										  LNGSEL("Ｃ言語字句分解インスタンスの生成を失敗しました。",
												 "C-Lang parser instance creation failure."));
				break;
			}
			//	スクリプトファイル・クローズ
			fclose(hFile);
			hFile = NULL;
		}
		else {	//	スクリプトファイル・オープン失敗？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, 0,
									  LNGSEL("ファイルのオープンを失敗しました。 <%s>",
											 "File open failure. <%s>"), pW->MacFile);
			break;
		}
	} while(0);

	return (pW->ErrCod == AJCIP_ERR_OK);
}

//□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□
//□	１．２	コードの解析（プリコンパイル）																	□
//□																											□
//□	引　数	：	pW			- インスタンスハンドル															□
//□																											□
//□	戻り値	：	TRUE  - 成功																				□
//□				FALSE - 失敗																				□
//□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□□
BOOL	CipAnalize	(HAJCCIP pW)
{
	BOOL		rc = TRUE;
	PAJCCIPTKN	pSymTkn = NULL;

	//	実行初期化
	pW->ErrCod = AJCIP_ERR_OK;

	do {
		//	ノードポインタ設定
		pW->pCur = pW->pTknTop;
		//------------------------------------------------------------------------------------------------------//
		//	オプション指定チェック																				//
		//------------------------------------------------------------------------------------------------------//
		if (pW->fEnableOption) {
			if (pW->pCur->tkn == EAJCTK_USR_NAME && mbscmp(pW->pCur->u.pStr, "option") == 0) {
				//	'option' スキップ
				pW->pCur++;
				//	'option' パラメタチェック
				if		(pW->pCur->tkn == EAJCTK_RSV_SIGNED  ) {	//	'signed'
					pW->NumType = AJCIPT_INTEGER;
					pW->fSigned = TRUE;
					pW->pCur++;
				}
				if		(pW->pCur->tkn == EAJCTK_RSV_UNSIGNED) {	//	'unsigned'
					pW->NumType = AJCIPT_INTEGER;
					pW->fSigned = FALSE;
					pW->pCur++;
				}
				else if (pW->pCur->tkn == EAJCTK_RSV_DOUBLE  ) {	//	'double'
					pW->NumType = AJCIPT_REAL;
					pW->pCur++;
				}
				else if (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {		//	';' 以外
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
											  LNGSEL("<%s> は無効なオプションパラメータです。",
													 "Invalid option parameter <%s>."), CipGsrTknStr(pW->pCur));
					pW->pCur++;
					rc = FALSE;
				}
				//	直後がセミコロンならばスキップ
				if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {
					pW->pCur++;
				}
			}
		}
		//------------------------------------------------------------------------------------------------------//
		//	システム変数登録		@rc  - 演算式中の関数戻り値		$@rc  - 予備								//
		//	（関数戻り値）			@rc1 - 予備						$@rc1 - 文字列比較時の関数戻り値			//
		//							@rc2 - 予備						$@rc2 - 文字列比較時の関数戻り値			//
		//------------------------------------------------------------------------------------------------------//
		{	BCP	p;

			p = "@rc";		AjcVmgDelVarA(pW->sFni[0].hVmg, p);	AjcVmgGenVarA(pW->sFni[0].hVmg, p, pW->NumType, 1);
			p = "@rc1";		AjcVmgDelVarA(pW->sFni[0].hVmg, p);	AjcVmgGenVarA(pW->sFni[0].hVmg, p, pW->NumType, 1);
			p = "@rc2";		AjcVmgDelVarA(pW->sFni[0].hVmg, p);	AjcVmgGenVarA(pW->sFni[0].hVmg, p, pW->NumType, 1);

			p = "$@rc";		AjcVmgDelVarA(pW->sFni[0].hVmg, p);	AjcVmgGenVarA(pW->sFni[0].hVmg, p, AJCVMGT_STR, 1);
			p = "$@rc1";	AjcVmgDelVarA(pW->sFni[0].hVmg, p);	AjcVmgGenVarA(pW->sFni[0].hVmg, p, AJCVMGT_STR, 1);
			p = "$@rc2";	AjcVmgDelVarA(pW->sFni[0].hVmg, p);	AjcVmgGenVarA(pW->sFni[0].hVmg, p, AJCVMGT_STR, 1);
		}
		//------------------------------------------------------------------------------------------------------//
		//	システム定数登録																					//
		//------------------------------------------------------------------------------------------------------//
		{
			int		i;

			//	数値定数
			for (i = 0; i < MAX_CONSTVAL; i++) {
				//	変数作成
				AjcVmgGenVarA	 (pW->sFni[0].hVmg, ConstVal[i].pVarName, (AJCVMGTYPE)pW->NumType, 1);
				//	変数値設定
				AjcVmgSetIntegerA(pW->sFni[0].hVmg, ConstVal[i].pVarName, 0, ConstVal[i].val);
				//	読み出し専用属性設定
				AjcVmgSetAttA	 (pW->sFni[0].hVmg, ConstVal[i].pVarName, AJCVMGA_RDONLY);
			}
			//	文字定数
			//	$_CR
			AjcVmgGenVarA	 (pW->sFni[0].hVmg, "$_CR", (AJCVMGTYPE)AJCIPT_STRING, 1);
			AjcVmgSetStringA (pW->sFni[0].hVmg, "$_CR", 0, "\r");
			AjcVmgSetAttA	 (pW->sFni[0].hVmg, "$_CR", AJCVMGA_RDONLY);
			//	$_LF
			AjcVmgGenVarA	 (pW->sFni[0].hVmg, "$_LF", (AJCVMGTYPE)AJCIPT_STRING, 1);
			AjcVmgSetStringA (pW->sFni[0].hVmg, "$_LF", 0, "\n");
			AjcVmgSetAttA	 (pW->sFni[0].hVmg, "$_LF", AJCVMGA_RDONLY);
			//	$_CRLF
			AjcVmgGenVarA	 (pW->sFni[0].hVmg, "$_CRLF", (AJCVMGTYPE)AJCIPT_STRING, 1);
			AjcVmgSetStringA (pW->sFni[0].hVmg, "$_CRLF", 0, "\r\n");
			AjcVmgSetAttA	 (pW->sFni[0].hVmg, "$_CRLF", AJCVMGA_RDONLY);
			//	$_MyPath
			AjcVmgGenVarA	 (pW->sFni[0].hVmg, "$_MyPath", (AJCVMGTYPE)AJCIPT_STRING, 1);
			AjcVmgSetStringA (pW->sFni[0].hVmg, "$_MyPath", 0, pW->MacPath);
			AjcVmgSetAttA	 (pW->sFni[0].hVmg, "$_MyPath", AJCVMGA_RDONLY);
			//	$MyName
			AjcVmgGenVarA	 (pW->sFni[0].hVmg, "$_MyName", (AJCVMGTYPE)AJCIPT_STRING, 1);
			AjcVmgSetStringA (pW->sFni[0].hVmg, "$_MyName", 0, pW->MacFName);
			AjcVmgSetAttA	 (pW->sFni[0].hVmg, "$_MyName", AJCVMGA_RDONLY);
		}
		//------------------------------------------------------------------------------------------------------//
		//	静的変数名，関数名の登録																			//
		//------------------------------------------------------------------------------------------------------//
		//	最初 'define' / 'function'
		while (pW->pCur->tkn == EAJCTK_RSV_DEFINE || pW->pCur->tkn == EAJCTK_CIP_FUNCTION) {
			//	エラーコードクリア（変数／ファンクションの登録を継続させる為）
			pW->ErrCod = AJCIP_ERR_OK;
			//	変数／ファンクションの登録（エラーがあっても中断しない）
			if		(pW->pCur->tkn == EAJCTK_RSV_DEFINE) {
				pW->pCur++;									//	'define' スキップ
				rc &= SubRegistVariable(pW);				//	変数登録
			}
			else if (pW->pCur->tkn == EAJCTK_CIP_FUNCTION) {
				pW->pCur++;									//	'function' スキップ
				rc &= SubRegistFunction(pW);				//	ファンクション登録
			}
		}
		//	終端チェック
		if (pW->pCur->tkn != EAJCTK_EOF) {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("シンタックスエラー <%s>",
											 "Syntax error <%s>."), CipGsrTknStr(pW->pCur));
			rc = FALSE;
		}

		//------------------------------------------------------------------------------------------------------//
		//	各関数の制御構造解析																				//
		//------------------------------------------------------------------------------------------------------//
		pW->fAnlRsu = TRUE;
		AjcAvlEnumNodes(pW->hAvlFun, cbNtcFuncs, FALSE);
		rc &= pW->fAnlRsu;

	} while(0);

	return rc;
}

//┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
//┃	1.2.1	変数／配列の登録																				┃
//┃																											┃
//┃	引　数	：	pW			- インスタンスハンドル															┃
//┃				pSymTkn		- 変数名トークン情報のアドレス													┃
//┃				fNumeric	- 数値タイプフラグ																┃
//┃																											┃
//┃	戻り値	：	TRU E：成功																					┃
//┃				FALSE：失敗																					┃
//┃																											┃
//┃	備　考	：	入力：pW->pCur	- 'define' の次のトークン													┃
//┃				出力：pW->pCur	- 変数定義の次のトークン													┃
//┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
static	BOOL	SubRegistVariable(HAJCCIP pW)
{
	BOOL		rc = TRUE;
	PAJCCIPTKN	pTop	= pW->pCur;
	PAJCCIPTKN	pSymTkn = NULL;
	BOOL		fNumeric;

	while (pW->pCur->tkn == EAJCTK_USR_NAME) {
		//	シンボルのノードポインタ，タイプ（数値／文字列($)）設定
		pSymTkn 	= pW->pCur;
		fNumeric	= ((*pW->pCur->u.pStr != '$') ? TRUE : FALSE);
		//	シンボルスキップ
		pW->pCur++;
		//	変数登録
		switch (pW->pCur->tkn) {
			case EAJCTK_DLM_EQ:				//	・'=' (define initilized variable 
				pW->pCur++;					//	  '=' スキップ
				SubRegistInitedVar(pW, pSymTkn, fNumeric);
				break;

			case EAJCTK_DLM_LLPART:			//	・'[' (define array)
				pW->pCur++;					//	  '[' スキップ
				SubRegistArray	  (pW, pSymTkn, fNumeric);
				break;

			default:
				SubRegistNoInitVar(pW, pSymTkn, fNumeric);
				break;
		}
		//	',' スキップ
		if (pW->pCur->tkn == EAJCTK_DLM_COMMA) {
			pW->pCur++;
		}
		else {
			break;
		}
	}
	//	正常ならば ';' チェック
	if (pW->ErrCod == AJCIP_ERR_OK) {
		//	';' チェック
		if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {		//	';' ？
			pW->pCur++;									//	';' スキップ
		}
		else {											//	';' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("'%s' の直前（変数定義の末尾）に ';' が必要です。",
											 "Need ';' before '%s' (tail of variables definition)."), CipGsrTknStr(pW->pCur));
			rc = FALSE;
		}
	}
	//	エラーならば、変数定義をスキップ
	if (!rc) {
		pW->pCur = pTop;
		//	';' までスキップ
		while (pW->pCur->tkn != EAJCTK_DLM_SEMICOL && pW->pCur->tkn != EAJCTK_EOF) {
			pW->pCur++;
		}
		//	';' が見つかったら ';' スキップ
		while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {
			pW->pCur++;
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	変数／配列の登録（初期値なし変数の登録）																	//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- 変数名トークン情報のアドレス														//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	＝AJCIP_ERR_OK：成功																			//
//				≠AJCIP_ERR_OK：失敗																			//
//																												//
//	備　考	：	入力：pW->pCur	- 'define 変数' の次のトークン													//
//				出力：pW->pCur	- 変数定義の次のトークン														//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistNoInitVar(HAJCCIP pW, PAJCCIPTKN pSymTkn, BOOL fNumeric)
{
	BOOL		rc;
	AJCVMGTYPE	VmgType = fNumeric ? (pW->NumType == AJCIPT_INTEGER ? AJCVMGT_LONG : AJCVMGT_REAL) : AJCVMGT_STR;
	UI			lno = pSymTkn->lno;

	rc = CipVmgGenVar(pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, VmgType, 0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	変数／配列の登録（初期値あり変数の登録）																	//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- 変数名トークン情報のアドレス														//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	＝AJCIP_ERR_OK：成功																			//
//				≠AJCIP_ERR_OK：失敗																			//
//																												//
//	備　考	：	入力：pW->pCur	- 'define 変数 = ' の次のトークン（式の先頭）									//
//				出力：pW->pCur	- 変数定義の次のトークン														//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistInitedVar(HAJCCIP pW, PAJCCIPTKN pSymTkn, BOOL fNumeric)
{
	BOOL		rc;
	AJCVMGTYPE	VmgType = fNumeric ? (pW->NumType == AJCIPT_INTEGER ? AJCVMGT_LONG : AJCVMGT_REAL) : AJCVMGT_STR;
	UI			lno 	= pSymTkn->lno;

	if (rc = CipVmgGenVar(pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, VmgType, 0)) {	//	変数登録ＯＫ？
		//	式の評価と値設定ＯＫ？
		if (!(rc = SubRegistSetVar(pW, pSymTkn, 0, fNumeric))) {
			//	エラーならば、変数登録解除
			AjcVmgDelVarA(pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr);
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	変数／配列の登録（配列変数の登録）																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- 変数名トークン情報のアドレス														//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	TRUE ：成功																						//
//				FALSE：失敗																						//
//																												//
//	備　考	：	入力：pW->pCur - 'define 変数[' の次のトークン（配列要指数「式」の先頭）						//
//				出力：pW->pCur - 変数定義の次のトークン															//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistArray(HAJCCIP pW, PAJCCIPTKN pSymTkn, BOOL fNumeric)
{
	BOOL		rc = TRUE;
	SLL			nArr;

	//	配列要素数設定
	if (pW->pCur->tkn == EAJCTK_DLM_RLPART) {								//	']' ？
		nArr = 0;															//	要素数＝０（初期値の個数）
	}
	else {																	//	']' 以外？
		rc = CipFmlINT(pW, &nArr, CALCULATION);								//	要素数算出
	}

	//	変数／配列の登録
	if (rc) {																//	配列要素数設定ＯＫ？
		if (pW->pCur->tkn == EAJCTK_DLM_RLPART) {							//	']' ？
			pW->pCur++;														//	']' スキップ
			if (pW->pCur->tkn == EAJCTK_DLM_EQ) {							//	']' の直後は '='
				pW->pCur++;													//	'=' スキップ
				rc = SubRegistInitedArr(pW, pSymTkn, (UI)nArr, fNumeric);
			}
			else {															//	']' の直後が '=' 以外？
				rc = SubRegistNoInitArr(pW, pSymTkn, (UI)nArr, fNumeric);
			}
		}
		else {																//	式（配列要素数）の直後が ']' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
									  LNGSEL("配列要素数の直後に ']' が必要です。",
											 "Need ']' after array elements."));
			rc = FALSE;
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	変数／配列の登録（初期値なし配列変数の登録）																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- 変数名トークン情報のアドレス														//
//				nArr		- 配列要素数																		//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	TRUE ：成功																						//
//				FALSE：失敗																						//
//																												//
//	備　考	：	入力：pW->pCur	- '変数[nnn]' の次のトークン													//
//				出力：pW->pStmt - 変数定義の次のステートメント先頭トークン（正常時のみ）						//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistNoInitArr(HAJCCIP pW, PAJCCIPTKN pSymTkn, UI nArr, BOOL fNumeric)
{
	BOOL		rc;
	AJCVMGTYPE	VmgType = fNumeric ? (pW->NumType == AJCIPT_INTEGER ? AJCVMGT_LONG : AJCVMGT_REAL) : AJCVMGT_STR;
	UI			lno 	= pSymTkn->lno;

	rc = CipVmgGenVar(pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, VmgType, nArr);		//	配列変数登録

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	変数／配列の登録（初期値あり配列変数の登録）																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- 変数名トークン情報のアドレス														//
//				nArr		- 配列要素数（０の場合は初期値の数を要素数とする）									//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	TRUE ：成功																						//
//				FALSE：失敗																						//
//																												//
//	備　考	：	入力：pW->pCur	- '変数[nnn] = ' の次のトークン													//
//				出力：pW->pStmt - 変数定義の次のステートメント先頭トークン（正常時のみ）						//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistInitedArr(HAJCCIP pW, PAJCCIPTKN pSymTkn, UI nArr, BOOL fNumeric)
{
	BOOL		rc = TRUE;
	UI			ix;
	AJCVMGTYPE	VmgType = fNumeric ? (pW->NumType == AJCIPT_INTEGER ? AJCVMGT_LONG : AJCVMGT_REAL) : AJCVMGT_STR;
	UI			lno 	= pSymTkn->lno;

	if (nArr == 0) {
		rc = SubRegistValueCount(pW, pSymTkn, &nArr, fNumeric);
	}
	if (rc) {
		if (rc = CipVmgGenVar(pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, VmgType, nArr)) {	//	変数登録ＯＫ？
			if (pW->pCur->tkn == EAJCTK_DLM_LMPART) {												//	'=' の次は '{' ？
				ix = 0;																				//		配列要素数カウンタ初期化
				do {
					pW->pCur++;																		//		pCur = 式の先頭（'{' or ',' の直後）
					if (ix < nArr) {																//		配列要素数以内？
						if (SubRegistSetVar(pW, pSymTkn, ix, fNumeric)) {							//		式の評価と値設定ＯＫ？
							ix++;																	//		配列インデクス更新
						}
						else break;																	//		式の評価ＮＧ？
					}
					else {																			//		配列要素数オーバー？
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
												  LNGSEL("配列の初期値が多すぎます。",
														 "Too maiy array initilizer."));
						rc = FALSE;
						break;																		//		→終了
					}
				} while (pW->pCur->tkn == EAJCTK_DLM_COMMA);										//		',' ならば初期値継続

				if (rc) {																			//		エラーなし？
					if (pW->pCur->tkn == EAJCTK_DLM_RMPART) {										//		式の次は '}' ？
						pW->pCur++;																	//		'}' スキップ
					}
					else {																			//	式の次は '}' 以外？
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
												  LNGSEL("配列初期値群の直後に '}' が必要です。",
														 "Need '}' after array initial values."));
						rc = FALSE;
					}
				}
			}
			else {																					//	'=' の次は '{' 以外？
				rc = SubRegistSetVar(pW, pSymTkn, 0, fNumeric);										//		式の評価と値設定ＯＫ？
			}
			//	エラーならば、変数登録解除
			if (!rc) {
				AjcVmgDelVarA(pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr);
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	初期値の個数カウント																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- シンボルトークン情報のアドレス													//
//				pCnt		- 初期値の個数を格納するバッファのアドレス											//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	TRUE ：成功																						//
//				FALSE：失敗																						//
//																												//
//	備　考	：	pW->pCur - 入力：'=' の次のトークン																//
//						   出力：入力時と同じ																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistValueCount(HAJCCIP pW, PAJCCIPTKN pSymTkn, UIP pCnt, BOOL fNumeric)
{
	BOOL		rc = TRUE;
	PAJCCIPTKN	pSvCur = pW->pCur;

	if (pW->pCur->tkn == EAJCTK_DLM_LMPART) {														//	'=' の次は '{' ？
		*pCnt = 0;																					//	初期値の個数カウンタクリアー
		do {
			pW->pCur++;																				//		pCur = 式の先頭（'{' or ',' の直後）
			if (fNumeric) {																			//	●整数
				if (pW->NumType == AJCIPT_INTEGER)	rc = CipFmlINT(pW, NULL, SYNTAX_ONLY);			//	式評価
				else								rc = CipFmlDBL(pW, NULL, SYNTAX_ONLY);
				if (!rc) {																			//	式評価ＮＧ？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
											  LNGSEL("変数 <%s> の初期値指定に誤りがあります。",
													 "Missing inializer in <%s>."), pSymTkn->u.pStr);
					rc = FALSE;
					break;
				}
			}
			else {																					//	●文字
				if (pW->pCur->tkn == EAJCTK_CIP_STRING) {											//	文字列トークン？
					pW->pCur++;																		//	文字列スキップ
				}
				else {																				//	文字列トークン以外？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
											  LNGSEL("文字列変数 <%s> の初期値指定に誤りがあります。",
													 "Missing string inializer in <%s>."), pSymTkn->u.pStr);
					rc = FALSE;
					break;
				}
			}
			(*pCnt)++;																				//	
		} while (pW->pCur->tkn == EAJCTK_DLM_COMMA);												//		',' ならば初期値継続
	}
	else {																							//	'=' の次は '{' 以外？
		*pCnt = 1;
	}
	//	トークンポインタ回復
	pW->pCur = pSvCur;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	変数／配列の登録（変数の値設定）																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSymTkn		- シンボルトークン情報のアドレス													//
//				ix			- 配列の添え字																		//
//				fNumeric	- 数値タイプフラグ																	//
//																												//
//	戻り値	：	TRUE ：成功																						//
//				FALSE：失敗																						//
//																												//
//	備　考	：	pW->pCur - 入力：式の先頭トークン																//
//						   出力：式の次のトークン（正常時のみ）													//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRegistSetVar(HAJCCIP pW, PAJCCIPTKN pSymTkn, UI ix, BOOL fNumeric)
{
	BOOL		rc;
	AJCCIP_UVAL	val;
	UI			lno = pSymTkn->lno;
	BOOL		fFmlErr = FALSE;

	//	数値変数の初期値設定
	if (fNumeric) {
		if (pW->NumType == AJCIPT_INTEGER) {																	  //●整数
			if (rc = CipFmlINT(pW, &val.sll, CALCULATION)) {													  // 式の評価ＯＫ？
				rc = CipVmgSetInteger(pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, ix, val.sll);			  // 変数／配列[n]の初期値設定
			}
			else fFmlErr = TRUE;
		}
		else {																									  //●実数
			if (rc = CipFmlDBL(pW, &val.dbl, CALCULATION)) {													  // 式評価ＯＫ？
				rc = CipVmgSetReal	 (pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, ix, val.dbl);			  // 変数／配列[n]の初期値設定
			}
			else fFmlErr = TRUE;
		}
		if (fFmlErr) {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("変数 <%s> の初期値指定に誤りがあります。",
											 "Missing inializer in <%s>."), pSymTkn->u.pStr);
		}
	}
	//	文字列変数の初期値設定
	else {
		if (pW->pCur->tkn == EAJCTK_CIP_STRING) {																  // 文字列トークン？
			if (rc = CipVmgSetString(pW, lno, pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr, ix, pW->pCur->u.pStr)) { // 変数に文字列登録成功？
				pW->pCur++;																						  // トークンポインタ更新
			}
		}
		else {																									  // 文字列トークン以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("文字列変数 <%s> の初期値指定に誤りがあります。",
											 "Missing string inializer in <%s>."), pSymTkn->u.pStr);
			rc = FALSE;
		}
	}
	return rc;
}


//┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
//┃	1.2.2	ファンクションの登録																			┃
//┃																											┃
//┃	引　数	：	pW			- インスタンスハンドル															┃
//┃				pSymTkn		- 関数名トークン情報のアドレス													┃
//┃				fNumeric	- 数値タイプフラグ																┃
//┃																											┃
//┃	戻り値	：	TRUE ：成功																					┃
//┃				FALSE：失敗																					┃
//┃																											┃
//┃	備　考	：	pW->pCur - 'function' の次のトークン														┃
//┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
static	BOOL	SubRegistFunction(HAJCCIP pW)
{
	BOOL		rc		= TRUE;
	PAJCCIPTKN	pTop	= pW->pCur;
	PAJCCIPTKN	pSav	= NULL;
	PAJCCIPTKN	pSymTkn = NULL;
	PAJCCIPTKN	pEnd	= NULL;
	AJCCIPFUNC	fun;
	AJCCIPARG	arg;
	UI			nest;
	BOOL		fNumeric;

	//	ファンクション情報クリアー
	memset(&fun, 0, sizeof fun);

	if (pW->pCur->tkn == EAJCTK_USR_NAME) {
		//	シンボルのノードポインタ，タイプ（数値／文字列($)）設定
		pSymTkn 	 = pW->pCur;
		fNumeric	 = ((*pW->pCur->u.pStr != '$') ? TRUE : FALSE);
		//	シンボル（関数名）をスキップ
		pW->pCur++;
		if (pW->pCur->tkn == EAJCTK_DLM_LSPART) {	//	'(' ？
			//	'(' スキップ
			pW->pCur++;
			//	ファンクション情報設定
			fun.pFunName = pSymTkn->u.pStr;										//	関数名
			fun.typRet	 = fNumeric ? pW->NumType : AJCIPT_STRING;				//	戻り値のタイプ
			if ((fun.hQueArg = AjcFQueCreate(sizeof(fun), 0, NULL)) != NULL) {	//	引数リストキュー
				//	'function <Symbol> (' の次のトークンをポイント
				pSav = pW->pCur;
				//	引数リストキュー作成
				fun.nArg = 0;
				if (pW->pCur->tkn == EAJCTK_USR_NAME) {	//	シンボル（引数名）？
					do {
						//	',' スキップ
						if (pW->pCur->tkn == EAJCTK_DLM_COMMA) {
							pW->pCur++;
						}
						//	引数情報クリアー
						memset(&arg, 0, sizeof arg);
						//	引数タイプ設定
						if (*pW->pCur->u.pStr != '$') arg.typ = pW->NumType;
						else						  arg.typ = AJCIPT_STRING;
						//	引数名設定
						arg.pSym = pW->pCur->u.pStr;
						//	引数の個数更新
						fun.nArg++;
						//	引数名スキップと配列フラグ設定
						pW->pCur++;		// シンボルスキップ
						//	引数が配列かのチェック
						if (pW->pCur->tkn == EAJCTK_DLM_LLPART) {		//	'[' ？
							pSav = pW->pCur++;							//	'[' スキップ
							if (pW->pCur->tkn == EAJCTK_DLM_RLPART) {	//	']' ？
								pW->pCur++;								//	']' スキップ
								arg.fArr = TRUE;						//	引数が配列である旨、フラグ設定
							}
							else {
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
														  LNGSEL("'[' の直後に ']' が必要です。",
																 "Need ']' after '['."));
								rc = FALSE;
								break;
							}
						}
						//	引数キューエントリ作成
						if (!AjcFQueEnque(fun.hQueArg, &arg)) {
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pSymTkn->lno,
													  LNGSEL("関数の引数リストキューエントリの確保に失敗しました。",
															 "Arguments list queue memory allocation failure."));
							rc = FALSE;
							break;
						}
					} while (pW->pCur->tkn == EAJCTK_DLM_COMMA);
				}
				if (rc) {
					//	引数の終端 ')' チェック
					if (pW->pCur->tkn == EAJCTK_DLM_RSPART) {			//	引数の終端は ')' ？
						//	')' スキップ
						pSav = pW->pCur++;
						//	'{' チェック
						if (pW->pCur->tkn == EAJCTK_DLM_LMPART) {		//	')' の次は '{' ？
							//	関数の入り口点（ '{' ）設定
							fun.pEntry	= pW->pCur;
							//	'{' スキップ
							pW->pCur++;
							//	関数の終端 '}' までスキップ
							nest = 1;
							while (nest != 0 && pW->pCur->tkn != EAJCTK_EOF) {
								switch (pW->pCur->tkn) {
									case EAJCTK_DLM_LMPART: nest++; break;	//	'{'
									case EAJCTK_DLM_RMPART: nest--; break;	//	'}'
								}
								pEnd = pW->pCur++;
							}
							//	関数の終端チェック
							if (nest == 0) {
								pEnd->flgCtrl = AJCIP_FUNC_END;
							}
							else {															//	エラー（ＥＯＦ検出）
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
															  LNGSEL("関数の途中で予期せぬEOFを検出しました。",
																	 "Unexpected EOF was detected."));
								rc = FALSE;
							}
						}
						else {																//	エラー（'{' が無い）
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
														  LNGSEL("')' の次に '{' が必要です。",
																 "Need '}' after ')'."));
							rc = FALSE;
						}
					}
					else {																	//	エラー（引数リストの終端が ')' 以外）
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
													  LNGSEL("<%s> の次に ')' が必要です。",
																 "Need ')' after <%s>."), pSav->u.pStr);
						rc = FALSE;
					}
					//	ＯＫならば、ファンクション情報登録
					if (rc) {
						//	ファンクション登録
						if (!AjcAvlInsNode(pW->hAvlFun, (UX)fun.pFunName, (C_VOP)&fun, sizeof fun)) {	//	ファンクション登録失敗？
							//	エラー通知（二重定義）
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSymTkn->lno,
														  LNGSEL("ファンクション名 <%s> は既に定義されています。",
																 "Multiple defined <%s>."), CipGsrTknStr(pSymTkn));
							rc = FALSE;
						}
					}
				}
			}
			else {																			//	エラー（メモリ不足）
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pSymTkn->lno,
										  LNGSEL("関数の引数リスト用メモリの確保に失敗しました。",
												 "Arguments list memory allocation failure."));
				rc = FALSE;
			}
		}
		else {																				//	エラー（関数名の次が '(' 以外）
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSymTkn->lno,
									  LNGSEL("ファンクション名 <%s> の直後に '(' が必要です。",
											 "Need '(' after function name <%s>."), CipGsrTknStr(pSymTkn));
			rc = FALSE;
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
								  LNGSEL("「function」の直後は、ファンクション名でなければなりません。",
										 "Need function name after 'function'."));
		rc = FALSE;
	}

	//	エラーならば、後始末と関数定義スキップ
	if (!rc) {
		//	引数リストキュー消去
		if (fun.hQueArg != NULL) {
			AjcFQueDelete(fun.hQueArg);
			fun.hQueArg = NULL;
		}
		//	関数定義スキップ
		pW->pCur = pTop;
		//	'{' までスキップ
		while (pW->pCur->tkn != EAJCTK_DLM_LMPART && pW->pCur->tkn != EAJCTK_EOF) {
			pW->pCur++;
		}
		//	'{' が見つかったら、対応する '}' までスキップ
		if (pW->pCur->tkn == EAJCTK_DLM_LMPART) {
			//	'{' スキップ
			pW->pCur++;
			//	対応する '}' までスキップ
			nest = 1;
			while (nest != 0 && pW->pCur->tkn != EAJCTK_EOF) {
				switch (pW->pCur->tkn) {
					case EAJCTK_DLM_LMPART: nest++; break;	//	'{'
					case EAJCTK_DLM_RMPART: nest--; break;	//	'}'
				}
				pW->pCur++;
			}
		}
	}
	return rc;
}
//┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
//┃	1.2.3	関数の制御構造解析																				┃
//┃																											┃
//┃	引　数	：	key			- 関数名のアドレス																┃
//┃				pNodeData	- 関数登録情報ノード（AJCCIPFUNC）のアドレス									┃
//┃				len			- ノードデータのバイト数（= sizeof(AJCCIPFUNC)）								┃
//┃				nest		- ネスト位置（２分木の高さ）													┃
//┃				cbp			- インスタンスワークのアドレス													┃
//┃																											┃
//┃	戻り値	：	TRUE  - 関数検索継続																		┃
//┃				FALSE - 関数検索中止																		┃
//┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
static BOOL CALLBACK cbNtcFuncs(UX key, C_VOP pNodeData, UI len, UI nest, UX cbp)
{
	BOOL			rsu	  = TRUE;
	HAJCCIP			pW	  = (HAJCCIP)cbp;
	PCAJCCIPFUNC	pFunc = (PCAJCCIPFUNC)pNodeData;

	//	エラークリアー
	pW->ErrCod = AJCIP_ERR_OK;

	//	入り口点設定
	pW->pCur  = pFunc->pEntry;
	pW->pFml  = pFunc->pEntry;

	//	変数初期化
	pW->AnlNest    = 0;		//	制御構造のネスト				（カウンタ）

	//----- 制御構造解析 ---------------------------------------------------------------------------------------//
	//	制御構造体Exitポイント登録用キュー，ラベルポイント登録用ＡＶＬ生成
	pW->hAnlFQExit	 = NULL;
	pW->hAnlAvlLabel = NULL;
	if ((pW->hAnlFQExit   = AjcFQueCreate(sizeof(AJCCIPEXIT), 0, NULL)) != NULL &&
		(pW->hAnlAvlLabel = AjcAvlCreate (0, cbAvlCompStr, NULL))		!= NULL) {

		//	関数の末尾検索
		rsu = SubAnalSkipStmt(pW, pFunc);
		while (rsu == TRUE && pW->pCur->tkn != EAJCTK_EOF && pW->AnlNest != 0) {
			rsu = SubAnalSkipStmt(pW, pFunc);
		}
		if (rsu == TRUE && pW->AnlNest != 0) {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
										  LNGSEL("制御構造に誤りがあります。",
												 "Illegal control structure."));
			rsu = pW->fAnlRsu = FALSE;
		}
		//	正常ならば、'break'，'goto' のジャンプ先設定
		if (rsu == TRUE) {
			rsu = SubAnalSetGotoAndBreakJmpAddr(pW, pFunc);
		}
	}
	else {	//	制御構造体Exitポイント登録用キュー生成 失敗？
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pW->pCur->lno,
									  LNGSEL("制御構造登録バッファの生成を失敗しました。",
											 "Control structure registration buffer creation failure."));
		rsu = pW->fAnlRsu = FALSE;
	}

	//	制御構造体Exitポイント登録用キュー 消去
	if (pW->hAnlFQExit != NULL) {
		AjcFQueDelete(pW->hAnlFQExit);
		pW->hAnlFQExit = NULL;
	}
	//	ラベルポイント登録用ＡＶＬ 消去
	if (pW->hAnlAvlLabel != NULL) {
		AjcAvlDelete(pW->hAnlAvlLabel);
		pW->hAnlAvlLabel = NULL;
	}
	return TRUE;	//	TRUE : 関数検索継続
}
//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（ステートメントをスキップ）																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pFunc		- 関数登録情報ノード（AJCCIPFUNC）のアドレス										//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//--------------------------------------------------------------------------------------------------------------//

//	制御命令判断（'else' を含まない 'if', 'while' or 'do' ）
#define		IS_CTRL_TKN(TKN)	(TKN == EAJCTK_RSV_IF		||	\
								 TKN == EAJCTK_RSV_FOR		||	\
								 TKN == EAJCTK_RSV_WHILE	||	\
								 TKN == EAJCTK_RSV_DO)

//	制御命令判断（'else' を含む 上記制御命令 or 'else'）
#define		IS_CTRL_ALL(TKN)	(IS_CTRL_TKN(TKN) || TKN == EAJCTK_RSV_ELSE)

//	文末文字( ';' or '}' ）判断
#define		IS_END_STMT(TKN)	(TKN == EAJCTK_DLM_RMPART || TKN == EAJCTK_DLM_SEMICOL)

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
static	BOOL	SubAnalSkipStmt(HAJCCIP pW, PCAJCCIPFUNC pFunc)
{
	PAJCCIPTKN	pSav;

	do {
		//----- エラーならば終了 -------------------------------------------------------------------------------//
		if (pW->ErrCod != AJCIP_ERR_OK) {
			break;
		}
		//----- if ---------------------------------------------------------------------------------------------//
		if (pW->pCur->tkn == EAJCTK_RSV_IF) {											//	'if' ？
			PAJCCIPTKN pIf = pW->pCur++;												//	'if' スキップ
			if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {									//	'(' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pIf->lno,
											  LNGSEL("'if' の直後に '(' が必要です。",
													 "Need '(' after 'if'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pSav = pW->pCur++;															//	'(' スキップ
			switch (pW->NumType) {														//	条件演算式評価
				case AJCIPT_INTEGER: CipFmlINT(pW, NULL, SYNTAX_ONLY); break;
				case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, SYNTAX_ONLY); break;
			}
			if (pW->ErrCod != AJCIP_ERR_OK) {											//	条件演算式エラー？
				//	演算式評価でエラー設定済の為、新たなエラーメッセージは不要
				break;
			}
			if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {									//	')' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
											  LNGSEL("'if' 文の条件が ')' で閉じられていません。",
													 "Condition in 'if' statement is not closed by ')'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pSav = pW->pCur++;															//	')' スキップ
			if (!SubAnalIsValidAfterCtrl(pW, pW->pCur)) {								//	'if (...)' の後は異常？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
											  LNGSEL("'if (条件)' の直後に誤りがあります。",
													 "Invalid token after 'if (cond)'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			SubAnalSkipStmt(pW, pFunc);									//	ステートメントスキップ
			while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;		//	連続する';' スキップ
			//----- else ---------------------------------------------------------------------------------------//
			if (pW->pCur->tkn == EAJCTK_RSV_ELSE) {										//	'else' ？
				PAJCCIPTKN pElse = (pSav = pW->pCur++);									//	'else' スキップ
				if (!SubAnalIsValidAfterCtrl(pW, pW->pCur)) {							//	'else' の後は異常？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
												  LNGSEL("'else' の直後に誤りがあります。",
														 "Invalid token after 'else'."));
					pW->fAnlRsu = FALSE;
					break;
				}
				pIf->u.pJmp = pW->pCur;													//	'if' のジャンプ先設定
				SubAnalSkipStmt(pW, pFunc);												//	ステートメントスキップ
				if (pW->ErrCod == AJCIP_ERR_OK) {										//	エラーなし？
					while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;				//	連続する';' スキップ
					pElse->u.pJmp = pW->pCur;											//	'else'のジャンプ先設定
				}
			}
			else {																		//	'else 以外？
				pIf->u.pJmp = pW->pCur;													//	'if' のジャンプ先設定
			}
		}
		//----- else -------------------------------------------------------------------------------------------//
		else if (pW->pCur->tkn == EAJCTK_RSV_ELSE) {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
										  LNGSEL("'else' に対応する 'if' がありません。",
												 "No 'if' statement."));
			pW->fAnlRsu = FALSE;
			break;
		}
		//----- while ------------------------------------------------------------------------------------------//
		else if (pW->pCur->tkn == EAJCTK_RSV_WHILE) {
			PAJCCIPTKN	pWhile = pW->pCur++;											//	'while' スキップ
			if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {									//	'(' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
											  LNGSEL("'while' の直後に '(' が必要です。",
													 "Need '(' after 'while'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pSav = pW->pCur++;															//	'(' スキップ
			switch (pW->NumType) {														//	条件演算式評価
				case AJCIPT_INTEGER: CipFmlINT(pW, NULL, SYNTAX_ONLY); break;
				case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, SYNTAX_ONLY); break;
			}
			if (pW->ErrCod != AJCIP_ERR_OK) {											//	条件演算式エラー？
				//	演算式評価でエラー設定済の為、新たなエラーメッセージは不要
				break;
			}
			if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {									//	')' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
											  LNGSEL("'while' 文の条件が ')' で閉じられていません。",
													 "Condition in 'while' statement is not closed by ')'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pSav = pW->pCur++;															//	')' スキップ
			if (!SubAnalIsValidAfterCtrl(pW, pW->pCur)) {								//	'while (...)' の後は異常？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
											  LNGSEL("'while (条件)' の直後に誤りがあります。",
													 "Invalid token after 'while (cond)'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			SubAnalSkipStmt(pW, pFunc);													//	ステートメントスキップ
			if (pW->ErrCod == AJCIP_ERR_OK) {											//	エラーなし
				//	'End of while' 情報設定
				if (pW->pAnlEndStmt->tkn == EAJCTK_DLM_SEMICOL || pW->pAnlEndStmt->tkn == EAJCTK_DLM_RMPART) { // ';' or '}' ？
					pW->pAnlEndStmt->flgCtrl = AJCIP_WHILE_END;							//	'while' の終端フラグ設定
					pW->pAnlEndStmt->u.pJmp  = pWhile;									//	'while' へのジャンプポインタ設定
					while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;				//	';' スキップ
					pWhile->flgCtrl = AJCIP_WHILE_FRONT;								//	'while' のタイプ（前置き）設定
					pWhile->u.pJmp	= pW->pCur;											//	'while' のExitポイント設定
					SubAnalRegistLoopInfo(pW, pWhile, pWhile->u.pJmp);					//	制御構造の先頭とExitポイント登録
				}
			}
		}
		//----- do ---------------------------------------------------------------------------------------------//
		else if (pW->pCur->tkn == EAJCTK_RSV_DO) {
			PAJCCIPTKN pDo = pW->pCur++;												//	'do' スキップ
			if (pW->pCur->tkn != EAJCTK_DLM_LMPART) {									//	'do' の直後は '{' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pDo->lno,
											  LNGSEL("'do' の直後に'{' が必要です。",
													 "Need '{' after 'do'."));
				pW->fAnlRsu = FALSE;
			}
			SubAnalSkipStmt(pW, pFunc);													//	ステートメントスキップ
			if (pW->ErrCod == AJCIP_ERR_OK) {											//	エラーなし？
				if (pW->pCur->tkn == EAJCTK_RSV_WHILE) {								//	'while' ？
					PAJCCIPTKN pDoWhile = pW->pCur++;									//	'while' スキップ
					if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {							//	'(' 以外？
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pDoWhile->lno,
												  LNGSEL("'while' の直後に '(' が必要です。",
														 "Need '(' after 'while'."));
						pW->fAnlRsu = FALSE;
						break;
					}
					pW->pCur++;															//	'(' スキップ
					switch (pW->NumType) {												//	条件演算式評価
						case AJCIPT_INTEGER: CipFmlINT(pW, NULL, SYNTAX_ONLY); break;
						case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, SYNTAX_ONLY); break;
					}
					if (pW->ErrCod == AJCIP_ERR_OK) {									//	条件演算式にエラーなし？
						if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {						//	')' 以外？
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
														  LNGSEL("'while' 文の条件が ')' で閉じられていません。",
																 "Condition in 'while' statement is not closed by ')'."));
							pW->fAnlRsu = FALSE;
							break;
						}
						pSav = pW->pCur++;												//	')' スキップ（ pSav = ')' ）
						if (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {						//	';' 以外？
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
														  LNGSEL("'while (条件)' の直後に ';' が必要です。",
																 "Need ';' after 'while (condition)'."));
							pW->fAnlRsu = FALSE;
							break;
						}
						while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;			//	連続する ';' スキップ
						pDoWhile->flgCtrl	= AJCIP_WHILE_TAIL;							//	後置き 'while' の旨、フラグ設定
						pDoWhile->u.pJmp	= pDo;										//	'while' のジャンプ先('do')設定
						pDo->u.pJmp			= pW->pCur;									//	'do' のExitポイント設定
						SubAnalRegistLoopInfo(pW, pDo, pDo->u.pJmp);					//	制御構造の先頭とExitポイント登録
					}
				}
				else {																	//	'while' なし
					while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;				//	連続する ';' スキップ
					pDo->u.pJmp = pW->pCur;												//	'do' のExitポイント設定
					SubAnalRegistLoopInfo(pW, pDo, pDo->u.pJmp);						//	制御構造の先頭とExitポイント登録
				}
			}
		}
		//----- for --------------------------------------------------------------------------------------------//
		else if (pW->pCur->tkn == EAJCTK_RSV_FOR) {
			PAJCCIPTKN	pInit, pCond, pUpd;		//	各部分の先頭ポインタ
			PAJCCIPTKN	pCondEnd, pUpdEnd;		//	各部分の終端ポインタ
			UI			nInit, nCond, nUpd;		//	各部分のトークン数
			UI			nest;					//	更新文のネスト
			AJCCIPTKN	SvForTkns[2];			//	'for (' 部分退避領域
			PAJCCIPTKN	pFor = pW->pCur++;		//	'for' スキップ

			//----- 'for' 直後の '(' チェック ------------------------------//
			if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {									//	'(' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pFor->lno,
											  LNGSEL("'for' の直後に '(' が必要です。",
													 "Need '(' after 'for'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pSav = pW->pCur++;															//	'(' スキップ
			//----- 初期化部分のアドレスとトークン数設定 -------------------//
			pInit = pW->pCur; nInit = 0;
			while (pW->pCur->tkn != EAJCTK_DLM_SEMICOL && pW->pCur->tkn != EAJCTK_EOF) {
				nInit++;
				pW->pCur++;
			}
			if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {
				nInit++;
				pW->pCur++;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
											  LNGSEL("'for' 文中の初期化文の直後に ';' が必要です。",
													 "Need ';' after initializer statements in 'for'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			//----- 条件部分のアドレスとトークン数設定 ---------------------//
			pCond = pW->pCur; nCond = 0;
			while (pW->pCur->tkn != EAJCTK_DLM_SEMICOL && pW->pCur->tkn != EAJCTK_EOF) {
				nCond++; pW->pCur++;
			}
			if (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {	//	条件の後が ';' 以外
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pFor->lno,
											  LNGSEL("'for' 文中の条件の直後に ';' が必要です。",
													 "Need ';' after condition in 'for'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			nCond++;				//	条件部分は末尾の ';' も含める
			pCondEnd = pW->pCur++;	//	';' スキップと、条件の末尾 ';' へのポインタ設定


			//----- 更新部分のアドレスとトークン数設定 ---------------------//
			pUpd = pW->pCur; nUpd = 0; nest = 0;
			while ((pW->pCur->tkn != EAJCTK_DLM_RSPART || nest != 0) && pW->pCur->tkn != EAJCTK_EOF) {
				if		(pW->pCur->tkn == EAJCTK_DLM_LSPART) nest++;
				else if (pW->pCur->tkn == EAJCTK_DLM_RSPART) nest--;
				nUpd++; pW->pCur++;
			}
			if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {	//	')' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pFor->lno,
											  LNGSEL("'for' 中の更新文の直後に ')' が必要です。",
													 "Need ')' after end of updating statements in 'for'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pUpdEnd = pW->pCur++;	//	')' スキップと、条件の末尾 ')' へのポインタ設定
			//----- 'for(' 部分 退避 ---------------------------------------//
			memcpy(SvForTkns, pFor, sizeof(AJCCIPTKN) * 2);
			//----- 'for (' と 'initializers' を入れ替える -----------------//
			memmove(pFor		, pInit    , sizeof(AJCCIPTKN) * nInit);
			memcpy (pFor + nInit, SvForTkns, sizeof(AJCCIPTKN) * 2);
			//----- 'for' と 'Initializers' のトークンポインタ再設定 -------//
			pSav  = pFor;
			pFor  = (pFor + nInit);
			pInit = pSav;
			//----- 条件末尾 ';' の属性とジャンプ先( ')' の次 )設定 --------//
			pCondEnd->flgCtrl = AJCIP_FOR_COND;
			pCondEnd->u.pJmp  = pW->pCur;
			//----- 右端の ')' の属性とジャンプ先（条件部分）設定 ----------//
			pUpdEnd->flgCtrl  = AJCIP_FOR_UPD;
			pUpdEnd->u.pJmp   = pFor;
			//----- 'for' のトークン情報へ'updaters'へのポインタ退避 -------//
			pFor->u.pJmp = pUpd;
			//----- 'Initializers' 部分のチェックと ',' -> ';' 変換 --------//
			pW->pCur = pInit;
			while (pW->ErrCod == AJCIP_ERR_OK && pW->pCur->tkn != EAJCTK_DLM_SEMICOL && pW->pCur->tkn != EAJCTK_EOF) {
				switch (pW->NumType) {							//	条件演算式評価
					case AJCIPT_INTEGER: CipFmlINT(pW, NULL, SYNTAX_ONLY); break;
					case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, SYNTAX_ONLY); break;
				}
				if (pW->ErrCod == AJCIP_ERR_OK) {				//	演算式は正常？
					if (pW->pCur->tkn != EAJCTK_DLM_COMMA && pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {	//	',' & ';' 以外
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
													  LNGSEL("'for' 中の初期化文の直後に ',' or ';' が必要です。",
															 "Need ',' or ';' after initializer statements in 'for'."));
						pW->fAnlRsu = FALSE;
						break;
					}
					if (pW->pCur->tkn == EAJCTK_DLM_COMMA) {	//	',' ？
						pW->pCur++;								//	',' スキップ
					}
				}
			}
			//----- 'Condition' 部分のチェック -----------------------------//
			pW->pCur = pCond;
			if (pW->ErrCod == AJCIP_ERR_OK) {
				if (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {		//	';' 以外
					switch (pW->NumType) {						//	条件演算式評価
						case AJCIPT_INTEGER: CipFmlINT(pW, NULL, SYNTAX_ONLY); break;
						case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, SYNTAX_ONLY); break;
					}
				}
				if (pW->ErrCod == AJCIP_ERR_OK) {				//	演算式は正常？
					if (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {	//	';' 以外？
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
													  LNGSEL("'for' 中の条件文の直後に ';' が必要です。",
															 "Need ';' after condition statement in 'for'."));
						pW->fAnlRsu = FALSE;
						break;
					}
				}
			}
			//----- 'Updaters' 部分のチェック ------------------------------//
			pW->pCur = pUpd;
			while (pW->ErrCod == AJCIP_ERR_OK && pW->pCur->tkn != EAJCTK_DLM_RSPART && pW->pCur->tkn != EAJCTK_EOF) {
				switch (pW->NumType) {												//	条件演算式評価
					case AJCIPT_INTEGER: CipFmlINT(pW, NULL, SYNTAX_ONLY); break;
					case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, SYNTAX_ONLY); break;
				}
				if (pW->ErrCod == AJCIP_ERR_OK) {				//	演算式は正常？
					if (pW->pCur->tkn != EAJCTK_DLM_COMMA && pW->pCur->tkn != EAJCTK_DLM_RSPART) {		//	',' & ')' 以外？
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
													  LNGSEL("'for' 中の更新文の直後に ',' or ')' が必要です。",
															 "Need ',' or ')' after updater statements in 'for'."));
						pW->fAnlRsu = FALSE;
						break;
					}
					if (pW->pCur->tkn == EAJCTK_DLM_COMMA) {	//	',' ？
						pW->pCur++;								//	',' スキップ
					}
				}
			}
			if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {		//	')' 以外？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
											  LNGSEL("'for' 中の更新文の終端に ')' が必要です。",
													 "Need ')' after end of updater statements in 'for'."));
				pW->fAnlRsu = FALSE;
				break;
			}
			pW->pCur++;																	//	')' スキップ
			SubAnalSkipStmt(pW, pFunc);													//	ステートメントスキップ
			if (pW->ErrCod == AJCIP_ERR_OK) {											//	エラーなし
				//	'End of for' 情報設定
				if (pW->pAnlEndStmt->tkn == EAJCTK_DLM_SEMICOL || pW->pAnlEndStmt->tkn == EAJCTK_DLM_RMPART) { // ';' or '}' ？
					pW->pAnlEndStmt->flgCtrl = AJCIP_FOR_END;							//	'for' の終端フラグ設定
					pW->pAnlEndStmt->u.pJmp = pFor->u.pJmp;								//	'for' (updaters)へのジャンプポインタ設定
					while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;				//	';' スキップ
					pFor->u.pJmp  = pW->pCur;											//	'for' のExitポイント設定
					SubAnalRegistLoopInfo(pW, pFor, pFor->u.pJmp);						//	制御構造の先頭とExitポイント登録
				}
			}
		}
		//--'{' ------------------------------------------------------------------------------------------------//
		else if (pW->pCur->tkn == EAJCTK_DLM_LMPART) {
			pSav = pW->pCur++;																//	'{' スキップ
			pW->AnlNest++;																	//	ネスト（カウンタ）加算
			while (pW->pCur->tkn != EAJCTK_DLM_RMPART && pW->pCur->tkn != EAJCTK_EOF &&		//	'}' までスキップループ
				   pW->ErrCod == AJCIP_ERR_OK) {
				PAJCCIPTKN pNxt = pW->pCur + 1;												//	pNxt = １つ先のトークン
				PAJCCIPTKN pNx2 = pW->pCur + 2;												//	pNx2 = ２つ先のトークン
				//	ラベル定義チェック
				if (pW->pCur->tkn == EAJCTK_USR_NAME && pNxt->tkn == EAJCTK_DLM_COLON) {	// 'SYMBOL:' ？
					if (pNx2->tkn == EAJCTK_DLM_SEMICOL) {									//	';' ？
						SubAnalRegistLabelInfo(pW, pW->pCur);								//	ラベル情報登録
						pW->pCur = pNx2;													//	'SYMBOL:' スキップ
					}
					else {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pNxt->lno,
													  LNGSEL("ラベル定義の末尾に ';' が必要です。",
															 "Need ';' at tail of label definition."));
						pW->fAnlRsu = FALSE;
					}

				}
				//	'define ・・' はスキップ（ ';' はスキップしない）
				else if (pW->pCur->tkn == EAJCTK_RSV_DEFINE) {
					while (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {
						pW->pCur++;
					}
				}
				//	不正トークンチェック
				else if (pW->pCur->tkn == EAJCTK_CIP_FUNCTION) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pNxt->lno,
												  LNGSEL("ファンクション中に 'function' は記述できません。",
														 "Illegal token 'function' is found in function."));
					pW->fAnlRsu = FALSE;
				}
				//	ステートメントスキップ
				if (IS_CTRL_ALL(pW->pCur->tkn)) SubAnalSkipStmt(pW, pFunc);
				else							pW->pCur++;
			}
			if (pW->ErrCod == AJCIP_ERR_OK) {												//	エラーなし？
				if (pW->pCur->tkn == EAJCTK_DLM_RMPART) {									//	'}' ？
					pW->pAnlEndStmt = pW->pCur++;											//	'}' スキップとStmt末尾('}')退避
					while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;					//	後続する';' スキップ
					pW->AnlNest--;															//	ネスト（カウンタ）減算
				}
				else {																		//	'}' 以外？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
												  LNGSEL("対応する '}' がありません。",
														 "Not closed by '}'."));
					pW->fAnlRsu = FALSE;
					break;
				}
			}
		}
		//----- その他（ＥＯＦ以外）---------------------------------------------------------------------------//
		else if (pW->pCur->tkn != EAJCTK_EOF) {
			//	文末( ';' / '}' )までスキップ
			while (!IS_END_STMT(pW->pCur->tkn) && pW->pCur->tkn != EAJCTK_EOF) {
				if (IS_CTRL_ALL(pW->pCur->tkn)) SubAnalSkipStmt(pW, pFunc);
				else							pW->pCur++;
			}
			pW->pAnlEndStmt = pW->pCur;
		}
	} while (0);

	return (pW->ErrCod == AJCIP_ERR_OK);
}

//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（制御命令「'if ()', 'while (), 'do' ... 」の直後のトークンが有効かのチェック	）			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pTkn		- 直後のトークン																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubAnalIsValidAfterCtrl(HAJCCIP pW, PAJCCIPTKN pTkn)
{
	BOOL	rc = TRUE;

	if (!IS_CTRL_TKN(pTkn->tkn) 		&& 		//	制御命令以外
		pTkn->tkn != EAJCTK_DLM_LMPART	&&		//	'{'		以外
		pTkn->tkn != EAJCTK_DLM_SEMICOL	&&		//	';' 	以外
		pTkn->tkn != EAJCTK_RSV_DEFINE	&&		//	'define'以外
		pTkn->tkn != EAJCTK_RSV_BREAK	&&		//	'break' 以外
		pTkn->tkn != EAJCTK_RSV_GOTO	&&		//	'goto'	以外
		pTkn->tkn != EAJCTK_RSV_RETURN) {		//	'return'以外
		//	式の評価チェック
		pW->pCur = pTkn;
		if (pW->NumType == AJCIPT_INTEGER) rc = CipFmlINT(pW, NULL, SYNTAX_ONLY);
		else							   rc = CipFmlDBL(pW, NULL, SYNTAX_ONLY);
		pW->pCur = pTkn;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（ラベル・ポイントの登録）																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pSymTkn		- ラベル名トークン																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubAnalRegistLabelInfo	(HAJCCIP pW, PAJCCIPTKN pSymTkn)
{
	BOOL		rc = TRUE;
	AJCCIPLABEL	Node;

	Node.pName = pSymTkn->u.pStr;	//	ラベル名
	Node.pJmp  = pSymTkn + 3;		//	'Label:;' の次ポイント
	if (!AjcAvlInsNode(pW->hAnlAvlLabel, (UX)Node.pName, &Node, sizeof Node)) {		//	ノード登録，失敗？
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSymTkn->lno,
									  LNGSEL("ラベル <%s> は既に定義されています。",
											 "Multiple defined <%s>."), Node.pName);
		rc = pW->fAnlRsu = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（ループ構造体の登録）																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pTop		- ループ構造体先頭ポイント															//
//				pExit		- ループ構造体Exitポイント															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubAnalRegistLoopInfo(HAJCCIP pW, PAJCCIPTKN pTop, PAJCCIPTKN pExit)
{
	BOOL		rc = TRUE;
	AJCCIPEXIT	Node;

	Node.nest  = pW->AnlNest;
	Node.pTop  = pTop;
	Node.pExit = pExit;
	if (!AjcFQueEnque(pW->hAnlFQExit, &Node)) {		//	ノード登録，失敗？
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pExit->lno,
									  LNGSEL("ループ構造 脱出ポイント情報の登録を失敗しました。",
											 "Control structure exit point registration failure."));
		rc = pW->fAnlRsu = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（ 'break', 'goto' のジャンプ先設定）														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pBreak		- 'break' トークンノード															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubAnalSetGotoAndBreakJmpAddr(HAJCCIP pW, PCAJCCIPFUNC pFunc)
{
	BOOL		rc = TRUE;
	PAJCCIPTKN	pTkn = pFunc->pEntry;
	PAJCCIPTKN	pSav;

	while (pTkn->tkn != EAJCTK_EOF && pTkn->flgCtrl != AJCIP_FUNC_END) {
		if (pTkn->tkn == EAJCTK_RSV_BREAK) {										//	● break
			PAJCCIPTKN		pBreak = pTkn++;										//	'break' スキップ
			if (pTkn->tkn == EAJCTK_DLM_SEMICOL) {									//	'break' の直後は ';'？
				SubAnalSetBreak(pW, pBreak);										//	'break' のジャンプ先設定
			}
			else {																	//	'break' の直後に ';' なし？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pBreak->lno,
											  LNGSEL("'break' の直後に ';' が必要です。",
													 "Need '(' after 'while'."));
				rc = pW->fAnlRsu = FALSE;
			}
		}
		else if (pTkn->tkn == EAJCTK_RSV_GOTO) {									//	● goto
			PAJCCIPTKN		pGoto = pTkn++;											//	'goto' スキップ
			if (pTkn->tkn == EAJCTK_USR_NAME) {										//	'goto' の直後はラベル？
				BCP		pName = pTkn->u.pStr;										//	ラベル名設定
				pSav = pTkn++;														//	ラベルスキップ
				if (pTkn->tkn == EAJCTK_DLM_SEMICOL) {								//	'goto label' の直後は ';'？
					SubAnalSetGoto(pW, pGoto, pName);								//	'goto' のジャンプ先設定
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSav->lno,
												  LNGSEL("'goto LABEL' の直後に ';' が必要です。",
														 "Need ';' after 'goto LABEL'."));
					rc = pW->fAnlRsu = FALSE;
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pGoto->lno,
											  LNGSEL("'goto' の直後にラベル名が必要です。",
													 "Need 'LabelName' after 'goto'."));
				rc = pW->fAnlRsu = FALSE;
			}
		}
		pTkn++;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（'break' のジャンプ先設定）																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pBreak		- 'break' トークンノード															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubAnalSetBreak(HAJCCIP pW, PAJCCIPTKN pBreak)
{
	BOOL			rc = TRUE;
	PCAJCCIPEXIT	pNode = NULL;
	PCAJCCIPTKN		pMin  = (PCAJCCIPTKN)((UX)-1);
	BOOL			fFind = FALSE;

	if (pNode = AjcFQueTopNode(pW->hAnlFQExit)) {
		do {
			if ((UX)pBreak > (UX)pNode->pTop && (UX)pBreak < (UX)pNode->pExit && (UX)pNode->pExit < (UX)pMin) {
				pBreak->u.pJmp = pNode->pExit;
				pMin		   = pNode->pExit;
				fFind		   = TRUE;
			}
		} while(pNode = AjcFQueNextNode(pW->hAnlFQExit, pNode));
	}
	//----- ジャンプ先が見つからない場合はエラー ----------------//
	if (!fFind) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pBreak->lno,
									  LNGSEL("'break' は制御構造外です。",
											 "'break' is out of control structure."));
		rc = pW->fAnlRsu = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	関数の制御構造解析（'goto' のジャンプ先設定）																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pGoto		- 'goto' トークンノード																//
//				pLabelName	- ラベル名文字列																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HAJCCIP		pW;
	PAJCCIPTKN	pGoto;
	BCP			pLabelName;
	BOOL		fFind;
} PRM_SET_GOTO, *PPRM_SET_GOTO;
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbAnalSetGoto(UX key, C_VOP pNodeData, UI len, UI height, UX cbp)
{
	BOOL			rc	  = TRUE;
	PAJCCIPLABEL	pNode = (PAJCCIPLABEL)pNodeData;
	PPRM_SET_GOTO	prm   = (PPRM_SET_GOTO)cbp;

	if (mbscmp(pNode->pName, prm->pLabelName) == 0) {
		prm->pGoto->u.pJmp = pNode->pJmp;
		prm->fFind 		   = TRUE;
		rc 				   = FALSE;	// 通知中止
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubAnalSetGoto(HAJCCIP pW, PAJCCIPTKN pGoto, BCP pLabelName)
{
	BOOL			rc = TRUE;
	PAJCCIPLABEL	pNode = NULL;
	BOOL			fFind = FALSE;
	PRM_SET_GOTO	PrmSetGoto;

	PrmSetGoto.pW		  = pW;
	PrmSetGoto.pGoto	  = pGoto;
	PrmSetGoto.pLabelName = pLabelName;
	PrmSetGoto.fFind	  = FALSE;

	AjcAvlEnumNodesEx(pW->hAnlAvlLabel, (UX)&PrmSetGoto, cbAnalSetGoto, FALSE);

	//----- ジャンプ先が見つからない場合はエラー ----------------//
	if (!PrmSetGoto.fFind) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pGoto->lno,
									  LNGSEL("'goto' のジャンプ先ラベル <%s> が見つかりません。",
											 "'Label <%s> not ound in 'goto'."), pLabelName);
		rc = pW->fAnlRsu = FALSE;
	}
	return rc;
}

//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■																											■
//■	２．実行																								■
//■																											■
//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//--------------------------------------------------------------------------------------------------------------//
//	関数の実行開始																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pCall		- 関数呼び出し情報																	//
//				pTknCall	- 関数呼び出しの先頭トークン（不要時はNULL)											//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipExeFuncCall(HAJCCIP pW, PAJCCIPCALL pCall, PAJCCIPTKN pTknCall)
{
	BOOL		rc		= FALSE;
	UI			lno		= pTknCall == NULL ? pCall->lno : pTknCall->lno;
	UI			i;
	PAJCCIPFUNC	pFunc	= NULL;
	PAJCCIPARG	pFuncArg;
	PAJCCIPAGV	pCallArg;
	HAJCVMGA	hVmgOld	= pW->sFni[pW->ixFni].hVmg;
	HAJCVMGA	hVmgNew = NULL;
	PFUNCENTRY	pFuncEntry = NULL;

	//----- コード内関数処理 -------------------------------------------------------------------------------//
	if ((pFunc = (PAJCCIPFUNC)AjcAvlGetNodePtr(pW->hAvlFun, (UX)pCall->pFunName, NULL)) != NULL) {
		do {
			//----- 関数用の変数管理インスタンス生成 -----------------------//
			if (pW->ixFni < AJCCIPMAX_IXVMG) {
				if ((hVmgNew = AjcVmgCreateA()) == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, lno,
												  LNGSEL("変数管理用のワークを確保できません。",
														 "Variable management work allocation failure."));
					break;
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, lno,
											  LNGSEL("関数呼び出しのネストが深すぎます。",
													 "Nest of function call too deep."));
				break;
			}

			//----- 引数の個数チェック -------------------------------------//
			if (pFunc->nArg != pCall->nArg) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, lno,
											  LNGSEL("引数の個数が異なります。",
													 "Not equal Number of argument."));
				break;
			}
			//----- 引数のタイプチェック -----------------------------------//
			pFuncArg = AjcFQueTopNode(pFunc->hQueArg);
			pCallArg = AjcFQueTopNode(pCall->hQueAgv);
			i = 0;
			if (pFuncArg != NULL && pCallArg != NULL) {
				do {
					if ((pFuncArg->typ == AJCIPT_STRING && pCallArg->typ != AJCIPT_STRING) ||
						(pFuncArg->typ != AJCIPT_STRING && pCallArg->typ == AJCIPT_STRING) ||
						 pFuncArg->fArr != pCallArg->fArr) {
						break;
					}
					i++;
					pFuncArg = (PAJCCIPARG)AjcFQueNextNode(pFunc->hQueArg, pFuncArg);
					pCallArg = (PAJCCIPAGV)AjcFQueNextNode(pCall->hQueAgv, pCallArg);
				} while (i < pFunc->nArg && pFuncArg != NULL && pCallArg != NULL);
			}
			if (i != pFunc->nArg) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, lno,
											  LNGSEL("%d 番目の引数タイプが異なります。",
													 "It's different in the %dth type."), i + 1);
				break;
			}
			//----- 引数設定 -----------------------------------------------//
			pFuncArg = (PAJCCIPARG)AjcFQueTopNode(pFunc->hQueArg);
			pCallArg = (PAJCCIPAGV)AjcFQueTopNode(pCall->hQueAgv);
			i = 0;
			if (pFuncArg != NULL && pCallArg != NULL) {
				do {
					if (pFuncArg->fArr) {
						//	配列コピー
						if (!CipVmgCopy(pW, lno, hVmgNew, pFuncArg->pSym, pCallArg->val.arr.hVmg, pCallArg->val.arr.pName)) {
							break;
						}
					}
					else {
						//	変数値コピー
						if (CipVmgGenVar(pW, lno, hVmgNew, pFuncArg->pSym, (AJCVMGTYPE)pFuncArg->typ, 0)) {
							switch (pCallArg->typ) {
								case AJCIPT_INTEGER:	AjcVmgSetIntegerA(hVmgNew, pFuncArg->pSym, 0, pCallArg->val.sll);	break;
								case AJCIPT_REAL:		AjcVmgSetRealA	 (hVmgNew, pFuncArg->pSym, 0, pCallArg->val.dbl);	break;
								case AJCIPT_STRING:		AjcVmgSetStringA (hVmgNew, pFuncArg->pSym, 0, pCallArg->val.pStr);	break;
							}
						}
						else break;
					}
					pFuncArg = (PAJCCIPARG)AjcFQueNextNode(pFunc->hQueArg, pFuncArg);
					pCallArg = (PAJCCIPAGV)AjcFQueNextNode(pCall->hQueAgv, pCallArg);
				} while (i < pFunc->nArg && pFuncArg != NULL && pCallArg != NULL);
				//	エラーならば、Exit
				if (pW->ErrCod != AJCIP_ERR_OK) {
					break;
				}
			}
		} while(0);
		//----- 正常ならば、コード実行 --------------------------------//
		if (pW->ErrCod == AJCIP_ERR_OK) {
			//	次の関数ネスト値設定
			UI	ixNxt = pW->ixFni + 1;
			//	変数管理インスタンス設定
			pW->sFni[ixNxt].hVmg = hVmgNew;
			//	関数呼び出し情報設定
			memcpy(&pW->sFni[ixNxt].CInf, pCall, sizeof(AJCCIPCALL));
			//	ジャンプ先アドレス（関数エントリポイント）設定
			CipGsrSetJumpAddr(pW, pFunc->pEntry);
			//	関数コード実行
			rc = SubExeFuncCode(pW, pW->ixFni++);
		}
		//----- エラーならば、リソース解放 ---------------------------//
		else {
			//	変数管理情報解放
			if (hVmgNew != NULL) {
				AjcVmgDeleteA(hVmgNew);
				hVmgNew = NULL;
			}
			//	引数値情報解放
			if (pCall->hQueAgv != NULL) {
				AjcFQueDelete(pCall->hQueAgv);
				pCall->hQueAgv = NULL;
			}
		}
	}
	//----- 外部関数処理 -----------------------------------------------------------------------------------//
	else {
		//	内蔵関数
		if (pFuncEntry = AjcAvlGetNodePtr(hAvlFuncs, (UX)pCall->pFunName, NULL)) {
			rc = pFuncEntry->func(pW, pCall);
		}
		//	ユーザ関数
		else {
			UI			argc = pCall->nArg;
			if (pW->ppNtcAgv != NULL) free(pW->ppNtcAgv);
			if ((pW->ppNtcAgv = MakeArgInfo(pW, pCall)) != NULL) {
				pW->NtcEvpFun.argc	= argc;
				pW->NtcEvpFun.argv	= pW->ppNtcAgv;
				pW->NtcEvpFun.pCall = pCall;
				SendMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_FUN),
													 fCmdWithHdl ? (LPARAM)pW->hWndBack : (LPARAM)&pW->NtcEvpFun);
			}
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	関数コード実行																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				ixSrt		- 関数のネストレベル																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubExeFuncCode(HAJCCIP pW, UI ixNest)
{
	BOOL	rc = TRUE;

	//	実行
	while (!pW->fRunStop					&&		//	実行中止以外				＆
			rc == TRUE						&&		//	インストラクション実行ＯＫ	＆
			pW->ixFni > ixNest				&&		//	実行開始時の関数ネスト以上	＆
			pW->pCur->tkn != EAJCTK_EOF) {			//	ＥＯＦ以外
		//----- イベント実行 -------------------------------------------------------------------//
		if (!pW->fExeEventBusy) {									//	イベント未実行？
			pW->fExeEventBusy = TRUE;								//		イベント実行中フラグ設定
			if (!pW->fExeStdEvtBusy && pW->nExeDisStdEvt == 0) {	//			標準イベント非実行中＆許可状態？
				pW->fExeStdEvtBusy = TRUE;							//				標準イベント実行中フラグ設定
				SubExeStdEvt(pW);									//				標準イベント実行
				pW->fExeStdEvtBusy = FALSE;							//				標準イベント実行中フラグ解除
			}
			if (!pW->fExeComEvtBusy && pW->nExeDisComEvt == 0) {	//			ＣＯＭイベント非実行中＆許可状態？
				pW->fExeComEvtBusy = TRUE;							//				ＣＯＭイベント実行中フラグ設定
				SubExeComEvt(pW);									//				ＣＯＭイベント実行
				pW->fExeComEvtBusy = FALSE;							//				ＣＯＭイベント実行中フラグ解除
			}
			pW->fExeEventBusy = FALSE;								//		イベント実行中フラグ解除
		}
		//----- 処理中断チェック （いずれか１つの条件のみ有効とする）---------------------------//
		do {
			//----- ステップカウントによる処理停止 ---------------------------------------------//
			if (pW->nStepCount != 0) {					//	ステップ実行中
				pW->nStepCount--;						//		ステップカウント減算
				if (pW->nStepCount == 0) {				//		ステップ実行満了？
					if (pW->hStepBack != NULL) {		//			ステップトレースウインド オープン中？
						pW->fExePause = FALSE;			//				Pause()による処理停止はキャンセル
						CipStepNtcExec(pW, TRUE);		//				強制停止
						break;
					}
				}
			}
			//----- Pause()による処理停止 ------------------------------------------------------//
			if (pW->fExePause) {						//	Pause()が実行された
				pW->fExePause = FALSE;					//		Pause()実行フラグ解除
				if (pW->hStepBack != NULL) {			//		ステップトレースウインド オープン中？
					CipStepNtcExec(pW, TRUE);			//			強制停止
					break;
				}
				else {									//		ステップトレースウインド クローズ中？
					ShowPauseDialog(pW);				//			PAUSEダイアログ表示
				}
			}
			//----- 行番号によるブレークチェック -----------------------------------------------//
			if (pW->hStepBack != NULL) {				//		ステップトレースウインド オープン中？
				CipStepNtcExec(pW, FALSE);				//			実行通知
			}
		} while(0);
		//----- 実行中断外／イベント実行中ならば命令実行 ---------------------------------------//
		if (!pW->fExeStop || pW->fExeEventBusy) {
			//	ダイナミックステップ番号更新
			pW->ExeStepNo++;
			//	ダイナミックステップ番号表示（ステップトレース）
			CipStepDynNo(pW);
			//	ステップトレース情報リセット
			pW->SvStepLno = -1;
			pW->SvStepTkn = EAJCTK_INVALID;
			//	インストラクション実行
			switch (pW->pCur->tkn) {
				case EAJCTK_RSV_DEFINE:		rc = SubExeDefine	(pW);	break;		//	・define
				case EAJCTK_RSV_IF:			rc = SubExeIf		(pW);	break;		//	・if
				case EAJCTK_RSV_ELSE:		rc = SubExeElse		(pW);	break;		//	・else
				case EAJCTK_RSV_DO:			rc = SubExeDo		(pW);	break;		//	・do
				case EAJCTK_RSV_WHILE:		rc = SubExeWhile	(pW);	break;		//	・while
				case EAJCTK_RSV_FOR:		rc = SubExeFor		(pW);	break;		//	・for
				case EAJCTK_RSV_BREAK:		rc = SubExeBreak	(pW);	break;		//	・break
				case EAJCTK_RSV_RETURN:		rc = SubExeReturn	(pW);	break;		//	・return
				case EAJCTK_RSV_GOTO:		rc = SubExeGoto		(pW);	break;		//	・goto
				case EAJCTK_DLM_LMPART:		rc = SubExeLmPart	(pW);	break;		//	・'{'
				case EAJCTK_DLM_RMPART:		rc = SubExeRmPart	(pW);	break;		//	・'}'
				case EAJCTK_DLM_SEMICOL:	rc = SubExeSemiCol	(pW);	break;		//	・';'
				case EAJCTK_DLM_COMMA:		rc = SubExeComma	(pW);	break;		//	・','
				case EAJCTK_DLM_RSPART:		rc = SubExeRsPart	(pW);	break;		//	・')'
				default:
					do {
						if (SubExeSkipLabel(pW)) break;		//	ラベル ( 'Sym:;' ) スキップ
						if (SubExeCopyArray(pW)) break;		//	配列コピー	（Sym[] = ・・	/ $Sym[] = ・・	）
						if (SubExeFormula  (pW)) break;		//	数値変数設定（数式の評価）
					} while (0);
					rc = (pW->ErrCod == AJCIP_ERR_OK);		//	戻り値設定
					break;
			}
			//	ステップトレース・トークン表示
			CipStepShowToken(pW, pW->pCur);
			//	ステップトレース・追跡変数表示
			CipStepShowVariable(pW);
			//	ユーザコールバック（実行通知）
			if (!pW->fRunStop) {							//	ユーザコールバック
				CipGsrNtcExe(pW, pW->pCur);					//	・
			}
		}
		//----- 実行中断＆非イベント実行（メインコード実行中）ならば、何もしない ---------------//
		else {
			CipGsrDoEvent(pW);
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ラベル ( 'Sym:;' ) スキップ																					//
//																												//
//	戻り値	：	TRUE  - ラベルをスキップした（成功／失敗は「pW->ErrCod」に設定）								//
//				FALSE - ラベル以外																				//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 戻り値＝TRUE時  - 構文の直後のトークン												//
//								   FALSE時 - 変化なし															//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubExeSkipLabel(HAJCCIP pW)
{
	BOOL		rc = FALSE;
	PAJCCIPTKN	pCur = pW->pCur;
	PAJCCIPTKN	pNx1 = pW->pCur + 1;
	PAJCCIPTKN	pNx2 = pW->pCur + 2;

	if (pW->pCur->tkn == EAJCTK_USR_NAME && pNx1->tkn == EAJCTK_DLM_COLON && pNx2->tkn == EAJCTK_DLM_SEMICOL) {
		pW->pCur = pNx2 + 1;
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	配列のコピー（ Sym[] = Sym[]  / $Sym[] = $Sym[] ）															//
//																												//
//	戻り値	：	TRUE  - 配列のコピー（成功／失敗は「pW->ErrCod」に設定）										//
//				FALSE - 配列のコピー以外																		//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 戻り値＝TRUE時  - 構文の直後のトークン												//
//								   FALSE時 - 変化なし															//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubExeCopyArray(HAJCCIP pW)
{
	BOOL		rc	 = FALSE;
	PAJCCIPTKN	pCur = pW->pCur;
	PAJCCIPTKN	pNx1 = pW->pCur + 1;
	PAJCCIPTKN	pNx2 = pW->pCur + 2;
	PAJCCIPTKN	pNx3 = pW->pCur + 3;

	if (pCur->tkn == EAJCTK_USR_NAME		&&		//	'Symbol'
		pNx1->tkn == EAJCTK_DLM_LLPART		&&		//	'['
		pNx2->tkn == EAJCTK_DLM_RLPART		&&		//	']'
		pNx3->tkn == EAJCTK_DLM_EQ) {				//	'='

		PAJCCIPTKN	pNx4 = pW->pCur + 4;
		PAJCCIPTKN	pNx5 = pW->pCur + 5;
		PAJCCIPTKN	pNx6 = pW->pCur + 6;
		PAJCCIPTKN	pNx7 = pW->pCur + 7;

		//	配列変数のコピー( Symbol[] = Symbol[]; )
		if (pNx4->tkn == EAJCTK_USR_NAME   &&		//	'Symbol'
			pNx5->tkn == EAJCTK_DLM_LLPART &&		//	'['
			pNx6->tkn == EAJCTK_DLM_RLPART) {		//	']'

			if (pNx7->tkn == EAJCTK_DLM_SEMICOL) {
				if ((*pCur->u.pStr != '$' && *pNx4->u.pStr != '$') ||		//	Sym[]  = Sym[];
					(*pCur->u.pStr == '$' && *pNx4->u.pStr == '$')) {		//	$sym[] = $Sym[];
					HAJCVMGA hVmgD = SubExeGetVarInst(pW, pCur);
					HAJCVMGA hVmgS = SubExeGetVarInst(pW, pNx4);
					if (hVmgD != NULL && hVmgS != NULL) {
						if (rc = CipVmgCopy(pW, pNx6->lno, hVmgD, pCur->u.pStr, hVmgS, pNx4->u.pStr)) {
							pW->pCur = pNx7 + 1;
						}
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pNx6->lno,
												  LNGSEL("変数 <%s> と <%s> のタイプが異なります。",
														 "Diffrent in variable <%s> and <%s>."), pCur->u.pStr, pNx4->u.pStr);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pNx6->lno,
											  LNGSEL("'%s[] = %s[]' の直後に ';' が必要です。",
													 "Need ';' after '%s[] = %s[]'."), pCur->u.pStr, pNx4->u.pStr);
			}
		}
		//	配列を返す関数の実行( Symbol[] = Func(・・・);	)
		else if (pNx4->tkn == EAJCTK_USR_NAME && pNx5->tkn == EAJCTK_DLM_LSPART) {	//	'Symbol('
			if ((*pCur->u.pStr != '$' && *pNx4->u.pStr != '$') ||					//	Sym[]  = Sym(・・・);
				(*pCur->u.pStr == '$' && *pNx4->u.pStr == '$')) {					//	$sym[] = $Sym(・・・);
				AJCCIPVARINFO	Vi;
				Vi.hVmg = SubExeGetVarInst(pW, pCur);
				Vi.pSym = pCur->u.pStr;
				Vi.ix	= 0;
				pW->pCur = pNx4;
				if (rc = CipFmlCallFunc(pW, &Vi, CALCULATION)) {					//	関数実行，成功？
					if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {						//	';' ？
						pW->pCur++;													//	';' スキップ
					}
					else {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pNx6->lno,
													  LNGSEL("'%s[] = %s(・・)' の直後に ';' が必要です。",
															 "Need ';' after '%s[] = %s( .. )'."), pCur->u.pStr, pNx4->u.pStr);
					}
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pNx6->lno,
											  LNGSEL("変数<%s>と関数<%s>のタイプが異なります。",
													 "Diffrent type in variable<%s> and function<%s>."), pCur->u.pStr, pNx4->u.pStr);
			}
		}
		rc = TRUE;	//	TRUE : 配列転送を処理した（成功／失敗は「pW->ErrCod」に設定）
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	数値変数値の設定（ 数式評価  ）																				//
//																												//
//	戻り値	：	TRUE  - 配列のコピー（成功／失敗は「pW->ErrCod」に設定）										//
//				FALSE - 配列のコピー以外																		//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 戻り値＝TRUE時  - 構文の直後のトークン												//
//								   FALSE時 - 変化なし															//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeFormula(HAJCCIP pW)
{
	//	数式演算
	switch (pW->NumType) {
		case AJCIPT_INTEGER: CipFmlINT(pW, NULL, CALCULATION); break;
		case AJCIPT_REAL:	 CipFmlDBL(pW, NULL, CALCULATION); break;
	}
	//	末尾( ';', ',' or ')' )チェック
	if (pW->ErrCod == AJCIP_ERR_OK) {
		do {
			//	'for' 中の更新文群直後の ')' は除く！
			if (pW->pCur->tkn == EAJCTK_DLM_RSPART && pW->pCur->flgCtrl == AJCIP_FOR_UPD) break;
			//	'前置き 'while' / 'for' ブロック終端 の ';' は除く
			if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL && (pW->pCur->flgCtrl == AJCIP_WHILE_END ||
														pW->pCur->flgCtrl == AJCIP_FOR_END	)) break;

			if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {						//	';' ？
				while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;		//	';' 群スキップ
			}
			else if (pW->pCur->tkn == EAJCTK_DLM_COMMA) {					//	',' ？
				pW->pCur++;													//	',' スキップ
			}
			else {															//	その他
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
											  LNGSEL("'%s' の直前に ';' が必要です。",
													 "Need ';' before '%s'."), CipGsrTknStr(pW->pCur));
			}
		} while (0);
	}
	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------//
//	標準イベント実行																							//
//																												//
//	戻り値	：	なし																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeStdEvt(HAJCCIP pW)
{
	BOOL			rc = TRUE;
	PAJCCIPCALL		pCall;
	UI				i;

	if (pW->hFQueStdEvt != NULL && !pW->fRunStop) {		//	イベントキュー有効＆マクロ実行中？
		//	Windowsイベント実行
		CipGsrDoEvent(pW);
		//	保留イベントの実行
		while (AjcFQueDeque(pW->hFQueStdEvt, (VOP)&pCall) != 0) {
			//	戻り情報設定し直し
			pCall->pReturn = pW->pCur;
			//	関数呼び出し
			CipExeFuncCall(pW, pCall, NULL);
			//	呼び出し情報破棄
			AjcCipCallInfoDelete(pW->hWndBack, pCall);
			//	Windowsイベント実行
			CipGsrDoEvent(pW);
		}
		//	右クリックイベントの実行
		if (pW->fExeRClick) {															//	右クリック発生？
			if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnRClick")) {				//		呼び出し情報生成
				pCall->pReturn = pW->pCur;												//			戻りアドレス
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, pW->ptExeRClick.x);		//			第１引数（Ｘ位置）
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, pW->ptExeRClick.y);		//			第２引数（Ｙ位置）
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, pW->fExeRClkShift);		//			第３引数（SHIFT）
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, pW->fExeRClkCtrl );		//			第４引数（CTRL）
				CipExeFuncCall(pW, pCall, NULL);										//			実行
				AjcCipCallInfoDelete(pW->hWndBack, pCall);								//			呼び出し情報破棄
			}
			pW->fExeRClick = FALSE;														//		右クリック発生フラグクリアー
		}
		//	ダブルクリックイベントの実行
		if (pW->fExeDblClk && pW->pExeDblClkLine != NULL) {								//	ダブルクリック発生？
			if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnDblClk")) {				//		呼び出し情報生成
				pCall->pReturn = pW->pCur;												//			戻りアドレス
				AjcCipCallInfoInsString(pW->hWndBack, pCall, pW->pExeDblClkLine);		//			第１引数（行テキスト）
				CipExeFuncCall(pW, pCall, NULL);										//			実行
				AjcCipCallInfoDelete(pW->hWndBack, pCall);								//			呼び出し情報破棄
			}
			free(pW->pExeDblClkLine);													//		行テキスト解放
			pW->pExeDblClkLine = NULL;													//		・
			pW->fExeDblClk	   = FALSE;													//		ダブルクリック発生フラグクリアー
		}
		//	タイマイベントの実行
		for (i = 1; i < 32; i++) {
			if (pW->fExeTimer[i]) {														//	タイマイベント発生？
				if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnTimer")) {				//		呼び出し情報生成
					pCall->pReturn = pW->pCur;											//			戻りアドレス
					AjcCipCallInfoInsInteger(pW->hWndBack, pCall, i);					//			第１引数（タイマＩＤ）
					CipExeFuncCall(pW, pCall, NULL);									//			実行
					AjcCipCallInfoDelete(pW->hWndBack, pCall);							//			呼び出し情報破棄
				}
				pW->fExeTimer[i] = FALSE;												//		タイマイベント発生フラグクリアー
			}
		}
	}
	else rc = FALSE;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＳＣＰイベント実行																							//
//																												//
//	戻り値	：	なし																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeComEvt(HAJCCIP pW)
{
	BOOL			rc = TRUE;
	AJCCIPSCPEVT	ScpEvt;
	PAJCCIPCALL		pCall;
	UI				port, len;

	if (pW->hFQueScpEvt != NULL && !pW->fRunStop) {		//	イベントキュー有効＆マクロ実行中？
		//	Windowsイベント実行
		CipGsrDoEvent(pW);
		while (AjcFQueDeque(pW->hFQueScpEvt, &ScpEvt) != 0) {
			CipGsrDoEvent(pW);
			port = ScpEvt.port;
			len  = ScpEvt.len;
			if (ScpEvt.evt & AJCSCP_EV_RXTEXT) {												//	●テキスト受信通知
				if (pCall = AjcCipCallInfoInit(pW->hWndBack, pW->ExeScp[port].pOnRecvText)) {	//	呼び出し情報生成
					pCall->pReturn = pW->pCur;													//		戻りアドレス
					AjcCipCallInfoInsString   (pW->hWndBack, pCall, (BCP)ScpEvt.pDat);			//		第１引数（受信テキスト）
					CipExeFuncCall(pW, pCall, NULL);											//		実行
					AjcCipCallInfoDelete(pW->hWndBack, pCall);									//		呼び出し情報破棄
				}
			}
			else if (ScpEvt.evt & AJCSCP_EV_RXCTRL) {											//	●制御コード受信通知
				if (pCall = AjcCipCallInfoInit(pW->hWndBack, pW->ExeScp[port].pOnRecvCtrl)) {	//	呼び出し情報生成
					pCall->pReturn = pW->pCur;													//		戻りアドレス
					AjcCipCallInfoInsInteger  (pW->hWndBack, pCall, *ScpEvt.pDat);				//		第１引数（制御コード値）
					CipExeFuncCall(pW, pCall, NULL);											//		実行
					AjcCipCallInfoDelete(pW->hWndBack, pCall);									//		呼び出し情報破棄
				}
			}
			else if (ScpEvt.evt & AJCSCP_EV_RXESC) {											//	●ＥＳＣコード受信通知
				if (pCall = AjcCipCallInfoInit(pW->hWndBack, pW->ExeScp[port].pOnRecvEsc)) {	//	呼び出し情報生成
					pCall->pReturn = pW->pCur;													//		戻りアドレス
					AjcCipCallInfoInsString   (pW->hWndBack, pCall, (BCP)ScpEvt.pDat);			//		第１引数（受信ＥＳＣシーケンス）
					CipExeFuncCall(pW, pCall, NULL);											//		実行
					AjcCipCallInfoDelete(pW->hWndBack, pCall);									//		呼び出し情報破棄
				}
			}
			else if (ScpEvt.evt & AJCSCP_EV_RXPKT) {											//	●パケットデータ受信通知
				do {
					//	呼び出し情報設定
					if (pCall = AjcCipCallInfoInit(pW->hWndBack, pW->ExeScp[port].pOnRecvPacket)) {
						UI		bno = pW->ExeScp[port].MemBlkNo;
						//	戻りアドレス
						pCall->pReturn = pW->pCur;
						//	メモリブロック＃チェック
						if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
													  LNGSEL("%s - 不正なメモリブロック番号です。",
															 "%s - Illegal memory block number."), pCall->pFunName);
							rc = FALSE;
							break;
						}
						//	メモリブロック割り当て済チェック
						if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
													  LNGSEL("%s - メモリブロックは割り当てられていません。",
															 "%s - Not allocated memory block."), pCall->pFunName);
							rc = FALSE;
							break;
						}
						//	メモリブロック超過チェック
						if (pW->ExeMemBlk[bno].MemLen < len) {
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
													  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
															 "%s - Over the memry block."), pCall->pFunName);
							rc = FALSE;
							break;
						}
						//	バイナリデータ設定
						memcpy(pW->ExeMemBlk[bno].pMemAddr, ScpEvt.pDat, len);
						//	引数（パケットデータ長）設定
						AjcCipCallInfoInsInteger(pW->hWndBack, pCall, len);
						//	関数呼び出し
						CipExeFuncCall(pW, pCall, NULL);
						//	呼び出し情報破棄
						AjcCipCallInfoDelete(pW->hWndBack, pCall);
					}
				} while(0);
			}
			//	受信データ破棄
			free(ScpEvt.pDat);
			//	Windowsイベント実行
			CipGsrDoEvent(pW);
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'define' ）																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 構文の直後のトークン																	//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeDefine	(HAJCCIP pW)
{
	BOOL	rc = TRUE;

	pW->pCur++;									//	'define' スキップ
	rc &= SubRegistVariable(pW);				//	変数登録

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'if' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 条件＝真：'if (条件)' の直後のトークン												//
//						   条件＝偽：'else' / ifブロック終端( '}' / ';' ) の直後のトークン						//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeIf		(HAJCCIP pW)
{
	BOOL		rc = FALSE;
	AJCCIP_UVAL	val;
	BOOL		cond;

	do {
		PAJCCIPTKN	pIf = pW->pCur++;															//	'if' スキップ
		if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {												//	'(' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pIf->lno,
										  LNGSEL("'if' の直後に '(' が必要です。",
												 "Need '(' after 'if'."));
			break;
		}
		pW->pCur++;																				//	'(' スキップ
		switch (pW->NumType) {																	//	数式演算
			case AJCIPT_INTEGER: CipFmlINT(pW, &val.sll, CALCULATION); cond = (val.sll != 0); break;
			case AJCIPT_REAL:	 CipFmlDBL(pW, &val.dbl, CALCULATION); cond = (val.dbl != 0); break;
		}
		if (pW->ErrCod != AJCIP_ERR_OK) break;													//	数式エラー
		if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {												//	')' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pIf->lno,
										  LNGSEL("'if (条件' の直後に ')' が必要です。",
												 "Need '(' after 'if (condition'."));
			break;
		}
		pW->pCur++;																				//	')' スキップ
		//	次の実行アドレス設定
		if (cond) {
			rc = TRUE;
		}
		else {
			if (CipGsrSetJumpAddr(pW, pIf->u.pJmp)) {
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pIf->lno,
											  LNGSEL("'if' 偽条件時のジャンプ先が設定されていません。（内部エラー）",
													 "Jump address is no set in 'if'. (Internal error)"));
				break;
			}
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'else' ）																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - ifブロック終端( '}' / ';' ) の直後のトークン											//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeElse		(HAJCCIP pW)
{
	BOOL		rc	  = FALSE;
	PAJCCIPTKN	pElse = pW->pCur;

	//	次の実行アドレス設定
	pW->pCur++;	// 'else'スキップ
	if (CipGsrSetJumpAddr(pW, pElse->u.pJmp)) {
		rc = TRUE;
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pElse->lno,
									  LNGSEL("'else' のジャンプ先が設定されていません。（内部エラー）",
											 "Jump address is no set in 'else'. (Internal error)"));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'do' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 'do' の次のトークン																	//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeDo		(HAJCCIP pW)
{
	BOOL	rc = TRUE;

	pW->pCur++;		//	'do' スキップ

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'while' ）																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 前置きwhile - 条件＝真：'while (条件)' の直後のトークン								//
//										 条件＝偽：'while'ブロック終端( '}' / ';' ) の直後のトークン			//
//						   後置きwhile - 条件＝真：'do' の直後のトークン										//
//										 条件＝偽：'while (条件)' の直後のトークン								//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeWhile		(HAJCCIP pW)
{
	BOOL		rc = FALSE;
	AJCCIP_UVAL	val;
	BOOL		cond;

	do {
		PAJCCIPTKN	pWhile = pW->pCur++;														//	'while' スキップ
		if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {												//	'(' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pWhile->lno,
										  LNGSEL("'while' の直後に '(' が必要です。",
												 "Need '(' after 'while'."));
			break;
		}
		pW->pCur++;																				//	'(' スキップ
		switch (pW->NumType) {																	//	数式演算
			case AJCIPT_INTEGER: CipFmlINT(pW, &val.sll, CALCULATION); cond = (val.sll != 0); break;
			case AJCIPT_REAL:	 CipFmlDBL(pW, &val.dbl, CALCULATION); cond = (val.dbl != 0); break;
		}
		if (pW->ErrCod != AJCIP_ERR_OK) break;													//	数式エラー
		if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {												//	')' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
										  LNGSEL("'while (条件' の直後に ')' が必要です。",
												 "Need '(' after 'while (condition'."));
			break;
		}
		pW->pCur++;																				//	')' スキップ
		//	次の実行アドレス設定
		if (pWhile->flgCtrl == AJCIP_WHILE_FRONT) {												//	前置き 'while' ？
			if (!cond) {																		//	偽条件？
				if (CipGsrSetJumpAddr(pW, pWhile->u.pJmp)) {									//	ジャンプ先設定，ＯＫ？
					rc = TRUE;																	//	「正常」
				}
				else {																			//	ジャンプ先設定，ＮＧ？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pWhile->lno,
												  LNGSEL("前置き 'while' 偽条件時のジャンプ先が設定されていません。（内部エラー）",
														 "Jump address is no set in 'while'. (Internal error)"));
					break;
				}
			}
			else {																				//	真条件？
				rc = TRUE;																		//	「正常」
			}
		}
		else if (pWhile->flgCtrl == AJCIP_WHILE_TAIL) {											//	後置き 'while' ？
			if (cond) {																			//	真条件？
				if (CipGsrSetJumpAddr(pW, pWhile->u.pJmp)) {									//	ジャンプ先設定，ＯＫ？
					rc = TRUE;																	//	「正常」
				}
				else {																			//	ジャンプ先設定，ＮＧ？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pWhile->lno,
												  LNGSEL("後置き 'while' 真条件時のジャンプ先が設定されていません。（内部エラー）",
														 "Jump address is no set in 'while'. (Internal error)"));
					break;
				}
			}
			else {																				//	偽条件？
				rc = TRUE;																		//	「正常」
			}
		}
		else {																					//	'while' のタイプ未設定？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pWhile->lno,
										  LNGSEL("'while' のタイプ（前置き／後置き）が設定されていません。（内部エラー）",
												 "'while' type is no set. (Internal error)"));
			break;
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'for' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 条件＝真：'for (初期化; 条件; 更新)' の直後のトークン								//
//						   条件＝偽：'for'ブロック終端( '}' / ';' ) の直後のトークン							//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeFor		(HAJCCIP pW)
{
	BOOL		rc = FALSE;
	AJCCIP_UVAL	val;
	BOOL		cond;
	PAJCCIPTKN	pFor;
	PAJCCIPTKN	pSemiCol;

	do {
		pFor = pW->pCur++;																		//	'for' スキップ
		if (pW->pCur->tkn != EAJCTK_DLM_LSPART) {												//	'(' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pFor->lno,
										  LNGSEL("'for' の直後に '(' が必要です。",
												 "Need '(' after 'for'."));
			break;
		}
		pW->pCur++;																				//	'(' スキップ
		if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {												//	';' ？
			cond = TRUE;
		}
		else {																					//	';' 以外？
			switch (pW->NumType) {																//	数式演算
				case AJCIPT_INTEGER: CipFmlINT(pW, &val.sll, CALCULATION); cond = (val.sll != 0); break;
				case AJCIPT_REAL:	 CipFmlDBL(pW, &val.dbl, CALCULATION); cond = (val.dbl != 0); break;
			}
			if (pW->ErrCod != AJCIP_ERR_OK) break;												//	数式エラー
		}
		if (pW->pCur->tkn != EAJCTK_DLM_SEMICOL) {												//	';' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
										  LNGSEL("'for 条件' の直後に ';' が必要です。",
												 "Need ';' after condition in 'for'."));
			break;
		}
		pSemiCol = pW->pCur++;																	//	';' スキップ
		//	次の実行アドレス設定
		if (!cond) {																			//	偽条件？
			if (CipGsrSetJumpAddr(pW, pFor->u.pJmp)) {											//	ジャンプ先設定，ＯＫ？
				rc = TRUE;																		//	「正常」
			}
			else {																				//	ジャンプ先設定，ＮＧ？
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pFor->lno,
											  LNGSEL("'for' 偽条件時のジャンプ先が設定されていません。（内部エラー）",
													 "Jump address is no set in 'while'. (Internal error)"));
				break;
			}
		}
		else {																					//	真条件？
			if (pSemiCol->flgCtrl == AJCIP_FOR_COND) {											//	'for' 条件の末尾（ ';' ）設定済？
				if (CipGsrSetJumpAddr(pW, pSemiCol->u.pJmp)) {									//	
					rc = TRUE;																	//	
				}
				else {																			//	'for' 条件の末尾（ ';' ）が設定されていない？
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pFor->lno,
												  LNGSEL("'for' 真条件時のジャンプ先が設定されていません。（内部エラー）",
														 "Jump address is no set in 'for'. (Internal error)"));
					break;
				}
			}
			else {																				//	
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pFor->lno,
											  LNGSEL("'for' 条件の次の ';' が正しく認識されていません。",
													 "'Next to the condition ';' in 'for', it isn't recognized right."));
				break;
			}
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'break' ）																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 制御ブロック終端( '}' / ';' ) の直後のトークン										//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeBreak		(HAJCCIP pW)
{
	BOOL		rc = FALSE;
	PAJCCIPTKN	pBreak = pW->pCur;

	do {
		//	構文チェック
		pW->pCur++;
		if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {
			while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pBreak->lno,
										  LNGSEL("'break' の直後に ';' が必要です。",
												 "Need ';' after 'break'."));
			break;
		}
		//	次の実行アドレス設定
		if (CipGsrSetJumpAddr(pW, pBreak->u.pJmp)) {
			rc = TRUE;
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pBreak->lno,
										  LNGSEL("'break' のジャンプ先が設定されていません。（内部エラー）",
												 "Jump address is no set in 'break'. (Internal error)"));
			break;
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'return' ）																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 戻り位置のトークン																	//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeReturn	(HAJCCIP pW)
{
	BOOL	rc = FALSE;
	PAJCCIPCALL	pCall = &pW->sFni[pW->ixFni].CInf;
	PAJCCIPTKN	pCur;
	PAJCCIPTKN	pNx1;
	PAJCCIPTKN	pNx2;
	UI			lno;

	pW->pCur++;				//	'return' スキップ
	pCur = pW->pCur;		//	'return' の次
	pNx1 = pCur + 1;		//	'return' の２つ次
	pNx2 = pCur + 2;		//	'return' の３つ次

	if (pCur->tkn != EAJCTK_EOF) {																				//	ＥＯＦ以外？
		if (pCur->tkn != EAJCTK_DLM_SEMICOL) {																	//	';' 以外
			//	関数タイプ＝文字型
			if (*pCall->pFunName == '$') {																		//	文字型関数？
				if (IS_STR_SYM(pCur)) {																			//	●文字型変数
					if (pNx1->tkn == EAJCTK_DLM_LLPART && pNx2->tkn == EAJCTK_DLM_RLPART) {						//		'$var[]' ？
						HAJCVMGA	hVmgS;
						if (hVmgS = SubExeGetVarInst(pW, pCur)) {												//		戻り値変数Inst取得，成功？
							if (pCall->rchVmg != NULL) {														//		戻り値格納要？
								lno = pCur->lno;
								if (CipVmgCopy(pW, lno, pCall->rchVmg, pCall->rcpSym, hVmgS, pCur->u.pStr)) {	//		配列コピー，成功？
									pW->pCur = pNx2 + 1;														//		'$var[]' スキップ
									rc = TRUE;
								}
							}
							else {																				//		戻り値格納不要？
								pW->pCur = pNx2 + 1;															//		'$var[]' スキップ
								rc = TRUE;
							}
						}
					}
					else {																						//		'$var[]' 以外？
						HAJCVMGA	hVmgS;
						ULL			ix;
						if (hVmgS = SubExeGetVarInstAndIx(pW, &ix)) {											//		変数Inst＆Ix取得，成功？
							if (pCall->rchVmg != NULL) {														//		戻り値格納要？
								C_BCP		pStrS;
								lno = pCur->lno;
								if (pStrS = CipVmgGetString(pW, lno, hVmgS, pCur->u.pStr, (UI)ix)) {						//	変数値（文字列）取得
									if (CipVmgSetString(pW, lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pStrS)) {	//	変数値（文字列）設定
										rc = TRUE;
									}
								}
								else {																			//		戻り値格納不要？
									rc = TRUE;
								}
							}
						}
					}
				}
				else if (pW->pCur->tkn == EAJCTK_CIP_STRING) {													//	●文字列
					if (pCall->rchVmg != NULL) {																//		戻り値格納要？
						lno = pW->pCur->lno;
						if (CipVmgSetString(pW, lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->pCur->u.pStr)) {	//	変数値（文字列）設定
							pW->pCur++;																			//		文字列スキップ
							rc = TRUE;
						}
					}
					else {																						//		戻り値格納不要？
						pW->pCur++;																				//		文字列スキップ
						rc = TRUE;
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
												  LNGSEL("戻り値は、文字変数／文字列でなければなりません。",
														 "Must be type string-variable or string-value."));
				}
			}
			//	関数タイプ＝数値型
			else {
				if (IS_NUM_SYM(pCur) && pNx1->tkn == EAJCTK_DLM_LLPART && pNx2->tkn == EAJCTK_DLM_RLPART) {		//	'var[]' ？
					
					if (pCall->rchVmg != NULL) {																//		戻り値格納要？
						HAJCVMGA	hVmgS;
						if (hVmgS = SubExeGetVarInst(pW, pCur)) {												//		戻り値変数Inst取得，成功？
							lno = pCur->lno;
							if (CipVmgCopy(pW, lno, pCall->rchVmg, pCall->rcpSym, hVmgS, pCur->u.pStr)) {		//		配列コピー，成功？
								pW->pCur = pNx2 + 1;															//		'var[]' スキップ
								rc = TRUE;
							}
						}
					}
					else {																						//		戻り値格納不要？
						pW->pCur = pNx2 + 1;																	//		'var[]' スキップ
						rc = TRUE;
					}
				}
				else {																							//	'var[]' 以外？
					AJCCIP_UVAL		val;
					lno = pW->pCur->lno;
					switch (pW->NumType) {																		//		演算式評価，値設定
						case AJCIPT_INTEGER:
							if (CipFmlINT(pW, &val.sll, CALCULATION)) {
								if (pCall->rchVmg != NULL) {													//		戻り値格納要？
									rc = CipVmgSetInteger(pW, lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, val.sll);
								}
								else rc = TRUE;																	//		戻り値格納不要？
							}
							break;

						case AJCIPT_REAL:
							if (CipFmlDBL(pW, &val.dbl, CALCULATION)) {
								if (pCall->rchVmg != NULL) {													//		戻り値格納要？
									rc = CipVmgSetReal	 (pW, lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, val.dbl);
								}
								else rc = TRUE;																	//		戻り値格納不要？
							}
							break;
					}
				}
			}
		}
		//	return の次がセミコロン(;)・・・戻り値指定無し
		else {
			rc = TRUE;
		}

		//	';' チェック
		if (rc) {
			if (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) {
				//	';' スキップ
				while (pW->pCur->tkn == EAJCTK_DLM_SEMICOL) pW->pCur++;
				//	変数管理インスタンス破棄
				if (pW->sFni[pW->ixFni].hVmg != NULL) {
					AjcVmgDeleteA(pW->sFni[pW->ixFni].hVmg);
					pW->sFni[pW->ixFni].hVmg = NULL;
				}
				//	変数管理インデクス減算，戻りアドレス設定
				if (pW->ixFni > 1) {						//	関数ネスト中？
					CipGsrSetJumpAddr(pW, pCall->pReturn);	//		戻りアドレス設定
					pW->ixFni--;							//		ネスト数減算
				}
				else {										//	先頭の関数？
					pW->fRunStop = TRUE;					//		停止
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
											  LNGSEL("'return' の末尾に ';' が必要です。",
													 "Need ';' in tail of 'return'."));
				rc = FALSE;
			}
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("'return' の末尾に ';' が必要です。",
											 "Need ';' in tail of 'return'."));
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ 'goto' ）																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur - 分岐先のトークン																		//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeGoto		(HAJCCIP pW)
{
	BOOL	rc = TRUE;
	PAJCCIPTKN	pGoto = pW->pCur;


	//	次の実行アドレス設定
	if (CipGsrSetJumpAddr(pW, pGoto->u.pJmp)) {
		rc = TRUE;
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pGoto->lno,
									  LNGSEL("'goto' のジャンプ先が設定されていません。（内部エラー）",
											 "Jump address is no set in 'goto'. (Internal error)"));
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ '{' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur -	前置き 'while' の終端 - 'while'トークン												//
//							'for' の終端		  - 'for'の更新文群先頭トークン									//
//							関数の末尾			  - 戻り位置のトークン											//
//							その他				  - '{' の次のトークン											//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeLmPart	(HAJCCIP pW)
{
	BOOL	rc = TRUE;

	pW->pCur++;		//	'{' スキップ

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ '}' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur -	前置き 'while' の終端 - 'while'トークン												//
//							'for' の終端		  - 'for'の更新文群先頭トークン									//
//							関数の末尾			  - 戻り位置のトークン											//
//							その他				  - '}' の次のトークン											//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeRmPart	(HAJCCIP pW)
{
	BOOL		rc		= FALSE;
	PAJCCIPCALL	pCall	= &pW->sFni[pW->ixFni].CInf;
	PAJCCIPTKN	pRmPart = pW->pCur;

	switch (pRmPart->flgCtrl) {
		case AJCIP_WHILE_END:					//	●前置き 'while' の終端（ ';' or '}' ）
			pW->pCur++;							//		'}' スキップ
			if (CipGsrSetJumpAddr(pW, pRmPart->u.pJmp)) {
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pRmPart->lno,
											  LNGSEL("'while' への繰り返しポイントが設定されていません。（内部エラー）",
													 "Jump address is no set in end of 'while'. (Internal error)"));
			}
			break;

		case AJCIP_FOR_END:						//	●'for' の終端（ ';' or '}' ）
			pW->pCur++;							//		'}' スキップ
			if (CipGsrSetJumpAddr(pW, pRmPart->u.pJmp)) {
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pRmPart->lno,
											  LNGSEL("'for' への繰り返しポイントが設定されていません。（内部エラー）",
													 "Jump address is no set in end of 'for'. (Internal error)"));
			}
			break;

		case AJCIP_FUNC_END:					//	●関数の末尾（ '}' ）
			pW->pCur++;							//		'}' スキップ
			//	変数管理インスタンス破棄
			if (pW->sFni[pW->ixFni].hVmg != NULL) {
				AjcVmgDeleteA(pW->sFni[pW->ixFni].hVmg);
				pW->sFni[pW->ixFni].hVmg = NULL;
			}
			//	変数管理インデクス減算，戻りアドレス設定
			if (pW->ixFni > 1) {						//	関数ネスト中？
				CipGsrSetJumpAddr(pW, pCall->pReturn);	//		戻りアドレス設定
				pW->ixFni--;							//		ネスト数減算
			}
			else {										//	先頭の関数？
				pW->fRunStop = TRUE;					//		停止
			}
			rc = TRUE;
			break;

		default:								//	●その他
			pW->pCur++;							//		'}' スキップ
			rc = TRUE;
			break;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ ';' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur -	前置き 'while' の終端 - 'while'トークン												//
//							'for' の終端		  - 'for'の更新文群先頭トークン									//
//							その他				  - '}' の次のトークン											//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeSemiCol	(HAJCCIP pW)
{
	BOOL		rc		 = FALSE;
	PAJCCIPTKN	pSemiCol = pW->pCur;

	switch (pSemiCol->flgCtrl) {
		case AJCIP_WHILE_END:				//	●前置き 'while' の終端（ ';' or '}' ）
			pW->pCur++;
			if (CipGsrSetJumpAddr(pW, pSemiCol->u.pJmp)) {
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pSemiCol->lno,
											  LNGSEL("'while' への繰り返しポイントが設定されていません。（内部エラー）",
													 "Jump address is no set in end of 'while'. (Internal error)"));
			}
			break;

		case AJCIP_FOR_END:					//	●'for' の終端（ ';' or '}' ）
			pW->pCur++;
			if (CipGsrSetJumpAddr(pW, pSemiCol->u.pJmp)) {
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pSemiCol->lno,
											  LNGSEL("'for' への繰り返しポイントが設定されていません。（内部エラー）",
													 "Jump address is no set in end of 'for'. (Internal error)"));
			}
			break;

		default:							//	●その他
			pW->pCur++;
			rc = TRUE;
			break;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ ',' ）		※ 'for' の「初期化文中」or「更新文中」													//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur -	',' の次のトークン																	//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeComma		(HAJCCIP pW)
{
	BOOL	rc = TRUE;

	pW->pCur++;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（ ')' ）																								//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//																												//
//	入　力	：	pW->pCur - トークン先頭																			//
//																												//
//	出　力	：	pW->pCur -	'for' 更新文の終端 - 'for' トークン													//
//							その他			   - ')' の次のトークン												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL SubExeRsPart	(HAJCCIP pW)
{
	BOOL		rc		= TRUE;
	PAJCCIPTKN	pRsPart = pW->pCur;

	switch (pRsPart->flgCtrl) {
		case AJCIP_FOR_UPD:					//	●'for' 更新文の終端（ ')' ）
			if (CipGsrSetJumpAddr(pW, pRsPart->u.pJmp)) {
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pRsPart->lno,
											  LNGSEL("'for' への繰り返しポイントが設定されていません。（内部エラー）",
													 "Jump address is no set in end of 'for' updaters. (Internal error)"));
			}
			break;

		default:							//	●その他
			pW->pCur++;
			break;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（変数のインスタンス取得）																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pSymTkn		- シンボルトークン																	//
//																												//
//	戻り値	：	≠NULL:正常（変数管理インスタンス）																//
//				＝NULL:エラー																					//
//																												//
//	入	力	：	pW->pCur - シンボルトークン																		//
//--------------------------------------------------------------------------------------------------------------//
static	HAJCVMGA	SubExeGetVarInst(HAJCCIP pW, PAJCCIPTKN pSymTkn)
{
	HAJCVMGA		rc = NULL;
	PCAJCVMGNODEA	pNode;
	UI				lno;

	do {
		//	自動変数インスタンス取得
		if (pW->ixFni != 0) {
			if (pNode = AjcVmgGetNodeA(pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr)) {
				rc = pW->sFni[pW->ixFni].hVmg;
				break;
			}
		}
		//	静的変数インスタンス取得
		lno = pSymTkn->lno;
		if (pNode = CipVmgGetNode(pW, lno, pW->sFni[0].hVmg, pSymTkn->u.pStr)) {
			rc = pW->sFni[0].hVmg;
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	実行（変数のインスタンスと配列添え字取得）																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pIx			- 変数の配列添え字の値を格納するバッファ											//
//																												//
//	戻り値	：	≠NULL:正常（変数管理インスタンス）																//
//				＝NULL:エラー																					//
//																												//
//	入	力	：	pW->pCur - シンボルトークン																		//
//--------------------------------------------------------------------------------------------------------------//
static	HAJCVMGA	SubExeGetVarInstAndIx(HAJCCIP pW, ULLP pIx)
{
	HAJCVMGA	rc	 = NULL;
	HAJCVMGA	hVmg = NULL;
	UI			lno;

	if (pW->pCur->tkn == EAJCTK_USR_NAME) {													//	先頭はシンボル？
		if (hVmg = SubExeGetVarInst(pW, pW->pCur)) {										//	変数インスタンス取得，成功？
			PAJCCIPTKN	pSymTkn = pW->pCur++;												//	変数スキップ
			if (pW->pCur->tkn == EAJCTK_DLM_LLPART) {										//	'[' ？
				pW->pCur++;																	//	'[' スキップ
				if (CipFmlINT(pW, pIx, CALCULATION)) {										//	配列インデクス算出，成功？
					if (pW->pCur->tkn == EAJCTK_DLM_RLPART) {								//	']' ？
						lno = pW->pCur->lno;
						pW->pCur++;															//	']' スキップ
						if (*pIx < (ULL)CipVmgGetArrNum(pW, lno, hVmg, pSymTkn->u.pStr)) {	//	インデクスは範囲内？
							rc = hVmg;														//	正常戻り値（インスタンス）設定
						}
					}
					else {																	//	']' 以外？
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pFml->lno,
											LNGSEL("配列添え字の後に ']' がありません。",
												   "Need ']' after array index."));
					}
				}
			}
			else {																			//	'[' 以外？
				*pIx = 0;																	//	インデクス＝０
				rc = hVmg;																	//	正常戻り値（インスタンス）設定
			}
		}
	}
	else {																					//	先頭はシンボル以外？
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
							LNGSEL("変数が指定されていません。",
								   "No variable."));
	}

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	ステートメントスキップ( ';' の次のトークンまでスキップ）													//
//																												//
//	引　数	：	pStmt		- ステートメントの先頭トークン														//
//																												//
//	戻り値	：	';' の次のトークン（';'が見つからない場合はEOFトークン）										//
//--------------------------------------------------------------------------------------------------------------//
static	PAJCCIPTKN	SubSkipStmt(PAJCCIPTKN pStmt)
{
	while (pStmt->tkn != EAJCTK_DLM_SEMICOL && pStmt->tkn != EAJCTK_EOF) {
		pStmt++;
	}
	while (pStmt->tkn == EAJCTK_DLM_SEMICOL) {
		pStmt++;
	}
	return pStmt;
}

