﻿#ifndef		AJCCIPCOMMON_H_
#define		AJCCIPCOMMON_H_
/****************************************************************************************************************/

#define	WM_ON_RCLICK		(WM_APP + 10)		//	マクロウインド・右クリック通知メッセージ
#define	WM_CIP_SCPEVENT		(WM_APP + 11)		//	ＳＣＰイベントメッセージ
#define	WM_POPUPMENU		(WM_APP + 12)		//	ポップアップメニュー選択通知

#define	MAX_INPTXTLEN		512					//	$_Input()で入力できる最大文字列バッファ長
#define	MAX_SECNAME			512					//	プロファイル・セクション名の最大バッファ長
#define	MAX_TMCTEXT			256					//	ＴＭＣｋｙぷしょん文字列のバッファｖ法

#define	MAX_BUTTON			8					//	最大ボタン数
#define	IDC_BKBUTTON		6000				//	ボタンコントロールＩＤ

#define	MAX_CHKBOX			8					//	最大チェックボックス数
#define	IDC_BKCHKBOX		6100				//	ボタンコントロールＩＤ

#define	MIN_COMPORT			1					//	最小ＣＯＭポート番号
#define	MAX_COMPORT			255					//	最大ＣＯＭポート番号
#define	SLOT_PORT			256					//	メールスロットポート番号

#define	MIN_PORT			MIN_COMPORT			//	最小ポート番号
#define	MAX_PORT			SLOT_PORT			//	最大ポート番号

#define	AJCCIP_SCPWNDCLASS	"CAJCCIPSCPWND"		//	ＳＣＰ通知用ウインドクラス
#define	AJCCIP_TMCBAKCLASS	"CAJCCIPTMCWND"		//	ＴＭＣ用バックウインドクラス

#define	CIP_MAIN_SECT		"AjcCipMainSect"	//	メインセクション
#define	CIP_TRC_SECT		"AjcCipTraceSect"	//	トレース表示情報セクション
#define	CIP_STEP_SECT		"AjcCipStepTrace"	//	ステップトレース情報セクション

//--------------------------------------------------------------------------------------------------------------//
//	'do', 'while', 'for', 'function' 関連のフラグ情報(flgCtrl)													//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCIP_WHILE_FRONT		1		//	前置き 'while'
#define	AJCIP_WHILE_TAIL		2		//	後置き 'while'
#define	AJCIP_WHILE_END			3		//	前置き 'while' ブロック終端 の（ ';' or '}' ）
#define	AJCIP_FOR_COND			4		//	'for' 条件の末尾（ ';' ）	※１
#define	AJCIP_FOR_UPD			5		//	'for' 更新文の末尾（ ')' ）	※１
#define	AJCIP_FOR_END			6		//	'for' の終端（ ';' or '}' ）
#define	AJCIP_FUNC_END			7		//	関数の末尾（ '}' ）

//--------------------------------------------------------------------------------------------------------------//
//	数値定数／文字定数のタイプ(flgValue)																		//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCIP_VAL_DEC			10		//	数値定数の表現形式（１０進数)
#define	AJCIP_VAL_HEX			11		//		  〃		  （１６進数）
#define	AJCIP_VAL_OCT			12		//		  〃		  （８進数）
#define	AJCIP_VAL_REAL			13		//		  〃		  （実数）

#define	AJCIP_VAL_QUOTE			20		//	文字定数の表現形式（"XXX"）
#define	AJCIP_VAL_APOST			21		//		  〃		  （'XXX'）


/*
	※１：'for' 文は、内部的に、以下のようにトークン順序を入れ替えます。

		for (A, B; COND; C, D)	--->  A; B; for(COND; C, D)

*/

//--------------------------------------------------------------------------------------------------------------//
//	引数リスト情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	EAJCCIPTYP	typ;						//	タイプ
	BCP			pSym;						//	引数名へのポインタ
	BOOL		fArr;						//	配列フラグ
} AJCCIPARG, *PAJCCIPARG;
typedef const AJCCIPARG *PCAJCCIPARG;

//--------------------------------------------------------------------------------------------------------------//
//	ファンクション登録情報																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BCP			pFunName;					//	関数名へのポインタ
	PAJCCIPTKN	pEntry;						//	関数入り口点のトークンポインタ（ 'function name(・・・) ' の次のトークン( = '{' ）
	EAJCCIPTYP	typRet;						//	戻り値のタイプ
	UI			nArg;						//	引数の個数
	HAJCFQUE	hQueArg;					//	引数情報（「AJCCIPARG」の固定長キュー）
} AJCCIPFUNC, *PAJCCIPFUNC;
typedef const AJCCIPFUNC *PCAJCCIPFUNC;

//--------------------------------------------------------------------------------------------------------------//
//	ループ構造体Exitポイント登録情報																			//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			nest;						//	制御構造のネスト位置
	PAJCCIPTKN	pTop;						//	制御構造の先頭ポイント
	PAJCCIPTKN	pExit;						//	制御構造のExitポイント
} AJCCIPEXIT, *PAJCCIPEXIT;
typedef const AJCCIPEXIT *PCAJCCIPEXIT;

//--------------------------------------------------------------------------------------------------------------//
//	ラベル・ポイント登録情報																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BCP			pName;						//	ラベル名
	PAJCCIPTKN	pJmp;						//	ジャンプポイント（ 'label:;' の次 ）
} AJCCIPLABEL, *PAJCCIPLABEL;
typedef const AJCCIPLABEL *PCAJCCIPLABEL;

//--------------------------------------------------------------------------------------------------------------//
//	関数ネスティング情報																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HAJCVMGA	hVmg;						//	変数管理情報	（[0]:静的変数，[1～]:関数内の自動変）
	AJCCIPCALL	CInf;						//	関数呼び出し情報（[0]:未使用  ，[1～]:当該関数呼び出し情報）
} AJCCIPFNEST, *PAJCCIPFNEST;
typedef const AJCCIPFNEST *PCAJCCIPFNEST;

//--------------------------------------------------------------------------------------------------------------//
//	変数情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HAJCVMGA	hVmg;						//	変数の「変数管理インスタンス」
	BCP			pSym;						//	  〃  「変数名へのポインタ」
	UI			ix;							//	  〃  「配列インデクス」
} AJCCIPVARINFO, *PAJCCIPVARINFO;
typedef const AJCCIPVARINFO *PCAJCCIPVARINFO;

//--------------------------------------------------------------------------------------------------------------//
//	数式評価用 直前のPARTが変数か否かの情報																		//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BOOL			fLsVar;						//	直前のPARTが変数であることを示すフラグ
	AJCCIPVARINFO	vLs;						//	直前の変数情報
} AJCCIPLSPART, *PAJCCIPLSPART;
typedef const AJCCIPLSPART *PCAJCCIPLSPART;

//--------------------------------------------------------------------------------------------------------------//
//	数式評価用 直前のPARTが変数か否かの情報																		//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UBP		pMemAddr;
	UI		MemLen;
} AJCCIPMBLK, *PAJCCIPMBLK;

//--------------------------------------------------------------------------------------------------------------//
//	ファイルハンドル情報																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	FILE	*hFile;
	BC		mode[8];
} AJCCIPFILE, *PAJCCIPFILE;
//--------------------------------------------------------------------------------------------------------------//
//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭ制御情報																			//
//--------------------------------------------------------------------------------------------------------------//
#define		MAX_FIND_FILE	64
typedef struct {
	HANDLE			XYm_hFile;					//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭ送受信ファイルハンドル
	BOOL			XYm_evt;					//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭイベントコード
	UL				XYm_FTime;					//	ＹＭＯＤＥＭファイルタイム
	BC				XYm_AnyPath[MAX_PATH];		//	ＹＭＯＤＥＭ受信時：ファイル格納ディレクトリパス
												//	ＹＭＯＤＥＭ時送信：ファイルパス／ワイルドパス
	BOOL			XYm_fFindFirst;				//	ＹＭＯＤＥＭ送信 - 初回ファイル検索フラグ
	int				XYm_ixFind;					//	ＹＭＯＤＥＭ送信 - ファイル検索ハンドルネストインデクス
	SX				XYm_hFind[MAX_FIND_FILE];	//	ＹＭＯＤＥＭ送信 - ファイル検索ハンドル
	BC				XYm_TopDir	[MAX_PATH];		//	トップフォルダパス
	BC				XYm_SrhDir	[MAX_PATH];		//	検索中のディレクトリパス
	BC				XYm_WildName[MAX_PATH];		//	ＹＭＯＤＥＭ送信 - ファイルパス／ワイルドパスのファイル名／ワイルド部分
	BC				XYm_SndName [MAX_PATH];		//	ＹＭＯＤＥＭにで送信するファイル名／パス名
	ULL				XYm_RxByteSize;				//	受信ファイルサイズ    (Y-MODEM)
	ULL				XYm_RxByteCount;			//	ファイルバイトカウンタ(Y-MODEM)
} XYMWORK, *PXYMWORK;
//--------------------------------------------------------------------------------------------------------------//
//	ＳＣＰハンドル情報																							//
//--------------------------------------------------------------------------------------------------------------//

typedef struct {
	HAJCSCP		hScp;							//	ＳＣＰハンドル
	C_BCP		pOnRecvText;					//	テキスト受信時の実行関数名
	C_BCP		pOnRecvCtrl;					//	制御コード			〃
	C_BCP		pOnRecvEsc;						//	ＥＳＣシーケンス	〃
	C_BCP		pOnRecvPacket;					//	パケットデータ		〃
	UI			MemBlkNo;						//	メモリブロック番号（パケットデータ格納用）
	HWND		hwnd;							//	ＳＣＰイベント通知用ウインド
	UI			EvtMask;						//	ＳＣＰイベントマスク
	HAJCXYM		hXyModem;						//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭインスタンスハンドル
	PXYMWORK	pXyW;							//	XMODEM/YMODEM 制御情報
} AJCCIPSCPINF, *PAJCCIPSCPINF;
//--------------------------------------------------------------------------------------------------------------//
//	ＳＣＰイベントキューエントリ																				//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			evt;
	UI			port;
	UI			len;
	UBP			pDat;
} AJCCIPSCPEVT, *PAJCCIPSCPEVT;
//--------------------------------------------------------------------------------------------------------------//
//	トレース変数情報																							//
//--------------------------------------------------------------------------------------------------------------//
//	配列表現
typedef enum {
	VAREXP_NORMAL	= 0,					//	単純変数			（ 'VarName'	）
	VAREXP_ARRALL	= 1,					//	配列全体を表す		（ 'VarName[]'	）
	VAREXP_ARRIDX	= 2,					//	特定の配列インデクス（ 'VarName[n]'	)
} EVAREXP, *PEVAREXP;

typedef struct {
	BCP			pVarName;					//	変数名へのポインタ	（ 'VarName' )
	UI			ixArr;						//	配列インデクス値	（ n ）
	BOOL		fVarExp;					//	配列表現フラグ
} AJCCIPTRCVAR, *PAJCCIPTRCVAR;
//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCCIPMAX_IXVMG		64			//	関数呼び出しの最大ネスト数
#define		AJCCIPMAX_FILES		32			//	同時オープン可能なファイル数
#define		AJCCIPMAX_MEMBLK	32			//	同時確保可能なメモリブロック数

#define		AJCCIPMAX_SCP	(MAX_PORT + 1)	//	ＳＣＰ情報個数（１～２５５，０は未使用，２５６はメールスロット）
#define		AJCCIPIX_SLOT	SLOT_PORT		//	メールスロットのＳＣＰ情報インデクス

#define		AJCCIP_INSTID	0xB672C9F3

typedef struct _AJCCIP {
	UI			id;							//	インスタンスＩＤ（実行時チェック用）

	HWND		hParent;					//	親ウインドハンドル
	HWND		hWndBack;					//	バックウインドハンドル
	HWND		hWndVth;					//	ＶＴＨウインドハンドル
	int			CtrlId;						//	ＣＩＰコントロールＩＤ

	HWND		hTrcBack;					//	トレース バックウインドハンドル
	HWND		hTrcVth;					//	トレース ウインドハンドル
	HWND		hTrcDlg;					//	トレース ダイアログハンドル
	HWND		hTrcTtp;					//	トレース ツールチップハンドル
	SIZE		szTrcWnd;					//	トレース バックウインドの最小サイズ
	SIZE		szTrcDlg;					//	トレース ダイアログのサイズ
	BOOL		fTrcDisClose;				//	トレース ウインドクローズ禁止フラグ
	BOOL		fTrcOpeClose;				//	トレース ウインドクローズ操作フラグ

	HWND		hStepBack;					//	ステップトレース バックウインドハンドル
	HWND		hStepVth;					//	ステップトレース ウインドハンドル
	HWND		hStepDlg;					//	ステップトレース ダイアログハンドル
	HWND		hStepTtp;					//	ステップトレース ツールチップハンドル
	SIZE		szStepWnd;					//	ステップトレース バックウインドの最小サイズ
	SIZE		szStepDlgA;					//	ステップトレース ダイアログのサイズ（ブレークポイント未設定時）
	SIZE		szStepDlgB;					//	ステップトレース ダイアログのサイズ（ブレークポイント設定時）
	BOOL		fStepPause;					//	一時停止中フラグ
	BOOL		fStepSvPause;				//	一時停止中フラグ退避
	UI			nStepCount;					//	ステップ実行カウンタ
	BOOL		fStepMsgBoxBusy;			//	メッセージボックス表示中フラグ
	BOOL		fStepSvExec;				//	実行中状態退避

	HWND		hWndTmcBack;				//	ＴＭＣのバックウインドハンドル
	HWND		hWndTmc;					//	ＴＭＣウインドハンドル

	PAJCCIPTKN	pTknTop;					//	トークンコード群先頭ポインタ
	UI			nTkn;						//	トークン数
	HAJCAVL		hAvlFun;					//	ファンクション登録用２分木
	HAJCAVL		hAvlStr;					//	文字列蓄積用２分木

	//	オプション情報
	BOOL		fEnableOption;				//	「option」文の解析許可フラグ
	EAJCCIPTYP	NumType;					//	数値タイプ「AJCIPT_INTEGER or AJCIPT_REAL」
	BOOL		fSigned;					//	整数「AJCIPT_INTEGER」時の符号の有無（TRUE:符号付，FALSE:符号無し）

	//	ダブルクリック動作フラグ
	BOOL		fNtcDblClk;

	//	トークン解析（プリコンパイル）完了フラグ
	BOOL		fRunReady;

	//	関数ネスティング情報
	UI			ixFni;						//	関数ネストインデクス
	AJCCIPFNEST	sFni[AJCCIPMAX_IXVMG + 1];	//	関数ネスト情報

	//	トークンポインタワーク
	PAJCCIPTKN	pCur;						//	現在のトークン
	PAJCCIPTKN	pFml;						//	演算式の最後のトークン

	//	ステップトレース
	BOOL		fStepTrace;					//	ステップトレース許可フラグ

	//	式の評価用ワーク
	UI			FmlNestCnt;					//	ネストカウンタ
	BOOL		fFmlCalc;					//	計算フラグ（CALCULATION(=TRUE ) : 計算する，
											//			   (SYNTAX_ONLY(=FALSE) : 式のシンタックスチェックのみ）
	HAJCFQUE	hFmlLsPart;					//	直前のPART情報（AJCCIPLSPARTのキュー）

	//	関数の制御構造解析用ワーク
	UI			AnlNest;					//	制御構造のネスト
	PAJCCIPTKN	pAnlEndStmt;				//	ステートメント末尾（';' / '}')トークン
	HAJCFQUE	hAnlFQExit;					//	ループ構造体のExitポイント登録キュー
	HAJCAVL		hAnlAvlLabel;				//	ラベルポイント登録用ＡＶＬ
	BOOL		fAnlRsu;					//	関数の制御構造解析結果（TRUE:成功，FALSE:失敗）

	//	実行ワーク（実行可is前に初期化し、実行終了時にクリアーする情報）
	BOOL			fExec;							//	マクロテキストの実行中を示すフラグ
	UI				ixIfNest;						//	マクロコード内関数多重カウンタ
	AJCCIP_ERR		ErrCod;							//	エラーコード
	BOOL			fRunStop;						//	実行中止フラグ
	BOOL			fExeStop;						//	実行中断フラグ（_Stop() 命令による中断フラグ）
	BOOL			fExePause;						//	実行中断フラグ（_Pause()命令による中断フラグ）
	BOOL			fExeFileSearch;					//	ファイル検索中フラグ
	BOOL			fBusyOnChkBox;					//	_OnChkBox()実行中フラグ
	BOOL			fExeEventBusy;					//	イベント実行中フラグ
	BOOL			fExeStdEvtBusy;					//	標準　イベント実行中フラグ
	BOOL			fExeComEvtBusy;					//	ＣＯＭイベント実行中フラグ
	int				nExeDisStdEvt;					//	標準　イベント禁止ネストカウンタ
	int				nExeDisComEvt;					//	ＣＯＭイベント禁止ネストカウンタ
	UI				mskExeTimEvt;					//	タイマイベント動作中フラグ（Bit31～Bit1）
	BOOL			fExeRClick;						//	右クリック発生フラグ
	BOOL			fExeRClkShift;					//	Shift + 右クリックフラグ
	BOOL			fExeRClkCtrl;					//	Ctrl  + 右クリックフラグ
	BOOL			fExeDblClk;						//	ダブルクリック発生フラグ
	BOOL			fExeTimer[32];					//	タイマイベント発生フラグ
	BOOL			fExeEnaStdPopupMenu;			//	右クリックによる標準ポップアップの許可状態
	BC				ExitText[512];					//	_Exit($Text)により設定されたテキスト
	HAJCFQUE		hFQueStdEvt;					//	その他のイベントキューハンドル
	HAJCFQUE		hFQueScpEvt;					//	ＳＣＰイベントキュー
	PAJCCIPTKN		pStepTkn;						//	ステップトレース表示用トークンアドレス
	UI				SvStepLno;						//	ステップトレース表示用行番号退避
	UI				SvBrkLno;						//	ブレーク用行番号退避
	EAJCTKCODE		SvStepTkn;						//	ステップトレース表示用トークンコード退避
	UI				SvStepNest;						//	関数ネストレベルの退避
	UI				ExeStepNo;						//	ダイナミックステップ番号
	AJCCIPSCPINF	ExeScp[AJCCIPMAX_SCP];			//	ＳＣＰ情報
	AJCCIPFILE		ExeFile[AJCCIPMAX_FILES];		//	ファイルハンドル（[0]は未使用）
	AJCCIPMBLK		ExeMemBlk[AJCCIPMAX_MEMBLK];	//	メモリブロック情報（[0]は未使用）
	HWND			hButton[MAX_BUTTON];			//	ボタンハンドル
	UI				mskBtnValid;					//	ボタン有効フラグ
	HWND			hChkBox[MAX_BUTTON];			//	チェックボックスハンドル
	UI				mskChkValid;					//	チェックボックス有効フラグ
	UI				BtnChkHeight;					//	ボタン＋チェックボックスの高さ
	UI				PauseLno;						//	Pause 行番号

	POINT			ptExeRClick;					//	右クリック位置
	BCP				pExeDblClkLine;					//	ダブルクリック行テキストポインタ

	BC				ExeOpenFile[MAX_PATH];			//	オープンファイル取得ワーク
	BC				ExeSaveFile[MAX_PATH];			//	セーブファイル取得ワーク
	BC				ExeFolder[MAX_PATH];			//	フォルダ名取得ワーク
	BC				ExeInpTxt[MAX_INPTXTLEN];		//	$_Input()の入力テキスト
	BC				ExeSect  [MAX_SECNAME];			//	プロファイルセクション名
	BC				ExeTmcTxt[MAX_TMCTEXT];			//	タイムチャート・プロパティ文字列


	//	マクロコードファイル・パス名
	BC				MacFile[MAX_PATH];				//	パス名（フルパス）
	BC				MacPath[MAX_PATH];				//	ディレクトリ名
	BC				MacDrv[_MAX_DRIVE];				//		ドライブ名
	BC				MacDir[_MAX_DIR];				//		ディレクトリ名
	BC				MacFName[_MAX_FNAME];			//		ファイル名
	BC				MacFExt[_MAX_EXT];				//		ファイル拡張子

	//	メッセージボックス・ダイアログワーク
	HWND			hMbxhOwner;						//	オーナーウインドハンドル
	C_BCP			pMbxMsg;						//	メッセージテキスト
	C_BCP			pMbxTtl;						//	タイトルテキスト

	//----- 通知情報 -----------//
	UI				NtcDirs;						//	ドロップディレクトリ数
	UI				NtcFiles;						//	ドロップファイル数
	AJCCIPEVPFUN	NtcEvpFun;						//	外部関数呼び出し情報
	PAJCCIPAGV		*ppNtcAgv;						//	外部関数呼び出し時の引数情報
	BC				NtcTxt[MAX_PATH + 1024];		//	通知テキスト（エラーメッセージ，ダブルクリック行）
} AJCCIP, *HAJCCIP;


//--------------------------------------------------------------------------------------------------------------//
//	マクロ																										//
//--------------------------------------------------------------------------------------------------------------//
//	式の評価のオプション（実計算／シンタックスチェックのみ）
#define		CALCULATION		TRUE
#define		SYNTAX_ONLY		FALSE

//	数値シンボル／文字シンボル判定
#define		IS_NUM_SYM(PTKN)	(PTKN->tkn == EAJCTK_USR_NAME && *PTKN->u.pStr != '$')
#define		IS_STR_SYM(PTKN)	(PTKN->tkn == EAJCTK_USR_NAME && *PTKN->u.pStr == '$')

//--------------------------------------------------------------------------------------------------------------//
//	ＣＲＣ計算種別																								//
//--------------------------------------------------------------------------------------------------------------//
#define		CRC_ITL			0		//	CCITT X.25 左送り
#define		CRC_ITR			1		//	CCITT X.25 右送り
#define		CRC_16L			2		//	ANSI-CRC   左送り
#define		CRC_16R			3		//	ANSI-CRC   右送り

//--------------------------------------------------------------------------------------------------------------//
//	内部共通関数プロトタイプ																					//
//--------------------------------------------------------------------------------------------------------------//
//----- 主制御(AjcCip.c) ---------------------------------------------------------------------------------------//
extern	BOOL		CipReadMacroText(HAJCCIP pW);
extern	BOOL		CipAnalize		(HAJCCIP pW);
extern	BOOL		CipExeFuncCall	(HAJCCIP pW, PAJCCIPCALL pCall, PAJCCIPTKN pTknCall);

//----- 計算式評価・整数(AjcCipFmlINT.c) -----------------------------------------------------------------------//
extern	BOOL		CipFmlINT (HAJCCIP pW, SLL	  *pVal, BOOL fCalculation);

//----- 計算式評価・実数(AjcCipFmlDBL.c) -----------------------------------------------------------------------//
extern	BOOL		CipFmlDBL (HAJCCIP pW, double *pVal, BOOL fCalculation);

//----- 計算式評価用・サブ関数(AjcFmlGsr.c) --------------------------------------------------------------------//
extern	BOOL		CipFmlStr 				(HAJCCIP pW, SLL	 *pVal, BOOL fCalculation);
extern	BOOL		CipFmlCallFunc			(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation);
extern	SLL			CipFmlGetVarInfoInt64	(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation);
extern	double		CipFmlGetVarInfoReal 	(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation);
extern	C_BCP		CipFmlGetVarInfoStr  	(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation);
extern	HAJCVMGA	CipFmlGetVarInst		(HAJCCIP pW, PAJCCIPTKN pSymTkn);
extern	EAJCTKCODE	CipFmlSkipToken			(HAJCCIP pW);


//----- 変数管理(AjcCipVmg.c) ----------------------------------------------------------------------------------//
extern	BOOL			CipVmgGenVar	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, AJCVMGTYPE type, UI num);
extern	BOOL			CipVmgDelVar	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName);
extern	BOOL			CipVmgSetInteger(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, SLL value);
extern	BOOL			CipVmgSetReal	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, double value);
extern	BOOL			CipVmgSetString	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, C_BCP pStr);
extern	BOOL			CipVmgGetInt64	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, SLLP pValue);
extern	BOOL			CipVmgGetReal	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, double *pValue);
extern	C_BCP			CipVmgGetString	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix);
extern	BOOL			CipVmgSwap		(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName1, UI ix1, C_BCP pVarName2, UI ix2);
extern	UI				CipVmgGetArrNum	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName);
extern	PCAJCVMGNODEA	CipVmgGetNode	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName);
extern	BOOL			CipVmgCopy		(HAJCCIP pW, UI lno, HAJCVMGA hVmgD, C_BCP pNameD, HAJCVMGA hVmgS, C_BCP pNameS);

//----- 汎用サブ関数(AjcCipGsr.c) ------------------------------------------------------------------------------//
extern	HAJCCIP			CipGsrCreate				(VO);
extern	VO				CipGsrDelete				(HAJCCIP pW);

extern	VO				CipGsrNtcExe				(HAJCCIP pW, PAJCCIPTKN pTkn);
extern	AJCCIP_ERR		CipGsrNtcErr				(HAJCCIP pW, AJCCIP_ERR err, UI lno, C_BCP pFmt, ...);
extern	C_BCP			CipGsrTknStr				(PCAJCCIPTKN pTkn);
extern	PCAJCCIPTKN		CipGsrGetBeforeToken		(HAJCCIP pW, PCAJCCIPTKN pCur);
extern	PCAJCCIPTKN		CipGsrSetJumpAddr			(HAJCCIP pW, PAJCCIPTKN  pJmp);

extern	VO				CipGsrBtnAndChkBoxAlignment	(HAJCCIP pW);
extern	VO				CipGsrMoveVT100Window		(HAJCCIP pW);
extern	VO				CipGsrCall_OnChkBox			(HAJCCIP pW, int ChkBoxNo);
extern	VO				CipGsrStopAllTimer			(HAJCCIP pW);
extern	HAJCVMGA		CipGsrGetVarInst			(HAJCCIP pW, C_BCP pVarName);
extern	VO				CipGsrShowVariableValue		(HAJCCIP pW, HWND hVth, BCP pTxt, UI nMaxArr);
extern	BOOL			CipGsrAnalVarName			(HAJCCIP pW, C_BCP pVar, PAJCCIPTRCVAR pBuf);
extern	VO				CipGerMessageBoxOK			(HAJCCIP pW, HWND hOwner, C_BCP pMsg, C_BCP pTtl);
extern	VO				CipGsrDoEvent				(HAJCCIP pW);

//	コールバック
extern	int CALLBACK 	cbAvlCompStr   (UX key1, UX key2, UX cbp);
extern	VO 	CALLBACK 	cbAvlRemoveFunc(UX key, VOP pNodeData, UI len, UI nest, UX cbp);

//----- トレース表示(AjcCipTrace.c) ----------------------------------------------------------------------------//
extern	BOOL			CipTrcInit();
extern	VO				CipTrcEnd();
extern	VO				CipTrcVarDump		(HAJCCIP pW, UI MaxArrNum, UI lno, BOOL fDumpAll);
extern	VO				CipTrcPutText		(HAJCCIP pW, C_BCP pText, UI lno);
extern	BOOL			CipTrcCreateWindow	(HAJCCIP pW);

//----- ステップトレース(AjcCipStep.c)	------------------------------------------------------------------------//
extern	BOOL			CipStepInit();
extern	VO				CipStepEnd();
extern	VO				CipStepEnable		(HAJCCIP pW, BOOL fEnable);
extern	VO				CipStepDynNo		(HAJCCIP pW);
extern	VO				CipStepShowToken	(HAJCCIP pW, PAJCCIPTKN pNxt);
extern	VO				CipStepShowVariable	(HAJCCIP pW);
extern	BOOL			CipStepCreateWindow	(HAJCCIP pW);
extern	VO				CipStepNtcExec		(HAJCCIP pW, BOOL fForced);


//--------------------------------------------------------------------------------------------------------------//
//	関数処理ファンクション																						//
//--------------------------------------------------------------------------------------------------------------//
//	オプション設定
extern	BOOL	CipFunEnableStdRClk		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _EnableStdRClk
extern	BOOL	CipFunEnableAutoScroll	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _EnableAutoScroll

//	スクリーン情報
extern	BOOL	CipFunSetVramSize		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetVramSize
extern	BOOL	CipFunSetBufLines		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetBufLines
extern	BOOL	CipFunGetVramWidth		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetVramWidth
extern	BOOL	CipFunGetVramHeight		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetVramHeight
extern	BOOL	CipFunGetBufLines		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetBufLines


//	表示出力
extern	BOOL	CipFunPrintF			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _PrintF
extern	BOOL	CipFunPrint				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Print
extern	BOOL	CipFunPItem				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Pd
extern	BOOL	CipFunPHexa				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Ph
extern	BOOL	CipFunLocate			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Locate
extern	BOOL	CipFunCls				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Cls
extern	BOOL	CipFunSetTextColor		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetTextColor
extern	BOOL	CipFunSetBackColor		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetBackColor
extern	BOOL	CipFunResetColor		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ResetColor

//	配列操作
extern	BOOL	CipFunElements			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Elements
extern	BOOL	CipFunMakeArray			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _MakeArray / $_MakeArray

//	整数演算
extern	BOOL	CipFunCalcCrc			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _CalcCrc
extern	BOOL	CipFunSRand				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SRand
extern	BOOL	CipFunRand				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Rand

//	算術演算
extern	BOOL	CipFunSqrt				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Sqrt
extern	BOOL	CipFunSin				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Sin
extern	BOOL	CipFunCos				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Cos
extern	BOOL	CipFunTan				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Tan
extern	BOOL	CipFunASin				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ASin
extern	BOOL	CipFunACos				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ACos
extern	BOOL	CipFunATan				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ATan
extern	BOOL	CipFunATan2				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ATan2
extern	BOOL	CipFunAbs				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Abs
extern	BOOL	CipFunMin				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Min
extern	BOOL	CipFunMax				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Max

//	時間／ウェイト
extern	BOOL	CipFunCurTime			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _CurTim
extern	BOOL	CipFunGetTime			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetTime
extern	BOOL	CipFunGetDateAndTime	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _DateAndTime
extern	BOOL	CipFunDate				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_Date
extern	BOOL	CipFunTime				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_Time
extern	BOOL	CipFunDateAndTime		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_DateAndTime
extern	BOOL	CipFunWaitMS			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _msWait
extern	BOOL	CipFunWaitUS			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _usWait
extern	BOOL	CipFunStop				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Stop
extern	BOOL	CipFunRestart			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Restart

//	タイマ起動／停止
extern	BOOL	CipFunTimerStart		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TimerStart
extern	BOOL	CipFunTimerStop			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TimerStop

//	文字列
extern	BOOL	CipFunStrLen			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _StrLen
extern	BOOL	CipFunStrICmp			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _StrICmp
extern	BOOL	CipFunStrStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _StrStr
extern	BOOL	CipFunStrIStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _StrIStr
extern	BOOL	CipFunToValue			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ToValue
extern	BOOL	CipFunSPrintF			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_SPrintF
extern	BOOL	CipFunStrCat			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrCat
extern	BOOL	CipFunPathCat			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_PathCat
extern	BOOL	CipFunStrPart			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrPart
extern	BOOL	CipFunStrRep			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrRep
extern	BOOL	CipFunStrLTrim			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrLTrim
extern	BOOL	CipFunStrRTrim			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrRTrim
extern	BOOL	CipFunStrTrim			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrTrim
extern	BOOL	CipFunStrSplit			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrSplit
extern	BOOL	CipFunStrJoin			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_StrJoin
extern	BOOL	CipFunToDecStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_ToDecStr
extern	BOOL	CipFunToHexStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_ToHexStr
extern	BOOL	CipFunInputStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_Input
extern	BOOL	CipFunHexStrToBinary	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _HexStrToBinary
extern	BOOL	CipFunGetValueByKey		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetValueByKey
extern	BOOL	CipFunGetValues			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetValue

//	問い合わせ
extern	BOOL	CipFunMsgBox			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _MsgBox
extern	BOOL	CipFunPopupMenu			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _PopupMenu

//	メモリブロック
extern	BOOL	CipFunMemAlloc			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _MemAlloc	
extern	BOOL	CipFunMemFree			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _MemFree	
extern	BOOL	CipFunGetMemBlk			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetMemBlk	
extern	BOOL	CipFunPutMemBlk			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _PutMemBlk	
extern	BOOL	CipFunClrMemBlk			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ClrMemBlk	
extern	BOOL	CipFunDumpMemBlk		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _DumpMemBlk

//	ファイル／ディレクトリ
extern	BOOL	CipFunFOpen				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FOpen
extern	BOOL	CipFunFClose			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FClose
extern	BOOL	CipFunFPutStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FPutS
extern	BOOL	CipFunFRead				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FRead
extern	BOOL	CipFunFWrite			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FWrite
extern	BOOL	CipFunFGetSeek			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FGetSeek
extern	BOOL	CipFunFSetSeek			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FSetSeek
extern	BOOL	CipFunFGetStr			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_SFGetS
extern	BOOL	CipFunFDelete			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _FDelete
extern	BOOL	CipFunMakeFolder		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _MakeFolder
extern	BOOL	CipFunPathExists		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _PathExists
extern	BOOL	CipFunPathIsFolder		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _PathIsFolder

//	ファイル名／フォルダ名取得
extern	BOOL	CipFunGetOpenFile		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_GetOpenFile
extern	BOOL	CipFunGetSaveFile		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_GetSaveFile
extern	BOOL	CipFunGetFolder			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_GetFolder
extern	BOOL	CipFunGetMacFilePath	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_GetMacFilePath
extern	BOOL	CipFunSearchFiles		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_SearchFiles
extern	BOOL	CipFunSplitPath			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_SplitPath
extern	BOOL	CipFunMakePath			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_MakePath

//	プロファイルアクセス
extern	BOOL	CipFunSetProfileSect	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetProfileSect
extern	BOOL	CipFunSetProfileVal		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetProfileVal
extern	BOOL	CipFunSetProfileStr		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _SetProfileStr
extern	BOOL	CipFunGetProfileVal		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetProfileVal
extern	BOOL	CipFunGetProfileStr		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	$_GetProfileStr

//	ＣＯＭポートアクセス
extern	BOOL	CipFunComCreate			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComCreate
extern	BOOL	CipFunComCreateByDialog	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComCreateByDialog
extern	BOOL	CipFunComDelete			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComDelete
extern	BOOL	CipFunComOpen			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComOpen
extern	BOOL	CipFunComIsOpenPossible	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComIsOpenPossible
extern	BOOL	CipFunComIsOpened		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComIsOpened
extern	BOOL	CipFunComClose			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComClose
extern	BOOL	CipFunComSendText		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendText
extern	BOOL	CipFunComSendBinary		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendBinary
extern	BOOL	CipFunComSendBytes		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendBytes
extern	BOOL	CipFunComSendPacket		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendPacket
extern	BOOL	CipFunComGetRate		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComGetRate
extern	BOOL	CipFunComGetDataBits	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComGetDataBits
extern	BOOL	CipFunComGetParity		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComGetParity
extern	BOOL	CipFunComGetStopBits	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComGetStopBits
extern	BOOL	CipFunComGetParam		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 $_ComGetParam
extern	BOOL	CipFunComSetDTR			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSetDTR
extern	BOOL	CipFunComSetRTS			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSetRTS
extern	BOOL	CipFunComGetSignal		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComGetSignal

//	ＣＯＭポートイベント登録
extern	BOOL	CipFunComSetOnRxText	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSetOnRxText
extern	BOOL	CipFunComSetOnRxCtrl	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSetOnRxCtrl
extern	BOOL	CipFunComSetOnRxEsc		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSetOnRxEsc
extern	BOOL	CipFunComSetOnRxPacket	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSetOnRxPacket

//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭ
extern	BOOL	CipFunComSendXModemSum	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendXModemSum
extern	BOOL	CipFunComSendXModemCrc	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendXModemCrc
extern	BOOL	CipFunComSendXModem1K	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendXModem1K
extern	BOOL	CipFunComRecvXModemSum	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComRecvXModemSum
extern	BOOL	CipFunComRecvXModemCrc	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComRecvXModemCrc
extern	BOOL	CipFunComRecvXModem1K	(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComRecvXModem1K
extern	BOOL	CipFunComSendYModem		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComSendYModem
extern	BOOL	CipFunComRecvYModem		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ComRecvYModem

//	イベント禁止／許可
extern	BOOL	CipFunDisStdEvt			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _DisStdEvt
extern	BOOL	CipFunEnaStdEvt			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _EnaStdEvt
extern	BOOL	CipFunGetDisStdEvt		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetDisStdEvt
extern	BOOL	CipFunDisComEvt			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _DisComEvt
extern	BOOL	CipFunEnaComEvt			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _EnaComEvt
extern	BOOL	CipFunGetDisComEvt		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetDisComEvt


//	タイムチャートグラフ
extern	BOOL	CipFunTmcOpen			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcOpen
extern	BOOL	CipFunTmcSetItems		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcSetItems
extern	BOOL	CipFunTmcSetRange		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcSetRange
extern	BOOL	CipFunTmcPutData		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcPutData
extern	BOOL	CipFunTmcClear			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcClear
extern	BOOL	CipFunTmcWndMove		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcWndMove
extern	BOOL	CipFunTmcWndSize		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcWndSize
extern	BOOL	CipFunTmcClose			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _TmcClose

//	ボタン
extern	BOOL	CipFunBtnOpen			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _BtnOpen
extern	BOOL	CipFunBtnClose			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _BtnClose
extern	BOOL	CipFunBtnEnable			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _BtnEnable

//	チェックボックス
extern	BOOL	CipFunChkBoxOpen		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ChkBoxOpen
extern	BOOL	CipFunChkBoxClose		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ChkBoxClose
extern	BOOL	CipFunChkBoxGetSts		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ChkBoxGetSts
extern	BOOL	CipFunChkBoxSetSts		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ChkBoxSetSts
extern	BOOL	CipFunChkBoxEnable		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ChkBoxEnable

//	その他
extern	BOOL	CipFunShowText			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _ShowText
extern	BOOL	CipFunGetWndPosX		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetWndPosX
extern	BOOL	CipFunGetWndPosY		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetWndPosY
extern	BOOL	CipFunGetWndWidth		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetWndWidth
extern	BOOL	CipFunGetWndHeight		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetWndHeight
extern	BOOL	CipFunGetCharWidth		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetCharWidth
extern	BOOL	CipFunGetCharHeight		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetCharHeight
extern	BOOL	CipFunGetLineHeight		(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _GetLineHeight
extern	BOOL	CipFunExit				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	 _Exit

//	デバッグ機能
extern	BOOL	CipFunVarDump			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	_VarDump
extern	BOOL	CipFunTrace				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	_Trace
extern	BOOL	CipFunPause				(HAJCCIP pW, PCAJCCIPCALL pCall);		//	_Pause
extern	BOOL	CipFunStepTrace			(HAJCCIP pW, PCAJCCIPCALL pCall);		//	_StepTrace

extern	VO			ShowPauseDialog	(HAJCCIP pW);
extern	PAJCCIPAGV	*MakeArgInfo	(HAJCCIP pW, PCAJCCIPCALL pCall);

/****************************************************************************************************************/
#endif
