﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ（数式評価用サブ関数）																	//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetCallInfo	(HAJCCIP pW, PAJCCIPCALL pCallInfo, BOOL fCalculation);
static	BOOL	GetVarInfo		(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation);
static	BOOL	SubGetVarInf	(HAJCCIP pW, PAJCCIPTKN pSymTkn, SLL ix, PAJCCIPVARINFO pVi);

//==============================================================================================================//
//	文字式の評価																								//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				pVal		 - 文字比較式の評価値を格納するバッファのアドレス									//
//				fCalculation - 計算フラグ - CALCULATION(=TRUE)	: 関数を実行する								//
//											SYNTAX_ONLY(=FALSE) : シンタックスチェックのみ						//
//																												//
//	戻り値	：	TRUE ：成功																						//
//				FALSE：失敗																						//
//																												//
//	備　考	：	pW->pCur - 入力時：文字式先頭トークン															//
//						   終了時：文字式の直後のトークン														//
//==============================================================================================================//
#define	ISOP_STRCMP(TKN)	((TKN) == EAJCTK_DLM_EQEQ	||	\
							 (TKN) == EAJCTK_DLM_NOTEQ	||	\
							 (TKN) == EAJCTK_DLM_LO		||	\
							 (TKN) == EAJCTK_DLM_HI 	||	\
							 (TKN) == EAJCTK_DLM_LOEQ 	||	\
							 (TKN) == EAJCTK_DLM_HIEQ)
//-------------------------------------------------------------------------------------------------------------//
BOOL	CipFmlStr(HAJCCIP pW, SLL *pVal, BOOL fCalculation)
{
	BOOL		rc	  = FALSE;					//	戻り値
	PCAJCCIPTKN	pSym1 = NULL, pSym2 = NULL;		//	両辺のシンボル名トークン
	PCAJCCIPTKN	pOpe  = NULL;					//	演算子
	PCAJCCIPTKN	pNxt  = NULL;					//	次のトークンポインタワーク
	C_BCP			pStr1 = NULL, pStr2 = NULL;	//	両辺の文字列
	AJCCIPVARINFO	vInf1, vInf2;				//	両辺の変数情報
	BOOL			fVar = FALSE;				//	左辺が変数であることを示すフラグ

	do {
		//----- 左辺の文字列取得 -------------------------------------//
		if (IS_STR_SYM(pW->pCur)) {
			pSym1 = pW->pCur;
			pNxt  = pW->pCur + 1;
			//	関数
			if (pNxt->tkn == EAJCTK_DLM_LSPART) {
				vInf1.hVmg = pW->sFni[0].hVmg;
				vInf1.pSym = "$@rc1";
				vInf1.ix   = 0;
				if (!CipFmlCallFunc(pW, &vInf1, fCalculation)) {
					break;
				}
				pStr1 = AjcVmgGetStringA(vInf1.hVmg, "$@rc1", 0);
			}
			//	変数
			else {
				fVar = TRUE;
				if (fCalculation) {
					if ((pStr1 = CipFmlGetVarInfoStr(pW, &vInf1, fCalculation)) == NULL) {
						break;
					}
				}
				else {
					pW->pCur++;		//	変数スキップ
				}
			}
		}
		else if (pW->pCur->tkn == EAJCTK_CIP_STRING) {
			pStr1 = pW->pCur->u.pStr;		//	文字列設定
			pW->pCur++;						//	文字列スキップ
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("文字式の表現に誤りがあります。",
											 "Missing string formula."));
			break;
		}
		//----- 演算子トークン退避，スキップ -------------------------//
		pOpe = pW->pCur;
		//----- 文字列演算子以外ならば、文字列値を設定 ---------------//
		if (!((ISOP_STRCMP(pOpe->tkn) || (fVar && pOpe->tkn == EAJCTK_DLM_EQ)))) {
			//	演算子以外の場合は、文字列１の内容で戻り値を設定し、終了
			int		sl	= sizeof(*pVal);
			int		dl	= (int)strlen(pStr1);
			int		len = __min(sl, dl);
			C_BCP	sp	= pStr1;
			BCP		dp	= ((BCP)pVal) + (len - 1);
			*pVal = 0;
			while (len-- > 0) {
				*dp-- = *sp++;
			}
			rc = TRUE;
			break;
		}
		//----- 文字列演算子スキップ ---------------------------------//
		pW->pCur++;
		//----- 右辺の文字列取得 -------------------------------------//
		if (IS_STR_SYM(pW->pCur)) {
			pSym2 = pW->pCur;
			pNxt  = pW->pCur + 1;
			//	関数
			if (pNxt->tkn == EAJCTK_DLM_LSPART) {
				vInf2.hVmg = pW->sFni[0].hVmg;
				vInf2.pSym = "$@rc2";
				vInf2.ix   = 0;
				if (!CipFmlCallFunc(pW, &vInf2, fCalculation)) {
					break;
				}
				pStr2 = AjcVmgGetStringA(vInf2.hVmg, "$@rc2", 0);
			}
			//	変数
			else {
				if (fCalculation) {
					if ((pStr2 = CipFmlGetVarInfoStr(pW, &vInf2, fCalculation)) == NULL) {
						break;
					}
				}
				else {
					pW->pCur++;		//	変数スキップ
				}
			}
		}
		else if (pW->pCur->tkn == EAJCTK_CIP_STRING) {
			pStr2 = pW->pCur->u.pStr;		//	文字列設定
			pW->pCur++;						//	文字列スキップ
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
									  LNGSEL("文字式の表現に誤りがあります。",
											 "Missing string formula."));
			break;
		}
		if (fCalculation) {
			//----- 比較演算実行 -----------------------------------------//
			if (ISOP_STRCMP(pOpe->tkn)) {
				switch (pOpe->tkn) {
					case EAJCTK_DLM_EQEQ:	*pVal = (mbscmp(pStr1, pStr2) == 0);	break;
					case EAJCTK_DLM_NOTEQ:	*pVal = (mbscmp(pStr1, pStr2) != 0);	break;
					case EAJCTK_DLM_LO:		*pVal = (mbscmp(pStr1, pStr2) <  0);	break;
					case EAJCTK_DLM_HI:		*pVal = (mbscmp(pStr1, pStr2) >  0);	break;
					case EAJCTK_DLM_LOEQ:	*pVal = (mbscmp(pStr1, pStr2) <= 0);	break;
					case EAJCTK_DLM_HIEQ:	*pVal = (mbscmp(pStr1, pStr2) >= 0);	break;
				}
				rc = TRUE;
			}
			//----- 文字列転送 -------------------------------------------//
			else if (fVar) {
				if (rc = CipVmgSetString(pW, pOpe->lno, vInf1.hVmg, vInf1.pSym, vInf1.ix, pStr2)) {
					*pVal = (*pStr2 != 0);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
										  LNGSEL("文字式の表現に誤りがあります。",
												 "Missing string formula."));
			}
		}
		else {
			*pVal = 1;
			rc	  = TRUE;
		}
	} while(0);

	return rc;
}
//==============================================================================================================//
//	関数の呼び出し（マクロ-トークンによる関数呼び出し）															//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				pVi			 - 関数戻り値を格納する変数の情報（NULL:変数無し）									//
//				fCalculation - 計算フラグ - CALCULATION(=TRUE)	: 関数呼び出しを実行する						//
//											SYNTAX_ONLY(=FALSE) : シンタックスチェックのみ						//
//																												//
//	戻り値	：	TRUE  - 関数の呼び出し成功																		//
//				FALSE - 関数の呼び出しでエラー発生																//
//																												//
//	入　力	：	pW->pCur - トークン先頭（関数名）																//
//																												//
//	出　力	：	pW->pCur - 戻り値＝TRUE時  - 構文の直後のトークン（ 'func(・・)' の次）							//
//==============================================================================================================//
BOOL	CipFmlCallFunc(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation)
{
	BOOL		rc	 = FALSE;
	PAJCCIPTKN	pTop = pW->pCur;
	AJCCIPCALL	CallInfo;

	pW->ixIfNest++;

	if (pW->pCur->tkn == EAJCTK_USR_NAME) {					//	'Symbol' ？
		//	関数呼び出し情報クリアー
		memset(&CallInfo, 0, sizeof CallInfo);
		//	関数呼び出し
		do {
			//	引数情報キューインスタンス生成
			if ((CallInfo.hQueAgv = AjcFQueCreate(sizeof(AJCCIPAGV), 0, NULL)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pTop->lno,
											  LNGSEL("関数呼び出しに関する引数用ワークの確保に失敗しました。",
													 "Arguments work in function call allocation failure."));
				break;
			}
			//	戻り変数情報設定
			if (pVi != NULL) {
				CallInfo.rchVmg = pVi->hVmg;
				CallInfo.rcpSym = pVi->pSym;
				CallInfo.rcIx	= pVi->ix;
			}
			//	関数呼び出し情報設定
			if (!SubSetCallInfo(pW, &CallInfo, fCalculation)) {
				break;
			}
			//	関数呼び出し実行
			if (fCalculation) {
				if (pW->fRunReady) {
					rc = CipExeFuncCall(pW, &CallInfo, pTop);
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pTop->lno,
												  LNGSEL("関数を実行できません。",
														 "Do not execute the function."));
				}
			}
			else {
				rc = TRUE;	//	シンタクスチェック時は関数を実行せずにＯＫを返す
			}
		} while(0);

		//	関数呼び出し情報破棄
		if (CallInfo.hQueAgv != NULL) {
			AjcFQueDelete(CallInfo.hQueAgv);
			CallInfo.hQueAgv = NULL;
		}
	}
	pW->ixIfNest--;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetCallInfo(HAJCCIP pW, PAJCCIPCALL pCallInfo, BOOL fCalculation)
{
	BOOL			rc = FALSE;
	AJCCIPAGV		agv;
	PCAJCVMGNODEA	pArgNode;
	UI				ixFuncArg = 0;

	do {
		//	関数名設定
		pCallInfo->pFunName = pW->pCur->u.pStr;
		//	行番号設定
		pCallInfo->lno		= pW->pCur->lno;
		//	関数名スキップ
		pW->pCur++;
		//	'(' スキップ
		pW->pCur++;

		//	引数情報設定
		pCallInfo->nArg = 0;
		while (pW->pCur->tkn != EAJCTK_DLM_RSPART &&pW->pCur->tkn != EAJCTK_EOF) {	// ')', EOF 以外
			PAJCCIPTKN pNx1 = pW->pCur + 1;
			PAJCCIPTKN pNx2 = pW->pCur + 2;
			//	引数情報クリアー
			memset(&agv, 0, sizeof agv);
			//	引数番号設定
			agv.seq = pCallInfo->nArg;
			//	配列指定チェック
			if (pW->pCur->tkn == EAJCTK_USR_NAME && pNx1->tkn == EAJCTK_DLM_LLPART && pNx2->tkn == EAJCTK_DLM_RLPART) {	//	'var[]' ？
				HAJCVMGA	hVmgS	 = NULL;
				PAJCCIPTKN	pSym	 = pW->pCur;
				//	引数タイプ設定
				if (*pW->pCur->u.pStr == '$') agv.typ = AJCIPT_STRING;
				else						  agv.typ = pW->NumType;
				//	配列フラグ設定
				agv.fArr = TRUE;
				//	配列変数インスタンス，変数名設定
				if (fCalculation) {
					if (agv.val.arr.hVmg  = CipFmlGetVarInst(pW, pSym)) {
						agv.val.arr.pName = pSym->u.pStr;
						//	'var[]' スキップ
						pW->pCur = pNx2 + 1;
					}
					else {
						break;		//	エラーならば、終了
					}
				}
				else {
					//	'var[]' スキップ
					pW->pCur = pNx2 + 1;
				}
			}
			//	文字変数／文字関数
			else if (IS_STR_SYM(pW->pCur)) {
				//	文字関数
				if (pNx1->tkn == EAJCTK_DLM_LSPART) {
					AJCCIPVARINFO	vInf;
					BC				ArgName[20];
					//	引数用の内部変数作成
					AjcSnPrintFA(ArgName, sizeof ArgName, "$@arg%d%d", pW->ixIfNest, ixFuncArg);
					ixFuncArg++;
					if ((pArgNode = AjcVmgGetNodeA(pW->sFni[pW->ixFni].hVmg, ArgName)) == NULL) {	//	当該変数無し？
						//	文字変数作成
						if (!CipVmgGenVar(pW, pCallInfo->lno, pW->sFni[pW->ixFni].hVmg, ArgName, AJCVMGT_STR, 1)) {
							break;
						}
						pArgNode = (PCAJCVMGNODEA)AjcVmgGetNodeA(pW->sFni[pW->ixFni].hVmg, ArgName);
					}
					//	引数情報設定
					vInf.hVmg = pW->sFni[pW->ixFni].hVmg;
					vInf.pSym = pArgNode->pName;
					vInf.ix   = 0;
					if (!CipFmlCallFunc(pW, &vInf, fCalculation)) {
						break;
					}
					agv.typ 	 = AJCIPT_STRING;
					agv.val.pStr = AjcVmgGetStringA(vInf.hVmg, ArgName, 0);
				}
				//	文字変数
				else {
					AJCCIPVARINFO	vInf;
					agv.typ 	 = AJCIPT_STRING;
					if (fCalculation) {
						if (GetVarInfo(pW, &vInf, fCalculation)) {
							agv.val.pStr = AjcVmgGetStringA(vInf.hVmg, vInf.pSym, vInf.ix);
						}
						else {
							break;
						}
					}
					else {
						//	文字変数スキップ
						pW->pCur++;
					}
				}
			}
			//	文字列
			else if (pW->pCur->tkn == EAJCTK_CIP_STRING) {
				agv.typ 	 = AJCIPT_STRING;
				agv.val.pStr = pW->pCur->u.pStr;
				pW->pCur++;			//	文字列スキップ
			}
			//	数式
			else {
				agv.typ = pW->NumType;
				switch (pW->NumType) {
					case AJCIPT_INTEGER: CipFmlINT(pW, &agv.val.sll, fCalculation);	break;
					case AJCIPT_REAL:	 CipFmlDBL(pW, &agv.val.dbl, fCalculation);	break;
				}
				//	エラーならば終了
				if (pW->ErrCod != AJCIP_ERR_OK) break;
			}
			//	引数ノード追加
			AjcFQueEnque(pCallInfo->hQueAgv, &agv);
			pCallInfo->nArg++;
			//	',' スキップ
			if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {
				if (pW->pCur->tkn == EAJCTK_DLM_COMMA) {
					pW->pCur++;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
												  LNGSEL("関数 <%s> 呼び出しの引数が ',' で区切られるか、 ')' で閉じられていません。",
														 "Missing ',' or Not closed by ')' in arguments of function <%s>."), pCallInfo->pFunName);
					break;
				}
			}
		}
		//	エラーならば終了
		if (pW->ErrCod != AJCIP_ERR_OK) break;
		//	')' チェック
		if (pW->pCur->tkn != EAJCTK_DLM_RSPART) {		//	')' 以外？
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
										  LNGSEL("関数 <%s> 呼び出しの引数が ')' で閉じられていません。",
												 "Not closed by ')' in arguments of function <%s>."), pCallInfo->pFunName);
			break;
		}
		pW->pCur++;										//	')' スキップ
		//	戻りアドレス設定
		pCallInfo->pReturn = pW->pCur;
		//	戻り値＝ＯＫ
		rc = TRUE;
	} while(0);

	return rc;
}
//==============================================================================================================//
//	変数情報取得																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pVi			- 変数情報格納バッファのアドレス													//
//				pVal		- 変数タイプ＆値 格納バッファのアドレス												//
//				fCalculation - 計算フラグ - CALCULATION(=TRUE)	: 配列インデクスを計算する						//
//											SYNTAX_ONLY(=FALSE) : シンタックスチェックのみ						//
//																												//
//	戻り値	：	変数の値（整数／実数／文字列へのポインタ）														//
//																												//
//	pW->pCur	:	入力 - 変数表現の先頭トークン（変数名）														//
//					出力 - 変数表現の次のトークン																//
//==============================================================================================================//
SLL		CipFmlGetVarInfoInt64(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation)
{
	SLL			rc	 = 1;
	PAJCCIPTKN	pSym = pW->pCur;

	if (GetVarInfo(pW, pVi, fCalculation)) {
		if (fCalculation) {
			if (!AjcVmgGetInt64A(pVi->hVmg, pVi->pSym, pVi->ix, &rc)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSym->lno,
										  LNGSEL("数値変数 <%s> の表現に誤りがあります。",
												 "Missing expression in numeric variable <%s>."), pSym->u.pStr);
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
double	CipFmlGetVarInfoReal (HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation)
{
	double		rc	 = 1.0;
	PAJCCIPTKN	pSym = pW->pCur;

	if (GetVarInfo(pW, pVi, fCalculation)) {
		if (fCalculation) {
			if (!AjcVmgGetRealA(pVi->hVmg, pVi->pSym, pVi->ix, &rc)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSym->lno,
										  LNGSEL("数値変数 %s> の表現に誤りがあります。",
												 "Missing expression in numeric variable <%s>."), pSym->u.pStr);
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
C_BCP		CipFmlGetVarInfoStr  (HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation)
{
	C_BCP		rc = NULL;
	PAJCCIPTKN	pSym = pW->pCur;

	if (GetVarInfo(pW, pVi, fCalculation)) {
		if (fCalculation) {
			if ((rc = AjcVmgGetStringA(pVi->hVmg, pVi->pSym, pVi->ix)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSym->lno,
										  LNGSEL("文字変数 <%s> の表現に誤りがあります。",
												 "Missing expression in string variable <%s>."), pSym->u.pStr);
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	GetVarInfo(HAJCCIP pW, PAJCCIPVARINFO pVi, BOOL fCalculation)
{
	BOOL		rc = FALSE;
	SLL			ix;
	PAJCCIPTKN	pSymTkn;

	//	シンボル退避
	pSymTkn = pW->pCur;
	//	次の語句ポインタ設定（ シンボルをスキップ）
	pW->pFml = pW->pCur++;
	//	配列変数？
	if (pW->pCur->tkn == EAJCTK_DLM_LLPART) {				//	'[' ？
		//	次の語句ポインタ設定＆ＥＯＦチェック
		if (CipFmlSkipToken(pW) != EAJCTK_EOF) {			//	EOF以外？
			//	配列要素番号設定
			if (CipFmlINT(pW, &ix, fCalculation)) {			//	数式評価，ＯＫ？
				//	演算後の語句が ']' ならばスキップし値設定
				if (pW->pCur->tkn == EAJCTK_DLM_RLPART) {	//	']' ？
					//	次の語句ポインタ設定（ ']' をスキップ）
					pW->pFml = pW->pCur++;
					//	配列変数値設定
					if (fCalculation) {
						rc = SubGetVarInf(pW, pSymTkn, ix, pVi);
					}
					else rc = TRUE;
				}
				//	演算後の語句が ']' 以外ならばエラー
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
											  LNGSEL("<%s> の前に ']' が必要です。",
													 "Need ']' before <%s>."), CipGsrTknStr(pW->pCur));
				}
			}
		}
	}
	//	単純変数？
	else {
		//	単純変数値設定
		if (fCalculation) {
			rc = SubGetVarInf(pW, pSymTkn, 0, pVi);
		}
		else rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubGetVarInf(HAJCCIP pW, PAJCCIPTKN pSymTkn, SLL ix, PAJCCIPVARINFO pVi)
{
	BOOL			rc = FALSE;
	PCAJCVMGNODEA	pNode;

	do {
		//	自動変数値取得
		if (pW->ixFni != 0) {
			if (pNode = AjcVmgGetNodeA(pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr)) {
				if (pNode->num > ix) {
					//	変数情報退避
					pVi->hVmg = pW->sFni[pW->ixFni].hVmg;
					pVi->pSym = pSymTkn->u.pStr;
					pVi->ix   = (UI)ix;
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, pW->pCur->lno,
										LNGSEL("配列インデクス値(%d)が大きすぎます。",
											   "Over array index value (%d)."), (UI)ix);
				}
				break;
			}
		}
		//	静的変数値取得
		if (pNode = AjcVmgGetNodeA(pW->sFni[0].hVmg, pSymTkn->u.pStr)) {
			if (pNode->num > ix) {
				//	変数情報退避
				pVi->hVmg = pW->sFni[0].hVmg;
				pVi->pSym = pSymTkn->u.pStr;
				pVi->ix   = (UI)ix;
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, pW->pCur->lno,
									LNGSEL("配列インデクス値(%d)が大きすぎます。",
										   "Over array index value (%d)."), (UI)ix);
			}
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, pSymTkn->lno,
								LNGSEL("変数 <%s> は定義されていません。",
									   "Undefined Variable <%s>."), CipGsrTknStr(pSymTkn));
		}
	} while(0);

	return rc;
}

//==============================================================================================================//
//	実行（変数のインスタンス取得）																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pSymTkn		- シンボルトークン																	//
//																												//
//	戻り値	：	≠NULL:正常（変数管理インスタンス）																//
//				＝NULL:エラー																					//
//																												//
//	入	力	：	pW->pCur - シンボルトークン																		//
//==============================================================================================================//
static	HAJCVMGA	CipFmlGetVarInst(HAJCCIP pW, PAJCCIPTKN pSymTkn)
{
	HAJCVMGA		rc = NULL;
	PCAJCVMGNODEA	pNode;

	do {
		//	自動変数インスタンス取得
		if (pW->ixFni != 0) {
			if (pNode = AjcVmgGetNodeA(pW->sFni[pW->ixFni].hVmg, pSymTkn->u.pStr)) {
				rc = pW->sFni[pW->ixFni].hVmg;
				break;
			}
		}
		//	静的変数インスタンス取得
		if (pNode = CipVmgGetNode(pW, pSymTkn->lno, pW->sFni[0].hVmg, pSymTkn->u.pStr)) {
			rc = pW->sFni[0].hVmg;
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pSymTkn->lno,
								LNGSEL("変数 <%s> は定義されていません。",
									   "Undefined Variable <%s>."), CipGsrTknStr(pSymTkn));
		}
	} while(0);

	return rc;
}
//==============================================================================================================//
//	語句をスキップしＥＯＦチェック（ＥＯＦならばエラー）														//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	次のトークンのコード																			//
//																												//
//	pW->pCur	:	入力 - 現在のトークン																		//
//					出力 - 次のトークン																			//
//==============================================================================================================//
EAJCTKCODE	CipFmlSkipToken(HAJCCIP pW)
{
	EAJCTKCODE	rc;

	if (pW->pCur->tkn != EAJCTK_EOF) {				//	語句はＥＯＦ以外？
		pW->pFml = pW->pCur++;
		rc = pW->pCur->tkn;
	}
	if (pW->pCur->tkn == EAJCTK_EOF) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pW->pCur->lno,
							LNGSEL("数式の途中でＥＯＦを検出しました。",
								   "EOF was detected in the formula expression."));
		rc = EAJCTK_EOF;
	}
	return rc;
}
