﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ（内臓関数群）																			//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubFunPItem		 (HAJCCIP pW, PCAJCCIPCALL pCall, BCP pBuf, UI lBuf);
static	BOOL	SubFunPHexa		 (HAJCCIP pW, PCAJCCIPCALL pCall, BCP pBuf, UI lBuf);


static	BOOL			GetSIntByNode	(HAJCCIP pW, PAJCCIPAGV pNode, SLLP pSll   , PCAJCCIPCALL pCall);
static	BOOL			GetRealByNode	(HAJCCIP pW, PAJCCIPAGV pNode, double *pDbl, PCAJCCIPCALL pCall);
static	C_BCP			GetStrByNode	(HAJCCIP pW, PAJCCIPAGV pNode, PCAJCCIPCALL pCall);
static	BOOL			SubSPrintF		(HAJCCIP pW, PCAJCCIPCALL pCall, BCP pBuf, UI lBuf);

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	エラーメッセージ表示／エラーチェック																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------//
//	エラー：引数の個数が不正です。																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	Err_InvalidArguments(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
							  LNGSEL("%s - 引数の個数が不正です。",
									 "%s - Invalid number of arguments."), pCall->pFunName);
}
//--------------------------------------------------------------------------------------------------------------//
//	ポート番号チェック																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	ChkPortNumber(HAJCCIP pW, PCAJCCIPCALL pCall, ULL port, ULL MinVal, ULL MaxVal)
{
	BOOL	rc;

	if (port >= MinVal && port <= MaxVal) {
		rc = TRUE;
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
								  LNGSEL("%s - ポート番号が不正です。",
										 "%s - Invalid port number."), pCall->pFunName);
		rc = FALSE;
	}
	return rc;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	オプション設定																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	右クリックによる標準のポップアップメニューの許可／禁止	_EnableStdRClk(fEnable)								//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunEnableStdRClk(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				fEnable;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fEnable , pCall))) break;
			//	標準右クリックによるポップアップメニューの許可／禁止
			AjcVthSetNtcRClk(pW->hWndVth, (BOOL)!fEnable, WM_ON_RCLICK, 0);
			//	許可状態設定
			pW->fExeEnaStdPopupMenu = (BOOL)fEnable;
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	自動スクロールの許可／禁止	_EnableAutoScroll(fEnable)														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunEnableAutoScroll(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				fEnable;
	UI				sty;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fEnable , pCall))) break;
			//	自動スクロールの許可／禁止
			sty = (UI)MAjcGetWindowLong(pW->hWndVth, GWL_STYLE);
			if (fEnable) sty &= ~AJCVTHS_NOSCRL;
			else		 sty |=  AJCVTHS_NOSCRL;
			MAjcSetWindowLong(pW->hWndVth, GWL_STYLE, sty);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	スクリーン情報																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ＶＲＡＭサイズ設定	_SetVramSize(width, height);															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetVramSize		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				cx, cy;
	AJCVTHPROP		prop;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&cx , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&cy , pCall))) break;
			//	ＶＲＡＭサイズ設定
			AjcVthGetProp(pW->hWndVth, &prop);
			prop.VramW = (UI)cx;
			prop.VramH = (UI)cy;
			AjcVthSetProp(pW->hWndVth, &prop);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	スクロールバッファ行数設定	_SetBufLines(lines);															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetBufLines		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				lines;
	AJCVTHPROP		prop;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&lines , pCall))) break;
			//	スクロールバッファ行数設定
			AjcVthGetProp(pW->hWndVth, &prop);
			prop.MaxLines = (UI)lines;
			AjcVthSetProp(pW->hWndVth, &prop);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	VRAMの幅（半角文字数）取得	_GetVramWidth();																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetVramWidth		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	AJCVTHPROP		prop;

	if (pCall->nArg == 0) {
		do {
			//	VRAMの幅を返す
			if (pCall->rchVmg != NULL) {
				AjcVthGetProp(pW->hWndVth, &prop);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, prop.VramW)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	VRAMの高さ（行数）取得		_GetVramHeight();																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetVramHeight		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	AJCVTHPROP		prop;

	if (pCall->nArg == 0) {
		do {
			//	VRAMの高さを返す
			if (pCall->rchVmg != NULL) {
				AjcVthGetProp(pW->hWndVth, &prop);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, prop.VramH)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	スクロールバッファ行数取得	_GGetBufLines();																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetBufLines		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	AJCVTHPROP		prop;

	if (pCall->nArg == 0) {
		do {
			//	スクロールバッファ行数を返す
			if (pCall->rchVmg != NULL) {
				AjcVthGetProp(pW->hWndVth, &prop);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, prop.MaxLines)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	表示出力																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	書式プリント		_PrintF($Fmt [,arg] ・・・);															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPrintF			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[1024];

	if (rc = SubSPrintF(pW, pCall, txt, sizeof txt)) {
		//	作成した文字列を表示
		AjcVthPutTextA(pW->hWndVth, txt, -1);
		//	戻り値＝正常
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	プリント		_Print(item1[, item2] ・・);																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPrint			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	UI			i;

	if (ppAgv = MakeArgInfo(pW, pCall)) {
		for (i = 0; i < pCall->nArg; i++) {
			if (!ppAgv[i]->fArr) {
				switch (ppAgv[i]->typ) {
					case AJCIPT_INTEGER:
						if (pW->fSigned) AjcCipPrintF(pW->hWndBack, "%lld", ppAgv[i]->val.sll);
						else			 AjcCipPrintF(pW->hWndBack, "%llu", ppAgv[i]->val.sll);
						break;

					case AJCIPT_REAL:
						AjcCipPrintF(pW->hWndBack, "%f", ppAgv[i]->val.dbl);
						break;

					case AJCIPT_STRING:
						AjcCipPrintF(pW->hWndBack, "%s", ppAgv[i]->val.pStr);
						break;
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - %d番目の引数に配列は指定できません。",
												 "%s - Can not specify array in %d[th] argument."), pCall->pFunName, i + 1);
				break;
			}
		}
		rc = (i == pCall->nArg);
		free(ppAgv);
	}
	return rc;
}
//==============================================================================================================//
//	項目の書式プリント（１０進）	_Pd(item [,len] [,lup] );													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPItem			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[512] = {0};

	if (rc = SubFunPItem(pW, pCall, txt, sizeof txt)) {
		AjcVthPutTextA(pW->hWndVth, txt, -1);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	書式文字列作成（１０進数）
static	BOOL	SubFunPItem			(HAJCCIP pW, PCAJCCIPCALL pCall, BCP pBuf, UI lBuf)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			len    = 0;
	SLL			lup    = 0;
	BC			fmt[64];

	if (pCall->nArg >= 1 && pCall->nArg <= 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	桁数設定
			if (pCall->nArg >= 2) {
				if (!GetSIntByNode(pW, ppAgv[1], &len, pCall)) {
					break;
				}
			}
			if (pCall->nArg >= 3) {
				if (!GetSIntByNode(pW, ppAgv[2], &lup, pCall)) {
					break;
				}
			}
			//	桁数を256以内とする
			len %= 256;
			lup %= 256;
			//	書式文字列設定，プリント
			switch (ppAgv[0]->typ) {
				case AJCIPT_INTEGER:
					if (pW->fSigned) AjcSnPrintFA(fmt, sizeof fmt, "%%%lldlld", len);
					else			 AjcSnPrintFA(fmt, sizeof fmt, "%%%lldllu", len);
					AjcSnPrintFA(pBuf, lBuf, fmt, ppAgv[0]->val.sll);
					break;

				case AJCIPT_REAL:
					if		(pCall->nArg == 1) AjcSnPrintFA(fmt, sizeof fmt, "%%f"					);
					else if (pCall->nArg == 2) AjcSnPrintFA(fmt, sizeof fmt, "%%%lldf"	  , len 	);
					else if (pCall->nArg == 3) AjcSnPrintFA(fmt, sizeof fmt, "%%%lld.%lldf", len, lup);
					AjcSnPrintFA(pBuf, lBuf, fmt, ppAgv[0]->val.dbl);
					break;

				case AJCIPT_STRING:
					AjcSnPrintFA(fmt, sizeof fmt, "%%%llds", len);
					AjcSnPrintFA(pBuf, lBuf, fmt, ppAgv[0]->val.pStr);
					break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	項目の書式プリント（１６進）	_Ph(item [,len] );															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPHexa			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[512] = {0};

	if (rc = SubFunPHexa(pW, pCall, txt, sizeof txt)) {
		AjcVthPutTextA(pW->hWndVth, txt, -1);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	書式文字列作成（１６進数）
static	BOOL	SubFunPHexa			(HAJCCIP pW, PCAJCCIPCALL pCall, BCP pBuf, UI lBuf)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			len    = 0;
	BC			fmt[64];

	if (pCall->nArg >= 1 && pCall->nArg <= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	桁数設定
			if (pCall->nArg >= 2) {
				if (!GetSIntByNode(pW, ppAgv[1], &len, pCall)) {
					break;
				}
			}
			//	桁数を256以内とする
			len %= 256;
			//	書式文字列設定，プリント
			switch (ppAgv[0]->typ) {
				case AJCIPT_INTEGER:
					if (pW->fSigned) AjcSnPrintFA(fmt, sizeof fmt, "%%0%lldllX", len);
					else			 AjcSnPrintFA(fmt, sizeof fmt, "%%0%lldllX", len);
					AjcSnPrintFA(pBuf, lBuf, fmt, ppAgv[0]->val.sll);
					break;

				case AJCIPT_REAL:
					if		(pCall->nArg == 1) AjcSnPrintFA(fmt, sizeof fmt, "%%llX"			);
					else if (pCall->nArg == 2) AjcSnPrintFA(fmt, sizeof fmt, "%%0%lldllX", len);
					AjcSnPrintFA(pBuf, lBuf, fmt, (SLL)ppAgv[0]->val.dbl);
					break;

				case AJCIPT_STRING:
					AjcSnPrintFA(fmt, sizeof fmt, "%%%llds", len);
					AjcSnPrintFA(pBuf, lBuf, fmt, ppAgv[0]->val.pStr);
					break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	描画位置設定		_Locate(x, y);																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunLocate			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				x, y;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&x , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&y , pCall))) break;
			//	描画位置設定
			AjcVthLocate(pW->hWndVth, (UI)y, (UI)x);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	画面クリアー	_Cls();																						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunCls				(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;

	if (pCall->nArg == 0) {
		//	画面クリアー
		AjcVthClearAllText(pW->hWndVth);
		//	描画色リセット
		AjcVthSetColor	(pW->hWndVth, 0);
		AjcVthSetBkColor(pW->hWndVth, 7);
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	テキスト表示色設定	_SetTextColor(color);																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetTextColor			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				color;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&color , pCall))) break;
			//	テキスト表示色設定
			AjcVthSetColor(pW->hWndVth, (UI)(color & 7));
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	テキスト背景色設定	_SetBackColor(color);																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetBackColor			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				color;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&color , pCall))) break;
			//	テキスト表示色設定
			AjcVthSetBkColor(pW->hWndVth, (UI)(color & 7));
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	テキスト描画色リセット	_ResetColor(color);																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunResetColor			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;

	if (pCall->nArg == 0) {
		//	描画色リセット
		AjcVthSetColor	(pW->hWndVth, 0);
		AjcVthSetBkColor(pW->hWndVth, 7);
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	配列操作																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	配列の要素数取得	_Elements(arr[]);																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunElements	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	UI			nElement;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	要素数取得
			if (ppAgv[0]->fArr) {
				if ((nElement = CipVmgGetArrNum(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == 0) {
					break;
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - 引数には配列( ex. var[] )を指定してください。",
												 "%s - Must be argument to arrangement( ex. var[] )."), pCall->pFunName);
				break;
			}
			//	要素数を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, nElement)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	配列生成（配列の型は、戻り値を受ける変数に依存）															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMakeArray		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			n	   = 0;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!GetSIntByNode(pW, ppAgv[0], &n, pCall)) break;
			//	配列作成
			if (pCall->rchVmg != NULL) {
				PCAJCVMGNODEA	pVmgNode = NULL;
				EAJCCIPTYP		typ;
				if ((pVmgNode = CipVmgGetNode(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) == NULL) break;
				typ = (EAJCCIPTYP)pVmgNode->type;
				if (!CipVmgDelVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) break;
				if (!CipVmgGenVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, typ, (UI)n)) break;
			}
			else rc = TRUE;	//	戻り値を受ける変数が無い場合はＯＫとする
		} while(0);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	整数演算																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ＣＲＣ算出	_CalcCrc(kind, MemBlkNo, loc, len, ini)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunCalcCrc(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				knd, bno, loc, len, ini = 0;
	UW				crc;

	if (pCall->nArg == 4 || pCall->nArg == 5) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
									if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&knd , pCall))) break;
									if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&bno , pCall))) break;
									if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&loc , pCall))) break;
									if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&len , pCall))) break;
			if (pCall->nArg == 5)  {if (!(GetSIntByNode(pW, ppAgv[4], (SLLP)&ini , pCall))) break;}
			//	引数値チェック
			if (knd != CRC_ITL && knd != CRC_ITR && knd != CRC_16L && knd != CRC_16R) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 第１引数が不正です。",
												 "%s - Invalid 1st argument."), pCall->pFunName);
				break;
			}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	ＣＲＣ計算
			switch (knd) {
				case CRC_ITL:	crc = AjcBlkCrcItL(pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len, (UW)ini);	break;
				case CRC_ITR:	crc = AjcBlkCrcItR(pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len, (UW)ini);	break;
				case CRC_16L:	crc = AjcBlkCrc16L(pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len, (UW)ini);	break;
				case CRC_16R:	crc = AjcBlkCrc16R(pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len, (UW)ini);	break;
			}
			//	戻り値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, crc)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	擬似乱数初期化			_SRand(n)																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSRand		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	擬似乱数初期化
			srand((UI)n);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	擬似乱数				_Rand()																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunRand		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;

	if (pCall->nArg == 0) {
		do {
			//	擬似乱数を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rand())) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	算術演算																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	sqrt			_Sqrt(n)																					//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSqrt		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	平方根を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, sqrt(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	sin				_Sin(degree)																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSin		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	Sin値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcSin(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	cos				_Cos(degree)																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunCos		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	Cos値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcCos(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	tan				_Tan(degree)																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTan		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	Tan値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcTan(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	asin			_ASin(n)																					//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunASin		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	ASin値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcASin(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	acos			_ACos(n)																					//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunACos		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	ACos値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcACos(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	atan			_ATan(n)																					//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunATan		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	ATan値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcATan(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	atan2			_ATan2(y, x)																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunATan2		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		y, x;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &y, pCall))) 		break;
			if (!(GetRealByNode(pW, ppAgv[1], &x, pCall))) 		break;
			//	ATAn2値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, AjcATan2(y, x))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	絶対値		_Abs(n)																							//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunAbs		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		n;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &n, pCall))) 		break;
			//	絶対値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, fabs(n))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	最小値		_Min(a, b)																						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMin		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		a, b;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &a, pCall))) 		break;
			if (!(GetRealByNode(pW, ppAgv[1], &b, pCall))) 		break;
			//	最小値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, __min(a, b))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	最大値		_Max(a, b)																						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMax		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	double		a, b;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetRealByNode(pW, ppAgv[0], &a, pCall))) 		break;
			if (!(GetRealByNode(pW, ppAgv[1], &b, pCall))) 		break;
			//	最大値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetReal(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, __max(a, b))) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	時間／ウェイト																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	現在時刻取得		_CurTime()			※197-/1/1 00:00:00 からの通算秒数									//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunCurTime		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SYSTEMTIME	st;
	SLL			n;

	if (pCall->nArg == 0) {
		//	現在時刻値設定
		GetLocalTime(&st);
		n = AjcSysTimeToTime1970(&st);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, n);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	指定時刻取得		_GetTime(year, month, day, hour, minute, second)	※197-/1/1 00:00:00 からの通算秒数	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetTime		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SYSTEMTIME	st;
	SLL			year, month, day, hour, minute, second;
	SLL			n;

	if (pCall->nArg == 6) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!GetSIntByNode(pW, ppAgv[0], &year	, pCall))	break;
			if (!GetSIntByNode(pW, ppAgv[1], &month , pCall))	break;
			if (!GetSIntByNode(pW, ppAgv[2], &day	, pCall))	break;
			if (!GetSIntByNode(pW, ppAgv[3], &hour	, pCall))	break;
			if (!GetSIntByNode(pW, ppAgv[4], &minute, pCall))	break;
			if (!GetSIntByNode(pW, ppAgv[5], &second, pCall))	break;
			//	現在時刻値設定
			memset(&st, 0, sizeof st);
			st.wYear   = (UW)year;
			st.wMonth  = (UW)month;
			st.wDay    = (UW)day;
			st.wHour   = (UW)hour;
			st.wMinute = (UW)minute;
			st.wSecond = (UW)second;
			n = AjcSysTimeToTime1970(&st);
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, n)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	日時情報取得		_GetDateAndTime([seconds])		※197-/1/1 00:00:00 からの通算秒数						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetDateAndTime		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			sec;
	SYSTEMTIME	st;

	if (pCall->nArg <= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg == 0) {
				GetLocalTime(&st);
			}
			else {
				if (!GetSIntByNode(pW, ppAgv[0], &sec, pCall)) {
					break;
				}
				AjcTime1970ToSysTime((UI)sec, &st);
			}
			//	日時情報の配列を返す
			if (pCall->rchVmg != NULL) {
				PCAJCVMGNODEA	pVmgNode = NULL;
				AJCVMGTYPE		typ;
				if ((pVmgNode = CipVmgGetNode(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) == NULL) break;
				typ = pVmgNode->type;
				if (!CipVmgDelVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) break;
				if (!CipVmgGenVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, typ, 7)) break;
				if ((pVmgNode = CipVmgGetNode(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) == NULL) break;

				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 0, st.wYear)		) break;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 1, st.wMonth)		) break;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 2, st.wDay)			) break;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 3, st.wHour)		) break;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 4, st.wMinute)		) break;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 5, st.wSecond)		) break;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 6, st.wMilliseconds)) break;
			}
			else rc = TRUE;	//	戻り値を受ける変数が無い場合はＯＫとする
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	日付文字列取得		$_Date([seconds])																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunDate	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			sec;
	SYSTEMTIME	st;
	BC			txt[32];

	if (pCall->nArg <= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg == 0) {
				GetLocalTime(&st);
			}
			else {
				if (!GetSIntByNode(pW, ppAgv[0], &sec, pCall)) {
					break;
				}
				AjcTime1970ToSysTime((UI)sec, &st);
			}
			//	日付文字列を返す
			if (pCall->rchVmg != NULL) {
				AjcSnPrintFA(txt, sizeof txt, "%04d/%02d/%02d", st.wYear, st.wMonth, st.wDay);
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	時刻文字列取得		$_Time([seconds])																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTime	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			sec;
	SYSTEMTIME	st;
	BC			txt[32];

	if (pCall->nArg <= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg == 0) {
				GetLocalTime(&st);
			}
			else {
				if (!GetSIntByNode(pW, ppAgv[0], &sec, pCall)) {
					break;
				}
				AjcTime1970ToSysTime((UI)sec, &st);
			}
			//	時刻文字列を返す
			if (pCall->rchVmg != NULL) {
				AjcSnPrintFA(txt, sizeof txt, "%02d:%02d:%02d", st.wHour, st.wMinute, st.wSecond);
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	日時文字列取得		$_DateAndTime([seconds])																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunDateAndTime	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	SLL			sec;
	SYSTEMTIME	st;
	BC			txt[32];

	if (pCall->nArg <= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg == 0) {
				GetLocalTime(&st);
			}
			else {
				if (!GetSIntByNode(pW, ppAgv[0], &sec, pCall)) {
					break;
				}
				AjcTime1970ToSysTime((UI)sec, &st);
			}
			//	日時文字列を返す
			if (pCall->rchVmg != NULL) {
				AjcSnPrintFA(txt, sizeof txt, "%04d/%02d/%02d %02d:%02d:%02d", st.wYear, st.wMonth, st.wDay,
																			   st.wHour, st.wMinute, st.wSecond);
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ミリ秒単位のウェイト			_msWait(MicroSecind)														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunWaitMS		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				tmWait, tmTotal, tmPeriBase, tmPeriod;
	ULL				nBefore, nAfter;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&tmWait, pCall))) break;
			//	ウェイト
			nBefore    = (ULL)GetTickCount();
			tmPeriBase = nBefore;
			tmPeriod   = 0;
			tmTotal    = 0;
			while(tmTotal < tmWait && !pW->fRunStop) {
				Sleep(1);
				CipGsrDoEvent(pW);
				if (tmPeriod > 1000) {	//	1[sec]
					//	ユーザコールバック
					if (!pW->fRunStop) {
						CipGsrNtcExe(pW, pW->pCur);
					}
					//	周期カウントリセット
					tmPeriBase = nAfter;
					tmPeriod   = 0;
				}
				nAfter	 = (ULL)GetTickCount();
				tmPeriod = nAfter - tmPeriBase;
				tmTotal  = nAfter - nBefore;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	マイクロ秒単位のウェイト			_usWait(MicroSecind)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunWaitUS		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				tmWait, tmTotal, tmPeriBase, tmPeriod;
	LARGE_INTEGER	nBefore, nAfter;
	LARGE_INTEGER	nFreq;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&tmWait, pCall))) break;
			//	ウェイト
			tmTotal = 0;
			if (QueryPerformanceFrequency(&nFreq) == 0) {
				QueryPerformanceCounter(&nBefore);
				tmPeriBase = nBefore.QuadPart;
				tmPeriod   = 0;
				tmTotal    = 0;
				while(tmTotal < tmWait && !pW->fRunStop) {
					if (tmPeriod > 1000000) {	//	1[sec]
						//	ユーザコールバック
						if (!pW->fRunStop) {
							CipGsrNtcExe(pW, pW->pCur);
						}
						//	周期カウントリセット
						tmPeriBase = nAfter.QuadPart;
						tmPeriod   = 0;
					}
					QueryPerformanceCounter(&nAfter);
					tmPeriod = (nAfter.QuadPart - tmPeriBase	  ) * (ULL)1000000 / nFreq.QuadPart;
					tmTotal  = (nAfter.QuadPart - nBefore.QuadPart) * (ULL)1000000 / nFreq.QuadPart;
					CipGsrDoEvent(pW);
				}
			}
			else {
				nBefore.QuadPart = (ULL)GetTickCount() * (ULL)1000;
				tmPeriBase		 = nBefore.QuadPart;
				tmPeriod		 = 0;
				tmTotal 		 = 0;
				while(tmTotal < tmWait && !pW->fRunStop) {
					if (tmPeriod > 1000000) {	//	1[sec]
						//	ユーザコールバック
						if (!pW->fRunStop) {
							CipGsrNtcExe(pW, pW->pCur);
						}
						//	周期カウントリセット
						tmPeriBase = nAfter.QuadPart;
						tmPeriod   = 0;
					}
					nAfter.QuadPart   = (ULL)GetTickCount() * (ULL)1000;
					tmPeriod		  = nAfter.QuadPart - tmPeriBase;
					tmTotal 		  = nAfter.QuadPart - nBefore.QuadPart;
					CipGsrDoEvent(pW);
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	実行中断				_Stop()																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStop		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;

	if (pCall->nArg == 0) {
		//	_Rstart()までループ
		pW->fExeStop = TRUE;
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	実行再開				_Restart()																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunRestart	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;

	if (pCall->nArg == 0) {
		//	ウェイトフラグ解除
		pW->fExeStop = FALSE;
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	タイマ起動／停止																							//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	タイマ起動		_TimerStart(tid, period)																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTimerStart(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				tno, tim;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], &tno , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], &tim , pCall))) break;
			//	タイマ番号チェック
			if (tno < 1 || tno > 31) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - タイマ番号が不正です。",
												 "%s - Invalid timer id."), pCall->pFunName);
				break;
			}
			//	タイマ起動フラグ設定
			pW->mskExeTimEvt |= (1 << tno);
			//	タイマ起動
			SetTimer(pW->hWndBack, (UI)tno, (UI)tim, NULL);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	タイマ停止		_TimerStop(tid)																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTimerStop(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				tno;

	if (pCall->nArg == 0 || pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg == 0) {
				//	全タイマ停止
				CipGsrStopAllTimer(pW);
				//	全タイマイベント破棄
				memset(pW->fExeTimer, 0, sizeof pW->fExeTimer);
			}
			else {
				if (!(GetSIntByNode(pW, ppAgv[0], &tno , pCall))) break;
				//	タイマ番号チェック
				if (tno < 1 || tno > 31) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - タイマ番号が不正です。",
													 "%s - Invalid timer id."), pCall->pFunName);
					break;
				}
				//	タイマイベント破棄
				pW->fExeTimer[tno] = FALSE;
				//	タイマ起動フラグ解除
				pW->mskExeTimEvt &= ~(1 << tno);
				//	タイマ停止
				KillTimer(pW->hWndBack, (UI)tno);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	文字列																										//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	書式文字列作成			$_SPrintF($Fmt [,arg] ・・・);														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSPrintF	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[1024];

	if (rc = SubSPrintF(pW, pCall, txt, sizeof txt)) {
		do {
			//	作成した文字列を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt)) {
					break;
				}
			}
			//	戻り値＝正常
			rc = TRUE;
		} while(0);
	}
	return rc;
}
//==============================================================================================================//
//	文字列の長さ取得	_StrLen($str);																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrLen	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr;
	ULL			stl;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) 		break;
			//	文字長設定
			stl = strlen(pStr);
			//	比較結果を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, stl)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の比較（英大文字，小文字を区別しない）	_StrICmp($str1 , $str2 [,nEqual] );							//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrICmp	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr1, pStr2;
	SLL			nEqual = 0;
	int			rsu;

	if (pCall->nArg >= 2 && pCall->nArg <= 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr1 = GetStrByNode(pW, ppAgv[0], pCall))) 		break;
			if (!(pStr2 = GetStrByNode(pW, ppAgv[1], pCall))) 		break;
			if (pCall->nArg == 3) {
				if (!GetSIntByNode(pW, ppAgv[2], &nEqual, pCall))	break;
			}
			//	文字列比較
			rsu = mbsicmp(pStr1, pStr2);
			//	比較結果を返す
			if (pCall->rchVmg != NULL) {
				if		(rsu  > 0) {if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, nEqual + 1)) break;}
				else if (rsu == 0) {if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, nEqual + 0)) break;}
				else if (rsu  < 0) {if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, nEqual - 1)) break;}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の検索（大文字／小文字を区別する）	_StrStr( $str1 , $str2 );										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrStr	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr1, pStr2;
	BCP			pStr;
	SLL			ix;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr1 = GetStrByNode(pW, ppAgv[0], pCall))) 		break;
			if (!(pStr2 = GetStrByNode(pW, ppAgv[1], pCall))) 		break;
			//	文字列検索
			if (pStr = mbsstr(pStr1, pStr2)) {
				ix = (SLL)((UX)pStr - (UX)pStr1);
			}
			else {
				ix = -1;	//	見つからない場合は －１
			}
			//	検索結果を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, ix)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の検索（大文字／小文字を区別しない）	_StrIStr( $str1 , $str2 );										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrIStr	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr1, pStr2;
	BCP			pStr;
	SLL			ix;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr1 = GetStrByNode(pW, ppAgv[0], pCall))) 		break;
			if (!(pStr2 = GetStrByNode(pW, ppAgv[1], pCall))) 		break;
			//	文字列検索
			if (pStr = mbsistr(pStr1, pStr2)) {
				ix = (SLL)((UX)pStr - (UX)pStr1);
			}
			else {
				ix = -1;	//	見つからない場合は －１
			}
			//	検索結果を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, ix)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	数値表現の文字列を数値に変換する			_ToValue($str)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunToValue		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pStr;
	SLL				sll;
	double			dbl;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	数値変換
			if (pCall->rchVmg != NULL) {
				while (MAjcIsBlankA(*pStr)) pStr++;
				if (*pStr == '0' && ((*(pStr + 1) | 0x20) == 'x')) {
					sll = AjcHexToULLA(pStr);
					if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, sll)) break;
				}
				else {
					if (pW->NumType == AJCIPT_INTEGER) {
						sll = AjcAscToLIntA(pStr);
						if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, sll)) break;
					}
					else {
						dbl = atof(pStr);
						if (!CipVmgSetReal	 (pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, dbl)) break;
					}
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の連結	$_StrCat( [$str1] [,$str2] ・・・);															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrCat	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr;
	UI			i, stl, len;
	BC			txt[1024];

	if (pCall->nArg >= 0) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	文字列連結
			txt[0] = 0;
			len    = 0;
			for (i = 0; i < pCall->nArg; i++) {
				if (!(pStr = GetStrByNode(pW, ppAgv[i], pCall))) goto cfsc_exit;
				stl  = (UI)strlen(pStr);
				if (len + stl + 1 < sizeof(txt)) {
					strcpy(&txt[len], pStr);
					len += stl;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - 文字列が長すぎます。",
													 "%s - String too long."), pCall->pFunName);
					goto cfsc_exit;
				}
			}
			//	連結した文字列を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt)) {
					break;
				}
			}
			//	戻り値=正常
			rc = TRUE;

		} while(0);
cfsc_exit:;
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	２つのパスの結合	$_PathCat( $str1 , $str2 );																//
//										（２つの文字列の間に、必ず１つの「￥」が挿入された文字列を作成する）	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPathCat	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr1, pStr2;
	UI			len1 , len2;
	BCP			pTmp = NULL;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr1 = GetStrByNode(pW, ppAgv[0], pCall))) 		break;
			if (!(pStr2 = GetStrByNode(pW, ppAgv[1], pCall))) 		break;
			//	文字列連結
			len1 = (UI)strlen(pStr1);
			len2 = (UI)strlen(pStr2);
			if (pTmp = (BCP)AJCMEM(len1 + len2 + 2)) {
				strcpy(pTmp, pStr1);
				AjcPathCatA(pTmp, pStr2, len1 + len2 + 2);
				//	連結した文字列を返す
				if (pCall->rchVmg != NULL) {
					if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
				}
				//	戻り値=正常
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
												 "%s - String work space allocation failure."), pCall->pFunName);
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の前部空白を除去	$_StrLTrim($str) / $_StrLTrim($str[])												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrLTrim	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pStr;
	UI				i, len;
	BCP				pTmp = NULL;
	PCAJCVMGNODEA	pNode;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	空白除去
			if (ppAgv[0]->fArr) {	//	配列変数
				//	引数のノード取得
				if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == NULL) {
					break;
				}
				if (pNode->type == AJCIPT_STRING) {
					//	空白除去
					for (i = 0; i < pNode->num; i++) {
						AjcStrLTrimA(pNode->arr.pStr[i], pNode->arr.pStr[i], (UI)strlen(pNode->arr.pStr[i]) + 1);
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
											  LNGSEL("%s - %d番目の引数は、文字型でなければなりません。",
													 "%s - Must be string type in %d[th] argument."), pCall->pFunName, ppAgv[0]->seq + 1);
					rc = FALSE;
					break;
				}
			}
			else {					//	単一変数
				if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) 	break;
				len = (UI)strlen(pStr);
				if (pTmp = (BCP)AJCMEM(len + 1)) {
					strcpy(pTmp, pStr);
					AjcStrLTrimA(pTmp, pTmp, len + 1);
					//	空白除去した文字列を返す
					if (pCall->rchVmg != NULL) {
						if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
					}
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
													 "%s - String work space allocation failure."), pCall->pFunName);
				}
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の後部空白を除去	$_StrRTrim( $str) / $_StrRTrim( $str[])												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrRTrim	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pStr;
	UI				i, len;
	BCP				pTmp = NULL;
	PCAJCVMGNODEA	pNode;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	空白除去
			if (ppAgv[0]->fArr) {	//	配列変数
				//	引数のノード取得
				if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == NULL) {
					break;
				}
				if (pNode->type == AJCIPT_STRING) {
					//	空白除去
					for (i = 0; i < pNode->num; i++) {
						AjcStrRTrimA(pNode->arr.pStr[i], pNode->arr.pStr[i], (UI)strlen(pNode->arr.pStr[i]) + 1);
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
											  LNGSEL("%s - %d番目の引数は、文字型でなければなりません。",
													 "%s - Must be string type in %d[th] argument."), pCall->pFunName, ppAgv[0]->seq + 1);
					rc = FALSE;
					break;
				}
			}
			else {					//	単一変数
				if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) break;
				len = (UI)strlen(pStr);
				if (pTmp = (BCP)AJCMEM(len + 1)) {
					strcpy(pTmp, pStr);
					AjcStrRTrimA(pTmp, pTmp, len + 1);
					//	空白除去した文字列を返す
					if (pCall->rchVmg != NULL) {
						if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
					}
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
													 "%s - String work space allocation failure."), pCall->pFunName);
				}
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列の前後の空白を除去	$_StrTrim( $str);																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrTrim	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pStr;
	UI				i, len;
	BCP				pTmp = NULL;
	PCAJCVMGNODEA	pNode;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	空白除去
			if (ppAgv[0]->fArr) {	//	配列変数
				//	引数のノード取得
				if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == NULL) {
					break;
				}
				if (pNode->type == AJCIPT_STRING) {
					//	配列全要素の空白除去
					for (i = 0; i < pNode->num; i++) {
						AjcStrTrimA(pNode->arr.pStr[i], pNode->arr.pStr[i], (UI)strlen(pNode->arr.pStr[i]) + 1);
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
											  LNGSEL("%s - %d番目の引数は、文字型でなければなりません。",
													 "%s - Must be string type in %d[th] argument."), pCall->pFunName, ppAgv[0]->seq + 1);
					rc = FALSE;
					break;
				}
			}
			else {					//	単一変数
				if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) 		break;
				len = (UI)strlen(pStr);
				if (pTmp = (BCP)AJCMEM(len + 1)) {
					strcpy(pTmp, pStr);
					AjcStrTrimA(pTmp, pTmp, len + 1);
					//	空白除去した文字列を返す
					if (pCall->rchVmg != NULL) {
						if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
					}
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
													 "%s - String work space allocation failure."), pCall->pFunName);
				}
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	部分文字列の取得	$_StrPart( $str1 , loc, len );															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrPart	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr;
	int			stl , ixs, ixe;
	SLL			loc , len;
	UI			uloc, ulen;
	BCP			pTmp = NULL;

	if (pCall->nArg == 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) 	break;
			if (!GetSIntByNode(pW, ppAgv[1], &loc , pCall)) 	break;
			if (!GetSIntByNode(pW, ppAgv[2], &len , pCall)) 	break;
			//	文字列長設定
			stl = (int)strlen(pStr);
			//	開始，終了ロケーション算出
			if (len >= 0) {ixs = (int)(loc	   );  ixe = (int)(loc + len);}
			else		  {ixs = (int)(loc + len); ixe = (int)(loc	   ); }
			if (ixs > ixe) AjcMemSwap((VOP)&ixs, (VOP)&ixe, sizeof ixs);
			//	文字列にマッピングされる部分を算出
			if ((ixs < 0 && ixe < 0) || (ixs > stl && ixe > stl)) {
				uloc = ulen = 0;
			}
			else {
				if (ixs >= 0) {uloc = ixs; ulen = __min(ixe - ixs, stl);}
				else		  {uloc = 0;   ulen = ixe;			  }
			}

			if (pTmp = (BCP)AJCMEM(ulen + 1)) {
				//	戻り値（文字列）作成
				memcpy(pTmp, pStr + uloc, ulen);
				*(pTmp + ulen) = 0;
				//	部分文字列を返す
				if (pCall->rchVmg != NULL) {
					if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
				}
				//	戻り値=正常
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
												 "%s - String work space allocation failure."), pCall->pFunName);
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放	
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	部分文字列の置換	$_StrRep( $str1 , loc, len, $Str2 );													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrRep	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr1, pStr2;
	int			len1 , len2;
	SLL			loc, len;
	BCP			pTmp = NULL;

	if (pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr1 = GetStrByNode(pW, ppAgv[0], pCall))) 	break;
			if (!GetSIntByNode(pW, ppAgv[1], &loc  , pCall)) 	break;
			if (!GetSIntByNode(pW, ppAgv[2], &len,	 pCall)) 	break;
			if (!(pStr2 = GetStrByNode(pW, ppAgv[3], pCall))) 	break;
			//	文字列長設定
			len1 = (int)strlen(pStr1);
			len2 = (int)strlen(pStr2);
			if (loc <	 0) loc = 0;
			if (loc > len1) loc = len1;
			if (loc + len > len1) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - loc + len が文字列１の範囲外です。",
												 "%s - Out of range in string1."), pCall->pFunName);
				break;
			}
			if (pTmp = (BCP)AJCMEM(len1 + len2 + 1)) {
				strcpy(pTmp, pStr1);
				AjcRepPartStrA(pTmp, len1 + len2 + 1, (UI)loc, (UI)len, pStr2, len2);
				//	置換した文字列を返す
				if (pCall->rchVmg != NULL) {
					if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
				}
				//	戻り値=正常
				rc = TRUE;
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
												 "%s - String work space allocation failure."), pCall->pFunName);
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放	
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列をデリミタで分解した配列を返す	$_StrSplit( $str [,$delimiter] );									//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrSplit	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr, pDlm = ",";
	C_BCP		pInp;
	BCP			pOut;
	UI			len, lStr, lDlm, lRem, nItem, ix;
	BCP			pTmp = NULL;

	if (pCall->nArg >= 1 && pCall->nArg <= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg >= 1) {if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) break;}
			if (pCall->nArg >= 2) {if (!(pDlm = GetStrByNode(pW, ppAgv[1], pCall))) break;}
			//	文字列長設定
			lStr = (UI)strlen(pStr);
			lDlm = (UI)strlen(pDlm);
			//	バッファ確保
			len = lStr * 2 + 2;
			if (pTmp = (BCP)AJCMEM(len)) {
				pInp = pStr;
				pOut = pTmp;
				//	Str1中のデリミタを0x00に変換し、バッファにコピー（多重文字列化）
				nItem = 1;
				if (lStr != 0) {
					if (lDlm != 0) {
						lRem = lStr;
						while (*pInp != 0 && lRem >= lDlm) {
							if (memcmp(pInp, pDlm, lDlm) == 0) {
								*pOut++  = 0;
								pInp	+= lDlm;
								nItem++;
								lRem -= lDlm;
							}
							else {
								*pOut++ = *pInp++;
								lRem--;
							}
						}
						//	後部の余り部分をコピー
						while (*pInp != 0) {
							*pOut++ = *pInp++;
						}
					}
					else {	//	デリミタ = "" ？
						strcpy(pOut, pInp);
						pOut += lStr;
					}
				}
				//	多重文字列終端設定
				*pOut++ = 0;
				*pOut++ = 0;

				if (pCall->rchVmg != NULL) {
					//	戻り変数を配列でリメイク
					if (!CipVmgDelVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) break;
					if (!CipVmgGenVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, AJCIPT_STRING, (UI)nItem)) break;
					//	文字列を分解した配列を返す
					pInp = pTmp;
					ix	 = 0;
					for (ix = 0; ix < nItem; ix++) {
						if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, ix, pInp)) break;
						pInp += (strlen(pInp) + 1);
					}
					rc = TRUE;	//	戻り値=正常
				}
				else rc = TRUE;		//	戻り変数が無い場合はＯＫとする
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
												 "%s - String work space allocation failure."), pCall->pFunName);
				break;
			}
		} while(0);


		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列配列にデリミタを付加し１つの文字列にする	$_StrJoin( $str[] [,$delimiter] );							//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStrJoin	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pDlm = ",";
	BCP				pOut;
	UI				len, lDlm, ix;
	BCP				pTmp = NULL;
	PCAJCVMGNODEA	pNode;

	if (pCall->nArg >= 1 && pCall->nArg <= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (ppAgv[0]->fArr) {
				if (pCall->rchVmg != NULL) {
					//	引数１取得
					if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == NULL) {
						break;
					}
					//	引数２（デリミタ）文字列取得
					if (pCall->nArg >= 2) {if (!(pDlm = GetStrByNode(pW, ppAgv[1], pCall))) break;}
					lDlm = (UI)strlen(pDlm);
					//	配列文字列とデリミタを合わせた長さ算出
					len = (UI)strlen(pNode->arr.pStr[0]);
					for (ix = 1; ix < pNode->num; ix++) {
						len += (UI)(strlen(pNode->arr.pStr[ix]) + lDlm);
					}
					len++;
					//	連結用バッファ確保
					if (pTmp = (BCP)AJCMEM(len)) {
						//	文字列の連結
						pOut = pTmp;
						strcpy(pOut, pNode->arr.pStr[0]);
						pOut += strlen(pNode->arr.pStr[0]);
						for (ix = 1; ix < pNode->num; ix++) {
							strcpy(pOut, pDlm);
							pOut += lDlm;
							strcpy(pOut, pNode->arr.pStr[ix]);
							pOut += strlen(pNode->arr.pStr[ix]);
						}
						*pOut = 0;
						//	連結した文字列を返す
						if (pCall->rchVmg != NULL) {
							if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pTmp)) break;
						}
						rc = TRUE;	//	戻り値=正常
					}
					else {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
												  LNGSEL("%s - 文字列編集用の作業領域を確保できません。",
														 "%s - String work space allocation failure."), pCall->pFunName);
						break;
					}
				}
				else rc = TRUE;		//	戻り変数が無い場合はＯＫとする
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - 引数には配列( ex. $var[] )を指定してください。",
												 "%s - Must be argument to arrangement( ex. var[] )."), pCall->pFunName);
				break;
			}
		} while(0);

		//	バッファ解放
		if (pTmp  != NULL) 	free(pTmp);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	項目の書式文字列作成（１０進）	$_ToDecStr(item [,len] [,lup] );											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunToDecStr	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[512] = {0};

	if (rc = SubFunPItem(pW, pCall, txt, sizeof txt)) {
		//作成した文字列を返す
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt);
		}
	}
	return rc;
}
//==============================================================================================================//
//	項目の書式文字列作成（１６進）	$_ToHexStr(item [,len] );													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunToHexStr	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[512] = {0};

	if (rc = SubFunPHexa(pW, pCall, txt, sizeof txt)) {
		//作成した文字列を返す
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt);
		}
	}
	return rc;
}
//==============================================================================================================//
//	文字列入力		$_Input([$Prompt] [,$DefStr])																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
typedef struct {
	C_BCP	pTtl;			//	[Inp]ウインドタイトル
	UI		len;			//	[Inp]入力可能文字数（文字列格納バッファの長さ）
	BCP		pStr;			//	[Inp]初期文字列へのポインタ，[Out]入力文字列を格納
	BCP		pMacFName;		//	[Inp]マクロファイル名（プロファイルセクション名の接頭語）
	//	内部ワーク
	HBITMAP	hBmpLgfBm2;		//	ビットマップ（フロッピ）
	HBITMAP	hBmpFolder;		//	ビットマップ（フォルダ）
	HWND	hToolTip;		//	ツールチップハンドル
} CIP_INPSTRINFO, *PCIP_INPSTRINFO;
//---------------------------------------------------------------------------------------------------------------//
//	ダイアログ初期化
AJC_DLGPROC(CipInpStr, WM_INITDIALOG )
{
	PCIP_INPSTRINFO	pParam = (PCIP_INPSTRINFO)lParam;
	HWND			hCbo = GetDlgItem(hDlg, IDC_CBO_INPSTR);
	BC				SecName[MAX_SECNAME];

	//	パラメタポインタ設定
	SetPropA(hDlg, "CipInpStrParam", (HANDLE)lParam);
	//	アイコン設定
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	//	ウインドタイトル設定
	SetWindowTextA(hDlg, pParam->pTtl);
	//	日英テキスト
	AjcSetDlgItemStrA(hDlg, IDOK	, LNGSEL("ＯＫ" 	 , "OK"    ));
	AjcSetDlgItemStrA(hDlg, IDCANCEL, LNGSEL("キャンセル", "Cancel"));
	//	ビットマップ生成
	AjcChangeBitmapColor((pParam->hBmpLgfBm2 = LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_LGF_BM2 ))), RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
	AjcChangeBitmapColor((pParam->hBmpFolder = LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_FOLDER	))), RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
	//	ビットマップ表示
	SendDlgItemMessage(hDlg, IDC_CMD_DIR , BM_SETIMAGE, 0, (LPARAM)pParam->hBmpFolder);
	SendDlgItemMessage(hDlg, IDC_CMD_FILE, BM_SETIMAGE, 0, (LPARAM)pParam->hBmpLgfBm2);
	//	ツールチップ・コントロール生成
	pParam->hToolTip = CreateWindowEx(WS_EX_TOPMOST,
									TOOLTIPS_CLASS,
									NULL,
									TTS_ALWAYSTIP,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									hDlg, NULL,
									hDllInst, NULL);
	//	ツールチップ追加
	{	TOOLINFOA	ti;
		memset(&ti, 0, sizeof ti);
		ti.cbSize	= sizeof(TOOLINFO);
		ti.hwnd		= hDlg;
		ti.hinst	= hDllInst;
		ti.uFlags	= TTF_IDISHWND | TTF_SUBCLASS;

		ti.lpszText = LNGSEL("フォルダ選択", "Folder selection");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_CMD_DIR );	SendMessage(pParam->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("ファイル選択", "File selection");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_CMD_FILE);	SendMessage(pParam->hToolTip, TTM_ADDTOOL, 0, (LPARAM)&ti);
	}
	//	コンボボックスをサブクラス化
	AjcSbcComboBox		  (hCbo, 50, MAX_PATH);
	//	コンボボックス設定内容読み出し
	AjcSnPrintFA(SecName, sizeof SecName, "%s_CboInpStr", pParam->pMacFName);
	AjcSbcLoadItemsA  (hCbo, SecName);
	//	文字列の比較方法設定
	AjcSbcSetCompExact(hCbo, TRUE); // 大小区別して比較
	//	コンボボックス入力可能文字数設定
	AjcSetCtrlCboLimit(hCbo, pParam->len - 1);
	//	コンボボックスをフォーカス
	SetFocus(hCbo);
	//	コンボボックスへ文字列挿入／選択
	AjcSetCtrlCboAddA (hCbo, 0, pParam->pStr, FALSE);
	//	文字列を選択状態にする
	SendMessage 	  (hCbo, CB_SETEDITSEL, 0, MAKELONG(0, -1));

	return TRUE;
}
//	ＯＫボタン
AJC_DLGPROC(CipInpStr, IDOK			)
{
	PCIP_INPSTRINFO	pParam = (PCIP_INPSTRINFO)GetPropA(hDlg, "CipInpStrParam");
	HWND			hCbo = GetDlgItem(hDlg, IDC_CBO_INPSTR);
	BC				SecName[MAX_SECNAME];

	//	入力した文字列取得
	*pParam->pStr = 0;
	AjcGetCtrlStrA(hCbo, pParam->pStr, pParam->len);
	//	入力した文字列挿入／選択
	AjcSetCtrlCboAddA (hCbo, 0, pParam->pStr, FALSE);
	//	コンボボックス設定内容退避
	AjcSnPrintFA(SecName, sizeof SecName, "%s_CboInpStr", pParam->pMacFName);
	AjcSbcSaveItemsA(hCbo, SecName);
	//	ビットマップ破棄
	if (pParam->hBmpLgfBm2 != NULL) DeleteObject(pParam->hBmpLgfBm2);
	if (pParam->hBmpFolder != NULL) DeleteObject(pParam->hBmpFolder);
	//	ツールチップ破棄
	if (pParam->hToolTip != NULL) DestroyWindow(pParam->hToolTip);

	EndDialog(hDlg, IDOK);
	return TRUE;
}
//	キャンセルボタン
AJC_DLGPROC(CipInpStr, IDCANCEL		)
{
	PCIP_INPSTRINFO	pParam = (PCIP_INPSTRINFO)GetPropA(hDlg, "CipInpStrParam");

	//	空文字列を返す
	*pParam->pStr = 0;

	//	ビットマップ破棄
	if (pParam->hBmpLgfBm2 != NULL) DeleteObject(pParam->hBmpLgfBm2);
	if (pParam->hBmpFolder != NULL) DeleteObject(pParam->hBmpFolder);
	//	ツールチップ破棄
	if (pParam->hToolTip != NULL) DestroyWindow(pParam->hToolTip);

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//	メッセージマップ
AJC_DLGMAP_DEF(CipInpStr)
	AJC_DLGMAP_MSG(CipInpStr, WM_INITDIALOG	)

	AJC_DLGMAP_CMD(CipInpStr, IDOK			)
	AJC_DLGMAP_CMD(CipInpStr, IDCANCEL		)
AJC_DLGMAP_END

//---------------------------------------------------------------------------------------------------------------//
BOOL	CipFunInputStr	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pTtl = "";
	C_BCP		pStr = "";
	C_BCP		pDef = "";
	CIP_INPSTRINFO	Param;

	if (pCall->nArg <= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	第1引数値設定($Prompt)
			if (pCall->nArg >= 1) {
				if (!(pTtl = GetStrByNode(pW, ppAgv[0], pCall))) 	break;
			}
			//	第2引数値設定($DefStr)
			if (pCall->nArg >= 2) {
				if (!(pDef = GetStrByNode(pW, ppAgv[1], pCall))) 	break;
				AjcSnPrintFA(pW->ExeInpTxt, sizeof pW->ExeInpTxt, "%s", pDef);
			}
			//	文字列入力
			Param.pTtl		= pTtl;
			Param.len		= MAX_INPTXTLEN;
			Param.pStr		= pW->ExeInpTxt;
			Param.pMacFName = pW->MacFName;
			DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_CIPINPSTR), pW->hWndVth, AJC_DLGPROC_NAME(CipInpStr), (LPARAM)&Param);
			//	入力した文字列を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->ExeInpTxt)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	16進文字列→バイナリデータ変換		_HexStrToBinary($HexStr, bno, loc)										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunHexStrToBinary		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr;
	SLL			bno, loc;
	SLL			bytes = 0;
	ULL			val;
	C_BCP		p;

	if (pCall->nArg == 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) 	break;
			if (!GetSIntByNode(pW, ppAgv[1], &bno, pCall)) 		break;
			if (!GetSIntByNode(pW, ppAgv[2], &loc, pCall)) 		break;
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	バイナリデータ変換
			p = pStr;
			while (*p != 0 && loc < pW->ExeMemBlk[bno].MemLen) {
				//	16進数変換
				val = 0;
				while (MAjcIsXDigitA(*p)) {
					val <<= 4;
					if (_ismbcdigit(*p)) val |=  (*p & 15);
					else				 val |= ((*p & 15) + 9);
					p++;
				}
				//	不正16進数ならば終了
				if (val < 0 || val > 255 || (*p != 0 && !MAjcIsBlankA(*p) && !MAjcIsXDigitA(*p))) break;
				//	メモリブロックへバイトデータ設定
				*(pW->ExeMemBlk[bno].pMemAddr + loc) = (UB)val;
				//	ロケーション，バイト数更新
				loc++;
				bytes++;
				//	空白スキップ
				while (MAjcIsBlankA(*p)) p++;
			}
			//	バイナリデータのバイト数を返す
			if (pCall->rchVmg != NULL) {
				if (pCall->rchVmg != NULL) {
					if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, bytes)) break;
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	キーに後続する数値取得		val[] = _GetValueByKey($str, $key [,fExact])									//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetValueByKey		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pStr, pKey;
	C_BCP		p;
	SLL			fExact = FALSE;
	union {SLL sll; double dbl;} u;

	if (pCall->nArg == 2 || pCall->nArg == 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (!(pKey = GetStrByNode(pW, ppAgv[1], pCall))) break;
			if (pCall->nArg == 3) {if (!GetSIntByNode(pW, ppAgv[2], &fExact, pCall)) break;}
			//	数値取得
			if (fExact) p = mbsstr (pStr, pKey);
			else		p = mbsistr(pStr, pKey);
			if (p != NULL) {
				p += strlen(pKey);
				if (pW->NumType == AJCIPT_INTEGER)	u.sll = AjcAscToLIntA(p);
				else 								u.dbl = AjcAscToRealA(p);
			}
			else {
				if (pW->NumType == AJCIPT_INTEGER)	u.sll = 0;
				else 								u.dbl = 0;
			}
			//	取得した数値を返す
			if (pW->NumType == AJCIPT_INTEGER) {
				//	整数値を返す
				if (pCall->rchVmg != NULL) {
					if (pCall->rchVmg != NULL) {
						if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, u.sll)) break;
					}
				}
			}
			else {
				//	実数値を返す
				if (pCall->rchVmg != NULL) {
					if (pCall->rchVmg != NULL) {
						if (!CipVmgSetReal	 (pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, u.dbl)) break;
					}
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字列中の数値収集		_GetValues($str)																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
typedef struct {
	int		ix;
	C_BCP	pTxt;
} CFGVPRM, *PCFGVPRM;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbCtkCfgv(BCP pBuf, UI lBuf, UX cbp)
{
	BOOL		rc	 = FALSE;
	PCFGVPRM	pCbp = (PCFGVPRM)cbp;
	C_BCP		pTxt = &pCbp->pTxt[pCbp->ix];
	UI			stl  = (UI)strlen(pTxt);

	if (stl != 0) {
		if (stl < lBuf) {
			strcpy(pBuf, pTxt);
			pCbp->ix += stl;
		}
		else {
			memcpy(pBuf, pTxt, lBuf - 1);
			pBuf[lBuf - 1] = 0;
			pCbp->ix += (lBuf - 1);
		}
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipFunGetValues		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pStr   = NULL;
	int				i, ix  = 0;
	CFGVPRM			cbp;
	PCAJCVMGNODEA	pVmgNode = NULL;
	AJCVMGTYPE		typ;
	HAJCTK			hCtk = NULL;
	UI				tkn;
	UI				svtkn = 0;
	BC				Syl  [256];
	union {SLL sll; double dbl;} u[64];

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	文字列中の数値収集
			cbp.ix	 = 0;
			cbp.pTxt = pStr;
			if (hCtk = AjcCtkCreateA(0, cbCtkCfgv, (UX)&cbp)) {
				while (ix < 64 && AjcCtkGetTokenA(hCtk, Syl, sizeof Syl)) {
					tkn = AJCTK_TOKEN(hCtk);
					if (svtkn == EAJCTK_DLM_MINUS) {
						if (AJCTKIS_VALUE(tkn)) {
							if (pW->NumType == AJCIPT_INTEGER)	u[ix].sll = -AjcAscToLIntA(Syl);
							else 								u[ix].dbl = -AjcAscToRealA(Syl);
							ix++;
						}
						svtkn = 0;
					}
					else {
						if (tkn == EAJCTK_DLM_MINUS) {
							svtkn = tkn;
						}
						else {
							if (AJCTKIS_VALUE(tkn)) {
								if (pW->NumType == AJCIPT_INTEGER)	u[ix].sll = AjcAscToLIntA(Syl);
								else 								u[ix].dbl = AjcAscToRealA(Syl);
								ix++;
							}
						}
					}
				}
			}
			//	収集した数値の配列を返す
			if (pCall->rchVmg != NULL) {
				if ((pVmgNode = CipVmgGetNode(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) == NULL) break;
				typ = pVmgNode->type;
				if (!CipVmgDelVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) break;
				if (!CipVmgGenVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, typ, ix)) break;
				if (ix > 0) {
					for (i = 0; i < ix; i++) {
						if (pW->NumType == AJCIPT_INTEGER)	{if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, i, u[i].sll)) goto cfgv_exit;}
						else 								{if (!CipVmgSetReal   (pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, i, u[i].dbl)) goto cfgv_exit;}
					}
				}
				else {
					if (pW->NumType == AJCIPT_INTEGER)	{if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 0, 0)) break;}
					else 								{if (!CipVmgSetReal   (pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 0, 0)) break;}
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
cfgv_exit:;
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
		//	トークンインスタンス解放
		if (hCtk != NULL) AjcCtkDelete(hCtk);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	問い合わせ																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	メッセージボックス	_MsgBox($Message, $Title, type)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMsgBox(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pMsg;
	C_BCP			pTtl;
	ULL				BoxType;
	int				rsu;

	if (pCall->nArg == 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pMsg = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (!(pTtl = GetStrByNode(pW, ppAgv[1], pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&BoxType , pCall))) break;
			//	ボックスタイプチェック
			if (BoxType != MB_OK 			&&
				BoxType != MB_OKCANCEL		&&
				BoxType != MB_RETRYCANCEL	&&
				BoxType != MB_YESNO			&&
				BoxType != MB_YESNOCANCEL	&&
				BoxType != MB_ICONERROR) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 第３引数が不正です。",
												 "%s - Invalid 3rd arguments."), pCall->pFunName);
				break;
			}
			//	メッセージボックス表示
			rsu = MessageBoxA(pW->hWndBack, pMsg, pTtl, (int)BoxType);
			//	戻り値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rsu)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ポップアップメニュー		_PopupMenu($menu[], x, y [,$Func])												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
#define		IDM_POPUPMENU_BASE	1000
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipFunPopupMenu	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	HMENU		hMenu  = NULL;
	UI			i, n;
	SLL			x, y, id;
	POINT		pt;
	C_BCP		pFunc;
	C_BCP		pStr;

	if (pCall->nArg == 3 || pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	$menu[]の要素数取得
			if (ppAgv[0]->fArr) {
				if ((n = CipVmgGetArrNum(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == 0) {
					break;
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - 引数には配列( ex. $menu[] )を指定してください。",
												 "%s - Must be argument to arrangement( ex. $menu[] )."), pCall->pFunName);
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&x , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&y , pCall))) break;
			if (pCall->nArg >= 4) {if (!(pFunc = GetStrByNode(pW, ppAgv[3], pCall))) break;}
			//	x,yをスクリーン座標に変換
			pt.x = (int)x;
			pt.y = (int)y;
			ClientToScreen(pW->hWndVth, &pt);
			//	ポップアップメニュー
			if (pCall->nArg == 3) {
				if (hMenu = CreatePopupMenu()) {
					for (i = 0; i < n; i++) {
						if ((pStr = CipVmgGetString(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName, i)) == NULL) goto cfpm_exit;
						AppendMenuA(hMenu, MFT_STRING, IDM_POPUPMENU_BASE + i, pStr);
					}
					id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, pW->hWndBack, NULL);
					if (id >= IDM_POPUPMENU_BASE) id -= IDM_POPUPMENU_BASE;
					else						  id = -1;
					DestroyMenu(hMenu);
					hMenu = NULL;
					//	メニュー選択結果を返す
					if (pCall->rchVmg != NULL) {
						if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, id)) break;
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - メニューを作成できません。",
													 "%s - Can't create the popup-menu."), pCall->pFunName);
					break;
				}
			}
			else {
				PAJCPPMTBLA	pTbl 	= NULL;
				PAJCCIPFUNC	pNode	= NULL;

				if ((pNode = (PAJCCIPFUNC)AjcAvlGetNodePtr(pW->hAvlFun, (UX)pFunc, NULL)) != NULL) {
					if (pTbl = (PAJCPPMTBLA)AJCMEM(sizeof(AJCPPMTBLA) * (n + 1))) {
						memset(pTbl, 0, 		   sizeof(AJCPPMTBLA) * (n + 1));
						for (i = 0; i < n; i++) {
							if ((pStr = CipVmgGetString(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName, i)) == NULL) goto cfpm_exit;
							pTbl[i].flag  = 0;
							pTbl[i].id	  = i;
							pTbl[i].key   = 0;
							pTbl[i].pText = pStr;
						}
						pTbl[i].flag = AJCPPMF_EOT;
						AjcPopupMenuA(pW->hWndBack, WM_POPUPMENU, pt.x, pt.y, pTbl, (LPARAM)pNode->pFunName);
						free(pTbl);
					}
					else {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
												  LNGSEL("%s - メニュー用の作業領域を確保できません",
														 "%s - Menu work allocation failure."), pCall->pFunName);
						break;
					}
				}
				else {
					if (!AjcPopupMenuA(pW->hWndBack, WM_POPUPMENU, pt.x, pt.y, pTbl, (LPARAM)pNode->pFunName)) {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
												  LNGSEL("%s - 関数 '%s' は未定義です。",
														 "%s - Undefined function '%s'."), pCall->pFunName, pFunc);
						break;
					}
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
cfpm_exit:;
		//	メニュー解放
		if (hMenu != NULL) {DestroyMenu(hMenu); hMenu = NULL;}
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	メモリブロック																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	メモリブロック割り当て		_MemAlloc(AllocSize)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMemAlloc		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	UI				bno;
	ULL				len;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&len, pCall))) break;
			//	割り当てサイズチェック
			if (len > 0xFFFFFFFF) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - メモリブロック・サイズが大きすぎます。",
												 "%s - Too big memory block size."), pCall->pFunName);
				break;
			}
			//	メモリブロック割り当てテーブル検索
			for (bno = 1; bno < AJCCIPMAX_MEMBLK; bno++) {
				if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
					break;
				}
			}
			if (bno >= AJCCIPMAX_MEMBLK) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
										  LNGSEL("%s - メモリブロックの数が多すぎます。",
												 "%s - Too many memory blocks."), pCall->pFunName);
				break;
			}
			//	メモリブロック割り当て
			if (pW->ExeMemBlk[bno].pMemAddr = (UBP)AJCMEM((UI)len)) {
				pW->ExeMemBlk[bno].MemLen = (UI)len;
				memset(pW->ExeMemBlk[bno].pMemAddr, 0 , (UI)len);
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - メモリブロックの割り当てを失敗しました。",
												 "%s - Memry block allocation failure."), pCall->pFunName);
				break;
			}
			//	メモリブロック＃を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, bno)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	メモリブロック解放		_MemFree(MemBlkNo)																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMemFree		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				bno;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&bno, pCall))) break;
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロック解放
			free(pW->ExeMemBlk[bno].pMemAddr);
			pW->ExeMemBlk[bno].pMemAddr = NULL;
			pW->ExeMemBlk[bno].MemLen	= 0;
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	メモリブロック中のデータ読み出し		_GetMemBlk(BlkNo, Location, Bytes [,fChangeEndian])					//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetMemBlk		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				bno, loc, len;
	ULL				fce    = FALSE;	//	エンディアン変更フラグ
	union {
		UB		b[8];
		ULL		n;
	} u;

	if (pCall->nArg == 3 || pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
								   if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&bno, pCall))) break;
								   if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&loc, pCall))) break;
								   if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&len, pCall))) break;
			if (pCall->nArg == 4) {if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&fce, pCall))) break;}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	データ長チェック
			if (!(len >= 1 && len <= 8)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - データ長は１～８の範囲でなければなりません。",
												 "%s - Data length out of range (1 to 8)."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	データ値を返す
			if (pCall->rchVmg != NULL) {
				u.n = 0;
				//	バッファからデータ取得
				u.n = 0;
				//	ビッグエンディアン
				if (fce) {
					memcpy(&u.b[8 - (UI)len], pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len);
					AjcExcAny(u.b, 8);
				}
				//	リトルエンディアン
				else {
					memcpy(&u.b[0], pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len);
				}
				//	戻り値設定
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, u.n)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	メモリブロック中のデータ書き込み		_PutMemBlk(BlkNo, Location, Bytes, data)							//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPutMemBlk			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				bno, loc, len;
	ULL				fce    = FALSE;	//	エンディアン変更フラグ
	union {
		UB		b[8];
		ULL		n;
	} u;

	if (pCall->nArg == 4 || pCall->nArg == 5) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
								   if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&bno, pCall))) break;
								   if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&loc, pCall))) break;
								   if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&len, pCall))) break;
								   if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&u.n, pCall))) break;
			if (pCall->nArg >= 5) {if (!(GetSIntByNode(pW, ppAgv[4], (SLLP)&fce, pCall))) break;}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	データ長チェック
			if (!(len >= 1 && len <= 8)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - データ長は１～８の範囲でなければなりません。",
												 "%s - Data length out of range (1 to 8)."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	エンディアン形式変更
			if (fce) AjcExcAny(u.b, (UI)len);
			//	データ値を設定
			memcpy(pW->ExeMemBlk[bno].pMemAddr + loc, u.b, (UI)len);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	メモリブロックのクリアー		_ClrMemBlk(BlkNo, Value)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunClrMemBlk			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				bno, val;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&bno, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&val, pCall))) break;
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロッククリアー
			memset(pW->ExeMemBlk[bno].pMemAddr, (UB)val, pW->ExeMemBlk[bno].MemLen);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	メモリブロックの１６進ダンプ表示	_DumpMemBlk(BlkNo [,loc] [,len])										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunDumpMemBlk		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				bno;
	ULL				loc    = 0;
	ULL				len    = -1;
	UI				i, ix, c, n;

	if (pCall->nArg >= 1 && pCall->nArg <= 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
								   if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&bno, pCall))) break;
			if (pCall->nArg >= 2) {if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&loc, pCall))) break;}
			if (pCall->nArg >= 3) {if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&len, pCall))) break;}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	ロケーションチェック
			if (loc >= pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ロケーションがメモリブロック範囲外です。",
												 "%s - Location out of memory block."), pCall->pFunName);
				break;
			}
			//	バイト数設定
			if (len == -1) {
				len = pW->ExeMemBlk[bno].MemLen - loc;
			}
			//	バイト数チェック
			else {
				//	メモリブロック超過チェック
				if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
													 "%s - Over the memry block."), pCall->pFunName);
					break;
				}
			}
			//	ダンプ表示
			if (len > 0) {
				//	先頭インデクス設定
				ix = (UI)(loc & -16);
				c  = 0;
				n  = (UI)len;
				//	ゲージ表示
				AjcCipPrintF(pW->hWndBack, "Loc.    0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F\n");
				//	１行目表示
				if ((loc & 15) != 0) {
					AjcCipPrintF(pW->hWndBack, "%04X : ", ix);
					ix = (UI)loc & 15;
					for (i = 0; i < ix; i++) {
						AjcCipPrintF(pW->hWndBack, "   ");
					}
					for (i = ix; i < 16; i++) {
						AjcCipPrintF(pW->hWndBack, " %02X", pW->ExeMemBlk[bno].pMemAddr[ix++]);
						if (++c >= n) break;
					}
					AjcCipPrintF(pW->hWndBack, "\n");
				}
				//	２行目以降表示
				while (c < n) {
					AjcCipPrintF(pW->hWndBack, "%04X : ", ix);
					for (i = 0; i < 16; i++) {
						AjcCipPrintF(pW->hWndBack, " %02X", pW->ExeMemBlk[bno].pMemAddr[ix++]);
						if (++c >= n) break;
					}
					AjcCipPrintF(pW->hWndBack, "\n");
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ファイル／ディレクトリ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ファイルオープン		_FOpen($_Path, $_Mode)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFOpen		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	UI				fno;
	C_BCP			pRW;
	C_BCP			pPath;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!((pPath = GetStrByNode(pW, ppAgv[0], pCall)))) break;
			if (!((pRW	 = GetStrByNode(pW, ppAgv[1], pCall)))) break;
			//	アクセスモードチェック
			if (mbscmp(pRW, "rt" ) != 0 && mbscmp(pRW, "wt" ) != 0 && mbscmp(pRW, "at" ) != 0 &&
				mbscmp(pRW, "rb" ) != 0 && mbscmp(pRW, "wb" ) != 0 && mbscmp(pRW, "ab" ) != 0) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なファイルアクセスモード(%s)です。",
												 "%s - Invalid file access mode(%s)."), pCall->pFunName, pRW);
				break;
			}
			//	空きファイル＃検索
			for (fno = 1; fno < AJCCIPMAX_FILES; fno++) {
				if (pW->ExeFile[fno].hFile == NULL) {
					break;
				}
			}
			if (fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
										  LNGSEL("%s - オープンしているファイルが多すぎます。",
												 "%s - Too many opened files."), pCall->pFunName);
				break;
			}
			//	ファイルオープン
			if ((pW->ExeFile[fno].hFile = fopen(pPath, pRW)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイル<%s>をオープンできません。。",
												 "%s - File <%s> Open failure."), pCall->pFunName, pPath);
				break;
			}
			//	アクセスモード設定
			AjcSnPrintFA(pW->ExeFile[fno].mode, sizeof pW->ExeFile[fno].mode, "%s", pRW);
			//	戻り値設定
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, fno)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ファイルクローズ		_FClose(FileNo)																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFClose		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	ファイルクローズ
			fclose(pW->ExeFile[fno].hFile);
			memset(&pW->ExeFile[fno], 0, sizeof pW->ExeFile[fno]);

			rc = TRUE;	//	戻り値=正常
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	テキストファイル書き込み		_FPutS($str)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFPutStr		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno;
	C_BCP			pStr;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			if (!(pStr = GetStrByNode(pW, ppAgv[1], pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	アクセスモードチェック
			if (mbscmp(pW->ExeFile[fno].mode, "wt") != 0 && mbscmp(pW->ExeFile[fno].mode, "at") != 0) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なファイルアクセスモード(%s)です。",
												 "%s - Invalid file access mode(%s)."), pCall->pFunName, pW->ExeFile[fno].mode);
			}
			//	テキスト書き込み
			fputs(pStr, pW->ExeFile[fno].hFile);

			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	バイナリファイル読み出し		_FRead(FileNo, BlkNo, Location, Bytes)										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFRead		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno, bno, loc, len;
	ULL				bytes;

	if (pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&bno, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&loc, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&len, pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	アクセスモードチェック
			if (mbscmp(pW->ExeFile[fno].mode, "rb") != 0) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なファイルアクセスモード(%s)です。",
												 "%s - Invalid file access mode(%s)."), pCall->pFunName, pW->ExeFile[fno].mode);
			}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	バイナリデータ読み出し
			bytes = fread(pW->ExeMemBlk[bno].pMemAddr + loc, 1, (size_t)len, pW->ExeFile[fno].hFile);
			//	戻り値設定
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, bytes)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	バイナリファイル書き込み		_FWrite(FileNo, BlkNo, Location, Bytes)										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFWrite		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno, bno, loc, len;
	ULL				bytes;

	if (pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&bno, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&loc, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&len, pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	アクセスモードチェック
			if (mbscmp(pW->ExeFile[fno].mode, "wb") != 0 && mbscmp(pW->ExeFile[fno].mode, "ab") != 0) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なファイルアクセスモード(%s)です。",
												 "%s - Invalid file access mode(%s)."), pCall->pFunName, pW->ExeFile[fno].mode);
			}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	バイナリデータ書き込み
			bytes = fwrite(pW->ExeMemBlk[bno].pMemAddr + loc, 1, (size_t)len, pW->ExeFile[fno].hFile);
			//	戻り値設定
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, bytes)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ファイルポインタ取得		_FGetSeek(FileNo)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFGetSeek		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno, pos;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	ファイルポインタ取得
			if ((pos = _ftelli64(pW->ExeFile[fno].hFile)) == -1) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルポインタの取得を失敗しました。",
												 "%s - File pointer getting failure."), pCall->pFunName);
				break;
			}
			//	戻り値設定
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pos)) break;
			}

			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	ファイルポインタ移動		_FSeek	 (FileNo, Location)														//
//								_FSetSeek(FileNo, Location)														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFSetSeek		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno, loc;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&loc, pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	ファイルポインタ移動
			_fseeki64(pW->ExeFile[fno].hFile, loc, SEEK_SET);

			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	テキストファイル読み出し		$_FGetS(FileNo)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFGetStr		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				fno;
	BC				txt[1024];

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&fno, pCall))) break;
			//	ファイル番号チェック
			if (fno < 1 || fno >= AJCCIPMAX_FILES) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不当なファイル番号 (%llu) です。",
												 "%s - Invalid file number <%llu>."), pCall->pFunName, fno);
				break;
			}
			//	ファイルオープン済かチェック
			if (pW->ExeFile[fno].hFile == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルがオープンされていません。",
												 "%s - File is not opened."), pCall->pFunName);
				break;
			}
			//	アクセスモードチェック
			if (mbscmp(pW->ExeFile[fno].mode, "rt") != 0) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なファイルアクセスモード(%s)です。",
												 "%s - Invalid file access mode(%s)."), pCall->pFunName, pW->ExeFile[fno].mode);
			}
			//	ファイル読み出し
			if (!fgets(txt, sizeof txt, pW->ExeFile[fno].hFile)) {
				txt[0] = 0;
			}
			//	読み出した文字列を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, txt)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ファイル削除		$_FDelete($FilePath)																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunFDelete(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pPath;

	if (pCall->nArg >= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pPath = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	ファイル削除
			if (!DeleteFileA(pPath)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイルを削除できません。",
												 "%s - Unable to delete the file."), pCall->pFunName);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	フォルダ作成		$_MakeFolder($FolderPath)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMakeFolder(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pPath;

	if (pCall->nArg >= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pPath = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	フォルダ作成
			MakeSureDirectoryPathExists(pPath);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	パスが存在するかチェック	_PathExists($Path)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPathExists(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pPath;
	BOOL			fExist;

	if (pCall->nArg >= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pPath = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	パスの存在チェック
			fExist = AjcPathExistsA(pPath);
			//	戻り値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, fExist)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	パスが実在するフォルダかチェック	_PathIsFolder($Path)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunPathIsFolder(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pPath;
	BOOL			fExist;

	if (pCall->nArg >= 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pPath = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	フォルダ作成
			fExist = AjcPathIsDirectoryA(pPath);
			//	戻り値を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, fExist)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ファイル名／フォルダ名取得																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	オープンファイル名取得		$_GetOpenFile([$Title] [,$Filter] [,$DefExt] [,DefFile])						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetOpenFile		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pTtl = "";
	C_BCP			pFlt = "All Files(*.*)/*.*";
	C_BCP			pExt = "txt";
	C_BCP			pDef = "";

	if (pCall->nArg >= 0 || pCall->nArg <= 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg >= 1) {if (!(pTtl = GetStrByNode(pW, ppAgv[0], pCall))) break;}
			if (pCall->nArg >= 2) {if (!(pFlt = GetStrByNode(pW, ppAgv[1], pCall))) break;}
			if (pCall->nArg >= 3) {if (!(pExt = GetStrByNode(pW, ppAgv[2], pCall))) break;}
			if (pCall->nArg >= 4) {if (!(pDef = GetStrByNode(pW, ppAgv[3], pCall))) break;}
			if (*pFlt == 0) pFlt = "All Files(*.*)/*.*";
			if (*pExt == 0) pFlt = "txt";
			if (*pDef != 0) AjcSnPrintFA(pW->ExeOpenFile, sizeof pW->ExeOpenFile, "%s", pDef);
			//	オープンファイル名を取得
			if (!AjcGetOpenFileA(pW->hWndBack, pTtl, pFlt, pExt, pW->ExeOpenFile, sizeof pW->ExeOpenFile)) {
				pW->ExeOpenFile[0] = 0;
			}
			//	オープンファイル名を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->ExeOpenFile)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	セーブファイル名取得		$_GetSaveFile([$Title[ [,$Filter] [,$DefExt] [,DefFile])						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetSaveFile		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pTtl = "";
	C_BCP			pFlt = "All Files(*.*)/*.*";
	C_BCP			pExt = "txt";
	C_BCP			pDef = "";

	if (pCall->nArg >= 0 || pCall->nArg <= 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg >= 1) {if (!(pTtl = GetStrByNode(pW, ppAgv[0], pCall))) break;}
			if (pCall->nArg >= 2) {if (!(pFlt = GetStrByNode(pW, ppAgv[1], pCall))) break;}
			if (pCall->nArg >= 3) {if (!(pExt = GetStrByNode(pW, ppAgv[2], pCall))) break;}
			if (pCall->nArg >= 4) {if (!(pDef = GetStrByNode(pW, ppAgv[3], pCall))) break;}
			if (*pFlt == 0) pFlt = "All Files(*.*)/*.*";
			if (*pExt == 0) pFlt = "txt";
			if (*pDef != 0) AjcSnPrintFA(pW->ExeOpenFile, sizeof pW->ExeSaveFile, "%s", pDef);
			//	セーブファイル名を取得
			if (!AjcGetSaveFileA(pW->hWndBack, pTtl, pFlt, pExt, pW->ExeSaveFile, sizeof pW->ExeSaveFile)) {
				pW->ExeSaveFile[0] = 0;
			}
			//	セーブファイル名を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->ExeSaveFile)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	フォルダ名取得		$_GetFolder([$WndTitle] [,$BoxTitle] [,DefFolder])										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetFolder		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pWndTtl = "";
	C_BCP			pBoxTtl = "";
	C_BCP			pDefDir = "";

	if (pCall->nArg >= 0 && pCall->nArg <= 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg >= 1) {if (!(pWndTtl = GetStrByNode(pW, ppAgv[0], pCall))) break;}
			if (pCall->nArg >= 2) {if (!(pBoxTtl = GetStrByNode(pW, ppAgv[1], pCall))) break;}
			if (pCall->nArg >= 3) {if (!(pDefDir = GetStrByNode(pW, ppAgv[2], pCall))) break;}
			if (*pDefDir != 0) AjcSnPrintFA(pW->ExeFolder, sizeof pW->ExeFolder, "%s", pDefDir);
			//	フォルダ名を取得
			if (!AjcGetFolderNameA(pW->hWndBack, pWndTtl, pBoxTtl, pW->ExeFolder, sizeof pW->ExeFolder)) {
				pW->ExeFolder[0] = 0;
			}
			//	フォルダ名を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->ExeFolder)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	マクロファイルのパス名取得		$_GetMacFilePath()															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetMacFilePath (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;

	if (pCall->nArg == 0) {
		do {
			//	パス名を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->MacFile)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ファイル検索		$_SearchFiles($_Folder, fSubDir [,Wild1] [, Wild2] ... )								//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
typedef struct {
	HAJCCIP		pW;
	HAJCVQUE	hVQue;
} AFSF_PARAM, *PAFSF_PARAM;
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbAfsfSearchFiles(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp)
{
	PAFSF_PARAM	p  = (PAFSF_PARAM)cbp;
	HAJCCIP 	pW = p->pW;
	PAJCCIPCALL	pCall;
	BOOL		RetVal = TRUE;

	//	通知処理（戻り情報を要する為、イベントのキューイングせずに、この場で呼び出す）
	if (nest == -1) {	//	検索中フォルダ通知（この場でイベント関数を実行）
		if (!pW->fExeEventBusy && pW->nExeDisStdEvt == 0) {						//	イベント未実行＆イベント許可状態？
			pW->fExeEventBusy = TRUE;											//		イベント実行中フラグ設定
			if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnFileSearch")) {	//		呼び出し情報生成
				pCall->pReturn = pW->pCur;										//			戻りアドレス
				AjcCipCallInfoInsString(pW->hWndBack, pCall, pPath);			//			第１引数（フォルダパス名）
				CipExeFuncCall(pW, pCall, NULL);								//			実行
																				//			戻り値設定
				if (pW->NumType == AJCIPT_INTEGER) RetVal = (BOOL)*AjcCipGetRetInt (pW->hWndBack, NULL);
				else							   RetVal = (BOOL)*AjcCipGetRetReal(pW->hWndBack, NULL);
				AjcCipCallInfoDelete(pW->hWndBack, pCall);						//			呼び出し情報破棄
			}
			pW->fExeEventBusy = FALSE;											//		イベント実行中フラグ解除
		}
	}
	else {				//	検索ファイル通知（キューにファイルパスを蓄積）
		AjcVQueEnque(p->hVQue, pPath, (UI)strlen(pPath) + 1);
	}
	//	Windowsイベント処理
	CipGsrDoEvent(pW);

	return (!p->pW->fRunStop && RetVal);		//	TRUE:検索継続，FALSE:検索中止
}
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipFunSearchFiles (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pDir;
	C_BCP			pWild;
	ULL				fSubDir;
	UI				i, j, ix, n, wdl, stl;
	PCAJCVMGNODEA	pNode;
	BCP				pPath;
	BC				wild[1024];
	AFSF_PARAM		prm;
	BOOL			fFirst = TRUE;

	if (pCall->nArg >= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pDir	 = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (!GetSIntByNode(pW, ppAgv[1], &fSubDir, pCall)) break;
			//	キューインスタンス生成
			if (!(prm.hVQue = AjcVQueCreate(0, NULL))) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
									  LNGSEL("%s - ワークメモリを確保できません。",
											 "%s - Work memory allocation failure."), pCall->pFunName);
				break;
			}
			//	ワイルドカード文字列作成
			if (pCall->nArg >= 3) {
				wdl = 0;
				wild[0] = 0;
				for (i = 2; i < pCall->nArg; i++) {
					if (ppAgv[i]->fArr) {		//	配列変数？
						//	引数のノード取得
						if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[i]->val.arr.hVmg, ppAgv[i]->val.arr.pName)) == NULL) {
							goto cfsf_exit;
						}
						if (pNode->type == AJCIPT_STRING) {
							//	ワイルドカード群生成
							for (j = 0; j < pNode->num; j++) {
								if (stl = (UI)strlen(pNode->arr.pStr[j])) {
									//	最初以外は、末尾にセミコロン(;)付加
									if (!fFirst) {
										if (wdl + 1 < sizeof wild) strcat(wild, ";");
										wdl++;
									}
									fFirst = FALSE;
									//	ワイルドカード追加
									
									if (wdl + stl < sizeof wild - 1) {
										strcat(wild, pNode->arr.pStr[j]);
										wdl += stl;
									}
								}
							}
						}
						else {
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
													  LNGSEL("%s - %d番目の引数は、文字型でなければなりません。",
															 "%s - Must be string type in %d[th] argument."), pCall->pFunName, ppAgv[i]->seq + 1);
							rc = FALSE;
							break;
						}
					}
					else {						//	単純変数？
						//	引数値取得
						if (!(pWild = GetStrByNode(pW, ppAgv[i], pCall))) goto cfsf_exit;
							if (stl = (UI)strlen(pWild)) {
							//	最初以外は、末尾にセミコロン(;)付加
							if (!fFirst) {
								if (wdl + 1 < sizeof wild) strcat(wild, ";");
								wdl++;
							}
							fFirst = FALSE;
							//	ワイルドカード追加
							if (wdl + stl < sizeof wild - 1) {
								strcat(wild, pWild);
								wdl += stl;
						}
						}
					}
				}
			}
			else {
				strcpy(wild, "*.*");
			}
			//	ファイル検索中チェック
			if (pW->fExeFileSearch) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
										  LNGSEL("%s - ファイル検索中に $_SearchFiles() は実行できません。",
												 "%s - Do not execution $_SearchFiles() in File searching."), pCall->pFunName);
				rc = FALSE;
				break;
			}
			//	ファイル検索中フラグ設定
			pW->fExeFileSearch = TRUE;
			//	ファイル検索
			prm.pW = pW;
			AjcSetNtcSearchingDir(TRUE);
			n = AjcSearchFilesA(pDir, wild, (BOOL)fSubDir, (UX)&prm, cbAfsfSearchFiles);
			//	戻り情報設定
			if (!pW->fRunStop) {
				if (pCall->rchVmg != NULL) {
					//	戻り変数を配列でリメイク
					if (!CipVmgDelVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) break;
					if (!CipVmgGenVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (AJCVMGTYPE)AJCIPT_STRING, (UI)n)) break;
					//	作成したパス名配列を返す
					ix = 0;
					if (pPath = (BCP)AjcVQueTopNode(prm.hVQue, NULL)) {
						do {
							if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)ix, pPath)) goto cfsf_exit;
							ix++;
						} while (pPath = (BCP)AjcVQueNextNode(prm.hVQue, pPath, NULL));
					}
					//	戻り値=正常
					rc = TRUE;
				}
				else rc = TRUE;			//	戻り値を設定しない場合はOKとする
			}
		} while(0);
cfsf_exit:;
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
		//	キューインスタンス消去
		if (prm.hVQue != NULL)	{AjcVQueDelete(prm.hVQue); prm.hVQue = NULL;}
		//	ファイル検索中フラグ解除
		pW->fExeFileSearch = FALSE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	パス名分解		$_SplitPath($PathName)																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSplitPath		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pPath;
	BC				drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pPath = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	パス名分解
			_splitpath(pPath, drv, dir, fname, ext);
			//	分解したパス名の配列を返す
			if (pCall->rchVmg != NULL) {
				//	戻り変数を配列でリメイク
				if (!CipVmgDelVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym)) break;
				if (!CipVmgGenVar(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, AJCIPT_STRING, 4)) break;

				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 0, drv  )) break;
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 1, dir  )) break;
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 2, fname)) break;
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, 3, ext  )) break;
				//	戻り値=正常
				rc = TRUE;
			}
			else rc = TRUE;		//	戻り変数が無い場合はＯＫとする
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	パス名作成		$_MakePath($drive[, $dir] [, $fname] [, $ext])												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunMakePath		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pDrv, pDir, pFName, pExt;
	BC				path[MAX_PATH];
	PCAJCVMGNODEA	pNode;

	if (pCall->nArg >= 1 && pCall->nArg <= 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	パス名組み立て
			if (ppAgv[0]->fArr) {	//	配列変数
				if (pCall->nArg == 1) {
					//	引数のノード取得
					if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == NULL) {
						break;
					}
					if (pNode->type == AJCIPT_STRING && pNode->num >= 4) {
						//	パス名作成
						_makepath(path, pNode->arr.pStr[0], pNode->arr.pStr[1], pNode->arr.pStr[2], pNode->arr.pStr[3]);
					}
					else {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
												  LNGSEL("%s - 文字型配列でないか、配列の項目数が少なすぎます。",
														 "%s - Not string array or too few array elements."), pCall->pFunName);
						break;
					}
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
											  LNGSEL("%s - 引数の個数が不正です。",
													 "%s - Invalid number of arguments."), pCall->pFunName);
					break;
				}
			}
			else {					//	単純変数
				pDrv = pDir = pFName = pExt = "";
				if (pCall->nArg >= 1 && !(pDrv	 = GetStrByNode(pW, ppAgv[0], pCall))) break;
				if (pCall->nArg >= 2 && !(pDir	 = GetStrByNode(pW, ppAgv[1], pCall))) break;
				if (pCall->nArg >= 3 && !(pFName = GetStrByNode(pW, ppAgv[2], pCall))) break;
				if (pCall->nArg >= 4 && !(pExt	 = GetStrByNode(pW, ppAgv[3], pCall))) break;
				//	パス名作成
				_makepath(path, pDrv, pDir, pFName, pExt);
			}
			//	作成したパス名を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, path)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	プロファイルアクセス																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	プロファイルセクション名設定		$_SetProfileSect($sect)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetProfileSect (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pStr;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pStr = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	セクション名設定
			if (*pStr != 0) {
				AjcSnPrintFA(pW->ExeSect, sizeof pW->ExeSect, "%s\\%s", pStr, pW->MacFName);
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - セクション名が空文字列です。",
												 "%s - Section name is null-string."), pCall->pFunName);
				break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルへ値を記録		$_SetProfileVal($key, value)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetProfileVal (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pKey;
	union {SLL sint; double real;} uVal;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pKey = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (pW->NumType == AJCIPT_INTEGER) {if (!(GetSIntByNode(pW, ppAgv[1], &uVal.sint, pCall))) break;}
			else							   {if (!(GetRealByNode(pW, ppAgv[1], &uVal.real, pCall))) break;}
			//	プロファイルへ値設定
			AjcPutProfileArrA(pW->ExeSect, pKey, &uVal, 8, 1);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルへ文字列を記録		$_SetProfileStr($key, $str)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunSetProfileStr (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pKey;
	C_BCP			pStr;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pKey = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (!(pStr = GetStrByNode(pW, ppAgv[1], pCall))) break;
			//	プロファイルへ文字列設定
			AjcPutProfileStrA(pW->ExeSect, pKey, pStr);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルから値を読み出す		$_GetProfileVal($key, defval)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetProfileVal (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pKey;
	union {SLL sint; double real;} uVal;
	union {SLL sint; double real;} uDef;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pKey = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (pW->NumType == AJCIPT_INTEGER) {
				if (!(GetSIntByNode(pW, ppAgv[1], &uDef.sint, pCall))) break;
			}
			else {
				if (!(GetRealByNode(pW, ppAgv[1], &uDef.real, pCall))) break;
			}
			//	プロファイルから値読み出し
			if (AjcGetProfileArrA(pW->ExeSect, pKey, &uVal, 8, 1) == 0) {
				if (pW->NumType == AJCIPT_INTEGER) uVal.sint = uDef.sint;
				else							   uVal.real = uDef.real;
			}
			//	読みだした値を返す
			if (pCall->rchVmg != NULL) {
				if (pW->NumType == AJCIPT_INTEGER) {if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, uVal.sint)) break;}
				else							   {if (!CipVmgSetReal	 (pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, uVal.real)) break;}
			}

			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルから文字列を読み出す		$_GetProfileStr($key, $defstr)										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetProfileStr (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pKey, pDef;
	BC				str[512];

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pKey = GetStrByNode(pW, ppAgv[0], pCall))) break;
			if (!(pDef = GetStrByNode(pW, ppAgv[1], pCall))) break;
			//	プロファイルから文字列読み出し
			AjcGetProfileStrA(pW->ExeSect, pKey, pDef, str, sizeof str);
			//	読みだした文字列を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, str)) {
					break;
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＣＯＭポートアクセス																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ＣＯＭポート生成	_ComCreate([{PortNo | $MySlotName}])													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComCreate(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc		= FALSE;
	PAJCCIPAGV		*ppAgv	= NULL;
	ULL				port	= 0;
	C_BCP			pMySlot = NULL;
	HWND			hwnd;
	HAJCSCP			hScp;

	if (pCall->nArg == 0 || pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	ポート番号／自メールスロット名指定値設定
			if (pCall->nArg == 1) {
				//	引数値設定（自スロット名）
				if (ppAgv[0]->typ == AJCIPT_STRING) {
					if (!(pMySlot = GetStrByNode(pW, ppAgv[0], pCall))) break;
					port = SLOT_PORT;
				}
				//	引数値設定（ＣＯＭポート番号）
				else {
					if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
					//	引数値チェック
					if (!ChkPortNumber(pW, pCall, port, MIN_COMPORT, MAX_COMPORT)) {
						break;
					}
				}
			}
			//	ＳＣＰ仮生成（メールスロット）
			if (port == SLOT_PORT) {
				port = SLOT_PORT;
				if ((hScp = AjcScpCreateExA("SerialPort", TRUE, pMySlot, NULL, NULL)) == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - メールスロット(%s)の初期化を失敗しました。",
													 "%s - Port(%s) initialization failure."), pCall->pFunName, pMySlot);
					break;
				}
			}
			//	ＳＣＰ仮生成（ＣＯＭポート）
			else {
				if ((hScp = AjcScpCreateExA("SerialPort", FALSE, NULL, NULL, NULL)) == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - ポート(COM%d)の初期化を失敗しました。",
													 "%s - Port(COM%d) initialization failure."), pCall->pFunName, port);
					break;
				}
				//	引数が無い場合、設定済ポート番号取得
				if (port == 0) port = AjcScpGetParam(hScp, NULL, NULL);
			}
			//	新ポート生成済ならば、一旦破棄する
			if (pW->ExeScp[port].hScp != NULL) {
				AjcScpDelete(pW->ExeScp[port].hScp);					//	ＳＣＰ消去
				DestroyWindow(pW->ExeScp[port].hwnd);					//	ウインド破棄
				memset(&pW->ExeScp[port], 0, sizeof pW->ExeScp[port]);	//	ＳＣＰ管理情報クリアー
			}
			//	イベント通知用ウインド生成
			hwnd = CreateWindowA(AJCCIP_SCPWNDCLASS, 			// window class name
								 "",							// window caption
								 WS_OVERLAPPEDWINDOW,			// style
								 0,								// initial x position
								 0,								// initial y position
								 0,								// initial x size
								 0,								// initial y size
								 NULL,							// parent window handle
								 NULL,							// window menu handle
								 hDllInst,						// program instance handle
								 NULL);							// creation parameters

			if (hwnd == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)の初期化を失敗しました。",
												 "%s - Port(#%d) initialization failure."), pCall->pFunName, (UI)port);
				AjcScpDelete(hScp);
				break;
			}
			//	ウインド非表示
			ShowWindow(hwnd, SW_HIDE);
			//	ＳＣＰモード設定
			AjcScpSetMode(hScp, hwnd, WM_CIP_SCPEVENT, FALSE);				//	モード設定（FALSE:ﾊﾞｲﾅﾘ・ﾁｬﾝｸ）
			AjcScpSetRxTextCode(hScp, AJCSCP_TXT_SJIS);						//	受信テキストの文字コード＝Ｓ-ＪＩＳ
			AjcScpSetEvtMask(hScp, AJCSCP_EV_RXTEXT | AJCSCP_EV_RXCTRL);	//	イベント設定（テキスト，制御コード受信のみ許可）
			//	インスタンスワーク，ポート番号設定
			MAjcSetWindowLong(hwnd, sizeof(UX) * 0, (UX)pW);
			MAjcSetWindowLong(hwnd, sizeof(UX) * 1, (UX)port);
			//	管理情報設定
			pW->ExeScp[port].hScp = hScp;
			pW->ExeScp[port].hwnd = hwnd;
			//	ポート番号を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, port)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポート生成（ダイアログ）	_ComCreateByDialog([OldPort])												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComCreateByDialog(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	UI				NewPort;
	HWND			hwnd;
	HAJCSCP			hScp;
	SLL				OldPort = 0;

	if (pCall->nArg == 0 || pCall->nArg == 1) {
		do {
			//	引数＝１個の場合、旧ポート番号設定，チェック
			if (pCall->nArg == 1) {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	引数値設定
				if (!(GetSIntByNode(pW, ppAgv[0], &OldPort, pCall))) break;
				//	ポート番号チェック
				if (!ChkPortNumber(pW, pCall, OldPort, 0, MAX_PORT)) {
					break;
				}
			}

			//	旧ＣＯＭ生成済ならば、パラメタセーブ
			if (OldPort != 0 && pW->ExeScp[OldPort].hScp != NULL) {
				AjcScpSaveParamToProfile(pW->ExeScp[OldPort].hScp, NULL);
			}
			//	ＳＣＰ仮生成
			if ((hScp = AjcScpCreateExA("SerialPort", FALSE, NULL, NULL, NULL)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポートの初期化を失敗しました。",
												 "%s - Port initialization failure."), pCall->pFunName);
				break;
			}
			//	ダイアログによるパラメタ設定
			AjcScpSetDialogGrayMask(hScp, AJCSCPGRY_SetDetail);
			//	新ＣＯＭポート生成
			if (AjcScpDlgParamEasy	(hScp, pW->hWndVth)) {
				//	ポート番号設定
				NewPort = AjcScpGetParam(hScp, NULL, NULL);
				//	ＳＣＰ生成済ならば、一旦破棄する
				if (pW->ExeScp[NewPort].hScp != NULL) {
					AjcScpDelete(pW->ExeScp[NewPort].hScp);							//	ＳＣＰ消去
					DestroyWindow(pW->ExeScp[NewPort].hwnd);						//	ウインド破棄
					memset(&pW->ExeScp[NewPort], 0, sizeof pW->ExeScp[NewPort]);	//	ＳＣＰ管理情報クリアー
				}
				//	イベント通知用ウインド生成
				hwnd = CreateWindowA(AJCCIP_SCPWNDCLASS, 			// window class name
								 	 "",							// window caption
									 WS_OVERLAPPEDWINDOW,			// style
									 0,								// initial x position
									 0,								// initial y position
									 0,								// initial x size
									 0,								// initial y size
									 NULL,							// parent window handle
									 NULL,							// window menu handle
									 hDllInst,						// program instance handle
									 NULL);							// creation parameters

				if (hwnd == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - ポート(#%d)の初期化を失敗しました。",
													 "%s - Port(#%d) initialization failure."), pCall->pFunName, (UI)NewPort);
					AjcScpDelete(hScp);
					break;
				}
				//	ウインド非表示
				ShowWindow(hwnd, SW_HIDE);
				//	ポート２５６（メールスロット）ならば、自メールスロット生成
				if (NewPort == SLOT_PORT) {
					if (!AjcScpCreateMySlot(hScp)) {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
												  LNGSEL("%s - メールスロット(%s)の生成を失敗しました。",
														 "%s - MailSlot(%s) creation failure."), pCall->pFunName, AjcScpGetMySlotPathName(hScp));
						AjcScpDelete(hScp);
						break;
					}
				}
				//	旧ＣＯＭポート破棄
				if (OldPort != 0 && OldPort != NewPort && pW->ExeScp[OldPort].hScp != NULL) {
					AjcScpDelete(pW->ExeScp[OldPort].hScp);							//	ＳＣＰ消去
					DestroyWindow(pW->ExeScp[OldPort].hwnd);						//	ウインド破棄
					memset(&pW->ExeScp[OldPort], 0, sizeof pW->ExeScp[NewPort]);	//	ＳＣＰ管理情報クリアー
				}
				//	ＳＣＰモード設定
				AjcScpSetMode(hScp, hwnd, WM_CIP_SCPEVENT, FALSE);		//	モード設定（FALSE:ﾊﾞｲﾅﾘ・ﾁｬﾝｸ）
				AjcScpSetRxTextCode(hScp, AJCSCP_TXT_SJIS);				//	受信テキストの文字コード＝Ｓ-ＪＩＳ
				//	インスタンスワーク，ポート番号設定
				MAjcSetWindowLong(hwnd, sizeof(UX) * 0, (UX)pW);
				MAjcSetWindowLong(hwnd, sizeof(UX) * 1, (UX)NewPort);
				//	管理情報設定
				pW->ExeScp[NewPort].hScp = hScp;
				pW->ExeScp[NewPort].hwnd = hwnd;
			}
			else {
				//	仮生成したＳＣＰを破棄
				AjcScpDelete(hScp);
				//	戻り値＝キャンセル
				NewPort = 0;
			}
			//	ポート番号を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, NewPort)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポート破棄	_ComDelete(PortNo)																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComDelete(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp != NULL) {
				//	スロットオープン状態ならば、スロットクローズ通知
				if (port == SLOT_PORT && AjcScpIsOpened(pW->ExeScp[port].hScp)) {
					SendMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_SLOTCLOSE), (LPARAM)pW->hWndBack);
				}
				//	ＳＣＰ消去
				AjcScpDelete(pW->ExeScp[port].hScp);
				//	ウインド破棄
				DestroyWindow(pW->ExeScp[port].hwnd);
				//	ＳＣＰ管理情報クリアー
				memset(&pW->ExeScp[port], 0, sizeof pW->ExeScp[port]);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートオープン	_ComOpen(PortNo [, Rate] [, DataLen] [, Parity] [, StopBit])						//
//							_ComOpen([$RemoteSlotName] [,$RemoteComputerName]									//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComOpen(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port = 0, rate = 0, dlen = 0, pari = 0, stpbit = 0;
	BOOL			rsu;
	C_BCP			pRmtSlot = NULL;
	C_BCP			pRmtHost = NULL;

	if (pCall->nArg >= 0 && pCall->nArg <= 5) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	ＣＯＭ／スロット判別
			if (pCall->nArg >= 1) {
				//	第１引数が文字型ならば、メールスロットのオープン
				if (ppAgv[0]->typ == AJCIPT_STRING) {
					port = SLOT_PORT;
				}
				//	第１引数が数値ならば、1～255:COMポート，256:メールスロット
				else {
					if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
				}
			}
			//	引数が無い場合は、メールスロットのオープン
			else {
				port = SLOT_PORT;
			}
			//----- メールスロット -----------------------------------------------------------------------------//
			if (port == SLOT_PORT) {
				//	引数の個数チェック
				if (pCall->nArg >= 3) {
					Err_InvalidArguments(pW, pCall); // 引数の個数が不正です。
					break;
				}
				//	引数値設定（第１引数で、port=256 が指定された場合は、規定値でメールスロットオープン）
				if (pCall->nArg >= 1 && ppAgv[0]->typ != AJCIPT_STRING) {
					if (pCall->nArg >= 2) {
						Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
						break;
					}
				}
				//	引数値設定（第１引数が文字型ならば、指定名称でメールスロットオープン）
				else {
					if (pCall->nArg >= 1) {if (!(pRmtSlot = GetStrByNode(pW, ppAgv[0], pCall))) break;}
					if (pCall->nArg >= 2) {if (!(pRmtHost = GetStrByNode(pW, ppAgv[1], pCall))) break;}
				}
			}
			//----- ＣＯＭポート -------------------------------------------------------------------------------//
			else {
				//	第１引数値設定
				if (!ChkPortNumber(pW, pCall, port, MIN_COMPORT, MAX_COMPORT)) {
					break;
				}
				//	第２引数設定
				if (pCall->nArg >= 2) {
					if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&rate, pCall))) break;
				}
				//	第３引数設定
				if (pCall->nArg >= 3) {
					if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&dlen, pCall))) break;
					if (dlen < 7 || dlen > 8) {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
												  LNGSEL("%s - データビット長が不正です。",
														 "%s - Invalid data bits length."), pCall->pFunName);
						break;
					}
				}
				//	第４引数設定
				if (pCall->nArg >= 4) {
					if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&pari, pCall))) break;
					if (pari > 2) {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
												  LNGSEL("%s - パリティ指定が不正です。",
														 "%s - Invalid parity bit."), pCall->pFunName);
						break;
					}
					//	パリティ指定値設定
					switch (pari) {
						case 0:	pari = 'N';	break;
						case 1:	pari = 'O';	break;
						case 2:	pari = 'E';	break;
					}
				}
				//	第５引数設定
				if (pCall->nArg >= 5) {
					if (!(GetSIntByNode(pW, ppAgv[4], (SLLP)&stpbit, pCall))) break;
					if (stpbit < 1 || stpbit > 2) {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
												  LNGSEL("%s - ストップビット指定が不正です。",
														 "%s - Invalid stop bits number."), pCall->pFunName);
						break;
					}
				}
			}
			//--------------------------------------------------------------------------------------------------//
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)が初期化されていません。",
												 "%s - Not initialized Port(#%d)."), pCall->pFunName, (UI)port);
				break;
			}
			//	イベントマスク設定
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, pW->ExeScp[port].EvtMask);
			//	ポートオープン
			if (port == SLOT_PORT) rsu = AjcScpOpenSlotA(pW->ExeScp[port].hScp, pRmtHost, pRmtSlot);
			else				   rsu = AjcScpOpen 	(pW->ExeScp[port].hScp, (UI)port, (UI)rate, (UI)dlen, (UI)pari, (UI)stpbit);
			//	スロットオープン通知
			if (rsu) {
				if (port == SLOT_PORT) {
					AJCCIPSLOTNAMES	prm;
					BC				MySlot [AJCMAX_SLOTNAME_LENGTH + 1] = {0};
					BC				RmtHost[AJCMAX_HOSTNAME_LENGTH + 1] = {0};
					BC				RmtSlot[AJCMAX_SLOTNAME_LENGTH + 1] = {0};
					prm.pMySlot  = MySlot;
					prm.pRmtHost = RmtHost;
					prm.pRmtSlot = RmtSlot;
					AjcScpGetMailSlotNamesA(pW->ExeScp[port].hScp, MySlot, RmtHost, RmtSlot);
					SendMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_SLOTOPEN),
														 fCmdWithHdl ? (LPARAM)pW->hWndBack : (LPARAM)&prm);
				}
			}
			//	オープンエラー・メッセージ
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)をオープンできません。",
												 "%s - Port(#%d) open failure."), pCall->pFunName, (UI)port);
				break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	ＣＯＭポートがオープン可能かチェック	_ComIsOpenPossible(PortNo)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComIsOpenPossible(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	BOOL			rsu	   = FALSE;
	BC				PortName[MAX_PATH];

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	第１引数値（ポート番号）設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成，オープン可能チェック
			if (pW->ExeScp[port].hScp != NULL) {
				//	ＣＯＭポートオープンチェック
				if (port >= MIN_COMPORT && port <= MAX_COMPORT) {
					HANDLE	hCom   = NULL;
					AjcSnPrintFA(PortName, sizeof PortName, "\\\\.\\COM%u", (UI)port);
					if ((hCom = CreateFileA(PortName, GENERIC_WRITE | GENERIC_READ, 0, NULL,
											OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
						CloseHandle(hCom);
						rsu = TRUE;
					}
				}
				//	メールスロットオープンチェック
				else if (port == 256) {
					HANDLE	hSlot	= NULL;
					//	相手スロットオープンチェック
					AjcSnPrintFA(PortName, sizeof PortName, "%s", AjcScpGetPortPathName(pW->ExeScp[port].hScp));
					if ((hSlot = CreateFileA(PortName, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
											 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
						CloseHandle(hSlot);
						rsu = TRUE;
					}
				}
			}
			//	チェック結果を返す
			if (pCall->rchVmg != NULL) {
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rsu)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートのオープン状態チェック	_ComIsOpened(PortNo)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComIsOpened(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	第１引数値（ポート番号）設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	オープン状態を返す
			if (pCall->rchVmg != NULL) {
				UI fOpened = FALSE;
				if (pW->ExeScp[port].hScp != NULL) fOpened = (AjcScpIsOpened(pW->ExeScp[port].hScp) != 0);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, fOpened)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートクローズ	_ComClose(PortNo)																	//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComClose(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp != NULL) {
				//	スロットオープン状態ならば、スロットクローズ通知
				if (port == SLOT_PORT && AjcScpIsOpened(pW->ExeScp[port].hScp)) {
					SendMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_SLOTCLOSE), (LPARAM)pW->hWndBack);
				}
				//	ＳＣＰクローズ
				Sleep(10);
				AjcScpClose(pW->ExeScp[port].hScp);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭテキスト送信	_ComSendText(PortNo, $Text1 [, $Text2)] ... )											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSendText(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	UI				i;
	ULL				port;
	C_BCP			pText;

	if (pCall->nArg >= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成，オープン済チェック
			if (pW->ExeScp[port].hScp == NULL || !AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)が未初期化／未オープンです。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	テキスト送信
			for (i = 1; i < pCall->nArg; i++) {
				if (!(pText = GetStrByNode(pW, ppAgv[i], pCall))) goto cfst_exit;
				AjcScpSendTextA(pW->ExeScp[port].hScp, pText, -1);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);
cfst_exit:;
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭバイナリ送信	_ComSendBinary(PortNo, MemBlkNo, loc, len)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSendBinary(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port, bno, loc, len;

	if (pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&bno , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&loc , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&len , pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成，オープン済チェック
			if (pW->ExeScp[port].hScp == NULL || !AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)が未初期化／未オープンです。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	バイナリ送信
			AjcScpSendBinData(pW->ExeScp[port].hScp, pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭバイトデータ送信	_ComSendBytes(PortNo, b1 [,b2] ・・・)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSendBytes(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port, dat;
	UI				i, ix, len;
	UBP				pDat = NULL;

	if (pCall->nArg >= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値（ポート番号設定）
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成，オープン済チェック
			if (pW->ExeScp[port].hScp == NULL || !AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)が未初期化／未オープンです。",
												 "%s - Port(#%d) is not initialized or not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	送信バイト数設定
			len = pCall->nArg - 1;
			//	データブロック割り当て
			if ((pDat = (UBP)AJCMEM(len)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - 送信用データブロックを確保できません。",
												 "%s - Sending block allocation failure."), pCall->pFunName);
				break;
			}
			//	ＳＣＰ生成済チェック
			for (i = 1, ix = 0; i < pCall->nArg; i++, ix++) {
				if (!(GetSIntByNode(pW, ppAgv[i], (SLLP)&dat, pCall))) goto cfcsb_exit;
				pDat[ix] = (UB)dat;
			}
			//	ＣＯＭポートチェック
			if (port < MIN_PORT || port > MAX_PORT || pW->ExeScp[port].hScp == NULL || !AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)がオープンされていません。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	バイトデータブロック送信
			AjcScpSendBinData(pW->ExeScp[port].hScp, pDat, (UI)len);
			//	戻り値=正常
			rc = TRUE;
		} while(0);
cfcsb_exit:;
		//	データブロック解放
		if (pDat != NULL) free(pDat);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭパケット送信	_ComSendPacket(PortNo, MemBlkNo, loc, len)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSendPacket(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port, bno, loc, len;

	if (pCall->nArg == 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&bno , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&loc , pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&len , pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成，オープン済チェック
			if (pW->ExeScp[port].hScp == NULL || !AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)が未初期化／未オープンです。",
												 "%s - Port(#%d) is not initialized or not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	メモリブロック＃チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック割り当て済チェック
			if (pW->ExeMemBlk[bno].pMemAddr == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - メモリブロックは割り当てられていません。",
												 "%s - Not allocated memory block."), pCall->pFunName);
				break;
			}
			//	メモリブロック超過チェック
			if ((loc + len) > pW->ExeMemBlk[bno].MemLen) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定データはメモリブロック範囲外です。",
												 "%s - Over the memry block."), pCall->pFunName);
				break;
			}
			//	バイナリ送信
			AjcScpSendPacket(pW->ExeScp[port].hScp, pW->ExeMemBlk[bno].pMemAddr + loc, (UI)len);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートの設定値（転送速度[bps]）取得	_ComGetRate(PortNo)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComGetRate(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	DCB				dcb;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	転送レート値を返す
			if (pCall->rchVmg != NULL) {
				AjcScpGetParam(pW->ExeScp[port].hScp, &dcb, NULL);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, dcb.BaudRate)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートの設定値（データビット数）取得	_ComGetDataBits(PortNo)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComGetDataBits(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	DCB				dcb;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	データビット数を返す
			if (pCall->rchVmg != NULL) {
				AjcScpGetParam(pW->ExeScp[port].hScp, &dcb, NULL);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, dcb.ByteSize)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートの設定値（パリティビット）取得	_ComGetParity(PortNo)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComGetParity(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	DCB				dcb;
	UI				pari = 0;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	パリティビットを返す
			if (pCall->rchVmg != NULL) {
				AjcScpGetParam(pW->ExeScp[port].hScp, &dcb, NULL);
				if (dcb.fParity) pari = dcb.Parity;
				else			 pari = 0;
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pari)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートの設定値（ストップビット数）取得	_ComGetStopBits(PortNo)										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComGetStopBits(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	DCB				dcb;
	UI				stpbit = 0;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ストップビット数を返す
			if (pCall->rchVmg != NULL) {
				AjcScpGetParam(pW->ExeScp[port].hScp, &dcb, NULL);
				switch (dcb.StopBits) {
					case 0:	stpbit = 1;	break;	//	1	bit
					case 1:	stpbit = 0;	break;	//	1.5 bit
					case 2:	stpbit = 2;	break;	//	2	bit
				}
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, stpbit)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートの設定値を文字列で取得	$_ComGetParam(PortNo)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComGetParam(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	DCB				dcb;
	BCP				pPari	= "";
	BCP				pStpBit = "";
	BC				str[512];

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	設定値（文字列）を返す
			if (pCall->rchVmg != NULL) {
				if (port >= MIN_COMPORT && port <= MAX_COMPORT) {
					AjcScpGetParam(pW->ExeScp[port].hScp, &dcb, NULL);
					if (dcb.fParity) pPari = "No";
					else {
						switch(dcb.Parity) {
							case 0:	pPari = "No";		break;
							case 1:	pPari = "Odd";		break;
							case 2:	pPari = "Even";		break;
							case 3:	pPari = "Mark";		break;
							case 4:	pPari = "Space";	break;
						}
					}
					switch (dcb.StopBits) {
						case 0:	pStpBit = "1";		break;	//	1	bit
						case 1:	pStpBit = "1.5";	break;	//	1.5 bit
						case 2:	pStpBit = "2";		break;	//	2	bit
					}
					AjcSnPrintFA(str, sizeof str, "COM%d, %d, %d, %s, %s", (UI)port, dcb.BaudRate, dcb.ByteSize, pPari, pStpBit);
				}
				else {
					AjcSnPrintFA(str, sizeof str, "%s", AjcScpGetPortPathName  (pW->ExeScp[port].hScp));
				}
				if (!CipVmgSetString(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, str)) {
					break;
				}
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートのＤＴＲ信号設定	$_ComSetDTR(PortNo, fDTR)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSetDTR(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port, dtr;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&dtr , pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ＤＴＲ設定
			AjcScpSetDTR(pW->ExeScp[port].hScp, (BOOL)(dtr != 0));
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートのＲＴＳ信号設定	$_ComSetRTS(PortNo, fRTS)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSetRTS(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port, rts;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&rts , pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ＤＴＲ設定
			AjcScpSetRTS(pW->ExeScp[port].hScp, (BOOL)(rts != 0));
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭポートの信号状態取得	$_ComGetSignal(PortNo)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComGetSignal(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			//	ポート番号チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ＳＣＰ生成済チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	信号状態を返す
			if (pCall->rchVmg != NULL) {
				UI	sig = AjcScpGetSigState(pW->ExeScp[port].hScp);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, sig)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＣＯＭポートイベント登録																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ＣＯＭテキスト受信イベント登録	_ComSetOnRxText(PortNo, $func)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSetOnRxText(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	C_BCP			pFuncName;
	PAJCCIPFUNC		pFuncInfo;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(pFuncName = GetStrByNode(pW, ppAgv[1], pCall))) break;
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	func引数チェック
			if ((pFuncInfo = (PAJCCIPFUNC)AjcAvlGetNodePtr(pW->hAvlFun, (UX)pFuncName, NULL)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 関数(%s)は定義されていません。",
												 "%s - Not defined function '%s'."), pCall->pFunName, pFuncName);
				break;
			}
			//	イベント関数，マスク設定
			pW->ExeScp[port].pOnRecvText = pFuncName;
			pW->ExeScp[port].EvtMask |= AJCSCP_EV_RXTEXT;
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭ制御コード受信イベント登録	_ComSetOnRxCtrl(PortNo, $func)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSetOnRxCtrl(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	C_BCP			pFuncName;
	PAJCCIPFUNC		pFuncInfo;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(pFuncName = GetStrByNode(pW, ppAgv[1], pCall))) break;
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	func引数チェック
			if ((pFuncInfo = (PAJCCIPFUNC)AjcAvlGetNodePtr(pW->hAvlFun, (UX)pFuncName, NULL)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 関数(%s)は定義されていません。",
												 "%s - Not defined function '%s'."), pCall->pFunName, pFuncName);
				break;
			}
			//	イベント関数，マスク設定
			pW->ExeScp[port].pOnRecvCtrl = pFuncName;
			pW->ExeScp[port].EvtMask |= AJCSCP_EV_RXCTRL;
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭ　ＥＳＣ受信イベント登録	_ComSetOnRxEsc(PortNo, $func)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSetOnRxEsc(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port;
	C_BCP			pFuncName;
	PAJCCIPFUNC		pFuncInfo;
	UI				evt;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(pFuncName = GetStrByNode(pW, ppAgv[1], pCall))) break;
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	func引数チェック
			if ((pFuncInfo = (PAJCCIPFUNC)AjcAvlGetNodePtr(pW->hAvlFun, (UX)pFuncName, NULL)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 関数(%s)は定義されていません。",
												 "%s - Not defined function '%s'."), pCall->pFunName, pFuncName);
				break;
			}
			//	イベント関数，マスク設定
			pW->ExeScp[port].pOnRecvEsc = pFuncName;
			pW->ExeScp[port].EvtMask |= AJCSCP_EV_RXESC;
			//	ＥＳＣ受信イベント許可
			evt = AjcScpGetEvtMask(pW->ExeScp[port].hScp);
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, evt | AJCSCP_EV_RXESC);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭ　パケット受信イベント登録	_ComSetOnRxPacket(PortNo, $func, MemBlkNo)								//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunComSetOnRxPacket(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	ULL				port, bno;
	C_BCP			pFuncName;
	PAJCCIPFUNC		pFuncInfo;
	UI				evt;

	if (pCall->nArg == 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall))) break;
			if (!(pFuncName = GetStrByNode(pW, ppAgv[1], pCall))) break;
			if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&bno , pCall))) break;
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	func引数チェック
			if ((pFuncInfo = (PAJCCIPFUNC)AjcAvlGetNodePtr(pW->hAvlFun, (UX)pFuncName, NULL)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 関数(%s)は定義されていません。",
												 "%s - Not defined function '%s'."), pCall->pFunName, pFuncName);
				break;
			}
			//	MemBlkNo引数チェック
			if (!(bno >= 1 && bno < AJCCIPMAX_MEMBLK)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 不正なメモリブロック番号(%d)です。",
												 "%s - Illegal memory block number(%d)."), pCall->pFunName, (UI)bno);
				break;
			}
			//	メモリブロック番号設定
			pW->ExeScp[port].MemBlkNo = (UI)bno;
			//	イベント関数，マスク設定
			pW->ExeScp[port].pOnRecvPacket = pFuncName;
			pW->ExeScp[port].EvtMask |= AJCSCP_EV_RXPKT;
			//	パケット受信イベント許可
			evt = AjcScpGetEvtMask(pW->ExeScp[port].hScp);
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, evt | AJCSCP_EV_RXPKT);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＸＭＯＤＥＭ／ＹＭＯＤＥＭ																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ＣＯＭ XMODEM送信	_ComSendXModemSum(PortNo, $FilePath)													//
//						_ComSendXModemCrc(PortNo, $FilePath)													//
//						_ComSendXModem1K (PortNo, $FilePath)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- コールバックパラメタ -----------------------------------------------------------------------------------//
typedef struct {
	UI		port;				//	ポート番号
	HAJCCIP	hCip;				//	ＣＩＰインスタンスハンドル
} CBPXMSEND, *PCBPXMSEND;
//----- ファイル情報取得　コールバック関数 ---------------------------------------------------------------------//
static VO CALLBACK cbXModemTxGetFile(PAJCXYMFILEINFOA pBuf, UX cbp)
{
	PCBPXMSEND		pCbp = (PCBPXMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;
	SYSTEMTIME		st;
	LARGE_INTEGER	TxFileSize;

	GetSystemTime(&st);
	GetFileSizeEx(pXyW->XYm_hFile, &TxFileSize);
	pBuf->pFName = "NONAME";
	pBuf->size	 = TxFileSize.QuadPart;
	pBuf->time	 = AjcSysTimeToTime1970(&st);
}
//----- ファイルデータ取得　コールバック関数 -------------------------------------------------------------------//
static VO CALLBACK cbXModemTxGetData(VOP pBuf, UI len, UIP pBytes, UX cbp)
{
	PCBPXMSEND		pCbp = (PCBPXMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	ReadFile(pXyW->XYm_hFile, pBuf, len, (LPDWORD)pBytes, NULL);
}
//----- イベント通知　コールバック関数 -------------------------------------------------------------------------//
static VO CALLBACK cbXModemTxNotice(UI knd, UX Param, UX cbp)
{
	PCBPXMSEND		pCbp = (PCBPXMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	//	イベントコード設定
	pXyW->XYm_evt = knd;

	//	イベント表示
	switch (knd) {
		case AJCXYN_TXREC: 		if (Param == 128) AjcCipPrintF(pW->hWndBack, ".");				//	●１レコード送信完了
								else			  AjcCipPrintF(pW->hWndBack, ":");
								break;

		case AJCXYN_RETRY:		AjcCipPrintF(pW->hWndBack, "R");					break;		//	●再送発生
		case AJCXYN_EOF:		AjcCipPrintF(pW->hWndBack, "E\n");					break;		//	●ファイル終端（ＥＯＦ）

		case AJCXYN_PROTOCOL:	AjcCipPrintF(pW->hWndBack, "C");								//	●プロトコル変更
								switch (Param) {
									case 0:	AjcCipPrintF(pW->hWndBack, "[SUM]");	break;
									case 1:	AjcCipPrintF(pW->hWndBack, "[CRC]");	break;
									case 2:	AjcCipPrintF(pW->hWndBack, "[1K]");		break;
								}
								break;

		case AJCXYN_COMPLETE:	AjcCipPrintF(pW->hWndBack, "\nComplete.\n");			break;	//	●送信正常終了
		case AJCXYN_RX_CAN:		AjcCipPrintF(pW->hWndBack, "\nStop by Received CAN\n");	break;	//	●送信中止（ＣＡＮ受信）
		case AJCXYN_USERSTOP:	AjcCipPrintF(pW->hWndBack, "\nStop by user\n");			break;	//	●送信中止（ユーザ停止）
		case AJCXYN_TIMEOUT:	AjcCipPrintF(pW->hWndBack, "\nStop by Timeout\n");		break;	//	●送信中止（タイムアウト）
		case AJCXYN_ABORT: 		AjcCipPrintF(pW->hWndBack, "\nStop by abort\n");		break;	//	●送信中止（その他）
	}
}
//----- データ送出　コールバック関数 ---------------------------------------------------------------------------//
static VO CALLBACK cbXModemTxSend(C_VOP pTxD, UI len, UX cbp)
{
	PCBPXMSEND		pCbp = (PCBPXMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	AjcScpSendBinData(pInf->hScp, pTxD, len);
}
//----- ＸＭＯＤＥＭ処理本体 -----------------------------------------------------------------------------------//
BOOL	SubComSendXModem(HAJCCIP pW, PCAJCCIPCALL pCall, AJCXYMPROTOCOL protocol)
{
	BOOL			rc		= FALSE;
	PAJCCIPAGV		*ppAgv	= NULL;
	ULL				port	= 0;
	C_BCP			pPath	= NULL;
	CBPXMSEND		cbp;
	PXYMWORK		pXyW	= NULL;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall)))	break;
			if (!(pPath = GetStrByNode(pW, ppAgv[1], pCall)))		break;
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ポートオープンチェック
			if (!AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)はオープンされていません。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	ＸＭＯＤＥＭ制御ワーク割り当て
			pXyW = pW->ExeScp[port].pXyW = (PXYMWORK)AJCMEM(sizeof(XYMWORK));
			if (pXyW == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - ＸＭＯＤＥＭ用作業領域の割り当てを失敗しました。",
												 "%s - Work of XMODEM allocation failure."), pCall->pFunName);
				break;
			}
			memset(pXyW, 0, sizeof(XYMWORK));
			//	チャンク受信イベント有効化
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) |  AJCSCP_EV_RXCHUNK);
			//	送信ファイルオープン
			if ((pXyW->XYm_hFile = CreateFileA(pPath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL)) == INVALID_HANDLE_VALUE) {
				pXyW->XYm_hFile = NULL;
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイル(%s)のオープンを失敗しました。",
												 "%s - File(%s) open failure."), pCall->pFunName, pPath);
				break;
			}
			//	XMODEMインスタンス生成
			cbp.port = (UI)port;
			cbp.hCip = pW;
			if ((pW->ExeScp[port].hXyModem = AjcXymCreateA((UX)&cbp, cbXModemTxNotice, cbXModemTxGetFile, cbXModemTxGetData, cbXModemTxSend)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - ＸＭＯＤＥＭ送信準備を失敗しました。",
													 "%s - XMODEM instance creation failure."), pCall->pFunName);
				break;
			}
			//	XMODEM送信
			if (AjcXymTxStart(pW->ExeScp[port].hXyModem, protocol)) {
				AjcCipPrintF(pW->hWndBack, "XMODEM Sending Start, Port(#%d) <- %s\n", (UI)port, pPath);
				while (!(pXyW->XYm_evt & AJCXYN_END)) {
					if (pW->fRunStop) {
						AjcXymStop(pW->ExeScp[port].hXyModem);
						break;
					}
					CipGsrDoEvent(pW);
				}
				AjcCipPrintF(pW->hWndBack, "XMODEM Sending End\n");
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ＸＭＯＤＥＭ送信を開始できません。",
												 "%s - XMODEM starting failure."), pCall->pFunName);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	リソース解放
		if (port != 0) {
			//	送信ファイルクローズ
			if (pXyW->XYm_hFile != NULL) {
				CloseHandle(pXyW->XYm_hFile);
				pXyW->XYm_hFile = NULL;
			}
			//	SCP後処理
			if (pW->ExeScp[port].hScp != NULL) {
				//	チャンク受信イベント無効化
				AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) & ~AJCSCP_EV_RXCHUNK);
			}
			//	ＸＭＯＤＥＭ制御ワーク解放
			if (pXyW != NULL) {
				free(pXyW);
				pXyW = pW->ExeScp[port].pXyW = NULL;
			}
			//	ＸＭＯＤＥＭインスタンス消去
			if (pW->ExeScp[port].hXyModem != NULL) {
				AjcXymDelete(pW->ExeScp[port].hXyModem);
				pW->ExeScp[port].hXyModem = NULL;
			}
		}
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//----- ＸＭＯＤＥＭ送信(SUM) ----------------------------------------------------------------------------------//
BOOL	CipFunComSendXModemSum(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	return SubComSendXModem(pW, pCall, AJCXYP_XMODEM_SUM);
}
//----- ＸＭＯＤＥＭ送信(CRC) ----------------------------------------------------------------------------------//
BOOL	CipFunComSendXModemCrc(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	return SubComSendXModem(pW, pCall, AJCXYP_XMODEM_CRC);
}
//----- ＸＭＯＤＥＭ送信(1K ) ----------------------------------------------------------------------------------//
BOOL	CipFunComSendXModem1K (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	return SubComSendXModem(pW, pCall, AJCXYP_XMODEM_1K);
}
//==============================================================================================================//
//	ＣＯＭ XMODEM受信	_ComRecvXModemSum(PortNo, $FilePath)													//
//						_ComRecvXModemCrc(PortNo, $FilePath)													//
//						_ComRecvXModem1K (PortNo, $FilePath)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- コールバックパラメタ -----------------------------------------------------------------------------------//
typedef struct {
	UI		port;				//	ポート番号
	HAJCCIP	hCip;				//	ＣＩＰインスタンスハンドル
} CBPXMRECV, *PCBPXMRECV;
//----- イベント通知　コールバック関数 -------------------------------------------------------------------------//
static VO CALLBACK cbModemRxNotice(UI knd, UX Param, UX cbp)
{
	PCBPXMRECV		pCbp = (PCBPXMRECV)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;
	DWORD			bytes;

	//	イベントコード設定
	pXyW->XYm_evt = knd;

	//	イベント表示，受信データ書き込み
	switch (knd) {
		case AJCXYN_RXREC_128:	AjcCipPrintF(pW->hWndBack, ".");								//	●１レコード受信( 128 bytes)
								WriteFile(pXyW->XYm_hFile, (VOP)Param,	128, &bytes, NULL);
								break;

		case AJCXYN_RXREC_1K:	AjcCipPrintF(pW->hWndBack, ":");								//	●１レコード受信(1024 bytes)
								WriteFile(pXyW->XYm_hFile, (VOP)Param, 1024, &bytes, NULL);
								break;

		case AJCXYN_RETRY:		AjcCipPrintF(pW->hWndBack, "R");					break;		//	●再送発生
		case AJCXYN_EOF:		AjcCipPrintF(pW->hWndBack, "E\n");					break;		//	●ファイル終端（ＥＯＦ）

		case AJCXYN_PROTOCOL:	AjcCipPrintF(pW->hWndBack, "C");								//	●プロトコル変更
								switch (Param) {
									case 0:	AjcCipPrintF(pW->hWndBack, "[SUM]");	break;
									case 1:	AjcCipPrintF(pW->hWndBack, "[CRC]");	break;
									case 2:	AjcCipPrintF(pW->hWndBack, "[1K]");		break;
								}
								break;

		case AJCXYN_COMPLETE:	AjcCipPrintF(pW->hWndBack, "\nComplete.\n");			break;	//	●受信正常終了
		case AJCXYN_RX_CAN:		AjcCipPrintF(pW->hWndBack, "\nStop by Received CAN\n");	break;	//	●受信中止（ＣＡＮ受信）
		case AJCXYN_USERSTOP:	AjcCipPrintF(pW->hWndBack, "\nStop by user\n");			break;	//	●受信中止（ユーザ停止）
		case AJCXYN_TIMEOUT:	AjcCipPrintF(pW->hWndBack, "\nStop by Timeout\n");		break;	//	●受信中止（タイムアウト）
		case AJCXYN_ABORT: 		AjcCipPrintF(pW->hWndBack, "\nStop by abort\n");		break;	//	●受信中止（その他）
	}
}
//----- データ送出　コールバック関数 ---------------------------------------------------------------------------//
static VO CALLBACK cbXModemRxSend(C_VOP pTxD, UI len, UX cbp)
{
	PCBPXMRECV		pCbp = (PCBPXMRECV)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	AjcScpSendBinData(pInf->hScp, pTxD, len);
}
//----- ＸＭＯＤＥＭ処理本体 -----------------------------------------------------------------------------------//
BOOL	SubComRecvXModem(HAJCCIP pW, PCAJCCIPCALL pCall, AJCXYMPROTOCOL protocol)
{
	BOOL			rc		= FALSE;
	PAJCCIPAGV		*ppAgv	= NULL;
	ULL				port	= 0;
	C_BCP			pPath	= NULL;
	CBPXMRECV		cbp;
	PXYMWORK		pXyW = NULL;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall)))	break;
			if (!(pPath = GetStrByNode(pW, ppAgv[1], pCall)))		break;
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ポートオープンチェック
			if (!AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)はオープンされていません。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	ＸＭＯＤＥＭ制御ワーク割り当て
			pXyW = pW->ExeScp[port].pXyW = (PXYMWORK)AJCMEM(sizeof(XYMWORK));
			if (pXyW == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - ＸＭＯＤＥＭ用作業領域の割り当てを失敗しました。",
												 "%s - Work of XMODEM allocation failure."), pCall->pFunName);
				break;
			}
			memset(pXyW, 0, sizeof(XYMWORK));
			//	チャンク受信イベント有効化
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) |  AJCSCP_EV_RXCHUNK);
			//	受信ファイルオープン
			if ((pXyW->XYm_hFile = CreateFileA(pPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
				pXyW->XYm_hFile = NULL;
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ファイル(%s)の作成を失敗しました。",
												 "%s - File(%s) creation failure."), pCall->pFunName, pPath);
				break;
			}
			//	XMODEMインスタンス生成
			cbp.port = (UI)port;
			cbp.hCip = pW;
			if ((pW->ExeScp[port].hXyModem = AjcXymCreate((UX)&cbp, cbModemRxNotice, NULL, NULL, cbXModemRxSend)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - ＸＭＯＤＥＭ受信準備を失敗しました。",
												 "%s - XMODEM instance creation failure."), pCall->pFunName);
				break;
			}
			//	XMODEM受信
			if (AjcXymRxStart(pW->ExeScp[port].hXyModem, protocol)) {
				AjcCipPrintF(pW->hWndBack, "XMODEM Receiving Start, Port(#%d) -> %s\n", (UI)port, pPath);
				while (!(pXyW->XYm_evt & AJCXYN_END)) {
					if (pW->fRunStop) {
						AjcXymStop(pW->ExeScp[port].hXyModem);
						break;
					}
					CipGsrDoEvent(pW);
				}
				AjcCipPrintF(pW->hWndBack, "XMODEM Receiving End\n", port, pPath);
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ＸＭＯＤＥＭ受信を開始できません。",
												 "%s - XMODEM starting failure."), pCall->pFunName);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	リソース解放
		if (port != 0) {
			//	受信ファイルクローズ
			if (pXyW->XYm_hFile != NULL) {
				CloseHandle(pXyW->XYm_hFile);
				pXyW->XYm_hFile = NULL;
			}
			//	SCP後処理
			if (pW->ExeScp[port].hScp != NULL) {
				//	チャンク受信イベント無効化
				AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) & ~AJCSCP_EV_RXCHUNK);
			}
			//	ＸＭＯＤＥＭ制御ワーク解放
			if (pXyW != NULL) {
				free(pXyW);
				pXyW = pW->ExeScp[port].pXyW = NULL;
			}
			//	ＸＭＯＤＥＭインスタンス消去
			if (pW->ExeScp[port].hXyModem != NULL) {
				AjcXymDelete(pW->ExeScp[port].hXyModem);
				pW->ExeScp[port].hXyModem = NULL;
			}
		}
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//----- ＸＭＯＤＥＭ受信(SUM) ----------------------------------------------------------------------------------//
BOOL	CipFunComRecvXModemSum(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	return SubComRecvXModem(pW, pCall, AJCXYP_XMODEM_SUM);
}
//----- ＸＭＯＤＥＭ受信(CRC) ----------------------------------------------------------------------------------//
BOOL	CipFunComRecvXModemCrc(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	return SubComRecvXModem(pW, pCall, AJCXYP_XMODEM_CRC);
}
//----- ＸＭＯＤＥＭ受信(1K ) ----------------------------------------------------------------------------------//
BOOL	CipFunComRecvXModem1K (HAJCCIP pW, PCAJCCIPCALL pCall)
{
	return SubComRecvXModem(pW, pCall, AJCXYP_XMODEM_1K);
}
//==============================================================================================================//
//	ＣＯＭ YMODEM送信	_ComSendYModem(PortNo, $Wild, fSubDir, fFolder)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- コールバックパラメタ -----------------------------------------------------------------------------------//
typedef struct {
	UI		port;				//	ポート番号
	HAJCCIP	hCip;				//	ＣＩＰインスタンスハンドル
	BOOL	fSubDir;			//	サブディレクトリ検索フラグ
	BOOL	fFolder;			//	ファイル名にフォルダを付加するフラグ
} CBPYMSEND, *PCBPYMSEND;
//----- ファイル情報取得　コールバック関数 ---------------------------------------------------------------------//
static VO CALLBACK cbYModemTxGetFile(PAJCXYMFILEINFOA pBuf, UX cbp)
{
	PCBPYMSEND		pCbp	= (PCBPYMSEND)cbp;
	HAJCCIP			pW		= pCbp->hCip;
	PAJCCIPSCPINF	pInf	= &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW	= pInf->pXyW;
	BOOL			fSubDir = pCbp->fSubDir;
	BOOL			fFolder = pCbp->fFolder;

	BOOL			fFindFile	= FALSE;
	BOOL			fEndOfFind	= FALSE;
	BOOL			fFileOpened	= FALSE;
	int				ix;
	struct	_finddata_t fd;

	while (!fEndOfFind	&&	!fFileOpened) {
		//----- ファイル検索 ------------------------------------------------------------//
		ix = pXyW->XYm_ixFind;
		do {
			//	ファイル検索
			if (pXyW->XYm_fFindFirst) {																//	初回検索？
				if ((pXyW->XYm_hFind[ix] = _findfirst(pXyW->XYm_AnyPath, &fd)) != -1) {				//		最初のファイル検索，見つかった？
					if (fSubDir) {																	//			サブフォルダ検索(*.*で検索)
						fFindFile = PathMatchSpecA(fd.name, pXyW->XYm_WildName);					//				ワイルドカードと一致すれば「見つかった」
					}
					else {																			//			サブフォルダは検索しない？
						fFindFile = TRUE;															//				「見つかった」
					}
				}
				else {																				//		最初のファイル検索，見つからない？
					fEndOfFind = TRUE;																//			「検索終了」
				}
				pXyW->XYm_fFindFirst = FALSE;														//		初回フラグ解除
			}
			else {																					//	初回以外？
				if (_findnext(pXyW->XYm_hFind[ix], &fd) != -1) {									//		2回目以降検索，見つかった？
					if (fSubDir) {																	//			サブフォルダ検索(*.*で検索)
						fFindFile = PathMatchSpecA(fd.name, pXyW->XYm_WildName);					//				ワイルドカードと一致すれば「見つかった」
					}
					else {																			//			サブフォルダは検索しない？
						fFindFile = TRUE;															//				「見つかった」
					}
				}
				else {																				//		2回目以降検索，見つからない？
					_findclose(pXyW->XYm_hFind[ix]);												//			検索ハンドル・クローズ
					ix--;																			//			ネスト減算
					if (ix >= 0) {																	//			先頭ネスト以上？
						BCP	pFileName;																//				
						AjcPathCatA(pXyW->XYm_SrhDir, "..\\", MAX_PATH);							//				1つ上のフォルダパス設定
						GetFullPathNameA(pXyW->XYm_SrhDir, MAX_PATH, pXyW->XYm_SrhDir, &pFileName);	//				・
					}
					else {																			//			ネスト・アンダフロー？
						fEndOfFind = TRUE;															//				「検索終了」
					}
				}
			}
			//	ディレクトリならば、ネストして検索
			if (fSubDir														&&	//	サブディレクトリも検索				＆
				!fEndOfFind 												&&	//	検索未終了							＆
				(fd.attrib & _A_SUBDIR)										&&	//	サブディレクトリ					＆
				!(fd.attrib & (_A_HIDDEN | _A_SYSTEM))						&&	//	隠しファイル，システムファイル以外	＆
				mbscmp(fd.name, ".") != 0 && mbscmp(fd.name, "..") != 0) {		//	"." , ".." 以外
				if (ix < MAX_FIND_FILE - 1) {
					BCP	pFileName;
					BC	WildPath[MAX_PATH];
					AjcPathCatA(pXyW->XYm_SrhDir, fd.name		   , MAX_PATH);
					AjcSnPrintFA(WildPath, sizeof WildPath, "%s", pXyW->XYm_SrhDir);
					AjcPathCatA(WildPath, "*.*", MAX_PATH);
					ix++;
					if ((pXyW->XYm_hFind[ix] = _findfirst(WildPath, &fd)) == -1) {
						AjcPathCatA(pXyW->XYm_SrhDir, "..\\", MAX_PATH);
						GetFullPathNameA(pXyW->XYm_SrhDir, MAX_PATH, pXyW->XYm_SrhDir, &pFileName);
						ix--;
					}
				}
			}
		} while (!fEndOfFind && !fFindFile);
		pXyW->XYm_ixFind = ix;
		//----- ファイル情報設定 --------------------------------------------------------//
		if (!fEndOfFind) {
			BC	SendFile[MAX_PATH];
			//	送信ファイル名作成
			strcpy(SendFile, pXyW->XYm_SrhDir);
			AjcPathCatA(SendFile, fd.name, MAX_PATH);
			//	前ファイルをクローズ
			if (pXyW->XYm_hFile != NULL) {
				CloseHandle(pXyW->XYm_hFile);
				pXyW->XYm_hFile = NULL;
			}
			//	送信ファイルオープン
			pXyW->XYm_hFile = CreateFileA(SendFile, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			//	オープン成功・・・
			if (pXyW->XYm_hFile != INVALID_HANDLE_VALUE) {
				pXyW->XYm_FTime	 = (UL)(fd.time_write);		//	ファイル時刻（ＵＴＣ）
				AjcCipPrintF(pW->hWndBack, "File transfer <%s>\n", SendFile);
				//	ＹＭＯＤＥＭ情報へ送信ファイル名／パス名設定
				if (fFolder) {
					PathRelativePathToA(pXyW->XYm_SndName, pXyW->XYm_TopDir, FILE_ATTRIBUTE_NORMAL, SendFile, FILE_ATTRIBUTE_NORMAL);
				}
				else {
					AjcSnPrintFA(pXyW->XYm_SndName, sizeof pXyW->XYm_SndName, "%s", fd.name);
				}
				pBuf->pFName = pXyW->XYm_SndName;
				//	ＹＭＯＤＥＭ情報へサイズ，タイム設定
				pBuf->size	 = fd.size;
				GetFileSizeEx(pXyW->XYm_hFile, (PLARGE_INTEGER)&pBuf->size);
				pBuf->time = (UL)fd.time_write;
				//	オープン成功の旨、フラグ設定
				fFileOpened = TRUE;
			}
		}
		else  pBuf->pFName = NULL;
	}
}
//----- ファイルデータ取得　コールバック関数 -------------------------------------------------------------------//
static VO CALLBACK cbYModemTxGetData(VOP pBuf, UI len, UIP pBytes, UX cbp)
{
	PCBPYMSEND		pCbp = (PCBPYMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	ReadFile(pXyW->XYm_hFile, pBuf, len, (LPDWORD)pBytes, NULL);
}
//----- イベント通知　コールバック関数 -------------------------------------------------------------------------//
static VO CALLBACK cbYModemTxNotice(UI knd, UX Param, UX cbp)
{
	PCBPYMSEND		pCbp = (PCBPYMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	//	イベントコード設定
	pXyW->XYm_evt = knd;

	//	イベント表示
	switch (knd) {
		case AJCXYN_TXREC: 		if (Param == 128) AjcCipPrintF(pW->hWndBack, ".");				//	●１レコード送信完了
								else			  AjcCipPrintF(pW->hWndBack, ":");
								break;

		case AJCXYN_RETRY:		AjcCipPrintF(pW->hWndBack, "R");					break;		//	●再送発生
		case AJCXYN_EOF:		AjcCipPrintF(pW->hWndBack, "E\n");					break;		//	●ファイル終端（ＥＯＦ）
		case AJCXYN_PROTOCOL:	AjcCipPrintF(pW->hWndBack, "C");					break;		//	●プロトコル変更

		case AJCXYN_COMPLETE:	AjcCipPrintF(pW->hWndBack, "\nComplete.\n");			break;	//	●送信正常終了
		case AJCXYN_RX_CAN:		AjcCipPrintF(pW->hWndBack, "\nStop by Received CAN\n");	break;	//	●送信中止（ＣＡＮ受信）
		case AJCXYN_USERSTOP:	AjcCipPrintF(pW->hWndBack, "\nStop by user\n");			break;	//	●送信中止（ユーザ停止）
		case AJCXYN_TIMEOUT:	AjcCipPrintF(pW->hWndBack, "\nStop by Timeout\n");		break;	//	●送信中止（タイムアウト）
		case AJCXYN_ABORT: 		AjcCipPrintF(pW->hWndBack, "\nStop by abort\n");		break;	//	●送信中止（その他）
	}
}
//----- データ送出　コールバック関数 ---------------------------------------------------------------------------//
static VO CALLBACK cbYModemTxSend(C_VOP pTxD, UI len, UX cbp)
{
	PCBPYMSEND		pCbp = (PCBPYMSEND)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	AjcScpSendBinData(pInf->hScp, pTxD, len);
}
//----- ＹＭＯＤＥＭ処理本体 -----------------------------------------------------------------------------------//
BOOL	CipFunComSendYModem(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc		= FALSE;
	PAJCCIPAGV		*ppAgv	= NULL;
	SLL				port	= 0;
	C_BCP			pPath;
	SLL				fSubDir = FALSE;
	SLL				fFolder = FALSE;
	CBPYMSEND		cbp;
	PXYMWORK		pXyW	= NULL;
	BC				drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], fext[_MAX_EXT];;

	if (pCall->nArg >= 2 && pCall->nArg <= 4) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定

								   if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port  , pCall)))	break;
								   if (!(pPath = GetStrByNode(pW, ppAgv[1], pCall)))			break;
			if (pCall->nArg >= 3) {if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&fSubDir, pCall)))	break;}
			if (pCall->nArg >= 4) {if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&fFolder, pCall)))	break;}
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ポートオープンチェック
			if (!AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)はオープンされていません。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	ＹＭＯＤＥＭ制御ワーク割り当て
			pXyW = pW->ExeScp[port].pXyW = (PXYMWORK)AJCMEM(sizeof(XYMWORK));
			if (pXyW == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - ＹＭＯＤＥＭ用作業領域の割り当てを失敗しました。",
												 "%s - Work of YMODEM allocation failure."), pCall->pFunName);
				break;
			}
			memset(pXyW, 0, sizeof(XYMWORK));
			//	チャンク受信イベント有効化
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) |  AJCSCP_EV_RXCHUNK);
			//	送信ファイルパス／ワイルドパス設定
			AjcSnPrintFA(pXyW->XYm_AnyPath, sizeof pXyW->XYm_AnyPath, "%s", pPath);
			if (AjcPathIsDirectoryA(pPath)) {										//	ディレクトリ名を指定？
				AjcPathCatA(pXyW->XYm_AnyPath, "", MAX_PATH);						//		フォルダ末尾に'\'追加
				strcpy	   (pXyW->XYm_SrhDir, pXyW->XYm_AnyPath);					//		検索ディレクトリ設定
				strcpy	   (pXyW->XYm_TopDir, pXyW->XYm_SrhDir);					//		トップフォルダ
				strcpy	   (pXyW->XYm_WildName, "*.*");								//		ワイルドカード
				AjcPathCatA(pXyW->XYm_AnyPath, "*.*", MAX_PATH);					//		ワイルドパス
			}
			else {																	//	ファイルパス／ワイルドパス指定
				_splitpath(pPath		   , drv, dir, fname, fext);				//		トップフォルダ
				_makepath (pXyW->XYm_TopDir, drv, dir, NULL , NULL);				//		・
				strcpy(pXyW->XYm_SrhDir, pXyW->XYm_TopDir);							//		最初の検索フォルダ
				if (fSubDir) {														//		サブフォルダ検索？
					_makepath(pXyW->XYm_WildName, NULL, NULL, fname, fext);			//			ワイルドカード＝指定値
					strcpy(pXyW->XYm_AnyPath, pXyW->XYm_SrhDir);					//			検索パス＝「・・・\*.*」に変更
					AjcPathCatA(pXyW->XYm_AnyPath, "*.*", MAX_PATH);				//			・
				}
				else {																//		サブフォルダ検索無し？
					_makepath (pXyW->XYm_WildName, NULL, NULL, fname, fext);		//			ワイルドカード＝指定値
				}
			}
			//	YMODEMインスタンス生成
			cbp.port	= (UI)port;
			cbp.hCip	= pW;
			cbp.fSubDir = (BOOL)fSubDir;
			cbp.fFolder = (BOOL)fFolder;
			if ((pW->ExeScp[port].hXyModem = AjcXymCreateA((UX)&cbp, cbYModemTxNotice, cbYModemTxGetFile, cbYModemTxGetData, cbYModemTxSend)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - ＹＭＯＤＥＭ送信準備を失敗しました。",
													 "%s - YMODEM instance creation failure."), pCall->pFunName);
				break;
			}
			//	その他のＹＭＯＤＥＭ送信情報初期化
			pXyW->XYm_fFindFirst	= TRUE;
			pXyW->XYm_hFile 	 	= NULL;
			pXyW->XYm_ixFind		= 0;
			pXyW->XYm_hFind[0]	 	= -1;
			//	YMODEM送信
			if (AjcXymTxStart(pW->ExeScp[port].hXyModem, AJCXYP_YMODEM_STD)) {
				AjcCipPrintF(pW->hWndBack, "YMODEM Sending Start, Port(#%d) <- %s\n", (UI)port, pXyW->XYm_AnyPath);
				while (!(pXyW->XYm_evt & AJCXYN_END)) {
					if (pW->fRunStop) {
						AjcXymStop(pW->ExeScp[port].hXyModem);
						break;
					}
					CipGsrDoEvent(pW);
				}
				AjcCipPrintF(pW->hWndBack, "YMODEM Sending End\n");
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ＹＭＯＤＥＭ送信を開始できません。",
												 "%s - YMODEM starting failure."), pCall->pFunName);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	リソース解放
		if (port != 0) {
			int ix;
			//	検索ハンドルクローズ
			ix = pXyW->XYm_ixFind;
			while (ix >= 0) {
				if (pXyW->XYm_hFind[ix] != -1) {
					_findclose(pXyW->XYm_hFind[ix]);
					pXyW->XYm_hFind[ix] = -1;
				}
				ix--;
			}
			pXyW->XYm_ixFind = 0;
			//	送信ファイルクローズ
			if (pXyW->XYm_hFile != NULL) {
				CloseHandle(pXyW->XYm_hFile);
				pXyW->XYm_hFile = NULL;
			}
			//	SCP後処理
			if (pW->ExeScp[port].hScp != NULL) {
				//	チャンク受信イベント無効化
				AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) & ~AJCSCP_EV_RXCHUNK);
			}
			//	ＹＭＯＤＥＭ制御ワーク解放
			if (pXyW != NULL) {
				free(pXyW);
				pXyW = pW->ExeScp[port].pXyW = NULL;
			}
			//	ＹＭＯＤＥＭインスタンス消去
			if (pW->ExeScp[port].hXyModem != NULL) {
				AjcXymDelete(pW->ExeScp[port].hXyModem);
				pW->ExeScp[port].hXyModem = NULL;
			}
		}
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭ YMODEM受信	_ComRecvYModem(PortNo, $FolderPath)														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- ファイル書き込み ---------------------------------------------------------------------------------------//
static	VO	WriteToFile(PXYMWORK pXyW, VOP pDat, UL len)
{
	UL	bytes;
	SLL	rem;

	//	ファイル書き込み
	rem = pXyW->XYm_RxByteSize - pXyW->XYm_RxByteCount;
	if (rem > len) {
		if (pXyW->XYm_hFile != INVALID_HANDLE_VALUE) WriteFile(pXyW->XYm_hFile, pDat, len		, &bytes, NULL);
		pXyW->XYm_RxByteCount += len;
	}
	else if (rem > 0) {
		if (pXyW->XYm_hFile != INVALID_HANDLE_VALUE) WriteFile(pXyW->XYm_hFile, pDat, (DWORD)rem, &bytes, NULL);
		pXyW->XYm_RxByteCount += rem;
	}
}
//----- コールバックパラメタ -----------------------------------------------------------------------------------//
typedef struct {
	UI		port;				//	ポート番号
	HAJCCIP	hCip;				//	ＣＩＰインスタンスハンドル
	BOOL	fSubDir;			//	サブフォルダ作成フラグ
} CBPYMRECV, *PCBPYMRECV;
//----- イベント通知　コールバック関数 -------------------------------------------------------------------------//
static VO CALLBACK cbYModemRxNotice(UI knd, UX Param, UX cbp)
{
	PCBPYMRECV		 pCbp	 = (PCBPYMRECV)cbp;
	HAJCCIP			 pW		 = pCbp->hCip;
	PAJCCIPSCPINF	 pInf	 = &pW->ExeScp[pCbp->port];
	BOOL			 fSubDir = pCbp->fSubDir;
	PXYMWORK		 pXyW	 = pInf->pXyW;
	PAJCXYMFILEINFOA pFileInfo;
	BCP				 pFileName;
	BC				 FilePath[MAX_PATH];
	BC				 DirPath [MAX_PATH];
	BC				 drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], fext[_MAX_EXT];

	//	イベントコード設定
	pXyW->XYm_evt = knd;

	//	イベント表示，受信データ書き込み
	switch (knd) {
		case AJCXYN_RXFILEINFO:	pFileInfo = (PAJCXYMFILEINFOA)Param;									//	●ファイル情報受信
								pXyW->XYm_RxByteSize  = pFileInfo->size;								//		ファイルサイズ設定
								pXyW->XYm_RxByteCount = 0;												//		ファイルバイトカウンタ初期化
								if (fSubDir) {															//		サブフォルダを作成する？
									strcpy	  (FilePath, pXyW->XYm_AnyPath);							//			受信ファイルパス名設定
									AjcPathCatA(FilePath, pFileInfo->pFName, MAX_PATH);					//			・
									GetFullPathNameA(FilePath, MAX_PATH, FilePath, &pFileName);
									_splitpath(FilePath, drv, dir, NULL, NULL);							//			ディレクトリ作成
									_makepath (DirPath , drv, dir, NULL, NULL);							//			（既に作成されている場合も
									if (DirPath[0] != 0) {												//			  ある為、エラーは無視）
										MakeSureDirectoryPathExists(DirPath);							//			・
									}																	//			・
								}
								else {																	//		サブフォルダを作成しない？
									_splitpath(pXyW->XYm_AnyPath, drv , dir , NULL , NULL);				//			フォルダ名とファイル名を合成
									_splitpath(pFileInfo->pFName, NULL, NULL, fname, fext);				//			・
									_makepath (FilePath 		, drv , dir , fname, fext);				//			・
								}
								AjcCipPrintF(pW->hWndBack, "File receive '%s'\n", FilePath);			//		ファイル名ログ表示
								AjcCipPrintF(pW->hWndBack, "     size = %lld[bytes]\n",					//		ファイルサイズログ表示
																			 pFileInfo->size);			//			・
								if (pXyW->XYm_hFile != NULL) {											//		（念の為）前ファイルクローズ
									CloseHandle(pXyW->XYm_hFile);										//		・
								}
								pXyW->XYm_hFile = CreateFileA(FilePath, GENERIC_WRITE,					//		受信ファイルオープン
									 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);				//		・
								if (pXyW->XYm_hFile == INVALID_HANDLE_VALUE) {							//		オープン失敗？
									pXyW->XYm_hFile = NULL;												//			ファイルハンドル無効化
									AjcCipPrintF(pW->hWndBack, "File creation failure.");				//			オープン失敗ログ表示
								}
								break;

		case AJCXYN_RXREC_128:	if (pXyW->XYm_hFile != NULL) {											//	●１レコード受信( 128 bytes)
									AjcCipPrintF(pW->hWndBack, ".");
									WriteToFile(pXyW, (VOP)Param, 128);
								}
								else AjcCipPrintF(pW->hWndBack, "x");
								break;

		case AJCXYN_RXREC_1K:	if (pXyW->XYm_hFile != NULL) {											//	●１レコード受信(1024 bytes)
									AjcCipPrintF(pW->hWndBack, ":");
									WriteToFile(pXyW, (VOP)Param, 1024);
								}
								else AjcCipPrintF(pW->hWndBack, "X");
								break;

		case AJCXYN_RETRY:		AjcCipPrintF(pW->hWndBack, "R");					break;				//	●再送発生

		case AJCXYN_EOF:		AjcCipPrintF(pW->hWndBack, "E\n");										//	●ファイル終端（ＥＯＦ）
								if (pXyW->XYm_hFile != NULL) {											//		ファイルオープン済？
									if (pXyW->XYm_FTime) {												//			ファイル日付あり？
										SYSTEMTIME	st;
										FILETIME	ft;
										AjcTime1970ToSysTime(pXyW->XYm_FTime, &st);						//				システムタイムへ変更
										SystemTimeToFileTime(&st, &ft);									//				ファイルタイムに変更
										SetFileTime(pXyW->XYm_hFile, &ft, &ft, &ft);					//				ファイル日時設定
									}
									CloseHandle(pXyW->XYm_hFile); 										//			ファイルクローズ
									pXyW->XYm_hFile = NULL;												//			ファイルハンドル無効化
								}
								break;

		case AJCXYN_PROTOCOL:	AjcCipPrintF(pW->hWndBack, "C");										//	●プロトコル変更
								break;

		case AJCXYN_COMPLETE:	AjcCipPrintF(pW->hWndBack, "\nComplete.\n");			break;			//	●受信正常終了
		case AJCXYN_RX_CAN:		AjcCipPrintF(pW->hWndBack, "\nStop by Received CAN\n");	break;			//	●受信中止（ＣＡＮ受信）
		case AJCXYN_USERSTOP:	AjcCipPrintF(pW->hWndBack, "\nStop by user\n");			break;			//	●受信中止（ユーザ停止）
		case AJCXYN_TIMEOUT:	AjcCipPrintF(pW->hWndBack, "\nStop by Timeout\n");		break;			//	●受信中止（タイムアウト）
		case AJCXYN_ABORT: 		AjcCipPrintF(pW->hWndBack, "\nStop by abort\n");		break;			//	●受信中止（その他）
	}
}
//----- データ送出　コールバック関数 ---------------------------------------------------------------------------//
static VO CALLBACK cbYModemRxSend(C_VOP pTxD, UI len, UX cbp)
{
	PCBPYMRECV		pCbp = (PCBPYMRECV)cbp;
	HAJCCIP			pW	 = pCbp->hCip;
	PAJCCIPSCPINF	pInf = &pW->ExeScp[pCbp->port];
	PXYMWORK		pXyW = pInf->pXyW;

	AjcScpSendBinData(pInf->hScp, pTxD, len);
}
//----- ＹＭＯＤＥＭ処理本体 -----------------------------------------------------------------------------------//
BOOL	CipFunComRecvYModem(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc		= FALSE;
	PAJCCIPAGV		*ppAgv	= NULL;
	ULL				port	= 0;
	C_BCP			pPath;
	CBPYMRECV		cbp;
	PXYMWORK		pXyW	= NULL;
	SLL				fSubDir	= FALSE;

	if (pCall->nArg >= 2 && pCall->nArg <= 3) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
								   if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&port, pCall)))	break;
								   if (!(pPath = GetStrByNode(pW, ppAgv[1], pCall)))		break;
			if (pCall->nArg >= 3) {if (!(GetSIntByNode(pW, ppAgv[2], &fSubDir, pCall)))		break;}
			//	port引数値チェック
			if (!ChkPortNumber(pW, pCall, port, MIN_PORT, MAX_PORT)) {
				break;
			}
			//	ポート生成チェック
			if (pW->ExeScp[port].hScp == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)は初期化されていません。",
												 "%s - Port(#%d) is not initialized."), pCall->pFunName, (UI)port);
				break;
			}
			//	ポートオープンチェック
			if (!AjcScpIsOpened(pW->ExeScp[port].hScp)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ポート(#%d)はオープンされていません。",
												 "%s - Port(#%d) is not opened."), pCall->pFunName, (UI)port);
				break;
			}
			//	ＹＭＯＤＥＭ制御ワーク割り当て
			pXyW = pW->ExeScp[port].pXyW = (PXYMWORK)AJCMEM(sizeof(XYMWORK));
			if (pXyW == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - ＹＭＯＤＥＭ用作業領域の割り当てを失敗しました。",
												 "%s - Work of YMODEM allocation failure."), pCall->pFunName);
				break;
			}
			memset(pXyW, 0, sizeof(XYMWORK));
			//	チャンク受信イベント有効化
			AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) |  AJCSCP_EV_RXCHUNK);
			//	受信ファイル格納フォルダ設定
			if (!AjcPathIsDirectoryA(pPath)){
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 指定されたフォルダは存在しません。(%s)",
												 "%s - Folder not found(%s)."), pCall->pFunName, pPath);
				break;
			}
			AjcSnPrintFA(pXyW->XYm_AnyPath, MAX_PATH, "%s", pPath);
			AjcPathCatA (pXyW->XYm_AnyPath, "", MAX_PATH);
			//	YMODEMインスタンス生成
			cbp.port	= (UI)port;
			cbp.hCip	= pW;
			cbp.fSubDir = (BOOL)fSubDir;
			if ((pW->ExeScp[port].hXyModem = AjcXymCreate((UX)&cbp, cbYModemRxNotice, NULL, NULL, cbYModemRxSend)) == NULL) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - ＹＭＯＤＥＭ受信準備を失敗しました。",
												 "%s - YMODEM instance creation failure."), pCall->pFunName);
				break;
			}
			//	その他のＹＭＯＤＥＭ受信情報初期化
			pXyW->XYm_hFile = NULL;
			//	YMODEM受信
			if (AjcXymRxStart(pW->ExeScp[port].hXyModem, AJCXYP_YMODEM_STD)) {
				AjcCipPrintF(pW->hWndBack, "YMODEM Receiving Start, Port(#%d) -> %s\n", (UI)port, pPath);
				while (!(pXyW->XYm_evt & AJCXYN_END)) {
					if (pW->fRunStop) {
						AjcXymStop(pW->ExeScp[port].hXyModem);
						break;
					}
					CipGsrDoEvent(pW);
				}
				AjcCipPrintF(pW->hWndBack, "YMODEM Receiving End\n", port, pPath);
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ＹＭＯＤＥＭ受信を開始できません。",
												 "%s - YMODEM starting failure."), pCall->pFunName);
				break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	リソース解放
		if (port != 0) {
			//	受信ファイルクローズ
			if (pXyW->XYm_hFile != NULL) {
				CloseHandle(pXyW->XYm_hFile);
				pXyW->XYm_hFile = NULL;
			}
			//	SCP後処理
			if (pW->ExeScp[port].hScp != NULL) {
				//	チャンク受信イベント無効化
				AjcScpSetEvtMask(pW->ExeScp[port].hScp, AjcScpGetEvtMask(pW->ExeScp[port].hScp) & ~AJCSCP_EV_RXCHUNK);
			}
			//	ＹＭＯＤＥＭ制御ワーク解放
			if (pXyW != NULL) {
				free(pXyW);
				pXyW = pW->ExeScp[port].pXyW = NULL;
			}
			//	ＹＭＯＤＥＭインスタンス消去
			if (pW->ExeScp[port].hXyModem != NULL) {
				AjcXymDelete(pW->ExeScp[port].hXyModem);
				pW->ExeScp[port].hXyModem = NULL;
			}
		}
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	イベントの禁止／許可																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	標準イベント関数の実行禁止		_DisStdEvt()																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunDisStdEvt	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;

	if (pCall->nArg == 0) {
		if (!pW->fExeStdEvtBusy) {
			if (pCall->nArg == 0) {
				if (pW->nExeDisStdEvt < INT_MAX) {
					//	イベント禁止ネスト増加
					pW->nExeDisStdEvt++;
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
											  LNGSEL("%s - 標準イベント禁止のネストが深すぎます。",
													 "%s - Disabling event nest overflow."), pCall->pFunName);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 引数の個数が不正です。",
												 "%s - Invalid number of arguments."), pCall->pFunName);
			}
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
									  LNGSEL("%s - 標準イベント関数から _DisStdEvt() はコールできません。",
											 "%s - Can not call _DisStdEvt() in std-event-function."), pCall->pFunName);
		}
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	標準イベント関数の実行許可		_EnaStdEvt()																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunEnaStdEvt	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;

	if (pCall->nArg == 0) {
		if (!pW->fExeStdEvtBusy) {
			if (pCall->nArg == 0) {
				if (pW->nExeDisStdEvt > 0) {
					//	イベント禁止ネスト減算
					pW->nExeDisStdEvt--;
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - 標準イベントは禁止されていません。",
													 "%s - Event is not disabled."), pCall->pFunName);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 引数の個数が不正です。",
												 "%s - Invalid number of arguments."), pCall->pFunName);
			}
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
									  LNGSEL("%s - 標準イベント関数から _EnaStdEvt() はコールできません。",
											 "%s - Can not call _EnaStdEvt() in event-function."), pCall->pFunName);
		}
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	標準イベント関数の実行禁止ネストレベル取得		_GetDisStdEvt()												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetDisStdEvt	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;

	if (pCall->nArg == 0) {
		if (!pW->fExeStdEvtBusy) {
			if (pCall->nArg == 0) {
				//	イベント禁止ネストレベルを返す
				if (pCall->rchVmg != NULL) {
					rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->nExeDisStdEvt);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 引数の個数が不正です。",
												 "%s - Invalid number of arguments."), pCall->pFunName);
			}
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
									  LNGSEL("%s - イベント関数から _EnableEvent() はコールできません。",
											 "%s - Can not call _EnableEvent() in event-function."), pCall->pFunName);
		}
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭイベント関数の実行禁止		_DisComEvt()																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunDisComEvt	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;

	if (pCall->nArg == 0) {
		if (!pW->fExeComEvtBusy) {
			if (pCall->nArg == 0) {
				if (pW->nExeDisComEvt < INT_MAX) {
					//	イベント禁止ネスト増加
					pW->nExeDisComEvt++;
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
											  LNGSEL("%s - イベント禁止のネストが深すぎます。",
													 "%s - Disabling event nest overflow."), pCall->pFunName);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 引数の個数が不正です。",
												 "%s - Invalid number of arguments."), pCall->pFunName);
			}
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
									  LNGSEL("%s - イベント関数から _DisComEvt() はコールできません。",
											 "%s - Can not call _DisComEvt() in std-event-function."), pCall->pFunName);
		}
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//==============================================================================================================//
//	ＣＯＭイベント関数の実行許可		_EnaComEvt()																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunEnaComEvt	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;

	if (pCall->nArg == 0) {
		if (!pW->fExeComEvtBusy) {
			if (pCall->nArg == 0) {
				if (pW->nExeDisComEvt > 0) {
					//	イベント禁止ネスト減算
					pW->nExeDisComEvt--;
					//	戻り値=正常
					rc = TRUE;
				}
				else {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - イベントは禁止されていません。",
													 "%s - Event is not disabled."), pCall->pFunName);
				}
			}
			else {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - 引数の個数が不正です。",
												 "%s - Invalid number of arguments."), pCall->pFunName);
			}
		}
		else {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
									  LNGSEL("%s - イベント関数から _EnaComEvt() はコールできません。",
											 "%s - Can not call _EnaComEvt() in event-function."), pCall->pFunName);
		}
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ＣＯＭイベント関数の実行禁止ネストレベル取得		_GetDisComEvt()											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetDisComEvt	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;

	if (pCall->nArg == 0) {
		//	イベント禁止ネストレベルを返す
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, pW->nExeDisComEvt);
		}
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	タイムチャートグラフ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	タイムチャート オープン		_TmcOpen([$Title] [,$PropText] [,x] [,y] [,cx] [,cy])							//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcOpen	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	C_BCP			pTitle = "";
	C_BCP			pText  = "";
	SLL				x	   = CW_USEDEFAULT;
	SLL				y	   = CW_USEDEFAULT;
	SLL				cx	   = 600;
	SLL				cy	   = 300;
	HWND			hwnd;

	if (pCall->nArg >= 0 && pCall->nArg <= 6) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg >= 1) {if (!(pTitle = GetStrByNode(pW, ppAgv[0], pCall)))	 break;}
			if (pCall->nArg >= 2) {if (!(pText	= GetStrByNode(pW, ppAgv[1], pCall)))	 break;}
			if (pCall->nArg >= 3) {if (!(GetSIntByNode(pW, ppAgv[2], (SLLP)&x , pCall))) break;}
			if (pCall->nArg >= 4) {if (!(GetSIntByNode(pW, ppAgv[3], (SLLP)&y , pCall))) break;}
			if (pCall->nArg >= 5) {if (!(GetSIntByNode(pW, ppAgv[4], (SLLP)&cx, pCall))) break;}
			if (pCall->nArg >= 6) {if (!(GetSIntByNode(pW, ppAgv[5], (SLLP)&cy, pCall))) break;}
			//	ＴＭＣ生成済ならば、一旦クローズ
			if (pW->hWndTmcBack != NULL) {
				DestroyWindow(pW->hWndTmcBack);
				pW->hWndTmcBack = NULL;
			}
			//	ＴＭＣ生成
			if (pW->hWndTmcBack == NULL) {
				//	ＴＭＣプロパティテキスト設定
				AjcSnPrintFA(pW->ExeTmcTxt, sizeof pW->ExeTmcTxt, "%s", pText);
				//	TMC用ウインド生成
				hwnd = CreateWindowA(AJCCIP_TMCBAKCLASS, 			// window class name
									 pTitle,						// window caption
									 WS_OVERLAPPEDWINDOW,			// style
									 (int)x,						// initial x position
									 (int)y,						// initial y position
									 (int)cx,						// initial x size
									 (int)cy,						// initial y size
									 NULL,							// parent window handle
									 NULL,							// window menu handle
									 hDllInst,						// program instance handle
									 (VOP)pW);						// creation parameters
				if (hwnd == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - タイムチャートの初期化を失敗しました。",
													 "%s - Timechart initialization failure."), pCall->pFunName);
					break;
				}
				//	ウインドハンドル設定
				pW->hWndTmcBack = hwnd;
				//	ウインド表示
				ShowWindow(hwnd, SW_SHOWNORMAL);
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート データ項目数設定		_TmcSetItems(NumOfDataItems)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcSetItems	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				n;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg == 1) {
			do {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	引数値設定
				if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&n, pCall))) break;
				//	データ項目数チェック
				if (n < 1 || n > 8) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - データ項目数が不正です。",
													 "%s - Invalid data item number."), pCall->pFunName);
					break;
				}
				//	データ項目数設定
				AjcTchSetItemNumber(pW->hWndTmc, (int)n);
				//	戻り値=正常
				rc = TRUE;
			} while(0);

			//	引数情報解放
			if (ppAgv != NULL)	free(ppAgv);
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート レンジ設定		_TmcSetRange(Low, High)														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcSetRange	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	double			lo, hi;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg == 2) {
			do {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	引数値設定
				if (!(GetRealByNode(pW, ppAgv[0], &lo, pCall))) break;
				if (!(GetRealByNode(pW, ppAgv[1], &hi, pCall))) break;
				//	レンジ設定
				if (lo != hi) {
					AjcTchSetRealRange	 (pW->hWndTmc, lo, hi);
				}
				else {
					AjcTchAdjustRange(pW->hWndTmc);
				}
				//	戻り値=正常
				rc = TRUE;
			} while(0);

			//	引数情報解放
			if (ppAgv != NULL)	free(ppAgv);
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート データ投与		_TmcPutData(d1 [,d2]・・・[, d8]) / _TmcPutData(data[])						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcPutData	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	double			dat[8] = {0, 0, 0, 0, 0, 0, 0, 0};
	UI				i, iMax;
	PCAJCVMGNODEA	pNode;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg >= 1 && pCall->nArg <= 8) {
			do {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	データ投与
				if (ppAgv[0]->fArr) {		//	配列変数？
					if (pCall->nArg == 1) {
						//	引数のノード取得
						if ((pNode = CipVmgGetNode(pW, pCall->lno, ppAgv[0]->val.arr.hVmg, ppAgv[0]->val.arr.pName)) == NULL) {
							break;
						}
						//	引数値設定
						iMax = __min(pNode->num, 8);
						for (i = 0; i < iMax; i++) {
							if (pW->NumType == AJCIPT_INTEGER) dat[i] = (double)pNode->arr.pSLL[i];
							else							   dat[i] = (double)pNode->arr.pDBL[i];
						}
					}
					else {
						pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
												  LNGSEL("%s - 引数の個数が不正です。",
														 "%s - Invalid number of arguments."), pCall->pFunName);
					}
				}
				else {						//	単純変数？
					for (i = 0; i < pCall->nArg; i++) {
						if (!(GetRealByNode(pW, ppAgv[i], &dat[i], pCall))) goto cftpd_exit;
					}
				}
				AjcTchPutRealData(pW->hWndTmc, dat);
				//	戻り値=正常
				rc = TRUE;
			} while(0);
cftpd_exit:;
			//	引数情報解放
			if (ppAgv != NULL)	free(ppAgv);
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート クリアー		_TmcClear()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcClear	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg == 0) {
			//	クリアー
			AjcTchPurge(pW->hWndTmc);
			//	戻り値=正常
			rc = TRUE;
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート ウインド移動		_TmcWndMove(x, y)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcWndMove	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				x, y;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg == 2) {
			do {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	引数値設定
				if (!(GetSIntByNode(pW, ppAgv[0], &x, pCall))) break;
				if (!(GetSIntByNode(pW, ppAgv[1], &y, pCall))) break;
				//	ウインド移動
				SetWindowPos(pW->hWndTmcBack, NULL, (int)x, (int)y, 0, 0, SWP_NOSIZE);
				//	戻り値=正常
				rc = TRUE;
			} while(0);

			//	引数情報解放
			if (ppAgv != NULL)	free(ppAgv);
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート ウインドサイズ設定		_TmcWndWndSize(cx, cy)												//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcWndSize	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				cx, cy;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg == 2) {
			do {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	引数値設定
				if (!(GetSIntByNode(pW, ppAgv[0], &cx, pCall))) break;
				if (!(GetSIntByNode(pW, ppAgv[1], &cy, pCall))) break;
				//	ウインド移動
				SetWindowPos(pW->hWndTmcBack, NULL, 0, 0, (int)cx, (int)cy, SWP_NOMOVE);
				//	戻り値=正常
				rc = TRUE;
			} while(0);

			//	引数情報解放
			if (ppAgv != NULL)	free(ppAgv);
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	タイムチャート クローズ		_TmcClose()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTmcClose	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;

	if (pW->hWndTmcBack != NULL) {
		if (pCall->nArg == 0) {
			//	クローズ
			DestroyWindow(pW->hWndTmcBack);
			pW->hWndTmcBack = NULL;
			//	戻り値=正常
			rc = TRUE;
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - タイムチャートは未オープンです。",
										 "%s - Timechart is not opened."), pCall->pFunName);
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ボタン																										//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ボタンオープン			_BtnOpen(BtmBo, $Caption)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunBtnOpen	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				BtnNo  = 0;
	C_BCP			pCap   = "";
	HWND			hBtn   = NULL;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&BtnNo , pCall)))	break;
			if (!(pCap	= GetStrByNode(pW, ppAgv[1], pCall)))	 		break;
			//	ボタン番号チェック
			if (BtnNo < 0 || BtnNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ボタン番号は０～７でなければなりません。",
												 "%s - Button number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	ボタン未生成ならば生成
			if (pW->hButton[BtnNo] == NULL) {
				//	ボタン・ウインド生成
				hBtn = CreateWindowA("BUTTON",									// window class name
									 pCap,										// window caption
									 WS_CHILD,									// window style
									 0,											// initial x position
									 0,											// initial y position
									 10,										// initial x size
									 10,										// initial y size
									 pW->hWndBack,								// parent window handle
									 (HMENU)((UX)(IDC_BKBUTTON + (UI)BtnNo)),	// window menu handle
									 hDllInst,									// program instance handle
									 NULL);										// creation parameters
				if (hBtn == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
											  LNGSEL("%s - ボタンの生成を失敗しました。",
													 "%s - Button creation failure."), pCall->pFunName);
					break;
				}
				//	フォント設定
				SendMessage(hBtn, WM_SETFONT, (WPARAM)hDefFontVar, TRUE);
				//	ウインド表示
				ShowWindow(hBtn, SW_SHOW);
				//	ウインドハンドル設定
				pW->hButton[BtnNo] = hBtn;
				//	ボタン有効フラグ設定
				pW->mskBtnValid |= (1 << BtnNo);
			}
			//	ボタン生成済ならば、キャプション設定
			else {
				SetWindowTextA(pW->hButton[BtnNo], pCap);
			}
			//	ボタン，チェックボックス整列
			CipGsrBtnAndChkBoxAlignment(pW);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ボタンクローズ				_BtnClose(BtmBo)																//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunBtnClose	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				BtnNo  = 0;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&BtnNo , pCall)))	break;
			//	ボタン番号チェック
			if (BtnNo < 0 || BtnNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ボタン番号は０～７でなければなりません。",
												 "%s - Button number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	ボタン破棄
			if (pW->hButton[BtnNo]) DestroyWindow(pW->hButton[BtnNo]); 
			//	ウインドハンドルクリアー
			pW->hButton[BtnNo] = NULL;
			//	ボタン有効フラグ解除
			pW->mskBtnValid &= ~(1 << BtnNo);
			//	ボタン，チェックボックス整列
			CipGsrBtnAndChkBoxAlignment(pW);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ボタン有効化／無効化		_BtnEnable(BtnNo, fEnable)														//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunBtnEnable	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				BtnNo  = 0;
	SLL				fEnable= 0;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&BtnNo	, pCall)))	break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&fEnable, pCall)))	break;
			//	ボタン番号チェック
			if (BtnNo < 0 || BtnNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - ボタン番号は０～７でなければなりません。",
												 "%s - Button number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	ボタン有効化／無効化
			if (pW->hButton[BtnNo]) EnableWindow(pW->hButton[BtnNo], fEnable != 0); 
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	チェックボックス																							//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	チェックボックスオープン	_ChkBoxOpen(BtmBo, $Caption)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunChkBoxOpen	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				ChkBoxNo  = 0;
	C_BCP			pCap   = "";
	HWND			hChk   = NULL;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&ChkBoxNo , pCall)))	break;
			if (!(pCap	= GetStrByNode(pW, ppAgv[1], pCall)))	 			break;
			//	チェックボックス番号チェック
			if (ChkBoxNo < 0 || ChkBoxNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - チェックボックス番号は０～７でなければなりません。",
												 "%s - Check-box number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	チェックボックス未生成ならば生成
			if (pW->hChkBox[ChkBoxNo] == NULL) {
				//	チェックボックス・ウインド生成
				hChk = CreateWindowExA(WS_EX_WINDOWEDGE,
										"BUTTON",									// window class name
										pCap,										// window caption
										WS_BORDER | WS_CHILD | BS_AUTOCHECKBOX,		// window style
										0,											// initial x position
										0,											// initial y position
										10,											// initial x size
										10,											// initial y size
										pW->hWndBack,								// parent window handle
										(HMENU)((UX)(IDC_BKCHKBOX + (UI)ChkBoxNo)),	// window menu handle
										hDllInst,									// program instance handle
										NULL);										// creation parameters
				if (hChk == NULL) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - チェックボックスの生成を失敗しました。",
													 "%s - Check-box creation failure."), pCall->pFunName);
					break;
				}
				//	フォント設定
				SendMessage(hChk, WM_SETFONT, (WPARAM)hDefFontVar, TRUE);
				//	ウインド表示
				ShowWindow(hChk, SW_SHOW);
				//	ウインドハンドル設定
				pW->hChkBox[ChkBoxNo] = hChk;
				//	チェックボックス有効フラグ設定
				pW->mskChkValid |= (1 << ChkBoxNo);
			}
			//	チェックボックス生成済ならば、キャプション設定
			else {
				SetWindowTextA(pW->hChkBox[ChkBoxNo], pCap);
			}
			//	ボタン，チェックボックス整列
			CipGsrBtnAndChkBoxAlignment(pW);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	チェックボックスクローズ	_ChkBoxClose(ChkBoxNo)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunChkBoxClose	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				ChkBoxNo  = 0;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&ChkBoxNo , pCall)))	break;
			//	チェックボックス番号チェック
			if (ChkBoxNo < 0 || ChkBoxNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - チェックボックス番号は０～７でなければなりません。",
												 "%s - Check-box number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	チェックボックス破棄
			if (pW->hChkBox[ChkBoxNo]) DestroyWindow(pW->hChkBox[ChkBoxNo]); 
			//	ウインドハンドルクリアー
			pW->hChkBox[ChkBoxNo] = NULL;
			//	チェックボックス有効フラグ解除
			pW->mskChkValid &= ~(1 << ChkBoxNo);
			//	ボタン，チェックボックス整列
			CipGsrBtnAndChkBoxAlignment(pW);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	チェックボックス・ステータス取得	_ChkBoxGetSts(ChkBoxNo)													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunChkBoxGetSts	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				ChkBoxNo  = 0;
	SLL				fEnable= 0;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&ChkBoxNo  , pCall)))	break;
			//	チェックボックス番号チェック
			if (ChkBoxNo < 0 || ChkBoxNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - チェックボックス番号は０～７でなければなりません。",
												 "%s - Check-boxn number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	チェックボックスステータスを返す
			if (pCall->rchVmg != NULL) {
				BOOL	sts = AjcGetCtrlChk(pW->hChkBox[ChkBoxNo]);
				if (!CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, sts)) break;
			}
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	チェックボックス・ステータス設定	_ChkBoxSetSts(ChkBoxNo, status)											//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunChkBoxSetSts	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc		 = FALSE;
	PAJCCIPAGV		*ppAgv	 = NULL;
	SLL				ChkBoxNo = 0;
	SLL				Status	 = 0;

	if (!pW->fBusyOnChkBox) {
		if (pCall->nArg == 2) {
			do {
				//	引数収集
				if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
					break;
				}
				//	引数値設定
				if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&ChkBoxNo, pCall)))	break;
				if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&Status  , pCall)))	break;
				//	チェックボックス番号チェック
				if (ChkBoxNo < 0 || ChkBoxNo > 7) {
					pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
											  LNGSEL("%s - チェックボックス番号は０～７でなければなりません。",
													 "%s - Check-boxn number out of range(0 to 7)."), pCall->pFunName);
					break;
				}
				//	チェックボックスステータスを設定
				AjcSetCtrlChk(pW->hChkBox[ChkBoxNo], (BOOL)Status);
				//	_OnChkBox()呼び出し
				CipGsrCall_OnChkBox(pW, (int)ChkBoxNo);
				//	戻り値=正常
				rc = TRUE;
			} while(0);

			//	引数情報解放
			if (ppAgv != NULL)	free(ppAgv);
		}
		else {
			Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,
								  LNGSEL("%s - _OnChkBox()中で、_ChkBoxSetSts()は実行できません。",
										 "%s - Do not execute _ChkBoxSetSts() in _OnChkBox()."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	チェックボックス有効化／無効化		_ChkBoxEnable(ChkBoxNo, fEnable)										//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunChkBoxEnable	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL			rc	   = FALSE;
	PAJCCIPAGV		*ppAgv = NULL;
	SLL				ChkBoxNo  = 0;
	SLL				fEnable= 0;

	if (pCall->nArg == 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], (SLLP)&ChkBoxNo  , pCall)))	break;
			if (!(GetSIntByNode(pW, ppAgv[1], (SLLP)&fEnable, pCall)))		break;
			//	チェックボックス番号チェック
			if (ChkBoxNo < 0 || ChkBoxNo > 7) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
										  LNGSEL("%s - チェックボックス番号は０～７でなければなりません。",
												 "%s - Check-boxn number out of range(0 to 7)."), pCall->pFunName);
				break;
			}
			//	チェックボックス有効化／無効化
			if (pW->hChkBox[ChkBoxNo]) EnableWindow(pW->hChkBox[ChkBoxNo], fEnable != 0); 
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	その他																										//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	ウインド右上にテキスト表示	_ShowText()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunShowText(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pTxt;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(pTxt = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	テキスト表示
			if (*pTxt == 0) pTxt = NULL;
			AjcVthSetTitleTextA(pW->hWndVth, pTxt, -1, -1, NULL);
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ウインドＸ位置取得		_GetWndPosX()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetWndPosX	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	RECT		rect;

	if (pCall->nArg == 0) {
		//	ウインドＸ位置を返す
		GetWindowRect(pW->hWndVth, &rect);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rect.left);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ウインドＹ位置取得		_GetWndPosY()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetWndPosY	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	RECT		rect;

	if (pCall->nArg == 0) {
		//	ウインドＸ位置を返す
		GetWindowRect(pW->hWndVth, &rect);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rect.top);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ウインド幅取得		_GetWndWidth()																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetWndWidth	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	RECT		rect;

	if (pCall->nArg == 0) {
		//	ウインド横サイズを返す
		GetWindowRect(pW->hWndVth, &rect);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rect.right - rect.left);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	ウインドの高さ取得		_GetWndHeight()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetWndHeight	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	RECT		rect;

	if (pCall->nArg == 0) {
		//	ウインド横サイズを返す
		GetWindowRect(pW->hWndVth, &rect);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, rect.bottom - rect.top);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字の幅取得		_GetCharWidth()																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetCharWidth	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	UI			width;

	if (pCall->nArg == 0) {
		//	文字の幅を返す
		AjcVthGetCharInfo(pW->hWndVth, &width, NULL, NULL);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, width);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	文字の高さ取得		_GetCharHeight()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetCharHeight	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	UI			height;

	if (pCall->nArg == 0) {
		//	文字の幅を返す
		AjcVthGetCharInfo(pW->hWndVth, NULL, &height, NULL);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, height);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	行の高さ取得		_GetLineHeight()																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunGetLineHeight	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	UI			height;

	if (pCall->nArg == 0) {
		//	行の幅を返す
		AjcVthGetCharInfo(pW->hWndVth, NULL, NULL, &height);
		if (pCall->rchVmg != NULL) {
			rc = CipVmgSetInteger(pW, pCall->lno, pCall->rchVmg, pCall->rcpSym, (UI)pCall->rcIx, height);
		}
		//	戻り値=正常
		rc = TRUE;
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	マクロ終了				_Exit($Text)																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunExit	(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc	   = FALSE;
	PAJCCIPAGV	*ppAgv = NULL;
	C_BCP		pTxt;

	if (pCall->nArg == 0 || pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	テキスト設定
			if (pCall->nArg == 1) {
				if (!(pTxt = GetStrByNode(pW, ppAgv[0], pCall))) break;
				AjcSnPrintFA(pW->ExitText, sizeof pW->ExitText, "%s", pTxt);
			}
			else {
				pW->ExitText[0] = 0;
			}
			//	マクロ終了
			pW->fRunStop = TRUE;
			//	戻り値=正常
			rc = TRUE;
		} while(0);

		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
	}
	return rc;
}
//==============================================================================================================//
//	変数のダンプ表示			_VarDump([MaxArrNum] [,"@ALL])													//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunVarDump		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc			= FALSE;
	PAJCCIPAGV	*ppAgv		= NULL;
	SLL			MaxArrNum	= 10;
	C_BCP		pAll		= NULL;
	BOOL		fVarDumpAll	= FALSE;

	if (pCall->nArg >= 0 || pCall->nArg <= 2) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (pCall->nArg >= 1) {
				if (!(GetSIntByNode(pW, ppAgv[1], &MaxArrNum, pCall)))	break;
			}
			if (pCall->nArg >= 2) {
				if (!((pAll = GetStrByNode(pW, ppAgv[0], pCall)))) break;
				//	全変数ダンプ・フラグ設定
				fVarDumpAll = (mbscmp(pAll, "@ALL") == 0);
			}
			//	トレースウインド生成
			if (!CipTrcCreateWindow(pW)) {
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
										  LNGSEL("%s - トレースウインドの作成を失敗しました",
												 "%s - Trace window creation failure."), pCall->pFunName);
				break;
			}
			//	全変数ダンプ表示
			CipTrcVarDump(pW, (UI)MaxArrNum, pCall->lno, fVarDumpAll);
			//	戻り値=正常
			rc = TRUE;
		} while(0);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - 引数の個数が不正です。",
										 "%s - Invalid number of arguments."), pCall->pFunName);
	}
	return rc;
}
//==============================================================================================================//
//	トレース表示			_Trace($fmt [,arg]・・・)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunTrace			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL	rc = FALSE;
	BC		txt[1024];

	//	書式文字列生成
	if (rc = SubSPrintF(pW, pCall, txt, sizeof txt)) {
		//	作成した文字列を表示
		CipTrcPutText(pW, txt, pCall->lno);
		//	戻り値＝正常
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	一時停止			_Pause()																				//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJC_DLGPROC_DEF(Pause);
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipFunPause			(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	pW->PauseLno  = pCall->lno;		//	行番号退避
	pW->fExePause = TRUE;			//	一時停止の旨、フラグ設定

	return TRUE;
}
//==============================================================================================================//
//																												//
//	一時停止ダイアログ表示																						//
//																												//
//==============================================================================================================//
VO		ShowPauseDialog(HAJCCIP pW)
{
	BC		ttl[256];
	BC		msg[256];

	AjcSnPrintFA(ttl, sizeof ttl, LNGSEL("マクロ実行 (%s)", "Macro (%s)"), pW->MacFName);

	AjcSnPrintFA(msg, sizeof msg, 
				 LNGSEL("Line = %d, 処理を中断しました。再開するにはＯＫボタンを押してください。",
						"Line = %d, It interrupted processing. To resume, press the OK button."), pW->PauseLno);

	AjcBell();
	CipGerMessageBoxOK(pW, pW->hWndVth, msg, ttl);
}

//==============================================================================================================//
//	ステップトレース禁止／許可		_StepTrace(fEnable)															//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipFunStepTrace		(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	BOOL		rc			= FALSE;
	PAJCCIPAGV	*ppAgv		= NULL;
	SLL			fEna;

	if (pCall->nArg == 1) {
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	引数値設定
			if (!(GetSIntByNode(pW, ppAgv[0], &fEna, pCall)))	break;
			//	ステップトレースウインド許可／禁止
			CipStepEnable(pW, (BOOL)fEna);
			//	戻り値=正常
			rc = TRUE;
		} while(0);
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
								  LNGSEL("%s - 引数の個数が不正です。",
										 "%s - Invalid number of arguments."), pCall->pFunName);
	}
	return rc;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//		サブ関数																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	引数情報配列作成																							//
//																												//
//	引　数	：	pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	≠NULL - 配列へのポインタ（この配列は、使用後解放要）											//
//				＝NULL - エラー																					//
//==============================================================================================================//
PAJCCIPAGV	*MakeArgInfo(HAJCCIP pW, PCAJCCIPCALL pCall)
{
	PAJCCIPAGV	*pAgv = NULL;
	PAJCCIPAGV	svp;
	UI			ix	  = 0;

	if (pAgv = (PAJCCIPAGV*)AJCMEM(sizeof(AJCCIPAGV) * pCall->nArg)) {
		//	引数収集
		ix = 0;
		if (svp = AjcFQueTopNode(pCall->hQueAgv)) {
			do {
				pAgv[ix] = svp;
				ix++;
			} while(ix < pCall->nArg && (svp = AjcFQueNextNode(pCall->hQueAgv, svp)));
		}
		//	引数の個数チェック
		if (ix != pCall->nArg) {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_INTERNAL, pCall->lno,
									  LNGSEL("%s - 内部エラー（引数の個数が合いません）。",
											 "%s - Internal error (Number of arguments unmatch)."), pCall->pFunName);
			free(pAgv);
			pAgv = NULL;
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_MEM, pCall->lno,
								  LNGSEL("%s - 引数情報用のメモリを確保できません。",
										 "%s - Arguments information memory allocation failure."), pCall->pFunName);
	}
	return pAgv;
}

//--------------------------------------------------------------------------------------------------------------//
//	引数値ノードから符号付整数値取り出し																		//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	GetSIntByNode(HAJCCIP pW, PAJCCIPAGV pNode, SLLP pSll, PCAJCCIPCALL pCall)
{
	BOOL	rc = TRUE;

	if (!pNode->fArr) {
		switch (pNode->typ) {
			case AJCIPT_INTEGER:
				*pSll = pNode->val.sll;
				break;

			case AJCIPT_REAL:
				*pSll = (SLL)pNode->val.dbl;
				break;

			default:
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - %d番目の引数は、数値型でなければなりません。",
												 "%s - Must be numeric type in %d[th] argument."), pCall->pFunName, pNode->seq + 1);
				rc = FALSE;
				break;
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
								  LNGSEL("%s - %d番目の引数に配列は指定できません。",
										 "%s - Can not specify array in %d[th] argument."), pCall->pFunName, pNode->seq + 1);
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	引数値ノードから実数値取り出し																				//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	GetRealByNode(HAJCCIP pW, PAJCCIPAGV pNode, double *pDbl, PCAJCCIPCALL pCall)
{
	BOOL	rc = TRUE;

	if (!pNode->fArr) {
		switch (pNode->typ) {
			case AJCIPT_INTEGER:
				*pDbl = (double)pNode->val.sll;
				break;

			case AJCIPT_REAL:
				*pDbl = pNode->val.dbl;
				break;

			default:
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - %d番目の引数は、数値型でなければなりません。",
												 "%s - Must be numeric type in %d[th] argument."), pCall->pFunName, pNode->seq + 1);
				rc = FALSE;
				break;
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
								  LNGSEL("%s - %d番目の引数に配列は指定できません。",
										 "%s - Can not specify array in %d[th] argument."), pCall->pFunName, pNode->seq + 1);
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	引数値ノードから文字列取り出し																				//
//--------------------------------------------------------------------------------------------------------------//
static	C_BCP	GetStrByNode(HAJCCIP pW, PAJCCIPAGV pNode, PCAJCCIPCALL pCall)
{
	C_BCP		rc = NULL;

	if (!pNode->fArr) {
		switch (pNode->typ) {
			case AJCIPT_STRING:
				rc = pNode->val.pStr;
				break;

			default:
				pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - %d番目の引数は、文字型でなければなりません。",
												 "%s - Must be string type in %d[th] argument."), pCall->pFunName, pNode->seq + 1);
				rc = FALSE;
				break;
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
								  LNGSEL("%s - %d番目の引数に配列は指定できません。",
										 "%s - Can not specify array in %d[th] argument."), pCall->pFunName, pNode->seq + 1);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	書式文字列作成																								//
//																												//
//	引　数	：	pCall		- 関数呼び出し情報																	//
//				pBuf		- 書式文字列を格納するバッファ														//
//				lBuf		- 書式文字列を格納するバッファのバイト数											//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
#define		SETBUFS(S)	{	UI stl = (UI)strlen(S);															\
							if (cBuf + (stl + 1) < lBuf) {													\
								memcpy(&pBuf[cBuf], S, stl);												\
								cBuf += stl;																\
							}																				\
							else {																			\
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,					\
											  LNGSEL("%s - 生成する文字列が長すぎます。",					\
													 "%s - Generation string too long."), pCall->pFunName);	\
								rc = FALSE;																	\
								goto sspf_exit;																\
							}																				\
						}
//--------------------------------------------------------------------------------------------------------------//
#define		SETBUFC(C)		if (cBuf < lBuf) {																\
								pBuf[cBuf++] = (BC)(C);														\
							}																				\
							else {																			\
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_EXEC, pCall->lno,					\
											  LNGSEL("%s - 生成する文字列が長すぎます。",					\
													 "%s - Generation string too long."), pCall->pFunName);	\
								rc = FALSE;																	\
								goto sspf_exit;																\
							}
						
//--------------------------------------------------------------------------------------------------------------//
#define		SETFMTC(C)	if (lFmt < sizeof(wFmt)) {															\
							wFmt[lFmt++] = (BC)(C);															\
						}																					\
						else {																				\
							SubSpfErrFmtLong(pW, pCall, seq, wFmt);											\
							rc = FALSE;																		\
							goto sspf_exit;																	\
						}
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubSpfErrFmtLong(HAJCCIP pW, PCAJCCIPCALL pCall, UI seq, BC wFmt[])
{
	pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
				  LNGSEL("%s - %d番目の書式(%s)が長すぎます。",
						 "%s - %dth argument, Format expression(%s) too long."),
						 pCall->pFunName, seq, wFmt);
}
//--------------------------------------------------------------------------------------------------------------//
static BOOL	SubSPrintF(HAJCCIP pW, PCAJCCIPCALL pCall, BCP pBuf, UI lBuf)
{
	BOOL		rc	   = TRUE;
	UI			ixArg;							//	引数インデクス
	PAJCCIPAGV	*ppAgv = NULL;					//	引数ポインタ配列
	UI			cBuf = 0;						//	生成文字列格納バイトカウンタ
	UI			seq  = 0;						//	書式の順序番号
	union {ULL num; double dbl; C_BCP pStr;} u;	//	引数値

	SLL			len1, len2;						//	可変長指定値「*」or「*.*」

	C_BCP		pFmt, p;						//	書式文字列ポインタ
	BC			typ;							//	書式タイプ（書式文字列の末尾文字）
	UI			lFmt;							//	書式文字列の長さ
	BC			wFmt[64];						//	単一書式バッファ
	BC			wStr[512];						//	単一書式による生成文字列

	if (pCall->nArg >= 1) {						//	引数は１個以上（最低、書式文字列が必要）
		do {
			//	引数収集
			if ((ppAgv = MakeArgInfo(pW, pCall)) == NULL) {
				break;
			}
			//	書式テキスト設定
			if (!(pFmt = GetStrByNode(pW, ppAgv[0], pCall))) break;
			//	書式文字列作成
			ixArg  = 1;
			p	   = pFmt;
			while (*p != 0) {
				if (*p == '%') {
					lFmt   = 0;
					SETFMTC(*p);
					p++;
					seq++;
					if (*p == '%') {			//	'%%' ？
						SETBUFS("%");
						p++;
					}
					else {						//	'%%' 以外？
						len1  = -1;				//		整数部可変長「＊」なし
						len2  = -1;				//		小数部可変長「＊」なし

						//	書式による文字列設定
						if (*p == '-' || *p == '+' || *p == '0' || MAjcIsBlankA(*p) || *p == '#')	{	//	-, +, 0, 空白, or #
							SETFMTC(*p);
							p++;
						}
						if (*p == '*')	{														//	*
							SETFMTC(*p);
							p++;
							if (pCall->nArg >= ixArg) {
								if (!(GetSIntByNode(pW, ppAgv[ixArg], &len1, pCall))) {rc = FALSE; goto sspf_exit;}
								ixArg++;
							}
							else {
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
														LNGSEL("%s - %d番目の書式中、'*'に対応する引数がありません。",
															   "%s - No argument in %dth format."), pCall->pFunName, seq);
								rc = FALSE;
								goto sspf_exit;
							}
						}
						else if (_ismbcdigit(*p)) {												//	nnn
							while (_ismbcdigit(*p))	{
								SETFMTC(*p);
								p++;
							}
						}
						if (*p == '.') {														//	.
							SETFMTC(*p);
							p++;
							if (*p == '*')	{													//	*
								SETFMTC(*p);
								p++;
								if (pCall->nArg >= ixArg) {
									if (!(GetSIntByNode(pW, ppAgv[ixArg], &len1, pCall))) {rc = FALSE; goto sspf_exit;}
									ixArg++;
								}
								else {
									pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
															LNGSEL("%s - %d番目の書式中の'.*'に対応する引数がありません。",
																   "%s - No argument in %dth format."), pCall->pFunName, seq);
									rc = FALSE;
									goto sspf_exit;
								}
							}
							else {																//	nnn
								while (_ismbcdigit(*p))	{
									SETFMTC(*p);
									p++;
								}
							}
						}

						//	引数の精度	( l / ll )
						if (memcmp(p, "I64", 3) == 0) {
							p += 3;							//	'I64' は書式文字列に含めない
						}
						else {
							if (*p == 'l')	{p++;}			//	'l' / 'll' は書式文字列に含めない
							if (*p == 'l')	{p++;}			//	・
						}
						//	引数のタイプ( s / c / d / i / u / x / X / p / f / e / E / g / G)
						//	部分書式文字列作成
						typ = *p;
						if (typ == 'd' || typ == 'i' || typ == 'u' || typ == 'x' || typ == 'X' || typ == 'p') {
							SETFMTC('l');	//	整数の場合は、精度指定(ll)を付加
							SETFMTC('l');	//	・
							SETFMTC(*p);
						}
						else {
							SETFMTC(*p);
						}
						p++;
						//	書式文字列の終端(0x00)設定
						SETFMTC(0);
						//	部分書式による文字列生成
						//	・文字列
						if		(typ == 's' || typ == 'S') {
							if (pCall->nArg > ixArg) {
								if (!(u.pStr = GetStrByNode(pW, ppAgv[ixArg], pCall))) {rc = FALSE; goto sspf_exit;}
								ixArg++;
								if (len1 == -1 && len2 == -1) {			//	'*' なし
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, u.pStr);
								}
								else if (len2 == -1) {					//	'*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, u.pStr);
								}
								else {									//	'*.*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, (int)len2, u.pStr);
								}
								SETBUFS(wStr);	//	作成した部分文字列をバッファに設定
							}
							else {
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
														LNGSEL("%s - %d番目の書式に対応する引数がありません。",
															   "%s - No argument in %dth format."), pCall->pFunName, seq);
								rc = FALSE;
								goto sspf_exit;
							}
						}
						//	・文字
						else if (typ == 'c' || typ == 'C') {
							if (pCall->nArg > ixArg) {
								if (!(GetSIntByNode(pW, ppAgv[ixArg], &u.num, pCall))) {rc = FALSE; goto sspf_exit;}
								ixArg++;
								if (len1 == -1 && len2 == -1) {			//	'*' なし
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)u.num);
								}
								else if (len2 == -1) {					//	'*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, (int)u.num);
								}
								else {									//	'*.*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, (int)len2, (int)u.num);
								}
								SETBUFS(wStr);	//	作成した部分文字列をバッファに設定
							}
							else {
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
														LNGSEL("%s - %d番目の書式に対応する引数がありません。",
															   "%s - No argument in %dth format."), pCall->pFunName, seq);
								rc = FALSE;
								goto sspf_exit;
							}
						}
						//	・整数
						else if (typ == 'd' || typ == 'i' || typ == 'u' || typ == 'x' || typ == 'X') {
							if (pCall->nArg > ixArg) {
								if (!(GetSIntByNode(pW, ppAgv[ixArg], &u.num, pCall))) {rc = FALSE; goto sspf_exit;}
								ixArg++;
								if (len1 == -1 && len2 == -1) {			//	'*' なし
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, u.num);
								}
								else if (len2 == -1) {					//	'*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, u.num);
								}
								else {									//	'*.*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, (int)len2, u.num);
								}
								SETBUFS(wStr);	//	作成した部分文字列をバッファに設定
							}
							else {
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
														LNGSEL("%s - %d番目の書式に対応する引数がありません。",
															   "%s - No argument in %dth format."), pCall->pFunName, seq);
								rc = FALSE;
								goto sspf_exit;
							}
						}
						//	・実数
						else if (typ == 'f' || typ == 'e' || typ == 'E' || typ == 'g' || typ == 'G') {
							if (pCall->nArg > ixArg) {
								if (!(GetRealByNode(pW, ppAgv[ixArg], &u.dbl, pCall))) {rc = FALSE; goto sspf_exit;}
								ixArg++;
								if (len1 == -1 && len2 == -1) {			//	'*' なし
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, u.dbl);
								}
								else if (len2 == -1) {					//	'*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, u.dbl);
								}
								else {									//	'*.*' あり
									AjcSnPrintFA(wStr, sizeof wStr, wFmt, (int)len1, (int)len2, u.dbl);
								}
								SETBUFS(wStr);	//	作成した部分文字列をバッファに設定
							}
							else {
								pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_PARAM, pCall->lno,
														LNGSEL("%s - %d番目の書式に対応する引数がありません。",
															   "%s - No argument in %dth format."), pCall->pFunName, seq);
								rc = FALSE;
								goto sspf_exit;
							}
						}
						else {
							pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_SYNTAX, pCall->lno,
										  LNGSEL("%s - %d番目の書式(%s)に誤りがあります。",
												 "%s - Invalid format expression in %dth argument(%s)."), pCall->pFunName, seq, wFmt);
							rc = FALSE;
							goto sspf_exit;
						}
					}
				}
				else {	//	書式（%・・）以外？
					SETBUFC(*p);
					p++;
				}
			}
			//	生成文字列終端(0x00)設定
			SETBUFC(0);
			//	戻り値=正常
			rc = TRUE;
		} while(0);
sspf_exit:;
		//	引数情報解放
		if (ppAgv != NULL)	free(ppAgv);
	}
	else {
		Err_InvalidArguments(pW, pCall); // 引数の個数が不正です
		rc = FALSE;
	}
	return rc;
}
