﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ（汎用サブ関数）																		//
//																												//
//**************************************************************************************************************//
//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL - 成功（インスタンスハンドル）															//
//				＝NULL - 失敗																					//
//==============================================================================================================//
HAJCCIP		CipGsrCreate(VO)
{
	HAJCCIP	pW = NULL;

	if (pW = (HAJCCIP)AJCMEM(sizeof(AJCCIP))) {
		//	インスタンスワーククリアー
		memset(pW, 0, sizeof(AJCCIP));
		//	インスタンスＩＤ設定
		pW->id = AJCCIP_INSTID;
		//	オプション情報設定
		pW->fEnableOption = TRUE;
		pW->NumType = AJCIPT_INTEGER;
		pW->fSigned = TRUE;
		//	２分木生成
		pW->hAvlFun = AjcAvlCreate((UX)pW, cbAvlCompStr, cbAvlRemoveFunc);		//	ファンクション登録用２分木生成
		pW->hAvlStr = AjcAvlCreate((UX)pW, cbAvlCompStr, NULL			);		//	文字列蓄積用２分木生成
		//	静的変数管理情報生成
		pW->sFni[0].hVmg = AjcVmgCreateA();
		//	ステップトレース情報
		pW->pStepTkn		= NULL;				//	ステップトレース表示用トークンアドレス
		pW->SvStepLno		= -1;				//	ステップトレース表示用行番号退避
		pW->SvStepTkn		= EAJCTK_INVALID;	//	ステップトレース表示用トークンコード退避
		//	ステップトレース許可フラグロード
		pW->fStepTrace		= AjcGetProfileUIntA(CIP_STEP_SECT, "fStepTrace", TRUE);
		//	戻り値設定
		if (pW->hAvlFun == NULL  ||  pW->hAvlStr == NULL || pW->sFni[0].hVmg == NULL) {
			CipGsrDelete(pW);
			pW = NULL;
		}
	}
	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO			CipGsrDelete	(HAJCCIP pW)
{
	UI		i;

	if (pW != NULL && pW->id == AJCCIP_INSTID) {
		//	ステップトレース許可フラグセーブ
		AjcPutProfileUIntA(CIP_STEP_SECT, "fStepTrace", pW->fStepTrace);
		//	字句群解放
		if (pW->pTknTop != NULL) {free(pW->pTknTop); pW->pTknTop = NULL;}
		//	２分木解放
		if (pW->hAvlFun != NULL) AjcAvlDelete(pW->hAvlFun);		//	ファンクション
		if (pW->hAvlStr != NULL) AjcAvlDelete(pW->hAvlStr);		//	文字列
		//	変数管理情報解放
		for (i = 0; i < AJCCIPMAX_IXVMG; i++) {
			if (pW->sFni[i].hVmg != NULL) {
				AjcVmgDeleteA(pW->sFni[i].hVmg);
			}
		}
		//	ＴＭＣウインドクローズ
		if (pW->hWndTmcBack != NULL) {DestroyWindow(pW->hWndTmcBack); pW->hWndTmcBack = NULL;}
		//	バックウインドクローズ
		if (pW->hWndBack	!= NULL) {DestroyWindow(pW->hWndBack);	  pW->hWndBack	  = NULL;}
		//	インスタンスワーク解放
		free(pW);
	}
}

//==============================================================================================================//
//	実行通知																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pTkn		- トークンノードのアドレス															//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	CipGsrNtcExe(HAJCCIP pW, PAJCCIPTKN pTkn)
{
	AJCCIPEVPEXE	cbp;

	cbp.pTkn  = pTkn;
	cbp.fStop = FALSE;
	SendMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_EXE),
										 fCmdWithHdl ? (LPARAM)pW->hWndBack : (LPARAM)&cbp);
	pW->fRunStop |= cbp.fStop;
	CipGsrDoEvent(pW);
}
//==============================================================================================================//
//	エラーメッセージ通知																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				err			- エラーコード																		//
//				lno			- 行番号																			//
//				pFmt		- 書式文字列																		//
//																												//
//	戻り値	：	エラーコード																					//
//==============================================================================================================//
AJCCIP_ERR	CipGsrNtcErr(HAJCCIP pW, AJCCIP_ERR err, UI lno, C_BCP pFmt, ...)
{
	va_list 		vls;
	UI				stl;
	AJCCIPEVPERR	cbp;

	if (pW->ErrCod == AJCIP_ERR_OK) {
		//	ファイルパス名，行番号設定
		AjcSnPrintFA(pW->NtcTxt, sizeof pW->NtcTxt, "\"%s\"(%4d): ", pW->MacFile, lno);
		stl = (UI)strlen(pW->NtcTxt);
		//	メッセージ設定
		va_start(vls, pFmt);
		_vsnprintf(&pW->NtcTxt[stl], (sizeof pW->NtcTxt) - stl, pFmt, vls);
		va_end	(vls);
		pW->NtcTxt[(sizeof pW->NtcTxt) - 1] = 0;
		//	エラー通知
		cbp.err  = err;
		cbp.lno  = lno;
		cbp.pMsg = pW->NtcTxt;
		SendMessage(pW->hParent, WM_COMMAND, MAKELONG(pW->CtrlId, AJCCIPN_ERR),
											 fCmdWithHdl ? (LPARAM)pW->hWndBack : (LPARAM)&cbp);
	}
	return err;
}
//==============================================================================================================//
//	トークン文字列取得																							//
//																												//
//	引　数	：	pTkn	- トークンノードのアドレス																//
//																												//
//	戻り値	：	トークン文字列のアドレス																		//
//==============================================================================================================//
C_BCP	CipGsrTknStr(PCAJCCIPTKN pTkn)
{
	C_BCP	pSyl;
	static	BC txt[512];

	if (pTkn != NULL) {
		if (pTkn->tkn == EAJCTK_USR_NAME) {
			pSyl = pTkn->u.pStr;
		}
		else if (pTkn->tkn == EAJCTK_CIP_STRING) {
			if (pTkn->flgValue == AJCIP_VAL_APOST) {
				AjcSnPrintFA(txt, sizeof txt, "'%s'", pTkn->u.pStr);
			}
			else {
				int		ix	= 0;
				BCP		p	= pTkn->u.pStr;
				txt[ix++] = '"';
				while (*p != 0 && ix < sizeof txt - 6) {
					if (iscntrl((UB)*p)) {
						if		(*p == '\a') {memcpy(&txt[ix], "\\a", 2); p++; ix += 2;}
						else if (*p == '\b') {memcpy(&txt[ix], "\\b", 2); p++; ix += 2;}
						else if (*p == '\n') {memcpy(&txt[ix], "\\n", 2); p++; ix += 2;}
						else if (*p == '\r') {memcpy(&txt[ix], "\\r", 2); p++; ix += 2;}
						else if (*p == '\f') {memcpy(&txt[ix], "\\f", 2); p++; ix += 2;}
						else if (*p == '\t') {memcpy(&txt[ix], "\\t", 2); p++; ix += 2;}
						else {
							AjcSnPrintFA(&txt[ix], sizeof txt - ix, "\\%x02X", (UB)*p);
							p++; ix += 4;
						}
					}
					else {
						if		(*p == '\\') txt[ix++] = '\\';
						else if (*p == '\"') txt[ix++] = '\"';
						else				 txt[ix++] = *p;
						p++;
					}
				}
				if (ix >= sizeof txt - 2) ix = sizeof txt - 2;
				txt[ix++] = '"';
				txt[ix	] = 0;
			}
			pSyl = txt;
		}
		else if (pTkn->tkn == EAJCTK_CIP_INTEGER) {
			switch (pTkn->flgValue) {
				case AJCIP_VAL_DEC:		AjcSnPrintFA(txt, sizeof txt, "%lld"  , pTkn->u.val);	break;
				case AJCIP_VAL_HEX:		AjcSnPrintFA(txt, sizeof txt, "%llX"  , pTkn->u.val);	break;
				case AJCIP_VAL_OCT:		AjcSnPrintFA(txt, sizeof txt, "%lli"  , pTkn->u.val);	break;
				default:				AjcSnPrintFA(txt, sizeof txt, "(%lld)", pTkn->u.val);	break;
			}
			pSyl = txt;
		}
		else if (pTkn->tkn == EAJCTK_CIP_REAL) {
			AjcSnPrintFA(txt, sizeof txt, "%f", pTkn->u.dbl);
			pSyl = txt;
		}
		else if (pTkn->tkn == EAJCTK_CIP_FUNCTION) {
			pSyl = pTkn->u.pStr;
		}
		else if (pTkn->tkn == EAJCTK_EOF) {
			pSyl = "<EOF>";
		}
		else {
			if ((pSyl = AjcCtkGetTokenStringA(pTkn->tkn)) == NULL) {
				pSyl = "<???>";
			}
		}
	}
	else {
		pSyl = "<null>";
	}

	return pSyl;
}
//==============================================================================================================//
//	直前のトークン取得																							//
//																												//
//	引　数	：	pTkn	- トークンノードのアドレス																//
//																												//
//	戻り値	：	トークン文字列のアドレス																		//
//==============================================================================================================//
PCAJCCIPTKN	CipGsrGetBeforeToken(HAJCCIP pW, PCAJCCIPTKN pCur)
{
	PCAJCCIPTKN	pBfr = pW->pTknTop;

	if (pCur != NULL) {
		//	直前のトークン検索
		while (pBfr != NULL && (pBfr + 1) != pCur) {
			pBfr++;
		}
	}
	//	直前全のトークンが見つからない場合は（しょうがないので）現トークンを返す（内部エラー）
	if (pBfr == NULL) pCur;

	return pBfr;
}
//==============================================================================================================//
//	分岐先アドレス設定																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pJmp		- ジャンプ先トークンノードのアドレス												//
//																												//
//	戻り値	：	設定したジャンプ先アドレス																		//
//==============================================================================================================//
PCAJCCIPTKN	CipGsrSetJumpAddr(HAJCCIP pW, PAJCCIPTKN pJmp)
{
	//	ここまでのステップトレース出力
	CipStepShowToken(pW, pW->pCur);
	//	ジャンプ先アドレス設定
	pW->pStepTkn = pW->pCur = pJmp;

	return pJmp;
}
//==============================================================================================================//
//	ボタン，チェックボックス整列																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		CipGsrBtnAndChkBoxAlignment(HAJCCIP pW)
{
	RECT	r;
	int		ww;
	int		i, bw, bh, lh, stl;
	int		sx = 5;
	int		sy = 3;
	int		x  = sx;
	int		y  = sy;
	SIZE	szCur, szMax;
	HFONT	hFont, hSvFont;
	HDC		hdc;
	BC		txt[512];

	//	バックウインドの幅設定
	GetClientRect(pW->hWndBack, &r);
	ww = r.right - r.left;

	//	ボタン＋チェックボックスの高さ初期化
	pW->BtnChkHeight  = 0;

	//	ボタン配置（ボタンは全て同じサイズで配置）
	if (pW->mskBtnValid) {
		//	文字列最大サイズ設定
		szMax.cx = szMax.cy= 0;
		for (i = 0; i < MAX_BUTTON; i++) {
			if (pW->hButton[i] != NULL) {
				hdc = GetDC(pW->hButton[i]);
				hFont = (HFONT)SendMessage(pW->hButton[i], WM_GETFONT, 0, 0);
				hSvFont = (HFONT)SelectObject(hdc, hFont);
				GetWindowTextA(pW->hButton[i], txt, sizeof txt);
				txt[sizeof txt - 1] = 0;
				stl = (int)strlen(txt);
				GetTextExtentPoint32A(hdc, txt, stl, &szCur);
				szMax.cx = __max(szCur.cx, szMax.cx);
				szMax.cy = __max(szCur.cy, szMax.cy);
				SelectObject(hdc, hSvFont);
				ReleaseDC(pW->hButton[i], hdc);
			}
		}
		//	ボタンサイズ設定
		bw = szMax.cx + 10;
		bh = szMax.cy + 6;
		lh = bh + 1;
		//	ボタン＋チェックボックスの高さ更新
		pW->BtnChkHeight += lh;
		//	ボタン配置
		x = sx; y = sy;
		for (i = 0; i < MAX_BUTTON; i++) {
			if (pW->hButton[i] != NULL) {
				if (x + bw >= ww) {
					x  = sx;
					y += lh;
					pW->BtnChkHeight += lh;
				}
				MoveWindow(pW->hButton[i], x, y, bw, bh, TRUE);
				x += (bw + 5);
			}
		}
	}
	//	チェックボックス配置（チェックボックスは各々のサイズで配置）
	if (pW->mskChkValid) {
		for (i = 0; i < MAX_BUTTON; i++) {
			if (pW->hChkBox[i] != NULL) {
				//	文字列サイズ設定
				hdc = GetDC(pW->hChkBox[i]);
				hFont = (HFONT)SendMessage(pW->hChkBox[i], WM_GETFONT, 0, 0);
				hSvFont = (HFONT)SelectObject(hdc, hFont);
				GetWindowTextA(pW->hChkBox[i], txt, sizeof txt);
				txt[sizeof txt - 1] = 0;
				stl = (int)strlen(txt);
				GetTextExtentPoint32A(hdc, txt, stl, &szCur);
				SelectObject(hdc, hSvFont);
				ReleaseDC(pW->hChkBox[i], hdc);
				if (pW->BtnChkHeight == 0) {
					pW->BtnChkHeight = szCur.cy + 6;
				}
				//	チェックボックスサイズ設定
				bw = szCur.cx + 30;
				bh = szCur.cy + 6;
				lh = bh + 1;
				//	チェックボックスがウインドサイズを超える場合は、表示行数更新
				if (x + bw >= ww) {
					x  = sx;
					y += lh;
					pW->BtnChkHeight += lh;
				}
				//	チェックボックス配置
				MoveWindow(pW->hChkBox[i], x, y, bw, bh, TRUE);
				x += (bw + 5);
			}
		}
	}
	//	VT100ウインド配置
	CipGsrMoveVT100Window(pW);
	//	Windows Event
	CipGsrDoEvent(pW);
}
//==============================================================================================================//
//	ＶＴ１００ウインド配置																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		CipGsrMoveVT100Window(HAJCCIP pW)
{
	RECT	r;
	int		width, height;

	GetClientRect(pW->hWndBack, &r);
	width  = r.right - r.left;
	if (pW->BtnChkHeight == 0) {
		height = r.bottom - r.top;
		MoveWindow(pW->hWndVth, 0, 0				   , width, height, TRUE);
	}
	else {
		height = (r.bottom - r.top) - (pW->BtnChkHeight + 4);
		height = __max(height, 0);
		MoveWindow(pW->hWndVth, 0, pW->BtnChkHeight + 4, width, height, TRUE);
	}
}
//==============================================================================================================//
//	_OnChkBox()呼び出し																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				ChkBoxNo	- チェックボックス番号																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		CipGsrCall_OnChkBox(HAJCCIP pW, int ChkBoxNo)
{
	PAJCCIPCALL	pCall;
	BOOL		status;

	if (pW->hChkBox[ChkBoxNo]) {
		//	_OnChkBox()実行中の旨設定
		pW->fBusyOnChkBox = TRUE;

		if (pCall = AjcCipCallInfoInit(pW->hWndBack, "_OnChkBox")) {		//	呼び出し情報生成
			pCall->pReturn = pW->pCur;										//		戻りアドレス
			if (pW->NumType == AJCIPT_INTEGER) {							//		第１引数（ボタン番号）
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, ChkBoxNo);
			}
			else {
				AjcCipCallInfoInsReal	(pW->hWndBack, pCall, (double)ChkBoxNo);
			}

			status = AjcGetCtrlChk(pW->hChkBox[ChkBoxNo]);					//		第２引数（チェック状態）
			if (pW->NumType == AJCIPT_INTEGER) {
				AjcCipCallInfoInsInteger(pW->hWndBack, pCall, status);
			}
			else {
				AjcCipCallInfoInsReal	(pW->hWndBack, pCall, (double)status);
			}
			AjcFQueEnque(pW->hFQueStdEvt, (VOP)&pCall);						//		イベントをエンキュー
		}

		//	_OnChkBox()実行中を解除
		pW->fBusyOnChkBox = FALSE;
	}
}
//==============================================================================================================//
//	全タイマ停止																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		CipGsrStopAllTimer(HAJCCIP pW)
{
	UI		i, msk;

	//	タイマ停止
	for (i = 1, msk = 0x01; i < 31; i++, msk <<= 1) {
		if (pW->mskExeTimEvt && msk) {
			KillTimer(pW->hWndBack, i);
		}
	}
	//	有効タイマフラグクリアー
	pW->mskExeTimEvt = 0;
	//	タイマイベント発生フラグクリアー
	memset(pW->fExeTimer, 0, sizeof pW->fExeTimer);
}
//==============================================================================================================//
//	変数情報のＶＭＧインスタンス取得																			//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pSym		- 変数名																			//
//																												//
//	戻り値	：	≠NULL:正常（変数管理インスタンス）																//
//				＝NULL:エラー																					//
//==============================================================================================================//
HAJCVMGA	CipGsrGetVarInst(HAJCCIP pW, C_BCP pVarName)
{
	HAJCVMGA		rc	  = NULL;
	PCAJCVMGNODE	pNode = NULL;

	do {
		//	自動変数インスタンス取得
		if (pW->ixFni != 0) {
			if (pW->sFni[pW->ixFni].hVmg != NULL && AjcVmgGetNodeA(pW->sFni[pW->ixFni].hVmg, pVarName) != NULL) {
				rc = pW->sFni[pW->ixFni].hVmg;
				break;
			}
		}
		//	静的変数インスタンス取得
		if (pW->sFni[0].hVmg != NULL && AjcVmgGetNodeA(pW->sFni[0].hVmg, pVarName) != NULL) {
			rc = pW->sFni[0].hVmg;
		}
	} while(0);

	return rc;
}
//==============================================================================================================//
//	変数の値表示（トレースウインド／ステップトレースウインド用）												//
//																												//
//	引　数	：	hVth		- VT100ハンドル																		//
//				pAnl		- 変数解析結果情報																	//
//				pNode		- ＶＭＧインスタンスノードポインタ													//
//				aix			- 表示項目インデクス																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
static	VO	SubGsrShowVariableItem(HAJCCIP pW, HWND hVth, PAJCCIPTRCVAR pAnl, PCAJCVMGNODEA pNode, UI aix)
{
	UI	ix;
	BC	txt[1024];

	//	項目名設定
	if (pAnl->fVarExp == VAREXP_ARRIDX) AjcSnPrintFA(txt, sizeof txt, "  %s[%d] : ", pAnl->pVarName, aix);	//	配列インデクス指定
	else if (pNode->num >= 2)			AjcSnPrintFA(txt, sizeof txt, "  %s[%d] : ", pAnl->pVarName, aix);	//	配列要素数 ≧ ２
	else								AjcSnPrintFA(txt, sizeof txt, "  %s : "		, pAnl->pVarName);		//	単純変数

	//	変数値テキスト設定
	ix = (UI)strlen(txt);
	if (pAnl->ixArr < pNode->num) {
		switch (pNode->type) {
			case AJCVMGT_LONG:
				if (pW->fSigned) AjcSnPrintFA(&txt[ix], sizeof txt - ix, "%lld\n", pNode->arr.pSLL[aix]);
				else			 AjcSnPrintFA(&txt[ix], sizeof txt - ix, "%llu\n", pNode->arr.pSLL[aix]);
				break;

			case AJCVMGT_REAL:
				AjcSnPrintFA(&txt[ix], sizeof txt - ix, "%f\n"	, pNode->arr.pDBL[aix]);
				break;

			case AJCVMGT_STR:
				AjcSnPrintFA(&txt[ix], sizeof txt - ix, "\"%s\"\n", pNode->arr.pStr[aix]);
				break;

			default:
				AjcSnPrintFA(&txt[ix], sizeof txt - ix, "*** Invalid type\n");
				break;
		}
	}
	else AjcSnPrintFA(&txt[ix], sizeof txt - ix, "*** Index too large\n");

	AjcVthPutTextA(hVth, txt, -1);
}
//--------------------------------------------------------------------------------------------------------------//
VO		CipGsrShowVariableValue(HAJCCIP pW, HWND hVth, BCP pTxt, UI nMaxArr)
{
	BCP				pVarExp	= pTxt;			//	変数表現（'，'で区切られた項目テキスト）
	HAJCVMGA		hVmg  = NULL;			//	VMGハンドル
	PCAJCVMGNODEA	pNode = NULL;			//	変数情報ノード
	AJCCIPTRCVAR	va;						//	変数解析情報

	if (pVarExp = mbstok(pTxt, ",")) {
		do {
			AjcStrTrimA(pVarExp, pVarExp, (UI)strlen(pVarExp) + 1);
			//	空文字列は除外
			if (*pVarExp != 0) {
				//	変数名解析
				if (CipGsrAnalVarName(pW, pVarExp, &va)) {
					//	ＶＭＧインスタンス取得
					if ((hVmg = (HAJCVMGA)CipGsrGetVarInst(pW, va.pVarName)) && (pNode = AjcVmgGetNodeA(hVmg, va.pVarName))) {
						//	変数値表示
						if (va.fVarExp == VAREXP_ARRIDX) {
							SubGsrShowVariableItem(pW, hVth, &va, pNode, va.ixArr);
						}
						else {
							UI		ix;
							for (ix = 0; ix < nMaxArr && ix < pNode->num; ix++) {
								SubGsrShowVariableItem(pW, hVth, &va, pNode, ix);
							}
						}
					}
					else AjcVthPrintFA(hVth, "  %s : Not found\n", va.pVarName);
				}
				else  AjcVthPrintFA(hVth, "  %s : Invalid variable expression\n", pVarExp);
			}
		} while (pVarExp = mbstok(NULL, ","));
	}


}
//==============================================================================================================//
//	変数名の解析																								//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pVar		- 変数名('VarName' / 'VarName[]' / 'VarName[n]')									//
//				pBuf		- 変数の解析結果を格納するバッファのアドレス										//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
typedef struct {
	UI		ix;
	UI		stl;
	C_BCP	pLine;
} CGAVN_CBP, *PGAVN_CBP;
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK Cgavn_cbReadLine(BCP pBuf, UI lBuf, UX cbp)
{
	BOOL		rc;
	PGAVN_CBP	pCbp = (PGAVN_CBP)cbp;
	UI			len;

	if (pCbp->ix < pCbp->stl) {
		len = __min(pCbp->stl, lBuf - 1);
		memcpy(pBuf, &pCbp->pLine[pCbp->ix], len);
		pBuf[len] = 0;
		pCbp->ix += len;
		rc		  = TRUE;
	}
	else {
		rc		  = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
BOOL		CipGsrAnalVarName(HAJCCIP pW, C_BCP pVar, PAJCCIPTRCVAR pBuf)
{
	BOOL		rc		= FALSE;
	HAJCTK		hCtk	= NULL;
	EAJCTKCODE	tkn;
	BOOL		fArr;
	CGAVN_CBP	cbp;
	BC			sdlm[512];
	BC			sidx[512];
	BC			name[512];

	cbp.ix		= 0;
	cbp.stl		= (UI)strlen(pVar);;
	cbp.pLine	= pVar;

	if (hCtk = AjcCtkCreateA(AJCTKFLG_INCSYM_DOLLAR | AJCTKFLG_INCSYM_MBSTR | AJCTKFLG_APOST_NOESC, Cgavn_cbReadLine, (UX)&cbp)) {
		do {
			//	変数名解析
			if (AjcCtkGetTokenA(hCtk, name, sizeof name) == 0) break;
			if (AJCTK_ERROR(hCtk) != AJCTKERR_OK) break;
			tkn = AJCTK_TOKEN(hCtk);
			if (!AJCTKIS_SYMBOL(tkn)) break;
			//	変数名設定
			if (pBuf->pVarName = (BCP)AjcAvlInsOrGetStrNodeA(pW->hAvlStr, name)) {
				//	次がＥＯＬならば単純変数（'VarName'）
				if (AjcCtkGetTokenA(hCtk, sdlm, sizeof sdlm) == 0) {
					pBuf->ixArr   = 0;
					pBuf->fVarExp = VAREXP_NORMAL;
				}
				//	次がＥＯＬ以外ならば、配列変数チェック
				else {
					fArr = TRUE;
					//	'[' チェック
					if (AJCTK_ERROR(hCtk) != AJCTKERR_OK) break;
					tkn = AJCTK_TOKEN(hCtk);
					if (tkn != EAJCTK_DLM_LLPART) break;
					//	']' チェック
					if (AjcCtkGetTokenA(hCtk, sidx, sizeof sidx) == 0) break;
					if (AJCTK_ERROR(hCtk) != AJCTKERR_OK) break;
					tkn = AJCTK_TOKEN(hCtk);
					//	']' ならば、明示的インデクス指定なし（'VarName[]'）
					if (tkn == EAJCTK_DLM_RLPART) {
						pBuf->ixArr   = 0;
						pBuf->fVarExp = VAREXP_ARRALL;
					}
					//	'n' ならば、明示的インデクスを指定した配列
					else if (AJCTKIS_VALUE(tkn)) {
						//	'n' の値設定
						if (tkn == EAJCTK_VAL_OCTAL) pBuf->ixArr = AjcOctToUIA (sidx);
						else						 pBuf->ixArr = AjcAscToIntA(sidx);
						//	種別設定
						pBuf->fVarExp = VAREXP_ARRIDX;
						//	']' チェック
						if (AjcCtkGetTokenA(hCtk, sdlm, sizeof sdlm) == 0) break;
						if (AJCTK_ERROR(hCtk) != AJCTKERR_OK) break;
						tkn = AJCTK_TOKEN(hCtk);
						if (tkn != EAJCTK_DLM_RLPART) break;
					}
					//	']' , 'n' 以外ならばエラー
					else break;
					//	EOL チェック
					if (AjcCtkGetTokenA(hCtk, sdlm, sizeof sdlm) != 0) break;
				}
			}
			//	戻り値（正常）
			rc = TRUE;
		} while(0);
		AjcCtkDelete(hCtk);
	}
	return rc;
}

//==============================================================================================================//
//	メッセージダイアログ表示（ＯＫボタン）																		//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				hOwner		- オーナーウインドハンドル															//
//				pMsg		- メッセージテキスト																//
//				pTtl		- タイトルテキスト																	//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJC_DLGPROC_DEF(MsgBox);
//--------------------------------------------------------------------------------------------------------------//
VO		CipGerMessageBoxOK(HAJCCIP pW, HWND hOwner, C_BCP pMsg, C_BCP pTtl)
{
	pW->hMbxhOwner	= hOwner;
	pW->pMbxMsg		= pMsg;
	pW->pMbxTtl		= pTtl;
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_CIPMSGBOX), hOwner, AJC_DLGPROC_NAME(MsgBox), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//	メッセージボックス ダイアログプロシージャ																	//
//--------------------------------------------------------------------------------------------------------------//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(MsgBox, WM_INITDIALOG 	)
{
	HAJCCIP pW = (HAJCCIP)lParam;
	HDC		hdc;
	HFONT	hFont, hSvFont;
	RECT	r;
	int		i, six, eix, ww, wh, cw, ch, bw, bh;
	SIZE	sz, szMax;

	//	アイコン設定
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	//	日英テキスト
	SetDlgItemText(hDlg, IDOK		 , LNGSEL(L"ＯＫ"	   , L"OK"			));

	//	テキストサイズ算出
	hdc = GetDC(GetDlgItem(hDlg, IDC_LBL_MSG));
	hFont = (HFONT)SendMessage(GetDlgItem(hDlg, IDC_LBL_MSG), WM_GETFONT, 0, 0);
	hSvFont = (HFONT)SelectObject(hdc, hFont);
	i = 1;
	six = eix = 0;
	szMax.cx = szMax.cy = 0;
	while (1) {
		if (pW->pMbxMsg[eix] == '\n' || pW->pMbxMsg[eix] == 0) {
			//	最大テキスト表示幅更新
			GetTextExtentPoint32A(hdc, &pW->pMbxMsg[six], eix - six, &sz);
			szMax.cx = __max(sz.cx, szMax.cx);
			szMax.cy = __max(sz.cy, szMax.cy);
			if (pW->pMbxMsg[eix] == '\n') {		//	'\n'？
				six = (++eix);					//		インデクス再設定（'\n'スキップ）
				i++;							//		行数更新
			}
			else break;
		}
		eix++;
	}
	SelectObject(hdc, hSvFont);
	ReleaseDC(pW->hButton[i], hdc);
	//	テキストサイズ設定
	sz.cx = __max(szMax.cx, 100);
	sz.cy = szMax.cy * i;

	//	ウインドサイズ設定
	ww = sz.cx + 40;
	wh = sz.cy + 80;
	SetWindowPos(hDlg, NULL, 0, 0, ww, wh, SWP_NOMOVE);
	//	クライアントサイズ設定
	GetClientRect(hDlg, &r);
	cw = r.right - r.left;
	ch = r.bottom - r.top;
	//	テキスト移動
	MoveWindow(GetDlgItem(hDlg, IDC_LBL_MSG), (cw - sz.cx) / 2, 10, sz.cx, sz.cy, FALSE);
	//	ＯＫボタン移動
	GetWindowRect(GetDlgItem(hDlg, IDOK), &r);
	bw = r.right - r.left;
	bh = r.bottom - r.top;
	SetWindowPos(GetDlgItem(hDlg, IDOK), NULL, (cw - bw) / 2, sz.cy + 20, 0, 0, SWP_NOSIZE);

	//	メッセージボックス・テキスト設定
	SetWindowTextA	 (hDlg, pW->pMbxTtl);
	AjcSetDlgItemStrA(hDlg, IDC_LBL_MSG, pW->pMbxMsg);
	//	オーナーウインドのセンタへ移動
	AjcMoveWindowToCenterOfWindow(hDlg, pW->hMbxhOwner);

	return TRUE;
}
//----- ＯＫ ---------------------------------------------------------------------------------------------------//
AJC_DLGPROC(MsgBox, IDOK				)
{
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(MsgBox, IDCANCEL			)
{
	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(MsgBox)
	AJC_DLGMAP_MSG(MsgBox, WM_INITDIALOG   )
	AJC_DLGMAP_CMD(MsgBox, IDOK		 	   )
	AJC_DLGMAP_CMD(MsgBox, IDCANCEL		   )
AJC_DLGMAP_END

//==============================================================================================================//
//	Windowメッセージ処理																						//
//																												//
//	引　数	：	pW			- インスタンスワーク																//
//				pSym		- 変数名																			//
//																												//
//	戻り値	：	≠NULL:正常（変数管理インスタンス）																//
//				＝NULL:エラー																					//
//==============================================================================================================//
VO		CipGsrDoEvent(HAJCCIP pW)
{
	AjcDoEventExA(2, pW->hTrcDlg, pW->hStepDlg);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//==============================================================================================================//
//	２分木用文字列キー比較																						//
//																												//
//	引　数	：	key1, key2 - 比較する２つのノードのキー（文字列のアドレス）										//
//																												//
//	戻り値	：	> 0 - key1 > key2																				//
//				= 0 - key1 = key2																				//
//				< 0 - key1 < key2																				//
//==============================================================================================================//
int CALLBACK cbAvlCompStr(UX key1, UX key2, UX cbp)
{
	return mbscmp((C_BCP)key1, (C_BCP)key2);
}
//==============================================================================================================//
//	ファンクション登録用２分木ノード削除																		//
//																												//
//	引　数	：	key			- 削除するノードのキー																//
//				pNodeData	- 削除するノードのデータアドレス													//
//				len			- 削除するノードのデータバイト数													//
//				nest		- ルートノードからの高さ（１～）													//
//				cbp			- コールバックパラメタ																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO CALLBACK cbAvlRemoveFunc(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	PAJCCIPFUNC	pNode = (PAJCCIPFUNC)pNodeData;

	if (pNode->hQueArg != NULL) {
		AjcFQueDelete(pNode->hQueArg);
		pNode->hQueArg = NULL;
	}
}
