﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ（ステップトレース）																	//
//																												//
//**************************************************************************************************************//

#define		MYSECT		CIP_STEP_SECT

#define		MAX_TXTLEN	512

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	ATOM	ClassStepStepBack = 0;
static	HICON	hIcoRun		= NULL;
static	HICON	hIcoPause	= NULL;
static	HICON	hIcoEnd		= NULL;
static	HICON	hIcoStep	= NULL;

static	BC		AppNameA[MAX_PATH];

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(StepBack);
AJC_DLGPROC_DEF(StepDlg);

static	BOOL	ChkBreakLno(HAJCCIP pW);
static	VO		ShowByExecState(HAJCCIP pW);
static	VO		ShowOnExec(HAJCCIP pW);
static	VO		ShowOnPause(HAJCCIP pW);
static	VO		ShowNotExec(HAJCCIP pW);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipStepInit(VO)
{
	BOOL		rc = TRUE;
	WNDCLASSA	wndclass;

	//	トレース用バックウインドクラス生成
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(StepBack);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= (sizeof(UX));
	wndclass.hInstance		= hDllInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= hBruBtnFace;
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= "CAjaMacroStepTrace";
	ClassStepStepBack = RegisterClassA(&wndclass);
	if (ClassStepStepBack == 0) {
		rc = FALSE;
	}

	//	アイコンロード
	hIcoRun   = (HICON)LoadImageA(hDllInst, MAKEINTRESOURCEA(IDI_CIP_RUN	), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	hIcoPause = (HICON)LoadImageA(hDllInst, MAKEINTRESOURCEA(IDI_CIP_PAUSE	), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	hIcoEnd   = (HICON)LoadImageA(hDllInst, MAKEINTRESOURCEA(IDI_CIP_END	), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	hIcoStep  = (HICON)LoadImageA(hDllInst, MAKEINTRESOURCEA(IDI_CIP_STEP	), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);

	//	アプリケーション名（バイト文字）
	WideCharToMultiByte(CP_ACP, 0, AppName, -1, AppNameA, AJCTSIZE(AppNameA), NULL, NULL);

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		CipStepEnd(VO)
{
	//	トレース用バックウインドクラス破棄
	if (ClassStepStepBack != 0) {
		UnregisterClassA((BCP)ClassStepStepBack, hDllInst);
		ClassStepStepBack = 0;
	}
	//	ビットマップ破棄
	if (hIcoRun   != NULL) {DeleteObject(hIcoRun  ); hIcoRun   = NULL;}
	if (hIcoPause != NULL) {DeleteObject(hIcoPause); hIcoPause = NULL;}
	if (hIcoEnd   != NULL) {DeleteObject(hIcoEnd  ); hIcoEnd   = NULL;}
	if (hIcoStep  != NULL) {DeleteObject(hIcoStep ); hIcoStep  = NULL;}
}
//==============================================================================================================//
//	ステップトレースの表示許可／禁止																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fEnable		- TRUE	- ステップトレースの表示を許可												//
//							  FALSE - ステップトレースの表示を禁止												//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO			CipStepEnable(HAJCCIP pW, BOOL fEnable)
{
	pW->fStepTrace = (fEnable != 0);

	if (pW->hStepBack != NULL) {
		AjcSetDlgItemChk(pW->hStepDlg, IDC_CHK_ENASTEP, pW->fStepTrace);
		CipGsrDoEvent(pW);
	}
}
//==============================================================================================================//
//	ステップトレース ダイナミックステップ番号表示																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pNxt		- 表示終了トークンアドレス（このトークンの直前まで表示）							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO			CipStepDynNo(HAJCCIP pW)
{
	do {
		if (pW->hStepBack == NULL	)	break;		//	ステップトレースウインド無し
		if (!pW->fStepTrace			)	break;		//	ステップトレース禁止

		//	ダイナミックステップ番号表示
		AjcVthPrintFA(pW->hStepVth, "\n\x1b[34m\x1B[46mStep: %-80d\x1B[0m", pW->ExeStepNo);
	} while(0);

	//	Windows Event
	CipGsrDoEvent(pW);
}
//==============================================================================================================//
//	ステップトレース トークン表示																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pNxt		- 表示終了トークンアドレス（このトークンの直前まで表示）							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO			CipStepShowToken(HAJCCIP pW, PAJCCIPTKN pNxt)
{
	UI			SvLno = -1;
	PAJCCIPTKN	pTkn;

	do {
		if (pW->hStepBack == NULL		)	break;		//	ステップトレースウインド無し
		if (!pW->fStepTrace				)	break;		//	ステップトレース禁止
		if (pW->pStepTkn == NULL		)	break;		//	トークンアドレス未設定
		if ((UX)pW->pStepTkn > (UX)pNxt	)	break;		//	開始位置 ＞ 終了位置

		//	Windows Event
		CipGsrDoEvent(pW);
		//	関数ネストレベルが増加したら、関数呼び出し情報表示
		if		(pW->SvStepNest < pW->ixFni) {
			PAJCCIPAGV	pNode;
			AjcVthPrintFA(pW->hStepVth, "\n\x1B[31m");
			AjcVthPrintFA(pW->hStepVth, "[%d: function  %s(", pW->ixFni, pW->sFni[pW->ixFni].CInf.pFunName);
			if (pNode = (PAJCCIPAGV)AjcFQueTopNode(pW->sFni[pW->ixFni].CInf.hQueAgv)) {
				do {
					if (pNode->seq != 0) AjcVthPrintFA(pW->hStepVth, ", ");
					if (pNode->fArr) {
						switch (pNode->typ) {
							case AJCIPT_INTEGER:
							{	SLL		v = 0;
								AjcVmgGetInt64A(pNode->val.arr.hVmg,  pNode->val.arr.pName, 0, &v);
								if (pW->fSigned)	AjcVthPrintFA(pW->hStepVth, "{%lld ...}"  , v);
								else				AjcVthPrintFA(pW->hStepVth, "{%llu ...}"  , v);
								break;
							}
							case AJCIPT_REAL:
							{	double v = 0.0;
								AjcVmgGetRealA(pNode->val.arr.hVmg,  pNode->val.arr.pName, 0, &v);
								AjcVthPrintFA(pW->hStepVth, "{%f ...}", v);
								break;
							}
							case AJCIPT_STRING:
							{	C_BCP		p = AjcVmgGetStringA(pNode->val.arr.hVmg,  pNode->val.arr.pName, 0);
								AjcVthPrintFA(pW->hStepVth, "{\"%s\" ...}", p != NULL ? p : "???");
								break;
							}
							default:
								AjcVthPrintFA(pW->hStepVth, "{??? ...}");
								break;
						}
					}
					else {
						switch (pNode->typ) {
							case AJCIPT_INTEGER:
								if (pW->fSigned)	AjcVthPrintFA(pW->hStepVth, "%lld"  , pNode->val.sll);
								else				AjcVthPrintFA(pW->hStepVth, "%llu"  , pNode->val.sll);
								break;
							case AJCIPT_REAL:		AjcVthPrintFA(pW->hStepVth, "%f"    , pNode->val.dbl);	break;
							case AJCIPT_STRING:		AjcVthPrintFA(pW->hStepVth, "\"%s\"", pNode->val.pStr);	break;
							default:				AjcVthPrintFA(pW->hStepVth, "???");						break;
						}
					}
				} while (pNode = (PAJCCIPAGV)AjcFQueNextNode(pW->sFni[pW->ixFni].CInf.hQueAgv, pNode));
			}
			AjcVthPrintFA(pW->hStepVth, ")]\x1B[0m");
			pW->SvStepNest = pW->ixFni;
			pW->SvStepLno  = -1;
			pW->SvStepTkn  = EAJCTK_INVALID;
		}
		//	関数ネストレベルが減少したら、関数名，戻り値表示
		else if (pW->SvStepNest > pW->ixFni) {
			AjcVthPrintFA(pW->hStepVth, "\n\x1B[31m");
			AjcVthPrintFA(pW->hStepVth, "[%d: return to %s()", pW->ixFni, pW->sFni[pW->ixFni].CInf.pFunName);
			if (pW->sFni[pW->SvStepNest].CInf.rchVmg != NULL) {
				PAJCCIPCALL   pCInf = &pW->sFni[pW->SvStepNest].CInf;
				PCAJCVMGNODEA pNode = AjcVmgGetNodeA(pCInf->rchVmg, pCInf->rcpSym);
				switch (pNode->type) {
					case AJCIPT_INTEGER:
						if (pW->fSigned)	AjcVthPrintFA(pW->hStepVth, ", value = %lld "	, pNode->arr.pSLL[pCInf->rcIx]);
						else				AjcVthPrintFA(pW->hStepVth, ", value = %llu "	, pNode->arr.pSLL[pCInf->rcIx]);
						break;
					case AJCIPT_REAL:		AjcVthPrintFA(pW->hStepVth, ", value = %f "		, pNode->arr.pDBL[pCInf->rcIx]); break;
					case AJCIPT_STRING:		AjcVthPrintFA(pW->hStepVth, ", value = \"%s\" "	, pNode->arr.pStr[pCInf->rcIx]); break;
				}
			}
			AjcVthPrintFA(pW->hStepVth, "]\x1B[0m");
			pW->SvStepNest = pW->ixFni;
			pW->SvStepLno  = -1;
			pW->SvStepTkn  = EAJCTK_INVALID;
		}
		//	pNxtの直前までのトークン表示
		pTkn = pW->pStepTkn;
		while (pTkn != pNxt && pTkn != NULL) {
			//	行番号が変化したら、行番号表示
			if (pW->SvStepLno != pTkn->lno) {
				AjcVthSetColor(pW->hStepVth, 0);
				AjcVthPrintFA(pW->hStepVth, "\n%5u: %*c", pTkn->lno, pW->ixFni * 4, ' ');
				pW->SvStepLno  = pTkn->lno;
				pW->SvStepTkn  = EAJCTK_INVALID;
			}
			//	空白挿入
			if (pW->SvStepTkn != EAJCTK_INVALID) {
				if (AJCTKIS_VALSYM(pW->SvStepTkn) && (AJCTKIS_VALSYM(pTkn->tkn))) {
					AjcVthPrintFA(pW->hStepVth, " ");
				}
			}
			//	トークン表示
			AjcVthPrintFA(pW->hStepVth, "%s", CipGsrTknStr(pTkn));
			//	Windows Event
			CipGsrDoEvent(pW);
			//	トークンコード退避
			pW->SvStepTkn = pTkn->tkn;
			//	次のトークンアドレス設定
			pTkn++;
		}
		//	トークンアドレス退避
		pW->pStepTkn = pTkn;
	} while (0);

	//	Windows Event
	CipGsrDoEvent(pW);
}
//==============================================================================================================//
//	ステップトレース 変数値表示																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO			CipStepShowVariable	(HAJCCIP pW)
{
	HAJCVMGA		hVmg  = NULL;			//	VMGハンドル
	PCAJCVMGNODEA	pNode = NULL;			//	変数情報ノード
	UI				nMaxArr;				//	配列の最大表示個数
	BC				DlgTxt[MAX_TXTLEN];		//	変数名群（ダイアログ指定値）

	do {
		if (pW->hStepBack == NULL		)	break;		//	ステップトレースウインド無し
		if (!pW->fStepTrace				)	break;		//	ステップトレース禁止

		//	文字色設定
		AjcVthPutTextA(pW->hStepVth, "\x1B[34m", -1);
		//	ダイアログ設定内容取得
		nMaxArr = AjcGetDlgItemUInt(pW->hStepDlg, IDC_TXT_ARRMAX);
		AjcGetDlgItemStrA(pW->hStepDlg, IDC_TXT_CHASE, DlgTxt, MAX_TXTLEN);
		AjcStrTrimA(DlgTxt, DlgTxt, MAX_TXTLEN);
		//	変数群表示
		AjcVthPutTextA(pW->hStepVth, "\n", -1);
		CipGsrShowVariableValue(pW, pW->hStepVth, DlgTxt, nMaxArr);
		//	文字色解除
		AjcVthPutTextA(pW->hStepVth, "\x1B[0m", -1);
		//	Windows Event
		CipGsrDoEvent(pW);
	} while(0);
}
//==============================================================================================================//
//	実行開始/中断/停止通知																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fForced		- 強制中断フラグ																	//
//																												//
//	戻り値	：	TRUE  - ステップトレースウインド オープン中														//
//				FALSE - ステップトレースウインド クローズ中														//
//==============================================================================================================//
VO		CipStepNtcExec(HAJCCIP pW, BOOL fForced)
{
	//	ステップトレースウインド オープン中
	if (pW->hStepBack != NULL) {
		//	中断フラグ設定
		if (pW->fExec && (fForced || ChkBreakLno(pW))) {	//	実行中 ＆ 強制中断／ブレーク行？
			pW->fStepPause = TRUE;							//		中断フラグ設定
		}

		//	実行状態による表示切替
		ShowByExecState(pW);

		//	中断状態ならば、処理停止
		if (pW->fStepPause) {
			AjcVthPrintFA(pW->hStepVth, "\n\x1B[31m");
			AjcVthPrintFA(pW->hStepVth, "+ PAUSE / BREAK, Line = %d\n", pW->pCur->lno);
			AjcVthPrintFA(pW->hStepVth, "\n\x1B[0m");
			while (pW->fStepPause && !pW->fRunStop) {
				Sleep(1);
				CipGsrDoEvent(pW);
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ブレーク行チェック																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL		ChkBreakLno(HAJCCIP pW)
{
	BOOL	rc = FALSE;
	UI		lno;
	BCP		p;
	BC		txt[MAX_TXTLEN];

	if (pW->SvBrkLno != pW->pCur->lno) {								//	前回と異なる行番号？
		pW->SvBrkLno  = pW->pCur->lno;									//		行番号退避
		if (AjcGetDlgItemChk(pW->hStepDlg, IDC_CHK_SETBRK)) {			//		ブレークポイント設定有効？
			AjcGetDlgItemStrA(pW->hStepDlg, IDC_TXT_BRKLNO,				//			ダイアログから設定行番号群テキスト取得
												txt, MAX_TXTLEN);		//			・
			//	行番号チェック
			p = txt;
			while (*p != 0) {											//			テキスト終端までループ
				while (MAjcIsBlankA(*p)) p++;							//				空白スキップ
				if (_ismbcdigit(*p)) {									//				数字？
					lno = atoi(p);										//					指定行番号設定
					if (lno == pW->pCur->lno) {							//					現在の行番号と一致？
						rc = TRUE;										//						戻り値設定
						break;											//						→終了
					}
					else {												//					現在の行番号と不一致？
						while (*p != ',' && *p != 0) p++;				//						カンマの次までスキップ
						if (*p == ',') p++;								//						・
					}
				}
				else {													//				数字以外？
					while (*p != ',' && *p != 0) p++;					//					カンマの次までスキップ
					if (*p == ',') p++;									//					・
				}
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	実行中状態による表示切替																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowByExecState(HAJCCIP pW)
{
	if (pW->hStepBack != NULL) {
		if (pW->fStepSvExec != pW->fExec || pW->fStepSvPause != pW->fStepPause) {
			//	実行中
			if (pW->fExec) {							//	マクロ実行中？
				if (pW->fStepPause) {					//		中断状態？
					ShowOnPause(pW);					//			一時停止中の表示
				}
				else {									//		実行中？
					ShowOnExec(pW);						//			実行中の表示
				}
			}
			//	実行停止
			else {										//	マクロ非実行中？
				ShowNotExec(pW);						//		非実行中の表示
			}
			pW->fStepSvExec  = pW->fExec;
			pW->fStepSvPause = pW->fStepPause;
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	実行中の表示																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnExec(HAJCCIP pW)
{
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_CHASE, FALSE, FALSE);
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_BREAK, FALSE, FALSE);
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_BTN  , TRUE , FALSE);
	AjcEnableDlgItem (pW->hStepDlg, IDC_CMD_PAUSE, TRUE);
	AjcEnableDlgItem (pW->hStepDlg, IDC_CMD_STOP , TRUE);
	AjcVthSetTitleTextA(pW->hStepVth, LNGSEL(" 実行中 ", " Running "), -1, -1, NULL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	一時停止中の表示																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnPause(HAJCCIP pW)
{
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_CHASE, TRUE , TRUE );
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_BREAK, TRUE , TRUE );
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_BTN  , TRUE , TRUE );
	AjcEnableDlgItem (pW->hStepDlg, IDC_CMD_PAUSE, FALSE);
	AjcVthSetTitleTextA(pW->hStepVth, LNGSEL(" 一時停止中 ", " Pause "), -1, -1, NULL);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	停止中の表示																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowNotExec(HAJCCIP pW)
{
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_CHASE, TRUE , TRUE );
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_BREAK, TRUE , TRUE );
	AjcEnableDlgGroup(pW->hStepDlg, IDC_GRP_BTN  , FALSE, FALSE);
	AjcVthSetTitleTextA(pW->hStepVth, LNGSEL(" 停止中 ", " Stopped "), -1, -1, NULL);
}
//==============================================================================================================//
//	ステップトレースウインド生成																				//
//																												//
//	引　数	：	pCall		- 関数呼び出し情報																	//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - エラー																					//
//==============================================================================================================//
#define		IDC_VTH_STEP			5010				//	ＶＴＨコントロールＩＤ
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipStepCreateWindow(HAJCCIP pW)
{
	BOOL		rc = TRUE;

	do {

		//	トレース用バックウインド生成
		if (pW->hStepBack == NULL) {
			//	マクロ実行中はウインドオープンできない
			if (pW->fExec) {
				if (!pW->fStepMsgBoxBusy) {
					 pW->fStepMsgBoxBusy = TRUE;
					 AjcBell();
					 CipGerMessageBoxOK(pW, pW->hWndVth,
									LNGSEL("マクロ実行中は、ステップトレースウインドをオープンできません。",
									"Can not be opened 'StepTraceWindow' during macro-execution."), AppNameA);
					 pW->fStepMsgBoxBusy = FALSE;
					 break;
				}
			}
			//	ウインド生成
			pW->hStepBack = CreateWindowA("CAjaMacroStepTrace",								// window class name
										 LNGSEL("ステップトレース", "Step trace window"),	// window caption
										 WS_OVERLAPPEDWINDOW,								// window style
										 0,													// initial x position
										 0,													// initial y position
										 500,												// initial x size
										 300,												// initial y size
										 NULL,												// parent window handle
										 NULL,												// window menu handle
										 hDllInst,											// program instance handle
										 pW);												// creation parameters
			if (pW->hStepBack == NULL) {
				rc = FALSE;
				break;
			}
			//	ウインド表示
			ShowWindow(pW->hStepBack, SW_SHOWNORMAL);
		}
		else {
			ShowWindow(pW->hStepBack, SW_SHOWNORMAL);
			SetFocus  (pW->hStepBack);
		}
	} while(0);

	CipGsrDoEvent(pW);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ステップトレース バックウインドプロシージャ																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(StepBack, WM_CREATE		)
{
	BOOL			rc = -1;
	LPCREATESTRUCT	p  = (LPCREATESTRUCT)lParam;
	HAJCCIP			pW = (HAJCCIP)p->lpCreateParams;
	RECT			r;
	int				cx, cy;
	BC				txt[512];

	do {
		//	ウインド・エクストラ領域へワークポインタ設定
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//	自ウインドハンドル設定
		pW->hStepBack = hwnd;
		//	VT-100エミュレーション・コントロール生成
		AjcGetCtrlStrA(pW->hWndBack, txt, sizeof txt);
		strcat(txt, ", ML=20000, 6=0x00E0E0E0");
		pW->hStepVth = CreateWindowExA(0,											// extend style
									 "AjcCtrlVT100",								// window class name
									 txt,											// caption
									 WS_CHILD | AJCVTHS_LFCTRL,						// style
									 0,												// initial x position
									 0,												// initial y position
									 0,												// initial x size
									 0,												// initial y size
									 hwnd,											// parent window handle
									 (HMENU)IDC_VTH_STEP,							// window menu handle
									 hDllInst,										// program instance handle
									 NULL);											// creation parameters
		if (pW->hStepVth == NULL) {
			break;
		}
		ShowWindow(pW->hStepVth, SW_SHOW);

		//	アイコン設定
		SendMessage(hwnd, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

		//	ダイアログ生成
		pW->hStepDlg = CreateDialogParam(hDllInst, MAKEINTRESOURCE(IDD_CIPSTEP), pW->hStepBack, AJC_DLGPROC_NAME(StepDlg), (LPARAM)pW);
		if (pW->hStepDlg == NULL) {
			DestroyWindow(pW->hStepVth);
			pW->hStepVth = NULL;
			break;
		}
		ShowWindow(pW->hStepDlg, SW_SHOW);
		//	ウインド最小サイズ設定
		r.left = r.top = 0;
		r.right  = pW->szStepDlgB.cx;
		r.bottom = pW->szStepDlgB.cy + 100;
		AdjustWindowRect(&r, WS_OVERLAPPEDWINDOW, FALSE);
		pW->szStepWnd.cx = r.right - r.left;
		pW->szStepWnd.cy = r.bottom - r.top;
		//	ウインドサイズロード
		AjcLoadWndRectA(hwnd, CIP_STEP_SECT);
		//	ウインド最小サイズ確保
		GetWindowRect(hwnd, &r);
		cx = r.right - r.left;
		cy = r.bottom - r.top;
		if (cx < pW->szStepWnd.cx || cy < pW->szStepWnd.cy) {
			cx = __max(cx, pW->szStepWnd.cx);
			cy = __max(cy, pW->szStepWnd.cy);
			SetWindowPos(pW->hStepBack, NULL, 0, 0, cx, cy, SWP_NOMOVE);
		}
		//	ＶＴＨ設定情報ロード
		AjcVthLoadPropA(pW->hStepVth, MYSECT, NULL);
		//	戻り値＝ＯＫ
		rc = 0;

	} while(0);

	return rc;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(StepBack, WM_DESTROY	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	//	ウインドサイズセーブ
	AjcSaveWndRectA(hwnd, CIP_STEP_SECT);
	//	ＶＴＨ設定情報セーブ
	AjcVthSavePropA(pW->hStepVth, MYSECT);

	//	子ウインドクローズ
	if (pW->hStepVth != NULL) {DestroyWindow(pW->hStepVth); pW->hStepVth = NULL;}
	if (pW->hStepDlg != NULL) {DestroyWindow(pW->hStepDlg); pW->hStepDlg = NULL;}
	pW->hStepBack = NULL;

	return 0;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_WNDPROC(StepBack, WM_CLOSE		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	//	マクロ実行中はウインドクローズできない
	if (pW->fExec) {
		if (!pW->fStepMsgBoxBusy) {
			 pW->fStepMsgBoxBusy = TRUE;
			 AjcBell();
			 CipGerMessageBoxOK(pW, pW->hStepVth,
							LNGSEL("マクロ実行中は、ステップトレースウインドをクローズできません。",
							"Can not be opened 'StepTraceWindow' during macro-execution."), AppNameA);
			 pW->fStepMsgBoxBusy = FALSE;
		}
	}
	//	マクロ非実行中ならば、ウインドをクローズ
	else {
		DestroyWindow(hwnd);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(StepBack, WM_SIZING		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LPRECT		p = (LPRECT)lParam;
	int			w = p->right - p->left;
	int			h = p->bottom - p->top;

	if (w < pW->szStepWnd.cx) p->right	= p->left + (pW->szStepWnd.cx);
	if (h < pW->szStepWnd.cy) p->bottom = p->top  + (pW->szStepWnd.cy);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(StepBack, WM_SIZE		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	int			cx = LOWORD(lParam);
	int			cy = HIWORD(lParam);
	int			dcy = AjcGetDlgItemChk(pW->hStepDlg, IDC_CHK_SETBRK) ? pW->szStepDlgB.cy : pW->szStepDlgA.cy;

	//	ダイアログウインド設定
	MoveWindow(pW->hStepDlg, 0, 0  , cx,	  dcy, TRUE);
	//	VTHウインドサイズ設定
	MoveWindow(pW->hStepVth, 0, dcy, cx, cy - dcy, TRUE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(StepBack)
	AJC_WNDMAP_MSG(StepBack, WM_CREATE		)
	AJC_WNDMAP_MSG(StepBack, WM_DESTROY		)
	AJC_WNDMAP_MSG(StepBack, WM_CLOSE		)
	AJC_WNDMAP_MSG(StepBack, WM_SIZING		)
	AJC_WNDMAP_MSG(StepBack, WM_SIZE		)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ステップトレース ダイアログプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define		DLGPROP		"StepDlg"
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, WM_INITDIALOG 	)
{
	HAJCCIP		pW = (HAJCCIP)lParam;
	RECT		r1, r2;

	pW->hStepDlg = hDlg;
	SetPropA(hDlg, DLGPROP, (HANDLE)pW);

	//	日英テキスト
	SetWindowTextA(pW->hWndBack, LNGSEL("ステップ・トレース", "Step trace"));
	AjcSetDlgItemStrA(hDlg, IDC_GRP_CHASE, LNGSEL("変数の追跡 （ 複数指定時は、カンマ( , )で区切る ）",
												  "Chase of the variable (Separate by comma(,) when specifying many variables)"	));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_ARRMAX	, LNGSEL("配列の最大表示項目数"			, "Max. display number of array items"		));
	AjcSetDlgItemStrA(hDlg, IDC_CHK_ENASTEP	, LNGSEL("ステップトレース許可"			, "Enable step trace"						));
	AjcSetDlgItemStrA(hDlg, IDC_CHK_SETBRK	, LNGSEL("ブレークポイントを設定する"	, "Set break point"							));
	AjcSetDlgItemStrA(hDlg, IDC_GRP_BREAK	, LNGSEL("ブレークポイント （ブレークする行番号を指定，複数指定時はカンマ( , ) で区切る）",
													 "Break point( line number to break. Separate by comma(,) when specifying many lines)"));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_BRKLNO	, LNGSEL("行番号"						, "Lines"									));

	//	ボタンへアイコン表示
	SendDlgItemMessage(hDlg, IDC_CMD_RUN  , BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoRun  );
	SendDlgItemMessage(hDlg, IDC_CMD_PAUSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoPause);
	SendDlgItemMessage(hDlg, IDC_CMD_STOP , BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoEnd  );
	SendDlgItemMessage(hDlg, IDC_CMD_STEP , BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoStep );

	//	テキスト文字数制限（全て511バイト）
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_CHASE , MAX_TXTLEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_STEP  , MAX_TXTLEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_BRKLNO, MAX_TXTLEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SETVAL, MAX_TXTLEN - 1);

	//	ダイアログのサイズ設定
	GetWindowRect(hDlg, &r1);
	GetWindowRect(GetDlgItem(hDlg, IDC_GRP_BREAK), &r2);
	pW->szStepDlgA.cx = r1.right - r1.left;
	pW->szStepDlgA.cy = r2.top - r1.top;
	pW->szStepDlgB.cx = r1.right - r1.left;
	pW->szStepDlgB.cy = r1.bottom - r1.top;

	//	ダイアログ項目関連付け
	MAjcSetDlgPropStrA(hDlg, IDC_TXT_CHASE	, ""		  , NULL, 0);
	MAjcSetDlgPropUInt(hDlg, IDC_TXT_ARRMAX , 10   , FALSE, NULL);
	MAjcSetDlgPropUInt(hDlg, IDC_TXT_STEP	, 1    , FALSE, NULL);
	MAjcSetDlgPropChk (hDlg, IDC_CHK_SETBRK	, FALSE 	  , NULL);
	MAjcSetDlgPropStrA(hDlg, IDC_TXT_BRKLNO	 , ""		  , NULL, 0);

	//	ダイアログ設定項目ロード
	AjcLoadDlgProfilesA(hDlg, MYSECT);

	//	ステップトレース許可フラグ（チェックボックス）設定
	AjcSetDlgItemChk(hDlg, IDC_CHK_ENASTEP, pW->fStepTrace);

	//	ツールチップ・コントロール生成
	pW->hStepTtp = CreateWindowEx(WS_EX_TOPMOST,
									TOOLTIPS_CLASS,
									NULL,
									TTS_ALWAYSTIP,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									hDlg, NULL,
									hDllInst, NULL);
	//	ツールチップ追加
	{	TOOLINFOA	ti;
		memset(&ti, 0, sizeof ti);
		ti.cbSize	= sizeof(TOOLINFO);
		ti.hwnd		= hDlg;
		ti.hinst	= hDllInst;
		ti.uFlags	= TTF_IDISHWND | TTF_SUBCLASS;

		ti.lpszText = LNGSEL("追跡する変数群", "variables to chase");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_CHASE );	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("実行継続", "Continuing execution");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_CMD_RUN	);	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("一時停止", "Pause");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_CMD_PAUSE	);	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("停止", "Stop");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_CMD_STOP	);	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("ステップ実行", "Step execution");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_CMD_STEP	);	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("実行ステップ数", "Execution steps");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_STEP	);	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("ブレークする行番号群", "Break line numbers");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_BRKLNO);	SendMessage(pW->hStepTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);
	}

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, WM_DESTROY		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	//	中断状態解除
	pW->fStepPause = FALSE;
	//	ダイアログ設定値退避
	AjcSaveDlgProfilesA(hDlg, MYSECT);
	AjcReleaseDlgProps(hDlg);
	//	ツールチップ破棄
	if (pW->hStepTtp != NULL) {DestroyWindow(pW->hStepTtp); pW->hStepTtp = NULL;}
	//	プロパティ破棄
	RemovePropA(hDlg, DLGPROP);

	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDCANCEL			)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	DestroyWindow(hDlg);
	return TRUE;
}
//----- 実行ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDC_CMD_RUN		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	中断状態解除
		pW->fStepPause = FALSE;
	}
	return TRUE;
}
//----- 一時停止ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDC_CMD_PAUSE		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	中断状態設定
		pW->fExePause = TRUE;
	}
	return TRUE;
}
//----- 停止ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDC_CMD_STOP		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	実行中止
		pW->fRunStop = TRUE;
	}
	return TRUE;
}
//----- ステップ実行ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDC_CMD_STEP		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	ステップ数設定
		pW->nStepCount = AjcGetDlgItemUInt(pW->hStepDlg, IDC_TXT_STEP);
		//	中断状態設定
		pW->fStepPause = FALSE;
	}
	return TRUE;
}
//----- チェックボックス（ステップトレース許可）----------------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDC_CHK_ENASTEP	)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	if (HIWORD(wParam) == BN_CLICKED) {
		pW->fStepTrace = AjcGetDlgItemChk(hDlg, IDC_CHK_ENASTEP);
	}
	return TRUE;
}
//----- チェックボックス（ブレークポイントを設定する）----------------------------------------------------------//
AJC_DLGPROC(StepDlg, IDC_CHK_SETBRK		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);
	RECT		r;
	int			cx, cy;

	if (HIWORD(wParam) == BN_CLICKED) {
		GetClientRect(pW->hStepBack, &r);
		cx = r.right - r.left;
		cy = r.bottom - r.top;
		SendMessage(pW->hStepBack, WM_SIZE, SIZE_RESTORED, MAKELONG(cx, cy));
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(StepDlg)
	AJC_DLGMAP_MSG(StepDlg, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(StepDlg, WM_DESTROY		)

	AJC_DLGMAP_CMD(StepDlg, IDCANCEL		)
	AJC_DLGMAP_CMD(StepDlg, IDC_CMD_RUN		)
	AJC_DLGMAP_CMD(StepDlg, IDC_CMD_PAUSE	)
	AJC_DLGMAP_CMD(StepDlg, IDC_CMD_STOP	)
	AJC_DLGMAP_CMD(StepDlg, IDC_CMD_STEP	)
	AJC_DLGMAP_CMD(StepDlg, IDC_CHK_ENASTEP	)
	AJC_DLGMAP_CMD(StepDlg, IDC_CHK_SETBRK	)
AJC_DLGMAP_END
