﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ（トレース表示）																		//
//																												//
//**************************************************************************************************************//

#define		MYSECT		CIP_TRC_SECT

#define		MAX_TXTLEN	512

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	ATOM	ClassTrcBack = 0;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(TrcBack);
AJC_DLGPROC_DEF(TrcDlg);

static	VO		ShowStepAndLineNo(HAJCCIP pW, UI lno);
static	VO		DisClose(HAJCCIP pW);
static	VO		EnaClose(HAJCCIP pW);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	CipTrcInit(VO)
{
	BOOL		rc = TRUE;
	WNDCLASSA	wndclass;

	//	トレース用バックウインドクラス生成
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(TrcBack);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= (sizeof(UX));
	wndclass.hInstance		= hDllInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= hBruBtnFace;
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= "CAjaMacroTrace";
	ClassTrcBack = RegisterClassA(&wndclass);
	if (ClassTrcBack == 0) {
		rc = FALSE;
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		CipTrcEnd(VO)
{
	//	トレース用バックウインドクラス破棄
	if (ClassTrcBack != 0) {
		UnregisterClassA((BCP)ClassTrcBack, hDllInst);
		ClassTrcBack = 0;
	}
}
//==============================================================================================================//
//	全変数表示																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				MaxArrNum	- 配列の最大表示項目数																//
//				fDumpAll	- システム内部変数を含めた全変数表示フラグ											//
//				lno			- 行番号																			//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
typedef struct {
	HAJCCIP		pW;
	UI			MaxArrNum;
	BOOL		fDumpAll;
} VARDMPPRM, *PVARDMPPRM;
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbDvNtcVar(PCAJCVMGNODEA pVarInfo, UX cbp)
{
	PVARDMPPRM	pCbp	  = (PVARDMPPRM)cbp;
	HAJCCIP 	pW		  = pCbp->pW;
	UI			MaxArrNum = pCbp->MaxArrNum;
	UI			i, n;
	UBP			p;

	n = __min(pVarInfo->num, MaxArrNum);
	for (i = 0; i < pVarInfo->num; i++) {
		if ((!mbsstr(pVarInfo->pName, "@") && !(pVarInfo->att & AJCVMGA_RDONLY))  ||  pCbp->fDumpAll) {
			UI	stl = (UI)strlen(pVarInfo->pName);
			if (pVarInfo->num == 1) {
				AjcVthPrintFA(pW->hTrcVth, "%s = ", pVarInfo->pName);
			}
			else {
				if (i == 0) AjcVthPrintFA(pW->hTrcVth, "%s[%2d] = ", pVarInfo->pName, i);
				else		AjcVthPrintFA(pW->hTrcVth, "%*c[%2d] = ", stl, ' ', i);
			}
			switch (pVarInfo->type) {
				case AJCVMGT_INT:	AjcVthPrintFA(pW->hTrcVth, "%d"	, pVarInfo->arr.pSI [i]);	break;
				case AJCVMGT_LONG:	AjcVthPrintFA(pW->hTrcVth, "%lld", pVarInfo->arr.pSLL[i]);	break;
				case AJCVMGT_REAL:	AjcVthPrintFA(pW->hTrcVth, "%f"	, pVarInfo->arr.pDBL[i]);	break;
				case AJCVMGT_STR:
					AjcVthPrintFA(pW->hTrcVth, "\"");
					for (p = (UBP)pVarInfo->arr.pStr[i]; *p != 0; p++) {
						if (*p < 0x20) AjcVthPrintFA(pW->hTrcVth, "\\x%02x", *p);
						else		   AjcVthPrintFA(pW->hTrcVth, "%c"	 , *p);
					}
					AjcVthPrintFA(pW->hTrcVth, "\"");
					break;
			}
			AjcVthPrintFA(pW->hTrcVth, "\n");
		}
		CipGsrDoEvent(pW);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
VO		CipTrcVarDump(HAJCCIP pW, UI MaxArrNum, UI lno, BOOL fDumpAll)
{
	int			i, stl;

	BC			txt[1024];
	VARDMPPRM	cbp;

	//	ウインドクローズ禁止
	DisClose(pW);

	if (pW->hTrcBack != NULL) {
		//	ステップ番号，行番号表示
		ShowStepAndLineNo(pW, lno);

		//	全変数値表示
		for (i = 0; i < AJCCIPMAX_IXVMG; i++) {
			if (pW->sFni[i].hVmg != NULL) {
				AjcSnPrintFA(txt, sizeof txt, "---------- Level %d, %s  Variables ", i,	(i == 0) ? "Global" : pW->sFni[i].CInf.pFunName);
				stl = (int)strlen(txt);
				if (stl < 80) {
					memset(&txt[stl], '-', 80 - stl);
					txt[80] = 0;
				}
				AjcVthPrintFA(pW->hTrcVth, "%s\n", txt);
				cbp.pW		  = pW;
				cbp.MaxArrNum = (UI)MaxArrNum;
				cbp.fDumpAll  = fDumpAll;
				AjcVmgEnumVarA(pW->sFni[i].hVmg, (UX)&cbp, cbDvNtcVar);
				CipGsrDoEvent(pW);
			}
		}
	}
	//	ウインドクローズ許可
	EnaClose(pW);
}
//==============================================================================================================//
//	テキスト表示																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pText		- 表示テキスト																		//
//				lno			- 行番号																			//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		CipTrcPutText(HAJCCIP pW, C_BCP pText, UI lno)
{
	//	ウインドクローズ禁止
	DisClose(pW);

	if (pW->hTrcBack == NULL) {
		CipTrcCreateWindow(pW);
	}

	if (pW->hTrcBack != NULL) {
		//	ステップ番号，行番号表示
		ShowStepAndLineNo(pW, lno);
		//	テキスト表示
		AjcVthPutTextA(pW->hTrcVth, pText, -1);
		//	Windows Event
		CipGsrDoEvent(pW);
	}
	//	ウインドクローズ許可
	EnaClose(pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ステップ番号，行番号表示																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowStepAndLineNo(HAJCCIP pW, UI lno)
{
	BOOL	fShowStepNo = AjcGetDlgItemChk(pW->hTrcDlg, IDC_CHK_SHOW_STEP);
	BOOL	fShowLineNo = AjcGetDlgItemChk(pW->hTrcDlg, IDC_CHK_SHOW_LINE);

	//	ステップ番号，行番号表示
	if (fShowStepNo || fShowLineNo) {
		AjcVthPrintFA(pW->hTrcVth, "\x1B[31m\n<<< ");
		if (fShowStepNo && fShowLineNo) AjcVthPrintFA(pW->hTrcVth, "Step = %d, Line = %d", pW->ExeStepNo, lno);
		else if (fShowStepNo)			AjcVthPrintFA(pW->hTrcVth, "Step = %d"			, pW->ExeStepNo		);
		else if (fShowLineNo)			AjcVthPrintFA(pW->hTrcVth, "Line = %d"			, 				 lno);
		AjcVthPrintFA(pW->hTrcVth, " >>>\n\x1B[0m");
		CipGsrDoEvent(pW);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ウインドクローズ禁止																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DisClose(HAJCCIP pW)
{
	//	ウインドクローズ禁止
	pW->fTrcDisClose = TRUE;
	//	クローズ操作フラグクリアー
	pW->fTrcOpeClose = FALSE;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ウインドクローズ許可																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	EnaClose(HAJCCIP pW)
{
	//	ウインドクローズ許可
	pW->fTrcDisClose = FALSE;
	//	禁止期間中にクローズ操作があれば、ウインド破棄
	if (pW->fTrcOpeClose) {
		pW->fTrcOpeClose = FALSE;
		if (pW->hTrcBack != NULL) {
			DestroyWindow(pW->hTrcBack);
		}
	}
}

//==============================================================================================================//
//	トレースウインド生成																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - エラー																					//
//==============================================================================================================//
#define		IDC_VTH_TRC				5010				//	ＶＴＨコントロールＩＤ
//--------------------------------------------------------------------------------------------------------------//
BOOL	CipTrcCreateWindow(HAJCCIP pW)
{
	BOOL		rc = TRUE;

	do {
		//	トレース用バックウインド生成
		if (pW->hTrcBack == NULL) {
			pW->hTrcBack = CreateWindowA("CAjaMacroTrace",							// window class name
										LNGSEL("トレースウインド", "Trace window"), // window caption
										WS_OVERLAPPEDWINDOW,						// window style
										0,											// initial x position
										0,											// initial y position
										500,										// initial x size
										300,										// initial y size
										NULL,										// parent window handle
										NULL,										// window menu handle
										hDllInst,									// program instance handle
										pW);										// creation parameters
			if (pW->hTrcBack == NULL) {
				rc = FALSE;
				break;
			}
			//	ウインド表示
			ShowWindow(pW->hTrcBack, SW_SHOWNORMAL);
		}
		else {
			ShowWindow(pW->hTrcBack, SW_SHOWNORMAL);
			SetFocus  (pW->hTrcBack);
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	トレース バックウインドプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TrcBack, WM_CREATE		)
{
	BOOL			rc = -1;
	LPCREATESTRUCT	p  = (LPCREATESTRUCT)lParam;
	HAJCCIP			pW = (HAJCCIP)p->lpCreateParams;
	RECT			r;
	int				cx, cy;
	BC				txt[512];

	do {
		//	ウインド・エクストラ領域へワークポインタ設定
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//	自ウインドハンドル設定
		pW->hTrcBack = hwnd;
		//	VT-100エミュレーション・コントロール生成
		AjcGetCtrlStrA(pW->hWndBack, txt, sizeof txt);
		strcat(txt, ", ML=10000");
		pW->hTrcVth = CreateWindowExA(0,													// extend style
									 "AjcCtrlVT100",									// window class name
									 txt,												// Caption
									 WS_CHILD | AJCVTHS_LFCTRL,							// style
									 0,													// initial x position
									 0,													// initial y position
									 0,													// initial x size
									 0,													// initial y size
									 hwnd,												// parent window handle
									 (HMENU)IDC_VTH_TRC,								// window menu handle
									 hDllInst,											// program instance handle
									 NULL);												// creation parameters
		if (pW->hTrcVth == NULL) {
			break;
		}
		ShowWindow(pW->hTrcVth, SW_SHOW);

		//	アイコン設定
		SendMessage(hwnd, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

		//	ダイアログ生成
		pW->hTrcDlg = CreateDialogParam(hDllInst, MAKEINTRESOURCE(IDD_CIPTRACE), pW->hTrcBack, AJC_DLGPROC_NAME(TrcDlg), (LPARAM)pW);
		if (pW->hTrcDlg == NULL) {
			DestroyWindow(pW->hTrcVth);
			pW->hTrcVth = NULL;
			break;
		}
		ShowWindow(pW->hTrcDlg, SW_SHOW);
		//	ウインド最小サイズ設定
		r.left = r.top = 0;
		r.right  = pW->szTrcDlg.cx;
		r.bottom = pW->szTrcDlg.cy + 100;
		AdjustWindowRect(&r, WS_OVERLAPPEDWINDOW, FALSE);
		pW->szTrcWnd.cx = r.right - r.left;
		pW->szTrcWnd.cy = r.bottom - r.top;
		//	ウインドサイズロード
		AjcLoadWndRectA(hwnd, MYSECT);
		//	ウインド最小サイズ確保
		GetWindowRect(hwnd, &r);
		cx = r.right - r.left;
		cy = r.bottom - r.top;
		if (cx < pW->szTrcWnd.cx || cy < pW->szTrcWnd.cy) {
			cx = __max(cx, pW->szTrcWnd.cx);
			cy = __max(cy, pW->szTrcWnd.cy);
			SetWindowPos(pW->hTrcBack, NULL, 0, 0, cx, cy, SWP_NOMOVE);
		}
		//	ＶＴＨ設定情報ロード
		AjcVthLoadPropA(pW->hTrcVth, MYSECT, NULL);
		//	戻り値＝ＯＫ
		rc = 0;
	} while(0);

	return rc;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(TrcBack, WM_DESTROY	)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	//	ウインドサイズセーブ
	AjcSaveWndRectA(hwnd, MYSECT);
	//	ＶＴＨ設定情報セーブ
	AjcVthSavePropA(pW->hTrcVth, MYSECT);

	//	子ウインドクローズ
	if (pW->hTrcVth != NULL) {DestroyWindow(pW->hTrcVth); pW->hTrcVth = NULL;}
	if (pW->hTrcDlg != NULL) {DestroyWindow(pW->hTrcDlg); pW->hTrcDlg = NULL;}
	pW->hTrcBack = NULL;

	return 0;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_WNDPROC(TrcBack, WM_CLOSE		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);

	if (!pW->fTrcDisClose) {
		DestroyWindow(hwnd);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TrcBack, WM_SIZING		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	LPRECT		p = (LPRECT)lParam;
	int			w = p->right - p->left;
	int			h = p->bottom - p->top;

	if (w < pW->szTrcWnd.cx) p->right  = p->left + (pW->szTrcWnd.cx);
	if (h < pW->szTrcWnd.cy) p->bottom = p->top  + (pW->szTrcWnd.cy);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(TrcBack, WM_SIZE		)
{
	HAJCCIP		pW = (HAJCCIP)MAjcGetWindowLong(hwnd, 0);
	int			cx = LOWORD(lParam);
	int			cy = HIWORD(lParam);

	//	ダイアログウインド設定
	MoveWindow(pW->hTrcDlg, 0, 0			  , cx, 	 pW->szTrcDlg.cy, TRUE);
	//	VTHウインドサイズ設定
	MoveWindow(pW->hTrcVth, 0, pW->szTrcDlg.cy, cx, cy - pW->szTrcDlg.cy, TRUE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(TrcBack)
	AJC_WNDMAP_MSG(TrcBack, WM_CREATE		)
	AJC_WNDMAP_MSG(TrcBack, WM_DESTROY		)
	AJC_WNDMAP_MSG(TrcBack, WM_CLOSE		)
	AJC_WNDMAP_MSG(TrcBack, WM_SIZING		)
	AJC_WNDMAP_MSG(TrcBack, WM_SIZE			)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	トレース ダイアログプロシージャ																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define		DLGPROP		"TrcDlg"
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(TrcDlg, WM_INITDIALOG 	)
{
	HAJCCIP		pW = (HAJCCIP)lParam;
	RECT		r;

	pW->hTrcDlg = hDlg;
	SetPropA(hDlg, DLGPROP, (HANDLE)pW);

	//	日英テキスト
	SetWindowTextA	(pW->hTrcBack, LNGSEL("トレース出力", "Trace output"));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_SHOW		, LNGSEL("_Trace() による表示出力 : "		, "Display output by _Trace() : "));
	AjcSetDlgItemStrA(hDlg, IDC_CHK_SHOW_STEP, LNGSEL("ダイナミック・ステップ番号を表示する", "Show dynamic step number"	));
	AjcSetDlgItemStrA(hDlg, IDC_CHK_SHOW_LINE, LNGSEL("行番号を表示する"					, "Show line number"			));

	AjcSetDlgItemStrA(hDlg, IDC_GRP_SHOWVAR	, LNGSEL("変数の表示"							, "Show variable value"			));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_SHOWVAR	, LNGSEL("変数名"								, "Variable name"				));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_ARRMAX	, LNGSEL("配列の最大表示項目数"					, "Max. display number of array items"));
	AjcSetDlgItemStrA(hDlg, IDC_CMD_SHOW		, LNGSEL("変数値 表示"						, "Show"						));

	AjcSetDlgItemStrA(hDlg, IDC_GRP_SETVAR	, LNGSEL("変数の設定"							, "Set value to variable"		));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_SETVAR	, LNGSEL("変数名"								, "Variable name"				));
	AjcSetDlgItemStrA(hDlg, IDC_LBL_SETVAL	, LNGSEL("変数値"								, "Setting value"				));
	AjcSetDlgItemStrA(hDlg, IDC_CMD_SET		, LNGSEL("変数値 設定"							, "Set value"					));
	//	ダイアログのサイズ設定
	GetWindowRect(hDlg, &r);
	pW->szTrcDlg.cx = r.right - r.left;
	pW->szTrcDlg.cy = r.bottom - r.top;
	//	テキスト文字数制限（全て511バイト）
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SHOWVAR , MAX_TXTLEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SETVAR	, MAX_TXTLEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SETVAL	, MAX_TXTLEN - 1);
	//	ダイアログ項目関連付け
	MAjcSetDlgPropChk (hDlg, IDC_CHK_SHOW_STEP, FALSE	 , NULL);
	MAjcSetDlgPropChk (hDlg, IDC_CHK_SHOW_LINE, FALSE	 , NULL);
	MAjcSetDlgPropStrA(hDlg, IDC_TXT_SHOWVAR 	 , ""		 , NULL, 0);
	MAjcSetDlgPropUInt(hDlg, IDC_TXT_ARRMAX 	 , 10 , FALSE, NULL);
	MAjcSetDlgPropStrA(hDlg, IDC_TXT_SETVAR 	 , ""		 , NULL, 0);
	MAjcSetDlgPropStrA(hDlg, IDC_TXT_SETVAL 	 , ""		 , NULL, 0);
	//	ダイアログ設定項目ロード
	AjcLoadDlgProfilesA(hDlg, MYSECT);

	//	ツールチップ・コントロール生成
	pW->hTrcTtp = CreateWindowEx(WS_EX_TOPMOST,
									TOOLTIPS_CLASS,
									NULL,
									TTS_ALWAYSTIP,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									CW_USEDEFAULT,
									hDlg, NULL,
									hDllInst, NULL);
	//	ツールチップ追加
	{	TOOLINFOA	ti;
		memset(&ti, 0, sizeof ti);
		ti.cbSize	= sizeof(TOOLINFO);
		ti.hwnd		= hDlg;
		ti.hinst	= hDllInst;
		ti.uFlags	= TTF_IDISHWND | TTF_SUBCLASS;

		ti.lpszText = LNGSEL("表示する変数群（複数指定時は、カンマ ( , )で区切る）",
							 "Displaying variables(Separate by comma(,) when specifying many variables)");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_SHOWVAR);	SendMessage(pW->hTrcTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("表示する変数（１つの変数を指定してください）", "A setting variable");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_SETVAR	);	SendMessage(pW->hTrcTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

		ti.lpszText = LNGSEL("設定する値(文字列の場合は両端のダブルクオート( \" )／アポストロフィ( ' )は不要)",
							 "Setting value (Need not both edges of (\") or (') in string)");
		ti.uId = (UX)GetDlgItem(hDlg, IDC_TXT_SETVAL	);	SendMessage(pW->hTrcTtp, TTM_ADDTOOL, 0, (LPARAM)&ti);

	}

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(TrcDlg, WM_DESTROY		)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	//	ダイアログ設定値退避
	AjcSaveDlgProfilesA(hDlg, MYSECT);
	AjcReleaseDlgPropsA(hDlg);
	//	ツールチップ破棄
	if (pW->hTrcTtp != NULL) {DestroyWindow(pW->hTrcTtp); pW->hTrcTtp = NULL;}
	//	プロパティ破棄
	RemovePropA(hDlg, DLGPROP);

	return TRUE;
}
//----- 変数値表示ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(TrcDlg, IDC_CMD_SHOW	)
{
	HAJCCIP			pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);
	HAJCVMGA		hVmg  = NULL;			//	VMGハンドル
	PCAJCVMGNODEA	pNode = NULL;			//	変数情報ノード
	UI				nMaxArr;				//	配列の最大表示個数
	BC				DlgTxt[MAX_TXTLEN];		//	変数名群（ダイアログ指定値）

	if (HIWORD(wParam) == BN_CLICKED) {
		//	文字色設定
		AjcVthPutTextA(pW->hTrcVth, "\x1B[34m", -1);
		//	ダイアログ設定内容取得
		nMaxArr = AjcGetDlgItemUInt(pW->hTrcDlg, IDC_TXT_ARRMAX);
		AjcGetDlgItemStrA(hDlg, IDC_TXT_SHOWVAR, DlgTxt, MAX_TXTLEN);
		AjcStrTrimA(DlgTxt, DlgTxt, MAX_TXTLEN);
		//	変数群表示
		CipGsrShowVariableValue(pW, pW->hTrcVth, DlgTxt, nMaxArr);
		//	文字色解除
		AjcVthPutTextA(pW->hTrcVth, "\x1B[0m", -1);
	}
	return TRUE;
}
//----- 変数値設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(TrcDlg, IDC_CMD_SET			)
{
	HAJCCIP			pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);
	HAJCVMGA		hVmg  = NULL;
	PCAJCVMGNODEA	pNode = NULL;			//	変数情報ノード
	AJCCIPTRCVAR	va;						//	変数解析情報
	BC				VarExp[MAX_TXTLEN];		//	変数表現（ダイアログ指定値）

	if (HIWORD(wParam) == BN_CLICKED) {
		//	文字色設定
		AjcVthPutTextA(pW->hTrcVth, "\x1B[35m", -1);
		//	変数名設定
		AjcGetDlgItemStrA(hDlg, IDC_TXT_SETVAR, VarExp, MAX_TXTLEN);
		AjcStrTrimA(VarExp, VarExp, MAX_TXTLEN);
		//	変数名解析
		if (CipGsrAnalVarName(pW, VarExp, &va)) {
			//	ＶＭＧインスタンス取得
			if ((hVmg = (HAJCVMGA)CipGsrGetVarInst(pW, va.pVarName)) && (pNode = AjcVmgGetNodeA(hVmg, va.pVarName))) {
				//	配列インデクスが所定内ならば、変数値設定
				if (va.ixArr < pNode->num) {
					switch (pNode->type) {
						case AJCVMGT_LONG:
						{	SLL		n;
							if (pW->fSigned) n = AjcGetDlgItemSI64(hDlg, IDC_TXT_SETVAL);
							else			 n = AjcGetDlgItemUI64(hDlg, IDC_TXT_SETVAL);
							AjcVmgSetIntegerA(hVmg, va.pVarName, va.ixArr, n);
							if (pW->fSigned) AjcVthPrintFA(pW->hTrcVth, "  %s = %lld\n"	, VarExp, n);
							else			 AjcVthPrintFA(pW->hTrcVth, "  %s = %llu\n"	, VarExp, n);
							break;
						}
						case AJCVMGT_REAL:
						{	double n;
							n = AjcGetDlgItemReal(hDlg, IDC_TXT_SETVAL);
							AjcVmgSetRealA(hVmg, va.pVarName, va.ixArr, n);
							AjcVthPrintFA(pW->hTrcVth, "  %s = %f\n"	, VarExp, n);
							break;
						}
						case AJCVMGT_STR:
						{	BC		str[MAX_TXTLEN];
							AjcGetDlgItemStrA(hDlg, IDC_TXT_SETVAL, str, MAX_TXTLEN);
							AjcVmgSetStringA(hVmg, va.pVarName, va.ixArr, str);
							AjcVthPrintFA(pW->hTrcVth, "  %s = \"%s\"\n", VarExp, str);
							break;
						}
						default:
							AjcVthPrintFA(pW->hTrcVth, "  %s = Invalid type\n"	, VarExp);
							break;
					}
				}
				else AjcVthPrintFA(pW->hTrcVth,"  %s = Index over\n", VarExp);
			}
			else AjcVthPrintFA(pW->hTrcVth, "  %s = Not found\n", VarExp);
		}

		AjcVthPutTextA(pW->hTrcVth, "\x1B[0m", -1);
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(TrcDlg, IDCANCEL			)
{
	HAJCCIP		pW = (HAJCCIP)GetPropA(hDlg, DLGPROP);

	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(TrcDlg)
	AJC_DLGMAP_MSG(TrcDlg, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(TrcDlg, WM_DESTROY		)

	AJC_DLGMAP_CMD(TrcDlg, IDC_CMD_SHOW		)
	AJC_DLGMAP_CMD(TrcDlg, IDC_CMD_SET		)
	AJC_DLGMAP_CMD(TrcDlg, IDCANCEL			)
AJC_DLGMAP_END


