﻿#include	"AjcInternal.h"
#include	"AjcCipCommon.h"

//**************************************************************************************************************//
//																												//
//	Ｃ言語風インタプリタ（変数管理）																			//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	変数の作成																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				type		- 変数のタイプ																		//
//				num			- 配列の要素数																		//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgGenVar	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, EAJCCIPTYP type, UI num)
{
	BOOL	rc = TRUE;

	if (AjcVmgGetNodeA(hVmg, pVarName) == NULL) {
		if (!(AjcVmgGenVarA(hVmg, pVarName, (AJCVMGTYPE)type, num))) {
			pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
										  LNGSEL("CipVmgGenVar: 変数 <%s> の作成を失敗しました",
												 "CipVmgGenVar: Variable <%s> generation failure."), pVarName);
			rc = FALSE;
		}
	}
	else {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgGenVar: 変数 <%s> は既に定義されています(CipVmgGenVar)",
											 "CipVmgGenVar: Multiple defined <%s>."), pVarName);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	変数の削除																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgDelVar(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName)
{
	BOOL	rc = TRUE;

	if (!AjcVmgDelVarA(hVmg, pVarName)) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgDelVar: 変数 <%s> が見つかりません",
											 "CipVmgDelVar: Variable <%s> not found."), pVarName);
		rc = FALSE;
	}

	return rc;
}

//==============================================================================================================//
//	変数値設定（整数）																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				value		- 変数値																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgSetInteger(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, SLL value)
{
	BOOL	rc = TRUE;

	if (!(AjcVmgSetIntegerA(hVmg, pVarName, ix, value))) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgSetInteger: 変数値 <%s> の設定を失敗しました。（未定義／配列インデクスオーバー）",
											 "CipVmgSetInteger: Variable <%s> setting failure."), pVarName);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	変数値設定（実数）																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				value		- 変数値																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgSetReal	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, double value)
{
	BOOL	rc = TRUE;

	if (!(AjcVmgSetRealA(hVmg, pVarName, ix, value))) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgSetReal: 変数値 <%s> の設定を失敗しました。（未定義／配列インデクスオーバー）",
											 "CipVmgSetReal: Variable <%s> setting failure."), pVarName);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	変数値設定（文字列）																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pStr		- 文字列へのポインタ																//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgSetString	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, C_BCP pStr)
{
	BOOL	rc = TRUE;

	if (!(AjcVmgSetStringA(hVmg, pVarName, ix, pStr))) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgSetString: 変数値 <%s> の設定を失敗しました。（未定義／配列インデクスオーバー／メモリエラー）",
											 "CipVmgSetString: Variable <%s> setting failure."), pVarName);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	変数値取得（６４ビット整数）																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pValue		- 変数値を格納するバッファのアドレス												//
//																												//
//	戻り値	：	≠０ - 成功（変数のタイプ）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
BOOL			CipVmgGetInt64	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, SLLP pValue)
{
	BOOL	rc = TRUE;

	if (AjcVmgGetInt64A(hVmg, pVarName, ix, pValue) == AJCVMGT_UNDEF) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgGetInt64: 変数値 <%s> の取得を失敗しました。（未定義／配列インデクスオーバー）",
											 "CipVmgGetInt64: Variable <%s> getting failure."), pVarName);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	変数値取得（実数）																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//				pValue		- 変数値を格納するバッファのアドレス												//
//																												//
//	戻り値	：	≠０ - 成功（変数のタイプ）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
BOOL		CipVmgGetReal	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix, double *pValue)
{
	BOOL	rc = TRUE;

	if (AjcVmgGetRealA(hVmg, pVarName, ix, pValue) == AJCVMGT_UNDEF) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgGetReal: 変数値 <%s> の取得を失敗しました。（未定義／配列インデクスオーバー(CipVmgGetReal)）",
											 "CipVmgGetReal: Variable <%s> getting failure."), pVarName);
		rc = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	変数値取得（文字列）																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//				ix			- 要素インデクス																	//
//																												//
//	戻り値	：	≠NULL - 成功（変数のタイプ）																	//
//				＝NULL - 失敗																					//
//==============================================================================================================//
C_BCP			CipVmgGetString(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName, UI ix)
{
	C_BCP	rc;

	if ((rc = AjcVmgGetStringA(hVmg, pVarName, ix)) == NULL) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgGetString: 変数値 <%s> の取得を失敗しました。（未定義／配列インデクスオーバー）",
											 "CipVmgGetString: Variable <%s> getting failure."), pVarName);
	}
	return rc;
}

//==============================================================================================================//
//	変数値の交換																								//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				lno				- 行番号																		//
//				hVmg			- 変数管理インスタンス															//
//				pVarName1, ix1	- 値を交換する変数名へのポインタ，配列要素インデクス							//
//				pVarName2, ix2	- 	〃																			//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgSwap		(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName1, UI ix1, C_BCP pVarName2, UI ix2)
{
	BOOL	rc = TRUE;

	if (!(AjcVmgSwapA(hVmg, pVarName1, ix1, pVarName2, ix2))) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgSwap: 変数値 <%s, %s> の交換を失敗しました。（未定義／配列インデクスオーバー／メモリエラー）",
											 "CipVmgSwap: Variable <%s, %s> excahnging failure."), pVarName1, pVarName2);
	}
	return rc;
}
//==============================================================================================================//
//	配列要素数の取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	≠０ - 成功（配列の要素数）																		//
//				＝０ - 失敗																						//
//==============================================================================================================//
UI				CipVmgGetArrNum	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName)
{
	UI		rc;

	if ((rc = AjcVmgGetArrNumA(hVmg, pVarName)) == 0) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgGetArrNum: 変数 <%s> は定義されていません。",
											 "CipVmgGetArrNum: Undefined variable <%s>."), pVarName);
	}
	return rc;
}
//==============================================================================================================//
//	変数情報ノード取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmg		- 変数管理インスタンス																//
//				pVarName	- 変数名へのポインタ																//
//																												//
//	戻り値	：	≠NULL - 成功（変数情報ノードのアドレス）														//
//				＝NULL - 失敗																					//
//==============================================================================================================//
PCAJCVMGNODEA	CipVmgGetNode	(HAJCCIP pW, UI lno, HAJCVMGA hVmg, C_BCP pVarName)
{
	PCAJCVMGNODEA	rc;

	if ((rc = AjcVmgGetNodeA(hVmg, pVarName)) == NULL) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgGetNode: 変数 <%s> は定義されていません。",
											 "CipVmgGetNode: Undefined variable <%s>."), pVarName);
	}
	return rc;
}
//==============================================================================================================//
//	変数／配列のコピー																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lno			- 行番号																			//
//				hVmgD		- コピー先インスタンスハンドル														//
//				pNameD		- コピー先変数名																	//
//				hVmgS		- コピー元インスタンスハンドル														//
//				pNameD		- コピー元変数名																	//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
BOOL			CipVmgCopy		(HAJCCIP pW, UI lno, HAJCVMGA hVmgD, C_BCP pNameD, HAJCVMGA hVmgS, C_BCP pNameS)
{
	BOOL	rc = TRUE;

	if (!(AjcVmgCopyA(hVmgD, pNameD, hVmgS, pNameS))) {
		pW->ErrCod = CipGsrNtcErr(pW, AJCIP_ERR_VMG, lno,
									  LNGSEL("CipVmgCopy: 変数／配列のコピー( <%s> -> <%s> )を失敗しました。（未定義／メモリエラー）",
											 "CipVmgCopy: Failed in a copy of a variable <%s> to <%s>."), pNameS, pNameD);
		rc = FALSE;
	}
	return rc;
}

