﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	共通定義														//
//																												//
//**************************************************************************************************************//

#define	G3D_ELPSPOINTS		60

#define	G3D_FLT_WIDTH		16				//	フィルタチェックボックスの幅
#define	G3D_FLT_HEIGHT		16				//		  〃				の高さ

#define	G3D_IDC_BTN_WIDE	4001			//	ワイドボタンＩＤ
#define	G3D_IDC_BTN_ZOOM	4002			//	ズームボタンＩＤ
#define	G3D_IDC_CHK_BASE	4100			//	チェックボックスＩＤ

#define	G3D_BTN_WIDTH		20				//	ボタン横サイズ
#define	G3D_BTN_HEIGHT		23				//	ボタン縦サイズ
#define	G3D_BTN_MRG			3

#define	G3D_SPHERE_SCALE_SLICE	16			//	球体スケールの水平分割数
#define	G3D_SPHERE_SCALE_STACK	16			//	球体スケールの垂直分割数
#define	G3D_SPHERE_PTBUF	(G3D_ELPSPOINTS * 2)

#define	G3D_INST_ID			0xF15D8BE2

//--------------------------------------------------------------------------------------------------------------//
//	描画情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	GIC_POINT		= 1	,
	GIC_LINE			,
	GIC_TRIAN			,
	GIC_SQUA			,
	GIC_ELPS			,
	GIC_FILL			,
} GICODE;
//----- 描画情報ヘッダ -----------------------------------------------------------------------------------------//
typedef struct {
	UW		gic;	//	描画種別
	UW		id;		//	データ項目番号(0 ～ 15)
	UI		seq;	//	描画順序
} GIHEAD, *PGIHEAD;
typedef  const GIHEAD *PCGIHEAD;
//----- ポイント情報 -------------------------------------------------------------------------------------------//
typedef struct {
	AJC3DVEC	v3;
	POINT		v2;
} GI_VEC, *PGI_VEC;
typedef const GI_VEC *PCGI_VEC;

//----- 点 -----------------------------------------------------------------------------------------------------//
typedef struct {
	GIHEAD		h;
	GI_VEC		p;
	UI			siz;
} GI_POINT, *PGI_POINT;
typedef const GI_POINT *PCGI_POINT;
//----- 線 -----------------------------------------------------------------------------------------------------//
typedef struct {
	GIHEAD		h;
	GI_VEC		p1, p2;
	BOOL		fArrow;
} GI_LINE, *PGI_LINE;
typedef const GI_LINE *PCGI_LINE;
//----- 三角形 -------------------------------------------------------------------------------------------------//
typedef struct {
	GIHEAD		h;
	GI_VEC		p1, p2, p3;
} GI_TRIAN, *PGI_TRIAN;
typedef const GI_TRIAN *PCGI_TRIAN;
//----- 四角形 -------------------------------------------------------------------------------------------------//
typedef struct {
	GIHEAD		h;
	GI_VEC		p1, p2, p3, p4;
} GI_SQUA, *PGI_SQUA;
typedef const GI_SQUA *PCGI_SQUA;
//----- 円 -----------------------------------------------------------------------------------------------------//
typedef struct {
	GIHEAD		h;
	GI_VEC		p[G3D_ELPSPOINTS];
	UI			siz;
} GI_ELPS, *PGI_ELPS;
typedef const GI_ELPS *PCGI_ELPS;
//----- 塗りつぶし ---------------------------------------------------------------------------------------------//
typedef struct {
	GIHEAD		h;
	UI			idBorder;		// 境界色（＝-1：Surface，≠-1：Border）
	GI_VEC		p;
} GI_FILL, *PGI_FILL;
typedef const GI_FILL *PCGI_FILL;
//--------------------------------------------------------------------------------------------------------------//
typedef union {
	GIHEAD		h;
	GI_POINT	poi;
	GI_LINE		line;
	GI_TRIAN	tri;
	GI_SQUA		squa;
	GI_ELPS		elps;
	GI_FILL		fill;
} GI_INFO, *PGI_INFO, **PPGI_INFO;
typedef const GI_INFO *PCGI_INFO;
//--------------------------------------------------------------------------------------------------------------//
//	ライン描画用ポイント情報																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			ix;					//	配列のインデクス（= 有効配列データ数）
	UI			nArr;				//	最大配列要素数（確保した配列要素数）
	HPEN		*pPen;				//	描画色ペンオブジェクト・配列へのポインタ
	POINT		*pPt;				//	描画点配列へのポインタ
} POLYINFO, *PPOLYINFO;
typedef const POLYINFO *PCPOLYINFO;
//--------------------------------------------------------------------------------------------------------------//
//	プロット情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			ix;					//	プロットデータインデクス（0 ～ Item[n].MaxPlot - 1)
	UI			cnt;				//	プロットデータ数		（0 ～ Item[n].MaxPlot	  )
	PGI_VEC		pBuf;				//	プロットデータ配列へのポインタ
} PLOTINFO, *PPLOTINFO;
typedef const PLOTINFO *PCPLOTINFO;

//--------------------------------------------------------------------------------------------------------------//
//	スケール情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	double	min, max;				//	スケール開始点と終了点
	double	step;					//	スケール描画ステップ
	UI		digit, prec;			//	整数部と小数部の桁数
} SCALEINFO, *PSCALEINFO;
typedef const SCALEINFO *PCSCALEINFO;
//--------------------------------------------------------------------------------------------------------------//
//	描画色情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	COLORREF	RgbP , RgbN;		//	描画色
	HBRUSH		hBruP, hBruN;		//	描画ブラシハンドル
	HPEN		hPenP, hPenN;		//	描画ペンハンドル
	GI_VEC		gv;					//	ライン描画用移動点退避バッファ
	double		t;					//	原点と点の開き角度（原点から手前側か奥側かを示す角度）
} RGBINFO, *PRGBINFO;
typedef const RGBINFO *PCRGBINFO;

//--------------------------------------------------------------------------------------------------------------//
//	アイテム情報																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	RGBINFO		RgbInfo;			//	描画色情報
	HAJCVQUE	hQueDat;			//	描画データキュー
	PLOTINFO	plot;				//	プロット情報
	AJC3DLVEC	PlnLVec;			//	平面定義（中心位置と法線）
	AJC3DVEC	PlnOrg;				//	平面定義（基準ベクトル（Ｘ軸方向となるベクトル））
} DATA_ITEM, *PDATA_ITEM;
typedef const DATA_ITEM *PCDATA_ITEM;
//--------------------------------------------------------------------------------------------------------------//
//	軸描画情報																									//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			MyIx;				//	自軸インデクス（０：Ｘ，１：Ｙ，２：Ｚ）
	double		Cent;				//	自軸中心位置
	double		r;					//	自軸半径
	RGBINFO		RgbInfo;			//	描画色情報
	GI_VEC		s, e;				//	描画範囲
	SCALEINFO	Sif;				//	スケーリング情報
} AXIS_INF, *PAXIS_INF;
typedef const AXIS_INF *PCAXIS_INF;
//--------------------------------------------------------------------------------------------------------------//
//	ドラッグ状態																								//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	DRAGMD_STOP	= 0	,				//	非ドラッグ中
	DRAGMD_XY		,				//	Ｘ／Ｙ軸回転ドラッグ中
	DRAGMD_Z		,				//	Ｚ軸回転ドラッグ中
} DRAGMODE;

//--------------------------------------------------------------------------------------------------------------//
//	平面回転角度テーブル																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	union {
		struct {SW x, y, z;} s;
		ULL					 ull;
	} u;
	AJCG3DAXIS_DIR	xDir;		//	平面Ｘ軸の種別
	AJCG3DAXIS_DIR	yDir;		//	平面Ｙ軸の種別
} ROTPLANE, *PROTPLANE;
typedef const ROTPLANE *PCROTPLANE;

#define	MAX_ROTPLANE	343

extern	const ROTPLANE	G3dRotPlane[MAX_ROTPLANE];

extern PCROTPLANE	G3dRpSearchTheta(int rx, int ry, int rz);						//	テーブルの回転角度検索
extern PCROTPLANE	G3dRpSearchAngle(AJCG3DAXIS_DIR xDir, AJCG3DAXIS_DIR yDir);		//	テーブルのアングル検索（最初に見つかったもの）

//--------------------------------------------------------------------------------------------------------------//
//	テキスト描画ＡＶＬノード																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BOOL		fPix;				//	表示位置＝ピクセル位置を示すフラグ
	AJCG3DTXOMD	md;					//	３Ｄ座標指定時のテキスト描画方法
	union {
		AJC3DVEC	v;				//	描画位置
		POINT		pt;
	} u;
	WC			txt[1];				//	描画テキスト
} G3DTXO, *PG3DTXO;

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;							//	インスタンス識別ＩＤ
	HWND		hMain;							//	メインウインドハンドル（グラフィック描画ウインド）
	HWND		hFilter;						//	フィルタウインドハンドル
	HWND		hChkFilt[AJC3DG_MAXITEM];		//	フィルタ・チェックボックス
	UI			style;							//	ウインドスタイル
	BOOL		fEnable;						//	コントロールの有効状態
	UI			ww, wh;							//	ウインドの幅と高さ
	COLORREF	RgbBorder;						//	ボーダー色
	HPEN		hPenBorder;						//	ボーダー描画ペンハンドル
	HBITMAP		hBmpImg;						//	スクリーンビットマップ（全体描画用）
	HBITMAP		hBmpSca;						//	スクリーンビットマップ（スケール描画用）
	HBITMAP		hBmpDat;						//	スクリーンビットマップ（データ描画用）
	BOOL		f2dMode;						//	２Ｄグラフモード
	BOOL		fFirstGetText;					//	最初のWM_GETTEXTを示すフラグ
	UI			MskFilt;						//	フィルタマスク
	AJC3DVEC	VSiten;							//	視点方向へのベクトル
	AJC3DMAT	MatX, MatY, MatZ;				//	回転行列データ
	AXIS_INF	AxisInfo[3];					//	軸描画情報
	UI			DatSeq;							//	データ描画順序番号
	HAJCAVL		hAvlDat;						//	データ描画順の描画ノードポインタ
	DATA_ITEM	DatItem[AJC3DG_MAXITEM];		//	各アイテム情報
	//----- 平面表示時の軸割り当て -----------------------------------------------------------------------------//
	AJCG3DAXIS_DIR	PlaneAxisH;
	AJCG3DAXIS_DIR	PlaneAxisV;
	//----- スケール用ＲＧＢ情報 -------------------------------------------------------------------------------//
	RGBINFO		RgbScale;
	//----- スケール（球体スケール，スケールライン，３軸）の再描画フラグ ---------------------------------------//
	BOOL		fReDrawScale;
	//----- データの再描画フラグ -------------------------------------------------------------------------------//
	BOOL		fReDrawData;
	//----- MoveTo / LineTo 用３Ｄポイントバッファ -------------------------------------------------------------//
	AJC3DVEC	V3dMoveTo[AJC3DG_MAXITEM];
	AJC2DVEC	V2dMoveTo[AJC3DG_MAXITEM];
	//----- 球体スケール描画用ポイントバッファ -----------------------------------------------------------------//
	POLYINFO	SphPolyInfo;					//	球体スケール・ライン描画用 ポイント情報
	HPEN		clSphBuf[G3D_SPHERE_PTBUF];		//	球体スケール・ライン描画用 描画色(HPEN)バッファ
	POINT		ptSphBuf[G3D_SPHERE_PTBUF];		//	球体スケール・ライン描画用 ポイントバッファ
	//----- メモリＤＣ -----------------------------------------------------------------------------------------//
	HDC			mdc;							//	全体描画用ＤＣ
	HDC			sdc;							//	スケール描画用ＤＣ
	HDC			ddc;							//	データ描画用ＤＣ
	//----- 表示停止フラグ -------------------------------------------------------------------------------------//
	BOOL		fPause;							//	表示停止中フラグ
	//----- スケール情報 ---------------------------------------------------------------------------------------//
	UI			SifCxChar, SifCyChar;			//	文字の幅と高さ
	UI			SifCyUnit;						//	スケール値描画間隔
	//----- ドラッグ情報 ---------------------------------------------------------------------------------------//
	DRAGMODE	DrgMode;						//	ドラッグ状態
	POINT		DrgSrt, DrgEnd;					//	ドラッグ開始，終了点
	AJC3DVEC	DrgRot;							//	ドラッグ開始時の回転角度
	//----- プロパティ -----------------------------------------------------------------------------------------//
	AJC3DGPROP	prop;
	//----- 右クリック通知情報 ---------------------------------------------------------------------------------//
	BOOL		fNtcRClk;						//	右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）
	UI			MsgRBDown;						//	右ボタンダウン時の通知メッセージコード
	UI			MsgRBUp;						//	右ボタンアップ時の通知メッセージコード
	//----- ワイド／ズームボタン情報 ---------------------------------------------------------------------------//
	BOOL		fShowBtn;						//	ボタン表示状態
	HWND		hBtnWide;						//	ワイドボタンハンドル
	HWND		hBtnZoom;						//	ズームボタンハンドル
	//----- ツールチップ情報 -----------------------------------------------------------------------------------//
	WCP			pToolTipTxt;						//	グラフィックのツールヒントメッセージ
	WCP			pChkBoxTool[AJC3DG_MAXITEM];		//	チェックボックスのツールヒントメッセージ
	BOOL		fShowAlways;						//	グラフィックのツールヒント表示条件
	BOOL		fChkBoxShowAlways[AJC3DG_MAXITEM];	//	チェックボックスのツールヒント表示条件
	//----- ドロップファイル名一時保留バッファ情報 -------------------------------------------------------------//
	HAJCRNG		hRngFile;						//	リングバッファハンドル
	UB			StaRngFile[1024];				//	スタティックリングバッファ
	//----- ドロップＤＩＲ名一時保留バッファ情報 ---------------------------------------------------------------//
	HAJCRNG		hRngDir;						//	リングバッファハンドル
	UB			StaRngDir[1024];				//	スタティックリングバッファ
	//----- タイトル文字列描画情報 -----------------------------------------------------------------------------//
	CTRL_TTLINFO TtlInfo;						//	タイトルビットマップ情報
	//----- 通知情報 -------------------------------------------------------------------------------------------//
	AJC3DVEC			NtcRotTheta;			//	視点ベクトル
	UI					NtcClrFact;				//	クリアーした内容
	AJC3DGRCLK			NtcRClk;				//	右クリック通知情報
	UI					NtcDirs;				//	ドロップしたディレクトリ数
	UI					NtcFiles;				//	ドロップしたファイル数
	AJC3DGPLOTLIST		PlotList;				//	プロットリスト情報
	//----- 描画時間計測情報 -----------------------------------------------------------------------------------//
	BOOL				fMesDrawEnable;			//	描画時間計測ポップアップメニューの許可／禁止
	HWND				hDlgMesDraw;			//	描画時間計測表示ダイアログ
	HAJCMESTIME			hMesDraw;				//	描画時間計測インスタンス
	AJCMSTINFO			MesDraw;				//	描画時間計測データ
	//----- テキスト描画情報 -----------------------------------------------------------------------------------//
	HFONT				hFontTxo;				//	テキスト描画フォント
	HAJCTXO				hTxo;					//	テキスト描画インスタンス
	UI					kAvlTxo;				//	テキスト描画ＡＶＬキー
	HAJCAVL				hAvlTxo;				//	テキス描画ＡＶＬ
} WRK3DGRAPH, *PWRK3DGRAPH;

//--------------------------------------------------------------------------------------------------------------//
//	グローバル変数																								//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	G3dClassMain;
extern	ATOM	G3dClassFilter;
extern	ATOM	G3dClassForMSIL;
extern	HFONT	G3dhMyFont;

//--------------------------------------------------------------------------------------------------------------//
//	サブ関数																									//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		G3dWndProcMain();
extern	WNDPROC		G3dWndProcFilt();
extern	WNDPROC		G3dWndProcMSIL();

extern	HWND	G3dCreateDlgSetRange(PWRK3DGRAPH pW);
extern	HWND	G3dCreateDlgSetPlane(PWRK3DGRAPH pW);
extern	HWND	G3dCreateWndFilter	(PWRK3DGRAPH pW, WCP pClsName);

//----- AjcCtrlG3dSubFunc.c ------------------------------------------------------------------------------------//
extern	BOOL	G3dSetCtrlProp(PWRK3DGRAPH pW, PCAJC3DGPROP pNew);
extern	BOOL	G3dSetBorderColor(PWRK3DGRAPH pW, COLORREF color);
extern	VO		G3dCnvAllPoints(PWRK3DGRAPH pW);
extern	VO		G3dCnv3dTo2d(PWRK3DGRAPH pW, PCAJC3DVEC p3D, LPPOINT p2D);
extern	int		G3dCnvValToX(PWRK3DGRAPH pW, double cent, double r, double val, BOOL fRev);
extern	int		G3dCnvValToY(PWRK3DGRAPH pW, double cent, double r, double val, BOOL fRev);
extern	VO		G3dSetAngleXY(PWRK3DGRAPH pW);
extern	VO		G3dSetAngleXZ(PWRK3DGRAPH pW);
extern	VO		G3dSetAngleYZ(PWRK3DGRAPH pW);
extern	VO		G3dSetAngle3D(PWRK3DGRAPH pW);

extern	PCROTPLANE	G3dIsAnglePlane	(PWRK3DGRAPH pW);
extern	BOOL		G3dIsAngleXY	(PWRK3DGRAPH pW);
extern	BOOL		G3dIsAngleXZ	(PWRK3DGRAPH pW);
extern	BOOL		G3dIsAngleYZ	(PWRK3DGRAPH pW);
extern	BOOL		G3dIsAngle3D	(PWRK3DGRAPH pW);

extern	VO		G3dSetScaleInfo(PWRK3DGRAPH pW);
extern	VO		G3dPlanePointTo3dPoint(PWRK3DGRAPH pW, PCAJC2DVEC p2d, PCAJC3DLVEC pCent, PCAJC3DVEC pBase, PAJC3DVEC p3dBuf);
extern	VO		G3dSet3dMode(PWRK3DGRAPH pW);
extern	VO		G3dSet2dMode(PWRK3DGRAPH pW);

//----- AjcCtrlG3dDrawImage.c ----------------------------------------------------------------------------------//
extern	VO		G3dDrawImage(PWRK3DGRAPH pW);

extern	BOOL	G3dMakeMetaBall(HWND hwnd, PCAJC3DVEC pCent, double rx, double ry, double rz, UI slice, UI stack,
									 UX cbp, BOOL (*cb)(PWRK3DGRAPH pW, PGI_ELPS pElps, UX cbp));
extern	VO		G3dMakeEllipseData(PWRK3DGRAPH pW, PCAJC2DVEC p2d, double rx, double ry,
															 PCAJC3DLVEC pCent, PCAJC3DVEC pBase, PGI_ELPS pBuf);

//----- AjcCtrlG3dDrawText.c -----------------------------------------------------------------------------------//
extern	VO		G3dDrawText(PWRK3DGRAPH pW);

