﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	任意の平面設定ダイアログ										//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(SetPlane);
static	VO	SetPlane(HWND hDlg);

//==============================================================================================================//
//																												//
//	任意の平面設定ダイアログ生成																				//
//																												//
//==============================================================================================================//
HWND	G3dCreateDlgSetPlane(PWRK3DGRAPH pW)
{
	HWND	rc = NULL;
	rc = (HWND)DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_G3DSETPLANE), pW->hMain, AJC_DLGPROC_NAME(SetPlane), (LPARAM)pW);
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	レンジ設定ダイアログプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetPlane, WM_INITDIALOG	)
{
	PWRK3DGRAPH	pW   = (PWRK3DGRAPH)lParam;
	HWND		hG2d = GetDlgItem(hDlg, IDC_G3D);
	UI			sty;
	UI			ixh, ixv;

	SetProp(hDlg, L"AjcG3dSetPlane", pW);
	AjcSetDlgItemStr(hDlg, IDC_GRP_HORI, LNGSEL(L"横方向にマッピングする軸", L"Axis to map horizontally"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_HXP , LNGSEL(L"Ｘ軸（昇順）", L"X-axis (ascending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_HYP , LNGSEL(L"Ｙ軸（昇順）", L"Y-axis (ascending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_HZP , LNGSEL(L"Ｚ軸（昇順）", L"Z-axis (ascending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_HXM , LNGSEL(L"Ｘ軸（降順）", L"X-axis (descending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_HYM , LNGSEL(L"Ｙ軸（降順）", L"Y-axis (descending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_HZM , LNGSEL(L"Ｚ軸（降順）", L"Z-axis (descending)"));
	AjcSetDlgItemStr(hDlg, IDC_GRP_VERT, LNGSEL(L"横方向にマッピングする軸", L"Axis to map vertically"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_VXP , LNGSEL(L"Ｘ軸（昇順）", L"X-axis (ascending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_VYP , LNGSEL(L"Ｙ軸（昇順）", L"Y-axis (ascending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_VZP , LNGSEL(L"Ｚ軸（昇順）", L"Z-axis (ascending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_VXM , LNGSEL(L"Ｘ軸（降順）", L"X-axis (descending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_VYM , LNGSEL(L"Ｙ軸（降順）", L"Y-axis (descending)"));
	AjcSetDlgItemStr(hDlg, IDC_RBT_VZM , LNGSEL(L"Ｚ軸（降順）", L"Z-axis (descending)"));

	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	if (pW->f2dMode) SetWindowText (hDlg, LNGSEL(L"平面のアングル設定", L"Set plane angle"));
	else             SetWindowText (hDlg, LNGSEL(L"任意の平面表示"    , L"View any plane" ));

	//	３Ｄグラフモード設定
	AjcG3dInitV(hG2d, NULL, NULL, NULL, (AJC3DGS_AXIS | AJC3DGS_SCALEVALUE | AJC3DGS_SCALE));

	//	２Ｄモード時
	if (pW->f2dMode) {
		//	表示サンプルのスタイル設定
		sty = (UI)MAjcGetWindowLong(hG2d, GWL_STYLE);
		sty |= (AJC3DGS_2DMODE | AJC3DGS_NOANGLE | AJC3DGS_NOFILTER);
		MAjcSetWindowLong(hG2d, GWL_STYLE, sty);
		//	Ｚ軸を無効化
		AjcEnableDlgItem(hDlg, IDC_RBT_HZP, FALSE);
		AjcEnableDlgItem(hDlg, IDC_RBT_HZM, FALSE);
		AjcEnableDlgItem(hDlg, IDC_RBT_VZP, FALSE);
		AjcEnableDlgItem(hDlg, IDC_RBT_VZM, FALSE);
	}
	//	３Ｄモード時
	else {
		//	表示サンプルのスタイル設定
		sty = (UI)MAjcGetWindowLong(hG2d, GWL_STYLE);
		sty |= (AJC3DGS_2DMODE | AJC3DGS_NOANGLE | AJC3DGS_NOFILTER | AJC3DGS_SHOWAXIS_Z);
		MAjcSetWindowLong(hG2d, GWL_STYLE, sty);
	}
	//	ポップアップメニュー禁止
	AjcG3dEnablePopupMenu(hG2d, FALSE);

	//	ラジオボタングループ化
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_HORI));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_VERT));

	//	ラジオボタン初期化
	AjcSetDlgItemUInt(hDlg, IDC_GRP_HORI, pW->PlaneAxisH);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_VERT, pW->PlaneAxisV);

	//	ラジオボタンダミークリック
	ixh = AjcGetDlgItemUInt(hDlg, IDC_GRP_HORI);
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_HORI, AJCRBTN_SELECT), ixh);
	ixv = AjcGetDlgItemUInt(hDlg, IDC_GRP_VERT);
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_VERT, AJCRBTN_SELECT), ixv);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetPlane, IDC_GRP_HORI	)
{
	SetPlane(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetPlane, IDC_GRP_VERT	)
{
	SetPlane(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetPlane, IDOK			)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)GetProp(hDlg, L"AjcG3dSetPlane");
	//	平面設定
	pW->PlaneAxisH = (AJCG3DAXIS_DIR)AjcGetDlgItemUInt(hDlg, IDC_GRP_HORI);
	pW->PlaneAxisV = (AJCG3DAXIS_DIR)AjcGetDlgItemUInt(hDlg, IDC_GRP_VERT);
	AjcG3dSetPlane(pW->hMain, pW->PlaneAxisH, pW->PlaneAxisV);
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetPlane, IDCANCEL		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)GetProp(hDlg, L"AjcG3dSetPlane");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SetPlane)
	AJC_DLGMAP_MSG(SetPlane, WM_INITDIALOG		)
	AJC_DLGMAP_CMD(SetPlane, IDC_GRP_HORI		)
	AJC_DLGMAP_CMD(SetPlane, IDC_GRP_VERT		)
	AJC_DLGMAP_CMD(SetPlane, IDOK				)
	AJC_DLGMAP_CMD(SetPlane, IDCANCEL			)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	サンプル図形表示																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPlane(HWND hDlg)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)GetProp(hDlg, L"AjcG3dSetPlane");
	HWND		hG2d = GetDlgItem(hDlg, IDC_G3D);
	UI			i;
	UI			id = 0;			//	平面種別（0:X-Y, 1:X-Z, 2:Y-Z）
	UI			ixh, ixv;		//	横軸，縦軸ラジオボタンの設定（0～5)
	UI			axh, axv;		//	横軸，縦軸（0;X, 1:Y, 2:Z）
	POINT		pt;
	double		t;
	AJC2DVEC	star[5];
	AJC3DVEC	vb[3] = {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};	//	ｘ軸方向のベクトル
	AJC3DLVEC	vh[3] = {{{0, 0, 0}, {0, 0, 1}}, {{0, 0, 0}, {0, 1, 0}}, {{0, 0, 0}, {1, 0, 0}}};	//	法線

	//	ラジオボタンの設定取得
	ixh = AjcGetDlgItemUInt(hDlg, IDC_GRP_HORI);
	ixv = AjcGetDlgItemUInt(hDlg, IDC_GRP_VERT);
	//	横軸，縦軸種別設定
	axh = ixh % 3;
	axv = ixv % 3;

	//	異なる軸選択ならば、サンプルの平面設定
	if  ((ixh % 3) != (ixv % 3)) {
		//	ＯＫボタン有効化
		AjcEnableDlgItem(hDlg, IDOK, TRUE);
		//	サンプルの平面設定
		AjcG3dSetPlane(hG2d, (AJCG3DAXIS_DIR)ixh, (AJCG3DAXIS_DIR)ixv);
		//	平面種別設定
		if      ((axh == 0 && axv == 1) || (axh == 1 && axv == 0)) id = 0;	//	X-Y平面
		else if ((axh == 0 && axv == 2) || (axh == 2 && axv == 0)) id = 1;	//	X-Z平面
		else                                                       id = 2;	//	Y-Z平面
		//	サンプル図形表示
		AjcG3dClearData(hG2d, 0);
		AjcG3dClearData(hG2d, 1);
		AjcG3dClearData(hG2d, 2);
		for (i = 0, t = AJC_PAI / 2.0; i < 5; i++, t += AJC_PAI / 2.5) {
			star[i].x = 0.5 + 0.2 * cos(t);
			star[i].y = 0.5 + 0.2 * sin(t);
		}
		AjcG3dDefPlaneV(hG2d, id, &vh[id], &vb[ixh % 3]);
		AjcG2dMoveToV(hG2d, id, &star[0]);
		AjcG2dLineToV(hG2d, id, &star[2]);
		AjcG2dLineToV(hG2d, id, &star[4]);
		AjcG2dLineToV(hG2d, id, &star[1]);
		AjcG2dLineToV(hG2d, id, &star[3]);
		AjcG2dLineToV(hG2d, id, &star[0]);
	}
	//	同じ軸選択ならば、ＯＫボタン無効化
	else {
		GetCursorPos(&pt);
		AjcTipTextShow(pt.x, pt.y + 16, LNGSEL(L"\x1b[31m同じ軸が選択されています。",
											   L"\x1B[31mSame axis is selected." ), 3000, NULL);
		AjcEnableDlgItem(hDlg, IDOK, FALSE);
	}

}
