﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	レンジ設定ダイアログ											//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(SetRange);

//==============================================================================================================//
//																												//
//	レンジ設定ダイアログ生成																					//
//																												//
//==============================================================================================================//
HWND	G3dCreateDlgSetRange(PWRK3DGRAPH pW)
{
	HWND	rc = NULL;
	rc = (HWND)DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_G3DSETRANGE), pW->hMain, AJC_DLGPROC_NAME(SetRange), (LPARAM)pW);
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	レンジ設定ダイアログプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, WM_INITDIALOG	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)lParam;

	SetProp(hDlg, L"AjcG3dSetRange", pW);

	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	SetWindowText (hDlg, LNGSEL(L"レンジ設定", L"Set Range"));
	AjcSetDlgItemStr(hDlg, IDC_G3DRBT_SETBYR, LNGSEL(L"中心位置と半径で設定", L"Set by center and radius"));
	AjcSetDlgItemStr(hDlg, IDC_G3DRBT_SETBYW, LNGSEL(L"各軸の範囲で設定"	, L"Set by axis width"		 ));
	AjcSetDlgItemStr(hDlg, IDOK 			, LNGSEL(L"ＯＫ"				, L"OK" 					 ));
	AjcSetDlgItemStr(hDlg, IDCANCEL 		, LNGSEL(L"キャンセル"			, L"Cancel" 				 ));

	AjcSetDlgItemChk (hDlg, IDC_G3DRBT_SETBYR, TRUE);
	AjcEnableDlgGroup(hDlg, IDC_G3DGRP_SETBYR, TRUE , TRUE );
	AjcEnableDlgGroup(hDlg, IDC_G3DGRP_SETBYW, FALSE, FALSE);

	if (pW->f2dMode) {
		EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZC), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZR), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZL), FALSE);
		EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZH), FALSE);
	}

	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_XC, pW->prop.Cent.x, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_YC, pW->prop.Cent.y, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_ZC, pW->prop.Cent.z, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_XR, pW->prop.xr	  , -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_YR, pW->prop.yr	  , -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_ZR, pW->prop.zr	  , -10);

	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_XL, pW->prop.Cent.x - pW->prop.xr, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_YL, pW->prop.Cent.y - pW->prop.yr, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_ZL, pW->prop.Cent.z - pW->prop.zr, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_XH, pW->prop.Cent.x + pW->prop.xr, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_YH, pW->prop.Cent.y + pW->prop.yr, -10);
	AjcSetDlgItemReal(hDlg, IDC_G3DTXT_ZH, pW->prop.Cent.z + pW->prop.zr, -10);


	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, WM_COMMAND	)
{
	BOOL		rc = FALSE;
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)GetProp(hDlg, L"AjcG3dSetRange");
	int			cmd = LOWORD(wParam);

	if (cmd == IDC_G3DRBT_SETBYR || cmd == IDC_G3DRBT_SETBYW) {
		if (HIWORD(wParam) == BN_CLICKED) {
			if (AjcGetDlgItemChk(hDlg, IDC_G3DRBT_SETBYR)) {
				AjcEnableDlgGroup(hDlg, IDC_G3DGRP_SETBYR, TRUE , TRUE );
				AjcEnableDlgGroup(hDlg, IDC_G3DGRP_SETBYW, FALSE, FALSE);
			}
			else {
				AjcEnableDlgGroup(hDlg, IDC_G3DGRP_SETBYR, TRUE , FALSE);
				AjcEnableDlgGroup(hDlg, IDC_G3DGRP_SETBYW, FALSE, TRUE );
			}
			if (pW->f2dMode) {
				EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZC), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZR), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZL), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_G3DTXT_ZH), FALSE);
			}
		}
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, IDOK			)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)GetProp(hDlg, L"AjcG3dSetRange");
	AJC3DGPROP	prop;
	double		xl, yl, zl, xh, yh, zh;

	memcpy(&prop, &pW->prop, sizeof(AJC3DGPROP));

	if (AjcGetDlgItemChk(hDlg, IDC_G3DRBT_SETBYR)) {
		prop.Cent.x = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_XC);
		prop.Cent.y = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_YC);
		prop.Cent.z = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_ZC);
		prop.xr		= AjcGetDlgItemReal(hDlg, IDC_G3DTXT_XR);
		prop.yr		= AjcGetDlgItemReal(hDlg, IDC_G3DTXT_YR);
		prop.zr		= AjcGetDlgItemReal(hDlg, IDC_G3DTXT_ZR);
	}
	else {
		xl = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_XL);
		yl = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_YL);
		zl = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_ZL);
		xh = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_XH);
		yh = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_YH);
		zh = AjcGetDlgItemReal(hDlg, IDC_G3DTXT_ZH);
		prop.Cent.x = (xl + xh) / 2.0;
		prop.Cent.y = (yl + yh) / 2.0;
		prop.Cent.z = (zl + zh) / 2.0;
		prop.xr		= fabs(xh - xl) / 2.0;
		prop.yr		= fabs(yh - yl) / 2.0;
		prop.zr		= fabs(zh - zl) / 2.0;
	}
	if (G3dSetCtrlProp(pW, &prop)) {
		if (pW->f2dMode) {
			UI	i;
			for (i = 0; i < AJC3DG_MAXITEM; i++) {
				pW->DatItem[i].PlnLVec.p.x = prop.Cent.x;
				pW->DatItem[i].PlnLVec.p.y = prop.Cent.y;
				pW->DatItem[i].PlnLVec.p.z = 0.0;
			}
		}
	}
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, IDCANCEL		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)GetProp(hDlg, L"AjcG3dSetRange");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SetRange)
	AJC_DLGMAP_MSG(SetRange, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(SetRange, WM_COMMAND			)
	AJC_DLGMAP_CMD(SetRange, IDOK				)
	AJC_DLGMAP_CMD(SetRange, IDCANCEL			)
AJC_DLGMAP_END
