﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	イメージ描画処理												//
//																												//
//**************************************************************************************************************//

#define	IX_X			0				//	Ｘ軸情報インデクス
#define	IX_Y			1				//	Ｙ　　〃
#define	IX_Z			2				//	Ｚ　　〃

#define	VTLIM	90.01					//	原点から手前側と奥側を識別する角度のしきい値

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DrawShpereScale(PWRK3DGRAPH pW, HDC hdc);
static	BOOL	CbDrawShpereScale(PWRK3DGRAPH pW, PGI_ELPS pElps, UX hdc);
static	VO		DrawScaleLine(PWRK3DGRAPH pW, HDC hdc);
static	VO		DrawRectScale(PWRK3DGRAPH pW, HDC hdc, UI ix1, UI ix2, UI ix3);
static	VO		DrawCirScale(PWRK3DGRAPH pW, HDC hdc, UI ix1, UI ix2, UI ix3);
static	VO		DrawAxis(PWRK3DGRAPH pW, HDC hdc);
static	VO		DrawData(PWRK3DGRAPH pW, HDC hdc);
static	VO		DrawPlot(PWRK3DGRAPH pW, HDC hdc);
static	VO		DrawScaleValXY(PWRK3DGRAPH pW, HDC hdc, PCROTPLANE p);
static	VO		DrawHoriScale(PWRK3DGRAPH pW, HDC hdc, PCAXIS_INF pAxi, BOOL fRev);
static	VO		DrawVertScale(PWRK3DGRAPH pW, HDC hdc, PCAXIS_INF pAxi, BOOL fRev);
static	VO		Draw3DimScale(PWRK3DGRAPH pW, HDC hdc, PCAXIS_INF pAxi);
static	VO		DrawBorder(PWRK3DGRAPH pW, HDC hdc);
static	VO		MakeScaleValueStr(PCAXIS_INF pAxi, double val, WCP pBuf, UI lBuf);
static	VO		SubSetPixel(PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, UI size, PRGBINFO pRgb);
static	VO		SubMoveTo  (PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb);
static	VO		SubLineTo  (PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb);
static	VO		SubMoveTo2 (PWRK3DGRAPH pW, HDC hdc, PCAJC3DVEC pv, LPPOINT pt, PRGBINFO pRgb);
static	VO		SubLineTo2 (PWRK3DGRAPH pW, HDC hdc, PCAJC3DVEC pv, LPPOINT pt, PRGBINFO pRgb);
static	VO		SubPolyToSet (PWRK3DGRAPH pW, PCGI_VEC p, PRGBINFO pRgb, PPOLYINFO pPol);
static	VO		SubPolyToDraw(PWRK3DGRAPH pW, HDC hdc, PPOLYINFO pPol);
static	VO		SubFillB(PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb, PRGBINFO pBorder);
static	VO		SubFillS(PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb);

//==============================================================================================================//
//																												//
//	イメージ描画																								//
//																												//
//==============================================================================================================//
VO		G3dDrawImage(PWRK3DGRAPH pW)
{
	HFONT		hFont;
	PCROTPLANE	pAnglePlane;

	//----- ラスタオペレーション設定 -------------------------//
	if (!(pW->style & AJC3DGS_NODEPTHCTRL)) {
		SetROP2(pW->mdc, R2_MASKPEN);
	}
	//----- 視点方向へのベクトル設定 -------------------------//
	pW->VSiten.x = 0.0; pW->VSiten.y = 0.0; pW->VSiten.z = 1.0;
	AjcV3dRotateX(&pW->VSiten, pW->prop.Rot.x, &pW->VSiten);
	AjcV3dRotateY(&pW->VSiten, pW->prop.Rot.y, &pW->VSiten);
	AjcV3dRotateZ(&pW->VSiten, pW->prop.Rot.z, &pW->VSiten);
	//----- スケール描画 -------------------------------------//
	if (pW->fReDrawScale) {
		RECT	r;
		//	スケールイメージ クリアー
		GetClientRect(pW->hMain, &r);
		FillRect(pW->sdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
		//	球体スケール描画
		if (pW->style & AJC3DGS_SPHERESCALE) DrawShpereScale(pW, pW->sdc);
		//	スケールライン描画
		DrawScaleLine (pW, pW->sdc);
		//	３軸描画
		DrawAxis(pW, pW->sdc);
		//	スケール再描画フラグクリアー
		pW->fReDrawScale = FALSE;
	}
	//----- 球形スケール, スケールライン, ３軸イメージコピー -//
	//		（白色部分を除いてコピー）
	TransparentBlt(pW->mdc, 0, 0, pW->ww, pW->wh, pW->sdc, 0, 0, pW->ww, pW->wh, RGB(255, 255, 255));
	//----- データ描画 ---------------------------------------//
	if (pW->fReDrawData) {
		RECT	r;
		//	データイメージ クリアー
		GetClientRect(pW->hMain, &r);
		FillRect(pW->ddc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
		//	データ描画
		DrawData(pW, pW->ddc);
		//	データ再描画フラグクリアー
		pW->fReDrawData = FALSE;
	}
	//----- データイメージコピー -----------------------------//
	//		（白色部分を除いてコピー）
	TransparentBlt(pW->mdc, 0, 0, pW->ww, pW->wh, pW->ddc, 0, 0, pW->ww, pW->wh, RGB(255, 255, 255));
	//----- プロットデータ描画 -------------------------------//
	DrawPlot(pW, pW->mdc);
	//----- スケール値描画 -----------------------------------//
	hFont = (HFONT)SelectObject(pW->mdc, G3dhMyFont);
	if (pW->fEnable) SetTextColor(pW->mdc, RGB(	 0,	  0,   0));
	else			 SetTextColor(pW->mdc, GetSysColor(COLOR_GRAYTEXT));
	SetBkMode(pW->mdc, TRANSPARENT);
	if (pAnglePlane = G3dIsAnglePlane(pW)) {
		if (pW->style & (AJC3DGS_SCALEVALUE_X | AJC3DGS_SCALEVALUE_Y)) {
			DrawScaleValXY(pW, pW->mdc, pAnglePlane);
		}
	}
	else {
		if (pW->style &  AJC3DGS_SCALEVALUE_X) Draw3DimScale(pW, pW->mdc, &pW->AxisInfo[IX_X]);
		if (pW->style &  AJC3DGS_SCALEVALUE_Y) Draw3DimScale(pW, pW->mdc, &pW->AxisInfo[IX_Y]);
		if (pW->style &  AJC3DGS_SCALEVALUE_Z) Draw3DimScale(pW, pW->mdc, &pW->AxisInfo[IX_Z]);
	}
	SelectObject(pW->mdc, hFont);
	//----- 外枠描画 -----------------------------------------//
	if (!(pW->style & AJC3DGS_NOBORDER)) DrawBorder(pW, pW->mdc);

	//----- ラスタオペレーション解除 -------------------------//
	if (!(pW->style & AJC3DGS_NODEPTHCTRL)) {
		SetROP2(pW->mdc, R2_COPYPEN);
	}
}
//----- 球形スケール表示 ---------------------------------------------------------------------------------------//
static	VO		DrawShpereScale(PWRK3DGRAPH pW, HDC hdc)
{
	HPEN	hPen;

	hPen = (HPEN)SelectObject(hdc, hPenScale);
	G3dMakeMetaBall(pW->hMain, &pW->prop.Cent, pW->prop.xr, pW->prop.yr, pW->prop.zr,
						G3D_SPHERE_SCALE_SLICE, G3D_SPHERE_SCALE_STACK, (UX)hdc, CbDrawShpereScale);
	SelectObject(hdc, hPen);
}
//--------------------------------------------------------------------------------------------------------------//
//	楕円球を構成する楕円の描画（コールバック）
static	BOOL	CbDrawShpereScale(PWRK3DGRAPH pW, PGI_ELPS pElps, UX hdc)
{
	UI		i;

	//	先頭ポイントへ移動
	SubMoveTo(pW, (HDC)hdc, &pElps->p[G3D_ELPSPOINTS-1], &pW->RgbScale);
	//	ポイント情報初期化
	pW->SphPolyInfo.ix	 = 0;					//	配列のインデクス（= 有効配列データ数）
	pW->SphPolyInfo.nArr = G3D_SPHERE_PTBUF;	//	最大配列要素数（確保した配列要素数）
	pW->SphPolyInfo.pPen = pW->clSphBuf;		//	PENオブジェクト配列
	pW->SphPolyInfo.pPt  = pW->ptSphBuf;		//	POINT配列
	//	ライン群描画
	for (i = 0; i < G3D_ELPSPOINTS; i++) {
		SubPolyToSet(pW, &pElps->p[i], &pW->RgbScale, &pW->SphPolyInfo);
	}
	SubPolyToDraw(pW, (HDC)hdc, &pW->SphPolyInfo);

	return TRUE;
}
//----- スケールライン描画 -------------------------------------------------------------------------------------//
static	VO		DrawScaleLine(PWRK3DGRAPH pW, HDC hdc)
{
	HPEN	hPen;

	hPen = (HPEN)SelectObject(hdc, hPenScale);
	if (pW->style & AJC3DGS_SCALE_XY) {
		if (pW->style & AJC3DGS_RECTSCALE) DrawRectScale(pW, hdc, IX_X, IX_Y, IX_Z);
		if (pW->style & AJC3DGS_ELPSSCALE) DrawCirScale (pW, hdc, IX_X, IX_Y, IX_Z);
	}
	if (pW->style & AJC3DGS_SCALE_XZ) {
		if (pW->style & AJC3DGS_RECTSCALE) DrawRectScale(pW, hdc, IX_X, IX_Z, IX_Y);
		if (pW->style & AJC3DGS_ELPSSCALE) DrawCirScale (pW, hdc, IX_X, IX_Z, IX_Y);
	}
	if (pW->style & AJC3DGS_SCALE_YZ) {
		if (pW->style & AJC3DGS_RECTSCALE) DrawRectScale(pW, hdc, IX_Y, IX_Z, IX_X);
		if (pW->style & AJC3DGS_ELPSSCALE) DrawCirScale (pW, hdc, IX_Y, IX_Z, IX_X);
	}
	SelectObject(hdc, hPen);
}
//----- 平面の方眼スケール描画 ---------------------------------------------------------------------------------//
static	VO		DrawRectScale(PWRK3DGRAPH pW, HDC hdc, UI ix1, UI ix2, UI ix3)
{
	PAXIS_INF	px = &pW->AxisInfo[ix1];
	PAXIS_INF	py = &pW->AxisInfo[ix2];
	PAXIS_INF	pz = &pW->AxisInfo[ix3];
	AJC3DVECU	vec;
	POINT		pt;

	vec.arr[pz->MyIx] = pz->Cent;

	vec.arr[px->MyIx] = px->Cent - px->r;
	vec.arr[py->MyIx] = py->Cent - py->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubMoveTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	vec.arr[py->MyIx] = py->Cent + py->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubLineTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	vec.arr[px->MyIx] = px->Cent + px->r;
	vec.arr[py->MyIx] = py->Cent - py->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubMoveTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	vec.arr[py->MyIx] = py->Cent + py->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubLineTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	for (vec.arr[px->MyIx] = px->Sif.min; vec.arr[px->MyIx] < px->Cent+px->r; vec.arr[px->MyIx] += px->Sif.step) {
		vec.arr[py->MyIx] = py->Cent - py->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubMoveTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
		vec.arr[py->MyIx] = py->Cent + py->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubLineTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	}

	vec.arr[py->MyIx] = py->Cent - py->r;
	vec.arr[px->MyIx] = px->Cent - px->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubMoveTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	vec.arr[px->MyIx] = px->Cent + px->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubLineTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	vec.arr[py->MyIx] = py->Cent + py->r;
	vec.arr[px->MyIx] = px->Cent - px->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubMoveTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	vec.arr[px->MyIx] = px->Cent + px->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubLineTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	for (vec.arr[py->MyIx] = py->Sif.min; vec.arr[py->MyIx] < py->Cent+py->r; vec.arr[py->MyIx] += py->Sif.step) {
		vec.arr[px->MyIx] = px->Cent - px->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubMoveTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
		vec.arr[px->MyIx] = px->Cent + px->r; G3dCnv3dTo2d(pW, &vec.s, &pt); SubLineTo2(pW, hdc, &vec.s, &pt, &pW->RgbScale);
	}
}
//----- 平面の同心楕円スケール描画 -----------------------------------------------------------------------------//
static	VO		DrawCirScale(PWRK3DGRAPH pW, HDC hdc, UI ix1, UI ix2, UI ix3)
{
	PAXIS_INF	px = &pW->AxisInfo[ix1];
	PAXIS_INF	py = &pW->AxisInfo[ix2];
	PAXIS_INF	pz = &pW->AxisInfo[ix3];
	AJC2DVEC	v2c;
	AJC3DVECU	vb;
	AJC3DLVECU	lv;
	double		rx, ry;
	UI			i, j, divx, divy, div;
	GI_ELPS		elps;

	v2c.x = 0.0;
	v2c.y = 0.0;
	memcpy(&lv.s.p, &pW->prop.Cent, sizeof(AJC3DVEC));
	lv.s.v.arr[ix1] = 0.0;
	lv.s.v.arr[ix2] = 0.0;
	lv.s.v.arr[ix3] = 1.0;
	vb.arr[ix1]		= 1.0;
	vb.arr[ix2]		= 0.0;
	vb.arr[ix3]		= 0.0;
	divx = (int)(fabs(px->Sif.max - px->Cent) / px->Sif.step);
	divy = (int)(fabs(py->Sif.max - py->Cent) / py->Sif.step);
	div	 = __min(divx, divy);
	for (i = 0, rx = px->Sif.step, ry = py->Sif.step; i < div; i++, rx += px->Sif.step, ry += py->Sif.step) {
		G3dMakeEllipseData(pW, &v2c, rx, ry, &lv.lv, &vb.s, &elps);
		SubMoveTo(pW, hdc, &elps.p[G3D_ELPSPOINTS-1], &pW->RgbScale);
		for (j = 0; j < G3D_ELPSPOINTS; j++) {
			SubLineTo(pW, hdc, &elps.p[j], &pW->RgbScale);
		}
	}
}
//----- ３軸描画 -----------------------------------------------------------------------------------------------//
static	VO		DrawAxis(PWRK3DGRAPH pW, HDC hdc)
{
	UI			i, msk;
	HBRUSH		hBru;
	HPEN		hPen;
	POINT		ptc;
	AJC3DVEC	v;

	//----- 中心位置の描画位置設定 -----------------------------------------------------------------------------//
	G3dCnv3dTo2d(pW, &pW->prop.Cent, &ptc);

	//----- ３軸描画 -------------------------------------------------------------------------------------------//
	for (i = 0, msk = AJC3DGS_SHOWAXIS_X; i < AJC3DG_MAXAXIS; i++, msk>>=1) {
		if (pW->style & msk) {
			//---- 低位→中心 -------------------------------------------------//
			AjcV3dSub(&pW->AxisInfo[i].s.v3, &pW->prop.Cent, &v);
			if (AjcV3dTheta(&pW->VSiten, &v) <= VTLIM) {
				hPen = (HPEN)SelectObject(hdc, pW->AxisInfo[i].RgbInfo.hPenP);
			}
			else {
				hPen = (HPEN)SelectObject(hdc, pW->AxisInfo[i].RgbInfo.hPenN);
			}
			MoveToEx(hdc, pW->AxisInfo[i].s.v2.x, pW->AxisInfo[i].s.v2.y, NULL);
			LineTo	(hdc, ptc.x					, ptc.y					);
			hPen = (HPEN)SelectObject(hdc, hPen);
			//----- 中心→高位 ------------------------------------------------//
			AjcV3dSub(&pW->AxisInfo[i].e.v3, &pW->prop.Cent, &v);
			if (AjcV3dTheta(&pW->VSiten, &v) <= VTLIM) {
				hPen = (HPEN  )SelectObject(hdc, pW->AxisInfo[i].RgbInfo.hPenP);
				hBru = (HBRUSH)SelectObject(hdc, pW->AxisInfo[i].RgbInfo.hBruP);
			}
			else {
				hPen = (HPEN  )SelectObject(hdc, pW->AxisInfo[i].RgbInfo.hPenN);
				hBru = (HBRUSH)SelectObject(hdc, pW->AxisInfo[i].RgbInfo.hBruN);
			}
			LineTo	(hdc, pW->AxisInfo[i].e.v2.x, pW->AxisInfo[i].e.v2.y);
			Ellipse (hdc, pW->AxisInfo[i].e.v2.x - 2, pW->AxisInfo[i].e.v2.y - 2,
						  pW->AxisInfo[i].e.v2.x + 2, pW->AxisInfo[i].e.v2.y + 2);
			hBru = (HBRUSH)SelectObject(hdc, hBru);
			hPen = (HPEN  )SelectObject(hdc, hPen);
		}
	}
}
//----- データ描画 ---------------------------------------------------------------------------------------------//
MAJCAVLPTR(GINODE, PPGI_INFO)

static	VO		DrawData(PWRK3DGRAPH pW, HDC hdc)
{
	UI			i, j, id, svid;
	HBRUSH		hBru, hBruP, hBruN;
	HPEN		hPen, hPenP, hPenN;
	UI			num;
	PCGINODE	pTop = (PCGINODE)AjcAvlCreatePtrArr(pW->hAvlDat, &num, FALSE);
	PCGINODE	pArr;
	PGI_INFO	p;

	if (pTop != NULL) {
		svid = -1;
		pArr = pTop;
		for (pArr = pTop, i = 0; i < num; i++, pArr++) {
			p  = *pArr->pNode;
			id = p->h.id;
			if (pW->MskFilt & (0x01 << id)) {
				//	id が変化したら、ペンとブラシオブジェクト再生成
				if (id != svid) {
					hBruP = pW->DatItem[id].RgbInfo.hBruP, hBruN = pW->DatItem[id].RgbInfo.hBruN;
					hPenP = pW->DatItem[id].RgbInfo.hPenP, hPenN = pW->DatItem[id].RgbInfo.hPenN;
					hBru = (HBRUSH)SelectObject(hdc, hBruP);
					hPen = (HPEN  )SelectObject(hdc, hPenP);
				}
				//	各種図形描画
				switch (p->h.gic) {
					case GIC_POINT:		//	●点描画
						SubSetPixel(pW, hdc, &p->poi.p, p->poi.siz, &pW->DatItem[id].RgbInfo);
						break;

					case GIC_LINE:		//	●ライン描画
						//	ライン描画
						SubMoveTo(pW, hdc, &p->line.p1, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->line.p2, &pW->DatItem[id].RgbInfo);
						//	矢印描画
						if (p->line.fArrow) {
							if (memcmp(&p->line.p1.v2, &p->line.p2.v2, sizeof(POINT)) != 0) {
								AJC2DVEC	va, vp, vm;
								double		len, ls, lw;
								POINT		vpi, vmi;
								//	p1 -> p2 ベクトル
								AjcVPtSub(&p->line.p2.v2, &p->line.p1.v2, &va);
								//	矢印の長さ設定
								len = AjcV2dLength(&va);
							//	AjcTrace("len = %f\n", len);
								if (len >= 10) {
									if		(len <= 10.0) {ls =  8; lw = 2;}
									else if (len <= 11.0) {ls =  9; lw = 2;}
									else if (len <= 12.0) {ls = 10; lw = 3;}
									else				  {ls = 11; lw = 3;}
									//	p1 -> p2 に直角なベクトル
									AjcV2dAnyOrthoVec(&va	 , &vp);
									AjcV2dNormal	 (&vp	 , &vp);
									AjcV2dMult		 (&vp, lw, &vp);
									AjcV2dMult		 (&vp, -1, &vm);
									//	矢印端点位置(vp, vm)設定
									if (len >= 10) {
										AjcV2dMult(&va, ((len - ls) / len), &va);
										AjcV2dAdd (&vp, &va, &vp);
										AjcV2dAdd (&vm, &va, &vm);
									}
									//	整数に変換
									AjcVPtSetIntVec(&vp, &vpi);
									AjcVPtSetIntVec(&vm, &vmi);
									//	実際のピクセル位置に変換
									vpi.x += p->line.p1.v2.x;  vpi.y += p->line.p1.v2.y;
									vmi.x += p->line.p1.v2.x;  vmi.y += p->line.p1.v2.y;
									//	矢印描画
									MoveToEx(hdc, vpi.x, vpi.y, NULL);
									LineTo	(hdc, p->line.p2.v2.x, p->line.p2.v2.y);
									LineTo	(hdc, vmi.x, vmi.y);
								}
							}
						}
						break;

					case GIC_TRIAN:		//	●三角形描画
						SubMoveTo(pW, hdc, &p->tri.p1, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->tri.p2, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->tri.p3, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->tri.p1, &pW->DatItem[id].RgbInfo);
						break;

					case GIC_SQUA:		//	●四角形描画
						SubMoveTo(pW, hdc, &p->squa.p1, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->squa.p2, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->squa.p3, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->squa.p4, &pW->DatItem[id].RgbInfo);
						SubLineTo(pW, hdc, &p->squa.p1, &pW->DatItem[id].RgbInfo);
						break;

					case GIC_ELPS:		//	●円／楕円描画
						SubMoveTo(pW, hdc, &p->elps.p[G3D_ELPSPOINTS-1], &pW->DatItem[id].RgbInfo);
						for (j = 0; j < G3D_ELPSPOINTS; j++) {
							SubLineTo(pW, hdc, &p->elps.p[j], &pW->DatItem[id].RgbInfo);
						}
						break;

					case GIC_FILL:		//	●塗りつぶし
						if (p->fill.idBorder == -1) SubFillS(pW, hdc, &p->fill.p, &pW->DatItem[id].RgbInfo);
						else						SubFillB(pW, hdc, &p->fill.p, &pW->DatItem[id].RgbInfo, &pW->DatItem[p->fill.idBorder].RgbInfo);
						break;
				}
				if (id != svid) {
					SelectObject(hdc, hBru);
					SelectObject(hdc, hPen);
				}
				svid = id;
			}
		}
		AjcAvlReleasePtrArr(pW->hAvlDat, (PCAJCAVLPTR)pTop);
	}
}
//----- プロット描画 -------------------------------------------------------------------------------------------//
static	VO		DrawPlot(PWRK3DGRAPH pW, HDC hdc)
{
	UI			i, j, ix, msk;
	HBRUSH		hBru;
	HPEN		hPen;
	POLYINFO	PolyInfo;

	for (i = 0, msk = 0x01; i < AJC3DG_MAXITEM; i++, msk <<= 1) {
		HBRUSH	hBruP = pW->DatItem[i].RgbInfo.hBruP, hBruN = pW->DatItem[i].RgbInfo.hBruN;
		HPEN	hPenP = pW->DatItem[i].RgbInfo.hPenP, hPenN = pW->DatItem[i].RgbInfo.hPenN;
		PGI_VEC	p = pW->DatItem[i].plot.pBuf;
		if ((pW->MskFilt & msk) && (pW->DatItem[i].plot.cnt > 0)) {
			//	PolylineTo用ポイントバッファ確保（確保失敗でも処理継続する為、malloc()で確保）
			HPEN	*pPen = (HPEN* )malloc(sizeof(HPEN ) * pW->DatItem[i].plot.cnt * 2);
			POINT	*pPt  = (POINT*)malloc(sizeof(POINT) * pW->DatItem[i].plot.cnt * 2);
			//	バッファ確保成功ならば PolylineTo モード
			BOOL	fPolyMode = (pPen != NULL && pPt != NULL);
			//	PolylineTo モード用バッファ情報初期化
			if (fPolyMode) {
				memset(&PolyInfo, 0, sizeof PolyInfo);
				PolyInfo.ix	  = 0;								//	配列のインデクス（= 有効配列データ数）
				PolyInfo.nArr = pW->DatItem[i].plot.cnt * 2;	//	最大配列要素数（確保した配列要素数）
				PolyInfo.pPen = pPen;
				PolyInfo.pPt  = pPt;
			}
			//	ブラシ，ペン退避
			hBru = (HBRUSH)SelectObject(hdc, pW->DatItem[i].RgbInfo.hBruP);
			hPen = (HPEN  )SelectObject(hdc, pW->DatItem[i].RgbInfo.hPenP);
			//	先頭プロットデータのインデクス設定
			if (pW->DatItem[i].plot.cnt < pW->prop.Item[i].MaxPlot) ix = 0;
			else													ix = pW->DatItem[i].plot.ix;
			//	先頭プロット点へ移動
			SubMoveTo(pW, hdc, &p[ix], &pW->DatItem[i].RgbInfo);
			//	２つ目～最終の直前プロット描画
			for (j = 1; j < pW->DatItem[i].plot.cnt - 1; j++) {
				SubSetPixel(pW, hdc, &p[ix], pW->prop.PlotSize, &pW->DatItem[i].RgbInfo);
				if (pW->prop.fPlotLine) {
					if (j == 0) {
						//	先頭プロット点へ移動
						SubMoveTo(pW, hdc, &p[ix], &pW->DatItem[i].RgbInfo);
					}
					else {
						if (fPolyMode) {
							//	PolylineToモードならば、プロット点を追加
							SubPolyToSet(pW, &p[ix], &pW->DatItem[i].RgbInfo, &PolyInfo);
						}
						else {
							//	LineToモードならば、LineToでライン描画
							SubLineTo(pW, hdc, &p[ix], &pW->DatItem[i].RgbInfo);
						}
					}
				}
				ix = ((ix + 1) % pW->prop.Item[i].MaxPlot);
			}
			//	最終プロット点描画
			SubSetPixel(pW, hdc, &p[ix], pW->prop.PlotSizeE, &pW->DatItem[i].RgbInfo);
			//	最終プロットライン描画
			if (pW->prop.fPlotLine) {
				if (fPolyMode) {
					//	PolylineToモードならば、最終プロット点を追加し、PolylineTo で描画
					SubPolyToSet (pW, &p[ix], &pW->DatItem[i].RgbInfo, &PolyInfo);
					SubPolyToDraw(pW, hdc,							   &PolyInfo);
				}
				else {
					//	LineToモードならば、LineToで最終ライン描画
					if (pW->prop.fPlotLine && pW->DatItem[i].plot.cnt > 1) {
						SubLineTo(pW, hdc, &p[ix], &pW->DatItem[i].RgbInfo);
					}
				}
			}
			//	ブラシ，ペン回復
			SelectObject(hdc, hBru);
			SelectObject(hdc, hPen);
			//	PolylineTo用ポイントバッファ解放
			if (pPen != NULL) free(pPen);
			if (pPt  != NULL) free(pPt );
		}
	}
}
//----- Ｘ，Ｙ軸スケールライン値描画 ---------------------------------------------------------------------------//
static	VO		DrawScaleValXY(PWRK3DGRAPH pW, HDC hdc, PCROTPLANE p)
{
	//	横軸の値描画
	if (pW->style &  AJC3DGS_SCALEVALUE_X) {
		switch (p->xDir) {
			case AJCG3DAXIS_DIR_XP: DrawHoriScale(pW, hdc, &pW->AxisInfo[IX_X], FALSE); break;		//	Ｘ軸昇順
			case AJCG3DAXIS_DIR_XM: DrawHoriScale(pW, hdc, &pW->AxisInfo[IX_X], TRUE ); break;		//	 〃 降順
			case AJCG3DAXIS_DIR_YP: DrawHoriScale(pW, hdc, &pW->AxisInfo[IX_Y], FALSE); break;		//	Ｙ軸昇順
			case AJCG3DAXIS_DIR_YM: DrawHoriScale(pW, hdc, &pW->AxisInfo[IX_Y], TRUE ); break;		//	 〃 降順
			case AJCG3DAXIS_DIR_ZP: DrawHoriScale(pW, hdc, &pW->AxisInfo[IX_Z], FALSE); break;		//	Ｚ軸昇順
			case AJCG3DAXIS_DIR_ZM: DrawHoriScale(pW, hdc, &pW->AxisInfo[IX_Z], TRUE ); break;		//	 〃 降順
		}
	}
	//	縦軸の値描画
	if (pW->style &  AJC3DGS_SCALEVALUE_Y) {
		switch (p->yDir) {
			case AJCG3DAXIS_DIR_XP: DrawVertScale(pW, hdc, &pW->AxisInfo[IX_X], FALSE); break;		//	Ｘ軸昇順
			case AJCG3DAXIS_DIR_XM: DrawVertScale(pW, hdc, &pW->AxisInfo[IX_X], TRUE ); break;		//	 〃 降順
			case AJCG3DAXIS_DIR_YP: DrawVertScale(pW, hdc, &pW->AxisInfo[IX_Y], FALSE); break;		//	Ｙ軸昇順
			case AJCG3DAXIS_DIR_YM: DrawVertScale(pW, hdc, &pW->AxisInfo[IX_Y], TRUE ); break;		//	 〃 降順
			case AJCG3DAXIS_DIR_ZP: DrawVertScale(pW, hdc, &pW->AxisInfo[IX_Z], FALSE); break;		//	Ｚ軸昇順
			case AJCG3DAXIS_DIR_ZM: DrawVertScale(pW, hdc, &pW->AxisInfo[IX_Z], TRUE ); break;		//	 〃 降順
		}
	}
}
//----- 水平スケール値描画 -------------------------------------------------------------------------------------//
static	VO		DrawHoriScale(PWRK3DGRAPH pW, HDC hdc, PCAXIS_INF pAxi, BOOL fRev)
{
	double	val, step;
	int		xlmin, xl, xr, x, y, n, stl, max=0;
	WC		txt[64];

	y = (int)((double)pW->wh - ((double)pW->wh / 2) * (1.0 - pW->prop.ratio));
	y = __min(y, (int)(pW->wh - (pW->SifCyChar + 1)));
	//----- ステップ値算出 --------------------------------------------------------//
	for (val = pAxi->Sif.min; val <= pAxi->Sif.max; val += pAxi->Sif.step) {
		MakeScaleValueStr(pAxi, val, txt, AJCTSIZE(txt));
		stl = (int)wcslen(txt);
		stl += (stl / 2);
		max = __max(stl, max);
	}
	n = G3dCnvValToX(pW, pAxi->Cent, pAxi->r, pAxi->Sif.step, fRev) - G3dCnvValToX(pW, pAxi->Cent, pAxi->r, 0.0, fRev);
	if (n != 0) {
		n = (max * pW->SifCxChar) / n + (((max * pW->SifCxChar) % n) != 0);
		if (n != 0) step = pAxi->Sif.step * n;
		else		step = pAxi->Sif.step;
	}
	else step = pAxi->Sif.step;
	//----- スケール値描画 --------------------------------------------------------//
	xlmin = (int)((double)pW->ww * (1.0 - pW->prop.ratio) / 2.0);
	for (val = pAxi->Sif.min; val <= pAxi->Sif.max; val += step) {
		MakeScaleValueStr(pAxi, val, txt, AJCTSIZE(txt));
		stl = (int)wcslen(txt);
		x = G3dCnvValToX(pW, pAxi->Cent, pAxi->r, val, fRev);
		xl = x - (stl * pW->SifCxChar / 2);
		xr = x + (stl * pW->SifCxChar / 2);
		if (xl > xlmin && xr < (int)pW->ww) {
			TextOut(hdc, xl, y, txt, stl);
		}
	}
}
//----- 垂直スケール値描画 -------------------------------------------------------------------------------------//
static	VO		DrawVertScale(PWRK3DGRAPH pW, HDC hdc, PCAXIS_INF pAxi, BOOL fRev)
{
	double	val;
	int		x, y=0, yt, yb, stl, exl;
	BOOL	first = TRUE;
	WC		txt[64];

	x = (int)((pW->ww / 2) * (1.0 - pW->prop.ratio));
	for (val = pAxi->Sif.min; val <= pAxi->Sif.max; val += pAxi->Sif.step) {
		MakeScaleValueStr(pAxi, val, txt, AJCTSIZE(txt));
		stl = (int)wcslen(txt);
		if (first) {
			first = FALSE;
			exl = (stl * (pW->SifCxChar));
			x -= exl;
			x = __max(x, 2);
		}
		y = G3dCnvValToY(pW, pAxi->Cent, pAxi->r, val, fRev);
		yt = y - pW->SifCyChar / 2;
		yb = y + pW->SifCyChar / 2;
		if (yt >= 0	 &&	 yb < (int)(pW->wh - pW->SifCyChar * 2)) {
			TextOut(hdc, x, yt, txt, stl);
		}
	}
}
//----- ３Ｄスケール値描画 -------------------------------------------------------------------------------------//
static	VO		Draw3DimScale(PWRK3DGRAPH pW, HDC hdc, PCAXIS_INF pAxi)
{
	POINT		ptMin, ptMax;
	UI			i, stl;
	AJC3DVECU	vmin, vmax;
	WC			txt[64];

	for (i = 0; i < 3; i++) {
		vmin.arr[i] = pW->AxisInfo[i].Cent;
		vmax.arr[i] = pW->AxisInfo[i].Cent;
	}
	vmin.arr[pAxi->MyIx] = pAxi->Cent - pAxi->r;
	vmax.arr[pAxi->MyIx] = pAxi->Cent + pAxi->r;
	G3dCnv3dTo2d(pW, &vmin.s, &ptMin);
	G3dCnv3dTo2d(pW, &vmax.s, &ptMax);

	if ((UI)abs(ptMin.x - ptMax.x) > pW->SifCxChar * 10	 ||	 (UI)abs(ptMin.y - ptMax.y) > pW->SifCyChar * 2) {
		MakeScaleValueStr(pAxi, pAxi->Cent - pAxi->r, txt, AJCTSIZE(txt));
		stl = (int)wcslen(txt);
	//	TextOut(hdc, ptMin.x - (stl * pW->SifCxChar) / 2, ptMin.y - pW->SifCyChar / 2, txt, stl); // 中心を合わせる
		TextOut(hdc, ptMin.x, ptMin.y, txt, stl);

		MakeScaleValueStr(pAxi, pAxi->Cent + pAxi->r, txt, AJCTSIZE(txt));
		stl = (int)wcslen(txt);
	//	TextOut(hdc, ptMax.x - (stl * pW->SifCxChar) / 2, ptMax.y - pW->SifCyChar / 2, txt, stl); //  中心を合わせる
		TextOut(hdc, ptMax.x, ptMax.y, txt, stl);
	}
}
//----- 外枠表示 -----------------------------------------------------------------------------------------------//
static	VO		DrawBorder(PWRK3DGRAPH pW, HDC hdc)
{
	HBRUSH	hBru;
	HPEN	hPen;

	if (pW->fEnable) hPen = (HPEN)SelectObject(hdc, pW->hPenBorder);
	else			 hPen = (HPEN)SelectObject(hdc, hPenGrayText);
	hBru = (HBRUSH)SelectObject(hdc, (HBRUSH)GetStockObject(NULL_BRUSH));
	Rectangle(hdc, 0, 0, pW->ww, pW->wh);
	SelectObject(hdc, hBru);
	SelectObject(hdc, hPen);
}
//----- スケール値文字列生成 -----------------------------------------------------------------------------------//
static	VO		MakeScaleValueStr(PCAXIS_INF pAxi, double val, WCP pBuf, UI lBuf)
{
	if (pAxi->Sif.digit + pAxi->Sif.prec > 7)
		AjcSnPrintF(pBuf, lBuf, L"%.*G", pAxi->Sif.digit + pAxi->Sif.prec, val);
	else
		AjcSnPrintF(pBuf, lBuf, L"%*.*f", pAxi->Sif.digit + pAxi->Sif.prec + 3, pAxi->Sif.prec, val);
}
//----- ピクセル描画サブルーチン -------------------------------------------------------------------------------//
static	VO		SubSetPixel(PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, UI size, PRGBINFO pRgb)
{
	AJC3DVEC	v;
	double		t;

	AjcV3dSub(&p->v3, &pW->prop.Cent, &v);
	t = AjcV3dTheta(&pW->VSiten, &v);

	if (size <= 1) {
		if (t <= VTLIM || (pW->style & AJC3DGS_NODEPTHCTRL)) 
			SetPixel(hdc, p->v2.x, p->v2.y, pRgb->RgbP);
		else
			SetPixel(hdc, p->v2.x, p->v2.y, pRgb->RgbN);
	}
	else {
		if (t <= VTLIM || (pW->style & AJC3DGS_NODEPTHCTRL)) {
			SelectObject(hdc, pRgb->hBruP);
			SelectObject(hdc, pRgb->hPenP);
		}
		else {
			SelectObject(hdc, pRgb->hBruN);
			SelectObject(hdc, pRgb->hPenN);
		}
		Ellipse (hdc, p->v2.x - size, p->v2.y - size, p->v2.x + size, p->v2.y + size);
	}
}
//----- ライン描画サブルーチン(MoveTo) -------------------------------------------------------------------------//
static	VO		SubMoveTo  (PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb)
{
	AJC3DVEC	v;

	AjcV3dSub(&p->v3, &pW->prop.Cent, &v);
	pRgb->t = AjcV3dTheta(&pW->VSiten, &v);
	memcpy(&pRgb->gv, p, sizeof pRgb->gv);

	MoveToEx(hdc, p->v2.x, p->v2.y, NULL);
}
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubMoveTo2(PWRK3DGRAPH pW, HDC hdc, PCAJC3DVEC pv, LPPOINT pt, PRGBINFO pRgb)
{
	GI_VEC	gv;

	memcpy(&gv.v3, pv, sizeof gv.v3);
	memcpy(&gv.v2, pt, sizeof gv.v2);
	SubMoveTo(pW, hdc, &gv, pRgb);
}
//----- ライン描画サブルーチン(LineTo) -------------------------------------------------------------------------//
static	VO		SubLineTo  (PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb)
{
	AJC3DVEC	v;
	double		t1 = pRgb->t;
	double		t2;
	GI_VEC		pc;
	AJC3DLVEC	lv;
	AJC3DVEC	p1, p2;
	double		L1, L2;

	AjcV3dSub(&p->v3, &pW->prop.Cent, &v);
	t2 = AjcV3dTheta(&pW->VSiten, &v);

	if		((t1 <= VTLIM && t2 <= VTLIM) || (pW->style & AJC3DGS_NODEPTHCTRL)) {	//	ライン両端はいずれも原点の前面／深さ表現無し？
		SelectObject(hdc, pRgb->hPenP);
		LineTo(hdc, p->v2.x, p->v2.y);
	}
	else if (t1	 > VTLIM && t2	> VTLIM) {											//	ライン両端はいずれも原点の向こう側？
		SelectObject(hdc, pRgb->hPenN);
		LineTo(hdc, p->v2.x, p->v2.y);
	}
	else {																			//	ライン両端は原点をまたぐ？
		memcpy(&lv.p, &pW->prop.Cent, sizeof lv.p);
		memcpy(&lv.v, &pW->VSiten	, sizeof lv.v);
		AjcV3dCrossP2F(&lv, &pRgb->gv.v3, &p1);
		AjcV3dCrossP2F(&lv, &p->v3	, &p2);
		L1 = AjcV3dDistP2P(&pRgb->gv.v3, &p1);
		L2 = AjcV3dDistP2P(&p->v3	   , &p2);
		memcpy(&pc.v3, &p1, sizeof pc.v3);
		AjcV3dSub(&p2, &pc.v3, &pc.v3);
		AjcV3dMult(&pc.v3, L1 / (L1 + L2), &pc.v3);
		AjcV3dAdd(&pc.v3, &p1, &pc.v3);
		G3dCnv3dTo2d(pW, &pc.v3, &pc.v2);
		if (t1 <= VTLIM) {		//	前面から向う側へのライン？
			if (L1 != 0.0) {
				SelectObject(hdc, pRgb->hPenP);
				LineTo(hdc, pc.v2.x, pc.v2.y);
			}
			SelectObject(hdc, pRgb->hPenN);
			LineTo(hdc, p->v2.x, p->v2.y);
		}
		else {					//	向う側から前面へのライン？
			if (L1 != 0) {
				SelectObject(hdc, pRgb->hPenN);
				LineTo(hdc, pc.v2.x, pc.v2.y);
			}
			SelectObject(hdc, pRgb->hPenP);
			LineTo(hdc, p->v2.x, p->v2.y);
		}
	}

	memcpy(&pRgb->gv, p, sizeof pRgb->gv);
	pRgb->t = t2;
}
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubLineTo2(PWRK3DGRAPH pW, HDC hdc, PCAJC3DVEC pv, LPPOINT pt, PRGBINFO pRgb)
{
	GI_VEC	gv;

	memcpy(&gv.v3, pv, sizeof gv.v3);
	memcpy(&gv.v2, pt, sizeof gv.v2);
	SubLineTo(pW, hdc, &gv, pRgb);
}
//----- ライン描画サブルーチン(PolyLineTo 用のポイント情報設定) ------------------------------------------------//
static	VO		SubPolyToSet  (PWRK3DGRAPH pW, PCGI_VEC p, PRGBINFO pRgb, PPOLYINFO pPol)
{
	AJC3DVEC	v;
	double		t1 = pRgb->t;
	double		t2;
	GI_VEC		pc;
	AJC3DLVEC	lv;
	AJC3DVEC	p1, p2;
	double		L1, L2;

	AjcV3dSub(&p->v3, &pW->prop.Cent, &v);
	t2 = AjcV3dTheta(&pW->VSiten, &v);

	if		((t1 <= VTLIM && t2 <= VTLIM) || (pW->style & AJC3DGS_NODEPTHCTRL)) {	//	ライン両端はいずれも原点の前面／深さ表現無し？
		if (pPol->ix < pPol->nArr) {
			pPol->pPen[pPol->ix]   = pRgb->hPenP;
			pPol->pPt [pPol->ix].x = p->v2.x;
			pPol->pPt [pPol->ix].y = p->v2.y;
			pPol->ix++;
		}
	}
	else if (t1	 > VTLIM && t2	> VTLIM) {											//	ライン両端はいずれも原点の向こう側？
		if (pPol->ix < pPol->nArr) {
			pPol->pPen[pPol->ix]   = pRgb->hPenN;
			pPol->pPt [pPol->ix].x = p->v2.x;
			pPol->pPt [pPol->ix].y = p->v2.y;
			pPol->ix++;
		}
	}
	else {																			//	ライン両端は原点をまたぐ？
		memcpy(&lv.p, &pW->prop.Cent, sizeof lv.p);
		memcpy(&lv.v, &pW->VSiten	, sizeof lv.v);
		AjcV3dCrossP2F(&lv, &pRgb->gv.v3, &p1);
		AjcV3dCrossP2F(&lv, &p->v3	, &p2);
		L1 = AjcV3dDistP2P(&pRgb->gv.v3, &p1);
		L2 = AjcV3dDistP2P(&p->v3	   , &p2);
		memcpy(&pc.v3, &p1, sizeof pc.v3);
		AjcV3dSub(&p2, &pc.v3, &pc.v3);
		AjcV3dMult(&pc.v3, L1 / (L1 + L2), &pc.v3);
		AjcV3dAdd(&pc.v3, &p1, &pc.v3);
		G3dCnv3dTo2d(pW, &pc.v3, &pc.v2);
		if (t1 <= VTLIM) {		//	前面から向う側へのライン？
			if (L1 != 0.0) {
				if (pPol->ix < pPol->nArr) {
					pPol->pPen[pPol->ix]   = pRgb->hPenP;
					pPol->pPt [pPol->ix].x = pc.v2.x;
					pPol->pPt [pPol->ix].y = pc.v2.y;
					pPol->ix++;
				}
			}
			if (pPol->ix < pPol->nArr) {
				pPol->pPen[pPol->ix]   = pRgb->hPenN;
				pPol->pPt [pPol->ix].x = p->v2.x;
				pPol->pPt [pPol->ix].y = p->v2.y;
				pPol->ix++;
			}
		}
		else {					//	向う側から前面へのライン？
			if (L1 != 0) {
				if (pPol->ix < pPol->nArr) {
					pPol->pPen[pPol->ix]   = pRgb->hPenN;
					pPol->pPt [pPol->ix].x = pc.v2.x;
					pPol->pPt [pPol->ix].y = pc.v2.y;
					pPol->ix++;
				}
			}
			if (pPol->ix < pPol->nArr) {
				pPol->pPen[pPol->ix]   = pRgb->hPenP;
				pPol->pPt [pPol->ix].x = p->v2.x;
				pPol->pPt [pPol->ix].y = p->v2.y;
				pPol->ix++;
			}
		}
	}

	memcpy(&pRgb->gv, p, sizeof pRgb->gv);
	pRgb->t = t2;
}
//----- ライン描画サブルーチン(ライン群の描画) -----------------------------------------------------------------//
static	VO		SubPolyToDraw  (PWRK3DGRAPH pW, HDC hdc, PPOLYINFO pPol)
{
	UI	i, j, n;

	for (i = 0; i < pPol->ix;) {
		//	同一色の範囲(個数)を設定
		for (j = i + 1, n = 1; j < pPol->ix && pPol->pPen[i] == pPol->pPen[j]; j++) {
			n++;
		}
		//	同一色のライン群を描画
		SelectObject(hdc, pPol->pPen[i]);
		PolylineTo(hdc, &pPol->pPt[i], n);
		i = j;
	}
}
//----- 塗りつぶし描画サブルーチン(Fill) -----------------------------------------------------------------------//
static	VO		SubFillB(PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb, PRGBINFO pBorder)
{
	SelectObject(hdc, pRgb->hBruP);
	ExtFloodFill(hdc, p->v2.x, p->v2.y, pBorder->RgbP, FLOODFILLBORDER);		//	閉領域の塗りつぶし
}
//----- 塗りつぶし描画サブルーチン(Fill) -----------------------------------------------------------------------//
static	VO		SubFillS(PWRK3DGRAPH pW, HDC hdc, PCGI_VEC p, PRGBINFO pRgb)
{
	SelectObject(hdc, pRgb->hBruP);
	ExtFloodFill(hdc, p->v2.x, p->v2.y, RGB(255, 255, 255), FLOODFILLSURFACE);	//	白色部分の塗りつぶし
}
//==============================================================================================================//
//	楕球データ生成																								//
//																												//
//	引　数	：	pCent		- 中心位置																			//
//				rx, ry, rz	- 楕球の半径																		//
//				slice		- 水平分割数																		//
//				stack		- 垂直分割数																		//
//				cb			- 楕球を構成する楕円データを通知するコールバック関数								//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
BOOL	G3dMakeMetaBall(HWND hwnd, PCAJC3DVEC pCent, double rx, double ry, double rz, UI slice, UI stack,
									 UX cbp, BOOL (*cb)(PWRK3DGRAPH pW, PGI_ELPS pElps, UX cbp))
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	BOOL		rc = TRUE;
	AJC3DLVEC	vc;
	AJC3DVEC	vb;
	AJC2DVEC	vz;
	double		step, t, s, e, x, y, drx, dry;
	GI_ELPS		elps;
	UI			i;

	if (slice >= 2 && stack >= 2) {
		vz.x = 0.0; vz.y = 0.0;
		memcpy(&vc.p, pCent, sizeof(AJC3DVEC));
		//----- 縦割り楕円描画 ----------------------------//
		vc.v.z = 0.0;
		vb.x = 0.0; vb.y = 0.0; vb.z = 1.0;
		step = AJC_PAI / (double)stack;
		for (t = 0, i = 0; t < (AJC_PAI - 0.00001); t += step, i++) {
			x = rx * cos(t + (AJC_PAI / 2.0));
			y = ry * sin(t + (AJC_PAI / 2.0));
			dry = sqrt(x * x + y * y);
			vc.v.x =  y;
			vc.v.y = -x;
			G3dMakeEllipseData(pW, &vz, rz, dry, &vc, &vb, &elps);
			rc &= cb(pW, &elps, cbp);
		}
		//----- 横割り楕円描画 ----------------------------//
		vb.x   = 1.0; vb.y	 = 0.0; vb.z   = 0.0;
		vc.v.x = 0.0; vc.v.y = 0.0; vc.v.z = 1.0;
		step = rz * 2 / (double)slice;
		s = pCent->z - rz + step;
		e = pCent->z + rz - (step / 2);
		for (vc.p.z = s; vc.p.z < e; vc.p.z += step) {
			double ratio = sin(acos((vc.p.z - pCent->z) / rz));
			drx = rx * ratio;
			dry = ry * ratio;
			G3dMakeEllipseData(pW, &vz, drx, dry, &vc, &vb, &elps);
			rc &= cb(pW, &elps, cbp);
		}
	}
	else rc = FALSE;

	return	rc;
}
//==============================================================================================================//
//	平面上の楕円描画データ生成																					//
//																												//
//	引　数	：	p2d			- 楕円の中心																		//
//				rx, ry		- 楕円のＸ／Ｙ半径																	//
//				pCent		- 平面上の中心位置と法線															//
//				pBase		- 基準軸の単位ベクトル																//
//				pBuf		- 楕円描画データ格納バッファ														//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
VO	G3dMakeEllipseData(PWRK3DGRAPH pW, PCAJC2DVEC p2d, double rx, double ry,
															 PCAJC3DLVEC pCent, PCAJC3DVEC pBase, PGI_ELPS pBuf)
{
	AJC2DVEC	v2d;
	double		step, t;
	UI			i;

//	pBuf->h.gic = GIC_ELPS;
//	pBuf->h.seq = pW->DatSeq++;
	step = (AJC_PAI * 2.0) / (double)G3D_ELPSPOINTS;
	for (i = 0, t = 0.0; i < G3D_ELPSPOINTS; i++, t += step) {
		v2d.x = rx * cos(t) + p2d->x;
		v2d.y = ry * sin(t) + p2d->y;
		G3dPlanePointTo3dPoint(pW, &v2d, pCent, pBase, &pBuf->p[i].v3);
		G3dCnv3dTo2d(pW, &pBuf->p[i].v3, &pBuf->p[i].v2);
	}
}


