﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	テキスト描画処理												//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbNtcNode(UX key, VOP pNodeData, UI len, UI nest, UX cbp);

//==============================================================================================================//
//																												//
//	テキスト描画																								//
//																												//
//==============================================================================================================//
VO		G3dDrawText(PWRK3DGRAPH pW)
{
	UI		i;

	if (AjcAvlGetCount(pW->hAvlTxo) != 0) {
		HFONT	hFontSv;
		if (hFontSv = SelectObject(pW->mdc, pW->hFontTxo)) {
			if (pW->hTxo = AjcTxoCreate(pW->mdc, 0, 0, -10)) {
				for (i = 0; i < 8; i++) {
					AjcTxoSetPaletteItem(pW->hTxo, i, pW->prop.Item[i].rgbP);
				}
				AjcTxoSetDcBmpSize(pW->hTxo, pW->ww, pW->wh);
				AjcAvlEnumNodesEx(pW->hAvlTxo, (UX)pW, cbNtcNode, FALSE);
				AjcTxoDelete(pW->hTxo, TRUE);
				pW->hTxo = NULL;
			}
			SelectObject(pW->mdc, hFontSv);
		}
	}
}


//--------------------------------------------------------------------------------------------------------------//
//	ＡＶＬノード通知																							//
//--------------------------------------------------------------------------------------------------------------//
#define		MRG		5

static	BOOL CALLBACK cbNtcNode(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	PWRK3DGRAPH	pW    = (PWRK3DGRAPH)cbp;
	PG3DTXO		pNode = (PG3DTXO)pNodeData;

	if (pNode->fPix) {
		AjcTxoTextOutEx(pW->hTxo, pNode->u.pt.x, pNode->u.pt.y, pNode->txt);
	}
	else {
		SIZE	sz;
		POINT	pt;
		AjcTxoGetExtent(pW->hTxo, pNode->txt, &sz);
		G3dCnv3dTo2d(pW, &pNode->u.v, &pt);
		switch (pNode->md) {
			case AJCG3DTXOMD_RIGHT:					//	点の右側
				AjcTxoTextOutEx(pW->hTxo, pt.x + MRG,
										  pt.y - (sz.cy / 2),
										  pNode->txt);
				break;
			case AJCG3DTXOMD_LEFT:					//	点の左側
				AjcTxoTextOutEx(pW->hTxo, pt.x - sz.cx - MRG,
										  pt.y - (sz.cy / 2),
										  pNode->txt);
				break;
			case AJCG3DTXOMD_CENTER:				//	点の中央
				AjcTxoTextOutEx(pW->hTxo, pt.x - (sz.cx / 2),
										  pt.y - (sz.cy / 2),
										  pNode->txt);
				break;
			case AJCG3DTXOMD_BELLOW_RIGHT:			//	点の下の右側
				AjcTxoTextOutEx(pW->hTxo, pt.x,
										  pt.y + MRG,
										  pNode->txt);
				break;
			case AJCG3DTXOMD_BELLOW_LEFT:			//	点の下の左側
				AjcTxoTextOutEx(pW->hTxo, pt.x - sz.cx,
										  pt.y + MRG,
										  pNode->txt);
				break;
			case AJCG3DTXOMD_BELLOW_CENTER:			//	点の下の中央
				AjcTxoTextOutEx(pW->hTxo, pt.x - sz.cx / 2,
										  pt.y + MRG,
										  pNode->txt);
				break;
			case AJCG3DTXOMD_ABOVE_RIGHT:			//	点の上の右側
				AjcTxoTextOutEx(pW->hTxo, pt.x,
										  pt.y - (sz.cy + MRG),
										  pNode->txt);
				break;
			case AJCG3DTXOMD_ABOVE_LEFT:			//	点の上の左側
				AjcTxoTextOutEx(pW->hTxo, pt.x - sz.cx,
										  pt.y - (sz.cy + MRG),
										  pNode->txt);
				break;
			case AJCG3DTXOMD_ABOVE_CENTER:			//	点の上の中央
				AjcTxoTextOutEx(pW->hTxo, pt.x - sz.cx / 2,
										  pt.y - (sz.cy + MRG),
										  pNode->txt);
				break;
		}
	}

	return TRUE;
}
