﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	ＭＳＩＬ(.NET Framework)対応処理								//
//																												//
//**************************************************************************************************************//
#define	IDC_PARENT	5000
#define	IDC_CTRL	5001

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//	サブ関数																									//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(MSIL);

//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hCtrl;			//	３Ｄグラフウインド
	VO (CALLBACK *cbFileDrop)(UI n	 );
	VO (CALLBACK *cbDirDrop )(UI n	 );
	VO (CALLBACK *cbRClick	)(int x, int y, BOOL shift, BOOL ctrl);
	VO (CALLBACK *cbPltLst	)(int max, int num, PAJC3DGPLITEM pItem);
} WKMSIL, *PWKMSIL;

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		G3dWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}

//==============================================================================================================//
//																												//
//	コントロールウインド生成																					//
//																												//
//==============================================================================================================//
AJCEXPORT HWND WINAPI AjcG3dCreateForMSIL(HWND hOwner,	VO (CALLBACK *cbFileDrop	)(UI n	 ),
														VO (CALLBACK *cbDirDrop 	)(UI n	 ),
														VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl),
														VO (CALLBACK *cbPltLst)(int max, int num, PAJC3DGPLITEM pItem))
{
	HWND		hBack = NULL;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = NULL;
	RECT		rect;

	do {
		//----- 親ウインドハンドルチェック ---------------------------------------------------------------------//
		if (!IsWindow(hOwner)) break;
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbFileDrop	= cbFileDrop;
		pWk->cbDirDrop	= cbDirDrop;
		pWk->cbRClick	= cbRClick;
		pWk->cbPltLst	= cbPltLst;
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hOwner, &rect);
		//----- バックウインド生成 -----------------------------------------------------------------------------//
		hBack = CreateWindow((WCP)G3dClassForMSIL,			// window class name
								L"",						// window caption
								WS_CHILD,					// window style
								0,							// initial x position
								0,							// initial y position
								rect.right - rect.left,		// initial x size
								rect.bottom - rect.top,		// initial y size
								hOwner,						// parent window handle
								(HMENU)IDC_PARENT,			// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hBack == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hCtrl = pWk->hCtrl;
		//----- チップコントロール対象ウインド設定 -------------------------------------------------------------//
		AJCTIPCTRL_SETHWNDA(hOwner, hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hBack, SW_SHOW);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hBack == NULL) {
		if (pWk != NULL) free(pWk);
	}
	return hCtrl;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドプロシージャ																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT		rect;

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hwnd, &rect);
		//----- ３Ｄグラフィックウインド生成 -------------------------------------------------------------------//
		hCtrl = CreateWindow(L"AjcCtrl3dGraph",										// window class name
							L"",														// window caption
							WS_CHILD | WS_VISIBLE | AJC3DGS_3DMODE, 				// style
							0,														// initial x position
							0,														// initial y position
							rect.right - rect.left,									// initial x size
							rect.bottom - rect.top,									// initial y size
							hwnd,													// parent window handle
							(HMENU)IDC_CTRL,										// window menu handle
							hDllInst,												// program instance handle
							NULL);													// creation parameters
		if (hCtrl == NULL) break;
		//----- ３Ｄアングル設定 -------------------------------------------------------------------------------//
		AjcG3dSetAngle3D(hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hCtrl, SW_SHOW);
		//----- コントロールのハンドル退避 ---------------------------------------------------------------------//
		pWk->hCtrl = hCtrl;
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		if (pWk->hCtrl != NULL) {
			DestroyWindow(pWk->hCtrl);
			pWk->hCtrl = NULL;
		}
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SIZE		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	int			width  = LOWORD(lParam);
	int			height = HIWORD(lParam);

	SetWindowPos(pWk->hCtrl, NULL, 0, 0, width, height, SWP_NOMOVE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_RBUTTONDOWN	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk->cbRClick != NULL) {
		pWk->cbRClick((SW)LOWORD(lParam), (SW)HIWORD(lParam), ((wParam & MK_SHIFT) != 0), ((wParam & MK_CONTROL) != 0));
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, IDC_CTRL		)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (LOWORD(wParam) == IDC_CTRL) {
		switch (HIWORD(wParam)) {
			case AJC3DGN_ROTTHETA:					//	●視点変化通知
				break;

			case AJC3DGN_PLOTLIST:					//	●プロットリスト通知
			{	PAJC3DGPLOTLIST p = (PAJC3DGPLOTLIST)lParam;
				if (pWk->cbPltLst != NULL) {
					pWk->cbPltLst(p->max, p->num, p->lst);
				}
				break;
			}
			case AJC3DGN_DROPFILE:					//	●ファイルドロップ通知
				if (pWk->cbFileDrop != NULL) {
					pWk->cbFileDrop((UI)lParam);
				}
				break;

			case AJC3DGN_DROPDIR:					//	●ディレクトリドロップ通知
				if (pWk->cbDirDrop != NULL) {
					pWk->cbDirDrop((UI)lParam);
				}
				break;

			case AJC3DGN_RCLICK:					//	●右クリック通知
			{	PAJC3DGRCLK	p = (PAJC3DGRCLK)lParam;
				if (pWk->cbRClick != NULL) {
					pWk->cbRClick(p->x, p->y, p->fShift, p->fCtrl);
				}
				break;
			}
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SIZE			)
	AJC_WNDMAP_MSG(MSIL, WM_RBUTTONDOWN		)

	AJC_WNDMAP_CMD(MSIL, IDC_CTRL			)
AJC_WNDMAP_END
//==============================================================================================================//
//																												//
//	スタイルの設定／取得関数																					//
//																												//
//==============================================================================================================//
//----- スタイル取得マクロ -------------------------------------------------------------------------------------//
#define	MGET_STY(NAME)	AJCEXPORT BOOL WINAPI AjcG3dGetSty_##NAME(HWND hwnd) {									\
	return (BOOL)((MAjcGetWindowLong(hwnd, GWL_STYLE) & AJC3DGS_##NAME) != 0);									\
}
//----- スタイル設定マクロ -------------------------------------------------------------------------------------//
#define	MSET_STY(NAME)	AJCEXPORT VO WINAPI AjcG3dSetSty_##NAME(HWND hwnd, BOOL f) {							\
	if (f) MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) |	AJC3DGS_##NAME);			\
	else   MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) & ~AJC3DGS_##NAME);			\
}

//----- 方眼スケール表示					(AJC3DGS_RECTSCALE) ------------------------------------------------//
MGET_STY(RECTSCALE)
MSET_STY(RECTSCALE)

//----- Ｘ軸スケール値表示					(AJC3DGS_SCALEVALUE_X) ---------------------------------------------//
MGET_STY(SCALEVALUE_X)
MSET_STY(SCALEVALUE_X)

//----- Ｙ軸スケール値表示					(AJC3DGS_SCALEVALUE_Y) ---------------------------------------------//
MGET_STY(SCALEVALUE_Y)
MSET_STY(SCALEVALUE_Y)

//----- Ｚ軸スケール値表示					(AJC3DGS_SCALEVALUE_Z) ---------------------------------------------//
MGET_STY(SCALEVALUE_Z)
MSET_STY(SCALEVALUE_Z)


//----- 同心円スケール表示					(AJC3DGS_ELPSSCALE) ------------------------------------------------//
MGET_STY(ELPSSCALE)
MSET_STY(ELPSSCALE)

//----- ＸＹ平面スケール表示				(AJC3DGS_SCALE_XY) -------------------------------------------------//
MGET_STY(SCALE_XY)
MSET_STY(SCALE_XY)

//----- ＸＺ平面スケール表示				(AJC3DGS_SCALE_XZ) -------------------------------------------------//
MGET_STY(SCALE_XZ)
MSET_STY(SCALE_XZ)

//----- ＹＺ平面スケール表示				(AJC3DGS_SCALE_YZ) -------------------------------------------------//
MGET_STY(SCALE_YZ)
MSET_STY(SCALE_YZ)


//----- 奥行表現の許可／禁止				(AJC3DGS_NODEPTHCTRL) ----------------------------------------------//
MGET_STY(NODEPTHCTRL)
MSET_STY(NODEPTHCTRL)

//----- コントロールの外枠・非表示／表示	(AJC3DGS_NOBORDER) -------------------------------------------------//
MGET_STY(NOBORDER)
MSET_STY(NOBORDER)

//----- フィルタ非表示／表示				(AJC3DGS_NOFILTER) -------------------------------------------------//
MGET_STY(NOFILTER)
MSET_STY(NOFILTER)

//----- 視点設定／ドラッグ　許可／禁止		(AJC3DGS_NOANGLE) --------------------------------------------------//
MGET_STY(NOANGLE)
MSET_STY(NOANGLE)


//----- 球体スケール表示					(AJC3DGS_SPHERESCALE) ----------------------------------------------//
MGET_STY(SPHERESCALE)
MSET_STY(SPHERESCALE)

//----- Ｘ軸表示							(AJC3DGS_SHOWAXIS_X) -----------------------------------------------//
MGET_STY(SHOWAXIS_X)
MSET_STY(SHOWAXIS_X)

//----- Ｙ軸表示							(AJC3DGS_SHOWAXIS_Y) -----------------------------------------------//
MGET_STY(SHOWAXIS_Y)
MSET_STY(SHOWAXIS_Y)

//----- Ｚ軸表示							(AJC3DGS_SHOWAXIS_Z) -----------------------------------------------//
MGET_STY(SHOWAXIS_Z)
MSET_STY(SHOWAXIS_Z)


//==============================================================================================================//
//																												//
//	プロパティの設定／取得関数																					//
//																												//
//==============================================================================================================//
//----- プロパティ取得マクロ -----------------------------------------------------------------------------------//
#define	MGET_PROP(TYPE, NAME)		AJCEXPORT TYPE WINAPI AjcG3dGetProp_##NAME(HWND hwnd) {						\
	AJC3DGPROP	p;																								\
	AjcG3dGetProp(hwnd, &p);																					\
	return p.NAME;																								\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MGET_PROPST(TYPE, NAME, M)	AJCEXPORT TYPE WINAPI AjcG3dGetProp_##NAME##_##M(HWND hwnd) {				\
	AJC3DGPROP	p;																								\
	AjcG3dGetProp(hwnd, &p);																					\
	return p.NAME.M;																							\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MGET_PROPIX(TYPE, NAME)		AJCEXPORT TYPE WINAPI AjcG3dGetProp_##NAME(HWND hwnd, UI ix) {				\
	TYPE		rc	  = 0;																						\
	AJC3DGPROP	p;																								\
	if (ix < AJC3DG_MAXITEM) {																					\
		AjcG3dGetProp(hwnd, &p);																				\
		rc = p.Item[ix].NAME;																					\
	}																											\
	return rc;																									\
}
//----- プロパティ設定マクロ -----------------------------------------------------------------------------------//
#define	MSET_PROP(TYPE, NAME)		AJCEXPORT VO WINAPI AjcG3dSetProp_##NAME(HWND hwnd, TYPE n) {				\
	AJC3DGPROP p;																								\
	AjcG3dGetProp(hwnd, &p);																					\
	p.NAME = n;																									\
	AjcG3dSetProp(hwnd, &p);																					\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MSET_PROPST(TYPE, NAME, M)	AJCEXPORT VO WINAPI AjcG3dSetProp_##NAME##_##M(HWND hwnd, TYPE n) {			\
	AJC3DGPROP p;																								\
	AjcG3dGetProp(hwnd, &p);																					\
	p.NAME.M = n;																								\
	AjcG3dSetProp(hwnd, &p);																					\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MSET_PROPIX(TYPE, NAME)		AJCEXPORT VO WINAPI AjcG3dSetProp_##NAME(HWND hwnd, UI ix, TYPE n) {		\
	AJC3DGPROP p;																								\
	if (ix < AJC3DG_MAXITEM) {																					\
		AjcG3dGetProp(hwnd, &p);																				\
		p.Item[ix].NAME = n;																					\
		AjcG3dSetProp(hwnd, &p);																				\
	}																											\
}
//----- 回転角度Ｘ 							(Rot.x) ------------------------------------------------------------//
MGET_PROPST(double, Rot, x)
MSET_PROPST(double, Rot, x)

//----- 回転角度Ｙ 							(Rot.y) ------------------------------------------------------------//
MGET_PROPST(double, Rot, y)
MSET_PROPST(double, Rot, y)

//----- 回転角度Ｚ 							(Rot.z) ------------------------------------------------------------//
MGET_PROPST(double, Rot, z)
MSET_PROPST(double, Rot, z)

//----- 中心位置Ｘ 							(Cent.x) -----------------------------------------------------------//
MGET_PROPST(double, Cent, x)
MSET_PROPST(double, Cent, x)

//----- 中心位置Ｙ 							(Cent.y) -----------------------------------------------------------//
MGET_PROPST(double, Cent, y)
MSET_PROPST(double, Cent, y)

//----- 中心位置Ｚ 							(Cent.z) -----------------------------------------------------------//
MGET_PROPST(double, Cent, z)
MSET_PROPST(double, Cent, z)

//----- 半径Ｘ 								(xr) ---------------------------------------------------------------//
MGET_PROP(double, xr)
MSET_PROP(double, xr)

//----- 半径Ｙ 								(yr) ---------------------------------------------------------------//
MGET_PROP(double, yr)
MSET_PROP(double, yr)

//----- 半径Ｚ 								(zr) ---------------------------------------------------------------//
MGET_PROP(double, zr)
MSET_PROP(double, zr)

//----- ビューボリュームの割合 				(ratio) ------------------------------------------------------------//
MGET_PROP(double, ratio)
MSET_PROP(double, ratio)

//----- プロットデータのピクセルサイズ		(PlotSize) ---------------------------------------------------------//
MGET_PROP(UI, PlotSize)
MSET_PROP(UI, PlotSize)

//----- 最終プロットデータのピクセルサイズ	(PlotSizeE) --------------------------------------------------------//
MGET_PROP(UI, PlotSizeE)
MSET_PROP(UI, PlotSizeE)

//----- プロットデータの結線				(fPlotLine) --------------------------------------------------------//
MGET_PROP(BOOL, fPlotLine)
MSET_PROP(BOOL, fPlotLine)

//----- アスペクト１保持					(fAspect1) ---------------------------------------------------------//
MGET_PROP(BOOL, fAspect1)
MSET_PROP(BOOL, fAspect1)

//----- 最大プロット数						(MaxPlot) ----------------------------------------------------------//
MGET_PROPIX(UI, MaxPlot)
MSET_PROPIX(UI, MaxPlot)

//----- 前面側プロット表示色				(rgbP) -------------------------------------------------------------//
MGET_PROPIX(UI, rgbP)
MSET_PROPIX(UI, rgbP)

//----- 後面側プロット表示色				(rgbN) -------------------------------------------------------------//
MGET_PROPIX(UI, rgbN)
MSET_PROPIX(UI, rgbN)

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcG3dSetProp_WndSize(HWND hwnd, UI width, UI height)
{
	if (IsWindow(hwnd)) {
		HWND		hParent;

		if (hParent = GetParent(hwnd)) {
			SetWindowPos(hParent , NULL, 0, 0, width, height, SWP_NOMOVE);
		}
	}
}

//----- ２Ｄモード設定 -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcG3dSetProp_Set2dMode(HWND hwnd)
{
	if (IsWindow(hwnd)) {
		PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
		G3dSet2dMode(pW);
	}
}

//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcG3dSetProp_AcceptFiles(HWND hwnd, BOOL fEnable)
{
	if (IsWindow(hwnd)) {
		UX	ExSty = MAjcGetWindowLong(hwnd, GWL_EXSTYLE);

		if (fEnable) ExSty |=  WS_EX_ACCEPTFILES;
		else		 ExSty &= ~WS_EX_ACCEPTFILES;

		MAjcSetWindowLong(hwnd, GWL_EXSTYLE, ExSty);
	}
}
AJCEXPORT BOOL WINAPI AjcG3dGetProp_AcceptFiles(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = ((MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES) != 0);
	}
	return rc;
}

//----- AJC3DGN_PLOTLISTイベントにおけるプロット点情報取得 -----------------------------------------------------//
AJCEXPORT int WINAPI AjcG3dGetPlotEvtInfo(PAJC3DGPLITEM pItem, int ix, double *pX, double *pY, double *pZ)
{
	*pX  = pItem[ix].vec.x;
	*pY  = pItem[ix].vec.y;
	*pZ  = pItem[ix].vec.z;
	return pItem[ix].ix;
}
//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcG3dSetTipTextForMSIL(HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = AjcTAllocW(stl + 1)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		rc = AjcG3dSetTipTextW(hwnd, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI	WINAPI	AjcG3dGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = AjcTAllocW(lBuf)) {
		AjcG3dGetTipTextW(hwnd, pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}
//----- フィルタチップテキスト設定／取得 -----------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcG3dSetChkBoxTipTextForMSIL(HWND hwnd, UI n, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = AjcTAllocW(stl + 1)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		rc = AjcG3dSetChkBoxTipTextW(hwnd, n, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI		WINAPI		AjcG3dGetChkBoxTipTextForMSIL(HWND hwnd, UI n, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = AjcTAllocW(lBuf)) {
		AjcG3dGetChkBoxTipTextW(hwnd, n, pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	ＭＳＩＬメソッド用関数																						//
//																												//
//==============================================================================================================//
//----- ２Ｄテキスト描画 ---------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcG3dTextOut2DForMSIL(HWND hwnd, AJCG2DTXOMD md, double x, double y, C_WCP pTxt)
{
	UI			rc = 0;
	AJC2DVEC	v;

	v.x = x;
	v.y = y;
	rc = AjcG2dTextOutVW(hwnd, md, &v, pTxt);
	return rc;
}
//----- ３Ｄテキスト描画 ---------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcG3dTextOut3DForMSIL(HWND hwnd, AJCG3DTXOMD md, double x, double y, double z, C_WCP pTxt)
{
	UI			rc = 0;
	AJC3DVEC	v;

	v.x = x;
	v.y = y;
	v.z = z;
	rc = AjcG3dTextOutVW(hwnd, md, &v, pTxt);
	return rc;
}
