﻿#include    "AjcInternal.h"
#include    "AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//                                                                                                              //
//  平面となる回転角度のテーブル                                                                                //
//                                                                                                              //
//**************************************************************************************************************//
//  テーブルの回転角度検索
PCROTPLANE  G3dRpSearchTheta(int rx, int ry, int rz)
{
    PCROTPLANE  rc = NULL;
    union {
        struct {SW x, y, z;} s;
        ULL                  ull;
    } u;
    int     L = 0;
    int     R = MAX_ROTPLANE - 1;
    int     M;

    u.ull = 0;
    u.s.x = (SW)rx;
    u.s.y = (SW)ry;
    u.s.z = (SW)rz;

    while (L < R) {
        M = (L + R) / 2;
        if (G3dRotPlane[M].u.ull < u.ull) L = M + 1;
        else                              R = M;
    }
    if (G3dRotPlane[L].u.ull == u.ull) {
        rc = &G3dRotPlane[L];
    }
    return rc;
}
//  テーブルのアングル検索（最初に見つかったもの）
PCROTPLANE  G3dRpSearchAngle(AJCG3DAXIS_DIR xDir, AJCG3DAXIS_DIR yDir)
{
    PCROTPLANE  rc = NULL;
    UI          i;

    for (i = 0; i < MAX_ROTPLANE; i++) {
        if (G3dRotPlane[i].xDir == xDir && G3dRotPlane[i].yDir == yDir) {
            rc = &G3dRotPlane[i];
            break;
        }
    }
    return rc;
}

//  検索キー(u.ull)の昇順にソートしたテーブル
const ROTPLANE  G3dRotPlane[MAX_ROTPLANE] = {
	{{   0,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000000000000000 
	{{  90,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000000000005A 
	{{ 180,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000000000B4 
	{{ 270,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000000000010E 
	{{-270,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000000000FEF2 
	{{-180,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},  // Key = 0x000000000000FF4C 
	{{ -90,    0,    0}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000000000FFA6 
	{{   0,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x00000000005A0000 
	{{  90,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000005A005A 
	{{ 180,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000005A00B4 
	{{ 270,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000005A010E 
	{{-270,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000005AFEF2 
	{{-180,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000005AFF4C 
	{{ -90,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000005AFFA6 
	{{   0,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000000000B40000 
	{{  90,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000000000B4005A 
	{{ 180,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000000000B400B4 
	{{ 270,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000000000B4010E 
	{{-270,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000000000B4FEF2 
	{{-180,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000000000B4FF4C 
	{{ -90,  180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000000000B4FFA6 
	{{   0,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x00000000010E0000 
	{{  90,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000010E005A 
	{{ 180,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000010E00B4 
	{{ 270,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000010E010E 
	{{-270,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000010EFEF2 
	{{-180,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000010EFF4C 
	{{ -90,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000010EFFA6 
	{{   0, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x00000000FEF20000 
	{{  90, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000FEF2005A 
	{{ 180, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000FEF200B4 
	{{ 270, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000FEF2010E 
	{{-270, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000FEF2FEF2 
	{{-180, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000FEF2FF4C 
	{{ -90, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000FEF2FFA6 
	{{   0, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},  // Key = 0x00000000FF4C0000 
	{{  90, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x00000000FF4C005A 
	{{ 180, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000FF4C00B4 
	{{ 270, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x00000000FF4C010E 
	{{-270, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x00000000FF4CFEF2 
	{{-180, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000FF4CFF4C 
	{{ -90, -180,    0}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x00000000FF4CFFA6 
	{{   0,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x00000000FFA60000 
	{{  90,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000FFA6005A 
	{{ 180,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000FFA600B4 
	{{ 270,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000FFA6010E 
	{{-270,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x00000000FFA6FEF2 
	{{-180,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x00000000FFA6FF4C 
	{{ -90,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x00000000FFA6FFA6 
	{{   0,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005A00000000 
	{{  90,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000005A0000005A 
	{{ 180,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A000000B4 
	{{ 270,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000005A0000010E 
	{{-270,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000005A0000FEF2 
	{{-180,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A0000FF4C 
	{{ -90,    0,   90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000005A0000FFA6 
	{{   0,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005A005A0000 
	{{  90,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005A005A005A 
	{{ 180,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A005A00B4 
	{{ 270,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005A005A010E 
	{{-270,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005A005AFEF2 
	{{-180,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A005AFF4C 
	{{ -90,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005A005AFFA6 
	{{   0,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005A00B40000 
	{{  90,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000005A00B4005A 
	{{ 180,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A00B400B4 
	{{ 270,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000005A00B4010E 
	{{-270,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000005A00B4FEF2 
	{{-180,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A00B4FF4C 
	{{ -90,  180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000005A00B4FFA6 
	{{   0,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005A010E0000 
	{{  90,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005A010E005A 
	{{ 180,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A010E00B4 
	{{ 270,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005A010E010E 
	{{-270,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005A010EFEF2 
	{{-180,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005A010EFF4C 
	{{ -90,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005A010EFFA6 
	{{   0, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005AFEF20000 
	{{  90, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005AFEF2005A 
	{{ 180, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005AFEF200B4 
	{{ 270, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005AFEF2010E 
	{{-270, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005AFEF2FEF2 
	{{-180, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005AFEF2FF4C 
	{{ -90, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005AFEF2FFA6 
	{{   0, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005AFF4C0000 
	{{  90, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000005AFF4C005A 
	{{ 180, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005AFF4C00B4 
	{{ 270, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000005AFF4C010E 
	{{-270, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000005AFF4CFEF2 
	{{-180, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005AFF4CFF4C 
	{{ -90, -180,   90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000005AFF4CFFA6 
	{{   0,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000005AFFA60000 
	{{  90,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005AFFA6005A 
	{{ 180,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005AFFA600B4 
	{{ 270,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005AFFA6010E 
	{{-270,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000005AFFA6FEF2 
	{{-180,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000005AFFA6FF4C 
	{{ -90,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000005AFFA6FFA6 
	{{   0,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B400000000 
	{{  90,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000B40000005A 
	{{ 180,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4000000B4 
	{{ 270,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000B40000010E 
	{{-270,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000B40000FEF2 
	{{-180,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B40000FF4C 
	{{ -90,    0,  180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000B40000FFA6 
	{{   0,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B4005A0000 
	{{  90,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4005A005A 
	{{ 180,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4005A00B4 
	{{ 270,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4005A010E 
	{{-270,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4005AFEF2 
	{{-180,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4005AFF4C 
	{{ -90,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4005AFFA6 
	{{   0,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B400B40000 
	{{  90,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000B400B4005A 
	{{ 180,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B400B400B4 
	{{ 270,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000B400B4010E 
	{{-270,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000B400B4FEF2 
	{{-180,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B400B4FF4C 
	{{ -90,  180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000B400B4FFA6 
	{{   0,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B4010E0000 
	{{  90,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4010E005A 
	{{ 180,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4010E00B4 
	{{ 270,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4010E010E 
	{{-270,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4010EFEF2 
	{{-180,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4010EFF4C 
	{{ -90,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4010EFFA6 
	{{   0, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B4FEF20000 
	{{  90, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4FEF2005A 
	{{ 180, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4FEF200B4 
	{{ 270, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4FEF2010E 
	{{-270, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4FEF2FEF2 
	{{-180, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4FEF2FF4C 
	{{ -90, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4FEF2FFA6 
	{{   0, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B4FF4C0000 
	{{  90, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000B4FF4C005A 
	{{ 180, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4FF4C00B4 
	{{ 270, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000B4FF4C010E 
	{{-270, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x000000B4FF4CFEF2 
	{{-180, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4FF4CFF4C 
	{{ -90, -180,  180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x000000B4FF4CFFA6 
	{{   0,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x000000B4FFA60000 
	{{  90,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4FFA6005A 
	{{ 180,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4FFA600B4 
	{{ 270,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4FFA6010E 
	{{-270,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x000000B4FFA6FEF2 
	{{-180,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x000000B4FFA6FF4C 
	{{ -90,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x000000B4FFA6FFA6 
	{{   0,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010E00000000 
	{{  90,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000010E0000005A 
	{{ 180,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E000000B4 
	{{ 270,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000010E0000010E 
	{{-270,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000010E0000FEF2 
	{{-180,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E0000FF4C 
	{{ -90,    0,  270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000010E0000FFA6 
	{{   0,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010E005A0000 
	{{  90,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010E005A005A 
	{{ 180,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E005A00B4 
	{{ 270,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010E005A010E 
	{{-270,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010E005AFEF2 
	{{-180,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E005AFF4C 
	{{ -90,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010E005AFFA6 
	{{   0,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010E00B40000 
	{{  90,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000010E00B4005A 
	{{ 180,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E00B400B4 
	{{ 270,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000010E00B4010E 
	{{-270,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000010E00B4FEF2 
	{{-180,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E00B4FF4C 
	{{ -90,  180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000010E00B4FFA6 
	{{   0,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010E010E0000 
	{{  90,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010E010E005A 
	{{ 180,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E010E00B4 
	{{ 270,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010E010E010E 
	{{-270,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010E010EFEF2 
	{{-180,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010E010EFF4C 
	{{ -90,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010E010EFFA6 
	{{   0, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010EFEF20000 
	{{  90, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010EFEF2005A 
	{{ 180, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010EFEF200B4 
	{{ 270, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010EFEF2010E 
	{{-270, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010EFEF2FEF2 
	{{-180, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010EFEF2FF4C 
	{{ -90, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010EFEF2FFA6 
	{{   0, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010EFF4C0000 
	{{  90, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000010EFF4C005A 
	{{ 180, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010EFF4C00B4 
	{{ 270, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000010EFF4C010E 
	{{-270, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000010EFF4CFEF2 
	{{-180, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010EFF4CFF4C 
	{{ -90, -180,  270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000010EFF4CFFA6 
	{{   0,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000010EFFA60000 
	{{  90,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010EFFA6005A 
	{{ 180,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010EFFA600B4 
	{{ 270,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010EFFA6010E 
	{{-270,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000010EFFA6FEF2 
	{{-180,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000010EFFA6FF4C 
	{{ -90,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000010EFFA6FFA6 
	{{   0,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF200000000 
	{{  90,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FEF20000005A 
	{{ 180,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2000000B4 
	{{ 270,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FEF20000010E 
	{{-270,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FEF20000FEF2 
	{{-180,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF20000FF4C 
	{{ -90,    0, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FEF20000FFA6 
	{{   0,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF2005A0000 
	{{  90,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2005A005A 
	{{ 180,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2005A00B4 
	{{ 270,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2005A010E 
	{{-270,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2005AFEF2 
	{{-180,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2005AFF4C 
	{{ -90,   90, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2005AFFA6 
	{{   0,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF200B40000 
	{{  90,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FEF200B4005A 
	{{ 180,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF200B400B4 
	{{ 270,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FEF200B4010E 
	{{-270,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FEF200B4FEF2 
	{{-180,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF200B4FF4C 
	{{ -90,  180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FEF200B4FFA6 
	{{   0,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF2010E0000 
	{{  90,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2010E005A 
	{{ 180,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2010E00B4 
	{{ 270,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2010E010E 
	{{-270,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2010EFEF2 
	{{-180,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2010EFF4C 
	{{ -90,  270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2010EFFA6 
	{{   0, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF2FEF20000 
	{{  90, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2FEF2005A 
	{{ 180, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2FEF200B4 
	{{ 270, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2FEF2010E 
	{{-270, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2FEF2FEF2 
	{{-180, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2FEF2FF4C 
	{{ -90, -270, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2FEF2FFA6 
	{{   0, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF2FF4C0000 
	{{  90, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FEF2FF4C005A 
	{{ 180, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2FF4C00B4 
	{{ 270, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FEF2FF4C010E 
	{{-270, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FEF2FF4CFEF2 
	{{-180, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2FF4CFF4C 
	{{ -90, -180, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FEF2FF4CFFA6 
	{{   0,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FEF2FFA60000 
	{{  90,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2FFA6005A 
	{{ 180,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2FFA600B4 
	{{ 270,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2FFA6010E 
	{{-270,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FEF2FFA6FEF2 
	{{-180,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FEF2FFA6FF4C 
	{{ -90,  -90, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FEF2FFA6FFA6 
	{{   0,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4C00000000 
	{{  90,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FF4C0000005A 
	{{ 180,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C000000B4 
	{{ 270,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FF4C0000010E 
	{{-270,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FF4C0000FEF2 
	{{-180,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C0000FF4C 
	{{ -90,    0, -180}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FF4C0000FFA6 
	{{   0,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4C005A0000 
	{{  90,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4C005A005A 
	{{ 180,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C005A00B4 
	{{ 270,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4C005A010E 
	{{-270,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4C005AFEF2 
	{{-180,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C005AFF4C 
	{{ -90,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4C005AFFA6 
	{{   0,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4C00B40000 
	{{  90,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FF4C00B4005A 
	{{ 180,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C00B400B4 
	{{ 270,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FF4C00B4010E 
	{{-270,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FF4C00B4FEF2 
	{{-180,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C00B4FF4C 
	{{ -90,  180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FF4C00B4FFA6 
	{{   0,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4C010E0000 
	{{  90,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4C010E005A 
	{{ 180,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C010E00B4 
	{{ 270,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4C010E010E 
	{{-270,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4C010EFEF2 
	{{-180,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4C010EFF4C 
	{{ -90,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4C010EFFA6 
	{{   0, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4CFEF20000 
	{{  90, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4CFEF2005A 
	{{ 180, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4CFEF200B4 
	{{ 270, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4CFEF2010E 
	{{-270, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4CFEF2FEF2 
	{{-180, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4CFEF2FF4C 
	{{ -90, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4CFEF2FFA6 
	{{   0, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4CFF4C0000 
	{{  90, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FF4CFF4C005A 
	{{ 180, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4CFF4C00B4 
	{{ 270, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FF4CFF4C010E 
	{{-270, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FF4CFF4CFEF2 
	{{-180, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4CFF4CFF4C 
	{{ -90, -180, -180}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FF4CFF4CFFA6 
	{{   0,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FF4CFFA60000 
	{{  90,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4CFFA6005A 
	{{ 180,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4CFFA600B4 
	{{ 270,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4CFFA6010E 
	{{-270,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FF4CFFA6FEF2 
	{{-180,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FF4CFFA6FF4C 
	{{ -90,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FF4CFFA6FFA6 
	{{   0,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA600000000 
	{{  90,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FFA60000005A 
	{{ 180,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6000000B4 
	{{ 270,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FFA60000010E 
	{{-270,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FFA60000FEF2 
	{{-180,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA60000FF4C 
	{{ -90,    0,  -90}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FFA60000FFA6 
	{{   0,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA6005A0000 
	{{  90,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6005A005A 
	{{ 180,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6005A00B4 
	{{ 270,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6005A010E 
	{{-270,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6005AFEF2 
	{{-180,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6005AFF4C 
	{{ -90,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6005AFFA6 
	{{   0,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA600B40000 
	{{  90,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FFA600B4005A 
	{{ 180,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA600B400B4 
	{{ 270,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FFA600B4010E 
	{{-270,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FFA600B4FEF2 
	{{-180,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA600B4FF4C 
	{{ -90,  180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FFA600B4FFA6 
	{{   0,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA6010E0000 
	{{  90,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6010E005A 
	{{ 180,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6010E00B4 
	{{ 270,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6010E010E 
	{{-270,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6010EFEF2 
	{{-180,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6010EFF4C 
	{{ -90,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6010EFFA6 
	{{   0, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA6FEF20000 
	{{  90, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6FEF2005A 
	{{ 180, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6FEF200B4 
	{{ 270, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6FEF2010E 
	{{-270, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6FEF2FEF2 
	{{-180, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6FEF2FF4C 
	{{ -90, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6FEF2FFA6 
	{{   0, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA6FF4C0000 
	{{  90, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FFA6FF4C005A 
	{{ 180, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6FF4C00B4 
	{{ 270, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FFA6FF4C010E 
	{{-270, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},  // Key = 0x0000FFA6FF4CFEF2 
	{{-180, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6FF4CFF4C 
	{{ -90, -180,  -90}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},  // Key = 0x0000FFA6FF4CFFA6 
	{{   0,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},  // Key = 0x0000FFA6FFA60000 
	{{  90,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6FFA6005A 
	{{ 180,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6FFA600B4 
	{{ 270,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6FFA6010E 
	{{-270,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},  // Key = 0x0000FFA6FFA6FEF2 
	{{-180,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},  // Key = 0x0000FFA6FFA6FF4C 
	{{ -90,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},  // Key = 0x0000FFA6FFA6FFA6 
};
//  オリジナルの定義
#if 0
const ROTPLANE  G3dRotPlane[MAX_ROTPLANE] = {
    {{-270, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-270, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-270, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{-270, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{-270, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-270, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-270, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{-270, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{-270, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{-270, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{-270, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{-270, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{-270, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{-270,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{-270,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{-270,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-270,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-270,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{-270,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{-270,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-270,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-270,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{-270,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{-270,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{-270,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{-270,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{-270,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{-270,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{-270,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-270,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-270,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{-270,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{-270,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-270,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-270,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{-270,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{-270,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{-270,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{-270,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{-270,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{-270,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{-270,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{-270,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{-270,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-270,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-270,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{-270,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{-270,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-180, -270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-180, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{-180, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-180, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-180, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{-180, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{-180, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-180, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-180, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{-180, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{-180, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{-180, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},
    {{-180, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{-180, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{-180,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{-180,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-180,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-180,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{-180,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{-180,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-180,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-180,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{-180,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{-180,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},
    {{-180,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{-180,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},
    {{-180,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{-180,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},
    {{-180,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{-180,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{-180,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-180,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-180,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{-180,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{-180,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{-180,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{-180,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{-180,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{-180,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{-180,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},
    {{-180,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{-180,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{-180,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{-180,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-180,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{-180,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{-180,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{-180,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{-180,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ -90, -270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ -90, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ -90, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ -90, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ -90, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ -90, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ -90, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ -90, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ -90, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ -90, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ -90, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ -90, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{ -90, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ -90, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ -90,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ -90,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ -90,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ -90,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ -90,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ -90,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ -90,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ -90,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ -90,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{ -90,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{ -90,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{ -90,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{ -90,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{ -90,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{ -90,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{ -90,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ -90,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ -90,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ -90,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ -90,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ -90,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ -90,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ -90,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ -90,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ -90,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ -90,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{ -90,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ -90,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ -90,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ -90,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ -90,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ -90,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ -90,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ -90,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ -90,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{   0, -270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{   0, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{   0, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{   0, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{   0, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{   0, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{   0, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{   0, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{   0, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{   0, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},
    {{   0, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{   0, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},
    {{   0, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{   0, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},
    {{   0,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{   0,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{   0,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{   0,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{   0,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{   0,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{   0,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{   0,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{   0,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{   0,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},
    {{   0,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{   0,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{   0,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{   0,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},
    {{   0,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{   0,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{   0,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{   0,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{   0,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{   0,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{   0,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{   0,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{   0,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{   0,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},
    {{   0,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{   0,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},
    {{   0,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{   0,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},
    {{   0,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{   0,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{   0,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{   0,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{   0,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{   0,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{   0,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{  90, -270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{  90, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{  90, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{  90, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{  90, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{  90, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{  90, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{  90, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{  90, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{  90, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{  90, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{  90, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{  90, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{  90, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{  90,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{  90,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{  90,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{  90,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{  90,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{  90,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{  90,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{  90,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{  90,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{  90,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{  90,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{  90,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{  90,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{  90,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{  90,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{  90,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{  90,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{  90,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{  90,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{  90,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{  90,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{  90,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{  90,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{  90,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{  90,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{  90,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{  90,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{  90,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{  90,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{  90,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{  90,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{  90,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{  90,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{  90,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{  90,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 180, -270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 180, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 180, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 180, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ 180, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ 180, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 180, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 180, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ 180, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{ 180, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{ 180, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{ 180, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},
    {{ 180, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{ 180, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{ 180,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{ 180,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 180,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 180,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 180,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ 180,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 180,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 180,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 180,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{ 180,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},
    {{ 180,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{ 180,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YM},
    {{ 180,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XP},
    {{ 180,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YP},
    {{ 180,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XM},
    {{ 180,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 180,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 180,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ 180,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ 180,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 180,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 180,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ 180,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{ 180,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{ 180,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{ 180,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_YM},
    {{ 180,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_XP},
    {{ 180,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_YP},
    {{ 180,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_XM},
    {{ 180,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 180,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 180,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 180,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ 180,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 180,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 270, -270, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 270, -270, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ 270, -270,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 270, -270,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 270, -270,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ 270, -270,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ 270, -270,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 270, -180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 270, -180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ 270, -180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ 270, -180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ 270, -180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{ 270, -180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ 270, -180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ 270,  -90, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ 270,  -90, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 270,  -90,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 270,  -90,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ 270,  -90,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 270,  -90,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 270,  -90,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 270,    0, -270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ 270,    0, -180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{ 270,    0,  -90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{ 270,    0,    0}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{ 270,    0,   90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZM},
    {{ 270,    0,  180}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZM},
    {{ 270,    0,  270}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZM},
    {{ 270,   90, -270}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZM},
    {{ 270,   90, -180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ 270,   90,  -90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 270,   90,    0}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 270,   90,   90}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XM},
    {{ 270,   90,  180}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YM},
    {{ 270,   90,  270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_XP},
    {{ 270,  180, -270}, AJCG3DAXIS_DIR_ZM, AJCG3DAXIS_DIR_YP},
    {{ 270,  180, -180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ 270,  180,  -90}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ 270,  180,    0}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ 270,  180,   90}, AJCG3DAXIS_DIR_XM, AJCG3DAXIS_DIR_ZP},
    {{ 270,  180,  180}, AJCG3DAXIS_DIR_YM, AJCG3DAXIS_DIR_ZP},
    {{ 270,  180,  270}, AJCG3DAXIS_DIR_XP, AJCG3DAXIS_DIR_ZP},
    {{ 270,  270, -270}, AJCG3DAXIS_DIR_YP, AJCG3DAXIS_DIR_ZP},
    {{ 270,  270, -180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 270,  270,  -90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
    {{ 270,  270,    0}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YM},
    {{ 270,  270,   90}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XP},
    {{ 270,  270,  180}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_YP},
    {{ 270,  270,  270}, AJCG3DAXIS_DIR_ZP, AJCG3DAXIS_DIR_XM},
};
#endif
