﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	共通サブ関数													//
//																												//
//**************************************************************************************************************//

#define	IX_X			0				//	Ｘ軸情報インデクス
#define	IX_Y			1				//	Ｙ　　〃
#define	IX_Z			2				//	Ｚ　　〃

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SetMatrix(PWRK3DGRAPH pW);
static	VO		SubSetScaleInfo(PWRK3DGRAPH pW, PAXIS_INF pAxi);

//==============================================================================================================//
//	プロパティ設定																								//
//																												//
//	引　数	：	pNew	- 新プロパティ																			//
//																												//
//	戻り値	：	TRUE - OK,	FALSE - Error																		//
//==============================================================================================================//
BOOL	G3dSetCtrlProp(PWRK3DGRAPH pW, PCAJC3DGPROP pNew)
{
	BOOL		rc	 = TRUE;
	PAJC3DGPROP pOld = &pW->prop;
	UI			i;
	HPEN		hPenP, hPenN;
	HBRUSH		hBruP, hBruN;
	VOP			pBuf;

	//----- 回転角度変化通知 -----------------------------------------------------------------------------------//
	if (memcmp(&pOld->Rot, &pNew->Rot, sizeof pOld->Rot) != 0) {
		PostMessage(pW->hMain, AJC3DGM_NEEDNTC_ANGLE, 0, 0);
	}
	//----- 回転角度，レンジ設定 -------------------------------------------------------------------------------//
	pOld->Rot.x = fmod(pNew->Rot.x, 360.0);
	pOld->Rot.y = fmod(pNew->Rot.y, 360.0);
	pOld->Rot.z = fmod(pNew->Rot.z, 360.0);
	memcpy(&pOld->Cent, &pNew->Cent, sizeof pOld->Cent);
	pOld->xr	= fabs(pNew->xr);
	pOld->yr	= fabs(pNew->yr);
	pOld->zr	= fabs(pNew->zr);
	pOld->xr	= __max(pOld->xr, (pOld->Cent.x + pOld->xr) * 1e-12);
	pOld->yr	= __max(pOld->yr, (pOld->Cent.y + pOld->yr) * 1e-12);
	pOld->zr	= __max(pOld->zr, (pOld->Cent.z + pOld->zr) * 1e-12);
	pOld->xr	= __max(pOld->xr, DBL_MIN * 1e6);
	pOld->yr	= __max(pOld->yr, DBL_MIN * 1e6);
	pOld->zr	= __max(pOld->zr, DBL_MIN * 1e6);
	pOld->ratio = __max(pNew->ratio, 0.1);
	pOld->PlotSize	= __max(pNew->PlotSize, 1);
	pOld->PlotSizeE = __max(pNew->PlotSizeE, 1);
	pOld->fPlotLine = pNew->fPlotLine;
	pOld->fAspect1	= pNew->fAspect1;
	//----- 中心位置と半径を各軸情報にコピー -------------------------------------------------------------------//
	pW->AxisInfo[IX_X].Cent = pOld->Cent.x; pW->AxisInfo[IX_X].r = fabs(pOld->xr);
	pW->AxisInfo[IX_Y].Cent = pOld->Cent.y; pW->AxisInfo[IX_Y].r = fabs(pOld->yr);
	pW->AxisInfo[IX_Z].Cent = pOld->Cent.z; pW->AxisInfo[IX_Z].r = fabs(pOld->zr);
	//----- 各軸の描画範囲設定 ---------------------------------------------------------------------------------//
	pW->AxisInfo[0].s.v3.x = pOld->Cent.x - pOld->xr; pW->AxisInfo[0].e.v3.x = pOld->Cent.x + pOld->xr;
	pW->AxisInfo[0].s.v3.y = pOld->Cent.y;			  pW->AxisInfo[0].e.v3.y = pOld->Cent.y;
	pW->AxisInfo[0].s.v3.z = pOld->Cent.z;			  pW->AxisInfo[0].e.v3.z = pOld->Cent.z;

	pW->AxisInfo[1].s.v3.x = pOld->Cent.x;			  pW->AxisInfo[1].e.v3.x = pOld->Cent.x;
	pW->AxisInfo[1].s.v3.y = pOld->Cent.y - pOld->yr; pW->AxisInfo[1].e.v3.y = pOld->Cent.y + pOld->yr;
	pW->AxisInfo[1].s.v3.z = pOld->Cent.z;			  pW->AxisInfo[1].e.v3.z = pOld->Cent.z;

	pW->AxisInfo[2].s.v3.x = pOld->Cent.x;			  pW->AxisInfo[2].e.v3.x = pOld->Cent.x;
	pW->AxisInfo[2].s.v3.y = pOld->Cent.y;			  pW->AxisInfo[2].e.v3.y = pOld->Cent.y;
	pW->AxisInfo[2].s.v3.z = pOld->Cent.z - pOld->zr; pW->AxisInfo[2].e.v3.z = pOld->Cent.z + pOld->zr;

	//----- 軸描画用プロパティ設定 -----------------------------------------------------------------------------//
	for (i = 0; i < AJC3DG_MAXAXIS; i++) {
		COLORREF	RgbP = pNew->axis[i].rgbP;
		COLORREF	RgbN = pNew->axis[i].rgbN;
		if (pW->AxisInfo[i].RgbInfo.hPenP == NULL || pW->AxisInfo[i].RgbInfo.hBruP == NULL ||
			pW->AxisInfo[i].RgbInfo.hPenN == NULL || pW->AxisInfo[i].RgbInfo.hBruN == NULL ||
			pOld->axis[i].rgbP != pNew->axis[i].rgbP || pOld->axis[i].rgbN != pNew->axis[i].rgbN) {

			hBruP = CreateSolidBrush(	   RgbP);
			hPenP = CreatePen(PS_SOLID, 1, RgbP);
			hBruN = CreateSolidBrush(	   RgbN);
			hPenN = CreatePen(PS_SOLID, 1, RgbN);
			if (hBruP != NULL && hPenP != NULL && hBruN != NULL && hPenN != NULL) {
				if (pW->AxisInfo[i].RgbInfo.hBruP != NULL) DeleteObject(pW->AxisInfo[i].RgbInfo.hBruP);
				if (pW->AxisInfo[i].RgbInfo.hPenP != NULL) DeleteObject(pW->AxisInfo[i].RgbInfo.hPenP);
				if (pW->AxisInfo[i].RgbInfo.hBruN != NULL) DeleteObject(pW->AxisInfo[i].RgbInfo.hBruN);
				if (pW->AxisInfo[i].RgbInfo.hPenN != NULL) DeleteObject(pW->AxisInfo[i].RgbInfo.hPenN);
				pOld->axis[i].rgbP			  = RgbP;
				pOld->axis[i].rgbN			  = RgbN;
				pW->AxisInfo[i].RgbInfo.RgbP  = RgbP;
				pW->AxisInfo[i].RgbInfo.RgbN  = RgbN;
				pW->AxisInfo[i].RgbInfo.hBruP = hBruP;
				pW->AxisInfo[i].RgbInfo.hPenP = hPenP;
				pW->AxisInfo[i].RgbInfo.hBruN = hBruN;
				pW->AxisInfo[i].RgbInfo.hPenN = hPenN;
			}
			else {
				if (hBruP != NULL) DeleteObject(hBruP);
				if (hPenP != NULL) DeleteObject(hPenP);
				if (hBruN != NULL) DeleteObject(hBruN);
				if (hPenN != NULL) DeleteObject(hPenN);
				rc = FALSE;
			}
		}
	}

	//----- データ描画用プロパティ設定 -------------------------------------------------------------------------//
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		COLORREF	RgbP = pNew->Item[i].rgbP;
		COLORREF	RgbN = pNew->Item[i].rgbN;
		//----- データ描画色 -----------------------------------------------//
		if (pW->DatItem[i].RgbInfo.hBruP == NULL || pW->DatItem[i].RgbInfo.hPenP == NULL ||
			pW->DatItem[i].RgbInfo.hBruN == NULL || pW->DatItem[i].RgbInfo.hPenN == NULL ||
			pOld->Item[i].rgbP != pNew->Item[i].rgbP || pOld->Item[i].rgbN != pNew->Item[i].rgbN) {

			hBruP = CreateSolidBrush(	   RgbP);
			hPenP = CreatePen(PS_SOLID, 1, RgbP);
			hBruN = CreateSolidBrush(	   RgbN);
			hPenN = CreatePen(PS_SOLID, 1, RgbN);
			if (hBruP != NULL && hPenP != NULL && hBruN != NULL && hPenN != NULL) {
				if (pW->DatItem[i].RgbInfo.hBruP != NULL) DeleteObject(pW->DatItem[i].RgbInfo.hBruP);
				if (pW->DatItem[i].RgbInfo.hPenP != NULL) DeleteObject(pW->DatItem[i].RgbInfo.hPenP);
				if (pW->DatItem[i].RgbInfo.hBruN != NULL) DeleteObject(pW->DatItem[i].RgbInfo.hBruN);
				if (pW->DatItem[i].RgbInfo.hPenN != NULL) DeleteObject(pW->DatItem[i].RgbInfo.hPenN);
				pOld->Item[i].rgbP			 = RgbP;
				pOld->Item[i].rgbN			 = RgbN;
				pW->DatItem[i].RgbInfo.RgbP	 = RgbP;
				pW->DatItem[i].RgbInfo.RgbN	 = RgbN;
				pW->DatItem[i].RgbInfo.hBruP = hBruP;
				pW->DatItem[i].RgbInfo.hPenP = hPenP;
				pW->DatItem[i].RgbInfo.hBruN = hBruN;
				pW->DatItem[i].RgbInfo.hPenN = hPenN;
			}
			else {
				if (hBruP != NULL) DeleteObject(hBruP);
				if (hPenP != NULL) DeleteObject(hPenP);
				if (hBruN != NULL) DeleteObject(hBruN);
				if (hPenN != NULL) DeleteObject(hPenN);
				rc = FALSE;
			}
		}
		//----- プロットバッファ -------------------------------------------//
		if (pW->DatItem[i].plot.pBuf == NULL || pOld->Item[i].MaxPlot != pNew->Item[i].MaxPlot) {
			if ((pBuf = (VOP)AJCMEM(sizeof(GI_VEC) * pNew->Item[i].MaxPlot)) != NULL) {
				pOld->Item[i].MaxPlot = pNew->Item[i].MaxPlot;
				if (pW->DatItem[i].plot.pBuf != NULL) free(pW->DatItem[i].plot.pBuf);
				pW->DatItem[i].plot.pBuf = pBuf;
				pW->DatItem[i].plot.ix	 = 0;
				pW->DatItem[i].plot.cnt	 = 0;
			}
			else rc = FALSE;
		}
	}

	//----- 描画位置／スケール再計算 ----------------------------------------//
	G3dCnvAllPoints(pW);
	G3dSetScaleInfo(pW);

	//----- プロパティ設定時は全て再描画とする ------------------------------//
	pW->fReDrawScale = TRUE;
	pW->fReDrawData  = TRUE;

	//----- 再描画 ----------------------------------------------------------//
	InvalidateRect(pW->hMain, NULL, FALSE);

	return rc;
}
//==============================================================================================================//
//	ボーダー色設定																								//
//																												//
//	引　数	：	pNew	- 新プロパティ																			//
//																												//
//	戻り値	：	TRUE - OK,	FALSE - Error																		//
//==============================================================================================================//
BOOL	G3dSetBorderColor(PWRK3DGRAPH pW, COLORREF color)
{
	BOOL	rc = FALSE;
	HPEN			hPen;

	if (hPen = CreatePen(PS_SOLID, 1, color)) {
		if (pW->hPenBorder != NULL) DeleteObject(pW->hPenBorder);
		pW->RgbBorder  = color;
		pW->hPenBorder = hPen;
		InvalidateRect(pW->hMain, NULL, FALSE);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	全ポイント３Ｄ→２Ｄ座標変換																				//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	G3dCnvAllPoints(PWRK3DGRAPH pW)
{
	UI		i, j;

	//----- 回転マトリクス設定 ---------------------------------------------------------------------------------//
	SetMatrix(pW);

	//----- ３軸 -----------------------------------------------------------------------------------------------//
	for (i = 0; i < AJC3DG_MAXAXIS; i++) {
		G3dCnv3dTo2d(pW, &pW->AxisInfo[i].s.v3, &pW->AxisInfo[i].s.v2);
		G3dCnv3dTo2d(pW, &pW->AxisInfo[i].e.v3, &pW->AxisInfo[i].e.v2);
	}
	//----- 描画データ -----------------------------------------------------------------------------------------//
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		PGI_INFO	p;
		if (p = AjcVQueTopNode(pW->DatItem[i].hQueDat, NULL)) {
			do {
				switch (p->h.gic) {
					case GIC_POINT:
						G3dCnv3dTo2d(pW, &p->poi.p.v3, &p->poi.p.v2);
						break;

					case GIC_LINE:
						G3dCnv3dTo2d(pW, &p->line.p1.v3, &p->line.p1.v2);
						G3dCnv3dTo2d(pW, &p->line.p2.v3, &p->line.p2.v2);
						break;

					case GIC_TRIAN:
						G3dCnv3dTo2d(pW, &p->tri.p1.v3, &p->tri.p1.v2);
						G3dCnv3dTo2d(pW, &p->tri.p2.v3, &p->tri.p2.v2);
						G3dCnv3dTo2d(pW, &p->tri.p3.v3, &p->tri.p3.v2);
						break;

					case GIC_SQUA:
						G3dCnv3dTo2d(pW, &p->squa.p1.v3, &p->squa.p1.v2);
						G3dCnv3dTo2d(pW, &p->squa.p2.v3, &p->squa.p2.v2);
						G3dCnv3dTo2d(pW, &p->squa.p3.v3, &p->squa.p3.v2);
						G3dCnv3dTo2d(pW, &p->squa.p4.v3, &p->squa.p4.v2);
						break;

					case GIC_ELPS:
						for (j = 0; j < G3D_ELPSPOINTS; j++) {
							G3dCnv3dTo2d(pW, &p->elps.p[j].v3, &p->elps.p[j].v2);
						}
						break;

					case GIC_FILL:
						G3dCnv3dTo2d(pW, &p->fill.p.v3, &p->fill.p.v2);
						break;

				}
			} while (p = AjcVQueNextNode(pW->DatItem[i].hQueDat, p, NULL));
		}
	}
	//----- プロットデータ -------------------------------------------------------------------------------------//
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		PGI_VEC	p = pW->DatItem[i].plot.pBuf;
		for (j = 0; j < pW->DatItem[i].plot.cnt; j++) {
			G3dCnv3dTo2d(pW, &p->v3, &p->v2);
			p++;
		}
	}
}
//==============================================================================================================//
//	３Ｄ→２Ｄ座標変換（平行投影）																				//
//																												//
//	引　数	：	p3D - ３Ｄ座標データのアドレス																	//
//				p2D - 変換した２Ｄ座標データを格納するバッファのアドレス										//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	G3dCnv3dTo2d(PWRK3DGRAPH pW, PCAJC3DVEC p3D, LPPOINT p2D)
{
	AJC3DVEC	v;
	double		xc = pW->ww / 2;
	double		yc = pW->wh / 2;
	double		x, y, xr, yr;

	if (pW->prop.fAspect1) {
		xr = yr = __min(xc, yc);
	}
	else {
		xr = xc;
		yr = yc;
	}

	if		(G3dIsAngleXY(pW)) {
		p2D->x = G3dCnvValToX(pW, pW->prop.Cent.x, pW->prop.xr, p3D->x, FALSE);
		p2D->y = G3dCnvValToY(pW, pW->prop.Cent.y, pW->prop.yr, p3D->y, FALSE);
	}
	else if (G3dIsAngleXZ(pW)) {
		p2D->x = G3dCnvValToX(pW, pW->prop.Cent.x, pW->prop.xr, p3D->x, FALSE);
		p2D->y = G3dCnvValToY(pW, pW->prop.Cent.z, pW->prop.zr, p3D->z, FALSE);
	}
	else if (G3dIsAngleYZ(pW)) {
		p2D->x = G3dCnvValToX(pW, pW->prop.Cent.y, pW->prop.yr, p3D->y, FALSE);
		p2D->y = G3dCnvValToY(pW, pW->prop.Cent.z, pW->prop.zr, p3D->z, FALSE);
	}
	else {
		memcpy(&v, p3D, sizeof v);
		v.x = (v.x - pW->prop.Cent.x) / pW->prop.xr * pW->prop.ratio;
		v.y = (v.y - pW->prop.Cent.y) / pW->prop.yr * pW->prop.ratio;
		v.z = (v.z - pW->prop.Cent.z) / pW->prop.zr * pW->prop.ratio;
		AjcV3dMultMat(&v, &pW->MatZ, &v);
		AjcV3dMultMat(&v, &pW->MatY, &v);
		AjcV3dMultMat(&v, &pW->MatX, &v);

		x = xc + (xr * v.x);
		y = yc + (yr * v.y);
		x += fmod(x, 0.5);
		y += fmod(y, 0.5);

		p2D->x = (int)(x);
		p2D->y = (int)(y);
		p2D->y = pW->wh - p2D->y;
	}
}
//==============================================================================================================//
//	アングル設定																								//
//==============================================================================================================//
//----- ＸＹ ---------------------------------------------------------------------------------------------------//
VO	G3dSetAngleXY(PWRK3DGRAPH pW)
{
	if (!G3dIsAngleXY(pW)) {
		pW->prop.Rot.x = pW->prop.Rot.y = pW->prop.Rot.z = 0.0;
		G3dCnvAllPoints(pW);
		InvalidateRect(pW->hMain, NULL, FALSE);
		PostMessage(pW->hMain, AJC3DGM_NEEDNTC_ANGLE, 0, 0);
	}
}
//----- ＸＺ ---------------------------------------------------------------------------------------------------//
VO	G3dSetAngleXZ(PWRK3DGRAPH pW)
{
	if (!G3dIsAngleXZ(pW)) {
		pW->prop.Rot.x = 90.0;
		pW->prop.Rot.y =  0.0;
		pW->prop.Rot.z =  0.0;
		G3dCnvAllPoints(pW);
		InvalidateRect(pW->hMain, NULL, FALSE);
		PostMessage(pW->hMain, AJC3DGM_NEEDNTC_ANGLE, 0, 0);
	}
}
//----- ＹＺ ---------------------------------------------------------------------------------------------------//
VO	G3dSetAngleYZ(PWRK3DGRAPH pW)
{
	if (!G3dIsAngleYZ(pW)) {
		pW->prop.Rot.x = 90.0;
		pW->prop.Rot.y =  0.0;
		pW->prop.Rot.z = 90.0;
		G3dCnvAllPoints(pW);
		InvalidateRect(pW->hMain, NULL, FALSE);
		PostMessage(pW->hMain, AJC3DGM_NEEDNTC_ANGLE, 0, 0);
	}
}
//----- ３Ｄ ---------------------------------------------------------------------------------------------------//
VO	G3dSetAngle3D(PWRK3DGRAPH pW)
{
	if (!G3dIsAngle3D(pW)) {
		pW->prop.Rot.x = 60.0;
		pW->prop.Rot.y = 10.0;
		pW->prop.Rot.z = 45.0;
		G3dCnvAllPoints(pW);
		InvalidateRect(pW->hMain, NULL, FALSE);
		PostMessage(pW->hMain, AJC3DGM_NEEDNTC_ANGLE, 0, 0);
	}
}
//----- 任意の平面 ---------------------------------------------------------------------------------------------//
VO	G3dSetPlane(PWRK3DGRAPH pW)
{
}
//==============================================================================================================//
//	アングルチェック																							//
//==============================================================================================================//
//----- 平面アングル -------------------------------------------------------------------------------------------//
PCROTPLANE	G3dIsAnglePlane(PWRK3DGRAPH pW)
{
	PCROTPLANE	rc = NULL;
	double	mx = fmod(pW->prop.Rot.x, 90.0);
	double	my = fmod(pW->prop.Rot.y, 90.0);
	double	mz = fmod(pW->prop.Rot.z, 90.0);

	if (fabs(mx) < 0.0001 && fabs(my) < 0.0001 && fabs(mz) < 0.0001) {
		int		rx = (SW)pW->prop.Rot.x;
		int		ry = (SW)pW->prop.Rot.y;
		int		rz = (SW)pW->prop.Rot.z;
		rc = G3dRpSearchTheta(rx, ry, rz);
	}
	return	rc;
}
//----- ＸＹ ---------------------------------------------------------------------------------------------------//
BOOL	G3dIsAngleXY(PWRK3DGRAPH pW)
{
	BOOL	rc;

	if (pW->prop.Rot.x == 0.0 && pW->prop.Rot.y == 0.0 && pW->prop.Rot.z == 0.0) rc = TRUE;
	else																		 rc = FALSE;

	return	rc;
}
//----- ＸＺ ---------------------------------------------------------------------------------------------------//
BOOL	G3dIsAngleXZ(PWRK3DGRAPH pW)
{
	BOOL	rc;

	if (pW->prop.Rot.x == 90.0 && pW->prop.Rot.y == 0.0 && pW->prop.Rot.z == 0.0) rc = TRUE;
	else																		  rc = FALSE;

	return	rc;
}
//----- ＹＺ ---------------------------------------------------------------------------------------------------//
BOOL	G3dIsAngleYZ(PWRK3DGRAPH pW)
{
	BOOL	rc;

	if (pW->prop.Rot.x == 90.0 && pW->prop.Rot.y == 0.0 && pW->prop.Rot.z == 90.0) rc = TRUE;
	else																		   rc = FALSE;

	return	rc;
}
//----- ３Ｄ ---------------------------------------------------------------------------------------------------//
BOOL	G3dIsAngle3D(PWRK3DGRAPH pW)
{
	BOOL	rc;

	if (pW->prop.Rot.x == 60.0 && pW->prop.Rot.y == 10.0 && pW->prop.Rot.z == 45.0) rc = TRUE;
	else																			rc = FALSE;

	return	rc;
}
//==============================================================================================================//
//	スケール情報設定																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO	G3dSetScaleInfo(PWRK3DGRAPH pW)
{
	SubSetScaleInfo(pW, &pW->AxisInfo[IX_X]);
	SubSetScaleInfo(pW, &pW->AxisInfo[IX_Y]);
	SubSetScaleInfo(pW, &pW->AxisInfo[IX_Z]);
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubSetScaleInfo(PWRK3DGRAPH pW, PAXIS_INF pAxi)
{
	double	len = __min(pW->ww, pW->wh);
	UI		d1, d2, d3, p1, p2, p3;

	//----- スケールステップサイズ算出 -----------------------------------------------------//
	if (len != 0) {
		pAxi->Sif.step = AjcCalcRangeStep((pAxi->r * 2), 6.0, (len / (double)pW->SifCyUnit),
				 &d1, &p1);
	}
	else {
		pAxi->Sif.step = pAxi->r * 2;
		d1 = p1 = 0;
	}
	//----- スケール値桁数設定 -------------------------------------------------------------//
	AjcAdjustPow10(pAxi->Cent + pAxi->r, &d2, &p2);
	AjcAdjustPow10(pAxi->Cent - pAxi->r, &d3, &p3);
	pAxi->Sif.digit = __max(d1, __max(d2, d3));
	pAxi->Sif.prec	= __max(p1, __max(p2, p3));
	//------ スケール最小値／最大値算出 ----------------------------------------------------//
	if (pW->style & AJC3DGS_ELPSSCALE) {
		UI		n = (UI)(pAxi->r / pAxi->Sif.step);
		double	w = pAxi->Sif.step * (double)n;
		pAxi->Sif.min = pAxi->Cent - w;
		pAxi->Sif.max = pAxi->Cent + w;
	}
	else {
		pAxi->Sif.min = pAxi->Cent - pAxi->r;
		pAxi->Sif.max = pAxi->Cent + pAxi->r;
		pAxi->Sif.min -= fmod(pAxi->Sif.min, pAxi->Sif.step);
		pAxi->Sif.max -= fmod(pAxi->Sif.max, pAxi->Sif.step);
	}
	pAxi->Sif.step *= 0.99999999999;
//	pAxi->Sif.min -= (pAxi->Sif.step / 100000.0);
//	pAxi->Sif.max += (pAxi->Sif.step / 100000.0);
}
//==============================================================================================================//
//	平面上の点位置を３Ｄ位置に変換																				//
//																												//
//	引　数	：	p2d			- ２Ｄポイント																		//
//				pCent		- 平面上の中心位置と法線															//
//				pBase		- 基準軸の単位ベクトル																//
//				p3dBuf		- ３Ｄポイントを格納するバッファ													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
VO		G3dPlanePointTo3dPoint(PWRK3DGRAPH pW, PCAJC2DVEC p2d, PCAJC3DLVEC pCent, PCAJC3DVEC pBase, PAJC3DVEC p3dBuf)
{
	double		r, t;
	AJC3DVEC	vb;

	r = sqrt(p2d->x * p2d->x + p2d->y * p2d->y);
	t = atan2(p2d->y, p2d->x);
	AjcV3dMult(pBase, r, &vb);
	AjcV3dRotateAny(&vb, AJC_RAD2DEG(t), &pCent->v, p3dBuf);
	AjcV3dAdd(p3dBuf, &pCent->p, p3dBuf);
}
//==============================================================================================================//
//	３Ｄモード設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		G3dSet3dMode(PWRK3DGRAPH pW)
{
	pW->f2dMode = FALSE;
}
//==============================================================================================================//
//	２Ｄモード設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		G3dSet2dMode(PWRK3DGRAPH pW)
{
	UI		i;

	pW->f2dMode = TRUE;

	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		pW->DatItem[i].PlnLVec.p.x = pW->prop.Cent.x;
		pW->DatItem[i].PlnLVec.p.y = pW->prop.Cent.y;
		pW->DatItem[i].PlnLVec.p.z = 0.0;
		pW->DatItem[i].PlnLVec.v.x = 0.0;
		pW->DatItem[i].PlnLVec.v.y = 0.0;
		pW->DatItem[i].PlnLVec.v.z = 1.0;
		pW->DatItem[i].PlnOrg.x	   = 1.0;
		pW->DatItem[i].PlnOrg.y	   = 0.0;
		pW->DatItem[i].PlnOrg.z	   = 0.0;
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	回転マトリクス設定																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetMatrix(PWRK3DGRAPH pW)
{
	double	s, c;

	//----- Ｘ軸回転マトリクス -----//
	s = sin(AJC_DEG2RAD(pW->prop.Rot.x));
	c = cos(AJC_DEG2RAD(pW->prop.Rot.x));
	pW->MatX.m[0][0] = 1.0;		pW->MatX.m[0][1] = 0;		pW->MatX.m[0][2] = 0;
	pW->MatX.m[1][0] = 0;		pW->MatX.m[1][1] = c;		pW->MatX.m[1][2] = s;
	pW->MatX.m[2][0] = 0;		pW->MatX.m[2][1] = -s;		pW->MatX.m[2][2] = c;

	//----- Ｙ軸回転マトリクス -----//
	s = sin(AJC_DEG2RAD(pW->prop.Rot.y));
	c = cos(AJC_DEG2RAD(pW->prop.Rot.y));
	pW->MatY.m[0][0] = c;		pW->MatY.m[0][1] = 0;		pW->MatY.m[0][2] = -s;
	pW->MatY.m[1][0] = 0;		pW->MatY.m[1][1] = 1.0;		pW->MatY.m[1][2] = 0;
	pW->MatY.m[2][0] = s;		pW->MatY.m[2][1] = 0;		pW->MatY.m[2][2] = c;

	//----- Ｚ軸回転マトリクス -----//
	s = sin(AJC_DEG2RAD(pW->prop.Rot.z));
	c = cos(AJC_DEG2RAD(pW->prop.Rot.z));
	pW->MatZ.m[0][0] = c;		pW->MatZ.m[0][1] = s;		pW->MatZ.m[0][2] = 0;
	pW->MatZ.m[1][0] = -s;		pW->MatZ.m[1][1] = c;		pW->MatZ.m[1][2] = 0;
	pW->MatZ.m[2][0] = 0;		pW->MatZ.m[2][1] = 0;		pW->MatZ.m[2][2] = 1.0;
}
