﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	フィィルタウインド処理											//
//																												//
//**************************************************************************************************************//

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Filt);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		G3dWndProcFilt()
{
	return AJC_WNDPROC_NAME(Filt);
}
//==============================================================================================================//
//																												//
//	フィルタウインド生成																						//
//																												//
//==============================================================================================================//
HWND	G3dCreateWndFilter  (PWRK3DGRAPH pW, WCP pClsName)
{
	HWND	rc = NULL;
	rc = CreateWindow(pClsName,								// window class name
			L"",											// window caption
			WS_CHILD,										// window style
			0,												// initial x position
			0,												// initial y position
			(G3D_FLT_WIDTH  + 5) * (AJC3DG_MAXITEM / 2),		// initial x size
			(G3D_FLT_HEIGHT + 4) * 2 + 1,					// initial y size
			pW->hMain,										// parent window handle
			NULL,											// window menu handle
			hDllInst,										// program instance handle
			pW);											// creation parameters
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	フィルタウインドプロシージャ																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_CREATE		)
{
	PWRK3DGRAPH	pW = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	int			i, x1, x2, y1, y2;

	MAjcSetWindowLong(hwnd, 0, (UX)pW);

	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		x1 = 2 + (G3D_FLT_WIDTH + 5) * (i % 8);					   x2 = x1 + G3D_FLT_WIDTH;
		y1 = 2 + (G3D_FLT_HEIGHT * (i / 8)) + (((i / 8) != 0) * 5); y2 = y1 + G3D_FLT_HEIGHT;
		pW->hChkFilt[i] = CreateWindow(L"BUTTON",									// window class name
									 L"",											// window caption
									 WS_CHILD | BS_AUTOCHECKBOX,					// window style
									 x1,											// initial x position
									 y1,											// initial y position
									 G3D_FLT_WIDTH,									// initial x size
									 G3D_FLT_HEIGHT,									// initial y size
									 hwnd,											// parent window handle
									 (HMENU)((UX)i + G3D_IDC_CHK_BASE),				// window menu handle
									 hDllInst,										// program instance handle
									 NULL);											// creation parameters
		if (pW->hChkFilt[i] != NULL) {
			ShowWindow(pW->hChkFilt[i], SW_SHOW);
			SendMessage(pW->hChkFilt[i], BM_SETCHECK, BST_CHECKED, 0);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_DESTROY	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	int			i;

	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		if (pW->hChkFilt[i] != NULL) {
			DestroyWindow(pW->hChkFilt[i]);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_COMMAND	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	UI			ix;

	ix = LOWORD(wParam) - G3D_IDC_CHK_BASE;
	if (ix >= 0	 &&	 ix < AJC3DG_MAXITEM  &&  HIWORD(wParam) == BN_CLICKED) {
		if (SendMessage(pW->hChkFilt[ix], BM_GETCHECK, 0, 0)) pW->MskFilt |=  (1 << ix);
		else												  pW->MskFilt &= ~(1 << ix);
		pW->fReDrawData = TRUE;
		InvalidateRect(pW->hMain, NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Filt, WM_PAINT		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HBRUSH		hBrush;
	HPEN		hPen;
	int			i, x1, x2, y1, y2;

	hdc	  = BeginPaint(hwnd, &ps);
	hBrush = (HBRUSH)SelectObject(hdc, GetStockObject(NULL_BRUSH));
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		hPen = (HPEN)SelectObject(hdc, pW->DatItem[i].RgbInfo.hPenP);
		x1 = 2 + (G3D_FLT_WIDTH + 5) * (i % 8);					   x2 = x1 + G3D_FLT_WIDTH;
		y1 = (i < 8) ? 2 : G3D_FLT_HEIGHT + 7;  y2 = y1 + G3D_FLT_HEIGHT;
		Rectangle(hdc, x1 - 1, y1 - 1, x2 + 1, y2 + 1);
		Rectangle(hdc, x1 - 2, y1 - 2, x2 + 2, y2 + 2);
		hPen = (HPEN)SelectObject(hdc, hPen);
	}
	SelectObject(hdc, hBrush);
	
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Filt)
	AJC_WNDMAP_MSG(Filt, WM_CREATE	)
	AJC_WNDMAP_MSG(Filt, WM_DESTROY	)
	AJC_WNDMAP_MSG(Filt, WM_PAINT	)
	AJC_WNDMAP_MSG(Filt, WM_COMMAND	)
AJC_WNDMAP_END
