﻿#include	"AjcInternal.h"
#include	"AjcCtrl3dGraphicDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（３Ｄグラフィック）	メインウインド処理												//
//																												//
//**************************************************************************************************************//

#define	IX_X			0				//	Ｘ軸情報インデクス
#define	IX_Y			1				//	Ｙ　　〃
#define	IX_Z			2				//	Ｚ　　〃

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);

static	VO		SetPropByText(PWRK3DGRAPH pW, WCP pTxt, PAJC3DGPROP pProp);
static	UI		MakePropText	  (PWRK3DGRAPH pW, WCP pTxt, UI lTxt);
static	VO		DeleteAllResource(PWRK3DGRAPH pW);
static	VO		StyleSetting(PWRK3DGRAPH pW);
static	VO		EnableCtrls(PWRK3DGRAPH pW, BOOL fEnable);
static	int		SearchIdByRGB(PWRK3DGRAPH pW, COLORREF rgb);
static	VO		AppendPlotList(PWRK3DGRAPH pW, UI id, LPPOINT p2d);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		G3dWndProcMain()
{
	return AJC_WNDPROC_NAME(Main);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メインウインドプロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE		)
{
	LRESULT			rc = -1;
	PWRK3DGRAPH		pW = NULL;
	AJC3DGPROP		prop;
	RECT			r;
	WC				PropTxt[1024];
	UI				i;
	HINSTANCE		hModuleInstance = GetModuleHandle(NULL);
	HDC				hdc;
	TEXTMETRIC		tm;
	HFONT			hFont;
//	UI				sty;

	do {
		//----- ワーク初期化 -----------------------------------------------------------------------------------//
		if ((pW = (PWRK3DGRAPH)AJCMEM(sizeof(WRK3DGRAPH))) == NULL) break;
		memset(pW, 0, sizeof(WRK3DGRAPH));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = G3D_INST_ID;
		//----- スケール描画色情報 -----------------------------------------------------------------------------//
		pW->RgbScale.RgbP  = RGB(210, 210, 210);
		pW->RgbScale.RgbN  = RGB(230, 230, 230);
		pW->RgbScale.hBruP = (HBRUSH)GetStockObject(NULL_BRUSH);
		pW->RgbScale.hBruN = (HBRUSH)GetStockObject(NULL_BRUSH);
		pW->RgbScale.hPenP = (HPEN)CreatePen(PS_SOLID, 1, pW->RgbScale.RgbP);
		pW->RgbScale.hPenN = (HPEN)CreatePen(PS_SOLID, 1, pW->RgbScale.RgbN);
		if (pW->RgbScale.hPenP == NULL || pW->RgbScale.hPenN == NULL) break;
		//----- 球体スケール描画用ポイントバッファ初期化 -------------------------------------------------------//
		pW->SphPolyInfo.nArr = G3D_SPHERE_PTBUF;
		pW->SphPolyInfo.pPen = pW->clSphBuf;
		pW->SphPolyInfo.pPt  = pW->ptSphBuf;
		//----- フィルタマスク初期化 ---------------------------------------------------------------------------//
		pW->MskFilt = ((1 << AJC3DG_MAXITEM) - 1);
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- バックウインドのスタイルへ「WS_CLIPCHILDREN」追加 ----------------------------------------------//
	//	sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
	//	MAjcSetWindowLong(hwnd, GWL_STYLE, sty | WS_CLIPCHILDREN);
		//----- 軸情報初期化 -----------------------------------------------------------------------------------//
		pW->AxisInfo[0].MyIx = IX_X;
		pW->AxisInfo[1].MyIx = IX_Y;
		pW->AxisInfo[2].MyIx = IX_Z;
		//----- 自軸インデクス初期化 ---------------------------------------------------------------------------//
		for (i = 0; i < AJC3DG_MAXAXIS; i++) {
			pW->AxisInfo[i].MyIx = i;
		}
		//----- 平面設定初期化 ---------------------------------------------------------------------------------//
		pW->PlaneAxisH = AJCG3DAXIS_DIR_XP;
		pW->PlaneAxisV = AJCG3DAXIS_DIR_YP;
		//----- スケール情報初期化 -----------------------------------------------------------------------------//
		hdc = GetDC(hwnd);
		hFont = (HFONT)SelectObject(hdc, G3dhMyFont);
		GetTextMetrics(hdc, &tm);
		pW->SifCxChar = tm.tmAveCharWidth;
		pW->SifCyChar = tm.tmHeight;
		pW->SifCyUnit = pW->SifCyChar * 2;
		SelectObject(hdc, hFont);
		ReleaseDC(hwnd, hdc);
		//----- 平面定義情報初期化 -----------------------------------------------------------------------------//
		for (i = 0; i < AJC3DG_MAXITEM; i++) {
			pW->DatItem[i].PlnLVec.p.x = 0.0;
			pW->DatItem[i].PlnLVec.p.y = 0.0;
			pW->DatItem[i].PlnLVec.p.z = 0.0;
			pW->DatItem[i].PlnLVec.v.x = 0.0;
			pW->DatItem[i].PlnLVec.v.y = 0.0;
			pW->DatItem[i].PlnLVec.v.z = 1.0;
			pW->DatItem[i].PlnOrg.x	   = 1.0;
			pW->DatItem[i].PlnOrg.y	   = 0.0;
			pW->DatItem[i].PlnOrg.z	   = 0.0;
		}
		//----- ウインドサイズ設定 -----------------------------------------------------------------------------//
		pW->hMain = hwnd;
		GetClientRect(hwnd, &r);
		pW->ww	  = r.right - r.left;
		pW->wh	  = r.bottom - r.top;
		//----- ウインドスタイル取得 ---------------------------------------------------------------------------//
		pW->style = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
		//----- ウインドキャプション（文字列パラメタ）取得 -----------------------------------------------------//
		pW->fFirstGetText = TRUE;
		GetWindowText(hwnd, PropTxt, AJCTSIZE(PropTxt));
		//----- デフォルトプロパティ設定 -----------------------------------------------------------------------//
		memset(&prop, 0, sizeof prop);
		prop.Rot.x = 0; prop.Rot.y = 0; prop.Rot.z = 0;
		prop.Cent.x = 0.0;
		prop.Cent.y = 0.0;
		prop.Cent.z = 0.0;
		prop.xr = 1.0;
		prop.yr = 1.0;
		prop.zr = 1.0;
		prop.ratio = 0.7;
		prop.PlotSize  = 2;
		prop.PlotSizeE = 3;
		prop.fPlotLine = TRUE;
		prop.fAspect1  = TRUE;

		prop.axis[0].rgbP = RGB(  0,   0, 255); prop.axis[0].rgbN = RGB(160, 160, 255); 
		prop.axis[1].rgbP = RGB(255,   0,	0); prop.axis[1].rgbN = RGB(255, 160, 160); 
		prop.axis[2].rgbP = RGB(  0, 224,	0); prop.axis[2].rgbN = RGB( 64, 255,  64); 

		prop.Item[ 0].rgbP = RGB(  0,	0, 255); prop.Item[ 0].rgbN = RGB(160, 160, 255);	//	0
		prop.Item[ 1].rgbP = RGB(255,	0,	 0); prop.Item[ 1].rgbN = RGB(255, 160, 160);	//	1
		prop.Item[ 2].rgbP = RGB(  0, 224,	 0); prop.Item[ 2].rgbN = RGB( 64, 255,	 64);	//	2
		prop.Item[ 3].rgbP = RGB(  0, 224, 224); prop.Item[ 3].rgbN = RGB(160, 255, 255);	//	3
		prop.Item[ 4].rgbP = RGB(255,	0, 255); prop.Item[ 4].rgbN = RGB(255, 160, 255);	//	4
		prop.Item[ 5].rgbP = RGB(192, 192,	 0); prop.Item[ 5].rgbN = RGB(206, 206, 128);	//	5
		prop.Item[ 6].rgbP = RGB(128, 128, 128); prop.Item[ 6].rgbN = RGB(192, 192, 192);	//	6
		prop.Item[ 7].rgbP = RGB(  0,	0,	 0); prop.Item[ 7].rgbN = RGB(160, 160, 160);	//	7
		prop.Item[ 8].rgbP = RGB(  0,	0, 190); prop.Item[ 8].rgbN = RGB( 90,	90, 190);	//	8
		prop.Item[ 9].rgbP = RGB(190,	0,	 0); prop.Item[ 9].rgbN = RGB(190,	90,	 90);	//	9
		prop.Item[10].rgbP = RGB(  0, 190,	 0); prop.Item[10].rgbN = RGB( 90, 190,	 90);	// 10
		prop.Item[11].rgbP = RGB(  0, 160, 160); prop.Item[11].rgbN = RGB( 90, 160, 160);	// 11
		prop.Item[12].rgbP = RGB(160,	0, 160); prop.Item[12].rgbN = RGB(160, 190, 220);	// 12
		prop.Item[13].rgbP = RGB(160, 160,	 0); prop.Item[13].rgbN = RGB(190,	90, 160);	// 13
		prop.Item[14].rgbP = RGB( 64, 180, 180); prop.Item[14].rgbN = RGB(128, 180, 180);	// 14
		prop.Item[15].rgbP = RGB(128, 128,	64); prop.Item[15].rgbN = RGB(180, 180, 128);	// 15

		prop.Item[ 0].MaxPlot = 16;
		prop.Item[ 1].MaxPlot = 16;
		prop.Item[ 2].MaxPlot = 16;
		prop.Item[ 3].MaxPlot = 16;
		prop.Item[ 4].MaxPlot = 16;
		prop.Item[ 5].MaxPlot = 16;
		prop.Item[ 6].MaxPlot = 16;
		prop.Item[ 7].MaxPlot = 16;
		prop.Item[ 8].MaxPlot = 16;
		prop.Item[ 9].MaxPlot = 16;
		prop.Item[10].MaxPlot = 16;
		prop.Item[11].MaxPlot = 16;
		prop.Item[12].MaxPlot = 16;
		prop.Item[13].MaxPlot = 16;
		prop.Item[14].MaxPlot = 16;
		prop.Item[15].MaxPlot = 16;
		//----- ボーダーペンハンドル設定 -----------------------------------------------------------------------//
		pW->RgbBorder  = RGB(  0,	0,	 0);
		if ((pW->hPenBorder = CreatePen(PS_SOLID, 1, pW->RgbBorder)) == NULL) break;
		//----- データキュー生成 -------------------------------------------------------------------------------//
		for (i = 0; i < AJC3DG_MAXITEM; i++) {
			if ((pW->DatItem[i].hQueDat = AjcVQueCreate(0, NULL)) == NULL) break;
		}
		if (i < AJC3DG_MAXITEM) break;
		//----- 描画順ノードポインタ用ＡＶＬ生成 ---------------------------------------------------------------//
		pW->hAvlDat = AjcAvlCreate (0, NULL, NULL);
		if (pW->hAvlDat == NULL) break;
		//----- ドロップファイル名一時保留バッファ生成 ---------------------------------------------------------//
		pW->hRngFile = AjcRngCreate(&pW->StaRngFile, sizeof pW->StaRngFile, 4096);
		if (pW->hRngFile == NULL) break;
		//----- ドロップＤＩＲ名一時保留バッファ生成 -----------------------------------------------------------//
		pW->hRngDir	 = AjcRngCreate(&pW->StaRngDir , sizeof pW->StaRngDir , 4096);
		if (pW->hRngDir	 == NULL) break;
		//----- チップテキスト表示条件 -------------------------------------------------------------------------//
		pW->fShowAlways = TRUE;
		for (i = 0; i < AJC3DG_MAXITEM; i++) {
			pW->fChkBoxShowAlways[i] = TRUE;
		}
		//----- フィルタウインド生成 ---------------------------------------------------------------------------//
		pW->hFilter = G3dCreateWndFilter(pW, (WCP)G3dClassFilter);
		if (pW->hFilter == NULL) {
			break;
		}
		//----- ワイド／ズームボタン生成 ---------------------------------------------------------------------------//
		pW->hBtnWide = CreateWindow(L"BUTTON",							// window class name
								L"",									// window caption
								WS_CHILD | BS_ICON,						// window style
								0,										// initial x position
								0,										// initial y position
								G3D_BTN_WIDTH,							// initial x size
								G3D_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								(HMENU)G3D_IDC_BTN_WIDE,				// window menu handle
								hDllInst,								// program instance handle
								NULL);									// creation parameters
		if (pW->hBtnWide != NULL) {
			SendMessage(pW->hBtnWide, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoWide);
		}
		else break;

		pW->hBtnZoom = CreateWindow(L"BUTTON",							// window class name
								L"",									// window caption
								WS_CHILD | BS_ICON,						// window style
								0,										// initial x position
								0,										// initial y position
								G3D_BTN_WIDTH,							// initial x size
								G3D_BTN_HEIGHT,							// initial y size
								hwnd,									// parent window handle
								(HMENU)G3D_IDC_BTN_ZOOM,				// window menu handle
								hDllInst,								// program instance handle
								NULL);									// creation parameters
		if (pW->hBtnZoom != NULL) {
			SendMessage(pW->hBtnZoom, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoZoom);
		}
		else break;

		//----- 視点角度変化通知の為のダミー値設定 -------------------------------------------------------------//
		pW->prop.Rot.x = pW->prop.Rot.y = pW->prop.Rot.z = DBL_MAX;
		//----- プロパティ設定 ---------------------------------------------------------------------------------//
		SetPropByText(pW, PropTxt, &prop);
		if (!G3dSetCtrlProp(pW, &prop)) break;
		//----- スタイル設定 -----------------------------------------------------------------------------------//
		pW->style = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
		StyleSetting(pW);
		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));
		//----- チャイルドウインド・クリップスタイル設定 -------------------------------------------------------//
		MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) | WS_CLIPCHILDREN);

		//----- メモリＤＣ作成 ---------------------------------------------------------------------------------//
		{
			HDC hdc = GetDC(hwnd);
			pW->mdc = CreateCompatibleDC(hdc);
			pW->sdc = CreateCompatibleDC(hdc);
			pW->ddc = CreateCompatibleDC(hdc);
			ReleaseDC(hwnd, hdc);
			if (pW->mdc == NULL || pW->sdc == NULL || pW->ddc == NULL) {
				break;
			}
		}
		//----- フィルタ／ボタン表示監視タイマ起動 -------------------------------------------------------------//
		SetTimer(hwnd, 1, 200, NULL);
		//----- ツールチップテキスト初期化 ---------------------------------------------------------------------//
		AjcTipTextAdd(pW->hBtnWide, LNGSEL(L"縮小表示", L"Shrink"));
		AjcTipTextAdd(pW->hBtnZoom, LNGSEL(L"拡大表示", L"Zoomed"));

		//----- テキスト描画情報初期化 -------------------------------------------------------------------------//
		pW->hFontTxo = AjcGetStockFont(AJCFID_VAR12);
		pW->kAvlTxo = 1;		//	ＡＶＬキー
		if ((pW->hAvlTxo = AjcAvlCreate(0, NULL, NULL)) == NULL) {
			break;
		}

		//----- 戻り値＝正常 -----------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	if (rc == -1) {
		if (pW != NULL) {
			DeleteAllResource(pW);
			free(pW);
			MAjcSetWindowLong(hwnd, 0, (LPARAM)NULL);
		}
	}

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);


	//----- フィルタ／ボタン表示監視タイマ停止 ------------//
	KillTimer(hwnd, 1);

	if (pW != NULL) {
		DeleteAllResource(pW);
		free(pW);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	HDC		hdc;

	//----- ウインドサイズ設定 -----------------------------//
	pW->ww = LOWORD(lParam);
	pW->wh = HIWORD(lParam);

	//----- ワイド／ズームボタン移動 -----------------------//
	if (pW->hBtnWide) SetWindowPos(pW->hBtnWide, NULL, pW->ww - (G3D_BTN_WIDTH * 2 + G3D_BTN_MRG), G3D_BTN_MRG, 0, 0, SWP_NOSIZE);
	if (pW->hBtnZoom) SetWindowPos(pW->hBtnZoom, NULL, pW->ww - (G3D_BTN_WIDTH	   + G3D_BTN_MRG), G3D_BTN_MRG, 0, 0, SWP_NOSIZE);

	//----- 描画速度情報表示ダイアログ移動 -----------------//
	if (pW->hDlgMesDraw != NULL) {
		AjcViewMesTimeMove(pW->hDlgMesDraw);
	}
	//----- 描画計測時間クリアー ---------------------------//
	memset(&pW->MesDraw, 0, sizeof pW->MesDraw);
	pW->MesDraw.Min = -1;

	//----- ビットマップ生成 -------------------------------//
	if (pW->hBmpImg != NULL) {DeleteObject(pW->hBmpImg);}
	if (pW->hBmpSca != NULL) {DeleteObject(pW->hBmpSca);}
	if (pW->hBmpDat != NULL) {DeleteObject(pW->hBmpDat);}
	hdc = GetDC(hwnd);
	pW->hBmpImg = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);
	pW->hBmpSca = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);
	pW->hBmpDat = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);
	ReleaseDC(hwnd, hdc);
	//----- スケール情報計算 -------------------------------//
	G3dSetScaleInfo(pW);
	//----- ポイント情報再計算 -----------------------------//
	G3dCnvAllPoints(pW);
	//----- スケール，データ再描画フラグ設定 ---------------//
	pW->fReDrawScale = TRUE;
	pW->fReDrawData  = TRUE;

	InvalidateRect(hwnd, NULL, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	RECT		r;
	POINT		cp;

	//----- ポップアップボタン（フィルタ，ワイド／ズームボタン）表示／非表示の監視 ----------------//
	if (pW->fEnable) {
		//--- カーソル位置，ウインド位置取得 -------------//
		GetCursorPos(&cp);
		GetWindowRect(hwnd, &r);
		MapWindowPoints(NULL, hwnd, (LPPOINT)&cp, 1);
		MapWindowPoints(NULL, hwnd, (LPPOINT)&r , 2);
		//--- フィルタボタン表示／非表示 -----------------//
		if (!(pW->style & AJC3DGS_NOFILTER)) {
			if (cp.x >= 0 && cp.x < (G3D_FLT_WIDTH	+ 4) * (AJC3DG_MAXITEM / 2) &&
				cp.y >= 0 && cp.y < (G3D_FLT_HEIGHT + 4) * (AJC3DG_MAXITEM / 8)) {
				ShowWindow(pW->hFilter , SW_SHOW);
				ShowWindow(pW->hBtnWide, SW_HIDE);
				ShowWindow(pW->hBtnZoom, SW_HIDE);
			}
			else {
				ShowWindow(pW->hFilter, SW_HIDE);
			}
		}
		else {
			ShowWindow(pW->hFilter, SW_HIDE);
		}
		//--- ワイド／ズームボタン表示／非表示 -----------//
		if (!(pW->style & AJC3DGS_NOFILTER)) {
			if (cp.x >= r.right - (G3D_BTN_WIDTH * 2 + G3D_BTN_MRG) &&
				cp.x <= r.right - G3D_BTN_MRG					&&
				cp.y >= r.top + G3D_BTN_MRG					&&
				cp.y <= r.top + (G3D_BTN_HEIGHT + G3D_BTN_MRG)) {
				ShowWindow(pW->hBtnWide, SW_SHOW);
				ShowWindow(pW->hBtnZoom, SW_SHOW);
			}
			else {
				ShowWindow(pW->hBtnWide, SW_HIDE);
				ShowWindow(pW->hBtnZoom, SW_HIDE);
				InvalidateRect(pW->hMain, NULL, FALSE);
			}
		}
		else {
			ShowWindow(pW->hBtnWide, SW_HIDE);
			ShowWindow(pW->hBtnZoom, SW_HIDE);
			InvalidateRect(pW->hMain, NULL, FALSE);
		}
	}
	else {
		ShowWindow(pW->hFilter, SW_HIDE);
		ShowWindow(pW->hBtnWide, SW_HIDE);
		ShowWindow(pW->hBtnZoom, SW_HIDE);
		InvalidateRect(pW->hMain, NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	RECT		r;
	BOOL		fPause = pW->fPause;

	//	ＤＣ設定
	hdc  = BeginPaint(hwnd, &ps);

	//	描画時間計測リセット
	if (pW->hMesDraw != NULL) {
		AjcMesTimeInterval(pW->hMesDraw);
	}

	if (pW->mdc != NULL && pW->sdc != NULL && pW->ddc != NULL) {
		if (pW->hBmpImg == NULL) {pW->hBmpImg = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);}
		if (pW->hBmpSca == NULL) {pW->hBmpSca = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);}
		if (pW->hBmpDat == NULL) {pW->hBmpDat = CreateCompatibleBitmap(hdc, pW->ww, pW->wh);}

		if (pW->hBmpImg != NULL && pW->hBmpSca != NULL && pW->hBmpDat != NULL) {
			SelectObject(pW->mdc, pW->hBmpImg);
			SelectObject(pW->sdc, pW->hBmpSca);
			SelectObject(pW->ddc, pW->hBmpDat);
			//	スクリーンイメージ クリアー
			GetClientRect(hwnd, &r);
			if (pW->fEnable) {FillRect(pW->mdc, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));}
			else			 {FillRect(pW->mdc, &r, hBruBtnFace);}
			//	イメージ描画
			G3dDrawImage(pW);
			//	テキスト描画
			G3dDrawText(pW);
			//	タイトル描画
			SubTtlBmpDraw(&pW->TtlInfo, hwnd, pW->mdc, 2, 0, pW->fEnable);
			//	ウインド表示
			BitBlt(hdc, 0, 0, pW->ww, pW->wh, pW->mdc, 0, 0, SRCCOPY);
		}
	}
	//	描画時間の集計
	if (pW->hMesDraw != NULL) {
		ULL		tm = AjcMesTimeInterval(pW->hMesDraw);
		pW->MesDraw.Cnt++;
		pW->MesDraw.Sum += tm;
		pW->MesDraw.Ave	= pW->MesDraw.Sum / pW->MesDraw.Cnt;
		pW->MesDraw.Max	= __max(pW->MesDraw.Max, tm);
		pW->MesDraw.Min	= __min(pW->MesDraw.Min, tm);
	}

	//	ＤＣ解放
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_GETTEXTLENGTH)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	WC			txt[1024];

	MakePropText(pW, txt, AJCTSIZE(txt));

	return wcslen(txt);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_GETTEXT	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;

	if (pW->fFirstGetText) {
		pW->fFirstGetText = FALSE;
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = MakePropText(pW, (WCP)lParam, (UI)wParam);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SETTEXT	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;
	AJC3DGPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJC3DGPROP));
	SetPropByText(pW, (WCP)lParam, &prop);
	rc = G3dSetCtrlProp(pW, &prop);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
#define		FLG_REDRAW_SCALE	(AJC3DGS_RECTSCALE | AJC3DGS_ELPSSCALE | AJC3DGS_SHPERESCALE | AJC3DGS_SCALE | AJC3DGS_AXIS)

AJC_WNDPROC(Main, WM_STYLECHANGED)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p  = (LPSTYLESTRUCT)lParam;

	if (wParam == GWL_STYLE) {
		//	スケール，データ再描画フラグ設定
		if (pW->style != p->styleNew) {
			pW->fReDrawScale = TRUE;
			pW->fReDrawData  = TRUE;
		}
		//	新スタイル設定
		pW->style = p->styleNew;
		//	指定スタイルによる描画情報算出／再描画
		StyleSetting(pW);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_ENABLE)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);

	EnableCtrls(pW, pW->fEnable = (BOOL)wParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDOWN)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);

	if (pW->fEnable) {
		if (!(wParam & MK_SHIFT)) {	// [Ctrl + ] Click
			if (!(pW->style & AJC3DGS_NOANGLE)) {
				if (wParam & MK_CONTROL) pW->DrgMode = DRAGMD_Z;
				else					 pW->DrgMode = DRAGMD_XY;
				SetCapture(hwnd);
				pW->DrgSrt.x = pW->DrgEnd.x = (SW)LOWORD(lParam);
				pW->DrgSrt.y = pW->DrgEnd.y = (SW)HIWORD(lParam);
				memcpy(&pW->DrgRot, &pW->prop.Rot, sizeof pW->DrgRot);
			}
		}
		else {						// Shift + Click
			POINT			p2d;
			UI				id, msk;

			//--- クリック位置設定 -------------------------------//
			p2d.x = (SW)LOWORD(lParam);
			p2d.y = (SW)HIWORD(lParam);
			//--- プロット情報バッファ初期化 ---------------------//
			memset(&pW->PlotList, 0, sizeof pW->PlotList);
			//--- プロットリスト情報追加 -------------------------//
			for (id = 0, msk = 0x01; id < AJC3DG_MAXITEM; id++, msk <<= 1) {
				if (pW->MskFilt & msk) {
					AppendPlotList(pW, id, &p2d);
				}
			}
			//--- プロットリスト情報通知 -------------------------//
			if (pW->PlotList.num != 0) {
				SendMessage(GetParent(pW->hMain), WM_COMMAND,
						MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_PLOTLIST),
						fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)&pW->PlotList);
			}
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONUP)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);

	if (pW->DrgMode != DRAGMD_STOP) {
		pW->DrgMode = DRAGMD_STOP;
		ReleaseCapture();
		InvalidateRect(hwnd, NULL, FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_MOUSEMOVE)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	DRAGMODE		NewMode;
	int				x = (SW)LOWORD(lParam);
	int				y = (SW)HIWORD(lParam);

	if (pW->DrgMode != DRAGMD_STOP) {
		if (wParam & MK_CONTROL) NewMode = DRAGMD_Z;
		else					 NewMode = DRAGMD_XY;
		if (pW->DrgMode == NewMode) {
			//--- 回転角度更新 ------------------------------//
			pW->DrgEnd.x = x;
			pW->DrgEnd.y = y;
			if (pW->DrgMode == DRAGMD_XY) {
				pW->prop.Rot.x = pW->DrgRot.x + ((double)(pW->DrgEnd.x - pW->DrgSrt.x) / 2.0);
				pW->prop.Rot.y = pW->DrgRot.y + ((double)(pW->DrgEnd.y - pW->DrgSrt.y) / 2.0);
				pW->prop.Rot.x = fmod(pW->prop.Rot.x, 360.0);
				pW->prop.Rot.y = fmod(pW->prop.Rot.y, 360.0);
			}
			else {
				pW->prop.Rot.z = pW->DrgRot.z + ((double)(pW->DrgEnd.x - pW->DrgSrt.x) / 2.0);
				pW->prop.Rot.z = fmod(pW->prop.Rot.z, 360.0);
			}
			//--- 回転角度変化通知 ---------------------------//
			memcpy(&pW->NtcRotTheta, &pW->prop.Rot, sizeof(AJC3DVEC));
			SendMessage(GetParent(pW->hMain), WM_COMMAND,
						MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_ROTTHETA),
						fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)&pW->prop.Rot);
			//--- 全ポイントを２Ｄ座標変換 -------------------//
			G3dCnvAllPoints(pW);
			//--- スケール，データ再描画フラグ設定 -----------//
			pW->fReDrawScale = TRUE;
			pW->fReDrawData  = TRUE;
			//--- 再描画 -------------------------------------//
			InvalidateRect(hwnd, NULL, FALSE);
		}
		else {
			pW->DrgMode = NewMode;
			pW->DrgSrt.x = pW->DrgEnd.x = (SW)LOWORD(lParam);
			pW->DrgSrt.y = pW->DrgEnd.y = (SW)HIWORD(lParam);
			memcpy(&pW->DrgRot, &pW->prop.Rot, sizeof pW->DrgRot);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	計測情報取得コールバック
static VO CALLBACK cbMtvGetInfo  (PAJCMSTINFO pBuf, UX cbp)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)cbp;
	memcpy(pBuf, &pW->MesDraw, sizeof(AJCMSTINFO));
}
//	計測情報表示ダイアログクローズ通知
static VO CALLBACK cbMtvNtcClosed(UX cbp)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)cbp;
	//	描画時間計測インスタンス破棄
	if (pW->hMesDraw != NULL) { 
		AjcMesTimeDelete(pW->hMesDraw);
	}
	pW->hMesDraw	= NULL;
	pW->hDlgMesDraw = NULL;
}
//	ポップアップメニューＩＤ
enum {
	IDM_COPYBMAP	= 5001	,		//	ビットマップコピー
	IDM_SETRANGE			,		//	レンジ設定
	IDM_ADJUSTRANGE			,		//	レンジ自動設定
	IDM_SAMERANGE			,		//	各軸のレンジ幅を同一サイズにする
	IDM_FIXEDASPECT			,		//	アスペクト比を１固定にする
	IDM_VARIABLEASPECT		,		//	アスペクト比をウインドサイズに合わせる
	IDM_SHOWFILTER			,		//	フィルタ表示
	IDM_HIDEFILTER			,		//	フィルタ非表示
	IDM_SHOWXY				,		//	ＸＹ平面のアングルで表示
	IDM_SHOWXZ				,		//	ＸＺ　〃
	IDM_SHOWYZ				,		//	ＹＺ　〃
	IDM_SHOW3D				,		//	３Ｄのアングルで表示
	IDM_SHOWPLANE			,		//	任意の平面表示

	IDM_SHOWSQR				,		//	方眼スケール表示
	IDM_SHOWCIR				,		//	同心円スケール表示
	IDM_SHOWBALL			,		//	球スケール表示

	IDM_HIDESQR				,		//	方眼スケール非表示
	IDM_HIDECIR				,		//	同心円スケール非表示
	IDM_HIDEBALL			,		//	球スケール非表示

	IDM_SCALEXY_ON			,		//	ＸＹ平面にスケール表示
	IDM_SCALEXZ_ON			,		//	ＸＺ　〃
	IDM_SCALEYZ_ON			,		//	ＹＺ　〃

	IDM_SCALEXY_OFF			,		//	ＸＹ平面にスケール非表示
	IDM_SCALEXZ_OFF			,		//	ＸＺ　〃
	IDM_SCALEYZ_OFF			,		//	ＹＺ　〃

	IDM_DEPTH_ON			,		//	奥行き表現する
	IDM_DEPTH_OFF			,		//	奥行き表現しない

	IDM_CLEARDATA			,		//	データクリアー

	IDM_MESDRAW_ON			,		//	計測時間表示ＯＮ
	IDM_MESDRAW_OFF			,		//	計測時間表示ＯＦＦ
};
AJC_WNDPROC(Main, WM_RBUTTONDOWN)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	HMENU		hMenu;
	int			id;
	POINT		pt;
	int			sty;

	//	右クリック通知設定時（親ウインドへ専用メッセージ通知）
	if (pW->fNtcRClk) {
		if (pW->MsgRBDown != 0) {
			PostMessage(GetParent(hwnd), pW->MsgRBDown, wParam, lParam);
		}
	}
	//	CTRL/SHIFT 押下時（親ウインドへWM_COMMAND(AJC3DGN_RCLICK)通知）
	else if (wParam & (MK_CONTROL | MK_SHIFT)) {
		pW->NtcRClk.x		= (SW)LOWORD(lParam);
		pW->NtcRClk.y		= (SW)HIWORD(lParam);
		pW->NtcRClk.fShift	= ((wParam & MK_SHIFT  ) != 0);
		pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
		SendMessage(GetParent(pW->hMain), WM_COMMAND,
					MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_RCLICK),
					fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)&pW->NtcRClk);
	}
	//	CTRL/SHIFT 未押下時（ポップアップメニュー）
	else {
		sty = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
		hMenu = CreatePopupMenu();
		AppendMenu(hMenu, MFT_STRING, IDM_COPYBMAP	 , LNGSEL(L"コピー(&C)"			, L"&Copy to clipboard"));
		AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
		AppendMenu(hMenu, MFT_STRING, IDM_SETRANGE	 , LNGSEL(L"レンジ設定(&R)"		, L"Set &Range"		  ));
		AppendMenu(hMenu, MFT_STRING, IDM_ADJUSTRANGE, LNGSEL(L"レンジ自動調整(&A)"	, L"&Auto adjust range"));
		AppendMenu(hMenu, MFT_STRING, IDM_SAMERANGE	 , LNGSEL(L"各軸のレンジ幅を同一サイズにする(&M)", L"Make the range width of each axis the same size(&M)"));
		AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
		if (!pW->prop.fAspect1) AppendMenu(hMenu, MFT_STRING, IDM_FIXEDASPECT	, LNGSEL(L"アスペクト比を１固定にする(&P)"			  ,
																						 L"Set the aspect ratio to 1 1.0(&P)"));
		else					AppendMenu(hMenu, MFT_STRING, IDM_VARIABLEASPECT, LNGSEL(L"アスペクト比をウインドサイズに合わせる(&P)" ,
																						 L"Fit the aspect ratio to the window size(&P)"));

		if (pW->style & AJC3DGS_NOFILTER) AppendMenu(hMenu, MFT_STRING, IDM_SHOWFILTER, LNGSEL(L"フィルタ表示(&F)"	 , L"Show &Filter"));
		else							  AppendMenu(hMenu, MFT_STRING, IDM_HIDEFILTER, LNGSEL(L"フィルタ非表示(&F)" , L"Hide &Filter"));

		if (pW->f2dMode) {
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_SHOWPLANE	 , LNGSEL(L"平面のアングル設定(&L)"	   , L"Set plane angle(&L)" ));

			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			if (!(pW->style & AJC3DGS_RECTSCALE	 )) AppendMenu(hMenu, MFT_STRING, IDM_SHOWSQR	 , LNGSEL(L"方眼スケール表示(&4)"	   , L"Show grid scale(&4)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_HIDESQR	 , LNGSEL(L"方眼スケール非表示(&4)"	   , L"Hide grid scale(&4)"));

			if (!(pW->style & AJC3DGS_ELPSSCALE	 )) AppendMenu(hMenu, MFT_STRING, IDM_SHOWCIR	 , LNGSEL(L"同心円スケール表示(&5)"	   , L"Show concentric scale(&5)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_HIDECIR	 , LNGSEL(L"同心円スケール非表示(&5)"  , L"Hide concentric scale(&5)"));

			if (!(pW->style & AJC3DGS_SCALE_XY	 )) AppendMenu(hMenu, MFT_STRING, IDM_SCALEXY_ON , LNGSEL(L"スケール表示(&7)"		   , L"Show scale(&7)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_SCALEXY_OFF, LNGSEL(L"スケール非表示(&7)" 	   , L"Hide scale(&7)"));
		}
		else {
			if (!(pW->style & AJC3DGS_NOANGLE)) {
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
				AppendMenu(hMenu, MFT_STRING, IDM_SHOWXY	 , LNGSEL(L"Ｘ-Ｙ座標面(&0)"	   , L"View X-Y angle(&0)" ));
				AppendMenu(hMenu, MFT_STRING, IDM_SHOWXZ	 , LNGSEL(L"Ｘ-Ｚ座標面(&1)"	   , L"View X-Z angle(&1)" ));
				AppendMenu(hMenu, MFT_STRING, IDM_SHOWYZ	 , LNGSEL(L"Ｙ-Ｚ座標面(&2)"	   , L"View Y-Z angle(&2)" ));
				AppendMenu(hMenu, MFT_STRING, IDM_SHOW3D	 , LNGSEL(L"３Ｄ 座標面(&3)"	   , L"View 3D askance(&3)"));
				AppendMenu(hMenu, MFT_STRING, IDM_SHOWPLANE	 , LNGSEL(L"任意の平面表示(&L)"	   , L"View any plane(&L)" ));
				AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			}

			if (!(pW->style & AJC3DGS_RECTSCALE	 )) AppendMenu(hMenu, MFT_STRING, IDM_SHOWSQR	 , LNGSEL(L"方眼スケール表示(&4)"	   , L"Show grid scale(&4)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_HIDESQR	 , LNGSEL(L"方眼スケール非表示(&4)"	   , L"Hide grid scale(&4)"));

			if (!(pW->style & AJC3DGS_ELPSSCALE	 )) AppendMenu(hMenu, MFT_STRING, IDM_SHOWCIR	 , LNGSEL(L"同心円スケール表示(&5)"	   , L"Show concentric scale(&5)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_HIDECIR	 , LNGSEL(L"同心円スケール非表示(&5)"  , L"Hide concentric scale(&5)"));

			if (!(pW->style & AJC3DGS_SPHERESCALE)) AppendMenu(hMenu, MFT_STRING, IDM_SHOWBALL	 , LNGSEL(L"球体スケール表示(&6)"	   , L"Show Spherical scale(&6)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_HIDEBALL	 , LNGSEL(L"球体スケール非表示(&6)"	   , L"Hide Spherical scale(&6)"));

			if (!(pW->style & AJC3DGS_SCALE_XY	 )) AppendMenu(hMenu, MFT_STRING, IDM_SCALEXY_ON , LNGSEL(L"ＸＹ平面スケール表示(&7)"  , L"Show scale on X-Y plane(&7)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_SCALEXY_OFF, LNGSEL(L"ＸＹ平面スケール非表示(&7)", L"Hide scale on X-Y plane(&7)"));

			if (!(pW->style & AJC3DGS_SCALE_XZ	 )) AppendMenu(hMenu, MFT_STRING, IDM_SCALEXZ_ON , LNGSEL(L"ＸＺ平面スケール表示(&8)"  , L"Show scale on X-Z plane(&8)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_SCALEXZ_OFF, LNGSEL(L"ＸＺ平面スケール非表示(&8)", L"Hide scale on X-Z plane(&8)"));

			if (!(pW->style & AJC3DGS_SCALE_YZ	 )) AppendMenu(hMenu, MFT_STRING, IDM_SCALEYZ_ON , LNGSEL(L"ＹＺ平面スケール表示(&9)"  , L"Show scale on Y-Z plane(&9)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_SCALEYZ_OFF, LNGSEL(L"ＹＺ平面スケール非表示(&9)", L"Hide scale on Y-Z plane(&9)"));

			if (pW->style & AJC3DGS_NODEPTHCTRL	  ) AppendMenu(hMenu, MFT_STRING, IDM_DEPTH_ON	 , LNGSEL(L"奥行き表現許可(&E)"		   , L"Depth expression(&E)"));
			else									AppendMenu(hMenu, MFT_STRING, IDM_DEPTH_OFF	 , LNGSEL(L"奥行き表現禁止(&E)"		   , L"No Depth expression(&E)"));
		}
		if (AjcAvlGetCount(pW->hAvlDat) != 0) {
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_CLEARDATA	 , LNGSEL(L"データクリアー(&D)"	, L"Clear all &Data"	  ));
		}
		if (pW->fMesDrawEnable) {
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			if (pW->hMesDraw == NULL) AppendMenu(hMenu, MFT_STRING, IDM_MESDRAW_ON	 , LNGSEL(L"描画時間情報 表示"	, L"Display drawing time information"));
			else					  AppendMenu(hMenu, MFT_STRING, IDM_MESDRAW_OFF	 , LNGSEL(L"描画時間情報 非表示", L"Hide drawing time informationn"));
		}
		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hwnd, NULL);
		DestroyMenu(hMenu);

		//	いずれかのメニュー項目を選択した場合は、スケール，データを再描画する
		if (id != 0) {
			pW->fReDrawScale = TRUE;
			pW->fReDrawData  = TRUE;
		}

		//	ポップアップメニュー項目実行
		switch (id) {
			case IDM_COPYBMAP:		 if (pW->hBmpImg != NULL) {
										 HBITMAP hBm = (HBITMAP)CopyImage(pW->hBmpImg, IMAGE_BITMAP, pW->ww, pW->wh, LR_COPYRETURNORG);
										 if (hBm != NULL) {
											 OpenClipboard(hwnd);
											 EmptyClipboard();
											 SetClipboardData(CF_BITMAP, hBm);
											 CloseClipboard();
										 }
									 }
									 break;

			case IDM_SETRANGE:		G3dCreateDlgSetRange(pW);			break;
			case IDM_SAMERANGE:		AjcG3dSetSameRangeWidth(hwnd);		break;
			case IDM_ADJUSTRANGE:	AjcG3dAdjustRange(hwnd);			break;
			case IDM_FIXEDASPECT:	AjcG3dSetFixedAspect(hwnd, TRUE );	break;
			case IDM_VARIABLEASPECT:AjcG3dSetFixedAspect(hwnd, FALSE);	break;
			case IDM_SHOWFILTER:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_NOFILTER);	break;
			case IDM_HIDEFILTER:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_NOFILTER);	break;
			case IDM_SHOWXY:		G3dSetAngleXY(pW);			break;
			case IDM_SHOWXZ:		G3dSetAngleXZ(pW);			break;
			case IDM_SHOWYZ:		G3dSetAngleYZ(pW);			break;
			case IDM_SHOW3D:		G3dSetAngle3D(pW);			break;
			case IDM_SHOWPLANE:		G3dCreateDlgSetPlane(pW);	break;

			case IDM_SHOWSQR:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_RECTSCALE);	break;			//	方眼スケール表示
			case IDM_HIDESQR:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_RECTSCALE);	break;			//	方眼スケール非表示

			case IDM_SHOWCIR:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_ELPSSCALE);	break;			//	同心円スケール表示
			case IDM_HIDECIR:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_ELPSSCALE);	break;			//	同心円スケール非表示

			case IDM_SHOWBALL:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_SPHERESCALE);	break;			//	球スケール表示
			case IDM_HIDEBALL:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_SPHERESCALE);	break;			//	球スケール非表示

			case IDM_SCALEXY_ON:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_SCALE_XY);	break;			//	ＸＹ平面にスケール表示
			case IDM_SCALEXY_OFF:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_SCALE_XY);	break;			//	ＸＹ平面にスケール非表示

			case IDM_SCALEXZ_ON:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_SCALE_XZ);	break;			//	ＸＺ平面にスケール表示
			case IDM_SCALEXZ_OFF:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_SCALE_XZ);	break;			//	ＸＺ平面にスケール非表示

			case IDM_SCALEYZ_ON:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_SCALE_YZ);	break;			//	ＹＺ平面にスケール表示
			case IDM_SCALEYZ_OFF:	MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_SCALE_YZ);	break;			//	ＹＺ平面にスケール非表示

			case IDM_DEPTH_ON:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty & ~AJC3DGS_NODEPTHCTRL);	break;			//	奥行き表現する
			case IDM_DEPTH_OFF:		MAjcSetWindowLong(hwnd, GWL_STYLE, sty |  AJC3DGS_NODEPTHCTRL);	break;			//	奥行き表現しない

			case IDM_CLEARDATA:		if (MessageBoxW(hwnd, LNGSEL(L"データを全て破棄し、画面をクリアーします。よろしいですか？",
																 L"Discard all data and clear the screen. Is it OK?"), AppName, MB_YESNO) == IDYES) {
										AjcG3dClearAllShape(hwnd);
										AjcG3dClearAllPlot (hwnd);
									}
									break;

			case IDM_MESDRAW_ON:	if (pW->hDlgMesDraw == NULL) {
										//	描画計測時間クリアー
										memset(&pW->MesDraw, 0, sizeof pW->MesDraw);
										pW->MesDraw.Min = -1;
										//	描画時間計測インスタンス生成
										pW->hMesDraw	= AjcMesTimeCreate(&pW->MesDraw.Freq);
										//	描画時間表示ダイアログク生成
										pW->hDlgMesDraw = AjcViewMesTimeCreate(hwnd, (UX)pW, cbMtvGetInfo, cbMtvNtcClosed);
									}
									break;

			case IDM_MESDRAW_OFF:	if (pW->hDlgMesDraw != NULL) {
										//	描画時間表示ダイアログクローズ
										AjcViewMesTimeDelete(pW->hDlgMesDraw);
									}
									break;

		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONUP		)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);

	if (pW->fNtcRClk) {
		if (pW->MsgRBUp != 0) {
			PostMessage(GetParent(hwnd), pW->MsgRBUp, wParam, lParam);
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_LBUTTONDBLCLK	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	int			x = (SW)LOWORD(lParam);
	int			y = (SW)HIWORD(lParam);

	SendMessage(GetParent(pW->hMain), WM_COMMAND,
				MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_DBLCLK),
				fCmdWithHdl ? (LPARAM)pW->hMain : MAKELONG(x, y));

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DROPFILES	)
{
	PWRK3DGRAPH	pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	HWND		hParent = GetParent(pW->hMain);
	HDROP	hDrop;
	UI		i, n, bytes;
	WC		path[MAX_PATH];

	//----- 前回のドロップデータ破棄 ----------------------------------//
	AjcRngPurge(pW->hRngDir);
	AjcRngPurge(pW->hRngFile);

	//----- カウンタクリアー ------------------------------------------//
	pW->NtcDirs = pW->NtcFiles = 0;
	//----- ドロップディレクトリ名／ファイル名取得 --------------------//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	n	  = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);							//	ドロップファイル数取得
	for (i = 0; i < n; i++) {													//	ドロップパス数ループ
		DragQueryFileW(hDrop, i, path, MAX_PATH);								//	ドロップパス名取得
		if (AjcPathExistsW(path)) {												//	有効なパス？
			bytes = (UI)wcslen(path) * 2 + 2;									//		パス名のバイト数設定
			if (AjcPathIsDirectoryW(path)) {									//		ディレクトリ？
				pW->NtcDirs++;													//				DIR数更新
				AjcRngPutData(pW->hRngDir, (VOP)&bytes, sizeof bytes);			//				DIR名退避
				AjcRngPutData(pW->hRngDir, (VOP)path, bytes);					//				・
			}
			else {																//		ファイル？
				pW->NtcFiles++;													//				FILE数更新
				AjcRngPutData(pW->hRngFile, (VOP)&bytes, sizeof bytes);			//				ファイル名退避
				AjcRngPutData(pW->hRngFile, (VOP)path, bytes);					//				・
			}
		}
	}
	DragFinish(hDrop);															//	ドロップ終了

	//----- ディレクトリドロップイベント通知 --------------------------//
	if (pW->NtcDirs) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_DROPDIR) ,
										 fCmdWithHdl ? (LPARAM)pW->hMain : pW->NtcDirs);
	}
	//----- ファイルドロップイベント通知 ------------------------------//
	if (pW->NtcFiles) {
		SendMessage(hParent, WM_COMMAND, MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_DROPFILE),
										 fCmdWithHdl ? (LPARAM)pW->hMain : pW->NtcFiles);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログ等で他のコントロールが初期化されていない可能性がある為、通知は自ウインドへのｐｏｓｔにより行う
//	
AJC_WNDPROC(Main, AJC3DGM_NEEDNTC_ANGLE)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);

	memcpy(&pW->NtcRotTheta, &pW->prop.Rot, sizeof(AJC3DVEC));
	SendMessage(GetParent(pW->hMain), WM_COMMAND,
				MAKELONG(MAjcGetWindowLong(pW->hMain, GWL_ID), AJC3DGN_ROTTHETA),
				fCmdWithHdl ? (LPARAM)pW->hMain : (LPARAM)&pW->prop.Rot);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, G3D_IDC_BTN_WIDE)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	AJC3DGPROP		prop;

	if (HIWORD(wParam) == BN_CLICKED) {
		memcpy(&prop, &pW->prop, sizeof prop);
		prop.xr *= 1.25;
		prop.yr *= 1.25;
		prop.zr *= 1.25;
		G3dSetCtrlProp(pW, &prop);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, G3D_IDC_BTN_ZOOM)
{
	PWRK3DGRAPH		pW = (PWRK3DGRAPH)MAjcGetWindowLong(hwnd, 0);
	AJC3DGPROP	prop;

	if (HIWORD(wParam) == BN_CLICKED) {
		memcpy(&prop, &pW->prop, sizeof prop);
		prop.xr *= 0.8;
		prop.yr *= 0.8;
		prop.zr *= 0.8;
		G3dSetCtrlProp(pW, &prop);
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE			)
	AJC_WNDMAP_MSG(Main, WM_DESTROY			)
	AJC_WNDMAP_MSG(Main, WM_SIZE			)
	AJC_WNDMAP_MSG(Main, WM_TIMER			)
	AJC_WNDMAP_MSG(Main, WM_PAINT			)
	AJC_WNDMAP_MSG(Main, WM_GETTEXTLENGTH	)
	AJC_WNDMAP_MSG(Main, WM_GETTEXT			)
	AJC_WNDMAP_MSG(Main, WM_SETTEXT			)
	AJC_WNDMAP_MSG(Main, WM_STYLECHANGED	)
	AJC_WNDMAP_MSG(Main, WM_ENABLE			)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONUP		)
	AJC_WNDMAP_MSG(Main, WM_MOUSEMOVE		)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN		)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONUP		)
	AJC_WNDMAP_MSG(Main, WM_LBUTTONDBLCLK	)
	AJC_WNDMAP_MSG(Main, WM_DROPFILES		)

	AJC_WNDMAP_MSG(Main, AJC3DGM_NEEDNTC_ANGLE	)

	AJC_WNDMAP_CMD(Main, G3D_IDC_BTN_WIDE		)
	AJC_WNDMAP_CMD(Main, G3D_IDC_BTN_ZOOM		)

AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	文字列パラメタからプロパティ設定																			//
//																												//
//	引　数	：	pTxt  - パラメタ文字列																			//
//				pProp - 現在のプロパティ値（プロパティ変更時は上書き）											//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPropByText(PWRK3DGRAPH pW, WCP pTxt, PAJC3DGPROP pProp)
{
	WCP			p  = NULL;
	UI			ix;
	int			fr=-1, fg=-1, fb=-1;

	if (wcsnicmp(pTxt, L"P:", 2) == 0) {
		//----- パラメタ解析 ---------------------------------------------------//
		p = pTxt + 2;
		if (p = AjcStrTokW(p, L",")) {
			do {
				while (MAjcIsBlankW(*p)) p++;
				if		(wcsnicmp(p, L"TX=", 3) == 0) pProp->Rot.x	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"TY=", 3) == 0) pProp->Rot.y	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"TZ=", 3) == 0) pProp->Rot.z	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"XC=", 3) == 0) pProp->Cent.x	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"YC=", 3) == 0) pProp->Cent.y	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"ZC=", 3) == 0) pProp->Cent.z	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"XR=", 3) == 0) pProp->xr		  = _wtof(p + 3);
				else if (wcsnicmp(p, L"YR=", 3) == 0) pProp->yr		  = _wtof(p + 3);
				else if (wcsnicmp(p, L"ZR=", 3) == 0) pProp->zr		  = _wtof(p + 3);
				else if (wcsnicmp(p, L"RA=", 3) == 0) pProp->ratio	  = _wtof(p + 3);
				else if (wcsnicmp(p, L"PS=", 3) == 0) pProp->PlotSize  = AjcAscToIntW(p + 3);
				else if (wcsnicmp(p, L"PE=", 3) == 0) pProp->PlotSizeE = AjcAscToIntW(p + 3);
				else if (wcsnicmp(p, L"PL=", 3) == 0) pProp->fPlotLine = AjcAscToIntW(p + 3);
				else if (wcsnicmp(p, L"A1=", 3) == 0) pProp->fAspect1  = AjcAscToIntW(p + 3);
				else if (wcsnicmp(p, L"BC=", 3) == 0) G3dSetBorderColor(pW, (COLORREF)AjcAscToIntW(p + 3));
				else if (towupper(*p) >= L'X' && towupper(*p) <= L'Z' && *(p+1) == L'=') {
					ix = towupper(*p) - L'X';
					p += 2;
					AjcGetSepNumbersW(p, L'/', L"ii", &pProp->axis[ix].rgbP, &pProp->axis[ix].rgbN);
				}
				else if (*p >= L'0' && *p <= L'9') {
					ix = _wtoi(p);
					if (ix >= 0 && ix < AJC3DG_MAXITEM) {
						if (p = wcsstr(p, L"=")) {
							p++;
							AjcGetSepNumbersW(p, L'/', L"iii", &pProp->Item[ix].MaxPlot, &pProp->Item[ix].rgbP, &pProp->Item[ix].rgbN);
						}
					}
				}
			} while(p = AjcStrTokW(NULL, L","));
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	プロパティ文字列生成																						//
//																												//
//	引　数	：	pTxt	- パラメタ文字列																		//
//				lTxt	- 文字列長																				//
//																												//
//	戻り値	：	テキスト長																						//
//--------------------------------------------------------------------------------------------------------------//
static	UI		MakePropText	  (PWRK3DGRAPH pW, WCP pTxt, UI lTxt)
{
	AjcSnPrintFW(pTxt, lTxt, L"P: TX=%G, TY=%G, TZ=%G, XC=%G, YC=%G, ZC=%G, XR=%G, YR=%G, ZR=%G, RA=%G, PS=%u, PE=%u, PL=%u, A1=%u, "
							L"BC=0x%X, X=0x%X/0x%X, Y=0x%X/0x%X, Z=0x%X/0x%X, "
							L"0=%u/0x%X/0x%X, 1=%u/0x%X/0x%X, 2=%u/0x%X/0x%X, 3=%u/0x%X/0x%X, "
							L"4=%u/0x%X/0x%X, 5=%u/0x%X/0x%X, 6=%u/0x%X/0x%X, 7=%u/0x%X/0x%X, "
							L"8=%u/0x%X/0x%X , 9=%u/0x%X/0x%X , 10=%u/0x%X/0x%X, 11=%u/0x%X/0x%X, "
							L"12=%u/0x%X/0x%X, 13=%u/0x%X/0x%X, 14=%u/0x%X/0x%X, 15=%u/0x%X/0x%X",

							pW->prop.Rot.x ,
							pW->prop.Rot.y ,
							pW->prop.Rot.z,
							pW->prop.Cent.x,
							pW->prop.Cent.y,
							pW->prop.Cent.z,
							pW->prop.xr,
							pW->prop.yr,
							pW->prop.zr,
							pW->prop.ratio,
							pW->prop.PlotSize,
							pW->prop.PlotSizeE,
							pW->prop.fPlotLine,
							pW->prop.fAspect1,
							pW->RgbBorder,
							pW->prop.axis[0].rgbP, pW->prop.axis[0].rgbN,
							pW->prop.axis[1].rgbP, pW->prop.axis[1].rgbN,
							pW->prop.axis[2].rgbP, pW->prop.axis[2].rgbN,
							pW->prop.Item[ 0].MaxPlot, pW->prop.Item[ 0].rgbP, pW->prop.Item[ 0].rgbN,
							pW->prop.Item[ 1].MaxPlot, pW->prop.Item[ 1].rgbP, pW->prop.Item[ 1].rgbN,
							pW->prop.Item[ 2].MaxPlot, pW->prop.Item[ 2].rgbP, pW->prop.Item[ 2].rgbN,
							pW->prop.Item[ 3].MaxPlot, pW->prop.Item[ 3].rgbP, pW->prop.Item[ 3].rgbN,
							pW->prop.Item[ 4].MaxPlot, pW->prop.Item[ 4].rgbP, pW->prop.Item[ 4].rgbN,
							pW->prop.Item[ 5].MaxPlot, pW->prop.Item[ 5].rgbP, pW->prop.Item[ 5].rgbN,
							pW->prop.Item[ 6].MaxPlot, pW->prop.Item[ 6].rgbP, pW->prop.Item[ 6].rgbN,
							pW->prop.Item[ 7].MaxPlot, pW->prop.Item[ 7].rgbP, pW->prop.Item[ 7].rgbN,
							pW->prop.Item[ 8].MaxPlot, pW->prop.Item[ 8].rgbP, pW->prop.Item[ 8].rgbN,
							pW->prop.Item[ 9].MaxPlot, pW->prop.Item[ 9].rgbP, pW->prop.Item[ 9].rgbN,
							pW->prop.Item[10].MaxPlot, pW->prop.Item[10].rgbP, pW->prop.Item[10].rgbN,
							pW->prop.Item[11].MaxPlot, pW->prop.Item[11].rgbP, pW->prop.Item[11].rgbN,
							pW->prop.Item[12].MaxPlot, pW->prop.Item[12].rgbP, pW->prop.Item[12].rgbN,
							pW->prop.Item[13].MaxPlot, pW->prop.Item[13].rgbP, pW->prop.Item[13].rgbN,
							pW->prop.Item[14].MaxPlot, pW->prop.Item[14].rgbP, pW->prop.Item[14].rgbN,
							pW->prop.Item[15].MaxPlot, pW->prop.Item[15].rgbP, pW->prop.Item[15].rgbN);

	return (UI)wcslen(pTxt);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	全リソース開放																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		DeleteAllResource(PWRK3DGRAPH pW)
{
	UI		i;

	//----- スケール用ＲＧＢ情報 --------------------------------//
	if (pW->RgbScale.hPenP	!= NULL	) {DeleteObject(pW->RgbScale.hPenP); pW->RgbScale.hPenP = NULL;}
	if (pW->RgbScale.hPenN	!= NULL	) {DeleteObject(pW->RgbScale.hPenN); pW->RgbScale.hPenN = NULL;}
	//----- ワイド／ズームボタン --------------------------------//
	if (pW->hBtnWide != NULL) {DestroyWindow(pW->hBtnWide); pW->hBtnWide = NULL;}
	if (pW->hBtnZoom != NULL) {DestroyWindow(pW->hBtnZoom); pW->hBtnZoom = NULL;}
	//----- フィルタウインド ------------------------------------//
	if (pW->hFilter != NULL) {DestroyWindow(pW->hFilter); pW->hFilter = NULL;}
	//----- ツールチップ ----------------------------------------//
	if (pW->pToolTipTxt != NULL) {
		free(pW->pToolTipTxt);
		pW->pToolTipTxt = NULL;
	}
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		if (pW->pChkBoxTool[i] != NULL) {
			free(pW->pChkBoxTool[i]);
			pW->pChkBoxTool[i] = NULL;
		}
	}
	//----- 描画速度情報表示ダイアログクローズ ------------------//
	if (pW->hDlgMesDraw != NULL) {AjcViewMesTimeDelete(pW->hDlgMesDraw); pW->hDlgMesDraw = NULL;}
	//----- 描画時間計測インスタンス消去 ------------------------//
	if (pW->hMesDraw != NULL) AjcMesTimeDelete(pW->hMesDraw);
	//----- ボーダー描画オブジェクト ----------------------------//
	if (pW->hPenBorder != NULL) {DeleteObject(pW->hPenBorder); pW->hPenBorder = NULL;}
	//----- 軸描画オブジェクト ----------------------------------//
	for (i = 0; i < 3; i++) {
		if (pW->AxisInfo[i].RgbInfo.hBruP != NULL) {DeleteObject(pW->AxisInfo[i].RgbInfo.hBruP); pW->AxisInfo[i].RgbInfo.hBruP = NULL;}
		if (pW->AxisInfo[i].RgbInfo.hPenP != NULL) {DeleteObject(pW->AxisInfo[i].RgbInfo.hPenP); pW->AxisInfo[i].RgbInfo.hPenP = NULL;}
		if (pW->AxisInfo[i].RgbInfo.hBruN != NULL) {DeleteObject(pW->AxisInfo[i].RgbInfo.hBruN); pW->AxisInfo[i].RgbInfo.hBruN = NULL;}
		if (pW->AxisInfo[i].RgbInfo.hPenN != NULL) {DeleteObject(pW->AxisInfo[i].RgbInfo.hPenN); pW->AxisInfo[i].RgbInfo.hPenN = NULL;}
	}
	//----- データ描画オブジェクト ------------------------------//
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		if (pW->DatItem[i].RgbInfo.hBruP != NULL) {DeleteObject(pW->DatItem[i].RgbInfo.hBruP); pW->DatItem[i].RgbInfo.hBruP = NULL;}
		if (pW->DatItem[i].RgbInfo.hPenP != NULL) {DeleteObject(pW->DatItem[i].RgbInfo.hPenP); pW->DatItem[i].RgbInfo.hPenP = NULL;}
		if (pW->DatItem[i].RgbInfo.hBruN != NULL) {DeleteObject(pW->DatItem[i].RgbInfo.hBruN); pW->DatItem[i].RgbInfo.hBruN = NULL;}
		if (pW->DatItem[i].RgbInfo.hPenN != NULL) {DeleteObject(pW->DatItem[i].RgbInfo.hPenN); pW->DatItem[i].RgbInfo.hPenN = NULL;}
		if (pW->DatItem[i].plot.pBuf	 != NULL) {free(pW->DatItem[i].plot.pBuf);			   pW->DatItem[i].plot.pBuf		= NULL;}
	}
	//----- タイトル描画オブジェクト ----------------------------//
	SubTtlBmpRemv(&pW->TtlInfo);
	//----- スクリーンビットマップ ------------------------------//
	if (pW->hBmpImg != NULL) {DeleteObject(pW->hBmpImg); pW->hBmpImg = NULL;}
	if (pW->hBmpSca != NULL) {DeleteObject(pW->hBmpSca); pW->hBmpSca = NULL;}
	if (pW->hBmpDat != NULL) {DeleteObject(pW->hBmpDat); pW->hBmpDat = NULL;}

	//----- データキュー ----------------------------------------//
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		if (pW->DatItem[i].hQueDat != NULL) {
			AjcVQueDelete(pW->DatItem[i].hQueDat);
			pW->DatItem[i].hQueDat = NULL;
		}
	}
	//----- 描画順ＡＶＬ ----------------------------------------//
	if (pW->hAvlDat != NULL) {
		AjcAvlDelete(pW->hAvlDat);
		pW->hAvlDat = NULL;
	}
	//----- ドロップファイル／ディレクトリ名一時保留バッファ ----//
	if (pW->hRngFile   != NULL) {AjcRngDelete(pW->hRngFile);   pW->hRngFile	 = NULL;}
	if (pW->hRngDir	   != NULL) {AjcRngDelete(pW->hRngDir );   pW->hRngDir	 = NULL;}

	//----- テキスト描画ＡＶＬ ----------------------------------//
	if (pW->hAvlTxo != NULL) {
		AjcAvlDelete(pW->hAvlTxo);
		pW->hAvlTxo = NULL;
	}

	//----- メモリＤＣ解放 --------------------------------------//
	if (pW->mdc != NULL) DeleteDC(pW->mdc);
	if (pW->sdc != NULL) DeleteDC(pW->sdc);
	if (pW->ddc != NULL) DeleteDC(pW->ddc);

}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スタイル設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		StyleSetting(PWRK3DGRAPH pW)
{
	//----- フィルタ表示／非表示 ---------------------------//
	if (pW->style & AJC3DGS_NOFILTER) {
		ShowWindow(pW->hFilter , SW_HIDE);
		ShowWindow(pW->hBtnWide, SW_HIDE);
		ShowWindow(pW->hBtnZoom, SW_HIDE);
	}
	//----- スケール情報計算 -------------------------------//
	G3dSetScaleInfo(pW);

	InvalidateRect(pW->hMain  , NULL, FALSE);
	InvalidateRect(pW->hFilter, NULL, FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRK3DGRAPH pW, BOOL fEnable)
{
	UI		i;

	//----- フィルタの有効状態設定 ------------------------------------//
	for (i = 0; i < AJC3DG_MAXITEM; i++) {
		EnableWindow(pW->hChkFilt[i], fEnable);
	}
	//----- ワイド／ズームボタンの有効状態設定 ------------------------//
	EnableWindow(pW->hBtnWide, fEnable);
	EnableWindow(pW->hBtnZoom, fEnable);
	//----- 無効状態ならばドラッグモード中止 --------------------------//
	if (!fEnable && pW->DrgMode != DRAGMD_STOP) {
		pW->DrgMode = DRAGMD_STOP;
		ReleaseCapture();
	}
	//----- 再描画 ----------------------------------------------------//
	InvalidateRect(pW->hMain, NULL, FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//	固定平面のＸ座標変換																						//
//																												//
//	引　数	：	PSif - スケール情報																				//
//				val	 - 実座標値																					//
//				fRev - 降順フラグ																				//
//																												//
//	戻り値	：	ウインドＸ位置																					//
//--------------------------------------------------------------------------------------------------------------//
int		G3dCnvValToX(PWRK3DGRAPH pW, double cent, double r, double val, BOOL fRev)
{
	double	xc = pW->ww / 2;
	double	yc = pW->wh / 2;
	double	x, xr;

	if (pW->prop.fAspect1) {
		xr = __min(xc, yc);
	}
	else {
		xr = xc;
	}

	if (fRev) x = xc + xr * ((cent - val) / r * pW->prop.ratio);
	else	  x = xc + xr * ((val - cent) / r * pW->prop.ratio);
	x += fmod(x, 0.5);
	return (int)x;
}
//--------------------------------------------------------------------------------------------------------------//
//	固定平面のＹ座標変換																						//
//																												//
//	引　数	：	PSif - スケール情報																				//
//				val	 - 実座標値																					//
//				fRev - 降順フラグ																				//
//																												//
//	戻り値	：	ウインドＸ位置																					//
//--------------------------------------------------------------------------------------------------------------//
int		G3dCnvValToY(PWRK3DGRAPH pW, double cent, double r, double val, BOOL fRev)
{
	double	xc = pW->ww / 2;
	double	yc = pW->wh / 2;
	double	y, yr;

	if (pW->prop.fAspect1) {
		yr = __min(xc, yc);
	}
	else {
		yr = yc;
	}

	if (fRev) y = yc + yr * ((cent - val) / r * pW->prop.ratio);
	else	  y = yc + yr * ((val - cent) / r * pW->prop.ratio);
	y += fmod(y, 0.5);
	y = pW->wh - y;
	return (int)y;
}
//--------------------------------------------------------------------------------------------------------------//
//	色コードからＩＤ＃検索																						//
//																												//
//	引　数	：	rgb			- 検索する色コード																	//
//																												//
//	戻り値	：	０～AJC3DG_MAXITEM - 当該ＩＤ＃																	//
//				－１			   - エラー（ＩＤ＃が見つからない）												//
//--------------------------------------------------------------------------------------------------------------//
static	int		SearchIdByRGB(PWRK3DGRAPH pW, COLORREF rgb)
{
	int		rc = -1;
	int		id;

	for (id = 0; id < AJC3DG_MAXITEM; id++) {
		if (pW->DatItem[id].RgbInfo.RgbP == rgb	 ||	 pW->DatItem[id].RgbInfo.RgbN == rgb) {
			rc = id;
			break;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	２Ｄ座標からプロットデータをリストアップしリストへ追加														//
//																												//
//	引　数	：	id			- 項目番号（0～AJC3DG_MAXITEM）														//
//				p2d			- 検索する２Ｄ座標																	//
//																												//
//	戻り値	：	≠NULL - プロットリストのアドレス																//
//				＝NULL - エラー																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AppendPlotList(PWRK3DGRAPH pW, UI id, LPPOINT p2d)
{

	//----------------------------------------------------------------------------------------------------------//
	//	プロットリストからクリックポイント検索																	//
	//----------------------------------------------------------------------------------------------------------//
	do {
		UI				ix, i;
		PPLOTINFO		pPlot;
		//----- プロット情報の先頭アドレス設定 -----------------------------------------------------------------//
		pPlot = &pW->DatItem[id].plot;
		if (pPlot->cnt == 0 || pPlot->pBuf == NULL) {
			break;
		}
		//----- プロットリスト情報設定 -------------------------------------------------------------------------//
		if (pPlot->cnt < pW->prop.Item[id].MaxPlot) ix = 0;
		else										ix = pPlot->ix;
		for (i = 0; i < pPlot->cnt; i++) {
			if (sqrt(pow(p2d->x - pPlot->pBuf[ix].v2.x, 2.0) + pow(p2d->y - pPlot->pBuf[ix].v2.y, 2.0)) <= 
																					(double)pW->prop.PlotSize) {
				pW->PlotList.max++;									//	実際のプロット点数
				if (pW->PlotList.num < AJC3DGMAX_PLOTLIST) {
					pW->PlotList.lst[pW->PlotList.num].id = id;		//	バッファＩＤ（0 ～ 15）
					pW->PlotList.lst[pW->PlotList.num].ix = i;		//	バッファ先頭からの位置
																	//	３Ｄベクトルデータ
					memcpy(&pW->PlotList.lst[pW->PlotList.num].vec, &pPlot->pBuf[ix].v3, sizeof(AJC3DVEC));
					pW->PlotList.num++;								//	プロット総数
				}
			}
			ix = ((ix + 1) % pW->prop.Item[id].MaxPlot);
		}
	} while(0);
	//----------------------------------------------------------------------------------------------------------//
	//	描画データからクリックポイント検索																		//
	//----------------------------------------------------------------------------------------------------------//
	do {
		PGI_INFO	pPgi;
		//----- 描画データ先頭アドレス設定 ---------------------------------------------------------------------//
		pPgi = AjcVQueTopNode(pW->DatItem[id].hQueDat, NULL);
		//----- プロットリスト情報設定 -------------------------------------------------------------------------//
		if (pPgi != NULL) {
			do {
				if (pPgi->h.gic == GIC_POINT) {
					if (sqrt(pow(p2d->x - pPgi->poi.p.v2.x, 2.0) + pow(p2d->y - pPgi->poi.p.v2.y, 2.0)) <= 
																							(double)pPgi->poi.siz) {
						pW->PlotList.max++;									//	実際のプロット点数
						if (pW->PlotList.num < AJC3DGMAX_PLOTLIST) {
							pW->PlotList.lst[pW->PlotList.num].id = id;		//	バッファＩＤ（0 ～ 15）
							pW->PlotList.lst[pW->PlotList.num].ix = -1;		//	バッファ先頭からの位置(-1:描画データ)
																			//	３Ｄベクトルデータ
							memcpy(&pW->PlotList.lst[pW->PlotList.num].vec, &pPgi->poi.p.v3, sizeof(AJC3DVEC));
							pW->PlotList.num++;								//	プロット総数
						}
					}
				}
			} while (pPgi = AjcVQueNextNode(pW->DatItem[id].hQueDat, pPgi, NULL));
		}
	} while(0);
}
