﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			ＡＰＩ															//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == BAR_INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	共通変数																									//
//--------------------------------------------------------------------------------------------------------------//
ATOM	BarClassBack	= 0;
ATOM	BarClassScale	= 0;
ATOM	BarClassImage	= 0;
ATOM	BarClassTtlStr	= 0;
ATOM	BarClassBarStr	= 0;
ATOM	BarClassFilter	= 0;
ATOM	BarClassForMSIL	= 0;

HFONT	BarhMyFont		= NULL;

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlBarGraphInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;
	LOGFONT		lf;

	do {
		//----- フォント ------------------------------------//
		lf.lfHeight			= -14;	lf.lfStrikeOut		= 0;
		lf.lfWidth			= 0;	lf.lfCharSet		= DEFAULT_CHARSET;
		lf.lfEscapement		= 0;	lf.lfOutPrecision	= 0;
		lf.lfOrientation	= 0;	lf.lfClipPrecision	= 0;
		lf.lfWeight			= 0;	lf.lfQuality		= 0;
		lf.lfItalic			= 0;	lf.lfPitchAndFamily	= FIXED_PITCH;
		lf.lfUnderline		= 0;	wcscpy(lf.lfFaceName, L"Terminal");
		if ((BarhMyFont = CreateFontIndirect(&lf)) == NULL) break;

		//----- カスタムコントロール・クラス -----------------//
		wndclass.style			= CS_HREDRAW | CS_VREDRAW | CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= BarWndProcBack();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRK_BARGRAPH);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcCtrlBarGraph";
		if ((BarClassBack = RegisterClass(&wndclass)) == 0) break;

		//----- スケール値表示ウインドクラス -----------------//
		wndclass.style			= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= BarWndProcScale();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRK_BARGRAPH);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);;
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcBarGraphScaleClass";
		if ((BarClassScale = RegisterClass(&wndclass)) == 0) break;

		//----- 棒グラフイメージ表示ウインドクラス -----------//
		wndclass.style			= CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
		wndclass.lpfnWndProc	= BarWndProcImage();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRK_BARGRAPH);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);;
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcBarGraphImageClass";
		if ((BarClassImage = RegisterClass(&wndclass)) == 0) break;

		//----- 棒タイトル名表示ウインドクラス --------------//
		wndclass.style			= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= BarWndProcTtlStr();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRK_BARGRAPH);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);;
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcBarGraphTtlStrClass";
		if ((BarClassTtlStr = RegisterClass(&wndclass)) == 0) break;

		//----- 棒タイトル表示ウインドクラス ----------------//
		wndclass.style			= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= BarWndProcBarStr();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRK_BARGRAPH);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);;
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcBarGraphBarStrClass";
		if ((BarClassBarStr = RegisterClass(&wndclass)) == 0) break;

		//----- フィルタ・ウインドクラス ----------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= BarWndProcFilt();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(PWRK_BARGRAPH);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);;
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(LTGRAY_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcBarGraphFilterClass";
		if ((BarClassFilter = RegisterClass(&wndclass)) == 0) break;

		//----- ＭＳＩＬコードサポート用 ---------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= BarWndProcMSIL();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(VOP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcBarForMSIL";
		if ((BarClassForMSIL = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlBarGraphEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlBarGraphEnd (VO)
{
	HINSTANCE	hModInst = GetModuleHandle(NULL);

	if (BarClassBack	!= 0   ) {UnregisterClass((VOP)BarClassBack   , hDllInst); BarClassBack	   = 0;   }
	if (BarClassScale	!= 0   ) {UnregisterClass((VOP)BarClassScale  , hDllInst); BarClassScale   = 0;   }
	if (BarClassImage	!= 0   ) {UnregisterClass((VOP)BarClassImage  , hDllInst); BarClassImage   = 0;   }
	if (BarClassTtlStr	!= 0   ) {UnregisterClass((VOP)BarClassTtlStr , hDllInst); BarClassTtlStr  = 0;   }
	if (BarClassBarStr	!= 0   ) {UnregisterClass((VOP)BarClassBarStr , hDllInst); BarClassBarStr  = 0;   }
	if (BarClassFilter	!= 0   ) {UnregisterClass((VOP)BarClassFilter , hDllInst); BarClassFilter  = 0;   }
	if (BarClassForMSIL != 0   ) {UnregisterClass((VOP)BarClassForMSIL, hDllInst); BarClassForMSIL = 0;   }
	if (BarhMyFont 		!= NULL) {DeleteObject	(BarhMyFont						); BarhMyFont	   = NULL;}
}

//==============================================================================================================//
//	実数データ設定																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				dat		- データ配列のアドレス																	//
//				pBarTtl - 棒タイトル文字列																		//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarPutRealDataA	(HWND hwnd, double dat[], C_BCP pBarTtl)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pBarTtl != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pBarTtl, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pBarTtl, -1, pTmp, len);
			rc = AjcBarPutRealDataW(hwnd, dat, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarPutRealDataW	(HWND hwnd, double dat[], C_WCP pBarTtl)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && dat != NULL && pBarTtl != NULL) {
			rc = BarSetData(pW, pBarTtl, dat);
		}
	}
	return rc;
}

//==============================================================================================================//
//	整数データ設定																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				dat		- データ配列のアドレス																	//
//				pBarTtl - 棒タイトル文字列																		//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarPutIntDataA	(HWND hwnd, int dat[], C_BCP pBarTtl)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pBarTtl != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pBarTtl, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pBarTtl, -1, pTmp, len);
			rc = AjcBarPutIntDataW(hwnd, dat, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarPutIntDataW	(HWND hwnd, int dat[], C_WCP pBarTtl)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && dat != NULL && pBarTtl != NULL) {
			UI				i;
			double			rdat[AJCBAR_MAXITEM];

			for (i = 0; i < pW->prop.MaxItem; i++) {
				rdat[i] = (double)dat[i];
			}
			rc = BarSetData(pW, pBarTtl, rdat);
		}
	}
	return rc;
}

//==============================================================================================================//
//	棒タイトル名設定																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				pTtl	- 棒タイトル名文字列																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSetBarTtlA	(HWND hwnd, C_BCP pTtl)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pTtl != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pTtl, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pTtl, -1, pTmp, len);
			rc = AjcBarSetBarTtlW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSetBarTtlW	(HWND hwnd, C_WCP pTtl)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pTtl != NULL) {
			wcsncpy(pW->TtlStr, pTtl, AJCTSIZE(pW->TtlStr));
			pW->TtlStr[AJCTSIZE(pW->TtlStr) - 1] = 0;
			InvalidateRect(pW->hTtlStr, NULL, TRUE);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	縦軸単位名設定																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				pUnit	- 縦軸の単位名文字列																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSetVUnitA		(HWND hwnd, C_BCP pUnit)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pUnit != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pUnit, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pUnit, -1, pTmp, len);
			rc = AjcBarSetVUnitW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSetVUnitW		(HWND hwnd, C_WCP pUnit)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pUnit != NULL) {
			wcsncpy(pW->VUnitStr, pUnit, AJCTSIZE(pW->VUnitStr));
			pW->VUnitStr[AJCTSIZE(pW->VUnitStr) - 1] = 0;
			InvalidateRect(pW->hScale, NULL, TRUE);
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	データクリアー																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				dat		- データ配列のアドレス																	//
//				pTtl	- 棒タイトル名文字列																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarPurge			(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = BarPurge(pW);
		}
	}
	return rc;
}

//==============================================================================================================//
//	外枠の表示／非表示																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				fShow	- 表示フラグ																			//
//				pTtl	- 外枠の色																				//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarShowBorder	(HWND hwnd, BOOL fShow, COLORREF rgb)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			int		sty;

			if (rgb != -1) {
				BarSetBorderColor(pW, rgb);
			}
			sty = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
			if (fShow) sty &= ~AJCBARS_NOBORDER;
			else	   sty |=  AJCBARS_NOBORDER;
			MAjcSetWindowLong(hwnd, GWL_STYLE, sty);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	フィルタ表示／非表示																						//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				fShow	- 表示フラグ																			//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarShowFilter	(HWND hwnd, BOOL fShow)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			int		sty;

			sty = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
			if (fShow) sty &= ~AJCBARS_NOFILTER;
			else	   sty |=  AJCBARS_NOFILTER;
			MAjcSetWindowLong(hwnd, GWL_STYLE, sty);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティ取得																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				pBuf	- 取得したプロパティを格納するバッファのアドレス										//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarGetProp		(HWND hwnd, PAJCBARPROP	 pBuf)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pBuf != NULL) {
			rc = BarGetProp(pW, pBuf);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロパティ設定																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				pProp	- 設定するプロパティデータのアドレス													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetProp		(HWND hwnd, PCAJCBARPROP pProp)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProp != NULL) {
			rc = BarSetProp(pW, pProp);
		}
	}
	return rc;
}
//==============================================================================================================//
//	実数レンジ取得																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				low		- グラフ下部レンジを格納するバッファのアドレス（不要時はNULL）							//
//				high	- グラフ上部レンジを格納するバッファのアドレス（不要時はNULL）							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarGetRealRange	(HWND hwnd, double *low, double *high)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AJCBARPROP	prop;

			if (rc = BarGetProp(pW, &prop)) {
				if (low  != NULL) *low	= prop.RngL;
				if (high != NULL) *high = prop.RngH;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	実数レンジ設定																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				low		- グラフ下部レンジ																		//
//				high	- グラフ上部レンジ																		//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetRealRange	(HWND hwnd, double	low, double	 high)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = BarSetRange(pW, low, high);
		}
	}
	return rc;
}
//==============================================================================================================//
//	整数レンジ取得																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				low		- グラフ下部レンジを格納するバッファのアドレス（不要時はNULL）							//
//				high	- グラフ上部レンジを格納するバッファのアドレス（不要時はNULL）							//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarGetIntRange	(HWND hwnd, int	   *low, int	*high)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AJCBARPROP	prop;

			if (rc = BarGetProp(pW, &prop)) {
				if (low  != NULL) *low	= (int)prop.RngL;
				if (high != NULL) *high = (int)prop.RngL;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	整数レンジ設定																								//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				low		- グラフ下部レンジ																		//
//				high	- グラフ上部レンジ																		//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetIntRange	(HWND hwnd, int		low, int	 high)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			double	l = (double)low;
			double	h = (double)high;
			rc = BarSetRange(pW, l, h);
		}
	}
	return rc;
}
//==============================================================================================================//
//	実数ベース値取得																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				base	- ベース値を格納するバッファのアドレス													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarGetRealBase	(HWND hwnd, double *base)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AJCBARPROP	prop;
			if (rc = BarGetProp(pW, &prop)) {
				if (base != NULL) *base = prop.Base;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	実数ベース値設定																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				base	- ベース値																				//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetRealBase	(HWND hwnd, double base)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = BarSetBase(pW, base);
		}
	}
	return rc;
}
//==============================================================================================================//
//	整数ベース値取得																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				base	- ベース値を格納するバッファのアドレス													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarGetIntBase	(HWND hwnd, int	*base)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AJCBARPROP	prop;
			if (rc = BarGetProp(pW, &prop)) {
				if (base != NULL) *base = (int)prop.Base;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	整数ベース値設定																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				low		- グラフ下部レンジ																		//
//				high	- グラフ上部レンジ																		//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetIntBase	(HWND hwnd, int	base)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			double	b = (double)base;
			rc = BarSetBase(pW, b);
		}
	}
	return rc;
}
//==============================================================================================================//
//	バッファサイズ設定																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				n		- バッファのサイズを格納するデータ数で指定												//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetBufSize	(HWND hwnd, int n)
{
	BOOL		rc = FALSE;
	AJCBARPROP	prop;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
			prop.MaxBuf = n;
			rc = BarSetProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	データ項目数設定																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				n		- 設定するデータ項目数																	//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetItemNumber (HWND hwnd, int n)
{
	BOOL		rc = FALSE;
	AJCBARPROP	prop;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
			prop.MaxItem = n;
			rc = BarSetProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	スケール値表示域の幅設定																					//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				width	- 幅																					//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetScaleWidth (HWND hwnd, int width)
{
	BOOL		rc = FALSE;
	AJCBARPROP	prop;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
			prop.ScaleWidth = width;
			rc = BarSetProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	棒の幅設定																									//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				width	- 幅																					//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetBarWidth	(HWND hwnd, int width)
{
	BOOL		rc = FALSE;
	AJCBARPROP	prop;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
			prop.BarWidth = width;
			rc = BarSetProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	棒表示域の幅設定																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				width	- 幅																					//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetItemWidth	(HWND hwnd, int width)
{
	BOOL		rc = FALSE;
	AJCBARPROP	prop;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
			prop.MinWidth = width;
			rc = BarSetProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	棒タイトルの最大行数設定																					//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//				lines	- 行数																					//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetTtlLines	(HWND hwnd, int lines)
{
	BOOL		rc = FALSE;
	AJCBARPROP	prop;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
			prop.BarTtlLines = lines;
			rc = BarSetProp(pW, &prop);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ビットマップ取得																							//
//																												//
//	引　数	：	hwnd	- ウインドハンドル																		//
//																												//
//	戻り値	：	≠NULL：ビットマップハンドル																	//
//				＝NULL：エラー																					//
//==============================================================================================================//
AJCEXPORT	HBITMAP		WINAPI	AjcBarGetBitmap		(HWND hwnd)
{
	HBITMAP	hBm = NULL;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			hBm = BarCreateBitmap(pW);
		}
	}
	return hBm;
}
//==============================================================================================================//
//	プロファイルからプロパティ読み出し																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pDefProp	 - デフォルトプロパティ値（現在値をデフォルトとする場合はNULL)						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropA		(HWND hwnd, C_BCP pProfileSect, PCAJCBARPROP pDefProp)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pProfileSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmp, len);
			rc = AjcBarLoadPropW(hwnd, pTmp, pDefProp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropW		(HWND hwnd, C_WCP pProfileSect, PCAJCBARPROP pDefProp)
{
	BOOL	rc = TRUE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL) {
			AJCBARPROP	prop;

			if (pDefProp != NULL) memcpy(&prop, pDefProp, sizeof prop);
			else				  rc = AjcBarGetProp(hwnd, &prop);

			if (rc) {
				prop.RngL			= AjcGetProfileRealW(pProfileSect, L"RngL"			, prop.RngL			);
				prop.RngH			= AjcGetProfileRealW(pProfileSect, L"RngH"			, prop.RngH			);
				prop.Base			= AjcGetProfileRealW(pProfileSect, L"Base"			, prop.Base			);
				prop.MaxBuf			= AjcGetProfileUIntW(pProfileSect, L"MaxBuf"		, prop.MaxBuf		);
				prop.MaxItem		= AjcGetProfileUIntW(pProfileSect, L"MaxItem"		, prop.MaxItem		);
				prop.ScaleWidth		= AjcGetProfileUIntW(pProfileSect, L"ScaleWidth"	, prop.ScaleWidth	);
				prop.BarWidth		= AjcGetProfileUIntW(pProfileSect, L"BarWidth"		, prop.BarWidth		);
				prop.MinWidth		= AjcGetProfileUIntW(pProfileSect, L"MinWidth"		, prop.MinWidth		);
				prop.BarTtlLines	= AjcGetProfileUIntW(pProfileSect, L"BarTtlLines"	, prop.BarTtlLines	);

				prop.rgb[0]			= AjcGetProfileUIntW(pProfileSect, L"rgb0" 			, prop.rgb[0]);
				prop.rgb[1]			= AjcGetProfileUIntW(pProfileSect, L"rgb1" 			, prop.rgb[1]);
				prop.rgb[2]			= AjcGetProfileUIntW(pProfileSect, L"rgb2" 			, prop.rgb[2]);
				prop.rgb[3]			= AjcGetProfileUIntW(pProfileSect, L"rgb3" 			, prop.rgb[3]);
				prop.rgb[4]			= AjcGetProfileUIntW(pProfileSect, L"rgb4" 			, prop.rgb[4]);
				prop.rgb[5]			= AjcGetProfileUIntW(pProfileSect, L"rgb5" 			, prop.rgb[5]);
				prop.rgb[6]			= AjcGetProfileUIntW(pProfileSect, L"rgb6" 			, prop.rgb[6]);
				prop.rgb[7]			= AjcGetProfileUIntW(pProfileSect, L"rgb7" 			, prop.rgb[7]);

				rc = AjcBarSetProp(hwnd, &prop);
			}
		}
		else rc = FALSE;
	}
	else rc = FALSE;

	return rc;
}

//==============================================================================================================//
//	プロファイルへプロパティ書き込み																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSavePropA		(HWND hwnd, C_BCP pProfileSect)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pProfileSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmp, len);
			rc = AjcBarSavePropW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSavePropW		(HWND hwnd, C_WCP pProfileSect)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL) {
			AJCBARPROP	prop;

			if (rc = AjcBarGetProp(hwnd, &prop)) {
				AjcPutProfileRealW(pProfileSect, L"RngL"		, prop.RngL			);
				AjcPutProfileRealW(pProfileSect, L"RngH"		, prop.RngH			);
				AjcPutProfileRealW(pProfileSect, L"Base"		, prop.Base			);
				AjcPutProfileUIntW(pProfileSect, L"MaxBuf"		, prop.MaxBuf		);
				AjcPutProfileUIntW(pProfileSect, L"MaxItem"		, prop.MaxItem		);
				AjcPutProfileUIntW(pProfileSect, L"ScaleWidth"	, prop.ScaleWidth	);
				AjcPutProfileUIntW(pProfileSect, L"BarWidth"	, prop.BarWidth		);
				AjcPutProfileUIntW(pProfileSect, L"MinWidth"	, prop.MinWidth		);
				AjcPutProfileUIntW(pProfileSect, L"BarTtlLines"	, prop.BarTtlLines	);

				AjcPutProfileUIntW(pProfileSect, L"rgb0"		, prop.rgb[0]);
				AjcPutProfileUIntW(pProfileSect, L"rgb1"		, prop.rgb[1]);
				AjcPutProfileUIntW(pProfileSect, L"rgb2"		, prop.rgb[2]);
				AjcPutProfileUIntW(pProfileSect, L"rgb3"		, prop.rgb[3]);
				AjcPutProfileUIntW(pProfileSect, L"rgb4"		, prop.rgb[4]);
				AjcPutProfileUIntW(pProfileSect, L"rgb5"		, prop.rgb[5]);
				AjcPutProfileUIntW(pProfileSect, L"rgb6"		, prop.rgb[6]);
				AjcPutProfileUIntW(pProfileSect, L"rgb7"		, prop.rgb[7]);
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	プロファイルからプロパティ，フィルタ設定，ウインドスタイル読み出し											//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//				pDefProp	 - デフォルトプロパティ値（現在値をデフォルトとする場合はNULL)						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropExA	(HWND hwnd, C_BCP pProfileSect, PCAJCBARPROP pDefProp)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pProfileSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmp, len);
			rc = AjcBarLoadPropExW(hwnd, pTmp, pDefProp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarLoadPropExW	(HWND hwnd, C_WCP pProfileSect, PCAJCBARPROP pDefProp)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL) {
			int			i, msk, flt, styS, styU;
			if (rc = AjcBarLoadPropW(hwnd, pProfileSect, pDefProp)) {
				//----- 現在のフィルタ値取得 ---------------------------------------------------//
				flt = 0;
				for (i = 0, msk = 0x0001; i < AJCBAR_MAXITEM; i++, msk <<= 1) {
					if (AjcBarGetFilter(hwnd, i)) flt |= msk;
				}
				//----- プロファイルからフィルタ値読み出し -------------------------------------//
				flt = AjcGetProfileUIntW(pProfileSect, L"FilterValue", flt);
				//----- フィルタ値設定 ---------------------------------------------------------//
				for (i = 0, msk = 0x0001; i < AJCBAR_MAXITEM; i++, msk <<= 1) {
					AjcBarSetFilter(hwnd, i, (flt & msk) != 0); 
				}
				//----- 現在のスタイル値読み出し -----------------------------------------------//
				styS = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
				styU = (styS & 0xFFFF);
				//----- プロファイルからスタイル値読み出し -------------------------------------//
				styU  = AjcGetProfileUIntW(pProfileSect, L"WndStyle", styU);
				styU &= 0xFFFF;
				//----- スタイル設定 -----------------------------------------------------------//
				styS &= ~0xFFFF;
				styS |= styU;
				MAjcSetWindowLong(hwnd, GWL_STYLE, styS);
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	プロファイルへプロパティ，フィルタ設定，ウインドスタイル書き込み											//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pProfileSect - プロファイルのセクション名														//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSavePropExA	(HWND hwnd, C_BCP pProfileSect)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pProfileSect != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAllocW(len))) {
			MultiByteToWideChar(CP_ACP, 0, pProfileSect, -1, pTmp, len);
			rc = AjcBarSavePropExW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSavePropExW	(HWND hwnd, C_WCP pProfileSect)
{
	BOOL		rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && pProfileSect != NULL) {
			int			i, msk, flt, sty;
			if (rc = AjcBarSavePropW(hwnd, pProfileSect)) {
				//----- 現在のフィルタ値取得 ---------------------------------------------------//
				flt = 0;
				for (i = 0, msk = 0x0001; i < AJCBAR_MAXITEM; i++, msk <<= 1) {
					if (AjcBarGetFilter(hwnd, i)) flt |= msk;
				}
				//----- プロファイルへフィルタ値書き込み ---------------------------------------//
				flt = AjcPutProfileUIntW(pProfileSect, L"FilterValue", flt);
				//----- 現在のスタイル値読み出し -----------------------------------------------//
				sty	 = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
				sty &= 0xFFFF;
				//----- プロファイルへスタイル値書き込み ---------------------------------------//
				sty = AjcPutProfileUIntW(pProfileSect, L"WndStyle", sty);
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	右クリックによるポップアップメニューの許可／禁止															//
//																												//
//	引　数	：	hwnd		  - ウインドハンドル																//
//				fEnable		  - ポップアップメニューの許可／禁止												//
//									TRUE  : 許可（右クリック非通知，Shuft/Ctrl+右クリック通知）					//
//									FALSE : 禁止（全ての右クリック通知）										//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarEnablePopupMenu(HWND hwnd, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AjcBarSetNtcRClk(hwnd, !fEnable, WM_RBUTTONDOWN, WM_RBUTTONUP);
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	右クリック通知設定																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fNtcRClk	 - TRUE  : 右ボタンDOWN/UP通知	（ポップアップは禁止）								//
//							   FALSE : 右ボタンDOWN/UP非通知（ポップアップを許可）								//
//				MsgRBDown	 - 右ボタン押下時の通知メッセージコード　（０の場合は非通知）						//
//				MSgRBUp		 - 右ボタン離され時の通知メッセージコード（０の場合は非通知）						//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//																												//
//	備　考	：						<ポップアップ>	<Shift/Ctrl+右>		<右-DOWN>	<右-UP>						//
//				NtcRClk	= FALSE	 	 許可		 	 通知				 非通知		 非通知						//
//				 		= TRUE		 禁止			 非通知				 MsgRBDown	 MsgRBUp					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetNtcRClk	(HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fNtcRClk  = fNtcRClk;
			pW->MsgRBDown = MsgRBDown;
			pW->MsgRBUp	  = MsgRBUp;
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	ツールチップ・テキスト設定																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pTxt		 - ツールチップ・テキスト文字列のアドレス											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcBarSetTipTextA (HWND hwnd, C_BCP pTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (rc = SubSetTipTextA(&pW->pToolTipTxt, 0, pTxt)) {
				AjcTipTextAddW		   (pW->hBack, pW->pToolTipTxt);
				AjcTipTextSetShowAlways(pW->hBack, pW->fShowAlways);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcBarSetTipTextW (HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (rc = SubSetTipTextW(&pW->pToolTipTxt, 0, pTxt)) {
				AjcTipTextAddW		   (pW->hBack, pW->pToolTipTxt);
				AjcTipTextSetShowAlways(pW->hBack, pW->fShowAlways);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト取得																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pBuf		 - ツールチップ・テキスト文字列を格納するバッファのアドレス							//
//				lBuf		 - ツールチップ・テキスト文字列を格納するバッファの文字数							//
//																												//
//	戻り値	：	チップテキストのバイト数／文字数（pBuf=NULLの場合は、文字列終端を含む）							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcBarGetTipTextA (HWND hwnd, BCP pBuf, UI lBuf)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = SubGetTipTextA(&pW->pToolTipTxt, 0, pBuf, lBuf);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcBarGetTipTextW (HWND hwnd, WCP pBuf, UI lBuf)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = SubGetTipTextW(&pW->pToolTipTxt, 0, pBuf, lBuf);
		}
	}
	return rc;
}

//==============================================================================================================//
//	フィィルタ（チェックボックス）のツールチップ・テキスト設定													//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				n			 - チェックボックス・インデクス（０～７）											//
//				pTxt		 - ツールチップ・テキスト文字列のアドレス											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSetChkBoxTipTextA(HWND hwnd, UI n, C_BCP pTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM) {
				if (rc = SubSetTipTextA(pW->pChkBoxTool, n, pTxt)) {
					AjcTipTextAddW		   (pW->hChkFilt[n], pW->pChkBoxTool[n]);
					AjcTipTextSetShowAlways(pW->hChkFilt[n], pW->fChkBoxShowAlways[n]);
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcBarSetChkBoxTipTextW(HWND hwnd, UI n, C_WCP pTxt)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM) {
				if (rc = SubSetTipTextW(pW->pChkBoxTool, n, pTxt)) {
					AjcTipTextAddW		   (pW->hChkFilt[n], pW->pChkBoxTool[n]);
					AjcTipTextSetShowAlways(pW->hChkFilt[n], pW->fChkBoxShowAlways[n]);
				}
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	フィィルタ（チェックボックス）のツールチップ・テキスト取得													//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				n			 - チェックボックス・インデクス（０～７）											//
//				pBuf		 - ツールチップ・テキスト文字列を格納するバッファのアドレス							//
//				lBuf		 - ツールチップ・テキスト文字列を格納するバッファの文字数							//
//																												//
//	戻り値	：	チップテキストのバイト数／文字数（pBuf=NULLの場合は、文字列終端を含む）							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcBarGetChkBoxTipTextA(HWND hwnd, UI n, BCP pBuf, UI lBuf)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM) {
				rc = SubGetTipTextA(pW->pChkBoxTool, n, pBuf, lBuf);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcBarGetChkBoxTipTextW(HWND hwnd, UI n, WCP pBuf, UI lBuf)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM && pBuf != NULL && lBuf != 0) {
				rc = SubGetTipTextW(pW->pChkBoxTool, n, pBuf, lBuf);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件設定																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fShowAlways	 - ツールチップ・テキスト表示条件													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarSetTipShowAlways(HWND hwnd, BOOL fShowAlways)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fShowAlways = fShowAlways;
			AjcTipTextSetShowAlways(hwnd, pW->fShowAlways);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ツールチップ・テキスト表示条件取得																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	ツールチップ・テキスト表示条件																	//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarGetTipShowAlways(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = pW->fShowAlways;
		}
	}
	return rc;
}
//==============================================================================================================//
//	フィィルタ（チェックボックス）のツールチップ・テキスト表示条件設定											//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				n			 - チェックボックス・インデクス（０～７）											//
//				fShowAlways	 - ツールチップ・テキスト表示条件													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarSetChkBoxTipShowAlways(HWND hwnd, UI n, BOOL fShowAlways)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM) {
				pW->fChkBoxShowAlways[n] = fShowAlways;
				AjcTipTextSetShowAlways(pW->hChkFilt[n], pW->fChkBoxShowAlways[n]);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	フィィルタ（チェックボックス）のツールチップ・テキスト表示条件取得											//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				n			 - チェックボックス・インデクス（０～７）											//
//																												//
//	戻り値	：	ツールチップ・テキスト表示条件																	//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarGetChkBoxTipShowAlways(HWND hwnd, UI n)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM) {
				rc = pW->fChkBoxShowAlways[n];
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	全てのツールチップ・テキスト表示条件設定																	//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				fShowAlways	 - ツールチップ・テキスト表示条件													//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarSetTipShowAlwaysAll(HWND hwnd, BOOL fShowAlways)
{
	BOOL	rc = FALSE;
	int		i;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			pW->fShowAlways = fShowAlways;
			for (i = 0; i < AJCTC_MAXITEM; i++) {
				pW->fChkBoxShowAlways[i] = fShowAlways;
			}
			rc = TRUE;
		}
	}
	return rc;
}


//==============================================================================================================//
//	スクロール位置の取得																						//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	現在のスクロール位置（０～）																	//
//==============================================================================================================//
AJCEXPORT	int			WINAPI	AjcBarGetScrollPos	(HWND hwnd)
{
	SCROLLINFO		si;

	si.nPos = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			si.cbSize = sizeof(SCROLLINFO);
			si.fMask  = SIF_POS;
			GetScrollInfo(pW->hBarStr, SB_HORZ, &si);
		}
	}
	return si.nPos;
}
//==============================================================================================================//
//	スクロール位置の設定																						//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pos			 - 設定するスクロール位置															//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetScrollPos	(HWND hwnd, int pos)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			SCROLLINFO		si;

			si.cbSize = sizeof(SCROLLINFO);
			si.fMask  = SIF_POS;
			si.nPos	  = pos;
			SetScrollInfo(pW->hBarStr, SB_HORZ, &si, TRUE);
			GetScrollInfo(pW->hBarStr, SB_HORZ, &si);

			pW->rxView = -((int)(si.nPos % pW->BarField));
			pW->ixView = BarDixToBix(pW, si.nPos / pW->BarField);
			pW->pxView = pW->ixView * pW->BarField + pW->rxView;
			SetViewInfoCurrent(pW);
			BarReDraw(pW, FALSE);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	フィルタの設定																								//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				n			 - チェックボックス・インデクス（０～７）											//
//				state		 - 設定する状態(FALSE:非表示，TRUE:表示)											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetFilter		(HWND hwnd, UI n, BOOL state)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM	&&	pW->hChkFilt[n] != NULL) {
				SendMessage(pW->hChkFilt[n], BM_SETCHECK, state, 0);
				SendMessage(pW->hFilter, WM_COMMAND, MAKELONG(BAR_IDC_CHK_BASE + n, BN_CLICKED), 0);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	フィルタの取得																								//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				n			 - チェックボックス・インデクス（０～７）											//
//																												//
//	戻り値	：	フィルタの設定状態																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarGetFilter		(HWND hwnd, UI n)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (n < AJCBAR_MAXITEM	&&	pW->hChkFilt[n] != NULL) {
				rc = (BOOL)SendMessage(pW->hChkFilt[n], BM_GETCHECK, 0, 0);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	横線（属性の設定）																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				id			 - 横線識別（０～７）																//
//				color		 - 描画色																			//
//				width		 - 線の太さ																			//
//				style		 - 横線種別	(AJCBAR_SOLID / DASH / DOT / DASHDOT / DASHDOTDOT / NULL)				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetHLineAtt (HWND hwnd, UI id, COLORREF color, int width, int style)
{
	BOOL			rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			HPEN			hPen;
			if (id < MAX_HLINE	&&	style >= AJCBAR_SOLID && style <= AJCBAR_INSIDEFRAME) {
				if (hPen = CreatePen(style, width, color)) {
					if (pW->HLineTbl[id].hPen != NULL) {
						DeleteObject(pW->HLineTbl[id].hPen);
					}
					pW->HLineTbl[id].hPen = hPen;
					InvalidateRect(pW->hImage, NULL, FALSE);
					rc = TRUE;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	横線（描画位置の設定）																						//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				id			 - 横線識別（０～７）																//
//				pos			 - 描画位置																			//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarSetHLinePos (HWND hwnd, UI id, double pos)
{
	BOOL			rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (id < MAX_HLINE) {
				pW->HLineTbl[id].pos = pos;
				InvalidateRect(pW->hImage, NULL, FALSE);
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	横線（描画の許可／禁止）																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				id			 - 横線識別（０～７）																//
//				fEnable		 - TRUE	 : 描画																		//
//							   FALSE : 非描画																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcBarEnableHLine (HWND hwnd, UI id, BOOL fEnable)
{
	BOOL			rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (id < MAX_HLINE) {
				pW->HLineTbl[id].fEnable = fEnable;
				InvalidateRect(pW->hImage, NULL, FALSE);
				rc = TRUE;
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	文字サイズ取得																								//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				pSize		 - 文字サイズを格納するバッファのアドレス											//
//																												//
//	戻り値	：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcBarGetCharSize (HWND hwnd, LPSIZE pSize)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pSize != NULL) {
				pSize->cx = pW->cxNormal;
				pSize->cy = pW->cyNormal;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたファイル名取得																				//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ファイル名を格納するバッファのアドレス													//
//																												//
//	戻り値	：	TRUE:ファイル名あり，FALSE:ファイル名なし														//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcBarGetDroppedFileA (HWND hwnd, BC buf[MAX_PATH])
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcBarGetDroppedFileW(hwnd, tmp)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcBarGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH])
{
	BOOL		rc = FALSE;
	UI			bytes;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && buf != NULL) {
			if (AjcRngGetData(pW->hRngFile, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				rc = (AjcRngGetData(pW->hRngFile, (VOP)buf, bytes) == bytes);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたディレクトリ名取得																			//
//																												//
//	引　数	：	pW	  - インスタンスワークアドレス																//
//				buf	  - ディレクトリ名を格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE:ディレクトリ名あり，FALSE:ディレクトリ名なし												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcBarGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH])
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcBarGetDroppedDirW(hwnd, tmp)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcBarGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH])
{
	BOOL		rc = FALSE;
	UI			bytes;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (VOP)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && buf != NULL) {
			if (AjcRngGetData(pW->hRngDir, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
				rc = (AjcRngGetData(pW->hRngDir, (VOP)buf, bytes) == bytes);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ドロップされたディレクトリ名取得（末尾の「￥」付加指定付き）												//
//																												//
//	引　数	：	pW				 - インスタンスワークアドレス													//
//				buf				 - ディレクトリ名を格納するバッファのアドレス									//
//				fTailIsDelimiter - TRUE  : ディレクトリパスの末尾に「\」を付ける								//
//								   FALSE : ディレクトリパスの末尾に「\」を付けない								//
//																												//
//	戻り値	：	TRUE:ディレクトリ名あり，FALSE:ディレクトリ名なし												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcBarGetDroppedDirExA	(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL	rc = FALSE;
	WC		tmp[MAX_PATH];

	if (buf != NULL) {
		if (rc = AjcBarGetDroppedDirExW(hwnd, tmp, fTailIsDelimiter)) {
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, buf, MAX_PATH, NULL, NULL);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcBarGetDroppedDirExW	(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	BOOL		rc = FALSE;

	if (rc = AjcBarGetDroppedDirW(hwnd, buf)) {
		if (fTailIsDelimiter) AjcPathCatW(buf, L"", MAX_PATH);
		else				  PathRemoveBackslashW(buf);
	}
	return rc;
}
//==============================================================================================================//
//	タイトル文字列の設定																						//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pTitleText	- タイトルテキストへのポインタ（NULL指定時は、タイトル非表示）						//
//				TextColor	- テキスト描画色（－１指定時は前回設定値，デフォルト色＝白）						//
//				BackColor	- テキスト背景色（－１指定時は前回設定値，デフォルト色＝グレー）					//
//				hFont		- タイトルテキストのフォント（NULL指定時は前回設定値／デフォルトのフォント）		//
//																												//
//	戻り値	：	ウインド先頭行の位置（０～）																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcBarSetTitleTextA(HWND hwnd, C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	BOOL		rc	 = FALSE;
	WCP			pTmp = NULL;
	UL			len;

	if (IsWindow(hwnd)) {
		do {
			if (pTitleText != NULL) {
				len = MultiByteToWideChar(CP_ACP, 0, pTitleText, -1, NULL, 0);
				if (len != 0  &&  (pTmp = AjcTAllocW(len))) {
					MultiByteToWideChar(CP_ACP, 0, pTitleText, -1, pTmp, len);
				}
				else break;
			}
			else pTmp = NULL;
			rc = AjcBarSetTitleTextW(hwnd, pTmp, TextColor, BackColor, hFont);
		} while(0);
		if (pTmp != NULL) free(pTmp);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	   WINAPI AjcBarSetTitleTextW(HWND hwnd, C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	BOOL	rc	 = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			//	タイトルテキスト・ビットマップ生成
			SubTtlBmpMake(&pW->TtlInfo, pW->hBack, pTitleText, TextColor, BackColor, hFont);
			//	戻り値＝正常
			rc = TRUE;
			//	再描画
			InvalidateRect(hwnd 	, NULL, TRUE);
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキスト描画フォント設定																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				hFont		 - フォントハンドル																	//
//																												//
//	戻り値	：	≠NULL : 前回のフォントハンドル																	//
//				＝NULL : 失敗																					//
//==============================================================================================================//
AJCEXPORT	HFONT	WINAPI		AjcBarSetTextFont	(HWND hwnd, HFONT hFont)
{
	HFONT	rc = NULL;
	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW) && hFont != NULL) {
			rc = pW->hFontTxo;
			pW->hFontTxo = hFont;
		}
	}
	return rc;
}
//==============================================================================================================//
//	テキスト描画（ピクセル位置指定）																			//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				x, y		 - 描画位置																			//
//				pTxt		 - 描画テキスト																		//
//																												//
//	戻り値	：	≠0 : テキストキー																				//
//				＝0 : 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI		AjcBarTextOutA		(HWND hwnd, int x, int y, C_BCP pTxt)
{
	UI		rc = 0;
	UI		len;
	WCP		pTmp = NULL;

	len = MultiByteToWideChar(CP_ACP, 0, pTxt, -1, NULL, 0);
	if (len != 0 && (pTmp = AjcTAllocW(len))) {
		MultiByteToWideChar(CP_ACP, 0, pTxt, -1, pTmp, len);
		rc = AjcBarTextOutW(hwnd, x, y, pTmp);
	}
	if (pTmp != NULL) free(pTmp);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI		AjcBarTextOutW		(HWND hwnd, int x, int y, C_WCP pTxt)
{
	UI		rc = 0;
	PBARTXO	pNode;
	UI		stl, len;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (stl = (UI)wcslen(pTxt)) {
				len = sizeof(BARTXO) + stl * 2;
				if (pNode = malloc(len)) {
					memset(pNode, 0, sizeof(BARTXO));
					pNode->pt.x = x;
					pNode->pt.y = y;
					wcscpy(pNode->txt, pTxt);
					if (AjcAvlInsNode(pW->hAvlTxo, pW->kAvlTxo, (C_VOP)pNode, len)) {
						rc = pW->kAvlTxo++;
						InvalidateRect(pW->hImage, NULL, FALSE);
					}
					free(pNode);
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	書式テキスト描画（ピクセル位置指定）																		//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				x, y		 - 描画位置																			//
//				pFmt		 - 書式テキスト																		//
//																												//
//	戻り値	：	≠0 : テキストキー																				//
//				＝0 : 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI		AjcBarPrintFA		(HWND hwnd, int x, int y, C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFA(buf, 2048, pFmt, vls);
		va_end	(vls);
		rc = AjcBarTextOutA(hwnd, x, y, buf);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI		AjcBarPrintFW		(HWND hwnd, int x, int y, C_WCP pFmt, ...)
{
	UI		rc = 0;
	va_list	vls;
	WC		buf[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		AjcVSnPrintFW(buf, 2048, pFmt, vls);
		buf[2047] = 0;
		va_end	(vls);
		rc = AjcBarTextOutW(hwnd, x, y, buf);
	}
	return rc;
}
//==============================================================================================================//
//	描画テキスト取得																							//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				key			 - テキストキー																		//
//				pBuf		 - テキスト格納バッファへのポインタ（不要時はNULL）									//
//				lBuft		 - テキスト格納バッファのバイト数／文字数											//
//																												//
//	戻り値	：	≠0 : 描画テキストのバイト数／文字数															//
//				＝0 : 失敗																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI		AjcBarGetTextA		(HWND hwnd, UI key, BCP pBuf, UI lBuf)
{
	UI		rc = 0;
	PBARTXO	pNode;
	UI		lNode;
	UI		stl;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pNode = (PBARTXO)AjcAvlGetNodePtr(pW->hAvlTxo, key, &lNode)) {
				stl = (UI)wcslen(pNode->txt);
				rc = WideCharToMultiByte(CP_ACP, 0, pNode->txt, stl, NULL, 0, NULL, NULL);
				if (pBuf != NULL && lBuf != 0) {
					WideCharToMultiByte(CP_ACP, 0, pNode->txt, -1, pBuf, lBuf, NULL, NULL);
					pBuf[lBuf - 1] = 0;
				}
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI		AjcBarGetTextW		(HWND hwnd, UI key, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	PBARTXO	pNode;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pNode = AjcAvlGetNodePtr(pW->hAvlTxo, key, NULL)) {
				rc = (UI)wcslen(pNode->txt);
				if (pBuf != NULL && lBuf != 0) {
					wcsncpy(pBuf, pNode->txt, lBuf);
					pBuf[lBuf - 1] = 0;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	描画テキストクリアー																						//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//				key			 - テキストキー																		//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcBarClearText		(HWND hwnd, UI key)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc = AjcAvlDelNode(pW->hAvlTxo, key);
			InvalidateRect(pW->hImage, NULL, FALSE);
		}
	}
	return rc;
}

//==============================================================================================================//
//	全ての描画テキストクリアー																					//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcBarClearAllText		(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			AjcAvlDelAllNodes(pW->hAvlTxo);
			pW->kAvlTxo = 1;
			InvalidateRect(pW->hImage, NULL, FALSE);
		}
	}
	return rc;
}
//==============================================================================================================//
//	全てデータ（プロット，テキスト）クリアー																	//
//																												//
//	引　数	：	hwnd		 - ウインドハンドル																	//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI		AjcBarClear				(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			rc	= TRUE;
			rc &= AjcBarPurge		 (hwnd);
			rc &= AjcBarClearAllText (hwnd);
		}
	}
	return rc;
}
//==============================================================================================================//
//	メインウインドのハンドル取得																				//
//																												//
//	引　数	：	hwnd		- ウインドハンドル																	//
//				pBkWnd		- ウインド背景色を格納するバッファへのポインタ（不要時はNULL）						//
//																												//
//	戻り値	：	≠NULL : メインウインドのハンドル																//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HWND	WINAPI		AjcBarGetMainWindow(HWND hwnd, COLORREF *pBkGnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		if (IS_MY_INST(pW)) {
			if (pBkGnd != NULL) {
				*pBkGnd = RGB(255, 255, 255);
			}
			rc = pW->hImage;
		}
	}
	return rc;
}

//==============================================================================================================//
//																												//
//	通知情報取得																								//
//																												//
//==============================================================================================================//
//	右クリック通知情報
AJCEXPORT	PAJCBARRCLK			WINAPI	AjcBarGetNtcRClk	(HWND hwnd)
{
	PAJCBARRCLK	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		rc = &pW->NtcRClk;
	}
	return rc;
}
//	ドロップしたディレクトリ数
AJCEXPORT	UI					WINAPI	AjcBarGetNtcDirs	(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcDirs;
	}
	return rc;
}
//	ドロップしたファイル数
AJCEXPORT	UI					WINAPI	AjcBarGetNtcFiles	(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcFiles;
	}
	return rc;
}
//	グラフレンジ情報
AJCEXPORT	PAJCBAR_NTC_RANGE	WINAPI	AjcBarGetNtcRng		(HWND hwnd)
{
	PAJCBAR_NTC_RANGE	rc = NULL;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		rc = &pW->NtcRng;
	}
	return rc;
}
//	スクロール位置
AJCEXPORT	UI					WINAPI	AjcBarGetNtcScrPos	(HWND hwnd)
{
	UI		rc = 0;

	if (IsWindow(hwnd)) {
		PWRK_BARGRAPH pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
		rc = pW->NtcScrPos;
	}
	return rc;
}
