﻿//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			共通定義														//
//																												//
//**************************************************************************************************************//

#define	BAR_FLT_WIDTH	16
#define	BAR_FLT_HEIGHT	16

#define	BAR_IDC_SCALE		4001
#define	BAR_IDC_IMAGE		4002
#define	BAR_IDC_TTLSTR		4003
#define	BAR_IDC_BARSTR		4004
#define	BAR_IDC_CHK_BASE	4100		//	チェックボックスＩＤ

#define	BAR_SPACE		10			//	棒間スペース

#define	BAR_INST_ID			0xC527FD40

//--------------------------------------------------------------------------------------------------------------//
//	グラフデータ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	double	val[AJCBAR_MAXITEM];
	WC		str[AJCBAR_MAXSTR];
} BARDATA, *PBARDATA;

//--------------------------------------------------------------------------------------------------------------//
//	横線描画情報																								//
//--------------------------------------------------------------------------------------------------------------//
#define	MAX_HLINE	8
typedef struct {
	BOOL		fEnable;		//	横線描画許可フラグ
	double		pos;			//	横線描画位置
	HPEN		hPen;			//	描画ペンオブジェクト
} BARHLINE, *PBARHLINE;

//--------------------------------------------------------------------------------------------------------------//
//	テキスト描画ＡＶＬノード																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	POINT		pt;					//	描画位置
	WC			txt[1];				//	描画テキスト
} BARTXO, *PBARTXO;

//--------------------------------------------------------------------------------------------------------------//
//	ウインドワーク																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI			InstID;						//	インスタンス識別ＩＤ
	HWND		hBack;						//	バックウインドハンドル
	HWND		hScale;						//	スケール値表示ウインド
	HWND		hImage;						//	棒グラフイメージ表示ウインド
	HWND		hTtlStr;					//	棒タイトル名表示ウインド
	HWND		hBarStr;					//	棒タイトル表示ウインド
	HWND		hFilter;					//	フィルタウインドハンドル
	HWND		hChkFilt[AJCBAR_MAXITEM];	//	フィルタ・チェックボックス
	HBITMAP		hBmpScale;					//	スケール値表示ウインド			ビットマップイメージ
	HBITMAP		hBmpImage;					//	棒グラフイメージ表示ウインド	ビットマップイメージ
	HBITMAP		hBmpTtlStr;					//	棒タイトル名表示ウインド		ビットマップイメージ
	HBITMAP		hBmpBarStr;					//	棒タイトル表示ウインド			ビットマップイメージ
	UI			BackW	, BackH;			//	バックウインドの幅，高さ
	UI			ScaleW	, ScaleH;			//	スケール値表示ウインドの幅，高さ
	UI			ImageW	, ImageH;			//	棒グラフイメージ表示ウインドの幅，高さ
	UI			TtlStrW	, TtlStrH;			//	棒タイトル名表示ウインドの幅，高さ
	UI			BarStrW	, BarStrH;			//	棒タイトル表示ウインドの幅，高さ
	UI			style;						//	ウインドスタイル
	UI			MskFilt;					//	フィルタマスク
	BOOL		fInitBusy;					//	初期化中を示すフラグ
	BOOL		fFirstGetText;				//	最初のGET_TEXTフラグ
	BOOL		fEnable;					//	コントロールの有効状態
	BOOL		fScrBar;					//	スクロールバーを掴んでいることを示すフラグ
	UI			BarField;					//	棒域の幅
	UI			cxNormal;					//	通常の文字フォントの幅
	UI			cyNormal;					//	　〃　文字フォントの高さ
	WC			TtlStr[128];				//	棒のタイトル名文字列
	WC			VUnitStr[128];				//	縦軸の単位名文字列
	UI			ValidItems;					//	有効な表示項目数（フィルタで非表示となってる項目を除いた数）
	//----- データ情報 -----------------------------------------------------------------------------------------//
	UI			ImgLen;						//	グラフ全体の長さ（ピクセル数）
	UI			pxView;						//	現在の表示ピクセル位置
	int			rxView;						//	表示開始ピクセル位置（ウインド左端からの相対値，０以下）
	UI			ixView;						//	バッファの表示位置
	UI			nView;						//	表示個数
	UI			nBuf;						//	バッファに格納されているデータの個数
	UI			ixBuf;						//	バッファに格納するデータの位置
	PBARDATA	pBuf;						//	バッファデータポインタ
	//----- 色コード -------------------------------------------------------------------------------------------//
	COLORREF	RgbBorder;					//	ボーダー色
	HPEN		hPenBorder;					//	ボーダー描画ペン
	//----- プロパティ -----------------------------------------------------------------------------------------//
	AJCBARPROP	prop;
	AJCBARPROP	SvProp;
	//----- 右クリック通知情報 ---------------------------------------------------------------------------------//
	BOOL		fNtcRClk;					//	右クリック通知フラグ（TRUE:通知する，FALSE:通知しない）
	UI			MsgRBDown;					//	右ボタンダウン時の通知メッセージコード
	UI			MsgRBUp;					//	右ボタンアップ時の通知メッセージコード
	//----- ツールチップ情報 -----------------------------------------------------------------------------------//
	WCP			pToolTipTxt;						//	テキストボックスのツールヒントメッセージ
	WCP			pChkBoxTool[AJCBAR_MAXITEM];		//	チェックボックスのツールヒントメッセージ
	BOOL		fShowAlways;						//	グラフィックのツールヒント表示条件
	BOOL		fChkBoxShowAlways[AJCBAR_MAXITEM];	//	チェックボックスのツールヒント表示条件
	//----- 横線描画情報テーブル -------------------------------------------------------------------------------//
	BARHLINE	HLineTbl[MAX_HLINE];
	//----- ドロップファイル名一時保留バッファ情報 -------------------------------------------------------------//
	HAJCRNG		hRngFile;					//	リングバッファハンドル
	UB			StaRngFile[1024];			//	スタティックリングバッファ
	//----- ドロップＤＩＲ名一時保留バッファ情報 ---------------------------------------------------------------//
	HAJCRNG		hRngDir;					//	リングバッファハンドル
	UB			StaRngDir[1024];			//	スタティックリングバッファ
	//----- タイトル文字列描画情報 -----------------------------------------------------------------------------//
	CTRL_TTLINFO TtlInfo;					//	タイトルビットマップ情報
	//----- 通知情報 -------------------------------------------------------------------------------------------//
	AJCBARRCLK			NtcRClk;			//	右クリック通知情報
	UI					NtcDirs;			//	ドロップしたディレクトリ数
	UI					NtcFiles;			//	ドロップしたファイル数
	AJCBAR_NTC_RANGE	NtcRng;				//	グラフレンジ情報
	UI					NtcScrPos;			//	スクロール位置
	//----- テキスト描画情報 -----------------------------------------------------------------------------------//
	HFONT				hFontTxo;				//	テキスト描画フォント
	HAJCTXO				hTxo;					//	テキスト描画インスタンス
	UI					kAvlTxo;				//	テキスト描画ＡＶＬキー
	HAJCAVL				hAvlTxo;				//	テキス描画ＡＶＬ
} WRK_BARGRAPH, *PWRK_BARGRAPH;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//

extern	ATOM	BarClassBack;
extern	ATOM	BarClassScale;
extern	ATOM	BarClassImage;
extern	ATOM	BarClassTtlStr;
extern	ATOM	BarClassBarStr;
extern	ATOM	BarClassFilter;
extern	ATOM	BarClassForMSIL;

extern	HFONT	BarhMyFont;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルサブ関数																							//
//--------------------------------------------------------------------------------------------------------------//
extern	WNDPROC		BarWndProcBack();
extern	WNDPROC		BarWndProcBarStr();
extern	WNDPROC		BarWndProcFilt();
extern	WNDPROC		BarWndProcImage();
extern	WNDPROC		BarWndProcScale();
extern	WNDPROC		BarWndProcTtlStr();
extern	WNDPROC		BarWndProcMSIL();
extern	HWND		BarCreateDlgSetRange(PWRK_BARGRAPH pW);


extern	BOOL	BarSetData			(PWRK_BARGRAPH pW, C_WCP pTitle, double data[]);
extern	BOOL	BarPurge			(PWRK_BARGRAPH pW);
extern	BOOL	BarSetBorderColor	(PWRK_BARGRAPH pW, COLORREF color);
extern	BOOL	BarSetProp			(PWRK_BARGRAPH pW, PCAJCBARPROP pNew);
extern	BOOL	BarGetProp			(PWRK_BARGRAPH pW, PAJCBARPROP pBuf);
extern	BOOL	BarSetRange			(PWRK_BARGRAPH pW, double low, double high);
extern	BOOL	BarSetBase			(PWRK_BARGRAPH pW, double base);


extern	VO		BarSetScrollInfo  (PWRK_BARGRAPH pW);
extern	VO		SetViewInfoCurrent(PWRK_BARGRAPH pW);
extern	UI		BarBixToDix		  (PWRK_BARGRAPH pW, UI bix);
extern	UI		BarDixToBix		  (PWRK_BARGRAPH pW, UI dix);
extern	int		BarDatToYPos	  (PWRK_BARGRAPH pW, double dat);
extern	VO		BarReDraw		  (PWRK_BARGRAPH pW, BOOL fClear);
extern	VO		BarSetBarFieldLen (PWRK_BARGRAPH pW);
extern	VO		BarSetValidItems  (PWRK_BARGRAPH pW);
extern	VO		BarPaintBackWnd	  (PWRK_BARGRAPH pW, HDC hdc, int width, int height);
extern	HBITMAP	BarCreateBitmap	  (PWRK_BARGRAPH pW);
extern	VO		BarSetViewInfoTail (PWRK_BARGRAPH pW);


