﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			レンジ設定ダイアログ											//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(SetRange);

//==============================================================================================================//
//																												//
//	レンジ設定ダイアログ生成																					//
//																												//
//==============================================================================================================//
HWND	BarCreateDlgSetRange(PWRK_BARGRAPH pW)
{
	HWND	rc = NULL;
	rc = (HWND)DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_BARSETRANGE), pW->hBack, AJC_DLGPROC_NAME(SetRange), (LPARAM)pW);
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	グラフレンジ設定ダイアログプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, WM_INITDIALOG	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)lParam;

	//----- ワークポインタをウインドに設定 ------------//
	SetProp(hDlg, L"AjcBarSetRange", pW);
	//----- アイコン設定 ------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	//----- 日英テキスト ------------------------------//
	SetWindowText (hDlg, LNGSEL(L"レンジ設定", L"Set Range"));
	SetDlgItemText(hDlg, IDC_LBL_RNGH, LNGSEL(L"高位レンジ", L"Top Value"	));
	SetDlgItemText(hDlg, IDC_LBL_RNGL, LNGSEL(L"低位レンジ", L"Bottom Value"));
	SetDlgItemText(hDlg, IDC_LBL_BASE, LNGSEL(L"ベース値"  , L"Base Value"	));
	SetDlgItemText(hDlg, IDOK		 , LNGSEL(L"ＯＫ"	   , L"OK"			));
	SetDlgItemText(hDlg, IDCANCEL	 , LNGSEL(L"キャンセル", L"Cancel"		));
	//----- レンジ値設定 ------------------------------//
	AjcSetDlgItemReal(hDlg, IDC_TXT_RNGH, pW->prop.RngH, -10);
	AjcSetDlgItemReal(hDlg, IDC_TXT_RNGL, pW->prop.RngL, -10);
	AjcSetDlgItemReal(hDlg, IDC_TXT_BASE, pW->prop.Base, -10);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, IDOK			)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)GetProp(hDlg, L"AjcBarSetRange");
	AJCBARPROP	prop;

	BarGetProp(pW, &prop);
	prop.RngH = AjcGetDlgItemReal(hDlg, IDC_TXT_RNGH);
	prop.RngL = AjcGetDlgItemReal(hDlg, IDC_TXT_RNGL);
	prop.Base = AjcGetDlgItemReal(hDlg, IDC_TXT_BASE);
	BarSetProp(pW, &prop);
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, IDCANCEL		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)GetProp(hDlg, L"AjcBarSetRange");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SetRange)
	AJC_DLGMAP_MSG(SetRange, WM_INITDIALOG	)
	AJC_DLGMAP_CMD(SetRange, IDOK			)
	AJC_DLGMAP_CMD(SetRange, IDCANCEL		)
AJC_DLGMAP_END
