﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			ＭＳＩＬ(.NET Framework)対応処理								//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(MSIL);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
#define	IDC_PARENT	5000
#define	IDC_CTRL	5001

//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HWND	hCtrl;			//	棒グラフウインド
	VO (CALLBACK *cbRengeChanged)(double low, double high);
	VO (CALLBACK *cbNtcScrollPos)(UI pos);
	VO (CALLBACK *cbFileDrop	)(UI n	 );
	VO (CALLBACK *cbDirDrop 	)(UI n	 );
	VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl);
	BOOL	fShowScrollBar;
} WKMSIL, *PWKMSIL;
//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールウインド生成																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcBarCreateForMSIL(HWND hOwner, BOOL fShowScrollBar, VO (CALLBACK *cbRengeChanged)(double low, double high),
																			VO (CALLBACK *cbNtcScrollPos)(UI pos),
																			VO (CALLBACK *cbFileDrop	)(UI n	 ),
																			VO (CALLBACK *cbDirDrop 	)(UI n	 ),
																			VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl))
{
	HWND		hBack = NULL;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk = NULL;
	RECT		rect;

	do {
		//----- 親ウインドハンドルチェック ---------------------------------------------------------------------//
		if (!IsWindow(hOwner)) break;
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbRengeChanged = cbRengeChanged;
		pWk->cbNtcScrollPos = cbNtcScrollPos;
		pWk->cbFileDrop		= cbFileDrop;
		pWk->cbDirDrop	 	= cbDirDrop;
		pWk->cbRClick		= cbRClick;
		pWk->fShowScrollBar = fShowScrollBar;
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hOwner, &rect);
		//----- バックウインド生成 -----------------------------------------------------------------------------//
		hBack = CreateWindow((WCP)BarClassForMSIL,			// window class name
								L"",						// window caption
								WS_CHILD,					// window style
								0,							// initial x position
								0,							// initial y position
								rect.right - rect.left,		// initial x size
								rect.bottom - rect.top,		// initial y size
								hOwner,						// parent window handle
								(HMENU)IDC_PARENT,			// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hBack == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hCtrl = pWk->hCtrl;
		//----- チップコントロール対象ウインド設定 -------------------------------------------------------------//
		AJCTIPCTRL_SETHWNDA(hOwner, hCtrl);
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hBack, SW_SHOW);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hBack == NULL) {
		if (pWk != NULL) free(pWk);
	}
	return hCtrl;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	親ウインドプロシージャ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = ((LPCREATESTRUCT)lParam)->lpCreateParams;
	RECT		rect;

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ウインドサイズ取得 -----------------------------------------------------------------------------//
		GetClientRect(hwnd, &rect);
		//----- タイムチャートウインド生成 ---------------------------------------------------------------------//
		hCtrl = CreateWindow(L"AjcCtrlBarGraph",									// window class name
							L"",													// window caption
							WS_CHILD | WS_VISIBLE | (pWk->fShowScrollBar ? 0 : AJCBARS_NOSCROLLBAR), 	// style
							0,														// initial x position
							0,														// initial y position
							rect.right - rect.left,									// initial x size
							rect.bottom - rect.top,									// initial y size
							hwnd,													// parent window handle
							(HMENU)IDC_CTRL,										// window menu handle
							hDllInst,												// program instance handle
							NULL);													// creation parameters
		if (hCtrl == NULL) break;
		//----- ウインド表示 -----------------------------------------------------------------------------------//
		ShowWindow(hCtrl, SW_SHOW);
		//----- コントロールのハンドル退避 ---------------------------------------------------------------------//
		pWk->hCtrl = hCtrl;
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (VOP)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		if (pWk->hCtrl != NULL) {
			DestroyWindow(pWk->hCtrl);
			pWk->hCtrl = NULL;
		}
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SIZE		)
{
	PWKMSIL		pWk = (VOP)MAjcGetWindowLong(hwnd, 0);
	int			width  = LOWORD(lParam);
	int			height = HIWORD(lParam);

	SetWindowPos(pWk->hCtrl, NULL, 0, 0, width, height, SWP_NOMOVE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_RBUTTONDOWN	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk->cbRClick != NULL) {
		pWk->cbRClick((int)LOWORD(lParam), (int)HIWORD(lParam), ((wParam & MK_SHIFT) != 0), ((wParam & MK_CONTROL) != 0));
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, IDC_CTRL		)
{
	PWKMSIL		pWk = (VOP)MAjcGetWindowLong(hwnd, 0);

	if (LOWORD(wParam) == IDC_CTRL) {
		switch (HIWORD(wParam)) {
			case AJCBARN_RANGE:								//	●レンジ通知
			{	PAJCTC_NTC_RANGE p = (VOP)lParam;
				if (pWk->cbRengeChanged != NULL) {
					pWk->cbRengeChanged(p->RngL, p->RngH);
				}
				break;
			}
			case AJCBARN_SCRPOS:							//	●スクロール位置通知
				if (pWk->cbNtcScrollPos != NULL) {
					pWk->cbNtcScrollPos((UI)lParam);
				}
				break;

			case AJCBARN_DROPFILE:							//	●ファイルドロップ通知
				if (pWk->cbFileDrop != NULL) {
					pWk->cbFileDrop((UI)lParam);
				}
				break;

			case AJCBARN_DROPDIR:							//	●ディレクトリドロップ通知
				if (pWk->cbDirDrop != NULL) {
					pWk->cbDirDrop((UI)lParam);
				}
				break;

			case AJCBARN_RCLICK:							//	●右クリック通知
			{	PAJCBARRCLK	p = (PAJCBARRCLK)lParam;
				if (pWk->cbRClick != NULL) {
					pWk->cbRClick(p->x, p->y, p->fShift, p->fCtrl);
				}
				break;
			}
		}
	}

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SIZE			)
	AJC_WNDMAP_MSG(MSIL, WM_RBUTTONDOWN		)

	AJC_WNDMAP_CMD(MSIL, IDC_CTRL			)
AJC_WNDMAP_END
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	スタイルの設定／取得関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- スタイル取得マクロ -------------------------------------------------------------------------------------//
#define	MGET_STY(NAME)	AJCEXPORT BOOL WINAPI AjcBarGetSty_##NAME(HWND hwnd) {									\
	return (BOOL)((MAjcGetWindowLong(hwnd, GWL_STYLE) & AJCBARS_##NAME) != 0);									\
}
//----- スタイル設定マクロ -------------------------------------------------------------------------------------//
#define	MSET_STY(NAME)	AJCEXPORT VO WINAPI AjcBarSetSty_##NAME(HWND hwnd, BOOL f) {							\
	if (f) MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) |	AJCBARS_##NAME);			\
	else   MAjcSetWindowLong(hwnd, GWL_STYLE, MAjcGetWindowLong(hwnd, GWL_STYLE) & ~AJCBARS_##NAME);			\
}

//----- コントロールの外枠・非表示／表示	(AJCBARS_NOBORDER) -------------------------------------------------//
MGET_STY(NOBORDER)
MSET_STY(NOBORDER)

//----- 折れ線グラフモード					(AJCBARS_LINEGRAPH) ------------------------------------------------//
MGET_STY(LINEGRAPH)
MSET_STY(LINEGRAPH)

//----- フィルタ非表示／表示				(AJCBARS_NOFILTER) -------------------------------------------------//
MGET_STY(NOFILTER)
MSET_STY(NOFILTER)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	プロパティの設定／取得関数																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- プロパティ取得マクロ -----------------------------------------------------------------------------------//
#define	MGET_PROP(TYPE, NAME)		AJCEXPORT TYPE WINAPI AjcBarGetProp_##NAME(HWND hwnd) {						\
	AJCBARPROP	p;																								\
	AjcBarGetProp(hwnd, &p);																					\
	return p.NAME;																								\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MGET_PROPIX(TYPE, NAME)	AJCEXPORT TYPE WINAPI AjcBarGetProp_##NAME(HWND hwnd, UI ix) {					\
	TYPE		rc	  = 0;																						\
	AJCBARPROP	p;																								\
	if (ix < AJCTC_MAXITEM) {																					\
		AjcBarGetProp(hwnd, &p);																				\
		rc = p.NAME[ix];																						\
	}																											\
	return rc;																									\
}
//----- プロパティ設定マクロ -----------------------------------------------------------------------------------//
#define	MSET_PROP(TYPE, NAME)		AJCEXPORT VO WINAPI AjcBarSetProp_##NAME(HWND hwnd, TYPE n) {				\
	AJCBARPROP p;																								\
	AjcBarGetProp(hwnd, &p);																					\
	p.NAME = n;																									\
	AjcBarSetProp(hwnd, &p);																					\
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
#define	MSET_PROPIX(TYPE, NAME)		AJCEXPORT VO WINAPI AjcBarSetProp_##NAME(HWND hwnd, UI ix, TYPE n) {		\
	AJCBARPROP p;																								\
	if (ix < AJCTC_MAXITEM) {																					\
		AjcBarGetProp(hwnd, &p);																				\
		p.NAME[ix] = n;																							\
		AjcBarSetProp(hwnd, &p);																				\
	}																											\
}
//----- 低位レンジ値 		(RngL) -----------------------------------------------------------------------------//
MGET_PROP(double, RngL)
MSET_PROP(double, RngL)

//----- 高位レンジ値 		(RngH) -----------------------------------------------------------------------------//
MGET_PROP(double, RngH)
MSET_PROP(double, RngH)

//----- ベース値 			(Base) -----------------------------------------------------------------------------//
MGET_PROP(double, Base)
MSET_PROP(double, Base)

//----- バッファ容量		(MaxBuf) ---------------------------------------------------------------------------//
MGET_PROP(UI, MaxBuf)
MSET_PROP(UI, MaxBuf)

//----- 最大データ項目数	(MaxItem) --------------------------------------------------------------------------//
MGET_PROP(UI, MaxItem)
MSET_PROP(UI, MaxItem)

//----- スケール値表示息の幅(ScaleWidth) -----------------------------------------------------------------------//
MGET_PROP(UI, ScaleWidth)
MSET_PROP(UI, ScaleWidth)

//----- 棒の幅				(BarWidth) -------------------------------------------------------------------------//
MGET_PROP(UI, BarWidth)
MSET_PROP(UI, BarWidth)

//----- 棒域の最小値		(MinWidth) -------------------------------------------------------------------------//
MGET_PROP(UI, MinWidth)
MSET_PROP(UI, MinWidth)

//----- 棒タイトルの行数	(BarTtlLines) ----------------------------------------------------------------------//
MGET_PROP(UI, BarTtlLines)
MSET_PROP(UI, BarTtlLines)

//----- 表示色				(rgb[]) ----------------------------------------------------------------------------//
MGET_PROPIX(UI, rgb)
MSET_PROPIX(UI, rgb)

//----- 文字の幅 -----------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcBarGetProp_CharWidth(HWND hwnd)
{
	SIZE	size;
	AjcBarGetCharSize (hwnd, &size);
	return size.cx;
}

//----- 文字の高さ ---------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcBarGetProp_CharHeight(HWND hwnd)
{
	SIZE	size;
	AjcBarGetCharSize (hwnd, &size);
	return size.cy;
}

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcBarSetProp_WndSize(HWND hwnd, UI width, UI height)
{
	if (IsWindow(hwnd)) {
		HWND		hParent;

		if (hParent = GetParent(hwnd)) {
			SetWindowPos(hParent , NULL, 0, 0, width, height, SWP_NOMOVE);
		}
	}
}

//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcBarSetProp_AcceptFiles(HWND hwnd, BOOL fEnable)
{
	if (IsWindow(hwnd)) {
		UX	ExSty = MAjcGetWindowLong(hwnd, GWL_EXSTYLE);

		if (fEnable) ExSty |=  WS_EX_ACCEPTFILES;
		else		 ExSty &= ~WS_EX_ACCEPTFILES;

		MAjcSetWindowLong(hwnd, GWL_EXSTYLE, ExSty);
	}
}
AJCEXPORT BOOL WINAPI AjcBarGetProp_AcceptFiles(HWND hwnd)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = ((MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES) != 0);
	}
	return rc;
}

//----- データ投与 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcBarPutData1	(HWND hwnd, C_WCP pBarTtl, double dat0)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData2	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData3	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData4	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData5	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData6	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	dat[5] = dat5;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData7	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	dat[5] = dat5;
	dat[6] = dat6;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT VO WINAPI	AjcBarPutData8	(HWND hwnd, C_WCP pBarTtl, double dat0, double dat1, double dat2, double dat3, double dat4, double dat5, double dat6, double dat7)
{
	double	dat[8];

	memset(dat, 0, sizeof dat);
	dat[0] = dat0;
	dat[1] = dat1;
	dat[2] = dat2;
	dat[3] = dat3;
	dat[4] = dat4;
	dat[5] = dat5;
	dat[6] = dat6;
	dat[7] = dat7;
	AjcBarPutRealDataW(hwnd, dat, pBarTtl);
}
//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcBarSetTipTextForMSIL(HWND hwnd, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = AjcTAllocW(stl + 1)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		AjcBarSetTipTextW(hwnd, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI	WINAPI	AjcBarGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = AjcTAllocW(lBuf)) {
		AjcBarGetTipTextW(hwnd, pTmp, lBuf);
		AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}
//----- フィルタチップテキスト設定／取得 -----------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcBarSetChkBoxTipTextForMSIL(HWND hwnd, UI n, C_WCP pTxt)
{
	BOOL	rc = FALSE;
	UI		stl;
	WCP		pTmp;

	if (pTxt == NULL) pTxt = L"";

	stl = (UI)wcslen(pTxt);
	if (pTmp = AjcTAllocW(stl + 1)) {
		AjcCLangStrToBinW(pTxt, pTmp, stl + 1);
		rc = AjcBarSetChkBoxTipTextW(hwnd, n, pTmp);
		free(pTmp);
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	UI		WINAPI		AjcBarGetChkBoxTipTextForMSIL(HWND hwnd, UI n, WCP pBuf, UI lBuf)
{
	UI		rc = 0;
	WCP		pTmp;

	if (pTmp = AjcTAllocW(lBuf)) {
		AjcBarGetChkBoxTipTextW(hwnd, n, pTmp, lBuf);
		rc = AjcBinToCLangStrW(pTmp, pBuf, lBuf);
		free(pTmp);
	}
	return rc;
}
