﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			共通サブ関数													//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	データ設定																									//
//																												//
//	引　数	：	pTitle	- 棒のタイトル																			//
//				data	- グラフデータのアドレス																//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarSetData(PWRK_BARGRAPH pW, C_WCP pTitle, double data[])
{
	SCROLLINFO		si;

	//----- バッファへデータ設定 -------------------------------------------------------//
	memcpy (pW->pBuf[pW->ixBuf].val, (VOP)data, sizeof(double) * pW->prop.MaxItem);
	wcsncpy(pW->pBuf[pW->ixBuf].str, (VOP)pTitle, AJCBAR_MAXSTR);
	pW->pBuf[pW->ixBuf].str[AJCBAR_MAXSTR - 1] = 0;
	if (pW->nBuf < pW->prop.MaxBuf) pW->nBuf++;								//	バッファデータ数更新
	pW->ixBuf = (pW->ixBuf + 1) % pW->prop.MaxBuf;							//	バッファインデクス更新

	//----- 棒グラフの全イメージ幅更新 -------------------------------------------------//
	pW->ImgLen = pW->nBuf * pW->BarField;

	//----- スクロール情報更新 ---------------------------------------------------------//
	if (!pW->fScrBar) {														//	スクロールバー非操作中？
		BarSetViewInfoTail(pW);												//		末尾部分表示開始位置設定
		BarSetScrollInfo(pW);												//		スクロール情報設定
	}
	else {																	//	スクロールバー操作中？
		si.cbSize = sizeof(SCROLLINFO);
		si.fMask  = SIF_POS;
		GetScrollInfo(pW->hBarStr, SB_HORZ, &si);							//		表示開始位置を、
		pW->pxView = si.nPos;												//		スクロールバー位置とする
		pW->rxView = -((int)(si.nPos % pW->BarField));
		pW->ixView = BarDixToBix(pW, si.nPos / pW->BarField);
		SetViewInfoCurrent(pW);												//		現在位置以降の表示情報設定
	}
	BarReDraw(pW, FALSE);														//	再描画

	return TRUE;
}
//==============================================================================================================//
//	データクリアー																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarPurge(PWRK_BARGRAPH pW)
{
	pW->ImgLen = 0;
	pW->pxView = 0;
	pW->rxView = 0;
	pW->ixView = 0;
	pW->nView  = 0;
	pW->nBuf   = 0;
	pW->ixBuf  = 0;
	BarSetScrollInfo(pW);
	BarReDraw(pW, FALSE);
	return TRUE;
}
//==============================================================================================================//
//	ボーダー色設定																								//
//																												//
//	引　数	：	color	- ボーダーカラー																		//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarSetBorderColor(PWRK_BARGRAPH pW, COLORREF color)
{
	BOOL	rc = FALSE;
	HPEN	hPen;

	if (hPen = CreatePen(PS_SOLID, 1, color)) {
		if (pW->hPenBorder != NULL) DeleteObject(pW->hPenBorder);
		pW->RgbBorder  = color;
		pW->hPenBorder = hPen;
		InvalidateRect(pW->hBack, NULL, FALSE);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	プロパティ設定																								//
//																												//
//	引　数	：	pNew	- 新プロパティ																			//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarSetProp(PWRK_BARGRAPH pW, PCAJCBARPROP pNew)
{
	BOOL		rc = TRUE;
	PBARDATA	pTmpBuf;
	BOOL		fNeedReSize = FALSE;

	if (pNew->MaxBuf  >= 2 && pNew->MaxBuf	<= AJCBAR_MAXBUF	&&
		pNew->MaxItem >= 1 && pNew->MaxItem <= AJCBAR_MAXITEM) {
		if (pW->prop.MaxBuf != pNew->MaxBuf || pW->prop.MaxItem != pNew->MaxItem) {
			if ((pTmpBuf = (PBARDATA)AJCMEM(sizeof(BARDATA) * pNew->MaxBuf)) != NULL) {
				memset(pTmpBuf, 0, sizeof(BARDATA) * pNew->MaxBuf);
				pW->pxView = 0;
				pW->rxView = 0;
				pW->ixView = 0;
				pW->nView  = 0;
				pW->nBuf   = 0;
				pW->ixBuf  = 0;
				pW->prop.MaxBuf	 = pNew->MaxBuf;
				pW->prop.MaxItem = pNew->MaxItem;
				if (pW->pBuf != NULL) free(pW->pBuf);
				pW->pBuf = pTmpBuf;
			}
			else {
				if (pTmpBuf != NULL) free(pTmpBuf);
				rc = FALSE;
			}
		}
		//---- 表示域の構成が変化した場合は、各ウインド再構成 ----------//
		if (pW->prop.ScaleWidth != pNew->ScaleWidth ||	pW->prop.BarTtlLines != pNew->BarTtlLines) {
			fNeedReSize = TRUE;
		}
		//----- グラフレンジが変化した場合は、レンジを通知 -------------//
		if (pW->prop.RngL != pNew->RngL || pW->prop.RngH != pNew->RngH) {
			PostMessage(pW->hBack, AJCBARM_NEEDNTC_RANGE, 0, 0);
		}
		pW->prop.RngL			= pNew->RngL;
		pW->prop.RngH			= pNew->RngH;
		pW->prop.Base			= pNew->Base;
		pW->prop.ScaleWidth		= __max(32, pNew->ScaleWidth );
		pW->prop.BarWidth		= __max( 4, pNew->BarWidth	 );
		pW->prop.MinWidth		= __max(10, pNew->MinWidth	 );
		pW->prop.BarTtlLines	= __max( 1, pNew->BarTtlLines);
		memcpy(pW->prop.rgb, &pNew->rgb, sizeof pW->prop.rgb);
		SetWindowPos(pW->hFilter, NULL, 0, 0, (BAR_FLT_WIDTH + 4) * pW->prop.MaxItem, BAR_FLT_HEIGHT + 4, SWP_NOMOVE);

		//----- 有効な表示項目数設定 -----------------------------------//
		BarSetValidItems(pW);

		//----- 棒表示域の長さ設定 -------------------------------------//
		BarSetBarFieldLen(pW);

		//----- 表示情報設定 -------------------------------------------//
		SetViewInfoCurrent(pW);

		//----- スクロール情報更新 -------------------------------------//
		BarSetScrollInfo(pW);

		//---- 表示域の構成が変化した場合は、各ウインド再構成 ----------//
		if (fNeedReSize) {
			SendMessage(pW->hBack, WM_SIZE, 0, MAKELONG(pW->BackW, pW->BackH));
		}

		//----- 再描画 -------------------------------------------------//
		BarReDraw(pW, FALSE);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	プロパティ取得																								//
//																												//
//	引　数	：	pBuf	- プロパティ格納バッファ																//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarGetProp(PWRK_BARGRAPH pW, PAJCBARPROP pBuf)
{
	memcpy(pBuf, &pW->prop, sizeof(AJCBARPROP));
	return TRUE;
}
//==============================================================================================================//
//	レンジ設定																									//
//																												//
//	引　数	：	low, high	- レンジ																			//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarSetRange(PWRK_BARGRAPH pW, double low, double high)
{
	BOOL			rc;
	AJCBARPROP		prop;

	memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
	prop.RngL = low;
	prop.RngH = high;
	rc = BarSetProp(pW, &prop);

	return rc;
}
//==============================================================================================================//
//	ベース設定																									//
//																												//
//	引　数	：	base	- ベース値																				//
//																												//
//	戻り値	：	TRUE - 成功，FALSE - 失敗																		//
//==============================================================================================================//
BOOL	BarSetBase(PWRK_BARGRAPH pW, double base)
{
	AJCBARPROP		prop;
	BOOL			rc;

	memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
	prop.Base = base;
	rc = BarSetProp(pW, &prop);

	return rc;
}
//==============================================================================================================//
//																												//
//	スクロール情報の設定とスクロールバー表示／非表示															//
//																												//
//==============================================================================================================//
VO		BarSetScrollInfo(PWRK_BARGRAPH pW)
{
	SCROLLINFO		si;

	//----- スクロール情報設定 -------------------------------------------//
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask  = SIF_PAGE | SIF_RANGE | SIF_POS;
	si.nMin	  = 0;
	si.nMax	  = pW->ImgLen;
	si.nPage  = pW->BarStrW;
	si.nPos	  = pW->pxView;
	SetScrollInfo(pW->hBarStr, SB_HORZ, &si, TRUE);

	//----- スクロールバー表示／非表示 ------------------------------------//
	if (pW->style & AJCBARS_NOSCROLLBAR) {
		ShowScrollBar(pW->hBarStr, SB_HORZ, FALSE);
	}
	else {
		if (pW->ImgLen <= pW->BarStrW) {
			ShowScrollBar(pW->hBarStr, SB_HORZ, FALSE);
		}
		else {
			ShowScrollBar(pW->hBarStr, SB_HORZ, TRUE);
		}
	}
}
//==============================================================================================================//
//																												//
//	現在位置以降の表示情報設定																					//
//																												//
//==============================================================================================================//
VO		SetViewInfoCurrent(PWRK_BARGRAPH pW)
{
	UI		nMaxView;
	int		dix, dixMax, rem;

	dix		   = BarBixToDix(pW, pW->ixView);						//	表示先頭データ・インデクス
	rem		   = pW->BarStrW % pW->BarField;					//	表示端数ピクセル数
	nMaxView   = (pW->BarStrW / pW->BarField) + (rem != 0);		//	最大表示可能個数
	dixMax	   = pW->nBuf - nMaxView;							//	最小データ・インデクス
	dixMax	   = __max(dixMax, 0);								//	・
	if (dixMax < dix) {											//	データインデクス補正要？
		dix		   = dixMax;									//		データインデクス補正
		pW->ixView = BarDixToBix(pW, dix);							//		バッファインデクス設定
	}
	if (rem == 0) pW->rxView = 0;								//	左に隠れた部分のピクセル数
	else		  pW->rxView = -((int)(pW->BarField - rem));	//	・
	pW->pxView = dix * pW->BarField + abs(pW->rxView);			//	グラフ左端に対応するデータピクセル位置
	pW->nView  = pW->nBuf - dix;								//	表示個数
	pW->nView  = __min(pW->nView, nMaxView);					//	・
}
//==============================================================================================================//
//																												//
//	バッファインデクス→データインデクス変換																	//
//																												//
//==============================================================================================================//
UI		BarBixToDix(PWRK_BARGRAPH pW, UI bix)
{
	UI		rc;

	if (pW->nBuf < pW->prop.MaxBuf) {
		rc = bix;
	}
	else {
		if (bix >= pW->ixBuf) rc = bix - pW->ixBuf;
		else				  rc = ((pW->prop.MaxBuf - pW->ixBuf) + bix) % pW->prop.MaxBuf;
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	データインデクス→バッファインデクス変換																	//
//																												//
//==============================================================================================================//
UI		BarDixToBix(PWRK_BARGRAPH pW, UI dix)
{
	UI		rc;

	if (pW->nBuf < pW->prop.MaxBuf) {
		rc = dix;
	}
	else {
		rc = (pW->ixBuf + dix) % pW->prop.MaxBuf;
	}
	return rc;
}
//==============================================================================================================//
//																												//
//	データ値→Ｙ位置変換																						//
//																												//
//==============================================================================================================//
int		BarDatToYPos(PWRK_BARGRAPH pW, double dat)
{
	double	y;

	if (pW->prop.RngL <= pW->prop.RngH) {
		y = (double)pW->ImageH * ((dat - pW->prop.RngL) / fabs(pW->prop.RngH - pW->prop.RngL));
		y = pW->ImageH - y;
	}
	else {
		y = (double)pW->ImageH * ((dat - pW->prop.RngH) / fabs(pW->prop.RngH - pW->prop.RngL));
	}
	return (int)y;
}
//==============================================================================================================//
//																												//
//	再描画																										//
//																												//
//==============================================================================================================//
VO		BarReDraw(PWRK_BARGRAPH pW, BOOL fClear)
{
//	InvalidateRect(pW->hBack  , NULL, fClear);
	InvalidateRect(pW->hScale , NULL, fClear);
	InvalidateRect(pW->hImage , NULL, fClear);
	InvalidateRect(pW->hTtlStr, NULL, fClear);
	InvalidateRect(pW->hBarStr, NULL, fClear);
	InvalidateRect(pW->hFilter, NULL, fClear);
}
//==============================================================================================================//
//																												//
//	有効な表示項目数設定																						//
//																												//
//==============================================================================================================//
VO		BarSetValidItems(PWRK_BARGRAPH pW)
{
	UI		n;
	UI		i;
	UI		msk;

	for (i = 0, n = 0, msk = 0x01; i < pW->prop.MaxItem; i++, msk <<= 1) {
		if (pW->MskFilt & msk) {
			n++;
		}
	}
	pW->ValidItems = n;
}
//==============================================================================================================//
//																												//
//	棒表示域の長さ計算																							//
//																												//
//==============================================================================================================//
VO		BarSetBarFieldLen(PWRK_BARGRAPH pW)
{
	//----- 折れ線グラフの場合 -----------------------------------------//
	if (pW->style & AJCBARS_LINEGRAPH) {
		pW->BarField = __max(pW->prop.MinWidth, 10);
	}
	//----- 棒グラフの場合 ---------------------------------------------//
	else {
		pW->BarField = pW->prop.BarWidth * pW->ValidItems + BAR_SPACE;
		pW->BarField = __max(pW->BarField, pW->prop.MinWidth);
		pW->ImgLen	 = pW->BarField * pW->nBuf;
	}
}
//==============================================================================================================//
//																												//
//	バックウインド描画																							//
//																												//
//==============================================================================================================//
VO		BarPaintBackWnd(PWRK_BARGRAPH pW, HDC hdc, int width, int height)
{
	HPEN		hPen;

	//----- ボーダー描画 ---------------------------------------------------//
	if (pW->style & AJCBARS_NOBORDER) {
		hPen = (HPEN)SelectObject(hdc, hPenBtnFace);
	}
	else {
		if (pW->fEnable) hPen = (HPEN)SelectObject(hdc, pW->hPenBorder);
		else			 hPen = (HPEN)SelectObject(hdc, hPenGrayText);
	}
	MoveToEx(hdc, 0			, 0			, NULL);
	LineTo	(hdc, width - 1 , 0			);
	LineTo	(hdc, width - 1 , height - 1);
	LineTo	(hdc, 0			, height - 1);
	LineTo	(hdc, 0			, 0			);
	SelectObject(hdc, hPen);

	//----- 十字ライン描画 -------------------------------------------------//
	hPen = (HPEN)SelectObject(hdc, (HPEN)GetStockObject(BLACK_PEN));
	MoveToEx(hdc, pW->ScaleW + 1, 1				 , NULL);
	LineTo	(hdc, pW->ScaleW + 1, pW->BackH	 - 1	   );
	MoveToEx(hdc, 1				, pW->ScaleH + 1 , NULL);
	LineTo	(hdc, pW->BackW - 1 , pW->ScaleH + 1	   );
	SelectObject(hdc, hPen);

}
//==============================================================================================================//
//																												//
//	コントロールのビットマップ・イメージ生成																	//
//																												//
//==============================================================================================================//
HBITMAP		BarCreateBitmap(PWRK_BARGRAPH pW)
{
	HBITMAP	hBmp = NULL;
	HBITMAP	svBmp;
	HDC		hdc, hmd, hmc;
	RECT	r;

	hdc = GetDC(pW->hBack);
	hmd = CreateCompatibleDC(hdc);
	hmc = CreateCompatibleDC(hdc);
	if (hmd != NULL) {
		hBmp = CreateCompatibleBitmap(hdc, pW->BackW, pW->BackH);
		if (hBmp != NULL) {
			svBmp = (HBITMAP)SelectObject(hmd, hBmp);
			//----- ビットマップクリアー ------------------------//
			SetRect(&r, 0, 0, pW->BackW, pW->BackH);
			FillRect(hmd, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			//----- 子ウインド配置 ------------------------------//
			if (hmc != NULL) {
				if (pW->hBmpScale != NULL) {
					SelectObject(hmc, pW->hBmpScale);
					GetWindowRect(pW->hScale, &r);
					MapWindowPoints(NULL, pW->hBack, (LPPOINT)&r, 2);
					BitBlt(hmd, r.left, r.top, r.right - r.left, r.bottom - r.top, hmc, 0, 0, SRCCOPY);
				}
				if (pW->hBmpImage != NULL) {
					SelectObject(hmc, pW->hBmpImage);
					GetWindowRect(pW->hImage, &r);
					MapWindowPoints(NULL, pW->hBack, (LPPOINT)&r, 2);
					BitBlt(hmd, r.left, r.top, r.right - r.left, r.bottom - r.top, hmc, 0, 0, SRCCOPY);
				}
				if (pW->hBmpTtlStr != NULL) {
					SelectObject(hmc, pW->hBmpTtlStr);
					GetWindowRect(pW->hTtlStr, &r);
					MapWindowPoints(NULL, pW->hBack, (LPPOINT)&r, 2);
					BitBlt(hmd, r.left, r.top, r.right - r.left, r.bottom - r.top, hmc, 0, 0, SRCCOPY);
				}
				if (pW->hBmpBarStr != NULL) {
					SelectObject(hmc, pW->hBmpBarStr);
					GetWindowRect(pW->hBarStr, &r);
					MapWindowPoints(NULL, pW->hBack, (LPPOINT)&r, 2);
					BitBlt(hmd, r.left, r.top, r.right - r.left, r.bottom - r.top, hmc, 0, 0, SRCCOPY);
				}
			}
			//----- バックウインド描画 --------------------------//
			BarPaintBackWnd(pW, hmd, pW->BackW, pW->BackH);
			SelectObject(hmd, svBmp);
		}
	}
	if (hmd != NULL) DeleteDC(hmd);
	if (hmc != NULL) DeleteDC(hmc);
	ReleaseDC(pW->hBack, hdc);

	return hBmp;
}

//==============================================================================================================//
//																												//
//	データ末尾部分の表示情報設定																				//
//																												//
//==============================================================================================================//
VO		BarSetViewInfoTail(PWRK_BARGRAPH pW)
{

	if (pW->ImgLen < pW->BarStrW) {
		pW->nView  = pW->nBuf;			//	表示個数
		pW->rxView = 0;					//	左端から左に隠れた部分のピクセル数
		pW->ixView = BarDixToBix(pW, 0);	//	表示先頭バッファ・インデクス
		pW->pxView = 0;					//	グラフ左端に対応するデータピクセル位置
	}
	else {
		UI		nMaxView;
		int		dix, rem;

		rem		   = pW->BarStrW % pW->BarField;					//	表示端数ピクセル数
		nMaxView   = (pW->BarStrW / pW->BarField) + (rem != 0);		//	最大表示可能個数
		dix		   = pW->nBuf - nMaxView;							//	表示先頭データ・インデクス
		dix		   = __max(dix, 0);									//	・
		pW->ixView = BarDixToBix(pW, dix);								//	表示先頭バッファインデクス
		if (rem == 0) pW->rxView = 0;								//	左に隠れた部分のピクセル数
		else		  pW->rxView = -((int)(pW->BarField - rem));	//	・
		pW->pxView = dix * pW->BarField + abs(pW->rxView);			//	グラフ左端に対応するデータピクセル位置
		pW->nView  = pW->nBuf - dix;								//	表示個数
		pW->nView  = __min(pW->nView, nMaxView);					//	・
	}
}

