﻿#include	"AjcInternal.h"
#include	"AjcCtrlBarGraphDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（棒グラフ）			バックウインド													//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);
static	VO		SetPropByText	  (PWRK_BARGRAPH pW, WCP pTxt, PAJCBARPROP pProp);
static	UI		MakePropText	  (PWRK_BARGRAPH pW, WCP pTxt, UI lText);
static	VO		EnableCtrls		  (PWRK_BARGRAPH pW, BOOL fEnable);
extern	VO		StyleSetting	  (PWRK_BARGRAPH pW);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		BarWndProcBack()
{
	return AJC_WNDPROC_NAME(Back);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バックウインドプロシージャ（カスタムコントロール ウインド）													//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE		)
{
	LRESULT			rc = -1;
	HDC				hdc;
	HFONT			hFont;
	PWRK_BARGRAPH	pW = NULL;
	AJCBARPROP		prop;
	RECT			r;
	TEXTMETRIC		tm;
	int				i;
	WC				PropTxt[1024];
	HINSTANCE	hModuleInstance = GetModuleHandle(NULL);

	do {
		//----- ワーク初期化 -----------------------------------------------------------------------------------//
		if ((pW = (PWRK_BARGRAPH)AJCMEM(sizeof(WRK_BARGRAPH))) == NULL) break;
		memset(pW, 0, sizeof(WRK_BARGRAPH));
		//----- インスタンス識別ＩＤ設定 -----------------------------------------------------------------------//
		pW->InstID = BAR_INST_ID;
		//----- フィルタマスク初期化 ---------------------------------------------------------------------------//
		pW->MskFilt = ((1 << AJCBAR_MAXITEM) - 1);
		//----- ウインド・エクストラ領域へワークポインタ設定 ---------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pW);
		//----- バックウインドサイズ設定 -----------------------------------------------------------------------//
		pW->hBack = hwnd;
		GetClientRect(hwnd, &r);
		pW->BackW = r.right - r.left;
		pW->BackH = r.bottom - r.top;
		//----- ウインドスタイル取得 ---------------------------------------------------------------------------//
		pW->style = (int)MAjcGetWindowLong(hwnd, GWL_STYLE);
		//----- ウインドキャプション（文字列パラメタ）取得 -----------------------------------------------------//
		pW->fFirstGetText = TRUE;
		GetWindowText(hwnd, PropTxt, AJCTSIZE(PropTxt));
		//----- デフォルトプロパティ設定 -----------------------------------------------------------------------//
		memset(&prop, 0, sizeof prop);
		prop.RngL		 = 0.0;						//	グラフ上下の座標値
		prop.RngH		 = 100.0;					//	・
		prop.Base		 = 0.0;						//	・
		prop.MaxBuf		 = 1024;					//	最大データ数
		prop.MaxItem	 = 1;						//	最大アイテム数
		prop.ScaleWidth	 = 64;						//	スケール値表示域の幅
		prop.BarWidth	 = 10;						//	棒の幅
		prop.MinWidth	 = 30;						//	棒域の最小幅
		prop.BarTtlLines = 3;						//	棒タイトルの最大行数
		prop.rgb[0]		 = RGB(	 0,	  0, 255);
		prop.rgb[1]		 = RGB(255,	  0,   0);
		prop.rgb[2]		 = RGB(	 0, 192,   0);
		prop.rgb[3]		 = RGB(	 0, 224, 224);
		prop.rgb[4]		 = RGB(255,	  0, 255);
		prop.rgb[5]		 = RGB(224, 224,   0);
		prop.rgb[6]		 = RGB(128, 128, 128);
		prop.rgb[7]		 = RGB(	 0,	  0,   0);
		//----- 有効な表示項目数初期化 -------------------------------------------------------------------------//
		pW->ValidItems = prop.MaxItem;
		//----- 棒表示域の長さ設定 -----------------------------------------------------------------------------//
		if (pW->style & AJCBARS_LINEGRAPH) pW->BarField = prop.MinWidth;
		else							   pW->BarField = __max(pW->prop.MinWidth, prop.BarWidth * prop.MaxItem + BAR_SPACE);
		//----- 描画色情報初期化 -------------------------------------------------------------------------------//
		pW->RgbBorder  = RGB(  0,	0,	 0);
		if ((pW->hPenBorder = CreatePen(PS_SOLID, 1, pW->RgbBorder)) == NULL) break;
		//----- 横線描画情報初期化 -----------------------------------------------------------------------------//
		for (i = 0; i < MAX_HLINE; i++) {
			pW->HLineTbl[i].fEnable = FALSE;
			pW->HLineTbl[i].pos		= 0.0;
			pW->HLineTbl[i].hPen	= NULL;
		}
		//----- 文字フォントのサイズ設定 -----------------------------------------------------------------------//
		hdc = GetDC(hwnd);
		// 文字フォントサイズ設定		//
		hFont = (HFONT)SelectObject(hdc, BarhMyFont);
		GetTextMetrics(hdc, &tm);
		pW->cxNormal = tm.tmAveCharWidth;
		pW->cyNormal = tm.tmHeight + 1; // + tm.tmExternalLeading;
		// 元フォント回復				//
		hFont = (HFONT)SelectObject(hdc, hFont);
		ReleaseDC(hwnd, hdc);
		//----- ドロップファイル名一時保留バッファ生成 ---------------------------------------------------------//
		pW->hRngFile = AjcRngCreate(&pW->StaRngFile, sizeof pW->StaRngFile, 4096);
		if (pW->hRngFile == NULL) break;
		//----- ドロップＤＩＲ名一時保留バッファ生成 -----------------------------------------------------------//
		pW->hRngDir	 = AjcRngCreate(&pW->StaRngDir , sizeof pW->StaRngDir , 4096);
		if (pW->hRngDir	 == NULL) break;
		//----- チップテキスト表示条件 -------------------------------------------------------------------------//
		pW->fShowAlways = TRUE;
		for (i = 0; i < AJCBAR_MAXITEM; i++) {
			pW->fChkBoxShowAlways[i] = TRUE;
		}
		//----- スケール値表示ウインド生成 ---------------------------------------------------------------------//
		pW->hScale = CreateWindow((WCP)BarClassScale,						// window class name
								L"",										// window caption
								(WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN),	// window style
								0,											// initial x position
								0,											// initial y position
								0,											// initial x size
								0,											// initial y size
								hwnd,										// parent window handle
								(HMENU)BAR_IDC_SCALE,						// window menu handle
								hDllInst,									// program instance handle
								pW);										// creation parameters
		if (pW->hScale == NULL) break;
		AJCTIP_SETFRIENDA(pW->hScale);
		ShowWindow		 (pW->hScale, SW_SHOW);
		//----- 棒グラフイメージ表示ウインド生成 ---------------------------------------------------------------//
		pW->hImage = CreateWindowEx(MAjcGetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_ACCEPTFILES,	// extend style
									(WCP)BarClassImage,							// window class name
									L"",										// window caption
									(WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN),	// window style
									0,											// initial x position
									0,											// initial y position
									0,											// initial x size
									0,											// initial y size
									hwnd,										// parent window handle
									(HMENU)BAR_IDC_IMAGE,						// window menu handle
									hDllInst,									// program instance handle
									pW);										// creation parameters
		if (pW->hImage == NULL) break;
		AJCTIP_SETFRIENDA(pW->hImage);
		ShowWindow		 (pW->hImage, SW_SHOW);
		//----- 棒タイトル名表示ウインド生成 -------------------------------------------------------------------//
		pW->hTtlStr = CreateWindow((WCP)BarClassTtlStr,						// window class name
								L"",										// window caption
								(WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN),	// window style
								0,											// initial x position
								0,											// initial y position
								0,											// initial x size
								0,											// initial y size
								hwnd,										// parent window handle
								(HMENU)BAR_IDC_TTLSTR,						// window menu handle
								hDllInst,									// program instance handle
								pW);										// creation parameters
		if (pW->hTtlStr == NULL) break;
		AJCTIP_SETFRIENDA(pW->hTtlStr);
		ShowWindow		 (pW->hTtlStr, SW_SHOW);
		//----- 棒タイトル表示ウインド生成 ---------------------------------------------------------------------//
		pW->hBarStr = CreateWindow((WCP)BarClassBarStr,						// window class name
								L"",										// window caption
								(pW->style & AJCBARS_NOSCROLLBAR) ?			// window style
										(WS_CHILD | WS_VISIBLE |			  WS_CLIPCHILDREN) :
										(WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_CLIPCHILDREN),
								0,											// initial x position
								0,											// initial y position
								0,											// initial x size
								0,											// initial y size
								hwnd,										// parent window handle
								(HMENU)BAR_IDC_BARSTR,						// window menu handle
								hDllInst,									// program instance handle
								pW);										// creation parameters
		if (pW->hBarStr == NULL) break;
		AJCTIP_SETFRIENDA(pW->hBarStr);
		ShowWindow		 (pW->hBarStr, SW_SHOW);
		//----- 初回プロパティ設定で、レンジ変化通知を行うためのダミー値設定 -----------------------------------//
		pW->prop.RngH = pW->prop.RngL = DBL_MAX;
		//----- プロパティ設定 ---------------------------------------------------------------------------------//
		SetPropByText(pW, PropTxt, &prop);
		if (!BarSetProp(pW, &prop)) break;
		//----- スタイル設定 -----------------------------------------------------------------------------------//
		StyleSetting(pW);
		//----- コントロールの有効状態設定 ---------------------------------------------------------------------//
		EnableCtrls(pW, pW->fEnable = !(pW->style & WS_DISABLED));
		//----- ツールチップテキスト初期化 ---------------------------------------------------------------------//
		//	NOP

		rc = 0;
	} while(0);

	if (rc == -1) {
		if (pW != NULL) {
			if (pW->hPenBorder != NULL) {DeleteObject(pW->hPenBorder); pW->hPenBorder = NULL;}
			if (pW->hScale	   != NULL) {DestroyWindow(pW->hScale);	   pW->hScale	  = NULL;}
			if (pW->hImage	   != NULL) {DestroyWindow(pW->hImage);	   pW->hImage	  = NULL;}
			if (pW->hTtlStr	   != NULL) {DestroyWindow(pW->hTtlStr);   pW->hTtlStr	  = NULL;}
			if (pW->hBarStr	   != NULL) {DestroyWindow(pW->hBarStr);   pW->hBarStr	  = NULL;}
			if (pW->pBuf	   != NULL) {free(pW->pBuf);			   pW->pBuf		  = NULL;}
			free(pW);
			MAjcSetWindowLong(hwnd, 0, (LPARAM)NULL);
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	int				i;

	if (pW != NULL) {
		if (pW->hPenBorder != NULL) {DeleteObject(pW->hPenBorder); pW->hPenBorder = NULL;}
		if (pW->hScale	   != NULL) {DestroyWindow(pW->hScale);	   pW->hScale	  = NULL;}
		if (pW->hImage	   != NULL) {DestroyWindow(pW->hImage);	   pW->hImage	  = NULL;}
		if (pW->hTtlStr	   != NULL) {DestroyWindow(pW->hTtlStr);   pW->hTtlStr	  = NULL;}
		if (pW->hBarStr	   != NULL) {DestroyWindow(pW->hBarStr);   pW->hBarStr	  = NULL;}
		if (pW->pBuf	   != NULL) {free(pW->pBuf);			   pW->pBuf		  = NULL;}
		if (pW->hBmpScale  != NULL) {DeleteObject(pW->hBmpScale ); pW->hBmpScale  = NULL;}
		if (pW->hBmpImage  != NULL) {DeleteObject(pW->hBmpImage ); pW->hBmpImage  = NULL;}
		if (pW->hBmpTtlStr != NULL) {DeleteObject(pW->hBmpTtlStr); pW->hBmpTtlStr = NULL;}
		if (pW->hBmpBarStr != NULL) {DeleteObject(pW->hBmpBarStr); pW->hBmpBarStr = NULL;}
		if (pW->hRngFile   != NULL) {AjcRngDelete(pW->hRngFile);   pW->hRngFile	  = NULL;}
		if (pW->hRngDir	   != NULL) {AjcRngDelete(pW->hRngDir );   pW->hRngDir	  = NULL;}
		//----- ツールチップ -------------------------------//
		if (pW->pToolTipTxt != NULL) {
			free(pW->pToolTipTxt);
			pW->pToolTipTxt = NULL;
		}
		for (i = 0; i < AJCBAR_MAXITEM; i++) {
			if (pW->pChkBoxTool[i] != NULL) {
				free(pW->pChkBoxTool[i]);
				pW->pChkBoxTool[i] = NULL;
			}
		}
		//----- 横線描画情報破棄 ---------------------------//
		for (i = 0; i < MAX_HLINE; i++) {
			if (pW->HLineTbl[i].hPen != NULL) {
				DeleteObject(pW->HLineTbl[i].hPen);
				pW->HLineTbl[i].hPen = NULL;
			}
		}
		//----- タイトル描画オブジェクト破棄 ---------------//
		SubTtlBmpRemv(&pW->TtlInfo);

		//----- インスタンスワーク解放 ---------------------//
		free(pW);
		MAjcSetWindowLong(hwnd, 0, (LPARAM)NULL);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	pW->BackW = LOWORD(lParam);
	pW->BackH = HIWORD(lParam);

	//----- 各ウインドの幅設定 ------------------------------------------------//
	pW->ScaleW = pW->prop.ScaleWidth;
	if (pW->BackW > (pW->ScaleW + 3)) pW->ImageW = pW->BackW - (pW->ScaleW + 3);
	else							  pW->ImageW = 0;
	pW->TtlStrW = pW->ScaleW;
	pW->BarStrW = pW->ImageW;
	//----- 各ウインドの高さ設定 ----------------------------------------------//
	pW->TtlStrH = pW->cyNormal * pW->prop.BarTtlLines + GetSystemMetrics(SM_CYHSCROLL);
	pW->BarStrH = pW->TtlStrH;
	if (pW->BackH > (pW->TtlStrH + 3)) pW->ScaleH = pW->BackH - (pW->TtlStrH + 3);
	else							   pW->ScaleH = 0;
	pW->ImageH = pW->ScaleH;
	//----- 各ウインドを配置 --------------------------------------------------//
	MoveWindow(pW->hScale , 1			   , 1				, pW->ScaleW , pW->ScaleH , FALSE);
	MoveWindow(pW->hImage , pW->ScaleW	+ 2, 1				, pW->ImageW , pW->ImageH , FALSE);
	MoveWindow(pW->hTtlStr, 1			   , pW->ScaleH	 + 2, pW->TtlStrW, pW->TtlStrH, FALSE);
	MoveWindow(pW->hBarStr, pW->TtlStrW + 2, pW->ScaleH	 + 2, pW->BarStrW, pW->BarStrH, FALSE);
	InvalidateRect(hwnd, NULL, FALSE);

	//----- 表示情報再計算 -------------------------------//
	BarSetViewInfoTail(pW);

	//----- スクロール情報設定 ---------------------------//
	BarSetScrollInfo(pW);

	//----- 再描画 ---------------------------------------//
	BarReDraw(pW, FALSE);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_PAINT		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	RECT		r;

	hdc	  = BeginPaint(hwnd, &ps);

	GetClientRect(hwnd, &r);
	BarPaintBackWnd(pW, hdc, r.right - r.left, r.bottom - r.top);

	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXTLENGTH)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	WC				txt[1024];

	MakePropText(pW, txt, AJCTSIZE(txt));

	return wcslen(txt);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_GETTEXT	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	LRESULT			rc;

	if (pW->fFirstGetText) {
		pW->fFirstGetText = FALSE;
		rc = AjcDefWindowProc(hwnd, msg, wParam, lParam);
	}
	else {
		rc = MakePropText(pW, (VOP)lParam, (UI)wParam);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SETTEXT	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	LRESULT		rc;
	AJCBARPROP	prop;

	memcpy(&prop, &pW->prop, sizeof(AJCBARPROP));
	SetPropByText(pW, (WCP)lParam, &prop);
	rc = BarSetProp(pW, &prop);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_STYLECHANGED)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	LPSTYLESTRUCT	p = (LPSTYLESTRUCT)lParam;

	if (wParam == GWL_STYLE) {
		pW->style = p->styleNew;
		StyleSetting(pW);
		InvalidateRect(pW->hBack, NULL, FALSE);
	}
	else if (wParam == GWL_EXSTYLE) {
		MAjcSetWindowLong(pW->hImage, GWL_EXSTYLE, p->styleNew & WS_EX_ACCEPTFILES);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_ENABLE)
{
	PWRK_BARGRAPH		pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	EnableCtrls(pW, pW->fEnable = (BOOL)wParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
enum {
	IDM_COPYBMAP	=	5001,
	IDM_SETRANGE			,
	IDM_SHOWFILTER			,
	IDM_HIDEFILTER			,
	IDM_CLEARDATA			,
};

AJC_WNDPROC(Back, WM_RBUTTONDOWN	)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);
	HMENU			hMenu;
	int				id;
	POINT			pt;
	int				sty;

	//	右クリック通知設定時（親ウインドへ専用メッセージ通知）
	if (pW->fNtcRClk) {
		if (pW->MsgRBDown != 0) {
			PostMessage(GetParent(pW->hBack), pW->MsgRBDown, wParam, lParam);
		}
	}
	//	CTRL/SHIFT 押下時（親ウインドへWM_COMMAND(AJCVTHN_RCLICK)通知）
	else if (wParam & (MK_CONTROL | MK_SHIFT)) {
		pW->NtcRClk.x		= (SW)LOWORD(lParam);
		pW->NtcRClk.y		= (SW)HIWORD(lParam);
		pW->NtcRClk.fShift	= ((wParam & MK_SHIFT  ) != 0);
		pW->NtcRClk.fCtrl	= ((wParam & MK_CONTROL) != 0);
		SendMessage(GetParent(pW->hBack), WM_COMMAND, 
						MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCBARN_RCLICK),
						fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->NtcRClk);
	}
	//	CTRL/SHIFT 未押下時（ポップアップメニュー）
	else {
		sty = (int)MAjcGetWindowLong(pW->hBack, GWL_STYLE);
		hMenu = CreatePopupMenu();
		AppendMenu(hMenu, MFT_STRING, IDM_COPYBMAP	 , LNGSEL(L"コピー(&C)"			  , L"&Copy to clipboard"));
		AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
		AppendMenu(hMenu, MFT_STRING, IDM_SETRANGE	 , LNGSEL(L"レンジ設定(&R)"		  , L"Set &Range"		));
		AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
		if (pW->style & AJCBARS_NOFILTER) AppendMenu(hMenu, MFT_STRING, IDM_SHOWFILTER, LNGSEL(L"フィルタ表示(&F)"	, L"Show &Filter"));
		else							  AppendMenu(hMenu, MFT_STRING, IDM_HIDEFILTER, LNGSEL(L"フィルタ非表示(&F)", L"Hide &Filter"));
		if (pW->nBuf != 0) {
			AppendMenu(hMenu, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hMenu, MFT_STRING, IDM_CLEARDATA	 , LNGSEL(L"データクリアー(&D)"	  , L"Clear all &Data"	));
		}
		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hwnd, NULL);
		DestroyMenu(hMenu);

		switch (id) {
			case IDM_COPYBMAP:
			{						HBITMAP hBm = BarCreateBitmap(pW);
									if (hBm != NULL) {
										OpenClipboard(hwnd);
										EmptyClipboard();
										SetClipboardData(CF_BITMAP, hBm);
										CloseClipboard();
									}
									break;
			}
			case IDM_SETRANGE:		BarCreateDlgSetRange(pW);
									break;
			case IDM_SHOWFILTER:	MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty & ~AJCBARS_NOFILTER);
									break;
			case IDM_HIDEFILTER:	MAjcSetWindowLong(pW->hBack, GWL_STYLE, sty |	AJCBARS_NOFILTER);
									break;

			case IDM_CLEARDATA:		if (MessageBoxW(hwnd, LNGSEL(L"データを全て破棄し、画面をクリアーします。よろしいですか？",
																 L"Discard all data and clear the screen. Is it OK?"), AppName, MB_YESNO) == IDYES) {
										BarPurge(pW);
									}
									break;
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_RBUTTONUP		)
{
	PWRK_BARGRAPH	pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	if (pW->fNtcRClk) {
		if (pW->MsgRBUp != 0) {
			PostMessage(GetParent(hwnd), pW->MsgRBUp, wParam, lParam);
		}
	}

	return 0;
}

//----- レンジ通知要												-------------------------------------------//
AJC_WNDPROC(Back, AJCBARM_NEEDNTC_RANGE)
{
	PWRK_BARGRAPH		pW = (PWRK_BARGRAPH)MAjcGetWindowLong(hwnd, 0);

	pW->NtcRng.RngL = pW->prop.RngL;
	pW->NtcRng.RngH = pW->prop.RngH;
	SendMessage(GetParent(pW->hBack), WM_COMMAND,
					MAKELONG(MAjcGetWindowLong(pW->hBack, GWL_ID), AJCBARN_RANGE),
					fCmdWithHdl ? (LPARAM)pW->hBack : (LPARAM)&pW->NtcRng);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE				)
	AJC_WNDMAP_MSG(Back, WM_DESTROY				)
	AJC_WNDMAP_MSG(Back, WM_SIZE				)
	AJC_WNDMAP_MSG(Back, WM_PAINT				)
	AJC_WNDMAP_MSG(Back, WM_GETTEXTLENGTH		)
	AJC_WNDMAP_MSG(Back, WM_GETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_SETTEXT				)
	AJC_WNDMAP_MSG(Back, WM_STYLECHANGED		)
	AJC_WNDMAP_MSG(Back, WM_ENABLE				)
	AJC_WNDMAP_MSG(Back, WM_RBUTTONDOWN			)
	AJC_WNDMAP_MSG(Back, WM_RBUTTONUP			)

	AJC_WNDMAP_MSG(Back, AJCBARM_NEEDNTC_RANGE	)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	文字列パラメタからプロパティ設定																			//
//																												//
//	引　数	：	pTxt  - パラメタ文字列																			//
//				pProp - 現在のプロパティ値（プロパティ変更時は上書き）											//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPropByText(PWRK_BARGRAPH pW, WCP pTxt, PAJCBARPROP pProp)
{
	WCP			p  = NULL;
	UI			ix;
	int			fr=-1, fg=-1, fb=-1;

	if (wcsnicmp(pTxt, L"P:", 2) == 0) {
		//----- パラメタ解析 ---------------------------------------------------//
		p = pTxt + 2;
		if (p = AjcStrTokW(p, L",")) {
			do {
				while (MAjcIsBlankW(*p)) p++;
				if		(wcsnicmp(p, L"L=" , 2) == 0) pProp->RngL		  = _wtof(p+2);
				else if (wcsnicmp(p, L"H=" , 2) == 0) pProp->RngH		  = _wtof(p+2);
				else if (wcsnicmp(p, L"Z=" , 2) == 0) pProp->Base		  = _wtof(p+2);
				else if (wcsnicmp(p, L"B=" , 2) == 0) pProp->MaxBuf		  = AjcAscToIntW(p+2);
				else if (wcsnicmp(p, L"I=" , 2) == 0) pProp->MaxItem	  = AjcAscToIntW(p+2);
				else if (wcsnicmp(p, L"SW=", 3) == 0) pProp->ScaleWidth   = AjcAscToIntW(p+3);
				else if (wcsnicmp(p, L"BW=", 3) == 0) pProp->BarWidth	  = AjcAscToIntW(p+3);
				else if (wcsnicmp(p, L"MW=", 3) == 0) pProp->MinWidth	  = AjcAscToIntW(p+3);
				else if (wcsnicmp(p, L"TL=", 3) == 0) pProp->BarTtlLines= AjcAscToIntW(p+3);
				else if (wcsnicmp(p, L"BC=", 3) == 0) BarSetBorderColor(pW, (COLORREF)AjcAscToIntW(p+3));
				else if (*p >= L'0' && *p <= L'7' && *(p+1) == L'=') {
					ix = (*p & 15);
					pProp->rgb[ix] = AjcAscToIntW(p + 2);
				}
			} while(p = AjcStrTokW(NULL, L","));
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	プロパティ文字列生成																						//
//																												//
//	引　数	：	pTxt	- パラメタ文字列																		//
//				lTxt	- 文字列長																				//
//																												//
//	戻り値	：	テキスト長																						//
//--------------------------------------------------------------------------------------------------------------//
static	UI		MakePropText	  (PWRK_BARGRAPH pW, WCP pTxt, UI lTxt)
{
	AjcSnPrintFW(pTxt, lTxt, L"P: L=%G, H=%G, Z=%G, B=%u, I=%u, SW=%u, BW=%u, MW=%u, TL=%u, BC=0x%X, "
							 L"0=0x%X, 1=0x%X, 2=0x%X, 3=0x%X, 4=0x%X, 5=0x%X, 6=0x%X, 7=0x%X",
				pW->prop.RngL			,
				pW->prop.RngH			,
				pW->prop.Base			,
				pW->prop.MaxBuf			,
				pW->prop.MaxItem		,
				pW->prop.ScaleWidth		,
				pW->prop.BarWidth		,
				pW->prop.MinWidth		,
				pW->prop.BarTtlLines	,
				pW->RgbBorder			,
				pW->prop.rgb[0]			,
				pW->prop.rgb[1]			,
				pW->prop.rgb[2]			,
				pW->prop.rgb[3]			,
				pW->prop.rgb[4]			,
				pW->prop.rgb[5]			,
				pW->prop.rgb[6]			,
				pW->prop.rgb[7]			);

	return (UI)wcslen(pTxt);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コントロールの有効状態設定																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		EnableCtrls(PWRK_BARGRAPH pW, BOOL fEnable)
{
	UI		i;

	//----- フィルタの有効状態設定 -----------------------------------//
	for (i=0; i<AJCBAR_MAXITEM; i++) {
		EnableWindow(pW->hChkFilt[i], fEnable);
	}
	//----- 再描画 ---------------------------------------------------//
	BarReDraw(pW, FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	スタイル設定																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO		StyleSetting(PWRK_BARGRAPH pW)
{
	//----- フィルタ非表示 -----------------------------------------//
	if (pW->style & AJCBARS_NOFILTER) {
		ShowWindow(pW->hFilter , SW_HIDE);
	}
	//----- 棒表示域の長さ設定 -------------------------------------//
	BarSetBarFieldLen(pW);

	//----- 表示情報設定 -------------------------------------------//
	SetViewInfoCurrent(pW);

	//----- スクロール情報更新 -------------------------------------//
	BarSetScrollInfo(pW);

	//----- 再描画 -------------------------------------------------//
	BarReDraw(pW, FALSE);
}
